/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.cli.CliDriver;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.processors.AddResourceProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.processors.ListResourceProcessor;
import org.apache.hadoop.hive.ql.processors.ResetProcessor;
import org.apache.hadoop.hive.ql.processors.SetProcessor;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Level;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.hive.thriftserver.SparkSQLCLIDriver$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLDriver;
import org.apache.spark.sql.hive.thriftserver.SparkSQLDriver$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLEnv$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0005-uA\u0002\u0010 \u0011\u0003\t3F\u0002\u0004.?!\u0005\u0011E\f\u0005\u0006w\u0005!\t!\u0010\u0005\b}\u0005\u0011\r\u0011\"\u0003@\u0011\u0019A\u0015\u0001)A\u0005\u0001\"9\u0011*\u0001b\u0001\n\u0013Q\u0005BB+\u0002A\u0003%1\nC\u0005W\u0003\u0001\u0007\t\u0019!C\u0005/\"Iq,\u0001a\u0001\u0002\u0004%I\u0001\u0019\u0005\nM\u0006\u0001\r\u0011!Q!\naCqaZ\u0001C\u0002\u00135\u0001\u000e\u0003\u0004m\u0003\u0001\u0006i!\u001b\u0005\u0006[\u0006!\tA\u001c\u0005\u0006_\u0006!\t\u0001\u001d\u0005\u0006m\u0006!\ta\u001e\u0004\u0007[}\u0001\u0011%!\u0004\t\rmzA\u0011AA\u000b\u0011%\tIb\u0004b\u0001\n\u0013\tY\u0002C\u0004\u0002\u001e=\u0001\u000b\u0011B?\t\u0013\u0005}qB1A\u0005\n\u0005\u0005\u0002\u0002CA\u001a\u001f\u0001\u0006I!a\t\t\u0013\u0005UrB1A\u0005\n\u0005]\u0002\u0002CA)\u001f\u0001\u0006I!!\u000f\t\u0011Y|!\u0019!C\u0005\u0003'Bq!!\u0016\u0010A\u0003%\u0001\u0010C\u0005\u0002X=\u0011\r\u0011\"\u0003\u0002Z!A\u0011QM\b!\u0002\u0013\tY\u0006C\u0004\u0002h=!\t%!\u001b\t\r\u0005mt\u0002\"\u0001o\u0011\u001d\tih\u0004C!\u0003\u007f\n\u0011c\u00159be.\u001c\u0016\u000bT\"M\u0013\u0012\u0013\u0018N^3s\u0015\t\u0001\u0013%\u0001\u0007uQJLg\r^:feZ,'O\u0003\u0002#G\u0005!\u0001.\u001b<f\u0015\t!S%A\u0002tc2T!AJ\u0014\u0002\u000bM\u0004\u0018M]6\u000b\u0005!J\u0013AB1qC\u000eDWMC\u0001+\u0003\ry'o\u001a\t\u0003Y\u0005i\u0011a\b\u0002\u0012'B\f'o[*R\u0019\u000ec\u0015\n\u0012:jm\u0016\u00148cA\u00010kA\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t1\u0011I\\=SK\u001a\u0004\"AN\u001d\u000e\u0003]R!\u0001O\u0013\u0002\u0011%tG/\u001a:oC2L!AO\u001c\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001,\u0003\u0019\u0001(o\\7qiV\t\u0001\t\u0005\u0002B\r6\t!I\u0003\u0002D\t\u0006!A.\u00198h\u0015\u0005)\u0015\u0001\u00026bm\u0006L!a\u0012\"\u0003\rM#(/\u001b8h\u0003\u001d\u0001(o\\7qi\u0002\nqbY8oi&tW/\u001a3Qe>l\u0007\u000f^\u000b\u0002\u0017B\u0011Aj\u0015\b\u0003\u001bF\u0003\"AT\u0019\u000e\u0003=S!\u0001\u0015\u001f\u0002\rq\u0012xn\u001c;?\u0013\t\u0011\u0016'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u000fRS!AU\u0019\u0002!\r|g\u000e^5ok\u0016$\u0007K]8naR\u0004\u0013!\u0003;sC:\u001c\bo\u001c:u+\u0005A\u0006CA-^\u001b\u0005Q&B\u0001,\\\u0015\tav%\u0001\u0004uQJLg\r^\u0005\u0003=j\u0013q\u0001V*pG.,G/A\u0007ue\u0006t7\u000f]8si~#S-\u001d\u000b\u0003C\u0012\u0004\"\u0001\r2\n\u0005\r\f$\u0001B+oSRDq!\u001a\u0005\u0002\u0002\u0003\u0007\u0001,A\u0002yIE\n!\u0002\u001e:b]N\u0004xN\u001d;!\u0003a\u0019\u0006+\u0011*L?\"\u000bEiT(Q?B\u0013v\nU0Q%\u00163\u0015\nW\u000b\u0002S>\t!.I\u0001l\u00035\u0019\b/\u0019:l]!\fGm\\8q]\u0005I2\u000bU!S\u0017~C\u0015\tR(P!~\u0003&k\u0014)`!J+e)\u0013-!\u0003QIgn\u001d;bY2\u001c\u0016n\u001a8bY\"\u000bg\u000e\u001a7feR\t\u0011-\u0001\u0003nC&tGCA1r\u0011\u0015\u0011X\u00021\u0001t\u0003\u0011\t'oZ:\u0011\u0007A\"8*\u0003\u0002vc\t)\u0011I\u001d:bs\u0006a\u0011n\u001d*f[>$X-T8eKR\u0011\u0001p\u001f\t\u0003aeL!A_\u0019\u0003\u000f\t{w\u000e\\3b]\")AP\u0004a\u0001{\u0006)1\u000f^1uKB\u0019a0!\u0003\u000e\u0003}TA!!\u0001\u0002\u0004\u0005\u00191\r\\5\u000b\u0007\t\n)AC\u0002\u0002\b\u001d\na\u0001[1e_>\u0004\u0018bAA\u0006\u007f\ny1\t\\5TKN\u001c\u0018n\u001c8Ti\u0006$Xm\u0005\u0003\u0010\u0003\u001f)\u0004c\u0001@\u0002\u0012%\u0019\u00111C@\u0003\u0013\rc\u0017\u000e\u0012:jm\u0016\u0014HCAA\f!\tas\"\u0001\u0007tKN\u001c\u0018n\u001c8Ti\u0006$X-F\u0001~\u00035\u0019Xm]:j_:\u001cF/\u0019;fA\u0005\u0019AjT$\u0016\u0005\u0005\r\u0002\u0003BA\u0013\u0003_i!!a\n\u000b\t\u0005%\u00121F\u0001\bY><w-\u001b8h\u0015\r\ticJ\u0001\bG>lWn\u001c8t\u0013\u0011\t\t$a\n\u0003\u00071{w-\u0001\u0003M\u001f\u001e\u0003\u0013aB2p]N|G.Z\u000b\u0003\u0003s\u0001B!a\u000f\u0002L9!\u0011QHA$\u001b\t\tyD\u0003\u0003\u0002B\u0005\r\u0013aB:fgNLwN\u001c\u0006\u0005\u0003\u000b\n\u0019!\u0001\u0002rY&!\u0011\u0011JA \u00031\u0019Vm]:j_:\u001cF/\u0019;f\u0013\u0011\ti%a\u0014\u0003\u00131{w\rS3ma\u0016\u0014(\u0002BA%\u0003\u007f\t\u0001bY8og>dW\rI\u000b\u0002q\u0006i\u0011n\u001d*f[>$X-T8eK\u0002\nAaY8oMV\u0011\u00111\f\t\u0005\u0003;\n\t'\u0004\u0002\u0002`)!\u0011qKA\u0003\u0013\u0011\t\u0019'a\u0018\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003\u0015\u0019wN\u001c4!\u0003A\u0019X\r\u001e%jm\u00164\u0016M]5bE2,7\u000fF\u0002b\u0003WBq!!\u001c\u001c\u0001\u0004\ty'A\u0007iSZ,g+\u0019:jC\ndWm\u001d\t\u0007\u0003c\n9hS&\u000e\u0005\u0005M$bAA;\t\u0006!Q\u000f^5m\u0013\u0011\tI(a\u001d\u0003\u00075\u000b\u0007/A\nqe&tG/T1ti\u0016\u0014\u0018I\u001c3BaBLE-\u0001\u0006qe>\u001cWm]:D[\u0012$B!!!\u0002\bB\u0019\u0001'a!\n\u0007\u0005\u0015\u0015GA\u0002J]RDa!!#\u001e\u0001\u0004Y\u0015aA2nI\u0002")
public class SparkSQLCLIDriver
extends CliDriver
implements Logging {
    private final CliSessionState sessionState;
    private final Log LOG;
    private final SessionState.LogHelper console;
    private final boolean isRemoteMode;
    private final Configuration conf;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void main(String[] stringArray) {
        SparkSQLCLIDriver$.MODULE$.main(stringArray);
    }

    public static void installSignalHandler() {
        SparkSQLCLIDriver$.MODULE$.installSignalHandler();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private CliSessionState sessionState() {
        return this.sessionState;
    }

    private Log LOG() {
        return this.LOG;
    }

    private SessionState.LogHelper console() {
        return this.console;
    }

    private boolean isRemoteMode() {
        return this.isRemoteMode;
    }

    private Configuration conf() {
        return this.conf;
    }

    public void setHiveVariables(Map<String, String> hiveVariables) {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(hiveVariables).asScala()).foreach((Function1 & Serializable & scala.Serializable)kv -> {
            SparkSQLCLIDriver.$anonfun$setHiveVariables$1(kv);
            return BoxedUnit.UNIT;
        });
    }

    public void printMasterAndAppId() {
        String master = SparkSQLEnv$.MODULE$.sparkContext().master();
        String appId = SparkSQLEnv$.MODULE$.sparkContext().applicationId();
        this.console().printInfo(new StringBuilder(32).append("Spark master: ").append(master).append(", Application Id: ").append(appId).toString());
    }

    public int processCmd(String cmd) {
        int n;
        String cmd_trimmed = cmd.trim();
        String cmd_lower = cmd_trimmed.toLowerCase(Locale.ROOT);
        String[] tokens = cmd_trimmed.split("\\s+");
        String cmd_1 = cmd_trimmed.substring(tokens[0].length()).trim();
        if (cmd_lower.equals("quit") || cmd_lower.equals("exit")) {
            this.sessionState().close();
            System.exit(0);
        }
        if (tokens[0].toLowerCase(Locale.ROOT).equals("source") || cmd_trimmed.startsWith("!") || this.isRemoteMode()) {
            long start = System.currentTimeMillis();
            super.processCmd(cmd);
            long end = System.currentTimeMillis();
            double timeTaken = (double)(end - start) / 1000.0;
            this.console().printInfo(new StringBuilder(20).append("Time taken: ").append(timeTaken).append(" seconds").toString());
            n = 0;
        } else {
            int ret = 0;
            HiveConf hconf = (HiveConf)this.conf();
            CommandProcessor proc = CommandProcessorFactory.get((String[])tokens, (HiveConf)hconf);
            if (proc != null) {
                if (proc instanceof Driver || proc instanceof SetProcessor || proc instanceof AddResourceProcessor || proc instanceof ListResourceProcessor || proc instanceof ResetProcessor) {
                    SparkSQLDriver driver = new SparkSQLDriver(SparkSQLDriver$.MODULE$.$lessinit$greater$default$1());
                    driver.init();
                    PrintStream out = this.sessionState().out;
                    PrintStream err = this.sessionState().err;
                    long start = System.currentTimeMillis();
                    if (this.sessionState().getIsVerbose()) {
                        out.println(cmd);
                    }
                    CommandProcessorResponse rc = driver.run(cmd);
                    long end = System.currentTimeMillis();
                    double timeTaken = (double)(end - start) / 1000.0;
                    ret = rc.getResponseCode();
                    if (ret != 0) {
                        Throwable throwable = rc.getException();
                        if (throwable instanceof AnalysisException) {
                            AnalysisException analysisException = (AnalysisException)throwable;
                            err.println(new StringBuilder(16).append("Error in query: ").append(analysisException.getMessage()).toString());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            err.println(rc.getErrorMessage());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        driver.close();
                        return ret;
                    }
                    ArrayList res = new ArrayList();
                    if (HiveConf.getBoolVar((Configuration)this.conf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CLI_PRINT_HEADER)) {
                        Option$.MODULE$.apply((Object)driver.getSchema().getFieldSchemas()).foreach((Function1 & Serializable & scala.Serializable)fields -> {
                            out.println(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fields).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getName(), Buffer$.MODULE$.canBuildFrom())).mkString("\t"));
                            return BoxedUnit.UNIT;
                        });
                    }
                    IntRef counter = IntRef.create((int)0);
                    try {
                        while (!out.checkError() && driver.getResults(res)) {
                            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(res).asScala()).foreach((Function1 & Serializable & scala.Serializable)l -> {
                                SparkSQLCLIDriver.$anonfun$processCmd$3(counter, out, l);
                                return BoxedUnit.UNIT;
                            });
                            res.clear();
                        }
                    }
                    catch (IOException e) {
                        this.console().printError(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(63).append("Failed with exception ").append(e.getClass().getName()).append(": ").append(e.getMessage()).append("\n                   |").append(StringUtils.stringifyException((Throwable)e)).append("\n                 ").toString())).stripMargin());
                        ret = 1;
                    }
                    int cret = driver.close();
                    if (ret == 0) {
                        ret = cret;
                    }
                    String responseMsg = new StringBuilder(20).append("Time taken: ").append(timeTaken).append(" seconds").toString();
                    if (counter.elem != 0) {
                        responseMsg = new StringBuilder(17).append(responseMsg).append(", Fetched ").append(counter.elem).append(" row(s)").toString();
                    }
                    this.console().printInfo(responseMsg, null);
                    driver.destroy();
                } else {
                    if (this.sessionState().getIsVerbose()) {
                        this.sessionState().out.println(new StringBuilder(1).append(tokens[0]).append(" ").append(cmd_1).toString());
                    }
                    ret = proc.run(cmd_1).getResponseCode();
                }
            }
            n = ret;
        }
        return n;
    }

    public static final /* synthetic */ void $anonfun$setHiveVariables$1(Tuple2 kv) {
        SparkSQLEnv$.MODULE$.sqlContext().conf().setConfString((String)kv._1(), (String)kv._2());
    }

    public static final /* synthetic */ void $anonfun$processCmd$3(IntRef counter$1, PrintStream out$1, String l) {
        ++counter$1.elem;
        out$1.println(l);
    }

    public SparkSQLCLIDriver() {
        Logging.$init$((Logging)this);
        this.sessionState = (CliSessionState)SessionState.get();
        this.LOG = LogFactory.getLog(SparkSQLCLIDriver.class);
        this.console = new SessionState.LogHelper(this.LOG());
        this.isRemoteMode = SparkSQLCLIDriver$.MODULE$.isRemoteMode(this.sessionState());
        Object object = this.conf = this.sessionState() != null ? this.sessionState().getConf() : new Configuration();
        if (!this.isRemoteMode()) {
            SparkSQLEnv$.MODULE$.init();
            if (this.sessionState().getIsSilent()) {
                SparkSQLEnv$.MODULE$.sparkContext().setLogLevel(Level.WARN.toString());
            }
        } else {
            throw new RuntimeException("Remote operations not supported");
        }
    }
}

