/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver.ui;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServer2;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServer2$ExecutionState$;
import org.apache.spark.sql.hive.thriftserver.ui.ThriftServerTab;
import org.apache.spark.ui.SparkUITab;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.WebUIPage;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub!B\b\u0011\u0001Aq\u0002\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\t\u000bA\u0002A\u0011A\u0019\t\u000fQ\u0002!\u0019!C\u0005k!1a\b\u0001Q\u0001\nYBqa\u0010\u0001C\u0002\u0013%\u0001\t\u0003\u0004J\u0001\u0001\u0006I!\u0011\u0005\b\u0015\u0002\u0011\r\u0011\"\u0003L\u0011\u0019\u0011\u0006\u0001)A\u0005\u0019\")1\u000b\u0001C\u0001)\")Q\u000f\u0001C\u0005m\")q\u000f\u0001C\u0005q\"9\u0011q\u0001\u0001\u0005\n\u0005%\u0001bBA\b\u0001\u0011%\u0011\u0011\u0003\u0005\b\u0003K\u0001A\u0011BA\u0014\u0005]!\u0006N]5giN+'O^3s'\u0016\u001c8/[8o!\u0006<WM\u0003\u0002\u0012%\u0005\u0011Q/\u001b\u0006\u0003'Q\tA\u0002\u001e5sS\u001a$8/\u001a:wKJT!!\u0006\f\u0002\t!Lg/\u001a\u0006\u0003/a\t1a]9m\u0015\tI\"$A\u0003ta\u0006\u00148N\u0003\u0002\u001c9\u00051\u0011\r]1dQ\u0016T\u0011!H\u0001\u0004_J<7c\u0001\u0001 IA\u0011\u0001EI\u0007\u0002C)\u0011\u0011\u0003G\u0005\u0003G\u0005\u0012\u0011bV3c+&\u0003\u0016mZ3\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001dB\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005%2#a\u0002'pO\u001eLgnZ\u0001\u0007a\u0006\u0014XM\u001c;\u0004\u0001A\u0011QFL\u0007\u0002!%\u0011q\u0006\u0005\u0002\u0010)\"\u0014\u0018N\u001a;TKJ4XM\u001d+bE\u00061A(\u001b8jiz\"\"AM\u001a\u0011\u00055\u0002\u0001\"\u0002\u0016\u0003\u0001\u0004a\u0013\u0001\u00037jgR,g.\u001a:\u0016\u0003Y\u0002\"aN\u001e\u000f\u0005aJT\"\u0001\n\n\u0005i\u0012\u0012!\u0005%jm\u0016$\u0006N]5giN+'O^3se%\u0011A(\u0010\u0002\u001a\u0011&4X\r\u00165sS\u001a$8+\u001a:wKJ\u0014D*[:uK:,'O\u0003\u0002;%\u0005IA.[:uK:,'\u000fI\u0001\ngR\f'\u000f\u001e+j[\u0016,\u0012!\u0011\t\u0003\u0005\u001ek\u0011a\u0011\u0006\u0003\t\u0016\u000bA!\u001e;jY*\ta)\u0001\u0003kCZ\f\u0017B\u0001%D\u0005\u0011!\u0015\r^3\u0002\u0015M$\u0018M\u001d;US6,\u0007%A\u0005f[B$\u0018pQ3mYV\tA\n\u0005\u0002N!6\taJ\u0003\u0002P\u000b\u0006!A.\u00198h\u0013\t\tfJ\u0001\u0004TiJLgnZ\u0001\u000bK6\u0004H/_\"fY2\u0004\u0013A\u0002:f]\u0012,'\u000f\u0006\u0002VSB\u0019a\u000bY2\u000f\u0005]kfB\u0001-\\\u001b\u0005I&B\u0001.,\u0003\u0019a$o\\8u}%\tA,A\u0003tG\u0006d\u0017-\u0003\u0002_?\u00069\u0001/Y2lC\u001e,'\"\u0001/\n\u0005\u0005\u0014'aA*fc*\u0011al\u0018\t\u0003I\u001el\u0011!\u001a\u0006\u0003M~\u000b1\u0001_7m\u0013\tAWM\u0001\u0003O_\u0012,\u0007\"\u00026\n\u0001\u0004Y\u0017a\u0002:fcV,7\u000f\u001e\t\u0003YNl\u0011!\u001c\u0006\u0003]>\fA\u0001\u001b;ua*\u0011\u0001/]\u0001\bg\u0016\u0014h\u000f\\3u\u0015\u0005\u0011\u0018!\u00026bm\u0006D\u0018B\u0001;n\u0005IAE\u000f\u001e9TKJ4H.\u001a;SKF,Xm\u001d;\u0002%\u001d,g.\u001a:bi\u0016\u0014\u0015m]5d'R\fGo\u001d\u000b\u0002+\u0006)r-\u001a8fe\u0006$XmU)M'R\fGo\u001d+bE2,GcA+zu\")!n\u0003a\u0001W\")1p\u0003a\u0001y\u0006I1/Z:tS>t\u0017\n\u0012\t\u0004{\u0006\raB\u0001@\u0000!\tAv,C\u0002\u0002\u0002}\u000ba\u0001\u0015:fI\u00164\u0017bA)\u0002\u0006)\u0019\u0011\u0011A0\u0002!\u0015\u0014(o\u001c:NKN\u001c\u0018mZ3DK2dGcA+\u0002\f!1\u0011Q\u0002\u0007A\u0002q\fA\"\u001a:s_JlUm]:bO\u0016\fACZ8s[\u0006$H)\u001e:bi&|gn\u00149uS>tGc\u0001?\u0002\u0014!9\u0011QC\u0007A\u0002\u0005]\u0011\u0001C7t\u001fB$\u0018n\u001c8\u0011\r\u0005e\u00111DA\u0010\u001b\u0005y\u0016bAA\u000f?\n1q\n\u001d;j_:\u0004B!!\u0007\u0002\"%\u0019\u00111E0\u0003\t1{gnZ\u0001\rY&\u001cH/\u001b8h)\u0006\u0014G.\u001a\u000b\u0006+\u0006%\u0012q\u0006\u0005\b\u0003Wq\u0001\u0019AA\u0017\u0003\u001dAW-\u00193feN\u00042A\u00161}\u0011\u001d\t\tD\u0004a\u0001\u0003g\tA\u0001Z1uCB!a\u000bYA\u0017\u0001")
public class ThriftServerSessionPage
extends WebUIPage
implements Logging {
    private final ThriftServerTab parent;
    private final HiveThriftServer2.HiveThriftServer2Listener listener;
    private final Date startTime;
    private final String emptyCell;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private HiveThriftServer2.HiveThriftServer2Listener listener() {
        return this.listener;
    }

    private Date startTime() {
        return this.startTime;
    }

    private String emptyCell() {
        return this.emptyCell;
    }

    public Seq<Node> render(HttpServletRequest request) {
        Seq seq;
        String parameterId = UIUtils$.MODULE$.stripXSS(request.getParameter("id"));
        Predef$.MODULE$.require(parameterId != null && new StringOps(Predef$.MODULE$.augmentString(parameterId)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Missing id parameter");
        HiveThriftServer2.HiveThriftServer2Listener hiveThriftServer2Listener = this.listener();
        synchronized (hiveThriftServer2Listener) {
            HiveThriftServer2.SessionInfo sessionStat = (HiveThriftServer2.SessionInfo)this.listener().getSession(parameterId).getOrElse((Function0 & Serializable & scala.Serializable)() -> null);
            Predef$.MODULE$.require(sessionStat != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Invalid sessionID[").append(parameterId).append("]").toString());
            TraversableLike traversableLike = (TraversableLike)this.generateBasicStats().$plus$plus((GenTraversableOnce)new Elem(null, "br", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])), Seq$.MODULE$.canBuildFrom());
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        User "));
            $buf.$amp$plus((Object)sessionStat.userName());
            $buf.$amp$plus((Object)new Text(",\n        IP "));
            $buf.$amp$plus((Object)sessionStat.ip());
            $buf.$amp$plus((Object)new Text(",\n        Session created at "));
            $buf.$amp$plus((Object)UIUtils$.MODULE$.formatDate(sessionStat.startTimestamp()));
            $buf.$amp$plus((Object)new Text(",\n        Total run "));
            $buf.$amp$plus((Object)BoxesRunTime.boxToInteger((int)sessionStat.totalExecution()));
            $buf.$amp$plus((Object)new Text(" SQL\n        "));
            seq = (Seq)((TraversableLike)traversableLike.$plus$plus((GenTraversableOnce)new Elem(null, "h4", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf), Seq$.MODULE$.canBuildFrom())).$plus$plus(this.generateSQLStatsTable(request, sessionStat.sessionId()), Seq$.MODULE$.canBuildFrom());
        }
        Seq content = seq;
        return UIUtils$.MODULE$.headerSparkPage(request, "JDBC/ODBC Session", (Function0 & Serializable & scala.Serializable)() -> content, (SparkUITab)this.parent, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)5000)), UIUtils$.MODULE$.headerSparkPage$default$6(), UIUtils$.MODULE$.headerSparkPage$default$7(), UIUtils$.MODULE$.headerSparkPage$default$8());
    }

    private Seq<Node> generateBasicStats() {
        long timeSinceStart = System.currentTimeMillis() - this.startTime().getTime();
        scala.xml.Null$ $md = scala.xml.Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("unstyled"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("Started at: "));
        $buf2.$amp$plus((Object)new Elem(null, "strong", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text(" "));
        $buf2.$amp$plus((Object)UIUtils$.MODULE$.formatDate(this.startTime()));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "li", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Time since start: "));
        $buf4.$amp$plus((Object)new Elem(null, "strong", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf4.$amp$plus((Object)UIUtils$.MODULE$.formatDurationVerbose(timeSinceStart));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "li", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "ul", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    private Seq<Node> generateSQLStatsTable(HttpServletRequest request, String sessionID) {
        None$ none$;
        Seq executionList = (Seq)this.listener().getExecutionList().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ThriftServerSessionPage.$anonfun$generateSQLStatsTable$1(sessionID, x$1)));
        int numStatement = executionList.size();
        if (numStatement > 0) {
            Seq headerRow = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User", "JobID", "GroupID", "Start Time", "Finish Time", "Duration", "Statement", "State", "Detail"}));
            Seq dataRows = (Seq)((SeqLike)executionList.sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.startTimestamp()), (Ordering)Ordering.Long$.MODULE$)).reverse();
            none$ = new Some((Object)UIUtils$.MODULE$.listingTable(headerRow, (Function1 & Serializable & scala.Serializable)info -> this.generateDataRow$1((HiveThriftServer2.ExecutionInfo)info, request), (Iterable)dataRows, false, (Option)None$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null})), false, UIUtils$.MODULE$.listingTable$default$8()));
        } else {
            none$ = None$.MODULE$;
        }
        None$ table = none$;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("SQL Statistics"));
        Elem elem = new Elem(null, "h5", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n          "));
        scala.xml.Null$ $md = scala.xml.Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("unstyled"), (MetaData)$md);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n            "));
        $buf3.$amp$plus(table.getOrElse((Function0 & Serializable & scala.Serializable)() -> "No statistics have been generated yet."));
        $buf3.$amp$plus((Object)new Text("\n          "));
        $buf2.$amp$plus((Object)new Elem(null, "ul", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeSeq content = (NodeSeq)elem.$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2), NodeSeq$.MODULE$.canBuildFrom());
        return content;
    }

    private Seq<Node> errorMessageCell(String errorMessage) {
        Object object;
        boolean isMultiline = errorMessage.indexOf(10) >= 0;
        String errorSummary = StringEscapeUtils.escapeHtml4((String)(isMultiline ? errorMessage.substring(0, errorMessage.indexOf(10)) : errorMessage));
        if (isMultiline) {
            scala.xml.Null$ $md = scala.xml.Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("expand-details"), (MetaData)$md);
            $md = new UnprefixedAttribute("onclick", (Seq)new Text("this.parentNode.querySelector('.stacktrace-details').classList.toggle('collapsed')"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        + details\n      "));
            Elem elem = new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
            scala.xml.Null$ $md2 = scala.xml.Null$.MODULE$;
            $md2 = new UnprefixedAttribute("class", (Seq)new Text("stacktrace-details collapsed"), (MetaData)$md2);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n        "));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)errorMessage);
            $buf2.$amp$plus((Object)new Elem(null, "pre", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
            $buf2.$amp$plus((Object)new Text("\n      "));
            object = elem.$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2), NodeSeq$.MODULE$.canBuildFrom());
        } else {
            object = "";
        }
        String details = object;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)errorSummary);
        $buf.$amp$plus((Object)details);
        return new Elem(null, "td", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    private String formatDurationOption(Option<Object> msOption) {
        return (String)msOption.map((Function1 & Serializable & scala.Serializable)ms -> UIUtils$.MODULE$.formatDurationVerbose(BoxesRunTime.unboxToLong((Object)ms))).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.emptyCell());
    }

    private Seq<Node> listingTable(Seq<String> headers, Seq<Seq<String>> data2) {
        return UIUtils$.MODULE$.listingTable(headers, (Function1 & Serializable & scala.Serializable)data -> ThriftServerSessionPage.generateDataRow$2(data), data2, true, UIUtils$.MODULE$.listingTable$default$5(), UIUtils$.MODULE$.listingTable$default$6(), UIUtils$.MODULE$.listingTable$default$7(), UIUtils$.MODULE$.listingTable$default$8());
    }

    public static final /* synthetic */ boolean $anonfun$generateSQLStatsTable$1(String sessionID$1, HiveThriftServer2.ExecutionInfo x$1) {
        String string = x$1.sessionId();
        String string2 = sessionID$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final Seq generateDataRow$1(HiveThriftServer2.ExecutionInfo info, HttpServletRequest request$1) {
        ArrayBuffer jobLink = (ArrayBuffer)info.jobId().map((Function1 & Serializable & scala.Serializable)id -> {
            scala.xml.Null$ $md = scala.xml.Null$.MODULE$;
            $md = new UnprefixedAttribute("href", new StringOps(Predef$.MODULE$.augmentString("%s/jobs/job/?id=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UIUtils$.MODULE$.prependBaseUri(request$1, $this.parent.basePath(), UIUtils$.MODULE$.prependBaseUri$default$3()), id})), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n            ["));
            $buf.$amp$plus(id);
            $buf.$amp$plus((Object)new Text("]\n          "));
            return new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        }, ArrayBuffer$.MODULE$.canBuildFrom());
        Enumeration.Value value = info.state();
        Enumeration.Value value2 = HiveThriftServer2$ExecutionState$.MODULE$.FAILED();
        String detail = !(value != null ? !value.equals(value2) : value2 != null) ? info.detail() : info.executePlan();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)info.userName());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n            "));
        $buf3.$amp$plus((Object)jobLink);
        $buf3.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)info.groupId());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)UIUtils$.MODULE$.formatDate(info.startTimestamp()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)UIUtils$.MODULE$.formatDate(info.finishTimestamp()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf.$amp$plus((Object)new Text("\n          "));
        scala.xml.Null$ $md = scala.xml.Null$.MODULE$;
        $md = new UnprefixedAttribute("sorttable_customkey", ((Object)BoxesRunTime.boxToLong((long)info.totalTime())).toString(), (MetaData)$md);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n            "));
        $buf7.$amp$plus((Object)this.formatDurationOption((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)info.totalTime()))));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)info.statement());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)info.state());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus(this.errorMessageCell(detail));
        $buf.$amp$plus((Object)new Text("\n        "));
        return new Elem(null, "tr", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    /*
     * WARNING - void declaration
     */
    private static final Seq generateDataRow$2(Seq data) {
        void var1_1;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text(" "));
        $buf.$amp$plus(data.map((Function1 & Serializable & scala.Serializable)d -> {
            void var1_1;
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus(d);
            return new Elem(null, "td", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var1_1);
        }, Seq$.MODULE$.canBuildFrom()));
        $buf.$amp$plus((Object)new Text(" "));
        return new Elem(null, "tr", (MetaData)scala.xml.Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var1_1);
    }

    public ThriftServerSessionPage(ThriftServerTab parent) {
        this.parent = parent;
        super("session");
        Logging.$init$((Logging)this);
        this.listener = parent.listener();
        this.startTime = Calendar.getInstance().getTime();
        this.emptyCell = "-";
    }
}

