/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver.ui;

import java.io.Serializable;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.hive.thriftserver.ui.ExecutionInfo;
import org.apache.spark.sql.hive.thriftserver.ui.HiveThriftServer2AppStatusStore;
import org.apache.spark.sql.hive.thriftserver.ui.SessionInfo;
import org.apache.spark.sql.hive.thriftserver.ui.SqlStatsPagedTable;
import org.apache.spark.sql.hive.thriftserver.ui.ThriftServerTab;
import org.apache.spark.ui.SparkUITab;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.WebUIPage;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Iterable$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0001E4QAC\u0006\u0001\u0017eA\u0001\"\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\u0006W\u0001!\t\u0001\f\u0005\b_\u0001\u0011\r\u0011\"\u00011\u0011\u0019!\u0004\u0001)A\u0005c!9Q\u0007\u0001b\u0001\n\u00131\u0004BB \u0001A\u0003%q\u0007C\u0003A\u0001\u0011\u0005\u0011\tC\u0003c\u0001\u0011%1\rC\u0003e\u0001\u0011%QMA\fUQJLg\r^*feZ,'oU3tg&|g\u000eU1hK*\u0011A\"D\u0001\u0003k&T!AD\b\u0002\u0019QD'/\u001b4ug\u0016\u0014h/\u001a:\u000b\u0005A\t\u0012\u0001\u00025jm\u0016T!AE\n\u0002\u0007M\fHN\u0003\u0002\u0015+\u0005)1\u000f]1sW*\u0011acF\u0001\u0007CB\f7\r[3\u000b\u0003a\t1a\u001c:h'\r\u0001!d\b\t\u00037ui\u0011\u0001\b\u0006\u0003\u0019MI!A\b\u000f\u0003\u0013]+'-V%QC\u001e,\u0007C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u0014\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u0013\"\u0005\u001daunZ4j]\u001e\fa\u0001]1sK:$8\u0001\u0001\t\u0003Q%j\u0011aC\u0005\u0003U-\u0011q\u0002\u00165sS\u001a$8+\u001a:wKJ$\u0016MY\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00055r\u0003C\u0001\u0015\u0001\u0011\u0015)#\u00011\u0001(\u0003\u0015\u0019Ho\u001c:f+\u0005\t\u0004C\u0001\u00153\u0013\t\u00194BA\u0010ISZ,G\u000b\u001b:jMR\u001cVM\u001d<feJ\n\u0005\u000f]*uCR,8o\u0015;pe\u0016\faa\u001d;pe\u0016\u0004\u0013!C:uCJ$H+[7f+\u00059\u0004C\u0001\u001d>\u001b\u0005I$B\u0001\u001e<\u0003\u0011)H/\u001b7\u000b\u0003q\nAA[1wC&\u0011a(\u000f\u0002\u0005\t\u0006$X-\u0001\u0006ti\u0006\u0014H\u000fV5nK\u0002\naA]3oI\u0016\u0014HC\u0001\"W!\r\u0019U\n\u0015\b\u0003\t*s!!\u0012%\u000e\u0003\u0019S!a\u0012\u0014\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0015!B:dC2\f\u0017BA&M\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011!S\u0005\u0003\u001d>\u00131aU3r\u0015\tYE\n\u0005\u0002R)6\t!K\u0003\u0002T\u0019\u0006\u0019\u00010\u001c7\n\u0005U\u0013&\u0001\u0002(pI\u0016DQaV\u0004A\u0002a\u000bqA]3rk\u0016\u001cH\u000f\u0005\u0002ZA6\t!L\u0003\u0002\\9\u0006!\u0001\u000e\u001e;q\u0015\tif,A\u0004tKJ4H.\u001a;\u000b\u0003}\u000bQA[1wCbL!!\u0019.\u0003%!#H\u000f]*feZdW\r\u001e*fcV,7\u000f^\u0001\u0013O\u0016tWM]1uK\n\u000b7/[2Ti\u0006$8\u000fF\u0001C\u0003U9WM\\3sCR,7+\u0015'Ti\u0006$8\u000fV1cY\u0016$2A\u00114h\u0011\u00159\u0016\u00021\u0001Y\u0011\u0015A\u0017\u00021\u0001j\u0003%\u0019Xm]:j_:LE\t\u0005\u0002k]:\u00111\u000e\u001c\t\u0003\u000b2K!!\u001c'\u0002\rA\u0013X\rZ3g\u0013\ty\u0007O\u0001\u0004TiJLgn\u001a\u0006\u0003[2\u0003")
public class ThriftServerSessionPage
extends WebUIPage
implements Logging {
    private final ThriftServerTab parent;
    private final HiveThriftServer2AppStatusStore store;
    private final Date startTime;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public HiveThriftServer2AppStatusStore store() {
        return this.store;
    }

    private Date startTime() {
        return this.startTime;
    }

    public Seq<Node> render(HttpServletRequest request) {
        Seq seq;
        String parameterId = request.getParameter("id");
        Predef$.MODULE$.require(parameterId != null && new StringOps(Predef$.MODULE$.augmentString(parameterId)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Missing id parameter");
        HiveThriftServer2AppStatusStore hiveThriftServer2AppStatusStore = this.store();
        synchronized (hiveThriftServer2AppStatusStore) {
            SessionInfo sessionStat = (SessionInfo)this.store().getSession(parameterId).getOrElse((Function0 & Serializable & scala.Serializable)() -> null);
            Predef$.MODULE$.require(sessionStat != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Invalid sessionID[").append(parameterId).append("]").toString());
            TraversableLike traversableLike = (TraversableLike)this.generateBasicStats().$plus$plus((GenTraversableOnce)new Elem(null, "br", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])), Seq$.MODULE$.canBuildFrom());
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        User "));
            $buf.$amp$plus((Object)sessionStat.userName());
            $buf.$amp$plus((Object)new Text(",\n        IP "));
            $buf.$amp$plus((Object)sessionStat.ip());
            $buf.$amp$plus((Object)new Text(",\n        Session created at "));
            $buf.$amp$plus((Object)UIUtils$.MODULE$.formatDate(sessionStat.startTimestamp()));
            $buf.$amp$plus((Object)new Text(",\n        Total run "));
            $buf.$amp$plus((Object)BoxesRunTime.boxToLong((long)sessionStat.totalExecution()));
            $buf.$amp$plus((Object)new Text(" SQL\n        "));
            seq = (Seq)((TraversableLike)traversableLike.$plus$plus((GenTraversableOnce)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf), Seq$.MODULE$.canBuildFrom())).$plus$plus(this.generateSQLStatsTable(request, sessionStat.sessionId()), Seq$.MODULE$.canBuildFrom());
        }
        Seq content = seq;
        return UIUtils$.MODULE$.headerSparkPage(request, "JDBC/ODBC Session", (Function0 & Serializable & scala.Serializable)() -> content, (SparkUITab)this.parent, UIUtils$.MODULE$.headerSparkPage$default$5(), UIUtils$.MODULE$.headerSparkPage$default$6(), UIUtils$.MODULE$.headerSparkPage$default$7());
    }

    private Seq<Node> generateBasicStats() {
        long timeSinceStart = System.currentTimeMillis() - this.startTime().getTime();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("unstyled"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("Started at: "));
        $buf2.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text(" "));
        $buf2.$amp$plus((Object)UIUtils$.MODULE$.formatDate(this.startTime()));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Time since start: "));
        $buf4.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf4.$amp$plus((Object)UIUtils$.MODULE$.formatDurationVerbose(timeSinceStart));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "ul", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    private Seq<Node> generateSQLStatsTable(HttpServletRequest request, String sessionID) {
        None$ none$;
        Seq executionList = (Seq)this.store().getExecutionList().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ThriftServerSessionPage.$anonfun$generateSQLStatsTable$1(sessionID, x$1)));
        int numStatement = executionList.size();
        if (numStatement > 0) {
            String sqlTableTag = "sqlsessionstat";
            scala.collection.mutable.Iterable parameterOtherTable = (scala.collection.mutable.Iterable)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.getParameterMap()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ThriftServerSessionPage.$anonfun$generateSQLStatsTable$2(sqlTableTag, x$2))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String name = (String)tuple2._1();
                String[] vals = (String[])tuple2._2();
                String string = new StringBuilder(1).append(name).append("=").append(vals[0]).toString();
                return string;
            }, Iterable$.MODULE$.canBuildFrom());
            String parameterSqlTablePage = request.getParameter(new StringBuilder(5).append(sqlTableTag).append(".page").toString());
            String parameterSqlTableSortColumn = request.getParameter(new StringBuilder(5).append(sqlTableTag).append(".sort").toString());
            String parameterSqlTableSortDesc = request.getParameter(new StringBuilder(5).append(sqlTableTag).append(".desc").toString());
            String parameterSqlPageSize = request.getParameter(new StringBuilder(9).append(sqlTableTag).append(".pageSize").toString());
            int sqlTablePage = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)parameterSqlTablePage).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)ThriftServerSessionPage.$anonfun$generateSQLStatsTable$4(x$3))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1));
            String sqlTableSortColumn = (String)Option$.MODULE$.apply((Object)parameterSqlTableSortColumn).map((Function1 & Serializable & scala.Serializable)sortColumn -> UIUtils$.MODULE$.decodeURLParameter(sortColumn)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "Start Time");
            boolean sqlTableSortDesc = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)parameterSqlTableSortDesc).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ThriftServerSessionPage.$anonfun$generateSQLStatsTable$8(x$4))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                String string = sqlTableSortColumn;
                String string2 = "Start Time";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }));
            int sqlTablePageSize = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)parameterSqlPageSize).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)ThriftServerSessionPage.$anonfun$generateSQLStatsTable$10(x$5))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 100));
            try {
                none$ = new Some(new SqlStatsPagedTable(request, this.parent, (Seq<ExecutionInfo>)executionList, "sqlserver/session", UIUtils$.MODULE$.prependBaseUri(request, this.parent.basePath(), UIUtils$.MODULE$.prependBaseUri$default$3()), (Iterable<String>)parameterOtherTable, sqlTableTag, sqlTablePageSize, sqlTableSortColumn, sqlTableSortDesc).table(sqlTablePage));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                boolean bl = throwable2 instanceof IllegalArgumentException ? true : throwable2 instanceof IndexOutOfBoundsException;
                if (!bl) {
                    throw throwable;
                }
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("class", (Seq)new Text("alert alert-error"), (MetaData)$md);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n            "));
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)new Text("Error while rendering job table:"));
                $buf.$amp$plus((Object)new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
                $buf.$amp$plus((Object)new Text("\n            "));
                NodeBuffer $buf3 = new NodeBuffer();
                $buf3.$amp$plus((Object)new Text("\n              "));
                $buf3.$amp$plus((Object)Utils$.MODULE$.exceptionString(throwable2));
                $buf3.$amp$plus((Object)new Text("\n            "));
                $buf.$amp$plus((Object)new Elem(null, "pre", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
                $buf.$amp$plus((Object)new Text("\n          "));
                Some some = new Some((Object)new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf));
                none$ = some;
            }
        } else {
            none$ = None$.MODULE$;
        }
        None$ table = none$;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-sqlsessionstat',\n                'aggregated-sqlsessionstat')"), (MetaData)$md);
        $md = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-sqlsessionstat collapse-table"), (MetaData)$md);
        $md = new UnprefixedAttribute("id", (Seq)new Text("sqlsessionstat"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n          "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md2);
        $buf4.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf4.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("SQL Statistics"));
        $buf4.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n      "));
        Elem elem = new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-sqlsessionstat collapsible-table"), (MetaData)$md3);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n          "));
        $buf6.$amp$plus(table.getOrElse((Function0 & Serializable & scala.Serializable)() -> "No statistics have been generated yet."));
        $buf6.$amp$plus((Object)new Text("\n        "));
        NodeSeq content = (NodeSeq)elem.$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6), NodeSeq$.MODULE$.canBuildFrom());
        return content;
    }

    public static final /* synthetic */ boolean $anonfun$generateSQLStatsTable$1(String sessionID$1, ExecutionInfo x$1) {
        String string = x$1.sessionId();
        String string2 = sessionID$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$generateSQLStatsTable$2(String sqlTableTag$1, Tuple2 x$2) {
        return ((String)x$2._1()).startsWith(sqlTableTag$1);
    }

    public static final /* synthetic */ int $anonfun$generateSQLStatsTable$4(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$generateSQLStatsTable$8(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toBoolean();
    }

    public static final /* synthetic */ int $anonfun$generateSQLStatsTable$10(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toInt();
    }

    public ThriftServerSessionPage(ThriftServerTab parent) {
        this.parent = parent;
        super("session");
        Logging.$init$((Logging)this);
        this.store = parent.store();
        this.startTime = parent.startTime();
    }
}

