/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver.ui;

import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.spark.sql.hive.thriftserver.ui.ExecutionInfo;
import org.apache.spark.sql.hive.thriftserver.ui.SqlStatsTableDataSource;
import org.apache.spark.sql.hive.thriftserver.ui.SqlStatsTableRow;
import org.apache.spark.sql.hive.thriftserver.ui.ThriftServerTab;
import org.apache.spark.sql.hive.thriftserver.ui.ToolTips$;
import org.apache.spark.ui.PagedTable;
import org.apache.spark.ui.UIUtils$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.xml.Comment;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0001\u00055d!B\u0010!\u0001\u0001r\u0003\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u0011)\u0003!\u0011!Q\u0001\n-C\u0001B\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\t=\u0002\u0011\t\u0011)A\u0005?\"Aq\r\u0001B\u0001B\u0003%q\f\u0003\u0005i\u0001\t\u0005\t\u0015!\u0003`\u0011\u0015I\u0007\u0001\"\u0001k\u0011)\u0011\b\u0001%A\u0001\u0004\u0003\u0006Ia\u001d\u0005\by\u0002\u0011\r\u0011\"\u0003~\u0011\u0019q\b\u0001)A\u0005?\"Aq\u0010\u0001b\u0001\n\u0013\t\t\u0001C\u0004\u0002\u0004\u0001\u0001\u000b\u0011\u0002<\t\u0013\u0005\u0015\u0001A1A\u0005\n\u0005\u001d\u0001bBA\u0005\u0001\u0001\u0006I!\u001f\u0005\n\u0003\u0017\u0001!\u0019!C\u0005\u0003\u001bA\u0001\"!\b\u0001A\u0003%\u0011q\u0002\u0005\t\u0003?\u0001!\u0019!C\u0005{\"9\u0011\u0011\u0005\u0001!\u0002\u0013y\u0006\"CA\u0012\u0001\t\u0007I\u0011IA\u0013\u0011!\ti\u0003\u0001Q\u0001\n\u0005\u001d\u0002BBA\u0018\u0001\u0011\u0005S\u0010\u0003\u0004\u00022\u0001!\t% \u0005\b\u0003g\u0001A\u0011IA\u001b\u0011\u0019\tY\u0004\u0001C!{\"1\u0011Q\b\u0001\u0005BuDa!a\u0010\u0001\t\u0003j\bbBA!\u0001\u0011\u0005\u00131\t\u0005\b\u0003'\u0002A\u0011IA+\u0011\u001d\tY\u0006\u0001C\u0005\u0003;Bq!a\u0019\u0001\t\u0013\t)G\u0001\nTc2\u001cF/\u0019;t!\u0006<W\r\u001a+bE2,'BA\u0011#\u0003\t)\u0018N\u0003\u0002$I\u0005aA\u000f\u001b:jMR\u001cXM\u001d<fe*\u0011QEJ\u0001\u0005Q&4XM\u0003\u0002(Q\u0005\u00191/\u001d7\u000b\u0005%R\u0013!B:qCJ\\'BA\u0016-\u0003\u0019\t\u0007/Y2iK*\tQ&A\u0002pe\u001e\u001c2\u0001A\u00186!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u0019\te.\u001f*fMB\u0019a\u0007\u000f\u001e\u000e\u0003]R!!\t\u0015\n\u0005e:$A\u0003)bO\u0016$G+\u00192mKB\u00111\bP\u0007\u0002A%\u0011Q\b\t\u0002\u0011'Fd7\u000b^1ugR\u000b'\r\\3S_^\fqA]3rk\u0016\u001cHo\u0001\u0001\u0011\u0005\u0005CU\"\u0001\"\u000b\u0005\r#\u0015\u0001\u00025uiBT!!\u0012$\u0002\u000fM,'O\u001e7fi*\tq)A\u0003kCZ\f\u00070\u0003\u0002J\u0005\n\u0011\u0002\n\u001e;q'\u0016\u0014h\u000f\\3u%\u0016\fX/Z:u\u0003\u0019\u0001\u0018M]3oiB\u00111\bT\u0005\u0003\u001b\u0002\u0012q\u0002\u00165sS\u001a$8+\u001a:wKJ$\u0016MY\u0001\u0005I\u0006$\u0018\rE\u0002Q1ns!!\u0015,\u000f\u0005I+V\"A*\u000b\u0005Q{\u0014A\u0002\u001fs_>$h(C\u00013\u0013\t9\u0016'A\u0004qC\u000e\\\u0017mZ3\n\u0005eS&aA*fc*\u0011q+\r\t\u0003wqK!!\u0018\u0011\u0003\u001b\u0015CXmY;uS>t\u0017J\u001c4p\u0003\u001d\u0019XO\u0019)bi\"\u0004\"\u0001\u00193\u000f\u0005\u0005\u0014\u0007C\u0001*2\u0013\t\u0019\u0017'\u0001\u0004Qe\u0016$WMZ\u0005\u0003K\u001a\u0014aa\u0015;sS:<'BA22\u0003!\u0011\u0017m]3QCRD\u0017\u0001E:rYN#\u0018\r^:UC\ndW\rV1h\u0003\u0019a\u0014N\\5u}Q91\u000e\\7o_B\f\bCA\u001e\u0001\u0011\u0015qt\u00011\u0001A\u0011\u0015Qu\u00011\u0001L\u0011\u0015qu\u00011\u0001P\u0011\u0015qv\u00011\u0001`\u0011\u00159w\u00011\u0001`\u0011\u0015Aw\u00011\u0001`\u0003\rAHe\r\t\u0006aQ|f/_\u0005\u0003kF\u0012a\u0001V;qY\u0016\u001c\u0004C\u0001\u0019x\u0013\tA\u0018GA\u0004C_>dW-\u00198\u0011\u0005AR\u0018BA>2\u0005\rIe\u000e^\u0001\u000bg>\u0014HoQ8mk6tW#A0\u0002\u0017M|'\u000f^\"pYVlg\u000eI\u0001\u0005I\u0016\u001c8-F\u0001w\u0003\u0015!Wm]2!\u0003!\u0001\u0018mZ3TSj,W#A=\u0002\u0013A\fw-Z*ju\u0016\u0004\u0013!E3oG>$W\rZ*peR\u001cu\u000e\\;n]V\u0011\u0011q\u0002\t\u0005\u0003#\tY\"\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003\u0011a\u0017M\\4\u000b\u0005\u0005e\u0011\u0001\u00026bm\u0006L1!ZA\n\u0003I)gnY8eK\u0012\u001cvN\u001d;D_2,XN\u001c\u0011\u0002\u001bA\f'/Y7fi\u0016\u0014\b+\u0019;i\u00039\u0001\u0018M]1nKR,'\u000fU1uQ\u0002\n!\u0002Z1uCN{WO]2f+\t\t9\u0003E\u0002<\u0003SI1!a\u000b!\u0005]\u0019\u0016\u000f\\*uCR\u001cH+\u00192mK\u0012\u000bG/Y*pkJ\u001cW-A\u0006eCR\f7k\\;sG\u0016\u0004\u0013a\u0002;bE2,\u0017\nZ\u0001\u000ei\u0006\u0014G.Z\"tg\u000ec\u0017m]:\u0002\u0011A\fw-\u001a'j].$2aXA\u001c\u0011\u0019\tId\u0006a\u0001s\u0006!\u0001/Y4f\u0003E\u0001\u0018mZ3TSj,gi\u001c:n\r&,G\u000eZ\u0001\u0014a\u0006<WMT;nE\u0016\u0014hi\u001c:n\r&,G\u000eZ\u0001\u0011O>\u0014U\u000f\u001e;p]\u001a{'/\u001c)bi\"\fq\u0001[3bI\u0016\u00148/\u0006\u0002\u0002FA!\u0001\u000bWA$!\u0011\tI%a\u0014\u000e\u0005\u0005-#bAA'c\u0005\u0019\u00010\u001c7\n\t\u0005E\u00131\n\u0002\u0005\u001d>$W-A\u0002s_^$B!!\u0012\u0002X!1\u0011\u0011\f\u000fA\u0002i\n\u0001c]9m'R\fGo\u001d+bE2,'k\\<\u0002!\u0015\u0014(o\u001c:NKN\u001c\u0018mZ3DK2dG\u0003BA#\u0003?Ba!!\u0019\u001e\u0001\u0004y\u0016\u0001D3se>\u0014X*Z:tC\u001e,\u0017A\u00026pEV\u0013F\nF\u0003`\u0003O\nI\u0007C\u0003?=\u0001\u0007\u0001\t\u0003\u0004\u0002ly\u0001\raX\u0001\u0006U>\u0014\u0017\n\u001a")
public class SqlStatsPagedTable
implements PagedTable<SqlStatsTableRow> {
    private final HttpServletRequest request;
    private final ThriftServerTab parent;
    private final String sqlStatsTableTag;
    private final /* synthetic */ Tuple3 x$3;
    private final String sortColumn;
    private final boolean desc;
    private final int pageSize;
    private final String encodedSortColumn;
    private final String parameterPath;
    private final SqlStatsTableDataSource dataSource;

    public Seq<Node> table(int page) {
        return PagedTable.table$((PagedTable)this, (int)page);
    }

    public Seq<Node> pageNavigation(int page, int pageSize, int totalPages, String navigationId) {
        return PagedTable.pageNavigation$((PagedTable)this, (int)page, (int)pageSize, (int)totalPages, (String)navigationId);
    }

    public String pageNavigation$default$4() {
        return PagedTable.pageNavigation$default$4$((PagedTable)this);
    }

    public String getParameterOtherTable(HttpServletRequest request, String tableTag) {
        return PagedTable.getParameterOtherTable$((PagedTable)this, (HttpServletRequest)request, (String)tableTag);
    }

    public Tuple3<String, Object, Object> getTableParameters(HttpServletRequest request, String tableTag, String defaultSortColumn) {
        return PagedTable.getTableParameters$((PagedTable)this, (HttpServletRequest)request, (String)tableTag, (String)defaultSortColumn);
    }

    public void isSortColumnValid(Seq<Tuple3<String, Object, Option<String>>> headerInfo, String sortColumn) {
        PagedTable.isSortColumnValid$((PagedTable)this, headerInfo, (String)sortColumn);
    }

    public Seq<Node> headerRow(Seq<Tuple3<String, Object, Option<String>>> headerInfo, boolean desc, int pageSize, String sortColumn, String parameterPath, String tableTag, String headerId) {
        return PagedTable.headerRow$((PagedTable)this, headerInfo, (boolean)desc, (int)pageSize, (String)sortColumn, (String)parameterPath, (String)tableTag, (String)headerId);
    }

    private String sortColumn() {
        return this.sortColumn;
    }

    private boolean desc() {
        return this.desc;
    }

    private int pageSize() {
        return this.pageSize;
    }

    private String encodedSortColumn() {
        return this.encodedSortColumn;
    }

    private String parameterPath() {
        return this.parameterPath;
    }

    public SqlStatsTableDataSource dataSource() {
        return this.dataSource;
    }

    public String tableId() {
        return this.sqlStatsTableTag;
    }

    public String tableCssClass() {
        return "table table-bordered table-sm table-striped table-head-clickable table-cell-width-limited";
    }

    public String pageLink(int page) {
        return new StringBuilder(19).append(this.parameterPath()).append("&").append(this.pageNumberFormField()).append("=").append(page).append("&").append(this.sqlStatsTableTag).append(".sort=").append(this.encodedSortColumn()).append("&").append(this.sqlStatsTableTag).append(".desc=").append(this.desc()).append("&").append(this.pageSizeFormField()).append("=").append(this.pageSize()).append("#").append(this.sqlStatsTableTag).toString();
    }

    public String pageSizeFormField() {
        return new StringBuilder(9).append(this.sqlStatsTableTag).append(".pageSize").toString();
    }

    public String pageNumberFormField() {
        return new StringBuilder(5).append(this.sqlStatsTableTag).append(".page").toString();
    }

    public String goButtonFormPath() {
        return new StringBuilder(15).append(this.parameterPath()).append("&").append(this.sqlStatsTableTag).append(".sort=").append(this.encodedSortColumn()).append("&").append(this.sqlStatsTableTag).append(".desc=").append(this.desc()).append("#").append(this.sqlStatsTableTag).toString();
    }

    public Seq<Node> headers() {
        Seq sqlTableHeadersAndTooltips = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"User", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"JobID", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"GroupID", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Start Time", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Finish Time", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)new Some((Object)ToolTips$.MODULE$.THRIFT_SERVER_FINISH_TIME())), new Tuple3((Object)"Close Time", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)new Some((Object)ToolTips$.MODULE$.THRIFT_SERVER_CLOSE_TIME())), new Tuple3((Object)"Execution Time", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)new Some((Object)ToolTips$.MODULE$.THRIFT_SERVER_EXECUTION())), new Tuple3((Object)"Duration", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)new Some((Object)ToolTips$.MODULE$.THRIFT_SERVER_DURATION())), new Tuple3((Object)"Statement", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"State", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Detail", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$)}));
        this.isSortColumnValid((Seq<Tuple3<String, Object, Option<String>>>)sqlTableHeadersAndTooltips, this.sortColumn());
        return this.headerRow((Seq<Tuple3<String, Object, Option<String>>>)sqlTableHeadersAndTooltips, this.desc(), this.pageSize(), this.sortColumn(), this.parameterPath(), this.sqlStatsTableTag, this.sqlStatsTableTag);
    }

    public Seq<Node> row(SqlStatsTableRow sqlStatsTableRow) {
        ExecutionInfo info = sqlStatsTableRow.executionInfo();
        long startTime = info.startTimestamp();
        long executionTime = sqlStatsTableRow.executionTime();
        long duration = sqlStatsTableRow.duration();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)info.userName());
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus((Object)this.jobLinks$1(sqlStatsTableRow.jobId()));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus((Object)info.groupId());
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)UIUtils$.MODULE$.formatDate(startTime));
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf6.$amp$plus((Object)(info.finishTimestamp() > 0L ? UIUtils$.MODULE$.formatDate(info.finishTimestamp()) : BoxedUnit.UNIT));
        $buf6.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n        "));
        $buf7.$amp$plus((Object)(info.closeTimestamp() > 0L ? UIUtils$.MODULE$.formatDate(info.closeTimestamp()) : BoxedUnit.UNIT));
        $buf7.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Comment(" Returns a human-readable string representing a duration such as \"5 second 35 ms\""));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n        "));
        $buf8.$amp$plus((Object)UIUtils$.MODULE$.formatDurationVerbose(executionTime));
        $buf8.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n        "));
        $buf9.$amp$plus((Object)UIUtils$.MODULE$.formatDurationVerbose(duration));
        $buf9.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("description-input"), (MetaData)$md);
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n          "));
        $buf11.$amp$plus((Object)info.statement());
        $buf11.$amp$plus((Object)new Text("\n        "));
        $buf10.$amp$plus((Object)new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11));
        $buf10.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n        "));
        $buf12.$amp$plus((Object)info.state());
        $buf12.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf12));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus(this.errorMessageCell(sqlStatsTableRow.detail()));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    private Seq<Node> errorMessageCell(String errorMessage) {
        boolean isMultiline = errorMessage.indexOf(10) >= 0;
        String errorSummary = StringEscapeUtils.escapeHtml4((String)(isMultiline ? errorMessage.substring(0, errorMessage.indexOf(10)) : errorMessage));
        Seq details = UIUtils$.MODULE$.detailsUINode(isMultiline, errorMessage);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)errorSummary);
        $buf.$amp$plus((Object)details);
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    private String jobURL(HttpServletRequest request, String jobId) {
        return new StringOps(Predef$.MODULE$.augmentString("%s/jobs/job/?id=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UIUtils$.MODULE$.prependBaseUri(request, this.parent.basePath(), UIUtils$.MODULE$.prependBaseUri$default$3()), jobId}));
    }

    private final Seq jobLinks$1(Seq jobData) {
        return (Seq)jobData.map((Function1 & Serializable & scala.Serializable)jobId -> {
            void var3_3;
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("href", this.jobURL($this.request, (String)jobId), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("["));
            $buf.$amp$plus(jobId);
            $buf.$amp$plus((Object)new Text("]"));
            return new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public SqlStatsPagedTable(HttpServletRequest request, ThriftServerTab parent, Seq<ExecutionInfo> data, String subPath, String basePath, String sqlStatsTableTag) {
        this.request = request;
        this.parent = parent;
        this.sqlStatsTableTag = sqlStatsTableTag;
        PagedTable.$init$((PagedTable)this);
        Tuple3<String, Object, Object> tuple3 = this.getTableParameters(request, sqlStatsTableTag, "Start Time");
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String sortColumn = (String)tuple3._1();
        boolean desc = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
        int pageSize = BoxesRunTime.unboxToInt((Object)tuple3._3());
        this.x$3 = new Tuple3((Object)sortColumn, (Object)BoxesRunTime.boxToBoolean((boolean)desc), (Object)BoxesRunTime.boxToInteger((int)pageSize));
        this.sortColumn = (String)this.x$3._1();
        this.desc = BoxesRunTime.unboxToBoolean((Object)this.x$3._2());
        this.pageSize = BoxesRunTime.unboxToInt((Object)this.x$3._3());
        this.encodedSortColumn = URLEncoder.encode(this.sortColumn(), StandardCharsets.UTF_8.name());
        this.parameterPath = new StringBuilder(3).append(basePath).append("/").append(subPath).append("/?").append(this.getParameterOtherTable(request, sqlStatsTableTag)).toString();
        this.dataSource = new SqlStatsTableDataSource(data, this.pageSize(), this.sortColumn(), this.desc());
    }
}

