/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.AbstractService;
import org.apache.hive.service.Service;
import org.apache.hive.service.ServiceException;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.SparkLogger;
import org.apache.spark.internal.SparkLoggerFactory;

public class CompositeService
extends AbstractService {
    private static final SparkLogger LOG = SparkLoggerFactory.getLogger(CompositeService.class);
    private final List<Service> serviceList = new ArrayList<Service>();

    public CompositeService(String name) {
        super(name);
    }

    public Collection<Service> getServices() {
        return Collections.unmodifiableList(this.serviceList);
    }

    protected synchronized void addService(Service service) {
        this.serviceList.add(service);
    }

    protected synchronized boolean removeService(Service service) {
        return this.serviceList.remove(service);
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        for (Service service : this.serviceList) {
            service.init(hiveConf);
        }
        super.init(hiveConf);
    }

    @Override
    public synchronized void start() {
        int i;
        try {
            int n = this.serviceList.size();
            for (i = 0; i < n; ++i) {
                Service service = this.serviceList.get(i);
                service.start();
            }
            super.start();
        }
        catch (Throwable e) {
            LOG.error("Error starting services {}", e, new MDC[]{MDC.of((LogKey)LogKeys.SERVICE_NAME$.MODULE$, (Object)this.getName())});
            this.stop(i);
            throw new ServiceException("Failed to Start " + this.getName(), e);
        }
    }

    @Override
    public synchronized void stop() {
        if (this.getServiceState() == Service.STATE.STOPPED) {
            return;
        }
        if (this.serviceList.size() > 0) {
            this.stop(this.serviceList.size() - 1);
        }
        super.stop();
    }

    private synchronized void stop(int numOfServicesStarted) {
        for (int i = numOfServicesStarted; i >= 0; --i) {
            Service service = this.serviceList.get(i);
            try {
                service.stop();
                continue;
            }
            catch (Throwable t) {
                LOG.info("Error stopping {}", t, new MDC[]{MDC.of((LogKey)LogKeys.SERVICE_NAME$.MODULE$, (Object)service.getName())});
            }
        }
    }

    public static class CompositeServiceShutdownHook
    implements Runnable {
        private final CompositeService compositeService;

        public CompositeServiceShutdownHook(CompositeService compositeService) {
            this.compositeService = compositeService;
        }

        @Override
        public void run() {
            try {
                this.compositeService.stop();
            }
            catch (Throwable t) {
                LOG.info("Error stopping {}", t, new MDC[]{MDC.of((LogKey)LogKeys.SERVICE_NAME$.MODULE$, (Object)this.compositeService.getName())});
            }
        }
    }
}

