/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hive.service.cli.CLIServiceUtils;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.operation.GetColumnsOperation;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServer2$;
import org.apache.spark.sql.hive.thriftserver.SparkOperation;
import org.apache.spark.sql.internal.NonClosableMutableURLClassLoader;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VarcharType;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005}e!B\n\u0015\u0001Y\u0001\u0003\u0002\u0003\u001c\u0001\u0005\u000b\u0007I\u0011\u0001\u001d\t\u0011u\u0002!\u0011!Q\u0001\neB\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\"A!\u000b\u0001B\u0001B\u0003%Q\t\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003F\u0011!!\u0006A!A!\u0002\u0013)\u0005\"B+\u0001\t\u00031\u0006b\u00020\u0001\u0005\u0004%\ta\u0018\u0005\u0007O\u0002\u0001\u000b\u0011\u00021\t\u000b!\u0004A\u0011I5\t\u000b9\u0004A\u0011B8\t\u000by\u0004A\u0011B@\t\u000f\u0005\r\u0001\u0001\"\u0003\u0002\u0006!9\u0011\u0011\u0002\u0001\u0005\n\u0005-\u0001bBA\u0010\u0001\u0011%\u0011\u0011\u0005\u0005\b\u0003\u000f\u0002A\u0011BA%\u00111\ty\t\u0001I\u0001\u0002\u0003\u0005I\u0011AAI\u0005a\u0019\u0006/\u0019:l\u000f\u0016$8i\u001c7v[:\u001cx\n]3sCRLwN\u001c\u0006\u0003+Y\tA\u0002\u001e5sS\u001a$8/\u001a:wKJT!a\u0006\r\u0002\t!Lg/\u001a\u0006\u00033i\t1a]9m\u0015\tYB$A\u0003ta\u0006\u00148N\u0003\u0002\u001e=\u00051\u0011\r]1dQ\u0016T\u0011aH\u0001\u0004_J<7\u0003\u0002\u0001\"YA\u0002\"A\t\u0016\u000e\u0003\rR!\u0001J\u0013\u0002\u0013=\u0004XM]1uS>t'B\u0001\u0014(\u0003\r\u0019G.\u001b\u0006\u0003Q%\nqa]3sm&\u001cWM\u0003\u0002\u00189%\u00111f\t\u0002\u0014\u000f\u0016$8i\u001c7v[:\u001cx\n]3sCRLwN\u001c\t\u0003[9j\u0011\u0001F\u0005\u0003_Q\u0011ab\u00159be.|\u0005/\u001a:bi&|g\u000e\u0005\u00022i5\t!G\u0003\u000245\u0005A\u0011N\u001c;fe:\fG.\u0003\u00026e\t9Aj\\4hS:<\u0017aB:fgNLwN\\\u0002\u0001+\u0005I\u0004C\u0001\u001e<\u001b\u0005A\u0012B\u0001\u001f\u0019\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003!\u0019Xm]:j_:\u0004\u0013!\u00049be\u0016tGoU3tg&|g\u000e\u0005\u0002A\u00056\t\u0011I\u0003\u00027K%\u00111)\u0011\u0002\f\u0011&4XmU3tg&|g.A\u0006dCR\fGn\\4OC6,\u0007C\u0001$P\u001d\t9U\n\u0005\u0002I\u00176\t\u0011J\u0003\u0002Ko\u00051AH]8pizR\u0011\u0001T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001d.\u000ba\u0001\u0015:fI\u00164\u0017B\u0001)R\u0005\u0019\u0019FO]5oO*\u0011ajS\u0001\u000bg\u000eDW-\\1OC6,\u0017!\u0003;bE2,g*Y7f\u0003)\u0019w\u000e\\;n]:\u000bW.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f]C\u0016LW.];B\u0011Q\u0006\u0001\u0005\u0006m!\u0001\r!\u000f\u0005\u0006}!\u0001\ra\u0010\u0005\u0006\t\"\u0001\r!\u0012\u0005\u0006%\"\u0001\r!\u0012\u0005\u0006'\"\u0001\r!\u0012\u0005\u0006)\"\u0001\r!R\u0001\bG\u0006$\u0018\r\\8h+\u0005\u0001\u0007CA1f\u001b\u0005\u0011'B\u00010d\u0015\t!\u0007$\u0001\u0005dCR\fG._:u\u0013\t1'M\u0001\bTKN\u001c\u0018n\u001c8DCR\fGn\\4\u0002\u0011\r\fG/\u00197pO\u0002\n1B];o\u0013:$XM\u001d8bYR\t!\u000e\u0005\u0002lY6\t1*\u0003\u0002n\u0017\n!QK\\5u\u000359W\r^\"pYVlgnU5{KR\u0011\u0001O\u001e\t\u0004WF\u001c\u0018B\u0001:L\u0005\u0019y\u0005\u000f^5p]B\u00111\u000e^\u0005\u0003k.\u00131!\u00138u\u0011\u00159H\u00021\u0001y\u0003\r!\u0018\u0010\u001d\t\u0003srl\u0011A\u001f\u0006\u0003wb\tQ\u0001^=qKNL!! >\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f\u0001cZ3u\t\u0016\u001c\u0017.\\1m\t&<\u0017\u000e^:\u0015\u0007A\f\t\u0001C\u0003x\u001b\u0001\u0007\u00010A\bhKRtU/\u001c)sK\u000e\u0014\u0016\rZ5y)\r\u0001\u0018q\u0001\u0005\u0006o:\u0001\r\u0001_\u0001\u000ei>T\u0015M^1T#2#\u0016\u0010]3\u0015\t\u00055\u0011Q\u0004\t\u0005\u0003\u001f\tI\"\u0004\u0002\u0002\u0012)!\u00111CA\u000b\u0003\u0011a\u0017M\\4\u000b\u0005\u0005]\u0011\u0001\u00026bm\u0006LA!a\u0007\u0002\u0012\t9\u0011J\u001c;fO\u0016\u0014\b\"B<\u0010\u0001\u0004A\u0018aC1eIR{'k\\<TKR$\u0012B[A\u0012\u0003o\tY$!\u0010\t\u000f\u0005\u0015\u0002\u00031\u0001\u0002(\u0005i1m\u001c7v[:\u0004\u0016\r\u001e;fe:\u0004B!!\u000b\u000245\u0011\u00111\u0006\u0006\u0005\u0003[\ty#A\u0003sK\u001e,\u0007P\u0003\u0003\u00022\u0005U\u0011\u0001B;uS2LA!!\u000e\u0002,\t9\u0001+\u0019;uKJt\u0007BBA\u001d!\u0001\u0007Q)\u0001\u0004eE:\u000bW.\u001a\u0005\u0006'B\u0001\r!\u0012\u0005\b\u0003\u007f\u0001\u0002\u0019AA!\u0003\u0019\u00198\r[3nCB\u0019\u00110a\u0011\n\u0007\u0005\u0015#P\u0001\u0006TiJ,8\r\u001e+za\u0016\f1bZ3u!JLgo\u00142kgR!\u00111JA>!\u0019\ti%a\u0016\u0002^9!\u0011qJA*\u001d\rA\u0015\u0011K\u0005\u0002\u0019&\u0019\u0011QK&\u0002\u000fA\f7m[1hK&!\u0011\u0011LA.\u0005\r\u0019V-\u001d\u0006\u0004\u0003+Z\u0005\u0003BA0\u0003oj!!!\u0019\u000b\t\u0005\r\u0014QM\u0001\u0007a2,x-\u001b8\u000b\t\u0005\u001d\u0014\u0011N\u0001\u000eCV$\bn\u001c:ju\u0006$\u0018n\u001c8\u000b\t\u0005-\u0014QN\u0001\tg\u0016\u001cWO]5us*!\u0011qNA9\u0003\t\tHNC\u0002\u0018\u0003gR1!!\u001e\u001d\u0003\u0019A\u0017\rZ8pa&!\u0011\u0011PA1\u0005MA\u0015N^3Qe&4\u0018\u000e\\3hK>\u0013'.Z2u\u0011\u001d\ti(\u0005a\u0001\u0003\u007f\nq\u0001\u001a23)\u0006\u00147\u000f\u0005\u0004G\u0003\u0003+\u0015QQ\u0005\u0004\u0003\u0007\u000b&aA'baB1\u0011QJA,\u0003\u000f\u0003B!!#\u0002\f6\t1-C\u0002\u0002\u000e\u000e\u0014q\u0002V1cY\u0016LE-\u001a8uS\u001aLWM]\u0001\u0011aJ|G/Z2uK\u0012$#o\\<TKR$B!a%\u0002\u001cB!\u0011QSAL\u001b\u0005)\u0013bAAMK\t1!k\\<TKRD\u0001\"!(\u0013\u0003\u0003\u0005\raV\u0001\u0004q\u0012\n\u0004")
public class SparkGetColumnsOperation
extends GetColumnsOperation
implements SparkOperation {
    private final SparkSession session;
    private final HiveSession parentSession;
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final String columnName;
    private final SessionCatalog catalog;
    private String statementId;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$thriftserver$SparkOperation$$super$run() {
        super.run();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$thriftserver$SparkOperation$$super$close() {
        super.close();
    }

    @Override
    public /* synthetic */ OperationState org$apache$spark$sql$hive$thriftserver$SparkOperation$$super$setState(OperationState newState) {
        return super.setState(newState);
    }

    @Override
    public void cleanup() {
        SparkOperation.cleanup$(this);
    }

    @Override
    public void run() {
        SparkOperation.run$(this);
    }

    @Override
    public void close() {
        SparkOperation.close$(this);
    }

    @Override
    public <T> T withLocalProperties(Function0<T> f) {
        return (T)SparkOperation.withLocalProperties$(this, f);
    }

    @Override
    public String tableTypeString(CatalogTableType tableType) {
        return SparkOperation.tableTypeString$(this, tableType);
    }

    @Override
    public PartialFunction<Throwable, BoxedUnit> onError() {
        return SparkOperation.onError$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public String statementId() {
        return this.statementId;
    }

    @Override
    public void statementId_$eq(String x$1) {
        this.statementId = x$1;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public /* synthetic */ RowSet protected$rowSet(SparkGetColumnsOperation x$1) {
        return x$1.rowSet;
    }

    @Override
    public SparkSession session() {
        return this.session;
    }

    public SessionCatalog catalog() {
        return this.catalog;
    }

    @Override
    public void runInternal() {
        Object object;
        String cmdStr = "catalog : " + this.catalogName + ", schemaPattern : " + this.schemaName + ", tablePattern : " + this.tableName;
        String logMsg = "Listing columns '" + cmdStr + ", columnName : " + this.columnName + "'";
        String catalogNameStr = this.catalogName == null ? "null" : this.catalogName;
        String schemaNameStr = this.schemaName == null ? "null" : this.schemaName;
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Listing columns 'catalog : ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CATALOG_NAME$.MODULE$, (Object)catalogNameStr)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"schemaPattern : ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DATABASE_NAME$.MODULE$, (Object)schemaNameStr)}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tablePattern : ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.TABLE_NAME$.MODULE$, (Object)$this.tableName)}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"columnName : ", "' "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.COLUMN_NAME$.MODULE$, (Object)$this.columnName)}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"with ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.STATEMENT_ID$.MODULE$, (Object)this.statementId())})))));
        this.setState(OperationState.RUNNING);
        NonClosableMutableURLClassLoader executionHiveClassLoader = this.session().sharedState().jarClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)executionHiveClassLoader);
        HiveThriftServer2$.MODULE$.eventManager().onStatementStart(this.statementId(), this.parentSession.getSessionHandle().getSessionId().toString(), logMsg, this.statementId(), this.parentSession.getUsername());
        String schemaPattern = this.convertSchemaPattern(this.schemaName);
        String tablePattern = this.convertIdentifierPattern(this.tableName, true);
        ObjectRef columnPattern = ObjectRef.create(null);
        if (this.columnName != null) {
            columnPattern.elem = Pattern.compile(this.convertIdentifierPattern(this.columnName, false));
        }
        scala.collection.immutable.Map db2Tabs = ((IterableOnceOps)this.catalog().listDatabases(schemaPattern).map((Function1 & Serializable)dbName -> new Tuple2(dbName, (Object)this.catalog().listTables(dbName, tablePattern, false)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (this.isAuthV2Enabled()) {
            List privObjs = CollectionConverters$.MODULE$.SeqHasAsJava(this.getPrivObjs((scala.collection.immutable.Map<String, Seq<TableIdentifier>>)db2Tabs)).asJava();
            this.authorizeMetaGets(HiveOperationType.GET_COLUMNS, privObjs, cmdStr);
        }
        try {
            db2Tabs.foreach((Function1 & Serializable)x0$1 -> {
                SparkGetColumnsOperation.$anonfun$runInternal$3(this, columnPattern, x0$1);
                return BoxedUnit.UNIT;
            });
            String globalTempViewDb = this.catalog().globalTempDatabase();
            Pattern databasePattern = Pattern.compile(CLIServiceUtils.patternToRegex(this.schemaName));
            if (databasePattern.matcher(globalTempViewDb).matches()) {
                this.catalog().globalTempViewManager().listViewNames(tablePattern).foreach((Function1 & Serializable)globalTempView -> {
                    SparkGetColumnsOperation.$anonfun$runInternal$5(this, columnPattern, globalTempViewDb, globalTempView);
                    return BoxedUnit.UNIT;
                });
            }
            this.catalog().listLocalTempViews(tablePattern).foreach((Function1 & Serializable)localTempView -> {
                SparkGetColumnsOperation.$anonfun$runInternal$8(this, columnPattern, localTempView);
                return BoxedUnit.UNIT;
            });
            object = this.setState(OperationState.FINISHED);
        }
        catch (Throwable x$7) {
            PartialFunction<Throwable, BoxedUnit> catchExpr$1 = this.onError();
            if (catchExpr$1.isDefinedAt((Object)x$7)) {
                object = catchExpr$1.apply((Object)x$7);
            }
            throw x$7;
        }
        HiveThriftServer2$.MODULE$.eventManager().onStatementFinish(this.statementId());
    }

    private Option<Object> getColumnSize(DataType typ) {
        DataType dataType = typ;
        if (BooleanType$.MODULE$.equals(dataType) ? true : (dataType instanceof NumericType ? true : (DateType$.MODULE$.equals(dataType) ? true : (TimestampType$.MODULE$.equals(dataType) ? true : (TimestampNTZType$.MODULE$.equals(dataType) ? true : (CalendarIntervalType$.MODULE$.equals(dataType) ? true : (NullType$.MODULE$.equals(dataType) ? true : dataType instanceof AnsiIntervalType))))))) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)dataType.defaultSize()));
        }
        if (dataType instanceof CharType) {
            CharType charType = (CharType)dataType;
            int n = charType.length();
            return new Some((Object)BoxesRunTime.boxToInteger((int)n));
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            Option[] sizeArr = (Option[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)f -> this.getColumnSize(f.dataType()), ClassTag$.MODULE$.apply(Option.class));
            if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])sizeArr), (Object)None$.MODULE$)) {
                return None$.MODULE$;
            }
            return new Some(Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])sizeArr), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)SparkGetColumnsOperation.$anonfun$getColumnSize$2(x$3)), (ClassTag)ClassTag$.MODULE$.Int())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        }
        return None$.MODULE$;
    }

    private Option<Object> getDecimalDigits(DataType typ) {
        DataType dataType = typ;
        if (BooleanType$.MODULE$.equals(dataType) ? true : dataType instanceof IntegerType) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)0));
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)7));
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)15));
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return new Some((Object)BoxesRunTime.boxToInteger((int)decimalType.scale()));
        }
        if (TimestampType$.MODULE$.equals(dataType) ? true : TimestampNTZType$.MODULE$.equals(dataType)) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)6));
        }
        return None$.MODULE$;
    }

    private Option<Object> getNumPrecRadix(DataType typ) {
        DataType dataType = typ;
        if (dataType instanceof NumericType) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)10));
        }
        return None$.MODULE$;
    }

    private Integer toJavaSQLType(DataType typ) {
        DataType dataType = typ;
        if (NullType$.MODULE$.equals(dataType)) {
            return Predef$.MODULE$.int2Integer(0);
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return Predef$.MODULE$.int2Integer(16);
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return Predef$.MODULE$.int2Integer(-6);
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return Predef$.MODULE$.int2Integer(5);
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return Predef$.MODULE$.int2Integer(4);
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return Predef$.MODULE$.int2Integer(-5);
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return Predef$.MODULE$.int2Integer(6);
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return Predef$.MODULE$.int2Integer(8);
        }
        if (dataType instanceof DecimalType) {
            return Predef$.MODULE$.int2Integer(3);
        }
        if (dataType instanceof VarcharType) {
            return Predef$.MODULE$.int2Integer(12);
        }
        if (dataType instanceof CharType) {
            return Predef$.MODULE$.int2Integer(1);
        }
        if (dataType instanceof StringType) {
            return Predef$.MODULE$.int2Integer(12);
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return Predef$.MODULE$.int2Integer(-2);
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return Predef$.MODULE$.int2Integer(91);
        }
        if (TimestampType$.MODULE$.equals(dataType) ? true : TimestampNTZType$.MODULE$.equals(dataType)) {
            return Predef$.MODULE$.int2Integer(93);
        }
        if (dataType instanceof ArrayType) {
            return Predef$.MODULE$.int2Integer(2003);
        }
        if (dataType instanceof MapType) {
            return Predef$.MODULE$.int2Integer(2000);
        }
        if (dataType instanceof StructType) {
            return Predef$.MODULE$.int2Integer(2002);
        }
        if (dataType instanceof CalendarIntervalType ? true : dataType instanceof AnsiIntervalType) {
            return Predef$.MODULE$.int2Integer(1111);
        }
        throw new IllegalArgumentException("Unrecognized type name: " + typ.sql());
    }

    private void addToRowSet(Pattern columnPattern, String dbName, String tableName, StructType schema) {
        ((IterableOnceOps)schema.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StructField column = (StructField)tuple2._1();
                int pos = tuple2._2$mcI$sp();
                if (columnPattern != null && !columnPattern.matcher(column.name()).matches()) {
                    return BoxedUnit.UNIT;
                }
                Object[] rowData = new Object[]{null, dbName, tableName, column.name(), this.toJavaSQLType(column.dataType()), column.dataType().sql(), this.getColumnSize(column.dataType()).map((Function1 & Serializable)x$4 -> SparkGetColumnsOperation.$anonfun$addToRowSet$2(BoxesRunTime.unboxToInt((Object)x$4))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), null, this.getDecimalDigits(column.dataType()).map((Function1 & Serializable)x$5 -> SparkGetColumnsOperation.$anonfun$addToRowSet$3(BoxesRunTime.unboxToInt((Object)x$5))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), this.getNumPrecRadix(column.dataType()).map((Function1 & Serializable)x$6 -> SparkGetColumnsOperation.$anonfun$addToRowSet$4(BoxesRunTime.unboxToInt((Object)x$6))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), column.nullable() ? BoxesRunTime.boxToInteger((int)1) : BoxesRunTime.boxToInteger((int)0), column.getComment().getOrElse((Function0 & Serializable)() -> ""), null, null, null, null, BoxesRunTime.boxToInteger((int)pos), "YES", null, null, null, null, "NO"};
                return this.protected$rowSet(this).addRow(rowData);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Seq<HivePrivilegeObject> getPrivObjs(scala.collection.immutable.Map<String, Seq<TableIdentifier>> db2Tabs) {
        return (Seq)db2Tabs.foldLeft((Object)package$.MODULE$.Seq().empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Seq i = (Seq)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    String dbName = (String)tuple22._1();
                    Seq tables = (Seq)tuple22._2();
                    return (Seq)i.$plus$plus((IterableOnce)tables.map((Function1 & Serializable)tableId -> new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW, dbName, tableId.table())));
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static final /* synthetic */ void $anonfun$runInternal$3(SparkGetColumnsOperation $this, ObjectRef columnPattern$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String dbName = (String)tuple2._1();
            Seq tables = (Seq)tuple2._2();
            $this.catalog().getTablesByName(tables).foreach((Function1 & Serializable)catalogTable -> {
                $this.addToRowSet((Pattern)columnPattern$1.elem, dbName, catalogTable.identifier().table(), catalogTable.schema());
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$runInternal$5(SparkGetColumnsOperation $this, ObjectRef columnPattern$1, String globalTempViewDb$1, String globalTempView) {
        $this.catalog().getRawGlobalTempView(globalTempView).map((Function1 & Serializable)x$1 -> x$1.tableMeta().schema()).foreach((Function1 & Serializable)schema -> {
            $this.addToRowSet((Pattern)columnPattern$1.elem, globalTempViewDb$1, globalTempView, schema);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$runInternal$8(SparkGetColumnsOperation $this, ObjectRef columnPattern$1, TableIdentifier localTempView) {
        $this.catalog().getRawTempView(localTempView.table()).map((Function1 & Serializable)x$2 -> x$2.tableMeta().schema()).foreach((Function1 & Serializable)schema -> {
            $this.addToRowSet((Pattern)columnPattern$1.elem, null, localTempView.table(), schema);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ int $anonfun$getColumnSize$2(Option x$3) {
        return BoxesRunTime.unboxToInt((Object)x$3.get());
    }

    public static final /* synthetic */ Object $anonfun$addToRowSet$2(int x$4) {
        return BoxesRunTime.boxToInteger((int)x$4);
    }

    public static final /* synthetic */ Object $anonfun$addToRowSet$3(int x$5) {
        return BoxesRunTime.boxToInteger((int)x$5);
    }

    public static final /* synthetic */ Object $anonfun$addToRowSet$4(int x$6) {
        return BoxesRunTime.boxToInteger((int)x$6);
    }

    public SparkGetColumnsOperation(SparkSession session, HiveSession parentSession, String catalogName, String schemaName, String tableName, String columnName) {
        this.session = session;
        this.parentSession = parentSession;
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.columnName = columnName;
        super(parentSession, catalogName, schemaName, tableName, columnName);
        Logging.$init$((Logging)this);
        SparkOperation.$init$(this);
        this.catalog = session.sessionState().catalog();
    }
}

