/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.SQLConf;
import org.apache.spark.sql.SQLConf$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SchemaRDD;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.EliminateAnalysisOperators$;
import org.apache.spark.sql.catalyst.analysis.OverrideCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Row;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.NativeCommand;
import org.apache.spark.sql.catalyst.plans.logical.SetCommand;
import org.apache.spark.sql.catalyst.types.DataType;
import org.apache.spark.sql.execution.Command;
import org.apache.spark.sql.execution.QueryExecutionException;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.hive.HiveContext$;
import org.apache.spark.sql.hive.HiveFunctionRegistry;
import org.apache.spark.sql.hive.HiveMetastoreCatalog;
import org.apache.spark.sql.hive.HiveQl$;
import org.apache.spark.sql.hive.HiveShim$;
import org.apache.spark.sql.hive.MetastoreRelation;
import org.apache.spark.sql.hive.execution.DescribeHiveTableCommand;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\r5h\u0001B\u0001\u0003\u00015\u00111\u0002S5wK\u000e{g\u000e^3yi*\u00111\u0001B\u0001\u0005Q&4XM\u0003\u0002\u0006\r\u0005\u00191/\u001d7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\t%\u0011\u0011\u0003\u0002\u0002\u000b'Fc5i\u001c8uKb$\b\"C\n\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000b\u0019\u0003\t\u00198\r\u0005\u0002\u0016-5\ta!\u0003\u0002\u0018\r\ta1\u000b]1sW\u000e{g\u000e^3yi&\u0011\u0011\u0004E\u0001\rgB\f'o[\"p]R,\u0007\u0010\u001e\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005uy\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001\"B\n\u001b\u0001\u0004!\u0002BB\u0011\u0001\t\u00032!%A\u0004eS\u0006dWm\u0019;\u0016\u0003\r\u0002\"\u0001\n\u0016\u000f\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0002\rA\u0013X\rZ3g\u0013\tYCF\u0001\u0004TiJLgn\u001a\u0006\u0003S\u0019BaA\f\u0001\u0005\u0002\u0019y\u0013aF2p]Z,'\u000f^'fi\u0006\u001cHo\u001c:f!\u0006\u0014\u0018/^3u+\u0005\u0001\u0004CA\u00132\u0013\t\u0011dEA\u0004C_>dW-\u00198\t\rQ\u0002A\u0011\u000b\u00036\u0003-)\u00070Z2vi\u0016\u0004F.\u00198\u0015\u0005Y\u0002\u0006CA\u001c9\u001b\u0005\u0001aAB\u001d\u0001\u0003#!!H\u0001\bRk\u0016\u0014\u00180\u0012=fGV$\u0018n\u001c8\u0014\u0005aZ\u0004CA\u001c=\u0013\tI\u0004\u0003C\u0003\u001cq\u0011\u0005a\bF\u00017\u0011\u0015\u0001\u0005\b\"\u0001B\u00031\u0019HO]5oOJ+7/\u001e7u)\u0005\u0011\u0005cA\"LG9\u0011A)\u0013\b\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000f2\ta\u0001\u0010:p_Rt\u0014\"A\u0014\n\u0005)3\u0013a\u00029bG.\fw-Z\u0005\u0003\u00196\u00131aU3r\u0015\tQe\u0005C\u0003Pq\u0011\u0005#%\u0001\u0007tS6\u0004H.Z*ue&tw\rC\u0003Rg\u0001\u0007!+\u0001\u0003qY\u0006t\u0007CA*[\u001b\u0005!&BA+W\u0003\u001dawnZ5dC2T!a\u0016-\u0002\u000bAd\u0017M\\:\u000b\u0005e#\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005m#&a\u0003'pO&\u001c\u0017\r\u001c)mC:DQ!\u0002\u0001\u0005Bu#\"AX1\u0011\u0005=y\u0016B\u00011\u0005\u0005%\u00196\r[3nCJ#E\tC\u0003c9\u0002\u00071%A\u0004tc2$V\r\u001f;\t\u000b\u0011\u0004A\u0011A3\u0002\r!Lg/Z9m)\tqf\rC\u0003hG\u0002\u00071%\u0001\u0005ic2\fV/\u001a:zQ\u0015\u0019\u0017\u000e\\A9!\t)#.\u0003\u0002lM\tQA-\u001a9sK\u000e\fG/\u001a32\u000b}iG/a\u0001\u0011\u00059\u001cX\"A8\u000b\u0005A\f\u0018\u0001\u00027b]\u001eT\u0011A]\u0001\u0005U\u00064\u0018-\u0003\u0002,_F*1%\u001e=~sR\u0011QN\u001e\u0005\bo2\t\t\u00111\u0001{\u0003\rAH%M\u0005\u0003sN\fQ\u0001\n9mkN\u0004\"!J>\n\u0005q4#aA!osF\u001aQE`@\u0010\u0003}\f#!!\u0001\u0002\u001f\"Lg/Z9mQ%\u0002\u0013n\u001d\u0011eKB\u0014XmY1uK\u0012\u0004\u0013m\u001d\u0011uQ\u0016\u00043/\u001d7!MVt7\r^5p]\u0002rwn\u001e\u0011qCJ\u001cXm\u001d\u0011vg&tw\r\t%jm\u0016\fF\n\t2zA\u0011,g-Y;mi:\u0002\u0013GB\u0010$\u0003\u000b\tI%M\u0005$\u0003\u000f\ti!a\u0007\u0002\u0010Q\u00191%!\u0003\t\u000f\u0005-A\u00021\u0001\u0002\u0016\u0005!\u0011M]4t\u0013\u0011\ty!!\u0005\u0002\u0003ML1!a\u0005'\u00055\u0019FO]5oO\u000e{g\u000e^3yiB!Q%a\u0006{\u0013\r\tIB\n\u0002\u000byI,\u0007/Z1uK\u0012t\u0014'C\u0010\u0002\u001e\u0005}\u0011\u0011HA!!\r)\u0013\u0011C\u0019\nG\u0005\u0005\u0012qEA\u0019\u0003S!B!!\b\u0002$!9\u0011Q\u0005\u0007A\u0002\u0005=\u0012!\u00029beR\u001c\u0018\u0002BA\u0015\u0003W\tQ!\u00199qYfT1!!\f'\u00035\u0019FO]5oO\u000e{g\u000e^3yiB!Q%a\u0006$c%\u0019\u00131GA\u001b\u0003o\tiCD\u0002E\u0003kI1!!\f'c\u0011!C\tS\u00142\u000b\u0015\nY$!\u0010\u0010\u0005\u0005u\u0012EAA \u00035\"\u0006.\u001a\u0011T#2\u0003C-[1mK\u000e$\bEZ8sAA\f'o]5oO\u0002\u001a\u0017M\u001c\u0011cK\u0002\u001aX\r\u001e\u0011vg&tw\rI\u0019\u0006K\u0005\r\u0013QI\b\u0003\u0003\u000b\n#!a\u0012\u0002\u0001EB1%\\A&\u0003'\ni%\u0003\u0003\u0002N\u0005=\u0013a\u0002#J\u00032+5\t\u0016\u0006\u0004\u0003#\"\u0011aB*R\u0019\u000e{gNZ\u0019\nG\u0005U\u0013qKA-\u0003#r1aDA,\u0013\r\t\t\u0006B\u0019\tG\u0005m\u0013\u0011NA6\u000b9!\u0011QLA5\u001d\u0011\ty&a\u001a\u000f\t\u0005\u0005\u0014Q\r\b\u0004\u000b\u0006\r\u0014\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\r\u0005$\u0003;\n9'!\u001c\bc!\u0019\u0013qLA3\u0003_J\u0011G\u0002\u0013\u0002b\u0005\r4\"\t\u0002\u0002t\u0005\u0019\u0011GL\u0019\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z\u0005\u0019\u0001.\u001d7\u0015\u0007y\u000bY\b\u0003\u0004h\u0003k\u0002\ra\t\u0015\b\u0003kJ\u0017qPA9c\u0019yR.!!\u0002\fF21%\u001e=\u0002\u0004f\fT!JAC\u0003\u000f{!!a\"\"\u0005\u0005%\u0015\u0001\u00145rY\"J\u0003%[:!I\u0016\u0004(/Z2bi\u0016$\u0007%Y:!i\",\u0007e]9mA\u0019,hn\u0019;j_:\u0004cn\\<!a\u0006\u00148/Z:!kNLgn\u001a\u0011ISZ,\u0017\u000b\u0014\u0011cs\u0002\"WMZ1vYRt\u0003%\r\u0004 G\u00055\u00151T\u0019\nG\u0005\u001d\u0011QBAH\u0003\u001f\t\u0014bHA\u000f\u0003#\u000b9*!'2\u0013\r\n\t#a\n\u0002\u0014\u0006%\u0012'C\u0012\u00024\u0005U\u0012QSA\u0017c\u0011!C\tS\u00142\u000b\u0015\nY$!\u00102\u000b\u0015\n\u0019%!\u00122\u0011\rj\u00171JAO\u0003\u001b\n\u0014bIA+\u0003/\ny*!\u00152\u0011\r\nY&!\u001b\u0002\"\u0016\t\u0004bIA/\u0003O\n\u0019kB\u0019\tG\u0005}\u0013QMAS\u0013E2A%!\u0019\u0002d-Aq!!+\u0001\t\u0003\tY+A\u0006de\u0016\fG/\u001a+bE2,W\u0003BAW\u0003S$b!a,\u0002|\u0006}H\u0003BAY\u0003o\u00032!JAZ\u0013\r\t)L\n\u0002\u0005+:LG\u000f\u0003\u0006\u0002:\u0006\u001d\u0016\u0011!a\u0002\u0003w\u000b!\"\u001a<jI\u0016t7-\u001a\u00132!\u0019\ti,!7\u0002f:!\u0011qXAj\u001d\u0011\t\t-a4\u000f\t\u0005\r\u0017\u0011\u001a\b\u0004\t\u0006\u0015\u0017bAAdM\u00059!/\u001a4mK\u000e$\u0018\u0002BAf\u0003\u001b\fqA];oi&lWMC\u0002\u0002H\u001aJ1ASAi\u0015\u0011\tY-!4\n\t\u0005U\u0017q[\u0001\tk:Lg/\u001a:tK*\u0019!*!5\n\t\u0005m\u0017Q\u001c\u0002\b)f\u0004X\rV1h\u0013\u0011\ty.!9\u0003\u0011QK\b/\u001a+bONTA!a9\u0002N\u0006\u0019\u0011\r]5\u0011\t\u0005\u001d\u0018\u0011\u001e\u0007\u0001\t!\tY/a*C\u0002\u00055(!A!\u0012\t\u0005=\u0018Q\u001f\t\u0004K\u0005E\u0018bAAzM\t9aj\u001c;iS:<\u0007cA\u0013\u0002x&\u0019\u0011\u0011 \u0014\u0003\u000fA\u0013x\u000eZ;di\"9\u0011Q`AT\u0001\u0004\u0019\u0013!\u0003;bE2,g*Y7f\u0011%\u0011\t!a*\u0011\u0002\u0003\u0007\u0001'A\u0007bY2|w/\u0012=jgRLgn\u001a\u0005\b\u0005\u000b\u0001A\u0011\u0001B\u0004\u0003\u001d\tg.\u00197zu\u0016$B!!-\u0003\n!9\u0011Q B\u0002\u0001\u0004\u0019\u0003\u0002\u0004B\u0007\u0001A\u0005\tr1Q\u0005\n\t=\u0011a\u0001=%gU\u0011!\u0011\u0003\t\bK\tM!q\u0003B\u0015\u0013\r\u0011)B\n\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\te!QE\u0007\u0003\u00057QAA!\b\u0003 \u0005!1m\u001c8g\u0015\r\u0019!\u0011\u0005\u0006\u0004\u0005GA\u0011A\u00025bI>|\u0007/\u0003\u0003\u0003(\tm!\u0001\u0003%jm\u0016\u001cuN\u001c4\u0011\t\t-\"QG\u0007\u0003\u0005[QAAa\f\u00032\u000591/Z:tS>t'\u0002\u0002B\u001a\u0005?\t!!\u001d7\n\t\t]\"Q\u0006\u0002\r'\u0016\u001c8/[8o'R\fG/\u001a\u0005\u000b\u0005w\u0001\u0001\u0012!Q!\n\tE\u0011\u0001\u0002=%g\u0001BqAa\u0010\u0001\t\u0003\u0012\t%A\u0004tKR\u001cuN\u001c4\u0015\r\u0005E&1\tB$\u0011\u001d\u0011)E!\u0010A\u0002\r\n1a[3z\u0011\u001d\u0011IE!\u0010A\u0002\r\nQA^1mk\u0016D\u0001B!\u0014\u0001\t#!!qJ\u0001\u000beVt7+\u001d7ISZ,Gc\u0001\"\u0003R!1QAa\u0013A\u0002\rBqA!\u0016\u0001\t#\u00119&A\u0004sk:D\u0015N^3\u0015\u000b\t\u0013IF!\u0018\t\u000f\tm#1\u000ba\u0001G\u0005\u00191-\u001c3\t\u0015\t}#1\u000bI\u0001\u0002\u0004\u0011\t'A\u0004nCb\u0014vn^:\u0011\u0007\u0015\u0012\u0019'C\u0002\u0003f\u0019\u00121!\u00138u\u0011)\u0011I\u0007\u0001EC\u0002\u0013E!1N\u0001\r_V$\b/\u001e;Ck\u001a4WM]\u000b\u0003\u0005[\u0012BAa\u001c\u0003\u0000\u00199!\u0011\u000fB:\u0001\t5$\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004B\u0003B;\u0001!\u0005\t\u0015)\u0003\u0003n\u0005iq.\u001e;qkR\u0014UO\u001a4fe\u0002BCAa\u001d\u0003zA\u0019QEa\u001f\n\u0007\tudEA\u0005ue\u0006t7/[3oiB!!\u0011\u0011BD\u001b\t\u0011\u0019IC\u0002\u0003\u0006F\f!![8\n\t\t%%1\u0011\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\u000b\u0005\u001b\u0013y\u00071A\u0005\u0002\t=\u0015a\u00019pgV\u0011!\u0011\r\u0005\u000b\u0005'\u0013y\u00071A\u0005\u0002\tU\u0015a\u00029pg~#S-\u001d\u000b\u0005\u0003c\u00139\nC\u0005x\u0005#\u000b\t\u00111\u0001\u0003b!Q!1\u0014B8\u0001\u0004%\tA!(\u0002\r\t,hMZ3s+\t\u0011y\nE\u0003&\u0005C\u0013\t'C\u0002\u0003$\u001a\u0012Q!\u0011:sCfD!Ba*\u0003p\u0001\u0007I\u0011\u0001BU\u0003)\u0011WO\u001a4fe~#S-\u001d\u000b\u0005\u0003c\u0013Y\u000bC\u0005x\u0005K\u000b\t\u00111\u0001\u0003 \"Y!q\u0016\u0001\t\u0006\u0004%\tB\u0001BY\u0003!A\u0017N^3d_:4WC\u0001B\f\u0011)\u0011)\f\u0001E\u0001B\u0003&!qC\u0001\nQ&4XmY8oM\u0002BCAa-\u0003z!Y!1\u0018\u0001\t\u0006\u0004%\tB\u0001B_\u00031\u0019Xm]:j_:\u001cF/\u0019;f+\t\u0011I\u0003\u0003\u0006\u0003B\u0002A\t\u0011)Q\u0005\u0005S\tQb]3tg&|gn\u0015;bi\u0016\u0004\u0003\u0006\u0002B`\u0005sB1Ba2\u0001\u0011\u000b\u0007I\u0011\u000b\u0003\u0003J\u000691-\u0019;bY><WC\u0001Bf%\u0019\u0011iM!6\u0003\\\u001a9!\u0011\u000fBh\u0001\t-\u0007B\u0003Bi\u0001!\u0005\t\u0015)\u0003\u0003L\u0006A1-\u0019;bY><\u0007\u0005\u000b\u0003\u0003P\ne\u0004c\u0001\u0010\u0003X&\u0019!\u0011\u001c\u0002\u0003)!Kg/Z'fi\u0006\u001cHo\u001c:f\u0007\u0006$\u0018\r\\8h!\u0011\u0011iNa9\u000e\u0005\t}'b\u0001Bq1\u0006A\u0011M\\1msNL7/\u0003\u0003\u0003f\n}'aD(wKJ\u0014\u0018\u000eZ3DCR\fGn\\4\t\u0017\t%\b\u0001#b\u0001\n#\"!1^\u0001\u0011MVt7\r^5p]J+w-[:uef,\"A!<\u0013\r\t=(q\u001fB\u007f\r\u001d\u0011\tH!=\u0001\u0005[D!Ba=\u0001\u0011\u0003\u0005\u000b\u0015\u0002Bw\u0003E1WO\\2uS>t'+Z4jgR\u0014\u0018\u0010\t\u0015\u0005\u0005c\u0014I\bE\u0002\u001f\u0005sL1Aa?\u0003\u0005QA\u0015N^3Gk:\u001cG/[8o%\u0016<\u0017n\u001d;ssB!!Q\u001cB\u0000\u0013\u0011\u0019\tAa8\u00031=3XM\u001d:jI\u00164UO\\2uS>t'+Z4jgR\u0014\u0018\u0010C\u0006\u0004\u0006\u0001A)\u0019!C)\t\r\u001d\u0011\u0001C1oC2L(0\u001a:\u0016\u0005\r%!\u0003BB\u0006\u0007'1qA!\u001d\u0004\u000e\u0001\u0019I\u0001\u0003\u0006\u0004\u0010\u0001A\t\u0011)Q\u0005\u0007\u0013\t\u0011\"\u00198bYfTXM\u001d\u0011)\t\r5!\u0011\u0010\t\u0005\u0005;\u001c)\"\u0003\u0003\u0004\u0018\t}'\u0001C!oC2L(0\u001a:\t\u0015\rm11\u0002b\u0001\n\u0003\u001ai\"A\u0007fqR,g\u000eZ3e%VdWm]\u000b\u0003\u0007?\u0001ba!\t\u0004,\r=RBAB\u0012\u0015\u0011\u0019)ca\n\u0002\u0013%lW.\u001e;bE2,'bAB\u0015M\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\r521\u0005\u0002\u0005\u0019&\u001cH\u000fE\u0003\u00042\r]\"+\u0004\u0002\u00044)\u00191Q\u0007-\u0002\u000bI,H.Z:\n\t\re21\u0007\u0002\u0005%VdW\rC\u0005\u0004>\u0001\u0011\r\u0011\"\u0001\u0004@\u0005Y\u0001.\u001b<f!2\fgN\\3s+\t\u0019\tE\u0005\u0004\u0004D\r-3\u0011\u000b\u0004\b\u0005c\u001a)\u0005AB!\u0011!\u00199\u0005\u0001Q\u0001\n\r\u0005\u0013\u0001\u00045jm\u0016\u0004F.\u00198oKJ\u0004\u0003\u0006BB#\u0005s\u00022aNB'\u0013\r\u0019y\u0005\u0005\u0002\r'B\f'o\u001b)mC:tWM\u001d\t\u0004=\rM\u0013bAB+\u0005\tq\u0001*\u001b<f'R\u0014\u0018\r^3hS\u0016\u001c\bBCB-\u0001\t\u0007I\u0011\u000b\u0003\u0004@\u00059\u0001\u000f\\1o]\u0016\u0014\b\u0002CB/\u0001\u0001\u0006Ia!\u0011\u0002\u0011Ad\u0017M\u001c8fe\u0002BCaa\u0017\u0003z!I11\r\u0001\u0012\u0002\u0013\u00051QM\u0001\u0016GJ,\u0017\r^3UC\ndW\r\n3fM\u0006,H\u000e\u001e\u00133+\u0011\u00199g! \u0016\u0005\r%$f\u0001\u0019\u0004l-\u00121Q\u000e\t\u0005\u0007_\u001aI(\u0004\u0002\u0004r)!11OB;\u0003%)hn\u00195fG.,GMC\u0002\u0004x\u0019\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0019Yh!\u001d\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0002\u0005\u0002l\u000e\u0005$\u0019AAw\u0011%\u0019\t\tAI\u0001\n#\u0019\u0019)A\tsk:D\u0015N^3%I\u00164\u0017-\u001e7uII*\"a!\"+\t\t\u000541N\u0004\b\u0007\u0013\u0013\u0001\u0012ABF\u0003-A\u0015N^3D_:$X\r\u001f;\u0011\u0007y\u0019iI\u0002\u0004\u0002\u0005!\u00051qR\n\u0007\u0007\u001b\u001b\tja&\u0011\u0007\u0015\u001a\u0019*C\u0002\u0004\u0016\u001a\u0012a!\u00118z%\u00164\u0007cA\u0013\u0004\u001a&\u001911\u0014\u0014\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000fm\u0019i\t\"\u0001\u0004 R\u001111\u0012\u0005\u000b\u0007G\u001biI1A\u0005\u0012\r\u0015\u0016A\u00049sS6LG/\u001b<f)f\u0004Xm]\u000b\u0003\u0007O\u0003ba!+\u0004,\u000e5VBAB\u0014\u0013\ra5q\u0005\n\t\u0007_\u001b),!>\u0004\u0018\u001a1!\u0011\u000f\u0001\u0001\u0007[S1aa-Y\u0003\u0015!\u0018\u0010]3t!\u0011\u00199l!/\u000e\u0005\rE\u0016\u0002BB^\u0007c\u0013!BT1uSZ,G+\u001f9f\u0011%\u0019yl!$!\u0002\u0013\u00199+A\bqe&l\u0017\u000e^5wKRK\b/Z:!\u0011%\u0019\u0019m!$\u0005\u0012\u0011\u0019)-\u0001\u0007u_\"Kg/Z*ue&tw\rF\u0002$\u0007\u000fD\u0001b!3\u0004B\u0002\u000711Z\u0001\u0002CB1QEa\u0005{\u0007\u001b\u0004Baa4\u0004T:!\u00111LBi\u0013\tQE!\u0003\u0003\u0004V\u000e]'\u0001\u0003#bi\u0006$\u0016\u0010]3\u000b\u0005)#\u0001\u0002CBn\u0007\u001b#\tb!8\u0002%Q|\u0007*\u001b<f'R\u0014Xo\u0019;TiJLgn\u001a\u000b\u0004G\r}\u0007\u0002CBe\u00073\u0004\raa3\t\u0015\r\r8QRA\u0001\n\u0013\u0019)/A\u0006sK\u0006$'+Z:pYZ,GCABt!\rq7\u0011^\u0005\u0004\u0007W|'AB(cU\u0016\u001cG\u000f")
public class HiveContext
extends SQLContext {
    private Tuple2<HiveConf, SessionState> x$3;
    private transient OutputStream outputBuffer;
    private transient HiveConf hiveconf;
    private transient SessionState sessionState;
    private transient HiveMetastoreCatalog catalog;
    private transient HiveFunctionRegistry functionRegistry;
    private transient Analyzer analyzer;
    private final transient SQLContext.SparkPlanner hivePlanner = new $anon$4(this);
    private final transient SQLContext.SparkPlanner planner = this.hivePlanner();
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static String toHiveStructString(Tuple2<Object, DataType> tuple2) {
        return HiveContext$.MODULE$.toHiveStructString(tuple2);
    }

    private OutputStream outputBuffer$lzycompute() {
        HiveContext hiveContext = this;
        synchronized (hiveContext) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.outputBuffer = new $anon$5(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.outputBuffer;
        }
    }

    private Tuple2 x$3$lzycompute() {
        HiveContext hiveContext = this;
        synchronized (hiveContext) {
            Tuple2 tuple2;
            block5: {
                if (!this.bitmap$0) {
                    Tuple2 tuple22;
                    tuple2 = (Tuple2)Option$.MODULE$.apply((Object)SessionState.get()).orElse((Function0)new $anonfun$4(this)).map((Function1)new $anonfun$5(this)).get();
                    if (tuple2 == null) break block5;
                    HiveConf hiveconf = (HiveConf)tuple2._1();
                    SessionState sessionState = (SessionState)tuple2._2();
                    this.x$3 = tuple22 = new Tuple2((Object)hiveconf, (Object)sessionState);
                    this.bitmap$0 = true;
                }
                return this.x$3;
            }
            throw new MatchError((Object)tuple2);
        }
    }

    private HiveConf hiveconf$lzycompute() {
        HiveContext hiveContext = this;
        synchronized (hiveContext) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.hiveconf = (HiveConf)this.x$3()._1();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.hiveconf;
        }
    }

    private SessionState sessionState$lzycompute() {
        HiveContext hiveContext = this;
        synchronized (hiveContext) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.sessionState = (SessionState)this.x$3()._2();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
            return this.sessionState;
        }
    }

    private HiveMetastoreCatalog catalog$lzycompute() {
        HiveContext hiveContext = this;
        synchronized (hiveContext) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.catalog = new $anon$1(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
            return this.catalog;
        }
    }

    private HiveFunctionRegistry functionRegistry$lzycompute() {
        HiveContext hiveContext = this;
        synchronized (hiveContext) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.functionRegistry = new $anon$2(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
            return this.functionRegistry;
        }
    }

    private Analyzer analyzer$lzycompute() {
        HiveContext hiveContext = this;
        synchronized (hiveContext) {
            if ((byte)(this.bitmap$trans$0 & 0x20) == 0) {
                this.analyzer = new $anon$3(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x20);
            }
            return this.analyzer;
        }
    }

    public String dialect() {
        return this.getConf(SQLConf$.MODULE$.DIALECT(), "hiveql");
    }

    public boolean convertMetastoreParquet() {
        String string = this.getConf("spark.sql.hive.convertMetastoreParquet", "true");
        String string2 = "true";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public QueryExecution executePlan(LogicalPlan plan) {
        return new QueryExecution(this, plan){
            private final LogicalPlan logical;

            public LogicalPlan logical() {
                return this.logical;
            }
            {
                this.logical = plan$1;
            }
        };
    }

    public SchemaRDD sql(String sqlText) {
        block4: {
            SchemaRDD schemaRDD;
            block3: {
                block2: {
                    String string = this.dialect();
                    String string2 = "sql";
                    if (string != null ? !string.equals(string2) : string2 != null) break block2;
                    schemaRDD = super.sql(sqlText);
                    break block3;
                }
                String string = this.dialect();
                String string3 = "hiveql";
                if (string != null ? !string.equals(string3) : string3 != null) break block4;
                schemaRDD = new SchemaRDD((SQLContext)this, (LogicalPlan)this.ddlParser().apply(sqlText).getOrElse((Function0)new Serializable(this, sqlText){
                    private final String sqlText$1;

                    public final LogicalPlan apply() {
                        return HiveQl$.MODULE$.parseSql(this.sqlText$1);
                    }
                    {
                        this.sqlText$1 = sqlText$1;
                    }
                }));
            }
            return schemaRDD;
        }
        throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported SQL dialect: ", ".  Try 'sql' or 'hiveql'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dialect()})));
    }

    public SchemaRDD hiveql(String hqlQuery) {
        return new SchemaRDD((SQLContext)this, HiveQl$.MODULE$.parseSql(hqlQuery));
    }

    public SchemaRDD hql(String hqlQuery) {
        return this.hiveql(hqlQuery);
    }

    public <A extends Product> void createTable(String tableName, boolean allowExisting, TypeTags.TypeTag<A> evidence$1) {
        this.catalog().createTable("default", tableName, (Seq<Attribute>)ScalaReflection$.MODULE$.attributesFor(evidence$1), allowExisting, this.catalog().createTable$default$5());
    }

    public <A extends Product> boolean createTable$default$2() {
        return true;
    }

    public void analyze(String tableName) {
        LogicalPlan relation = EliminateAnalysisOperators$.MODULE$.apply(((OverrideCatalog)this.catalog()).lookupRelation((Option)None$.MODULE$, tableName, ((OverrideCatalog)this.catalog()).lookupRelation$default$3()));
        LogicalPlan logicalPlan = relation;
        if (logicalPlan instanceof MetastoreRelation) {
            BoxedUnit boxedUnit;
            MetastoreRelation metastoreRelation = (MetastoreRelation)logicalPlan;
            Map tableParameters = metastoreRelation.hiveQlTable().getParameters();
            long oldTotalSize = BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply(tableParameters.get(HiveShim$.MODULE$.getStatsSetupConstTotalSize())).map((Function1)new Serializable(this){

                public final long apply(String x$1) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$1)).toLong();
                }
            }).getOrElse((Function0)new Serializable(this){

                public final long apply() {
                    return this.apply$mcJ$sp();
                }

                public long apply$mcJ$sp() {
                    return 0L;
                }
            }));
            long newTotalSize = this.getFileSizeForTable$1(this.hiveconf(), metastoreRelation.hiveQlTable());
            if (newTotalSize > 0L && newTotalSize != oldTotalSize) {
                tableParameters.put(HiveShim$.MODULE$.getStatsSetupConstTotalSize(), ((Object)BoxesRunTime.boxToLong((long)newTotalSize)).toString());
                org.apache.hadoop.hive.metastore.api.Table hiveTTable = metastoreRelation.hiveQlTable().getTTable();
                hiveTTable.setParameters(tableParameters);
                String tableFullName = new StringBuilder().append((Object)metastoreRelation.hiveQlTable().getDbName()).append((Object)".").append((Object)metastoreRelation.hiveQlTable().getTableName()).toString();
                this.catalog().client().alterTable(tableFullName, new Table(hiveTTable));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return;
        }
        throw new NotImplementedError(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Analyze has only implemented for Hive tables, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but ", " is a ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, logicalPlan.nodeName()}))).toString());
    }

    public OutputStream outputBuffer() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.outputBuffer$lzycompute() : this.outputBuffer;
    }

    private /* synthetic */ Tuple2 x$3() {
        return this.bitmap$0 ? this.x$3 : this.x$3$lzycompute();
    }

    public HiveConf hiveconf() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.hiveconf$lzycompute() : this.hiveconf;
    }

    public SessionState sessionState() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.sessionState$lzycompute() : this.sessionState;
    }

    public void setConf(String key, String value) {
        SQLConf.class.setConf((SQLConf)this, (String)key, (String)value);
        this.runSqlHive(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SET ", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, value})));
    }

    public HiveMetastoreCatalog catalog() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.catalog$lzycompute() : this.catalog;
    }

    public HiveFunctionRegistry functionRegistry() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.functionRegistry$lzycompute() : this.functionRegistry;
    }

    public Analyzer analyzer() {
        return (byte)(this.bitmap$trans$0 & 0x20) == 0 ? this.analyzer$lzycompute() : this.analyzer;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> runSqlHive(String sql2) {
        void var3_3;
        int maxResults = 100000;
        Seq<String> results = this.runHive(sql2, maxResults);
        if (results.size() == maxResults) {
            throw package$.MODULE$.error("RESULTS POSSIBLY TRUNCATED");
        }
        return var3_3;
    }

    public Seq<String> runHive(String cmd2, int maxRows) {
        try {
            Buffer<String> buffer;
            String cmd_trimmed = cmd2.trim();
            String[] tokens = cmd_trimmed.split("\\s+");
            String cmd_1 = cmd_trimmed.substring(tokens[0].length()).trim();
            CommandProcessor proc = HiveShim$.MODULE$.getCommandProcessor((String[])((Object[])new String[]{tokens[0]}), this.hiveconf());
            SessionState sessionState = SessionState.get();
            SessionState sessionState2 = this.sessionState();
            Object object = !(sessionState != null ? !sessionState.equals(sessionState2) : sessionState2 != null) ? BoxedUnit.UNIT : SessionState.start((SessionState)this.sessionState());
            CommandProcessor commandProcessor = proc;
            if (commandProcessor instanceof Driver) {
                Driver driver = (Driver)commandProcessor;
                ArrayList<Object> results = HiveShim$.MODULE$.createDriverResultsArray();
                CommandProcessorResponse response = driver.run(cmd2);
                if (response.getResponseCode() != 0) {
                    driver.close();
                    throw new QueryExecutionException(response.getErrorMessage());
                }
                driver.setMaxRows(maxRows);
                driver.getResults(results);
                driver.close();
                buffer = HiveShim$.MODULE$.processResults(results);
            } else {
                if (this.sessionState().out != null) {
                    this.sessionState().out.println(new StringBuilder().append((Object)tokens[0]).append((Object)" ").append((Object)cmd_1).toString());
                }
                buffer = (Buffer<String>)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)proc.run(cmd_1).getResponseCode())).toString()}));
            }
            return buffer;
        }
        catch (Exception exception) {
            this.logError((Function0)new Serializable(this){
                private final /* synthetic */ HiveContext $outer;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n            |======================\n            |HIVE FAILURE OUTPUT\n            |======================\n            |", "\n            |======================\n            |END HIVE FAILURE OUTPUT\n            |======================\n          "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.outputBuffer().toString()})))).stripMargin();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            throw exception;
        }
    }

    public int runHive$default$2() {
        return 1000;
    }

    public SQLContext.SparkPlanner hivePlanner() {
        return this.hivePlanner;
    }

    public SQLContext.SparkPlanner planner() {
        return this.planner;
    }

    public final long org$apache$spark$sql$hive$HiveContext$$calculateTableSize$1(FileSystem fs, Path path) {
        FileStatus fileStatus = fs.getFileStatus(path);
        long size = fileStatus.isDir() ? BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(path)).map((Function1)new Serializable(this, fs){
            private final /* synthetic */ HiveContext $outer;
            private final FileSystem fs$1;

            public final long apply(FileStatus status) {
                return this.$outer.org$apache$spark$sql$hive$HiveContext$$calculateTableSize$1(this.fs$1, status.getPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fs$1 = fs$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) : fileStatus.getLen();
        return size;
    }

    private final long getFileSizeForTable$1(HiveConf conf, Table table) {
        Path path = table.getPath();
        long size = 0L;
        try {
            FileSystem fs = path.getFileSystem((Configuration)conf);
            size = this.org$apache$spark$sql$hive$HiveContext$$calculateTableSize$1(fs, path);
        }
        catch (Exception exception) {
            this.logWarning((Function0)new Serializable(this, table, exception){
                private final Table table$1;
                private final Exception e$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to get the size of table ", " in the "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table$1.getTableName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"database ", " because of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table$1.getDbName(), this.e$1.toString()}))).toString();
                }
                {
                    this.table$1 = table$1;
                    this.e$1 = e$1;
                }
            }, exception);
            size = 0L;
        }
        return size;
    }

    public HiveContext(SparkContext sc) {
        super(sc);
    }

    public abstract class QueryExecution
    extends SQLContext.QueryExecution {
        public Seq<String> stringResult() {
            Seq seq;
            SparkPlan sparkPlan = this.executedPlan();
            if (sparkPlan instanceof DescribeHiveTableCommand) {
                DescribeHiveTableCommand describeHiveTableCommand = (DescribeHiveTableCommand)sparkPlan;
                seq = describeHiveTableCommand.hiveString();
            } else if (sparkPlan instanceof Command) {
                SparkPlan sparkPlan2 = sparkPlan;
                seq = (Seq)Predef$.MODULE$.refArrayOps((Object[])((Command)sparkPlan2).executeCollect()).map((Function1)new Serializable(this){

                    public final String apply(Row x$7) {
                        return x$7.head().toString();
                    }
                }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
            } else {
                Seq result = Predef$.MODULE$.refArrayOps((Object[])sparkPlan.executeCollect()).toSeq();
                Seq types = (Seq)this.analyzed().output().map((Function1)new Serializable(this){

                    public final DataType apply(Attribute x$8) {
                        return x$8.dataType();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                seq = ((SeqLike)((TraversableLike)result.map((Function1)new Serializable(this, types){
                    private final Seq types$1;

                    public final Seq<String> apply(Seq<Object> x$9) {
                        return (Seq)((TraversableLike)x$9.zip((GenIterable)this.types$1, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){

                            public final String apply(Tuple2<Object, DataType> a) {
                                return HiveContext$.MODULE$.toHiveString(a);
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                    }
                    {
                        this.types$1 = types$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){

                    public final String apply(Seq<String> x$10) {
                        return x$10.mkString("\t");
                    }
                }, Seq$.MODULE$.canBuildFrom())).toSeq();
            }
            return seq;
        }

        public String simpleString() {
            LogicalPlan logicalPlan = this.logical();
            String string = logicalPlan instanceof NativeCommand ? "<Native command: executed by Hive>" : (logicalPlan instanceof SetCommand ? "<SET command: executed by Hive, and noted by SQLContext>" : super.simpleString());
            return string;
        }

        public /* synthetic */ HiveContext org$apache$spark$sql$hive$HiveContext$QueryExecution$$$outer() {
            return (HiveContext)this.$outer;
        }

        public QueryExecution(HiveContext $outer) {
            super((SQLContext)$outer);
        }
    }
}

