/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.test;

import java.io.File;
import java.util.Set;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat;
import org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.serde2.RegexSerDe;
import org.apache.hadoop.hive.serde2.avro.AvroSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.SQLConf$;
import org.apache.spark.sql.catalyst.analysis.OverrideCatalog;
import org.apache.spark.sql.catalyst.plans.logical.CacheTableCommand;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.NativeCommand;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.hive.HiveContext;
import org.apache.spark.sql.hive.HiveQl$;
import org.apache.spark.sql.hive.HiveShim$;
import org.apache.spark.sql.hive.test.TestHiveContext$;
import org.apache.spark.sql.hive.test.TestHiveContext$QueryExecution$;
import org.apache.spark.sql.hive.test.TestHiveContext$TestTable$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\t\u0015h\u0001B\u0001\u0003\u0001=\u0011q\u0002V3ti\"Kg/Z\"p]R,\u0007\u0010\u001e\u0006\u0003\u0007\u0011\tA\u0001^3ti*\u0011QAB\u0001\u0005Q&4XM\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011CE\u0007\u0002\t%\u00111\u0003\u0002\u0002\f\u0011&4XmQ8oi\u0016DH\u000fC\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u00175\u0005\u00111o\u0019\t\u0003/ai\u0011\u0001C\u0005\u00033!\u0011Ab\u00159be.\u001cuN\u001c;fqRL!a\u0007\u000f\u0002\u0019M\u0004\u0018M]6D_:$X\r\u001f;\n\u0005u1!AC*R\u0019\u000e{g\u000e^3yi\")q\u0004\u0001C\u0001A\u00051A(\u001b8jiz\"\"!I\u0012\u0011\u0005\t\u0002Q\"\u0001\u0002\t\u000bUq\u0002\u0019\u0001\f\t\u0011\u0015\u0002\u0001R1A\u0005\u0002\u0019\nQb^1sK\"|Wo]3QCRDW#A\u0014\u0011\u0005!jS\"A\u0015\u000b\u0005)Z\u0013\u0001\u00027b]\u001eT\u0011\u0001L\u0001\u0005U\u00064\u0018-\u0003\u0002/S\t11\u000b\u001e:j]\u001eD\u0001\u0002\r\u0001\t\u0002\u0003\u0006KaJ\u0001\u000fo\u0006\u0014X\r[8vg\u0016\u0004\u0016\r\u001e5!\u0011!\u0011\u0004\u0001#b\u0001\n\u00031\u0013!D7fi\u0006\u001cHo\u001c:f!\u0006$\b\u000e\u0003\u00055\u0001!\u0005\t\u0015)\u0003(\u00039iW\r^1ti>\u0014X\rU1uQ\u0002BQA\u000e\u0001\u0005\u0012]\n\u0011bY8oM&<WO]3\u0015\u0003a\u0002\"!\u000f\u001f\u000e\u0003iR\u0011aO\u0001\u0006g\u000e\fG.Y\u0005\u0003{i\u0012A!\u00168ji\"9q\b\u0001b\u0001\n\u0003\u0001\u0015a\u0003;fgR$V-\u001c9ESJ,\u0012!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t.\n!![8\n\u0005\u0019\u001b%\u0001\u0002$jY\u0016Da\u0001\u0013\u0001!\u0002\u0013\t\u0015\u0001\u0004;fgR$V-\u001c9ESJ\u0004\u0003\u0002\u0003&\u0001\u0011\u000b\u0007I\u0011A&\u0002\u0011!Lg/\u001a%p[\u0016,\u0012\u0001\u0014\t\u0004s5\u000b\u0015B\u0001(;\u0005\u0019y\u0005\u000f^5p]\"A\u0001\u000b\u0001E\u0001B\u0003&A*A\u0005iSZ,\u0007j\\7fA!A!\u000b\u0001EC\u0002\u0013\u00051*A\u0006iSZ,G)\u001a<I_6,\u0007\u0002\u0003+\u0001\u0011\u0003\u0005\u000b\u0015\u0002'\u0002\u0019!Lg/\u001a#fm\"{W.\u001a\u0011\t\u000bY\u0003A\u0011I,\u0002\u0015I,hnU9m\u0011&4X\r\u0006\u0002YUB\u0019\u0011,\u00193\u000f\u0005i{fBA._\u001b\u0005a&BA/\u000f\u0003\u0019a$o\\8u}%\t1(\u0003\u0002au\u00059\u0001/Y2lC\u001e,\u0017B\u00012d\u0005\r\u0019V-\u001d\u0006\u0003Aj\u0002\"!\u001a5\u000f\u0005e2\u0017BA4;\u0003\u0019\u0001&/\u001a3fM&\u0011a&\u001b\u0006\u0003OjBQaB+A\u0002\u0011DQ\u0001\u001c\u0001\u0005B5\f1\"\u001a=fGV$X\r\u00157b]R\u0019a.!\u0004\u0011\u0005=\u0004X\"\u0001\u0001\u0007\u000bE\u0004\u0011\u0011\u0001:\u0003\u001dE+XM]=Fq\u0016\u001cW\u000f^5p]N\u0011\u0001o\u001d\t\u0003_RL!!\u001d\n\t\u000b}\u0001H\u0011\u0001<\u0015\u00039D\u0001\u0002\u001f9\t\u0006\u0004%\t%_\u0001\tC:\fG.\u001f>fIV\t!\u0010E\u0002|\u0003\u000bi\u0011\u0001 \u0006\u0003{z\fq\u0001\\8hS\u000e\fGNC\u0002\u0000\u0003\u0003\tQ\u0001\u001d7b]NT1!a\u0001\u0007\u0003!\u0019\u0017\r^1msN$\u0018bAA\u0004y\nYAj\\4jG\u0006d\u0007\u000b\\1o\u0011%\tY\u0001\u001dE\u0001B\u0003&!0A\u0005b]\u0006d\u0017P_3eA!1\u0011qB6A\u0002i\fA\u0001\u001d7b]\"A\u00111\u0003\u0001\u0005B!\t)\"\u0001\u000bok6\u001c\u0006.\u001e4gY\u0016\u0004\u0016M\u001d;ji&|gn]\u000b\u0003\u0003/\u00012!OA\r\u0013\r\tYB\u000f\u0002\u0004\u0013:$\bbBA\u0010\u0001\u0011%\u0011\u0011E\u0001\rK:4h+\u0019:U_\u001aKG.\u001a\u000b\u0004\u0019\u0006\r\u0002bBA\u0013\u0003;\u0001\r\u0001Z\u0001\u0007K:4h+\u0019:\t\u000f\u0005%\u0002\u0001\"\u0003\u0002,\u0005a!/Z<sSR,\u0007+\u0019;igR\u0019A-!\f\t\u000f\u0005=\u0012q\u0005a\u0001I\u0006\u00191-\u001c3\t\u0011\u0005M\u0002A1A\u0005\u0002\u0001\u000bQ\u0002[5wK\u001aKG.Z:UK6\u0004\bbBA\u001c\u0001\u0001\u0006I!Q\u0001\u000fQ&4XMR5mKN$V-\u001c9!\u0011!\tY\u0004\u0001b\u0001\n\u0003\u0001\u0015aC5o%\u0016\u0004x\u000eV3tiNDq!a\u0010\u0001A\u0003%\u0011)\u0001\u0007j]J+\u0007o\u001c+fgR\u001c\b\u0005C\u0004\u0002D\u0001!\t!!\u0012\u0002\u0017\u001d,G\u000fS5wK\u001aKG.\u001a\u000b\u0004\u0003\u0006\u001d\u0003bBA%\u0003\u0003\u0002\r\u0001Z\u0001\u0005a\u0006$\b\u000eC\u0005\u0002N\u0001\u0011\r\u0011\"\u0001\u0002P\u0005qA-Z:de&\u0014W\r\u001a+bE2,WCAA)!\u0011\t\u0019&!\u0018\u000e\u0005\u0005U#\u0002BA,\u00033\n\u0001\"\\1uG\"Lgn\u001a\u0006\u0004\u00037R\u0014\u0001B;uS2LA!a\u0018\u0002V\t)!+Z4fq\"A\u00111\r\u0001!\u0002\u0013\t\t&A\beKN\u001c'/\u001b2fIR\u000b'\r\\3!\r\u001d\t9\u0007\u0001\u0005\u0005\u0003S\u0012A\u0003S5wKFc\u0015+^3ss\u0016CXmY;uS>t7cAA3]\"Q\u0011QNA3\u0005\u0003\u0005\u000b\u0011\u00023\u0002\u0007!\fH\u000eC\u0004 \u0003K\"\t!!\u001d\u0015\t\u0005M\u0014Q\u000f\t\u0004_\u0006\u0015\u0004bBA7\u0003_\u0002\r\u0001\u001a\u0005\n{\u0006\u0015\u0004R1A\u0005\u0002eD!\"a\u001f\u0002f!\u0005\t\u0015)\u0003{\u0003!awnZ5dC2\u0004\u0003\u0002CA@\u0003K\"\t!!!\u0002\u0011!Lg/Z#yK\u000e$\u0012\u0001\u0017\u0005\t\u0003\u000b\u000b)\u0007\"\u0011\u0002\b\u0006AAo\\*ue&tw\rF\u0001(\r\u0019\tY\t\u0001!\u0002\u000e\nIA+Z:u)\u0006\u0014G.Z\n\t\u0003\u0013\u000by)!&\u0002\u001cB\u0019\u0011(!%\n\u0007\u0005M%H\u0001\u0004B]f\u0014VM\u001a\t\u0004s\u0005]\u0015bAAMu\t9\u0001K]8ek\u000e$\bcA\u001d\u0002\u001e&\u0019\u0011q\u0014\u001e\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0017\u0005\r\u0016\u0011\u0012BK\u0002\u0013\u0005\u0011QU\u0001\u0005]\u0006lW-F\u0001e\u0011)\tI+!#\u0003\u0012\u0003\u0006I\u0001Z\u0001\u0006]\u0006lW\r\t\u0005\f\u0003[\u000bII!f\u0001\n\u0003\ty+\u0001\u0005d_6l\u0017M\u001c3t+\t\t\t\fE\u0003:\u0003g\u000b9,C\u0002\u00026j\u0012!\u0002\u0010:fa\u0016\fG/\u001a3?!\u0011I\u0014\u0011\u0018\u001d\n\u0007\u0005m&HA\u0005Gk:\u001cG/[8oa!Y\u0011qXAE\u0005#\u0005\u000b\u0011BAY\u0003%\u0019w.\\7b]\u0012\u001c\b\u0005C\u0004 \u0003\u0013#\t!a1\u0015\r\u0005\u0015\u0017qYAe!\ry\u0017\u0011\u0012\u0005\b\u0003G\u000b\t\r1\u0001e\u0011!\ti+!1A\u0002\u0005E\u0006\"CAg\u0003\u0013\u000b\t\u0011\"\u0011'\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jq\"Q\u0011\u0011[AE\u0003\u0003%\t!!\u0006\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0015\u0005U\u0017\u0011RA\u0001\n\u0003\t9.\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005e\u0017q\u001c\t\u0004s\u0005m\u0017bAAou\t\u0019\u0011I\\=\t\u0015\u0005\u0005\u00181[A\u0001\u0002\u0004\t9\"A\u0002yIEB!\"!:\u0002\n\u0006\u0005I\u0011IAt\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAu!\u0019\tY/!=\u0002Z6\u0011\u0011Q\u001e\u0006\u0004\u0003_T\u0014AC2pY2,7\r^5p]&!\u00111_Aw\u0005!IE/\u001a:bi>\u0014\bBCA|\u0003\u0013\u000b\t\u0011\"\u0001\u0002z\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002|\n\u0005\u0001cA\u001d\u0002~&\u0019\u0011q \u001e\u0003\u000f\t{w\u000e\\3b]\"Q\u0011\u0011]A{\u0003\u0003\u0005\r!!7\t\u0015\t\u0015\u0011\u0011RA\u0001\n\u0003\u00129!\u0001\u0005iCND7i\u001c3f)\t\t9\u0002\u0003\u0006\u0002\u0006\u0006%\u0015\u0011!C!\u0003\u000fC!B!\u0004\u0002\n\u0006\u0005I\u0011\tB\b\u0003\u0019)\u0017/^1mgR!\u00111 B\t\u0011)\t\tOa\u0003\u0002\u0002\u0003\u0007\u0011\u0011\\\u0004\n\u0005+\u0001\u0011\u0011!E\u0001\u0005/\t\u0011\u0002V3tiR\u000b'\r\\3\u0011\u0007=\u0014IBB\u0005\u0002\f\u0002\t\t\u0011#\u0001\u0003\u001cM1!\u0011\u0004B\u000f\u00037\u0003\u0012Ba\b\u0003&\u0011\f\t,!2\u000e\u0005\t\u0005\"b\u0001B\u0012u\u00059!/\u001e8uS6,\u0017\u0002\u0002B\u0014\u0005C\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83\u0011\u001dy\"\u0011\u0004C\u0001\u0005W!\"Aa\u0006\t\u0015\u0005\u0015%\u0011DA\u0001\n\u000b\n9\t\u0003\u0006\u00032\te\u0011\u0011!CA\u0005g\tQ!\u00199qYf$b!!2\u00036\t]\u0002bBAR\u0005_\u0001\r\u0001\u001a\u0005\t\u0003[\u0013y\u00031\u0001\u00022\"Q!1\bB\r\u0003\u0003%\tI!\u0010\u0002\u0015Ut\u0017\r\u001d9msN+\u0017\u000f\u0006\u0003\u0003@\t-\u0003\u0003B\u001dN\u0005\u0003\u0002b!\u000fB\"I\n\u001d\u0013b\u0001B#u\t1A+\u001e9mKJ\u0002b!a;\u0003J\u0005]\u0016b\u00012\u0002n\"Q!Q\nB\u001d\u0003\u0003\u0005\r!!2\u0002\u0007a$\u0003\u0007\u0003\u0006\u0003R\te\u0011\u0011!C\u0005\u0005'\n1B]3bIJ+7o\u001c7wKR\u0011!Q\u000b\t\u0004Q\t]\u0013b\u0001B-S\t1qJ\u00196fGR4qA!\u0018\u0001\u0013\u0011\u0011yF\u0001\u0004Tc2\u001cU\u000eZ\n\u0005\u00057\ny\tC\u0005\b\u00057\u0012\t\u0011)A\u0005I\"9qDa\u0017\u0005\u0002\t\u0015D\u0003\u0002B4\u0005S\u00022a\u001cB.\u0011\u00199!1\ra\u0001I\"A\u0011q\u0006B.\t\u0003\u0011i'\u0006\u0002\u00028\"Q!\u0011\u000f\u0001\u0002\u0002\u0013MAAa\u001d\u0002\rM\u000bHnQ7e)\u0011\u00119G!\u001e\t\r\u001d\u0011y\u00071\u0001e\u0011)\u0011I\b\u0001EC\u0002\u0013\u0005!1P\u0001\u000bi\u0016\u001cH\u000fV1cY\u0016\u001cXC\u0001B?!\u001d\u0011yH!\"e\u0003\u000bl!A!!\u000b\t\t\r\u0015Q^\u0001\b[V$\u0018M\u00197f\u0013\u0011\u00119I!!\u0003\u000f!\u000b7\u000f['ba\"Q!1\u0012\u0001\t\u0002\u0003\u0006KA! \u0002\u0017Q,7\u000f\u001e+bE2,7\u000f\t\u0005\b\u0005\u001f\u0003A\u0011\u0001BI\u0003E\u0011XmZ5ti\u0016\u0014H+Z:u)\u0006\u0014G.\u001a\u000b\u0005\u0005{\u0012\u0019\n\u0003\u0005\u0003\u0016\n5\u0005\u0019AAc\u0003%!Xm\u001d;UC\ndW\rC\u0005\u0003\u001a\u0002\u0011\r\u0011\"\u0001\u0003\u001c\u0006\u0019\u0002.\u001b<f#R+7\u000f^+uS2$\u0016M\u00197fgV\u0011!Q\u0014\t\u0007\u0003W\u0014I%!2\t\u0011\t\u0005\u0006\u0001)A\u0005\u0005;\u000bA\u0003[5wKF#Vm\u001d;Vi&dG+\u00192mKN\u0004\u0003\"\u0003BS\u0001\t\u0007I\u0011\u0002BT\u00031aw.\u00193fIR\u000b'\r\\3t+\t\u0011I\u000bE\u0003\u0003\u0000\t-F-\u0003\u0003\u0003.\n\u0005%a\u0002%bg\"\u001cV\r\u001e\u0005\t\u0005c\u0003\u0001\u0015!\u0003\u0003*\u0006iAn\\1eK\u0012$\u0016M\u00197fg\u0002B\u0011B!.\u0001\u0001\u0004%\tAa.\u0002\u0017\r\f7\r[3UC\ndWm]\u000b\u0003\u0003wD\u0011Ba/\u0001\u0001\u0004%\tA!0\u0002\u001f\r\f7\r[3UC\ndWm]0%KF$2\u0001\u000fB`\u0011)\t\tO!/\u0002\u0002\u0003\u0007\u00111 \u0005\t\u0005\u0007\u0004\u0001\u0015)\u0003\u0002|\u0006a1-Y2iKR\u000b'\r\\3tA!9!q\u0019\u0001\u0005\u0002\t%\u0017!\u00047pC\u0012$Vm\u001d;UC\ndW\rF\u00029\u0005\u0017Dq!a)\u0003F\u0002\u0007A\rC\u0005\u0003P\u0002\u0011\r\u0011\"\u0005\u0003R\u0006aqN]5hS:\fG.\u00163ggV\u0011!1\u001b\t\u0006\u0005+\u0014I\u000eZ\u0007\u0003\u0005/T1!a\u0017,\u0013\u0011\u0011YNa6\u0003\u0007M+G\u000f\u0003\u0005\u0003`\u0002\u0001\u000b\u0011\u0002Bj\u00035y'/[4j]\u0006dW\u000b\u001a4tA!1!1\u001d\u0001\u0005\u0002]\nQA]3tKR\u0004")
public class TestHiveContext
extends HiveContext {
    private String warehousePath;
    private String metastorePath;
    private final File testTempDir;
    private Option<File> hiveHome;
    private Option<File> hiveDevHome;
    private final File hiveFilesTemp;
    private final File inRepoTests;
    private final Regex describedTable;
    private HashMap<String, TestTable> testTables;
    private final Seq<TestTable> hiveQTestUtilTables;
    private final HashSet<String> loadedTables;
    private boolean cacheTables;
    private final Set<String> originalUdfs;
    private volatile TestHiveContext$TestTable$ TestTable$module;
    private volatile byte bitmap$0;

    private String warehousePath$lzycompute() {
        TestHiveContext testHiveContext = this;
        synchronized (testHiveContext) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.warehousePath = package$.MODULE$.getTempFilePath("sparkHiveWarehouse", package$.MODULE$.getTempFilePath$default$2()).getCanonicalPath();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.warehousePath;
        }
    }

    private String metastorePath$lzycompute() {
        TestHiveContext testHiveContext = this;
        synchronized (testHiveContext) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.metastorePath = package$.MODULE$.getTempFilePath("sparkHiveMetastore", package$.MODULE$.getTempFilePath$default$2()).getCanonicalPath();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.metastorePath;
        }
    }

    private Option hiveHome$lzycompute() {
        TestHiveContext testHiveContext = this;
        synchronized (testHiveContext) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.hiveHome = this.envVarToFile("HIVE_HOME");
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.hiveHome;
        }
    }

    private Option hiveDevHome$lzycompute() {
        TestHiveContext testHiveContext = this;
        synchronized (testHiveContext) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.hiveDevHome = this.envVarToFile("HIVE_DEV_HOME");
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.hiveDevHome;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TestHiveContext$TestTable$ TestTable$lzycompute() {
        TestHiveContext testHiveContext = this;
        synchronized (testHiveContext) {
            if (this.TestTable$module != null) return this.TestTable$module;
            this.TestTable$module = new TestHiveContext$TestTable$(this);
            return this.TestTable$module;
        }
    }

    private HashMap testTables$lzycompute() {
        TestHiveContext testHiveContext = this;
        synchronized (testHiveContext) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.testTables = new HashMap();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
            return this.testTables;
        }
    }

    public String warehousePath() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.warehousePath$lzycompute() : this.warehousePath;
    }

    public String metastorePath() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.metastorePath$lzycompute() : this.metastorePath;
    }

    public void configure() {
        this.setConf("javax.jdo.option.ConnectionURL", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jdbc:derby:;databaseName=", ";create=true"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.metastorePath()})));
        this.setConf("hive.metastore.warehouse.dir", this.warehousePath());
        Utils$.MODULE$.registerShutdownDeleteDir(new File(this.warehousePath()));
        Utils$.MODULE$.registerShutdownDeleteDir(new File(this.metastorePath()));
    }

    public File testTempDir() {
        return this.testTempDir;
    }

    public Option<File> hiveHome() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.hiveHome$lzycompute() : this.hiveHome;
    }

    public Option<File> hiveDevHome() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.hiveDevHome$lzycompute() : this.hiveDevHome;
    }

    @Override
    public Seq<String> runSqlHive(String sql2) {
        return super.runSqlHive(this.rewritePaths(sql2));
    }

    @Override
    public QueryExecution executePlan(LogicalPlan plan) {
        return new QueryExecution(this, plan){
            private final LogicalPlan logical;

            public LogicalPlan logical() {
                return this.logical;
            }
            {
                this.logical = plan$1;
            }
        };
    }

    public int numShufflePartitions() {
        return new StringOps(Predef$.MODULE$.augmentString(this.getConf(SQLConf$.MODULE$.SHUFFLE_PARTITIONS(), "5"))).toInt();
    }

    private Option<File> envVarToFile(String envVar) {
        return Option$.MODULE$.apply((Object)System.getenv(envVar)).map((Function1)new Serializable(this){

            public final File apply(String x$1) {
                return new File(x$1);
            }
        });
    }

    private String rewritePaths(String cmd2) {
        String string;
        if (cmd2.toUpperCase().contains("LOAD DATA")) {
            String testDataLocation = (String)this.hiveDevHome().map((Function1)new Serializable(this){

                public final String apply(File x$2) {
                    return x$2.getCanonicalPath();
                }
            }).getOrElse((Function0)new Serializable(this){
                private final /* synthetic */ TestHiveContext $outer;

                public final String apply() {
                    return this.$outer.inRepoTests().getCanonicalPath();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            string = cmd2.replaceAll("\\.\\./\\.\\./", new StringBuilder().append((Object)testDataLocation).append((Object)"/").toString());
        } else {
            string = cmd2;
        }
        return string;
    }

    public File hiveFilesTemp() {
        return this.hiveFilesTemp;
    }

    public File inRepoTests() {
        return this.inRepoTests;
    }

    public File getHiveFile(String path) {
        String stripped = path.replaceAll("\\.\\.\\/", "").replace('/', File.separatorChar);
        return (File)this.hiveDevHome().map((Function1)new Serializable(this, stripped){
            private final String stripped$1;

            public final File apply(File x$3) {
                return new File(x$3, this.stripped$1);
            }
            {
                this.stripped$1 = stripped$1;
            }
        }).filter((Function1)new Serializable(this){

            public final boolean apply(File x$4) {
                return x$4.exists();
            }
        }).getOrElse((Function0)new Serializable(this, stripped){
            private final /* synthetic */ TestHiveContext $outer;
            private final String stripped$1;

            public final File apply() {
                return new File(this.$outer.inRepoTests(), this.stripped$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.stripped$1 = stripped$1;
            }
        });
    }

    public Regex describedTable() {
        return this.describedTable;
    }

    public TestHiveContext$TestTable$ TestTable() {
        return this.TestTable$module == null ? this.TestTable$lzycompute() : this.TestTable$module;
    }

    public SqlCmd SqlCmd(String sql2) {
        return new SqlCmd(this, sql2);
    }

    public HashMap<String, TestTable> testTables() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.testTables$lzycompute() : this.testTables;
    }

    public HashMap<String, TestTable> registerTestTable(TestTable testTable) {
        return this.testTables().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testTable.name()), (Object)testTable));
    }

    public Seq<TestTable> hiveQTestUtilTables() {
        return this.hiveQTestUtilTables;
    }

    private HashSet<String> loadedTables() {
        return this.loadedTables;
    }

    public boolean cacheTables() {
        return this.cacheTables;
    }

    public void cacheTables_$eq(boolean x$1) {
        this.cacheTables = x$1;
    }

    public void loadTestTable(String name) {
        if (!this.loadedTables().contains((Object)name)) {
            this.loadedTables().$plus$eq((Object)name);
            this.logInfo((Function0)new Serializable(this, name){
                private final String name$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading test table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1}));
                }
                {
                    this.name$1 = name$1;
                }
            });
            Seq createCmds = (Seq)this.testTables().get((Object)name).map((Function1)new Serializable(this){

                public final Seq<Function0<BoxedUnit>> apply(TestTable x$7) {
                    return x$7.commands();
                }
            }).getOrElse((Function0)new Serializable(this, name){
                private final String name$1;

                public final Nothing$ apply() {
                    return scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown test table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1})));
                }
                {
                    this.name$1 = name$1;
                }
            });
            createCmds.foreach((Function1)new Serializable(this){

                public final void apply(Function0<BoxedUnit> x$8) {
                    x$8.apply$mcV$sp();
                }
            });
            if (this.cacheTables()) {
                this.cacheTable(name);
            }
        }
    }

    public Set<String> originalUdfs() {
        return this.originalUdfs;
    }

    public void reset() {
        try {
            JavaConversions$.MODULE$.enumerationAsScalaIterator(LogManager.getCurrentLoggers()).foreach((Function1)new Serializable(this){

                public final void apply(Object log) {
                    ((Logger)log).setLevel(Level.WARN);
                }
            });
            this.clearCache();
            this.loadedTables().clear();
            JavaConversions$.MODULE$.asScalaBuffer(this.catalog().client().getAllTables("default")).foreach((Function1)new Serializable(this){
                private final /* synthetic */ TestHiveContext $outer;

                public final void apply(String t) {
                    this.$outer.logDebug((Function0)new Serializable(this, t){
                        private final String t$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.t$1}));
                        }
                        {
                            this.t$1 = t$1;
                        }
                    });
                    Table table = this.$outer.catalog().client().getTable("default", t);
                    JavaConversions$.MODULE$.asScalaBuffer(this.$outer.catalog().client().getIndexes("default", t, (short)255)).foreach((Function1)new Serializable(this, t){
                        private final /* synthetic */ $anonfun$reset$2 $outer;
                        private final String t$1;

                        public final boolean apply(Index index) {
                            return this.$outer.org$apache$spark$sql$hive$test$TestHiveContext$$anonfun$$$outer().catalog().client().dropIndex("default", this.t$1, index.getIndexName(), true);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.t$1 = t$1;
                        }
                    });
                    if (!table.isIndexTable()) {
                        this.$outer.catalog().client().dropTable("default", t);
                    }
                }

                public /* synthetic */ TestHiveContext org$apache$spark$sql$hive$test$TestHiveContext$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            ((IterableLike)JavaConversions$.MODULE$.asScalaBuffer(this.catalog().client().getAllDatabases()).filterNot((Function1)new Serializable(this){

                public final boolean apply(String x$9) {
                    String string = x$9;
                    String string2 = "default";
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }
            })).foreach((Function1)new Serializable(this){
                private final /* synthetic */ TestHiveContext $outer;

                public final void apply(String db) {
                    this.$outer.logDebug((Function0)new Serializable(this, db){
                        private final String db$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dropping Database: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.db$1}));
                        }
                        {
                            this.db$1 = db$1;
                        }
                    });
                    this.$outer.catalog().client().dropDatabase(db, true, false, true);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            ((OverrideCatalog)this.catalog()).unregisterAllTables();
            ((IterableLike)JavaConversions$.MODULE$.asScalaSet(FunctionRegistry.getFunctionNames()).filterNot((Function1)new Serializable(this){
                private final /* synthetic */ TestHiveContext $outer;

                public final boolean apply(String x$10) {
                    return this.$outer.originalUdfs().contains(x$10);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            })).foreach((Function1)new Serializable(this){

                public final void apply(String udfName) {
                    FunctionRegistry.unregisterTemporaryUDF((String)udfName);
                }
            });
            this.hiveconf().set("fs.default.name", new File(".").toURI().toString());
            this.runSqlHive("RESET");
            this.runSqlHive("set datanucleus.cache.collections=true");
            this.runSqlHive("set datanucleus.cache.collections.lazy=true");
            this.runSqlHive("set hive.metastore.partition.name.whitelist.pattern=.*");
            this.configure();
            this.runSqlHive("USE default");
            this.loadTestTable("src");
            this.loadTestTable("srcpart");
        }
        catch (Exception exception) {
            this.logError((Function0)new Serializable(this){

                public final String apply() {
                    return "FATAL ERROR: Failed to reset TestDB state.";
                }
            }, exception);
        }
    }

    public TestHiveContext(SparkContext sc) {
        super(sc);
        System.clearProperty("spark.hostPort");
        CommandProcessorFactory.clean((HiveConf)this.hiveconf());
        this.testTempDir = File.createTempFile("testTempFiles", "spark.hive.tmp");
        this.testTempDir().delete();
        this.testTempDir().mkdir();
        Utils$.MODULE$.registerShutdownDeleteDir(this.testTempDir());
        System.setProperty("test.tmp.dir", this.testTempDir().getCanonicalPath());
        this.configure();
        this.hiveFilesTemp = File.createTempFile("catalystHiveFiles", "");
        this.hiveFilesTemp().delete();
        this.hiveFilesTemp().mkdir();
        Utils$.MODULE$.registerShutdownDeleteDir(this.hiveFilesTemp());
        this.inRepoTests = System.getProperty("user.dir").endsWith(new StringBuilder().append((Object)"sql").append((Object)File.separator).append((Object)"hive").toString()) ? new File(new StringBuilder().append((Object)"src").append((Object)File.separator).append((Object)"test").append((Object)File.separator).append((Object)"resources").append((Object)File.separator).toString()) : new File(new StringBuilder().append((Object)"sql").append((Object)File.separator).append((Object)"hive").append((Object)File.separator).append((Object)"src").append((Object)File.separator).append((Object)"test").append((Object)File.separator).append((Object)"resources").toString());
        this.describedTable = new StringOps(Predef$.MODULE$.augmentString("DESCRIBE (\\w+)")).r();
        this.hiveQTestUtilTables = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TestTable[]{new TestTable(this, "src", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd("CREATE TABLE src (key INT, value STRING)").cmd(), this.SqlCmd(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD DATA LOCAL INPATH '", "' INTO TABLE src"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getHiveFile("data/files/kv1.txt")}))).cmd()})), new TestTable(this, "src1", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd("CREATE TABLE src1 (key INT, value STRING)").cmd(), this.SqlCmd(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD DATA LOCAL INPATH '", "' INTO TABLE src1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getHiveFile("data/files/kv3.txt")}))).cmd()})), new TestTable(this, "srcpart", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{new $anonfun$1(this)})), new TestTable(this, "srcpart1", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{new $anonfun$2(this)})), new TestTable(this, "src_thrift", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{new $anonfun$3(this)})), new TestTable(this, "serdeins", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE serdeins (key INT, value STRING)\n         |ROW FORMAT SERDE '", "'\n         |WITH SERDEPROPERTIES ('field.delim'='\\\\t')\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LazySimpleSerDe.class.getCanonicalName()})))).stripMargin()).cmd(), this.SqlCmd("INSERT OVERWRITE TABLE serdeins SELECT * FROM src").cmd()})), new TestTable(this, "sales", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE IF NOT EXISTS sales (key STRING, value INT)\n         |ROW FORMAT SERDE '", "'\n         |WITH SERDEPROPERTIES (\"input.regex\" = \"([^ ]*)\\t([^ ]*)\")\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RegexSerDe.class.getCanonicalName()})))).stripMargin()).cmd(), this.SqlCmd(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD DATA LOCAL INPATH '", "' INTO TABLE sales"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getHiveFile("data/files/sales.txt")}))).cmd()})), new TestTable(this, "episodes", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE episodes (title STRING, air_date STRING, doctor INT)\n         |ROW FORMAT SERDE '", "'\n         |STORED AS\n         |INPUTFORMAT '", "'\n         |OUTPUTFORMAT '", "'\n         |TBLPROPERTIES (\n         |  'avro.schema.literal'='{\n         |    \"type\": \"record\",\n         |    \"name\": \"episodes\",\n         |    \"namespace\": \"testing.hive.avro.serde\",\n         |    \"fields\": [\n         |      {\n         |          \"name\": \"title\",\n         |          \"type\": \"string\",\n         |          \"doc\": \"episode title\"\n         |      },\n         |      {\n         |          \"name\": \"air_date\",\n         |          \"type\": \"string\",\n         |          \"doc\": \"initial date\"\n         |      },\n         |      {\n         |          \"name\": \"doctor\",\n         |          \"type\": \"int\",\n         |          \"doc\": \"main actor playing the Doctor in episode\"\n         |      }\n         |    ]\n         |  }'\n         |)\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{AvroSerDe.class.getCanonicalName(), AvroContainerInputFormat.class.getCanonicalName(), AvroContainerOutputFormat.class.getCanonicalName()})))).stripMargin()).cmd(), this.SqlCmd(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD DATA LOCAL INPATH '", "' INTO TABLE episodes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getHiveFile("data/files/episodes.avro")}))).cmd()})), new TestTable(this, "episodes_part", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE episodes_part (title STRING, air_date STRING, doctor INT)\n         |PARTITIONED BY (doctor_pt INT)\n         |ROW FORMAT SERDE '", "'\n         |STORED AS\n         |INPUTFORMAT '", "'\n         |OUTPUTFORMAT '", "'\n         |TBLPROPERTIES (\n         |  'avro.schema.literal'='{\n         |    \"type\": \"record\",\n         |    \"name\": \"episodes\",\n         |    \"namespace\": \"testing.hive.avro.serde\",\n         |    \"fields\": [\n         |      {\n         |          \"name\": \"title\",\n         |          \"type\": \"string\",\n         |          \"doc\": \"episode title\"\n         |      },\n         |      {\n         |          \"name\": \"air_date\",\n         |          \"type\": \"string\",\n         |          \"doc\": \"initial date\"\n         |      },\n         |      {\n         |          \"name\": \"doctor\",\n         |          \"type\": \"int\",\n         |          \"doc\": \"main actor playing the Doctor in episode\"\n         |      }\n         |    ]\n         |  }'\n         |)\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{AvroSerDe.class.getCanonicalName(), AvroContainerInputFormat.class.getCanonicalName(), AvroContainerOutputFormat.class.getCanonicalName()})))).stripMargin()).cmd(), this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |ALTER TABLE episodes_part SET SERDEPROPERTIES (\n         |  'avro.schema.literal'='{\n         |    \"type\": \"record\",\n         |    \"name\": \"episodes\",\n         |    \"namespace\": \"testing.hive.avro.serde\",\n         |    \"fields\": [\n         |      {\n         |          \"name\": \"title\",\n         |          \"type\": \"string\",\n         |          \"doc\": \"episode title\"\n         |      },\n         |      {\n         |          \"name\": \"air_date\",\n         |          \"type\": \"string\",\n         |          \"doc\": \"initial date\"\n         |      },\n         |      {\n         |          \"name\": \"doctor\",\n         |          \"type\": \"int\",\n         |          \"doc\": \"main actor playing the Doctor in episode\"\n         |      }\n         |    ]\n         |  }'\n         |)\n        "})).s((Seq)Nil$.MODULE$))).stripMargin()).cmd(), this.SqlCmd(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        INSERT OVERWRITE TABLE episodes_part PARTITION (doctor_pt=1)\n        SELECT title, air_date, doctor FROM episodes\n      "})).s((Seq)Nil$.MODULE$)).cmd()}))}));
        this.hiveQTestUtilTables().foreach((Function1)new Serializable(this){
            private final /* synthetic */ TestHiveContext $outer;

            public final HashMap<String, TestTable> apply(TestTable testTable) {
                return this.$outer.registerTestTable(testTable);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.loadedTables = new HashSet();
        this.cacheTables = false;
        this.originalUdfs = FunctionRegistry.getFunctionNames();
        HiveShim$.MODULE$.createDefaultDBIfNeeded(this);
    }

    public class SqlCmd {
        public final String org$apache$spark$sql$hive$test$TestHiveContext$SqlCmd$$sql;
        public final /* synthetic */ TestHiveContext $outer;

        public Function0<BoxedUnit> cmd() {
            return new Serializable(this){
                private final /* synthetic */ SqlCmd $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    new HiveQLQueryExecution(this.$outer.org$apache$spark$sql$hive$test$TestHiveContext$SqlCmd$$$outer(), this.$outer.org$apache$spark$sql$hive$test$TestHiveContext$SqlCmd$$sql).stringResult();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
        }

        public /* synthetic */ TestHiveContext org$apache$spark$sql$hive$test$TestHiveContext$SqlCmd$$$outer() {
            return this.$outer;
        }

        public SqlCmd(TestHiveContext $outer, String sql2) {
            this.org$apache$spark$sql$hive$test$TestHiveContext$SqlCmd$$sql = sql2;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class TestTable
    implements Product,
    Serializable {
        private final String name;
        private final Seq<Function0<BoxedUnit>> commands;
        public final /* synthetic */ TestHiveContext $outer;

        public String name() {
            return this.name;
        }

        public Seq<Function0<BoxedUnit>> commands() {
            return this.commands;
        }

        public String productPrefix() {
            return "TestTable";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = this.commands();
                    break;
                }
                case 0: {
                    object = this.name();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TestTable;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TestTable)) return false;
            if (((TestTable)object).org$apache$spark$sql$hive$test$TestHiveContext$TestTable$$$outer() != this.org$apache$spark$sql$hive$test$TestHiveContext$TestTable$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            TestTable testTable = (TestTable)x$1;
            String string = this.name();
            String string2 = testTable.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Seq<Function0<BoxedUnit>> seq = this.commands();
            Seq<Function0<BoxedUnit>> seq2 = testTable.commands();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!testTable.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ TestHiveContext org$apache$spark$sql$hive$test$TestHiveContext$TestTable$$$outer() {
            return this.$outer;
        }

        public TestTable(TestHiveContext $outer, String name, Seq<Function0<BoxedUnit>> commands) {
            this.name = name;
            this.commands = commands;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }

    public abstract class QueryExecution
    extends HiveContext.QueryExecution {
        private LogicalPlan analyzed;
        private volatile boolean bitmap$0;

        /*
         * Unable to fully structure code
         */
        private LogicalPlan analyzed$lzycompute() {
            var1_1 = this;
            synchronized (var1_1) {
                block7: {
                    if (this.bitmap$0) break block7;
                    var3_2 = this.logical();
                    if (!(var3_2 instanceof NativeCommand)) ** GOTO lbl-1000
                    var4_3 = (NativeCommand)var3_2;
                    var5_4 = var4_3.cmd();
                    var6_5 = this.org$apache$spark$sql$hive$test$TestHiveContext$QueryExecution$$$outer().describedTable().unapplySeq((CharSequence)var5_4);
                    if (!var6_5.isEmpty() && var6_5.get() != null && ((LinearSeqOptimized)var6_5.get()).lengthCompare(1) == 0) {
                        var9_7 = tbl = (String)((LinearSeqOptimized)var6_5.get()).apply(0);
                        var8_8 = Nil$.MODULE$.$colon$colon((Object)var9_7);
                    } else if (var3_2 instanceof CacheTableCommand) {
                        var10_9 = (CacheTableCommand)var3_2;
                        var12_11 = tbl = var10_9.tableName();
                        var8_8 = Nil$.MODULE$.$colon$colon((Object)var12_11);
                    } else {
                        var8_8 = Nil$.MODULE$;
                    }
                    describedTables = var8_8;
                    referencedTables = (List)describedTables.$plus$plus((GenTraversableOnce)this.logical().collect((PartialFunction)new QueryExecution$$anonfun$4(this)), List$.MODULE$.canBuildFrom());
                    referencedTestTables = (List)referencedTables.filter((Function1)new QueryExecution$$anonfun$7(this));
                    this.org$apache$spark$sql$hive$test$TestHiveContext$QueryExecution$$$outer().logDebug((Function0)new Serializable(this, referencedTestTables){
                        private final List referencedTestTables$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Query references test tables: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.referencedTestTables$1.mkString(", ")}));
                        }
                        {
                            this.referencedTestTables$1 = referencedTestTables$1;
                        }
                    });
                    referencedTestTables.foreach((Function1)new Serializable(this){
                        private final /* synthetic */ QueryExecution $outer;

                        public final void apply(String name) {
                            this.$outer.org$apache$spark$sql$hive$test$TestHiveContext$QueryExecution$$$outer().loadTestTable(name);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.analyzed = (LogicalPlan)this.org$apache$spark$sql$hive$test$TestHiveContext$QueryExecution$$$outer().analyzer().apply((TreeNode)this.logical());
                    this.bitmap$0 = true;
                }
                return this.analyzed;
            }
        }

        public LogicalPlan analyzed() {
            return this.bitmap$0 ? this.analyzed : this.analyzed$lzycompute();
        }

        public /* synthetic */ TestHiveContext org$apache$spark$sql$hive$test$TestHiveContext$QueryExecution$$$outer() {
            return (TestHiveContext)this.$outer;
        }

        public QueryExecution(TestHiveContext $outer) {
            super($outer);
        }
    }

    public class HiveQLQueryExecution
    extends QueryExecution {
        private final String hql;
        private LogicalPlan logical;
        private volatile boolean bitmap$0;

        private LogicalPlan logical$lzycompute() {
            HiveQLQueryExecution hiveQLQueryExecution = this;
            synchronized (hiveQLQueryExecution) {
                if (!this.bitmap$0) {
                    this.logical = HiveQl$.MODULE$.parseSql(this.hql);
                    this.bitmap$0 = true;
                }
                return this.logical;
            }
        }

        public LogicalPlan logical() {
            return this.bitmap$0 ? this.logical : this.logical$lzycompute();
        }

        public Seq<String> hiveExec() {
            return this.org$apache$spark$sql$hive$test$TestHiveContext$HiveQLQueryExecution$$$outer().runSqlHive(this.hql);
        }

        public String toString() {
            return new StringBuilder().append((Object)this.hql).append((Object)"\n").append((Object)super.toString()).toString();
        }

        public /* synthetic */ TestHiveContext org$apache$spark$sql$hive$test$TestHiveContext$HiveQLQueryExecution$$$outer() {
            return (TestHiveContext)this.$outer;
        }

        public HiveQLQueryExecution(TestHiveContext $outer, String hql) {
            this.hql = hql;
            super($outer);
        }
    }
}

