/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.VariableSubstitution;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.spark.SparkContext;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.DataFrame$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLConf;
import org.apache.spark.sql.SQLConf$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.EliminateSubQueries$;
import org.apache.spark.sql.catalyst.analysis.OverrideCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.ExecutedCommand;
import org.apache.spark.sql.execution.QueryExecutionException;
import org.apache.spark.sql.execution.RunnableCommand;
import org.apache.spark.sql.execution.SetCommand;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.hive.HiveContext$;
import org.apache.spark.sql.hive.HiveFunctionRegistry;
import org.apache.spark.sql.hive.HiveMetastoreCatalog;
import org.apache.spark.sql.hive.HiveQl$;
import org.apache.spark.sql.hive.HiveShim$;
import org.apache.spark.sql.hive.MetastoreRelation;
import org.apache.spark.sql.hive.execution.DescribeHiveTableCommand;
import org.apache.spark.sql.hive.execution.HiveNativeCommand;
import org.apache.spark.sql.sources.DDLParser;
import org.apache.spark.sql.types.DataType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\tuh\u0001B\u0001\u0003\u00015\u00111\u0002S5wK\u000e{g\u000e^3yi*\u00111\u0001B\u0001\u0005Q&4XM\u0003\u0002\u0006\r\u0005\u00191/\u001d7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\t%\u0011\u0011\u0003\u0002\u0002\u000b'Fc5i\u001c8uKb$\b\"C\n\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000b\u0019\u0003\t\u00198\r\u0005\u0002\u0016-5\ta!\u0003\u0002\u0018\r\ta1\u000b]1sW\u000e{g\u000e^3yi&\u0011\u0011\u0004E\u0001\rgB\f'o[\"p]R,\u0007\u0010\u001e\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005uy\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001\"B\n\u001b\u0001\u0004!\u0002\"C\u0011\u0001\u0011\u000b\u0007I\u0011\u000b\u0003#\u0003\u0011\u0019wN\u001c4\u0016\u0003\r\u0002\"a\u0004\u0013\n\u0005\u0015\"!aB*R\u0019\u000e{gN\u001a\u0005\tO\u0001A\t\u0011)Q\u0005G\u0005)1m\u001c8gA!1\u0011\u0006\u0001C\t\t)\nqcY8om\u0016\u0014H/T3uCN$xN]3QCJ\fX/\u001a;\u0016\u0003-\u0002\"\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u0012qAQ8pY\u0016\fg\u000e\u0003\u00043\u0001\u0011EAAK\u0001\fG>tg/\u001a:u\u0007R\u000b5\u000b\u0003\u00045\u0001\u0011EC!N\u0001\fKb,7-\u001e;f!2\fg\u000e\u0006\u00027MB\u0011q\u0007O\u0007\u0002\u0001\u0019)\u0011\b\u0001\u0005\u0005u\tq\u0011+^3ss\u0016CXmY;uS>t7C\u0001\u001d<!\t9D(\u0003\u0002:!!Ia\b\u000fB\u0001B\u0003%q(S\u0001\fY><\u0017nY1m!2\fg\u000e\u0005\u0002A\u000f6\t\u0011I\u0003\u0002C\u0007\u00069An\\4jG\u0006d'B\u0001#F\u0003\u0015\u0001H.\u00198t\u0015\t1E!\u0001\u0005dCR\fG._:u\u0013\tA\u0015IA\u0006M_\u001eL7-\u00197QY\u0006t\u0017B\u0001\"=\u0011\u0015Y\u0002\b\"\u0001L)\t1D\nC\u0003?\u0015\u0002\u0007q\bC\u0003Oq\u0011\u0005q*\u0001\u0007tiJLgn\u001a*fgVdG\u000fF\u0001Q!\r\t\u0016\f\u0018\b\u0003%^s!a\u0015,\u000e\u0003QS!!\u0016\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0013B\u0001-.\u0003\u001d\u0001\u0018mY6bO\u0016L!AW.\u0003\u0007M+\u0017O\u0003\u0002Y[A\u0011Q\f\u0019\b\u0003YyK!aX\u0017\u0002\rA\u0013X\rZ3g\u0013\t\t'M\u0001\u0004TiJLgn\u001a\u0006\u0003?6BQ\u0001\u001a\u001d\u0005B\u0015\fAb]5na2,7\u000b\u001e:j]\u001e,\u0012\u0001\u0018\u0005\u0006ON\u0002\raP\u0001\u0005a2\fg\u000eC\u0003\u0006\u0001\u0011\u0005\u0013\u000e\u0006\u0002k[B\u0011qb[\u0005\u0003Y\u0012\u0011\u0011\u0002R1uC\u001a\u0013\u0018-\\3\t\u000b9D\u0007\u0019\u0001/\u0002\u000fM\fH\u000eV3yi\")\u0001\u000f\u0001C\u0001c\u0006a!/\u001a4sKNDG+\u00192mKR\u0011!/\u001e\t\u0003YML!\u0001^\u0017\u0003\tUs\u0017\u000e\u001e\u0005\u0006m>\u0004\r\u0001X\u0001\ni\u0006\u0014G.\u001a(b[\u0016Da\u0001\u001f\u0001\u0005\u0012\tI\u0018aD5om\u0006d\u0017\u000eZ1uKR\u000b'\r\\3\u0015\u0005IT\b\"\u0002<x\u0001\u0004a\u0006\"\u0002?\u0001\t\u0003i\u0018aB1oC2L(0\u001a\u000b\u0003ezDQA^>A\u0002qC3a_A\u0001!\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0011Q\u0001\u0002\r\u000bb\u0004XM]5nK:$\u0018\r\u001c\u0005\b\u0003\u001f\u0001A\u0011IA\t\u0003\u001d\u0019X\r^\"p]\u001a$RA]A\n\u0003/Aq!!\u0006\u0002\u000e\u0001\u0007A,A\u0002lKfDq!!\u0007\u0002\u000e\u0001\u0007A,A\u0003wC2,X\r\u0003\u0005\u0002\u001e\u0001!\t\u0002BA\u0010\u0003)\u0011XO\\*rY\"Kg/\u001a\u000b\u0004!\u0006\u0005\u0002BB\u0003\u0002\u001c\u0001\u0007A\fC\u0004\u0002&\u0001!\t\"a\n\u0002\u000fI,h\u000eS5wKR)\u0001+!\u000b\u0002.!9\u00111FA\u0012\u0001\u0004a\u0016aA2nI\"Q\u0011qFA\u0012!\u0003\u0005\r!!\r\u0002\u000f5\f\u0007PU8xgB\u0019A&a\r\n\u0007\u0005URFA\u0002J]RD!\"!\u000f\u0001\u0005\u0004%\t\u0002BA\u001e\u0003M!G\r\u001c)beN,'oV5uQ\"Kg/Z)M+\t\ti\u0004\u0005\u0003\u0002@\u0005\u0015SBAA!\u0015\r\t\u0019\u0005B\u0001\bg>,(oY3t\u0013\u0011\t9%!\u0011\u0003\u0013\u0011#E\nU1sg\u0016\u0014\b\u0002CA&\u0001\u0001\u0006I!!\u0010\u0002)\u0011$G\u000eU1sg\u0016\u0014x+\u001b;i\u0011&4X-\u0015'!Q\u0011\tI%a\u0014\u0011\u00071\n\t&C\u0002\u0002T5\u0012\u0011\u0002\u001e:b]NLWM\u001c;\t\u0015\u0005]\u0003\u0001#b\u0001\n#\tI&\u0001\u0007pkR\u0004X\u000f\u001e\"vM\u001a,'/\u0006\u0002\u0002\\I!\u0011QLA4\r\u001d\ty&!\u0019\u0001\u00037\u0012A\u0002\u0010:fM&tW-\\3oizB!\"a\u0019\u0001\u0011\u0003\u0005\u000b\u0015BA.\u00035yW\u000f\u001e9vi\n+hMZ3sA!\"\u0011\u0011MA(!\u0011\tI'a\u001d\u000e\u0005\u0005-$\u0002BA7\u0003_\n!![8\u000b\u0005\u0005E\u0014\u0001\u00026bm\u0006LA!!\u001e\u0002l\taq*\u001e;qkR\u001cFO]3b[\"Q\u0011\u0011PA/\u0001\u0004%\t!a\u001f\u0002\u0007A|7/\u0006\u0002\u00022!Q\u0011qPA/\u0001\u0004%\t!!!\u0002\u000fA|7o\u0018\u0013fcR\u0019!/a!\t\u0015\u0005\u0015\u0015QPA\u0001\u0002\u0004\t\t$A\u0002yIEB!\"!#\u0002^\u0001\u0007I\u0011AAF\u0003\u0019\u0011WO\u001a4feV\u0011\u0011Q\u0012\t\u0006Y\u0005=\u0015\u0011G\u0005\u0004\u0003#k#!B!se\u0006L\bBCAK\u0003;\u0002\r\u0011\"\u0001\u0002\u0018\u0006Q!-\u001e4gKJ|F%Z9\u0015\u0007I\fI\n\u0003\u0006\u0002\u0006\u0006M\u0015\u0011!a\u0001\u0003\u001bC1\"!(\u0001\u0011\u000b\u0007I\u0011\u0003\u0002\u0002 \u0006a1/Z:tS>t7\u000b^1uKV\u0011\u0011\u0011\u0015\t\u0005\u0003G\u000b\u0019,\u0004\u0002\u0002&*!\u0011qUAU\u0003\u001d\u0019Xm]:j_:TA!a+\u0002.\u0006\u0011\u0011\u000f\u001c\u0006\u0004\u0007\u0005=&bAAY\u0011\u00051\u0001.\u00193p_BLA!!.\u0002&\na1+Z:tS>t7\u000b^1uK\"Q\u0011\u0011\u0018\u0001\t\u0002\u0003\u0006K!!)\u0002\u001bM,7o]5p]N#\u0018\r^3!Q\u0011\t9,a\u0014\t\u0017\u0005}\u0006\u0001#b\u0001\n#\u0011\u0011\u0011Y\u0001\tQ&4XmY8oMV\u0011\u00111\u0019\t\u0005\u0003\u000b\fI-\u0004\u0002\u0002H*\u0019\u0011%!,\n\t\u0005-\u0017q\u0019\u0002\t\u0011&4XmQ8oM\"Q\u0011q\u001a\u0001\t\u0002\u0003\u0006K!a1\u0002\u0013!Lg/Z2p]\u001a\u0004\u0003\u0006BAg\u0003\u001fB1\"!6\u0001\u0011\u000b\u0007I\u0011\u000b\u0003\u0002X\u000691-\u0019;bY><WCAAm%\u0019\tY.a9\u0002j\u001a9\u0011qLAo\u0001\u0005e\u0007BCAp\u0001!\u0005\t\u0015)\u0003\u0002Z\u0006A1-\u0019;bY><\u0007\u0005\u000b\u0003\u0002^\u0006=\u0003c\u0001\u0010\u0002f&\u0019\u0011q\u001d\u0002\u0003)!Kg/Z'fi\u0006\u001cHo\u001c:f\u0007\u0006$\u0018\r\\8h!\u0011\tY/!=\u000e\u0005\u00055(bAAx\u000b\u0006A\u0011M\\1msNL7/\u0003\u0003\u0002t\u00065(aD(wKJ\u0014\u0018\u000eZ3DCR\fGn\\4\t\u0017\u0005]\b\u0001#b\u0001\n#\"\u0011\u0011`\u0001\u0011MVt7\r^5p]J+w-[:uef,\"!a?\u0013\r\u0005u(Q\u0001B\u0006\r\u001d\ty&a@\u0001\u0003wD!B!\u0001\u0001\u0011\u0003\u0005\u000b\u0015BA~\u0003E1WO\\2uS>t'+Z4jgR\u0014\u0018\u0010\t\u0015\u0005\u0003\u007f\fy\u0005E\u0002\u001f\u0005\u000fI1A!\u0003\u0003\u0005QA\u0015N^3Gk:\u001cG/[8o%\u0016<\u0017n\u001d;ssB!\u00111\u001eB\u0007\u0013\u0011\u0011y!!<\u00031=3XM\u001d:jI\u00164UO\\2uS>t'+Z4jgR\u0014\u0018\u0010C\u0006\u0003\u0014\u0001A)\u0019!C)\t\tU\u0011\u0001C1oC2L(0\u001a:\u0016\u0005\t]!\u0003\u0002B\r\u0005C1q!a\u0018\u0003\u001c\u0001\u00119\u0002\u0003\u0006\u0003\u001e\u0001A\t\u0011)Q\u0005\u0005/\t\u0011\"\u00198bYfTXM\u001d\u0011)\t\tm\u0011q\n\t\u0005\u0003W\u0014\u0019#\u0003\u0003\u0003&\u00055(\u0001C!oC2L(0\u001a:\t\u0015\t%\"\u0011\u0004b\u0001\n\u0003\u0012Y#A\ffqR,g\u000eZ3e%\u0016\u001cx\u000e\\;uS>t'+\u001e7fgV\u0011!Q\u0006\t\u0007\u0005_\u0011ID!\u0010\u000e\u0005\tE\"\u0002\u0002B\u001a\u0005k\t\u0011\"[7nkR\f'\r\\3\u000b\u0007\t]R&\u0001\u0006d_2dWm\u0019;j_:LAAa\u000f\u00032\t!A*[:u!\u0015\u0011yD!\u0012@\u001b\t\u0011\tEC\u0002\u0003D\u0015\u000bQA];mKNLAAa\u0012\u0003B\t!!+\u001e7f\u0011%\u0011Y\u0005\u0001b\u0001\n\u0013\u0011i%A\u0006iSZ,\u0007\u000b\\1o]\u0016\u0014XC\u0001B(%\u0019\u0011\tF!\u0017\u0003`\u00199\u0011q\fB*\u0001\t=\u0003\u0002\u0003B+\u0001\u0001\u0006IAa\u0014\u0002\u0019!Lg/\u001a)mC:tWM\u001d\u0011)\t\tM\u0013q\n\t\u0004o\tm\u0013b\u0001B/!\ta1\u000b]1sWBc\u0017M\u001c8feB\u0019aD!\u0019\n\u0007\t\r$A\u0001\bISZ,7\u000b\u001e:bi\u0016<\u0017.Z:\t\u0015\t\u001d\u0004A1A\u0005R\u0011\u0011i%A\u0004qY\u0006tg.\u001a:\t\u0011\t-\u0004\u0001)A\u0005\u0005\u001f\n\u0001\u0002\u001d7b]:,'\u000f\t\u0015\u0005\u0005S\ny\u0005C\u0005\u0003r\u0001\t\n\u0011\"\u0005\u0003t\u0005\t\"/\u001e8ISZ,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\tU$\u0006BA\u0019\u0005oZ#A!\u001f\u0011\t\tm$1Q\u0007\u0003\u0005{RAAa \u0003\u0002\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000fi\u0013\u0002\u0002BC\u0005{\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u000f\u001d\u0011II\u0001E\u0005\u0005\u0017\u000b1\u0002S5wK\u000e{g\u000e^3yiB\u0019aD!$\u0007\r\u0005\u0011\u0001\u0012\u0002BH'\u0019\u0011iI!%\u0003\u0018B\u0019AFa%\n\u0007\tUUF\u0001\u0004B]f\u0014VM\u001a\t\u0004Y\te\u0015b\u0001BN[\ta1+\u001a:jC2L'0\u00192mK\"91D!$\u0005\u0002\t}EC\u0001BF\u0011)\u0011\u0019K!$C\u0002\u0013E!QU\u0001\u000faJLW.\u001b;jm\u0016$\u0016\u0010]3t+\t\u00119\u000b\u0005\u0004\u0003*\n-&QV\u0007\u0003\u0005kI1A\u0017B\u001b%!\u0011yK!.\u0003>\n]eABA0\u0001\u0001\u0011iKC\u0002\u00034\u0012\tQ\u0001^=qKN\u0004BAa.\u0003:6\u0011!\u0011W\u0005\u0005\u0005w\u0013\tL\u0001\u0006OCRLg/\u001a+za\u0016\u00042\u0001\fB`\u0013\r\u0011\t-\f\u0002\b!J|G-^2u\u0011%\u0011)M!$!\u0002\u0013\u00119+A\bqe&l\u0017\u000e^5wKRK\b/Z:!\u0011%\u0011IM!$\u0005\u0012\u0011\u0011Y-\u0001\u0007u_\"Kg/Z*ue&tw\rF\u0002]\u0005\u001bD\u0001Ba4\u0003H\u0002\u0007!\u0011[\u0001\u0002CB9AFa5\u0003X\nu\u0017b\u0001Bk[\t1A+\u001e9mKJ\u00022\u0001\fBm\u0013\r\u0011Y.\f\u0002\u0004\u0003:L\b\u0003\u0002B\\\u0005?LAA!9\u00032\nAA)\u0019;b)f\u0004X\r\u0003\u0005\u0003f\n5E\u0011\u0003Bt\u0003I!x\u000eS5wKN#(/^2u'R\u0014\u0018N\\4\u0015\u0007q\u0013I\u000f\u0003\u0005\u0003P\n\r\b\u0019\u0001Bi\u0011)\u0011iO!$\u0002\u0002\u0013%!q^\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003rB!!1\u001fB}\u001b\t\u0011)P\u0003\u0003\u0003x\u0006=\u0014\u0001\u00027b]\u001eLAAa?\u0003v\n1qJ\u00196fGR\u0004")
public class HiveContext
extends SQLContext {
    private SQLConf conf;
    private final transient DDLParser ddlParserWithHiveQL = new DDLParser((Function1)new $anonfun$2(this));
    private transient OutputStream outputBuffer;
    private transient SessionState sessionState;
    private transient HiveConf hiveconf;
    private transient HiveMetastoreCatalog catalog;
    private transient HiveFunctionRegistry functionRegistry;
    private transient Analyzer analyzer;
    private final transient SQLContext.SparkPlanner hivePlanner = new $anon$4(this);
    private final transient SQLContext.SparkPlanner planner = this.hivePlanner();
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static String toHiveStructString(Tuple2<Object, DataType> tuple2) {
        return HiveContext$.MODULE$.toHiveStructString(tuple2);
    }

    private SQLConf conf$lzycompute() {
        HiveContext hiveContext = this;
        synchronized (hiveContext) {
            if (!this.bitmap$0) {
                this.conf = new SQLConf(this){

                    public String dialect() {
                        return this.getConf(SQLConf$.MODULE$.DIALECT(), "hiveql");
                    }
                };
                this.bitmap$0 = true;
            }
            return this.conf;
        }
    }

    private OutputStream outputBuffer$lzycompute() {
        HiveContext hiveContext = this;
        synchronized (hiveContext) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.outputBuffer = new $anon$5(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.outputBuffer;
        }
    }

    /*
     * WARNING - void declaration
     */
    private SessionState sessionState$lzycompute() {
        HiveContext hiveContext = this;
        synchronized (hiveContext) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                void var2_2;
                BoxedUnit boxedUnit;
                SessionState state = SessionState.get();
                if (state == null) {
                    state = new SessionState(new HiveConf(SessionState.class));
                    boxedUnit = SessionState.start((SessionState)state);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                if (state.out == null) {
                    state.out = new PrintStream(this.outputBuffer(), true, "UTF-8");
                }
                if (state.err == null) {
                    state.err = new PrintStream(this.outputBuffer(), true, "UTF-8");
                }
                this.sessionState = var2_2;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.sessionState;
        }
    }

    private HiveConf hiveconf$lzycompute() {
        HiveContext hiveContext = this;
        synchronized (hiveContext) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.setConf(this.sessionState().getConf().getAllProperties());
                this.hiveconf = this.sessionState().getConf();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
            return this.hiveconf;
        }
    }

    private HiveMetastoreCatalog catalog$lzycompute() {
        HiveContext hiveContext = this;
        synchronized (hiveContext) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.catalog = new $anon$1(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
            return this.catalog;
        }
    }

    private HiveFunctionRegistry functionRegistry$lzycompute() {
        HiveContext hiveContext = this;
        synchronized (hiveContext) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.functionRegistry = new $anon$2(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
            return this.functionRegistry;
        }
    }

    private Analyzer analyzer$lzycompute() {
        HiveContext hiveContext = this;
        synchronized (hiveContext) {
            if ((byte)(this.bitmap$trans$0 & 0x20) == 0) {
                this.analyzer = new $anon$3(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x20);
            }
            return this.analyzer;
        }
    }

    public SQLConf conf() {
        return this.bitmap$0 ? this.conf : this.conf$lzycompute();
    }

    public boolean convertMetastoreParquet() {
        String string = this.getConf("spark.sql.hive.convertMetastoreParquet", "true");
        String string2 = "true";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public boolean convertCTAS() {
        return new StringOps(Predef$.MODULE$.augmentString(this.getConf("spark.sql.hive.convertCTAS", "false"))).toBoolean();
    }

    public QueryExecution executePlan(LogicalPlan plan) {
        return new QueryExecution(this, plan);
    }

    public DDLParser ddlParserWithHiveQL() {
        return this.ddlParserWithHiveQL;
    }

    public DataFrame sql(String sqlText) {
        block4: {
            DataFrame dataFrame;
            block3: {
                String substituted;
                block2: {
                    substituted = new VariableSubstitution().substitute(this.hiveconf(), sqlText);
                    String string = this.conf().dialect();
                    String string2 = "sql";
                    if (string != null ? !string.equals(string2) : string2 != null) break block2;
                    dataFrame = super.sql(substituted);
                    break block3;
                }
                String string = this.conf().dialect();
                String string3 = "hiveql";
                if (string != null ? !string.equals(string3) : string3 != null) break block4;
                Option ddlPlan = this.ddlParserWithHiveQL().apply(sqlText, false);
                dataFrame = DataFrame$.MODULE$.apply((SQLContext)this, (LogicalPlan)ddlPlan.getOrElse((Function0)new Serializable(this, substituted){
                    private final String substituted$1;

                    public final LogicalPlan apply() {
                        return HiveQl$.MODULE$.parseSql(this.substituted$1);
                    }
                    {
                        this.substituted$1 = substituted$1;
                    }
                }));
            }
            return dataFrame;
        }
        throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported SQL dialect: ", ". Try 'sql' or 'hiveql'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.conf().dialect()})));
    }

    public void refreshTable(String tableName) {
        this.catalog().refreshTable("default", tableName);
    }

    public void invalidateTable(String tableName) {
        this.catalog().invalidateTable("default", tableName);
    }

    @Experimental
    public void analyze(String tableName) {
        LogicalPlan relation = EliminateSubQueries$.MODULE$.apply(((OverrideCatalog)this.catalog()).lookupRelation((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName})), ((OverrideCatalog)this.catalog()).lookupRelation$default$2()));
        LogicalPlan logicalPlan = relation;
        if (logicalPlan instanceof MetastoreRelation) {
            BoxedUnit boxedUnit;
            MetastoreRelation metastoreRelation = (MetastoreRelation)logicalPlan;
            Map tableParameters = metastoreRelation.hiveQlTable().getParameters();
            long oldTotalSize = BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply(tableParameters.get(HiveShim$.MODULE$.getStatsSetupConstTotalSize())).map((Function1)new Serializable(this){

                public final long apply(String x$2) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$2)).toLong();
                }
            }).getOrElse((Function0)new Serializable(this){

                public final long apply() {
                    return this.apply$mcJ$sp();
                }

                public long apply$mcJ$sp() {
                    return 0L;
                }
            }));
            long newTotalSize = this.getFileSizeForTable$1(this.hiveconf(), metastoreRelation.hiveQlTable());
            if (newTotalSize > 0L && newTotalSize != oldTotalSize) {
                tableParameters.put(HiveShim$.MODULE$.getStatsSetupConstTotalSize(), ((Object)BoxesRunTime.boxToLong((long)newTotalSize)).toString());
                org.apache.hadoop.hive.metastore.api.Table hiveTTable = metastoreRelation.hiveQlTable().getTTable();
                hiveTTable.setParameters(tableParameters);
                String tableFullName = new StringBuilder().append((Object)metastoreRelation.hiveQlTable().getDbName()).append((Object)".").append((Object)metastoreRelation.hiveQlTable().getTableName()).toString();
                this.catalog().client().alterTable(tableFullName, new Table(hiveTTable));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return;
        }
        throw new NotImplementedError(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Analyze has only implemented for Hive tables, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but ", " is a ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, logicalPlan.nodeName()}))).toString());
    }

    public OutputStream outputBuffer() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.outputBuffer$lzycompute() : this.outputBuffer;
    }

    public SessionState sessionState() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.sessionState$lzycompute() : this.sessionState;
    }

    public HiveConf hiveconf() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.hiveconf$lzycompute() : this.hiveconf;
    }

    public void setConf(String key, String value) {
        super.setConf(key, value);
        this.runSqlHive(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SET ", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, value})));
    }

    public HiveMetastoreCatalog catalog() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.catalog$lzycompute() : this.catalog;
    }

    public HiveFunctionRegistry functionRegistry() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.functionRegistry$lzycompute() : this.functionRegistry;
    }

    public Analyzer analyzer() {
        return (byte)(this.bitmap$trans$0 & 0x20) == 0 ? this.analyzer$lzycompute() : this.analyzer;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> runSqlHive(String sql2) {
        void var3_3;
        int maxResults = 100000;
        Seq<String> results = this.runHive(sql2, maxResults);
        if (results.size() == maxResults) {
            throw package$.MODULE$.error("RESULTS POSSIBLY TRUNCATED");
        }
        return var3_3;
    }

    public synchronized Seq<String> runHive(String cmd2, int maxRows) {
        try {
            Buffer<String> buffer;
            String cmd_trimmed = cmd2.trim();
            String[] tokens = cmd_trimmed.split("\\s+");
            String cmd_1 = cmd_trimmed.substring(tokens[0].length()).trim();
            CommandProcessor proc = HiveShim$.MODULE$.getCommandProcessor((String[])((Object[])new String[]{tokens[0]}), this.hiveconf());
            SessionState sessionState = SessionState.get();
            SessionState sessionState2 = this.sessionState();
            Object object = !(sessionState != null ? !sessionState.equals(sessionState2) : sessionState2 != null) ? BoxedUnit.UNIT : SessionState.start((SessionState)this.sessionState());
            CommandProcessor commandProcessor = proc;
            if (commandProcessor instanceof Driver) {
                Driver driver = (Driver)commandProcessor;
                ArrayList<Object> results = HiveShim$.MODULE$.createDriverResultsArray();
                CommandProcessorResponse response = driver.run(cmd2);
                if (response.getResponseCode() != 0) {
                    driver.close();
                    throw new QueryExecutionException(response.getErrorMessage());
                }
                driver.setMaxRows(maxRows);
                driver.getResults(results);
                driver.close();
                buffer = HiveShim$.MODULE$.processResults(results);
            } else {
                if (this.sessionState().out != null) {
                    this.sessionState().out.println(new StringBuilder().append((Object)tokens[0]).append((Object)" ").append((Object)cmd_1).toString());
                }
                buffer = (Buffer<String>)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)proc.run(cmd_1).getResponseCode())).toString()}));
            }
            return buffer;
        }
        catch (Exception exception) {
            this.logError((Function0)new Serializable(this){
                private final /* synthetic */ HiveContext $outer;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n            |======================\n            |HIVE FAILURE OUTPUT\n            |======================\n            |", "\n            |======================\n            |END HIVE FAILURE OUTPUT\n            |======================\n          "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.outputBuffer().toString()})))).stripMargin();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            throw exception;
        }
    }

    public int runHive$default$2() {
        return 1000;
    }

    private SQLContext.SparkPlanner hivePlanner() {
        return this.hivePlanner;
    }

    public SQLContext.SparkPlanner planner() {
        return this.planner;
    }

    public final long org$apache$spark$sql$hive$HiveContext$$calculateTableSize$1(FileSystem fs, Path path) {
        FileStatus fileStatus = fs.getFileStatus(path);
        long size = fileStatus.isDir() ? BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(path)).map((Function1)new Serializable(this, fs){
            private final /* synthetic */ HiveContext $outer;
            private final FileSystem fs$1;

            public final long apply(FileStatus status) {
                return this.$outer.org$apache$spark$sql$hive$HiveContext$$calculateTableSize$1(this.fs$1, status.getPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fs$1 = fs$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) : fileStatus.getLen();
        return size;
    }

    private final long getFileSizeForTable$1(HiveConf conf, Table table) {
        Path path = table.getPath();
        long size = 0L;
        try {
            FileSystem fs = path.getFileSystem((Configuration)conf);
            size = this.org$apache$spark$sql$hive$HiveContext$$calculateTableSize$1(fs, path);
        }
        catch (Exception exception) {
            this.logWarning((Function0)new Serializable(this, table, exception){
                private final Table table$1;
                private final Exception e$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to get the size of table ", " in the "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table$1.getTableName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"database ", " because of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table$1.getDbName(), this.e$1.toString()}))).toString();
                }
                {
                    this.table$1 = table$1;
                    this.e$1 = e$1;
                }
            }, exception);
            size = 0L;
        }
        return size;
    }

    public HiveContext(SparkContext sc) {
        super(sc);
    }

    public class QueryExecution
    extends SQLContext.QueryExecution {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Seq<String> stringResult() {
            boolean bl = false;
            ExecutedCommand executedCommand = null;
            SparkPlan sparkPlan = this.executedPlan();
            if (sparkPlan instanceof ExecutedCommand) {
                bl = true;
                executedCommand = (ExecutedCommand)sparkPlan;
                RunnableCommand desc = executedCommand.cmd();
                if (desc instanceof DescribeHiveTableCommand) {
                    DescribeHiveTableCommand describeHiveTableCommand = (DescribeHiveTableCommand)desc;
                    return (Seq)describeHiveTableCommand.run(this.org$apache$spark$sql$hive$HiveContext$QueryExecution$$$outer()).map((Function1)new Serializable(this){

                        public final String apply(Row x0$1) {
                            Row row = x0$1;
                            Some some = Row$.MODULE$.unapplySeq(row);
                            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                                Object name = ((SeqLike)some.get()).apply(0);
                                Object dataType = ((SeqLike)some.get()).apply(1);
                                Object comment = ((SeqLike)some.get()).apply(2);
                                if (name instanceof String) {
                                    String string = (String)name;
                                    if (dataType instanceof String) {
                                        String string2 = (String)dataType;
                                        String string3 = ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{string, string2, (String)Option$.MODULE$.apply((Object)((String)comment)).getOrElse((Function0)new Serializable(this){

                                            public final String apply() {
                                                return "";
                                            }
                                        })}))).map((Function1)new Serializable(this){

                                            public final String apply(String s) {
                                                return String.format(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"%-20s"})).s((Seq)Nil$.MODULE$), s);
                                            }
                                        }, Seq$.MODULE$.canBuildFrom())).mkString("\t");
                                        return string3;
                                    }
                                }
                            }
                            throw new MatchError((Object)row);
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                }
            }
            if (bl) {
                return (Seq)Predef$.MODULE$.refArrayOps((Object[])executedCommand.executeCollect()).map((Function1)new Serializable(this){

                    public final String apply(Row x$10) {
                        return x$10.apply(0).toString();
                    }
                }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
            }
            Seq result = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])sparkPlan.executeCollect()).map((Function1)new Serializable(this){

                public final Seq<Object> apply(Row x$11) {
                    return x$11.toSeq();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)))).toSeq();
            Seq types = (Seq)this.analyzed().output().map((Function1)new Serializable(this){

                public final DataType apply(Attribute x$12) {
                    return x$12.dataType();
                }
            }, Seq$.MODULE$.canBuildFrom());
            return ((SeqLike)((TraversableLike)result.map((Function1)new Serializable(this, types){
                private final Seq types$1;

                public final Seq<String> apply(Seq<Object> x$13) {
                    return (Seq)((TraversableLike)x$13.zip((GenIterable)this.types$1, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){

                        public final String apply(Tuple2<Object, DataType> a) {
                            return HiveContext$.MODULE$.toHiveString(a);
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                }
                {
                    this.types$1 = types$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){

                public final String apply(Seq<String> x$14) {
                    return x$14.mkString("\t");
                }
            }, Seq$.MODULE$.canBuildFrom())).toSeq();
        }

        public String simpleString() {
            LogicalPlan logicalPlan = this.logical();
            String string = logicalPlan instanceof HiveNativeCommand ? "<Native command: executed by Hive>" : (logicalPlan instanceof SetCommand ? "<SET command: executed by Hive, and noted by SQLContext>" : super.simpleString());
            return string;
        }

        public /* synthetic */ HiveContext org$apache$spark$sql$hive$HiveContext$QueryExecution$$$outer() {
            return (HiveContext)this.$outer;
        }

        public QueryExecution(HiveContext $outer, LogicalPlan logicalPlan) {
            super((SQLContext)$outer, logicalPlan);
            SessionState sessionState = SessionState.get();
            SessionState sessionState2 = $outer.sessionState();
            Object object = !(sessionState != null ? !sessionState.equals(sessionState2) : sessionState2 != null) ? BoxedUnit.UNIT : SessionState.start((SessionState)$outer.sessionState());
        }
    }
}

