/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.test;

import java.io.File;
import java.util.Set;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat;
import org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.serde2.RegexSerDe;
import org.apache.hadoop.hive.serde2.avro.AvroSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.SQLConf;
import org.apache.spark.sql.SQLConf$;
import org.apache.spark.sql.catalyst.analysis.OverrideCatalog;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.execution.CacheTableCommand;
import org.apache.spark.sql.hive.HiveContext;
import org.apache.spark.sql.hive.HiveQl$;
import org.apache.spark.sql.hive.HiveShim$;
import org.apache.spark.sql.hive.execution.HiveNativeCommand;
import org.apache.spark.sql.hive.test.TestHiveContext$;
import org.apache.spark.sql.hive.test.TestHiveContext$QueryExecution$;
import org.apache.spark.sql.hive.test.TestHiveContext$TestTable$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\t]h\u0001B\u0001\u0003\u0001=\u0011q\u0002V3ti\"Kg/Z\"p]R,\u0007\u0010\u001e\u0006\u0003\u0007\u0011\tA\u0001^3ti*\u0011QAB\u0001\u0005Q&4XM\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011CE\u0007\u0002\t%\u00111\u0003\u0002\u0002\f\u0011&4XmQ8oi\u0016DH\u000fC\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u00175\u0005\u00111o\u0019\t\u0003/ai\u0011\u0001C\u0005\u00033!\u0011Ab\u00159be.\u001cuN\u001c;fqRL!a\u0007\u000f\u0002\u0019M\u0004\u0018M]6D_:$X\r\u001f;\n\u0005u1!AC*R\u0019\u000e{g\u000e^3yi\")q\u0004\u0001C\u0001A\u00051A(\u001b8jiz\"\"!I\u0012\u0011\u0005\t\u0002Q\"\u0001\u0002\t\u000bUq\u0002\u0019\u0001\f\t\u0011\u0015\u0002\u0001R1A\u0005\u0002\u0019\nQb^1sK\"|Wo]3QCRDW#A\u0014\u0011\u0005!jS\"A\u0015\u000b\u0005)Z\u0013\u0001\u00027b]\u001eT\u0011\u0001L\u0001\u0005U\u00064\u0018-\u0003\u0002/S\t11\u000b\u001e:j]\u001eD\u0001\u0002\r\u0001\t\u0002\u0003\u0006KaJ\u0001\u000fo\u0006\u0014X\r[8vg\u0016\u0004\u0016\r\u001e5!\u0011!\u0011\u0004\u0001#b\u0001\n\u00031\u0013!D7fi\u0006\u001cHo\u001c:f!\u0006$\b\u000e\u0003\u00055\u0001!\u0005\t\u0015)\u0003(\u00039iW\r^1ti>\u0014X\rU1uQ\u0002BQA\u000e\u0001\u0005\u0012]\n\u0011bY8oM&<WO]3\u0015\u0003a\u0002\"!\u000f\u001f\u000e\u0003iR\u0011aO\u0001\u0006g\u000e\fG.Y\u0005\u0003{i\u0012A!\u00168ji\"9q\b\u0001b\u0001\n\u0003\u0001\u0015a\u0003;fgR$V-\u001c9ESJ,\u0012!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t.\n!![8\n\u0005\u0019\u001b%\u0001\u0002$jY\u0016Da\u0001\u0013\u0001!\u0002\u0013\t\u0015\u0001\u0004;fgR$V-\u001c9ESJ\u0004\u0003\u0002\u0003&\u0001\u0011\u000b\u0007I\u0011A&\u0002\u0011!Lg/\u001a%p[\u0016,\u0012\u0001\u0014\t\u0004s5\u000b\u0015B\u0001(;\u0005\u0019y\u0005\u000f^5p]\"A\u0001\u000b\u0001E\u0001B\u0003&A*A\u0005iSZ,\u0007j\\7fA!A!\u000b\u0001EC\u0002\u0013\u00051*A\u0006iSZ,G)\u001a<I_6,\u0007\u0002\u0003+\u0001\u0011\u0003\u0005\u000b\u0015\u0002'\u0002\u0019!Lg/\u001a#fm\"{W.\u001a\u0011\t\u000bY\u0003A\u0011I,\u0002\u0015I,hnU9m\u0011&4X\r\u0006\u0002YUB\u0019\u0011,\u00193\u000f\u0005i{fBA._\u001b\u0005a&BA/\u000f\u0003\u0019a$o\\8u}%\t1(\u0003\u0002au\u00059\u0001/Y2lC\u001e,\u0017B\u00012d\u0005\r\u0019V-\u001d\u0006\u0003Aj\u0002\"!\u001a5\u000f\u0005e2\u0017BA4;\u0003\u0019\u0001&/\u001a3fM&\u0011a&\u001b\u0006\u0003OjBQaB+A\u0002\u0011DQ\u0001\u001c\u0001\u0005B5\f1\"\u001a=fGV$X\r\u00157b]R\u0019a.a\u0006\u0011\u0005=\u0004X\"\u0001\u0001\u0007\tE\u0004\u0001A\u001d\u0002\u000f#V,'/_#yK\u000e,H/[8o'\t\u00018\u000f\u0005\u0002pi&\u0011\u0011O\u0005\u0005\u000bmB\u0014\t\u0011)A\u0005o\u0006\r\u0011a\u00037pO&\u001c\u0017\r\u001c)mC:\u0004\"\u0001_@\u000e\u0003eT!A_>\u0002\u000f1|w-[2bY*\u0011A0`\u0001\u0006a2\fgn\u001d\u0006\u0003}\u001a\t\u0001bY1uC2L8\u000f^\u0005\u0004\u0003\u0003I(a\u0003'pO&\u001c\u0017\r\u001c)mC:L1A_A\u0003\u0013\t\tH\u0004\u0003\u0004 a\u0012\u0005\u0011\u0011\u0002\u000b\u0004]\u0006-\u0001B\u0002<\u0002\b\u0001\u0007q\u000f\u0003\u0006\u0002\u0010AD)\u0019!C!\u0003#\t\u0001\"\u00198bYfTX\rZ\u000b\u0002o\"I\u0011Q\u00039\t\u0002\u0003\u0006Ka^\u0001\nC:\fG.\u001f>fI\u0002Ba!!\u0007l\u0001\u00049\u0018\u0001\u00029mC:D1\"!\b\u0001\u0011\u000b\u0007I\u0011\u000b\u0004\u0002 \u0005!1m\u001c8g+\t\t\t\u0003\u0005\u0003\u0002$\u0005\u0015R\"\u0001\u0004\n\u0007\u0005\u001dbAA\u0004T#2\u001buN\u001c4\t\u0015\u0005-\u0002\u0001#A!B\u0013\t\t#A\u0003d_:4\u0007\u0005C\u0004\u00020\u0001!I!!\r\u0002\u0019\u0015tgOV1s)>4\u0015\u000e\\3\u0015\u00071\u000b\u0019\u0004C\u0004\u00026\u00055\u0002\u0019\u00013\u0002\r\u0015tgOV1s\u0011\u001d\tI\u0004\u0001C\u0005\u0003w\tAB]3xe&$X\rU1uQN$2\u0001ZA\u001f\u0011\u001d\ty$a\u000eA\u0002\u0011\f1aY7e\u0011!\t\u0019\u0005\u0001b\u0001\n\u0003\u0001\u0015!\u00045jm\u00164\u0015\u000e\\3t)\u0016l\u0007\u000fC\u0004\u0002H\u0001\u0001\u000b\u0011B!\u0002\u001d!Lg/\u001a$jY\u0016\u001cH+Z7qA!A\u00111\n\u0001C\u0002\u0013\u0005\u0001)A\u0006j]J+\u0007o\u001c+fgR\u001c\bbBA(\u0001\u0001\u0006I!Q\u0001\rS:\u0014V\r]8UKN$8\u000f\t\u0005\b\u0003'\u0002A\u0011AA+\u0003-9W\r\u001e%jm\u00164\u0015\u000e\\3\u0015\u0007\u0005\u000b9\u0006C\u0004\u0002Z\u0005E\u0003\u0019\u00013\u0002\tA\fG\u000f\u001b\u0005\n\u0003;\u0002!\u0019!C\u0001\u0003?\na\u0002Z3tGJL'-\u001a3UC\ndW-\u0006\u0002\u0002bA!\u00111MA7\u001b\t\t)G\u0003\u0003\u0002h\u0005%\u0014\u0001C7bi\u000eD\u0017N\\4\u000b\u0007\u0005-$(\u0001\u0003vi&d\u0017\u0002BA8\u0003K\u0012QAU3hKbD\u0001\"a\u001d\u0001A\u0003%\u0011\u0011M\u0001\u0010I\u0016\u001c8M]5cK\u0012$\u0016M\u00197fA\u00199\u0011q\u000f\u0001\t\t\u0005e$\u0001\u0006%jm\u0016\fF*U;fef,\u00050Z2vi&|gnE\u0002\u0002v9D!\"! \u0002v\t\u0005\t\u0015!\u0003e\u0003\rA\u0017\u000f\u001c\u0005\b?\u0005UD\u0011AAA)\u0011\t\u0019)!\"\u0011\u0007=\f)\bC\u0004\u0002~\u0005}\u0004\u0019\u00013\t\u0011\u0005%\u0015Q\u000fC\u0001\u0003\u0017\u000b\u0001\u0002[5wK\u0016CXm\u0019\u000b\u00021\"A\u0011qRA;\t\u0003\n\t*\u0001\u0005u_N#(/\u001b8h)\u00059cABAK\u0001\u0001\u000b9JA\u0005UKN$H+\u00192mKNA\u00111SAM\u0003?\u000b)\u000bE\u0002:\u00037K1!!(;\u0005\u0019\te.\u001f*fMB\u0019\u0011(!)\n\u0007\u0005\r&HA\u0004Qe>$Wo\u0019;\u0011\u0007e\n9+C\u0002\u0002*j\u0012AbU3sS\u0006d\u0017N_1cY\u0016D1\"!,\u0002\u0014\nU\r\u0011\"\u0001\u00020\u0006!a.Y7f+\u0005!\u0007BCAZ\u0003'\u0013\t\u0012)A\u0005I\u0006)a.Y7fA!Y\u0011qWAJ\u0005+\u0007I\u0011AA]\u0003!\u0019w.\\7b]\u0012\u001cXCAA^!\u0015I\u0014QXAa\u0013\r\tyL\u000f\u0002\u000byI,\u0007/Z1uK\u0012t\u0004\u0003B\u001d\u0002DbJ1!!2;\u0005%1UO\\2uS>t\u0007\u0007C\u0006\u0002J\u0006M%\u0011#Q\u0001\n\u0005m\u0016!C2p[6\fg\u000eZ:!\u0011\u001dy\u00121\u0013C\u0001\u0003\u001b$b!a4\u0002R\u0006M\u0007cA8\u0002\u0014\"9\u0011QVAf\u0001\u0004!\u0007\u0002CA\\\u0003\u0017\u0004\r!a/\t\u0013\u0005]\u00171SA\u0001\n\u00032\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u0007\u0010\u0003\u0006\u0002\\\u0006M\u0015\u0011!C\u0001\u0003;\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a8\u0011\u0007e\n\t/C\u0002\u0002dj\u00121!\u00138u\u0011)\t9/a%\u0002\u0002\u0013\u0005\u0011\u0011^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tY/!=\u0011\u0007e\ni/C\u0002\u0002pj\u00121!\u00118z\u0011)\t\u00190!:\u0002\u0002\u0003\u0007\u0011q\\\u0001\u0004q\u0012\n\u0004BCA|\u0003'\u000b\t\u0011\"\u0011\u0002z\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002|B1\u0011Q B\u0002\u0003Wl!!a@\u000b\u0007\t\u0005!(\u0001\u0006d_2dWm\u0019;j_:LAA!\u0002\u0002\u0000\nA\u0011\n^3sCR|'\u000f\u0003\u0006\u0003\n\u0005M\u0015\u0011!C\u0001\u0005\u0017\t\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005\u001b\u0011\u0019\u0002E\u0002:\u0005\u001fI1A!\u0005;\u0005\u001d\u0011un\u001c7fC:D!\"a=\u0003\b\u0005\u0005\t\u0019AAv\u0011)\u00119\"a%\u0002\u0002\u0013\u0005#\u0011D\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011q\u001c\u0005\u000b\u0003\u001f\u000b\u0019*!A\u0005B\u0005E\u0005B\u0003B\u0010\u0003'\u000b\t\u0011\"\u0011\u0003\"\u00051Q-];bYN$BA!\u0004\u0003$!Q\u00111\u001fB\u000f\u0003\u0003\u0005\r!a;\b\u0013\t\u001d\u0002!!A\t\u0002\t%\u0012!\u0003+fgR$\u0016M\u00197f!\ry'1\u0006\u0004\n\u0003+\u0003\u0011\u0011!E\u0001\u0005[\u0019bAa\u000b\u00030\u0005\u0015\u0006#\u0003B\u0019\u0005o!\u00171XAh\u001b\t\u0011\u0019DC\u0002\u00036i\nqA];oi&lW-\u0003\u0003\u0003:\tM\"!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oe!9qDa\u000b\u0005\u0002\tuBC\u0001B\u0015\u0011)\tyIa\u000b\u0002\u0002\u0013\u0015\u0013\u0011\u0013\u0005\u000b\u0005\u0007\u0012Y#!A\u0005\u0002\n\u0015\u0013!B1qa2LHCBAh\u0005\u000f\u0012I\u0005C\u0004\u0002.\n\u0005\u0003\u0019\u00013\t\u0011\u0005]&\u0011\ta\u0001\u0003wC!B!\u0014\u0003,\u0005\u0005I\u0011\u0011B(\u0003))h.\u00199qYf\u001cV-\u001d\u000b\u0005\u0005#\u0012i\u0006\u0005\u0003:\u001b\nM\u0003CB\u001d\u0003V\u0011\u0014I&C\u0002\u0003Xi\u0012a\u0001V;qY\u0016\u0014\u0004CBA\u007f\u00057\n\t-C\u0002c\u0003\u007fD!Ba\u0018\u0003L\u0005\u0005\t\u0019AAh\u0003\rAH\u0005\r\u0005\u000b\u0005G\u0012Y#!A\u0005\n\t\u0015\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\u001a\u0011\u0007!\u0012I'C\u0002\u0003l%\u0012aa\u00142kK\u000e$ha\u0002B8\u0001%!!\u0011\u000f\u0002\u0007'Fd7)\u001c3\u0014\t\t5\u0014\u0011\u0014\u0005\n\u000f\t5$\u0011!Q\u0001\n\u0011Dqa\bB7\t\u0003\u00119\b\u0006\u0003\u0003z\tm\u0004cA8\u0003n!1qA!\u001eA\u0002\u0011D\u0001\"a\u0010\u0003n\u0011\u0005!qP\u000b\u0003\u0003\u0003D!Ba!\u0001\u0003\u0003%\u0019\u0002\u0002BC\u0003\u0019\u0019\u0016\u000f\\\"nIR!!\u0011\u0010BD\u0011\u00199!\u0011\u0011a\u0001I\"Q!1\u0012\u0001\t\u0006\u0004%\tA!$\u0002\u0015Q,7\u000f\u001e+bE2,7/\u0006\u0002\u0003\u0010B9!\u0011\u0013BLI\u0006=WB\u0001BJ\u0015\u0011\u0011)*a@\u0002\u000f5,H/\u00192mK&!!\u0011\u0014BJ\u0005\u001dA\u0015m\u001d5NCBD!B!(\u0001\u0011\u0003\u0005\u000b\u0015\u0002BH\u0003-!Xm\u001d;UC\ndWm\u001d\u0011\t\u000f\t\u0005\u0006\u0001\"\u0001\u0003$\u0006\t\"/Z4jgR,'\u000fV3tiR\u000b'\r\\3\u0015\t\t=%Q\u0015\u0005\t\u0005O\u0013y\n1\u0001\u0002P\u0006IA/Z:u)\u0006\u0014G.\u001a\u0005\n\u0005W\u0003!\u0019!C\u0001\u0005[\u000b1\u0003[5wKF#Vm\u001d;Vi&dG+\u00192mKN,\"Aa,\u0011\r\u0005u(1LAh\u0011!\u0011\u0019\f\u0001Q\u0001\n\t=\u0016\u0001\u00065jm\u0016\fF+Z:u+RLG\u000eV1cY\u0016\u001c\b\u0005C\u0005\u00038\u0002\u0011\r\u0011\"\u0003\u0003:\u0006aAn\\1eK\u0012$\u0016M\u00197fgV\u0011!1\u0018\t\u0006\u0005#\u0013i\fZ\u0005\u0005\u0005\u007f\u0013\u0019JA\u0004ICND7+\u001a;\t\u0011\t\r\u0007\u0001)A\u0005\u0005w\u000bQ\u0002\\8bI\u0016$G+\u00192mKN\u0004\u0003\"\u0003Bd\u0001\u0001\u0007I\u0011\u0001Be\u0003-\u0019\u0017m\u00195f)\u0006\u0014G.Z:\u0016\u0005\t5\u0001\"\u0003Bg\u0001\u0001\u0007I\u0011\u0001Bh\u0003=\u0019\u0017m\u00195f)\u0006\u0014G.Z:`I\u0015\fHc\u0001\u001d\u0003R\"Q\u00111\u001fBf\u0003\u0003\u0005\rA!\u0004\t\u0011\tU\u0007\u0001)Q\u0005\u0005\u001b\tAbY1dQ\u0016$\u0016M\u00197fg\u0002BqA!7\u0001\t\u0003\u0011Y.A\u0007m_\u0006$G+Z:u)\u0006\u0014G.\u001a\u000b\u0004q\tu\u0007bBAW\u0005/\u0004\r\u0001\u001a\u0005\n\u0005C\u0004!\u0019!C\t\u0005G\fAb\u001c:jO&t\u0017\r\\+eMN,\"A!:\u0011\u000b\t\u001d(1\u001e3\u000e\u0005\t%(bAA6W%!!Q\u001eBu\u0005\r\u0019V\r\u001e\u0005\t\u0005c\u0004\u0001\u0015!\u0003\u0003f\u0006iqN]5hS:\fG.\u00163gg\u0002BaA!>\u0001\t\u00039\u0014!\u0002:fg\u0016$\b")
public class TestHiveContext
extends HiveContext {
    private String warehousePath;
    private String metastorePath;
    private final File testTempDir;
    private Option<File> hiveHome;
    private Option<File> hiveDevHome;
    private SQLConf conf;
    private final File hiveFilesTemp;
    private final File inRepoTests;
    private final Regex describedTable;
    private HashMap<String, TestTable> testTables;
    private final Seq<TestTable> hiveQTestUtilTables;
    private final HashSet<String> loadedTables;
    private boolean cacheTables;
    private final Set<String> originalUdfs;
    private volatile TestHiveContext$TestTable$ TestTable$module;
    private volatile byte bitmap$0;

    private String warehousePath$lzycompute() {
        TestHiveContext testHiveContext = this;
        synchronized (testHiveContext) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.warehousePath = package$.MODULE$.getTempFilePath("sparkHiveWarehouse", package$.MODULE$.getTempFilePath$default$2()).getCanonicalPath();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.warehousePath;
        }
    }

    private String metastorePath$lzycompute() {
        TestHiveContext testHiveContext = this;
        synchronized (testHiveContext) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.metastorePath = package$.MODULE$.getTempFilePath("sparkHiveMetastore", package$.MODULE$.getTempFilePath$default$2()).getCanonicalPath();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.metastorePath;
        }
    }

    private Option hiveHome$lzycompute() {
        TestHiveContext testHiveContext = this;
        synchronized (testHiveContext) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.hiveHome = this.envVarToFile("HIVE_HOME");
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.hiveHome;
        }
    }

    private Option hiveDevHome$lzycompute() {
        TestHiveContext testHiveContext = this;
        synchronized (testHiveContext) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.hiveDevHome = this.envVarToFile("HIVE_DEV_HOME");
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.hiveDevHome;
        }
    }

    private SQLConf conf$lzycompute() {
        TestHiveContext testHiveContext = this;
        synchronized (testHiveContext) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.conf = new SQLConf(this){

                    public int numShufflePartitions() {
                        return new StringOps(Predef$.MODULE$.augmentString(this.getConf(SQLConf$.MODULE$.SHUFFLE_PARTITIONS(), "5"))).toInt();
                    }

                    public String dialect() {
                        return this.getConf(SQLConf$.MODULE$.DIALECT(), "hiveql");
                    }
                };
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
            return this.conf;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TestHiveContext$TestTable$ TestTable$lzycompute() {
        TestHiveContext testHiveContext = this;
        synchronized (testHiveContext) {
            if (this.TestTable$module != null) return this.TestTable$module;
            this.TestTable$module = new TestHiveContext$TestTable$(this);
            return this.TestTable$module;
        }
    }

    private HashMap testTables$lzycompute() {
        TestHiveContext testHiveContext = this;
        synchronized (testHiveContext) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.testTables = new HashMap();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
            return this.testTables;
        }
    }

    public String warehousePath() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.warehousePath$lzycompute() : this.warehousePath;
    }

    public String metastorePath() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.metastorePath$lzycompute() : this.metastorePath;
    }

    public void configure() {
        this.setConf("javax.jdo.option.ConnectionURL", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jdbc:derby:;databaseName=", ";create=true"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.metastorePath()})));
        this.setConf("hive.metastore.warehouse.dir", this.warehousePath());
        Utils$.MODULE$.registerShutdownDeleteDir(new File(this.warehousePath()));
        Utils$.MODULE$.registerShutdownDeleteDir(new File(this.metastorePath()));
    }

    public File testTempDir() {
        return this.testTempDir;
    }

    public Option<File> hiveHome() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.hiveHome$lzycompute() : this.hiveHome;
    }

    public Option<File> hiveDevHome() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.hiveDevHome$lzycompute() : this.hiveDevHome;
    }

    @Override
    public Seq<String> runSqlHive(String sql2) {
        return super.runSqlHive(this.rewritePaths(sql2));
    }

    @Override
    public QueryExecution executePlan(LogicalPlan plan) {
        return new QueryExecution(this, plan);
    }

    @Override
    public SQLConf conf() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.conf$lzycompute() : this.conf;
    }

    private Option<File> envVarToFile(String envVar) {
        return Option$.MODULE$.apply((Object)System.getenv(envVar)).map((Function1)new Serializable(this){

            public final File apply(String x$1) {
                return new File(x$1);
            }
        });
    }

    private String rewritePaths(String cmd2) {
        String string;
        if (cmd2.toUpperCase().contains("LOAD DATA")) {
            String testDataLocation = (String)this.hiveDevHome().map((Function1)new Serializable(this){

                public final String apply(File x$2) {
                    return x$2.getCanonicalPath();
                }
            }).getOrElse((Function0)new Serializable(this){
                private final /* synthetic */ TestHiveContext $outer;

                public final String apply() {
                    return this.$outer.inRepoTests().getCanonicalPath();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            string = cmd2.replaceAll("\\.\\./\\.\\./", new StringBuilder().append((Object)testDataLocation).append((Object)"/").toString());
        } else {
            string = cmd2;
        }
        return string;
    }

    public File hiveFilesTemp() {
        return this.hiveFilesTemp;
    }

    public File inRepoTests() {
        return this.inRepoTests;
    }

    public File getHiveFile(String path) {
        String stripped = path.replaceAll("\\.\\.\\/", "").replace('/', File.separatorChar);
        return (File)this.hiveDevHome().map((Function1)new Serializable(this, stripped){
            private final String stripped$1;

            public final File apply(File x$3) {
                return new File(x$3, this.stripped$1);
            }
            {
                this.stripped$1 = stripped$1;
            }
        }).filter((Function1)new Serializable(this){

            public final boolean apply(File x$4) {
                return x$4.exists();
            }
        }).getOrElse((Function0)new Serializable(this, stripped){
            private final /* synthetic */ TestHiveContext $outer;
            private final String stripped$1;

            public final File apply() {
                return new File(this.$outer.inRepoTests(), this.stripped$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.stripped$1 = stripped$1;
            }
        });
    }

    public Regex describedTable() {
        return this.describedTable;
    }

    public TestHiveContext$TestTable$ TestTable() {
        return this.TestTable$module == null ? this.TestTable$lzycompute() : this.TestTable$module;
    }

    public SqlCmd SqlCmd(String sql2) {
        return new SqlCmd(this, sql2);
    }

    public HashMap<String, TestTable> testTables() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.testTables$lzycompute() : this.testTables;
    }

    public HashMap<String, TestTable> registerTestTable(TestTable testTable) {
        return this.testTables().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testTable.name()), (Object)testTable));
    }

    public Seq<TestTable> hiveQTestUtilTables() {
        return this.hiveQTestUtilTables;
    }

    private HashSet<String> loadedTables() {
        return this.loadedTables;
    }

    public boolean cacheTables() {
        return this.cacheTables;
    }

    public void cacheTables_$eq(boolean x$1) {
        this.cacheTables = x$1;
    }

    public void loadTestTable(String name) {
        if (!this.loadedTables().contains((Object)name)) {
            this.loadedTables().$plus$eq((Object)name);
            this.logInfo((Function0)new Serializable(this, name){
                private final String name$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading test table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1}));
                }
                {
                    this.name$1 = name$1;
                }
            });
            Seq createCmds = (Seq)this.testTables().get((Object)name).map((Function1)new Serializable(this){

                public final Seq<Function0<BoxedUnit>> apply(TestTable x$7) {
                    return x$7.commands();
                }
            }).getOrElse((Function0)new Serializable(this, name){
                private final String name$1;

                public final Nothing$ apply() {
                    return scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown test table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1})));
                }
                {
                    this.name$1 = name$1;
                }
            });
            createCmds.foreach((Function1)new Serializable(this){

                public final void apply(Function0<BoxedUnit> x$8) {
                    x$8.apply$mcV$sp();
                }
            });
            if (this.cacheTables()) {
                this.cacheTable(name);
            }
        }
    }

    public Set<String> originalUdfs() {
        return this.originalUdfs;
    }

    public void reset() {
        try {
            JavaConversions$.MODULE$.enumerationAsScalaIterator(LogManager.getCurrentLoggers()).foreach((Function1)new Serializable(this){

                public final void apply(Object log) {
                    ((Logger)log).setLevel(Level.WARN);
                }
            });
            this.cacheManager().clearCache();
            this.loadedTables().clear();
            this.catalog().cachedDataSourceTables().invalidateAll();
            JavaConversions$.MODULE$.asScalaBuffer(this.catalog().client().getAllTables("default")).foreach((Function1)new Serializable(this){
                private final /* synthetic */ TestHiveContext $outer;

                public final void apply(String t) {
                    this.$outer.logDebug((Function0)new Serializable(this, t){
                        private final String t$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.t$1}));
                        }
                        {
                            this.t$1 = t$1;
                        }
                    });
                    Table table = this.$outer.catalog().client().getTable("default", t);
                    JavaConversions$.MODULE$.asScalaBuffer(this.$outer.catalog().client().getIndexes("default", t, (short)255)).foreach((Function1)new Serializable(this, t){
                        private final /* synthetic */ $anonfun$reset$2 $outer;
                        private final String t$1;

                        public final boolean apply(Index index) {
                            return this.$outer.org$apache$spark$sql$hive$test$TestHiveContext$$anonfun$$$outer().catalog().client().dropIndex("default", this.t$1, index.getIndexName(), true);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.t$1 = t$1;
                        }
                    });
                    if (!table.isIndexTable()) {
                        this.$outer.catalog().client().dropTable("default", t);
                    }
                }

                public /* synthetic */ TestHiveContext org$apache$spark$sql$hive$test$TestHiveContext$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            ((IterableLike)JavaConversions$.MODULE$.asScalaBuffer(this.catalog().client().getAllDatabases()).filterNot((Function1)new Serializable(this){

                public final boolean apply(String x$9) {
                    String string = x$9;
                    String string2 = "default";
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }
            })).foreach((Function1)new Serializable(this){
                private final /* synthetic */ TestHiveContext $outer;

                public final void apply(String db) {
                    this.$outer.logDebug((Function0)new Serializable(this, db){
                        private final String db$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dropping Database: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.db$1}));
                        }
                        {
                            this.db$1 = db$1;
                        }
                    });
                    this.$outer.catalog().client().dropDatabase(db, true, false, true);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            ((OverrideCatalog)this.catalog()).unregisterAllTables();
            ((IterableLike)JavaConversions$.MODULE$.asScalaSet(FunctionRegistry.getFunctionNames()).filterNot((Function1)new Serializable(this){
                private final /* synthetic */ TestHiveContext $outer;

                public final boolean apply(String x$10) {
                    return this.$outer.originalUdfs().contains(x$10);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            })).foreach((Function1)new Serializable(this){

                public final void apply(String udfName) {
                    FunctionRegistry.unregisterTemporaryUDF((String)udfName);
                }
            });
            this.hiveconf().set("fs.default.name", new File(".").toURI().toString());
            this.runSqlHive("RESET");
            this.runSqlHive("set hive.table.parameters.default=");
            this.runSqlHive("set datanucleus.cache.collections=true");
            this.runSqlHive("set datanucleus.cache.collections.lazy=true");
            this.runSqlHive("set hive.metastore.partition.name.whitelist.pattern=.*");
            this.configure();
            this.runSqlHive("USE default");
            this.loadTestTable("src");
            this.loadTestTable("srcpart");
        }
        catch (Exception exception) {
            this.logError((Function0)new Serializable(this){

                public final String apply() {
                    return "FATAL ERROR: Failed to reset TestDB state.";
                }
            }, exception);
        }
    }

    public TestHiveContext(SparkContext sc) {
        super(sc);
        System.clearProperty("spark.hostPort");
        CommandProcessorFactory.clean((HiveConf)this.hiveconf());
        this.hiveconf().set("hive.plan.serialization.format", "javaXML");
        this.testTempDir = File.createTempFile("testTempFiles", "spark.hive.tmp");
        this.testTempDir().delete();
        this.testTempDir().mkdir();
        Utils$.MODULE$.registerShutdownDeleteDir(this.testTempDir());
        System.setProperty("test.tmp.dir", this.testTempDir().getCanonicalPath());
        this.configure();
        this.hiveFilesTemp = File.createTempFile("catalystHiveFiles", "");
        this.hiveFilesTemp().delete();
        this.hiveFilesTemp().mkdir();
        Utils$.MODULE$.registerShutdownDeleteDir(this.hiveFilesTemp());
        this.inRepoTests = System.getProperty("user.dir").endsWith(new StringBuilder().append((Object)"sql").append((Object)File.separator).append((Object)"hive").toString()) ? new File(new StringBuilder().append((Object)"src").append((Object)File.separator).append((Object)"test").append((Object)File.separator).append((Object)"resources").append((Object)File.separator).toString()) : new File(new StringBuilder().append((Object)"sql").append((Object)File.separator).append((Object)"hive").append((Object)File.separator).append((Object)"src").append((Object)File.separator).append((Object)"test").append((Object)File.separator).append((Object)"resources").toString());
        this.describedTable = new StringOps(Predef$.MODULE$.augmentString("DESCRIBE (\\w+)")).r();
        this.hiveQTestUtilTables = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TestTable[]{new TestTable(this, "src", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd("CREATE TABLE src (key INT, value STRING)").cmd(), this.SqlCmd(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD DATA LOCAL INPATH '", "' INTO TABLE src"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getHiveFile("data/files/kv1.txt")}))).cmd()})), new TestTable(this, "src1", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd("CREATE TABLE src1 (key INT, value STRING)").cmd(), this.SqlCmd(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD DATA LOCAL INPATH '", "' INTO TABLE src1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getHiveFile("data/files/kv3.txt")}))).cmd()})), new TestTable(this, "srcpart", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{new $anonfun$1(this)})), new TestTable(this, "srcpart1", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{new $anonfun$2(this)})), new TestTable(this, "src_thrift", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{new $anonfun$3(this)})), new TestTable(this, "serdeins", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE serdeins (key INT, value STRING)\n         |ROW FORMAT SERDE '", "'\n         |WITH SERDEPROPERTIES ('field.delim'='\\\\t')\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LazySimpleSerDe.class.getCanonicalName()})))).stripMargin()).cmd(), this.SqlCmd("INSERT OVERWRITE TABLE serdeins SELECT * FROM src").cmd()})), new TestTable(this, "sales", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE IF NOT EXISTS sales (key STRING, value INT)\n         |ROW FORMAT SERDE '", "'\n         |WITH SERDEPROPERTIES (\"input.regex\" = \"([^ ]*)\\t([^ ]*)\")\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RegexSerDe.class.getCanonicalName()})))).stripMargin()).cmd(), this.SqlCmd(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD DATA LOCAL INPATH '", "' INTO TABLE sales"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getHiveFile("data/files/sales.txt")}))).cmd()})), new TestTable(this, "episodes", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE episodes (title STRING, air_date STRING, doctor INT)\n         |ROW FORMAT SERDE '", "'\n         |STORED AS\n         |INPUTFORMAT '", "'\n         |OUTPUTFORMAT '", "'\n         |TBLPROPERTIES (\n         |  'avro.schema.literal'='{\n         |    \"type\": \"record\",\n         |    \"name\": \"episodes\",\n         |    \"namespace\": \"testing.hive.avro.serde\",\n         |    \"fields\": [\n         |      {\n         |          \"name\": \"title\",\n         |          \"type\": \"string\",\n         |          \"doc\": \"episode title\"\n         |      },\n         |      {\n         |          \"name\": \"air_date\",\n         |          \"type\": \"string\",\n         |          \"doc\": \"initial date\"\n         |      },\n         |      {\n         |          \"name\": \"doctor\",\n         |          \"type\": \"int\",\n         |          \"doc\": \"main actor playing the Doctor in episode\"\n         |      }\n         |    ]\n         |  }'\n         |)\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{AvroSerDe.class.getCanonicalName(), AvroContainerInputFormat.class.getCanonicalName(), AvroContainerOutputFormat.class.getCanonicalName()})))).stripMargin()).cmd(), this.SqlCmd(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD DATA LOCAL INPATH '", "' INTO TABLE episodes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getHiveFile("data/files/episodes.avro")}))).cmd()})), new TestTable(this, "episodes_part", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE episodes_part (title STRING, air_date STRING, doctor INT)\n         |PARTITIONED BY (doctor_pt INT)\n         |ROW FORMAT SERDE '", "'\n         |STORED AS\n         |INPUTFORMAT '", "'\n         |OUTPUTFORMAT '", "'\n         |TBLPROPERTIES (\n         |  'avro.schema.literal'='{\n         |    \"type\": \"record\",\n         |    \"name\": \"episodes\",\n         |    \"namespace\": \"testing.hive.avro.serde\",\n         |    \"fields\": [\n         |      {\n         |          \"name\": \"title\",\n         |          \"type\": \"string\",\n         |          \"doc\": \"episode title\"\n         |      },\n         |      {\n         |          \"name\": \"air_date\",\n         |          \"type\": \"string\",\n         |          \"doc\": \"initial date\"\n         |      },\n         |      {\n         |          \"name\": \"doctor\",\n         |          \"type\": \"int\",\n         |          \"doc\": \"main actor playing the Doctor in episode\"\n         |      }\n         |    ]\n         |  }'\n         |)\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{AvroSerDe.class.getCanonicalName(), AvroContainerInputFormat.class.getCanonicalName(), AvroContainerOutputFormat.class.getCanonicalName()})))).stripMargin()).cmd(), this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |ALTER TABLE episodes_part SET SERDEPROPERTIES (\n         |  'avro.schema.literal'='{\n         |    \"type\": \"record\",\n         |    \"name\": \"episodes\",\n         |    \"namespace\": \"testing.hive.avro.serde\",\n         |    \"fields\": [\n         |      {\n         |          \"name\": \"title\",\n         |          \"type\": \"string\",\n         |          \"doc\": \"episode title\"\n         |      },\n         |      {\n         |          \"name\": \"air_date\",\n         |          \"type\": \"string\",\n         |          \"doc\": \"initial date\"\n         |      },\n         |      {\n         |          \"name\": \"doctor\",\n         |          \"type\": \"int\",\n         |          \"doc\": \"main actor playing the Doctor in episode\"\n         |      }\n         |    ]\n         |  }'\n         |)\n        "})).s((Seq)Nil$.MODULE$))).stripMargin()).cmd(), this.SqlCmd(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        INSERT OVERWRITE TABLE episodes_part PARTITION (doctor_pt=1)\n        SELECT title, air_date, doctor FROM episodes\n      "})).s((Seq)Nil$.MODULE$)).cmd()}))}));
        this.hiveQTestUtilTables().foreach((Function1)new Serializable(this){
            private final /* synthetic */ TestHiveContext $outer;

            public final HashMap<String, TestTable> apply(TestTable testTable) {
                return this.$outer.registerTestTable(testTable);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.loadedTables = new HashSet();
        this.cacheTables = false;
        this.originalUdfs = FunctionRegistry.getFunctionNames();
        HiveShim$.MODULE$.createDefaultDBIfNeeded(this);
    }

    public class SqlCmd {
        public final String org$apache$spark$sql$hive$test$TestHiveContext$SqlCmd$$sql;
        public final /* synthetic */ TestHiveContext $outer;

        public Function0<BoxedUnit> cmd() {
            return new Serializable(this){
                private final /* synthetic */ SqlCmd $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    new HiveQLQueryExecution(this.$outer.org$apache$spark$sql$hive$test$TestHiveContext$SqlCmd$$$outer(), this.$outer.org$apache$spark$sql$hive$test$TestHiveContext$SqlCmd$$sql).stringResult();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
        }

        public /* synthetic */ TestHiveContext org$apache$spark$sql$hive$test$TestHiveContext$SqlCmd$$$outer() {
            return this.$outer;
        }

        public SqlCmd(TestHiveContext $outer, String sql2) {
            this.org$apache$spark$sql$hive$test$TestHiveContext$SqlCmd$$sql = sql2;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class TestTable
    implements Product,
    Serializable {
        private final String name;
        private final Seq<Function0<BoxedUnit>> commands;
        public final /* synthetic */ TestHiveContext $outer;

        public String name() {
            return this.name;
        }

        public Seq<Function0<BoxedUnit>> commands() {
            return this.commands;
        }

        public String productPrefix() {
            return "TestTable";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = this.commands();
                    break;
                }
                case 0: {
                    object = this.name();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TestTable;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TestTable)) return false;
            if (((TestTable)object).org$apache$spark$sql$hive$test$TestHiveContext$TestTable$$$outer() != this.org$apache$spark$sql$hive$test$TestHiveContext$TestTable$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            TestTable testTable = (TestTable)x$1;
            String string = this.name();
            String string2 = testTable.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Seq<Function0<BoxedUnit>> seq = this.commands();
            Seq<Function0<BoxedUnit>> seq2 = testTable.commands();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!testTable.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ TestHiveContext org$apache$spark$sql$hive$test$TestHiveContext$TestTable$$$outer() {
            return this.$outer;
        }

        public TestTable(TestHiveContext $outer, String name, Seq<Function0<BoxedUnit>> commands) {
            this.name = name;
            this.commands = commands;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }

    public class QueryExecution
    extends HiveContext.QueryExecution {
        private LogicalPlan analyzed;
        private volatile boolean bitmap$0;

        /*
         * Unable to fully structure code
         */
        private LogicalPlan analyzed$lzycompute() {
            var1_1 = this;
            synchronized (var1_1) {
                block7: {
                    if (this.bitmap$0) break block7;
                    var2_2 = this.logical();
                    if (!(var2_2 instanceof HiveNativeCommand)) ** GOTO lbl-1000
                    var3_3 = (HiveNativeCommand)var2_2;
                    var4_4 = var3_3.sql();
                    var5_5 = this.org$apache$spark$sql$hive$test$TestHiveContext$QueryExecution$$$outer().describedTable().unapplySeq((CharSequence)var4_4);
                    if (!var5_5.isEmpty() && var5_5.get() != null && ((LinearSeqOptimized)var5_5.get()).lengthCompare(1) == 0) {
                        var7_7 = tbl = (String)((LinearSeqOptimized)var5_5.get()).apply(0);
                        var8_8 = Nil$.MODULE$.$colon$colon((Object)var7_7);
                    } else if (var2_2 instanceof CacheTableCommand) {
                        var9_9 = (CacheTableCommand)var2_2;
                        var11_11 = tbl = var9_9.tableName();
                        var8_8 = Nil$.MODULE$.$colon$colon((Object)var11_11);
                    } else {
                        var8_8 = Nil$.MODULE$;
                    }
                    describedTables = var8_8;
                    referencedTables = (List)describedTables.$plus$plus((GenTraversableOnce)this.logical().collect((PartialFunction)new QueryExecution$$anonfun$4(this)), List$.MODULE$.canBuildFrom());
                    referencedTestTables = (List)referencedTables.filter((Function1)new QueryExecution$$anonfun$7(this));
                    this.org$apache$spark$sql$hive$test$TestHiveContext$QueryExecution$$$outer().logDebug((Function0)new Serializable(this, referencedTestTables){
                        private final List referencedTestTables$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Query references test tables: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.referencedTestTables$1.mkString(", ")}));
                        }
                        {
                            this.referencedTestTables$1 = referencedTestTables$1;
                        }
                    });
                    referencedTestTables.foreach((Function1)new Serializable(this){
                        private final /* synthetic */ QueryExecution $outer;

                        public final void apply(String name) {
                            this.$outer.org$apache$spark$sql$hive$test$TestHiveContext$QueryExecution$$$outer().loadTestTable(name);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.analyzed = (LogicalPlan)this.org$apache$spark$sql$hive$test$TestHiveContext$QueryExecution$$$outer().analyzer().apply((TreeNode)this.logical());
                    this.bitmap$0 = true;
                }
                return this.analyzed;
            }
        }

        public LogicalPlan analyzed() {
            return this.bitmap$0 ? this.analyzed : this.analyzed$lzycompute();
        }

        public /* synthetic */ TestHiveContext org$apache$spark$sql$hive$test$TestHiveContext$QueryExecution$$$outer() {
            return (TestHiveContext)this.$outer;
        }

        public QueryExecution(TestHiveContext $outer, LogicalPlan logicalPlan) {
            super($outer, logicalPlan);
        }
    }

    public class HiveQLQueryExecution
    extends QueryExecution {
        private final String hql;

        public Seq<String> hiveExec() {
            return this.org$apache$spark$sql$hive$test$TestHiveContext$HiveQLQueryExecution$$$outer().runSqlHive(this.hql);
        }

        public String toString() {
            return new StringBuilder().append((Object)this.hql).append((Object)"\n").append((Object)super.toString()).toString();
        }

        public /* synthetic */ TestHiveContext org$apache$spark$sql$hive$test$TestHiveContext$HiveQLQueryExecution$$$outer() {
            return (TestHiveContext)this.$outer;
        }

        public HiveQLQueryExecution(TestHiveContext $outer, String hql) {
            this.hql = hql;
            super($outer, HiveQl$.MODULE$.parseSql(hql));
        }
    }
}

