/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.VariableSubstitution;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.spark.SparkContext;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.DataFrame$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLConf;
import org.apache.spark.sql.SQLConf$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.EliminateSubQueries$;
import org.apache.spark.sql.catalyst.analysis.OverrideCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.ExecutedCommand;
import org.apache.spark.sql.execution.QueryExecutionException;
import org.apache.spark.sql.execution.RunnableCommand;
import org.apache.spark.sql.execution.SetCommand;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.hive.HiveContext$;
import org.apache.spark.sql.hive.HiveFunctionRegistry;
import org.apache.spark.sql.hive.HiveMetastoreCatalog;
import org.apache.spark.sql.hive.HiveQl$;
import org.apache.spark.sql.hive.HiveShim$;
import org.apache.spark.sql.hive.MetastoreRelation;
import org.apache.spark.sql.hive.execution.DescribeHiveTableCommand;
import org.apache.spark.sql.hive.execution.HiveNativeCommand;
import org.apache.spark.sql.sources.DDLParser;
import org.apache.spark.sql.types.DataType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\r\u0005a\u0001B\u0001\u0003\u00015\u00111\u0002S5wK\u000e{g\u000e^3yi*\u00111\u0001B\u0001\u0005Q&4XM\u0003\u0002\u0006\r\u0005\u00191/\u001d7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\t%\u0011\u0011\u0003\u0002\u0002\u000b'Fc5i\u001c8uKb$\b\"C\n\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000b\u0019\u0003\t\u00198\r\u0005\u0002\u0016-5\ta!\u0003\u0002\u0018\r\ta1\u000b]1sW\u000e{g\u000e^3yi&\u0011\u0011\u0004E\u0001\rgB\f'o[\"p]R,\u0007\u0010\u001e\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005uy\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001\"B\n\u001b\u0001\u0004!\u0002\"C\u0011\u0001\u0011\u000b\u0007I\u0011\u000b\u0003#\u0003\u0011\u0019wN\u001c4\u0016\u0003\r\u0002\"a\u0004\u0013\n\u0005\u0015\"!aB*R\u0019\u000e{gN\u001a\u0005\tO\u0001A\t\u0011)Q\u0005G\u0005)1m\u001c8gA!1\u0011\u0006\u0001C\t\t)\nqcY8om\u0016\u0014H/T3uCN$xN]3QCJ\fX/\u001a;\u0016\u0003-\u0002\"\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u0012qAQ8pY\u0016\fg\u000e\u0003\u00043\u0001\u0011EAAK\u0001)G>tg/\u001a:u\u001b\u0016$\u0018m\u001d;pe\u0016\u0004\u0016M]9vKR<\u0016\u000e\u001e5TG\",W.Y'fe\u001eLgn\u001a\u0005\u0007i\u0001!\t\u0002\u0002\u0016\u0002\u0017\r|gN^3si\u000e#\u0016i\u0015\u0005\u0007m\u0001!\t\u0006B\u001c\u0002\u0017\u0015DXmY;uKBc\u0017M\u001c\u000b\u0003q!\u0004\"!\u000f\u001e\u000e\u0003\u00011Qa\u000f\u0001\t\tq\u0012a\"U;fef,\u00050Z2vi&|gn\u0005\u0002;{A\u0011\u0011HP\u0005\u0003wAA\u0011\u0002\u0011\u001e\u0003\u0002\u0003\u0006I!Q&\u0002\u00171|w-[2bYBc\u0017M\u001c\t\u0003\u0005&k\u0011a\u0011\u0006\u0003\t\u0016\u000bq\u0001\\8hS\u000e\fGN\u0003\u0002G\u000f\u0006)\u0001\u000f\\1og*\u0011\u0001\nB\u0001\tG\u0006$\u0018\r\\=ti&\u0011!j\u0011\u0002\f\u0019><\u0017nY1m!2\fg.\u0003\u0002E}!)1D\u000fC\u0001\u001bR\u0011\u0001H\u0014\u0005\u0006\u00012\u0003\r!\u0011\u0005\u0006!j\"\t!U\u0001\rgR\u0014\u0018N\\4SKN,H\u000e\u001e\u000b\u0002%B\u00191k\u00170\u000f\u0005QKfBA+Y\u001b\u00051&BA,\r\u0003\u0019a$o\\8u}%\ta&\u0003\u0002[[\u00059\u0001/Y2lC\u001e,\u0017B\u0001/^\u0005\r\u0019V-\u001d\u0006\u000356\u0002\"a\u00182\u000f\u00051\u0002\u0017BA1.\u0003\u0019\u0001&/\u001a3fM&\u00111\r\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0005l\u0003\"\u00024;\t\u0003:\u0017\u0001D:j[BdWm\u0015;sS:<W#\u00010\t\u000b%,\u0004\u0019A!\u0002\tAd\u0017M\u001c\u0005\u0006\u000b\u0001!\te\u001b\u000b\u0003Y>\u0004\"aD7\n\u00059$!!\u0003#bi\u00064%/Y7f\u0011\u0015\u0001(\u000e1\u0001_\u0003\u001d\u0019\u0018\u000f\u001c+fqRDQA\u001d\u0001\u0005\u0002M\fAB]3ge\u0016\u001c\b\u000eV1cY\u0016$\"\u0001^<\u0011\u00051*\u0018B\u0001<.\u0005\u0011)f.\u001b;\t\u000ba\f\b\u0019\u00010\u0002\u0013Q\f'\r\\3OC6,\u0007B\u0002>\u0001\t#\u001110A\bj]Z\fG.\u001b3bi\u0016$\u0016M\u00197f)\t!H\u0010C\u0003ys\u0002\u0007a\fC\u0003\u007f\u0001\u0011\u0005q0A\u0004b]\u0006d\u0017P_3\u0015\u0007Q\f\t\u0001C\u0003y{\u0002\u0007a\fK\u0002~\u0003\u000b\u0001B!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u00171\u0011AC1o]>$\u0018\r^5p]&!\u0011qBA\u0005\u00051)\u0005\u0010]3sS6,g\u000e^1m\u0011\u001d\t\u0019\u0002\u0001C!\u0003+\tqa]3u\u0007>tg\rF\u0003u\u0003/\tY\u0002C\u0004\u0002\u001a\u0005E\u0001\u0019\u00010\u0002\u0007-,\u0017\u0010C\u0004\u0002\u001e\u0005E\u0001\u0019\u00010\u0002\u000bY\fG.^3\t\u0011\u0005\u0005\u0002\u0001\"\u0005\u0005\u0003G\t!B];o'Fd\u0007*\u001b<f)\r\u0011\u0016Q\u0005\u0005\u0007\u000b\u0005}\u0001\u0019\u00010\t\u000f\u0005%\u0002\u0001\"\u0005\u0002,\u00059!/\u001e8ISZ,G#\u0002*\u0002.\u0005E\u0002bBA\u0018\u0003O\u0001\rAX\u0001\u0004G6$\u0007BCA\u001a\u0003O\u0001\n\u00111\u0001\u00026\u00059Q.\u0019=S_^\u001c\bc\u0001\u0017\u00028%\u0019\u0011\u0011H\u0017\u0003\u0007%sG\u000f\u0003\u0006\u0002>\u0001\u0011\r\u0011\"\u0005\u0005\u0003\u007f\t1\u0003\u001a3m!\u0006\u00148/\u001a:XSRD\u0007*\u001b<f#2+\"!!\u0011\u0011\t\u0005\r\u0013\u0011J\u0007\u0003\u0003\u000bR1!a\u0012\u0005\u0003\u001d\u0019x.\u001e:dKNLA!a\u0013\u0002F\tIA\t\u0012'QCJ\u001cXM\u001d\u0005\t\u0003\u001f\u0002\u0001\u0015!\u0003\u0002B\u0005!B\r\u001a7QCJ\u001cXM],ji\"D\u0015N^3R\u0019\u0002BC!!\u0014\u0002TA\u0019A&!\u0016\n\u0007\u0005]SFA\u0005ue\u0006t7/[3oi\"Q\u00111\f\u0001\t\u0006\u0004%\t\"!\u0018\u0002\u0019=,H\u000f];u\u0005V4g-\u001a:\u0016\u0005\u0005}#\u0003BA1\u0003W2q!a\u0019\u0002f\u0001\tyF\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0003\u0006\u0002h\u0001A\t\u0011)Q\u0005\u0003?\nQb\\;uaV$()\u001e4gKJ\u0004\u0003\u0006BA3\u0003'\u0002B!!\u001c\u0002x5\u0011\u0011q\u000e\u0006\u0005\u0003c\n\u0019(\u0001\u0002j_*\u0011\u0011QO\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002z\u0005=$\u0001D(viB,Ho\u0015;sK\u0006l\u0007BCA?\u0003C\u0002\r\u0011\"\u0001\u0002\u0000\u0005\u0019\u0001o\\:\u0016\u0005\u0005U\u0002BCAB\u0003C\u0002\r\u0011\"\u0001\u0002\u0006\u00069\u0001o\\:`I\u0015\fHc\u0001;\u0002\b\"Q\u0011\u0011RAA\u0003\u0003\u0005\r!!\u000e\u0002\u0007a$\u0013\u0007\u0003\u0006\u0002\u000e\u0006\u0005\u0004\u0019!C\u0001\u0003\u001f\u000baAY;gM\u0016\u0014XCAAI!\u0015a\u00131SA\u001b\u0013\r\t)*\f\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u000b\u00033\u000b\t\u00071A\u0005\u0002\u0005m\u0015A\u00032vM\u001a,'o\u0018\u0013fcR\u0019A/!(\t\u0015\u0005%\u0015qSA\u0001\u0002\u0004\t\t\nC\u0006\u0002\"\u0002A)\u0019!C\t\u0005\u0005\r\u0016\u0001D:fgNLwN\\*uCR,WCAAS!\u0011\t9+a.\u000e\u0005\u0005%&\u0002BAV\u0003[\u000bqa]3tg&|gN\u0003\u0003\u00020\u0006E\u0016AA9m\u0015\r\u0019\u00111\u0017\u0006\u0004\u0003kC\u0011A\u00025bI>|\u0007/\u0003\u0003\u0002:\u0006%&\u0001D*fgNLwN\\*uCR,\u0007BCA_\u0001!\u0005\t\u0015)\u0003\u0002&\u0006i1/Z:tS>t7\u000b^1uK\u0002BC!a/\u0002T!Y\u00111\u0019\u0001\t\u0006\u0004%\tBAAc\u0003!A\u0017N^3d_:4WCAAd!\u0011\tI-!4\u000e\u0005\u0005-'bA\u0011\u00022&!\u0011qZAf\u0005!A\u0015N^3D_:4\u0007BCAj\u0001!\u0005\t\u0015)\u0003\u0002H\u0006I\u0001.\u001b<fG>tg\r\t\u0015\u0005\u0003#\f\u0019\u0006C\u0006\u0002Z\u0002A)\u0019!C)\t\u0005m\u0017aB2bi\u0006dwnZ\u000b\u0003\u0003;\u0014b!a8\u0002h\u00065haBA2\u0003C\u0004\u0011Q\u001c\u0005\u000b\u0003G\u0004\u0001\u0012!Q!\n\u0005u\u0017\u0001C2bi\u0006dwn\u001a\u0011)\t\u0005\u0005\u00181\u000b\t\u0004=\u0005%\u0018bAAv\u0005\t!\u0002*\u001b<f\u001b\u0016$\u0018m\u001d;pe\u0016\u001c\u0015\r^1m_\u001e\u0004B!a<\u0002v6\u0011\u0011\u0011\u001f\u0006\u0004\u0003g<\u0015\u0001C1oC2L8/[:\n\t\u0005]\u0018\u0011\u001f\u0002\u0010\u001fZ,'O]5eK\u000e\u000bG/\u00197pO\"Y\u00111 \u0001\t\u0006\u0004%\t\u0006BA\u007f\u0003A1WO\\2uS>t'+Z4jgR\u0014\u00180\u0006\u0002\u0002\u0000J1!\u0011\u0001B\u0005\u0005\u001f1q!a\u0019\u0003\u0004\u0001\ty\u0010\u0003\u0006\u0003\u0006\u0001A\t\u0011)Q\u0005\u0003\u007f\f\u0011CZ;oGRLwN\u001c*fO&\u001cHO]=!Q\u0011\u0011\u0019!a\u0015\u0011\u0007y\u0011Y!C\u0002\u0003\u000e\t\u0011A\u0003S5wK\u001a+hn\u0019;j_:\u0014VmZ5tiJL\b\u0003BAx\u0005#IAAa\u0005\u0002r\nArJ^3se&$WMR;oGRLwN\u001c*fO&\u001cHO]=\t\u0017\t]\u0001\u0001#b\u0001\n#\"!\u0011D\u0001\tC:\fG.\u001f>feV\u0011!1\u0004\n\u0005\u0005;\u0011)CB\u0004\u0002d\t}\u0001Aa\u0007\t\u0015\t\u0005\u0002\u0001#A!B\u0013\u0011Y\"A\u0005b]\u0006d\u0017P_3sA!\"!qDA*!\u0011\tyOa\n\n\t\t%\u0012\u0011\u001f\u0002\t\u0003:\fG.\u001f>fe\"Q!Q\u0006B\u000f\u0005\u0004%\tEa\f\u0002/\u0015DH/\u001a8eK\u0012\u0014Vm]8mkRLwN\u001c*vY\u0016\u001cXC\u0001B\u0019!\u0019\u0011\u0019D!\u0010\u0003B5\u0011!Q\u0007\u0006\u0005\u0005o\u0011I$A\u0005j[6,H/\u00192mK*\u0019!1H\u0017\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003@\tU\"\u0001\u0002'jgR\u0004RAa\u0011\u0003J\u0005k!A!\u0012\u000b\u0007\t\u001ds)A\u0003sk2,7/\u0003\u0003\u0003L\t\u0015#\u0001\u0002*vY\u0016D\u0011Ba\u0014\u0001\u0005\u0004%IA!\u0015\u0002\u0017!Lg/\u001a)mC:tWM]\u000b\u0003\u0005'\u0012bA!\u0016\u0003^\t\rdaBA2\u0005/\u0002!1\u000b\u0005\t\u00053\u0002\u0001\u0015!\u0003\u0003T\u0005a\u0001.\u001b<f!2\fgN\\3sA!\"!qKA*!\rI$qL\u0005\u0004\u0005C\u0002\"\u0001D*qCJ\\\u0007\u000b\\1o]\u0016\u0014\bc\u0001\u0010\u0003f%\u0019!q\r\u0002\u0003\u001d!Kg/Z*ue\u0006$XmZ5fg\"Q!1\u000e\u0001C\u0002\u0013ECA!\u0015\u0002\u000fAd\u0017M\u001c8fe\"A!q\u000e\u0001!\u0002\u0013\u0011\u0019&\u0001\u0005qY\u0006tg.\u001a:!Q\u0011\u0011i'a\u0015\t\u0013\tU\u0004!%A\u0005\u0012\t]\u0014!\u0005:v]\"Kg/\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\u0010\u0016\u0005\u0003k\u0011Yh\u000b\u0002\u0003~A!!q\u0010BD\u001b\t\u0011\tI\u0003\u0003\u0003\u0004\n\u0015\u0015!C;oG\",7m[3e\u0015\r\tY!L\u0005\u0005\u0005\u0013\u0013\tIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016<qA!$\u0003\u0011\u0013\u0011y)A\u0006ISZ,7i\u001c8uKb$\bc\u0001\u0010\u0003\u0012\u001a1\u0011A\u0001E\u0005\u0005'\u001bbA!%\u0003\u0016\nm\u0005c\u0001\u0017\u0003\u0018&\u0019!\u0011T\u0017\u0003\r\u0005s\u0017PU3g!\ra#QT\u0005\u0004\u0005?k#\u0001D*fe&\fG.\u001b>bE2,\u0007bB\u000e\u0003\u0012\u0012\u0005!1\u0015\u000b\u0003\u0005\u001fC!Ba*\u0003\u0012\n\u0007I\u0011\u0003BU\u00039\u0001(/[7ji&4X\rV=qKN,\"Aa+\u0011\r\t5&q\u0016BY\u001b\t\u0011I$C\u0002]\u0005s\u0011\u0002Ba-\u0003:\n\u0005'1\u0014\u0004\u0007\u0003G\u0002\u0001A!-\u000b\u0007\t]F!A\u0003usB,7\u000f\u0005\u0003\u0003<\nuVB\u0001B[\u0013\u0011\u0011yL!.\u0003\u00159\u000bG/\u001b<f)f\u0004X\rE\u0002-\u0005\u0007L1A!2.\u0005\u001d\u0001&o\u001c3vGRD\u0011B!3\u0003\u0012\u0002\u0006IAa+\u0002\u001fA\u0014\u0018.\\5uSZ,G+\u001f9fg\u0002B\u0011B!4\u0003\u0012\u0012EAAa4\u0002\u0019Q|\u0007*\u001b<f'R\u0014\u0018N\\4\u0015\u0007y\u0013\t\u000e\u0003\u0005\u0003T\n-\u0007\u0019\u0001Bk\u0003\u0005\t\u0007c\u0002\u0017\u0003X\nm'\u0011]\u0005\u0004\u00053l#A\u0002+va2,'\u0007E\u0002-\u0005;L1Aa8.\u0005\r\te.\u001f\t\u0005\u0005w\u0013\u0019/\u0003\u0003\u0003f\nU&\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u0011\t%(\u0011\u0013C\t\u0005W\f!\u0003^8ISZ,7\u000b\u001e:vGR\u001cFO]5oOR\u0019aL!<\t\u0011\tM'q\u001da\u0001\u0005+D!B!=\u0003\u0012\u0006\u0005I\u0011\u0002Bz\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\tU\b\u0003\u0002B|\u0005{l!A!?\u000b\t\tm\u00181O\u0001\u0005Y\u0006tw-\u0003\u0003\u0003\u0000\ne(AB(cU\u0016\u001cG\u000f")
public class HiveContext
extends SQLContext {
    private SQLConf conf;
    private final transient DDLParser ddlParserWithHiveQL = new DDLParser((Function1)new $anonfun$2(this));
    private transient OutputStream outputBuffer;
    private transient SessionState sessionState;
    private transient HiveConf hiveconf;
    private transient HiveMetastoreCatalog catalog;
    private transient HiveFunctionRegistry functionRegistry;
    private transient Analyzer analyzer;
    private final transient SQLContext.SparkPlanner hivePlanner = new $anon$4(this);
    private final transient SQLContext.SparkPlanner planner = this.hivePlanner();
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static String toHiveStructString(Tuple2<Object, DataType> tuple2) {
        return HiveContext$.MODULE$.toHiveStructString(tuple2);
    }

    private SQLConf conf$lzycompute() {
        HiveContext hiveContext = this;
        synchronized (hiveContext) {
            if (!this.bitmap$0) {
                this.conf = new SQLConf(this){

                    public String dialect() {
                        return this.getConf(SQLConf$.MODULE$.DIALECT(), "hiveql");
                    }
                };
                this.bitmap$0 = true;
            }
            return this.conf;
        }
    }

    private OutputStream outputBuffer$lzycompute() {
        HiveContext hiveContext = this;
        synchronized (hiveContext) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.outputBuffer = new $anon$5(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.outputBuffer;
        }
    }

    /*
     * WARNING - void declaration
     */
    private SessionState sessionState$lzycompute() {
        HiveContext hiveContext = this;
        synchronized (hiveContext) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                void var2_2;
                BoxedUnit boxedUnit;
                SessionState state = SessionState.get();
                if (state == null) {
                    state = new SessionState(new HiveConf(SessionState.class));
                    boxedUnit = SessionState.start((SessionState)state);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                if (state.out == null) {
                    state.out = new PrintStream(this.outputBuffer(), true, "UTF-8");
                }
                if (state.err == null) {
                    state.err = new PrintStream(this.outputBuffer(), true, "UTF-8");
                }
                this.sessionState = var2_2;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.sessionState;
        }
    }

    private HiveConf hiveconf$lzycompute() {
        HiveContext hiveContext = this;
        synchronized (hiveContext) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.setConf(this.sessionState().getConf().getAllProperties());
                this.hiveconf = this.sessionState().getConf();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
            return this.hiveconf;
        }
    }

    private HiveMetastoreCatalog catalog$lzycompute() {
        HiveContext hiveContext = this;
        synchronized (hiveContext) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.catalog = new $anon$2(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
            return this.catalog;
        }
    }

    private HiveFunctionRegistry functionRegistry$lzycompute() {
        HiveContext hiveContext = this;
        synchronized (hiveContext) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.functionRegistry = new $anon$3(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
            return this.functionRegistry;
        }
    }

    private Analyzer analyzer$lzycompute() {
        HiveContext hiveContext = this;
        synchronized (hiveContext) {
            if ((byte)(this.bitmap$trans$0 & 0x20) == 0) {
                this.analyzer = new $anon$1(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x20);
            }
            return this.analyzer;
        }
    }

    public SQLConf conf() {
        return this.bitmap$0 ? this.conf : this.conf$lzycompute();
    }

    public boolean convertMetastoreParquet() {
        String string = this.getConf("spark.sql.hive.convertMetastoreParquet", "true");
        String string2 = "true";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public boolean convertMetastoreParquetWithSchemaMerging() {
        String string = this.getConf("spark.sql.hive.convertMetastoreParquet.mergeSchema", "false");
        String string2 = "true";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public boolean convertCTAS() {
        return new StringOps(Predef$.MODULE$.augmentString(this.getConf("spark.sql.hive.convertCTAS", "false"))).toBoolean();
    }

    public QueryExecution executePlan(LogicalPlan plan) {
        return new QueryExecution(this, plan);
    }

    public DDLParser ddlParserWithHiveQL() {
        return this.ddlParserWithHiveQL;
    }

    public DataFrame sql(String sqlText) {
        block4: {
            DataFrame dataFrame;
            block3: {
                String substituted;
                block2: {
                    substituted = new VariableSubstitution().substitute(this.hiveconf(), sqlText);
                    String string = this.conf().dialect();
                    String string2 = "sql";
                    if (string != null ? !string.equals(string2) : string2 != null) break block2;
                    dataFrame = super.sql(substituted);
                    break block3;
                }
                String string = this.conf().dialect();
                String string3 = "hiveql";
                if (string != null ? !string.equals(string3) : string3 != null) break block4;
                Option ddlPlan = this.ddlParserWithHiveQL().apply(sqlText, false);
                dataFrame = DataFrame$.MODULE$.apply((SQLContext)this, (LogicalPlan)ddlPlan.getOrElse((Function0)new Serializable(this, substituted){
                    private final String substituted$1;

                    public final LogicalPlan apply() {
                        return HiveQl$.MODULE$.parseSql(this.substituted$1);
                    }
                    {
                        this.substituted$1 = substituted$1;
                    }
                }));
            }
            return dataFrame;
        }
        throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported SQL dialect: ", ". Try 'sql' or 'hiveql'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.conf().dialect()})));
    }

    public void refreshTable(String tableName) {
        this.catalog().refreshTable("default", tableName);
    }

    public void invalidateTable(String tableName) {
        this.catalog().invalidateTable("default", tableName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Experimental
    public void analyze(String tableName) {
        BoxedUnit boxedUnit;
        LogicalPlan relation = EliminateSubQueries$.MODULE$.apply(((OverrideCatalog)this.catalog()).lookupRelation((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName})), ((OverrideCatalog)this.catalog()).lookupRelation$default$2()));
        LogicalPlan logicalPlan = relation;
        if (!(logicalPlan instanceof MetastoreRelation)) {
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Analyze only works for Hive tables, but ", " is a ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, logicalPlan.nodeName()})));
        }
        MetastoreRelation metastoreRelation = (MetastoreRelation)logicalPlan;
        Map tableParameters = metastoreRelation.hiveQlTable().getParameters();
        long oldTotalSize = BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply(tableParameters.get(HiveShim$.MODULE$.getStatsSetupConstTotalSize())).map((Function1)new Serializable(this){

            public final long apply(String x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2)).toLong();
            }
        }).getOrElse((Function0)new Serializable(this){

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        long newTotalSize = this.getFileSizeForTable$1(this.hiveconf(), metastoreRelation.hiveQlTable());
        if (newTotalSize > 0L && newTotalSize != oldTotalSize) {
            tableParameters.put(HiveShim$.MODULE$.getStatsSetupConstTotalSize(), ((Object)BoxesRunTime.boxToLong((long)newTotalSize)).toString());
            org.apache.hadoop.hive.metastore.api.Table hiveTTable = metastoreRelation.hiveQlTable().getTTable();
            hiveTTable.setParameters(tableParameters);
            String tableFullName = new StringBuilder().append((Object)metastoreRelation.hiveQlTable().getDbName()).append((Object)".").append((Object)metastoreRelation.hiveQlTable().getTableName()).toString();
            HiveMetastoreCatalog hiveMetastoreCatalog = this.catalog();
            synchronized (hiveMetastoreCatalog) {
                this.catalog().client().alterTable(tableFullName, new Table(hiveTTable));
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl20 : MonitorExitStatement: MONITOREXIT : hiveMetastoreCatalog
                boxedUnit = boxedUnit2;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit3 = boxedUnit;
    }

    public OutputStream outputBuffer() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.outputBuffer$lzycompute() : this.outputBuffer;
    }

    public SessionState sessionState() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.sessionState$lzycompute() : this.sessionState;
    }

    public HiveConf hiveconf() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.hiveconf$lzycompute() : this.hiveconf;
    }

    public void setConf(String key, String value) {
        super.setConf(key, value);
        this.runSqlHive(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SET ", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, value})));
    }

    public HiveMetastoreCatalog catalog() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.catalog$lzycompute() : this.catalog;
    }

    public HiveFunctionRegistry functionRegistry() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.functionRegistry$lzycompute() : this.functionRegistry;
    }

    public Analyzer analyzer() {
        return (byte)(this.bitmap$trans$0 & 0x20) == 0 ? this.analyzer$lzycompute() : this.analyzer;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> runSqlHive(String sql2) {
        void var3_3;
        int maxResults = 100000;
        Seq<String> results = this.runHive(sql2, maxResults);
        if (results.size() == maxResults) {
            throw package$.MODULE$.error("RESULTS POSSIBLY TRUNCATED");
        }
        return var3_3;
    }

    public synchronized Seq<String> runHive(String cmd2, int maxRows) {
        try {
            Buffer<String> buffer;
            String cmd_trimmed = cmd2.trim();
            String[] tokens = cmd_trimmed.split("\\s+");
            String cmd_1 = cmd_trimmed.substring(tokens[0].length()).trim();
            CommandProcessor proc = HiveShim$.MODULE$.getCommandProcessor((String[])((Object[])new String[]{tokens[0]}), this.hiveconf());
            SessionState sessionState = SessionState.get();
            SessionState sessionState2 = this.sessionState();
            Object object = !(sessionState != null ? !sessionState.equals(sessionState2) : sessionState2 != null) ? BoxedUnit.UNIT : SessionState.start((SessionState)this.sessionState());
            CommandProcessor commandProcessor = proc;
            if (commandProcessor instanceof Driver) {
                Driver driver = (Driver)commandProcessor;
                ArrayList<Object> results = HiveShim$.MODULE$.createDriverResultsArray();
                CommandProcessorResponse response = driver.run(cmd2);
                if (response.getResponseCode() != 0) {
                    driver.close();
                    throw new QueryExecutionException(response.getErrorMessage());
                }
                driver.setMaxRows(maxRows);
                driver.getResults(results);
                driver.close();
                buffer = HiveShim$.MODULE$.processResults(results);
            } else {
                if (this.sessionState().out != null) {
                    this.sessionState().out.println(new StringBuilder().append((Object)tokens[0]).append((Object)" ").append((Object)cmd_1).toString());
                }
                buffer = (Buffer<String>)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)proc.run(cmd_1).getResponseCode())).toString()}));
            }
            return buffer;
        }
        catch (Exception exception) {
            this.logError((Function0)new Serializable(this){
                private final /* synthetic */ HiveContext $outer;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n            |======================\n            |HIVE FAILURE OUTPUT\n            |======================\n            |", "\n            |======================\n            |END HIVE FAILURE OUTPUT\n            |======================\n          "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.outputBuffer().toString()})))).stripMargin();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            throw exception;
        }
    }

    public int runHive$default$2() {
        return 1000;
    }

    private SQLContext.SparkPlanner hivePlanner() {
        return this.hivePlanner;
    }

    public SQLContext.SparkPlanner planner() {
        return this.planner;
    }

    public final long org$apache$spark$sql$hive$HiveContext$$calculateTableSize$1(FileSystem fs, Path path) {
        FileStatus fileStatus = fs.getFileStatus(path);
        long size = fileStatus.isDir() ? BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(path)).map((Function1)new Serializable(this, fs){
            private final /* synthetic */ HiveContext $outer;
            private final FileSystem fs$1;

            public final long apply(FileStatus status) {
                return this.$outer.org$apache$spark$sql$hive$HiveContext$$calculateTableSize$1(this.fs$1, status.getPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fs$1 = fs$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) : fileStatus.getLen();
        return size;
    }

    private final long getFileSizeForTable$1(HiveConf conf, Table table) {
        Path path = table.getPath();
        long size = 0L;
        try {
            FileSystem fs = path.getFileSystem((Configuration)conf);
            size = this.org$apache$spark$sql$hive$HiveContext$$calculateTableSize$1(fs, path);
        }
        catch (Exception exception) {
            this.logWarning((Function0)new Serializable(this, table, exception){
                private final Table table$1;
                private final Exception e$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to get the size of table ", " in the "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table$1.getTableName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"database ", " because of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table$1.getDbName(), this.e$1.toString()}))).toString();
                }
                {
                    this.table$1 = table$1;
                    this.e$1 = e$1;
                }
            }, exception);
            size = 0L;
        }
        return size;
    }

    public HiveContext(SparkContext sc) {
        super(sc);
    }

    public class QueryExecution
    extends SQLContext.QueryExecution {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Seq<String> stringResult() {
            boolean bl = false;
            ExecutedCommand executedCommand = null;
            SparkPlan sparkPlan = this.executedPlan();
            if (sparkPlan instanceof ExecutedCommand) {
                bl = true;
                executedCommand = (ExecutedCommand)sparkPlan;
                RunnableCommand desc = executedCommand.cmd();
                if (desc instanceof DescribeHiveTableCommand) {
                    DescribeHiveTableCommand describeHiveTableCommand = (DescribeHiveTableCommand)desc;
                    return (Seq)describeHiveTableCommand.run(this.org$apache$spark$sql$hive$HiveContext$QueryExecution$$$outer()).map((Function1)new Serializable(this){

                        public final String apply(Row x0$1) {
                            Row row = x0$1;
                            Some some = Row$.MODULE$.unapplySeq(row);
                            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                                Object name = ((SeqLike)some.get()).apply(0);
                                Object dataType = ((SeqLike)some.get()).apply(1);
                                Object comment = ((SeqLike)some.get()).apply(2);
                                if (name instanceof String) {
                                    String string = (String)name;
                                    if (dataType instanceof String) {
                                        String string2 = (String)dataType;
                                        String string3 = ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{string, string2, (String)Option$.MODULE$.apply((Object)((String)comment)).getOrElse((Function0)new Serializable(this){

                                            public final String apply() {
                                                return "";
                                            }
                                        })}))).map((Function1)new Serializable(this){

                                            public final String apply(String s) {
                                                return String.format(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"%-20s"})).s((Seq)Nil$.MODULE$), s);
                                            }
                                        }, Seq$.MODULE$.canBuildFrom())).mkString("\t");
                                        return string3;
                                    }
                                }
                            }
                            throw new MatchError((Object)row);
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                }
            }
            if (bl) {
                return (Seq)Predef$.MODULE$.refArrayOps((Object[])executedCommand.executeCollect()).map((Function1)new Serializable(this){

                    public final String apply(Row x$10) {
                        return x$10.apply(0).toString();
                    }
                }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
            }
            Seq result = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])sparkPlan.executeCollect()).map((Function1)new Serializable(this){

                public final Seq<Object> apply(Row x$11) {
                    return x$11.toSeq();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)))).toSeq();
            Seq types = (Seq)this.analyzed().output().map((Function1)new Serializable(this){

                public final DataType apply(Attribute x$12) {
                    return x$12.dataType();
                }
            }, Seq$.MODULE$.canBuildFrom());
            return ((SeqLike)((TraversableLike)result.map((Function1)new Serializable(this, types){
                private final Seq types$1;

                public final Seq<String> apply(Seq<Object> x$13) {
                    return (Seq)((TraversableLike)x$13.zip((GenIterable)this.types$1, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){

                        public final String apply(Tuple2<Object, DataType> a) {
                            return HiveContext$.MODULE$.toHiveString(a);
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                }
                {
                    this.types$1 = types$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){

                public final String apply(Seq<String> x$14) {
                    return x$14.mkString("\t");
                }
            }, Seq$.MODULE$.canBuildFrom())).toSeq();
        }

        public String simpleString() {
            LogicalPlan logicalPlan = this.logical();
            String string = logicalPlan instanceof HiveNativeCommand ? "<Native command: executed by Hive>" : (logicalPlan instanceof SetCommand ? "<SET command: executed by Hive, and noted by SQLContext>" : super.simpleString());
            return string;
        }

        public /* synthetic */ HiveContext org$apache$spark$sql$hive$HiveContext$QueryExecution$$$outer() {
            return (HiveContext)this.$outer;
        }

        public QueryExecution(HiveContext $outer, LogicalPlan logicalPlan) {
            super((SQLContext)$outer, logicalPlan);
            SessionState sessionState = SessionState.get();
            SessionState sessionState2 = $outer.sessionState();
            Object object = !(sessionState != null ? !sessionState.equals(sessionState2) : sessionState2 != null) ? BoxedUnit.UNIT : SessionState.start((SessionState)$outer.sessionState());
        }
    }
}

