/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.orc;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.spark.Logging;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.sql.hive.HiveMetastoreTypes$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;

public final class OrcFileOperator$
implements Logging {
    public static final OrcFileOperator$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new OrcFileOperator$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public Reader getFileReader(String pathStr, Option<Configuration> config) {
        Configuration conf = (Configuration)config.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Configuration apply() {
                return new Configuration();
            }
        });
        Path fspath = new Path(pathStr);
        FileSystem fs = fspath.getFileSystem(conf);
        Seq<Path> orcFiles = this.listOrcFiles(pathStr, conf);
        return OrcFile.createReader((FileSystem)fs, (Path)((Path)orcFiles.head()));
    }

    public Option<Configuration> getFileReader$default$2() {
        return None$.MODULE$;
    }

    public StructType readSchema(String path, Option<Configuration> conf) {
        Reader reader = this.getFileReader(path, conf);
        StructObjectInspector readerInspector = (StructObjectInspector)reader.getObjectInspector();
        String schema = readerInspector.getTypeName();
        return (StructType)HiveMetastoreTypes$.MODULE$.toDataType(schema);
    }

    public StructObjectInspector getObjectInspector(String path, Option<Configuration> conf) {
        return (StructObjectInspector)this.getFileReader(path, conf).getObjectInspector();
    }

    public Seq<Path> listOrcFiles(String pathStr, Configuration conf) {
        Path origPath = new Path(pathStr);
        FileSystem fs = origPath.getFileSystem(conf);
        Path path = origPath.makeQualified(fs);
        Seq paths = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)SparkHadoopUtil$.MODULE$.get().listLeafStatuses(fs, origPath).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$1) {
                return x$1.isDir();
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Path apply(FileStatus x$2) {
                return x$2.getPath();
            }
        }, Seq$.MODULE$.canBuildFrom())).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Path x$3) {
                return x$3.getName().startsWith("_");
            }
        })).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Path x$4) {
                return x$4.getName().startsWith(".");
            }
        });
        if (paths == null || paths.size() == 0) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"orcFileOperator: path ", " does not have valid orc files matching the pattern"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
        }
        return paths;
    }

    private OrcFileOperator$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

