/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst;

import java.sql.Timestamp;
import org.apache.spark.sql.catalyst.SQLBuilderTest;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame$;
import org.apache.spark.sql.catalyst.expressions.TimeAdd;
import org.apache.spark.sql.catalyst.expressions.TimeSub;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.catalyst.expressions.WindowSpecDefinition;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y1A!\u0001\u0002\u0001\u001b\tIR\t\u001f9sKN\u001c\u0018n\u001c8T#2\u0013U/\u001b7eKJ\u001cV/\u001b;f\u0015\t\u0019A!\u0001\u0005dCR\fG._:u\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\tq1+\u0015'Ck&dG-\u001a:UKN$\b\"B\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\u0016!\ty\u0001\u0001")
public class ExpressionSQLBuilderSuite
extends SQLBuilderTest {
    public ExpressionSQLBuilderSuite() {
        this.test("literal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionSQLBuilderSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)"foo"), "'foo'");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)"\"foo\""), "'\"foo\"'");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)"'foo'"), "'\\'foo\\''");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToByte((byte)1)), "1Y");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)2)), "2S");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), "4");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)8L)), "8L");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)1.5f)), "CAST(1.5 AS FLOAT)");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)Float.POSITIVE_INFINITY)), "CAST('Infinity' AS FLOAT)");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)Float.NEGATIVE_INFINITY)), "CAST('-Infinity' AS FLOAT)");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)Float.NaN)), "CAST('NaN' AS FLOAT)");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)2.5)), "2.5D");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY)), "CAST('Infinity' AS DOUBLE)");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Double.NEGATIVE_INFINITY)), "CAST('-Infinity' AS DOUBLE)");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Double.NaN)), "CAST('NaN' AS DOUBLE)");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply("10.0000000").underlying()), "10.0000000BD");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)Timestamp.valueOf("2016-01-01 00:00:00")), "TIMESTAMP('2016-01-01 00:00:00.0')");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("attributes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionSQLBuilderSuite $outer;
            private static Symbol symbol$1;
            private static Symbol symbol$2;
            private static Symbol symbol$3;

            static {
                symbol$1 = Symbol$.MODULE$.apply("a");
                symbol$2 = Symbol$.MODULE$.apply("foo bar");
                symbol$3 = Symbol$.MODULE$.apply("int");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslSymbol(symbol$1).int(), "`a`");
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslSymbol(symbol$2).int(), "`foo bar`");
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslSymbol(symbol$3).int(), "`int`");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("binary comparisons", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionSQLBuilderSuite $outer;
            private static Symbol symbol$4;
            private static Symbol symbol$5;
            private static Symbol symbol$6;

            static {
                symbol$4 = Symbol$.MODULE$.apply("a");
                symbol$5 = Symbol$.MODULE$.apply("b");
                symbol$6 = Symbol$.MODULE$.apply("c");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$4).int()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslSymbol(symbol$5).int()), "(`a` = `b`)");
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$4).int()).$less$eq$greater((Expression)package.expressions$.MODULE$.DslSymbol(symbol$5).int()), "(`a` <=> `b`)");
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$4).int()).$eq$bang$eq((Expression)package.expressions$.MODULE$.DslSymbol(symbol$5).int()), "(NOT (`a` = `b`))");
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$4).int()).$less((Expression)package.expressions$.MODULE$.DslSymbol(symbol$5).int()), "(`a` < `b`)");
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$4).int()).$less$eq((Expression)package.expressions$.MODULE$.DslSymbol(symbol$5).int()), "(`a` <= `b`)");
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$4).int()).$greater((Expression)package.expressions$.MODULE$.DslSymbol(symbol$5).int()), "(`a` > `b`)");
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$4).int()).$greater$eq((Expression)package.expressions$.MODULE$.DslSymbol(symbol$5).int()), "(`a` >= `b`)");
                this.$outer.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$4).int()).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslSymbol(symbol$5).int(), package.expressions$.MODULE$.DslSymbol(symbol$6).int()})), "(`a` IN (`b`, `c`))");
                this.$outer.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$4).int()).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(1), package.expressions$.MODULE$.intToLiteral(2)})), "(`a` IN (1, 2))");
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$4).int()).isNull(), "(`a` IS NULL)");
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$4).int()).isNotNull(), "(`a` IS NOT NULL)");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("logical operators", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionSQLBuilderSuite $outer;
            private static Symbol symbol$7;
            private static Symbol symbol$8;
            private static Symbol symbol$9;

            static {
                symbol$7 = Symbol$.MODULE$.apply("a");
                symbol$8 = Symbol$.MODULE$.apply("b");
                symbol$9 = Symbol$.MODULE$.apply("c");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$7).boolean()).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol(symbol$8).boolean()), "(`a` AND `b`)");
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$7).boolean()).$bar$bar((Expression)package.expressions$.MODULE$.DslSymbol(symbol$8).boolean()), "(`a` OR `b`)");
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$7).boolean()).unary_$bang(), "(NOT `a`)");
                this.$outer.checkSQL((Expression)new If((Expression)package.expressions$.MODULE$.DslSymbol(symbol$7).boolean(), (Expression)package.expressions$.MODULE$.DslSymbol(symbol$8).int(), (Expression)package.expressions$.MODULE$.DslSymbol(symbol$9).int()), "(IF(`a`, `b`, `c`))");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("arithmetic expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionSQLBuilderSuite $outer;
            private static Symbol symbol$10;
            private static Symbol symbol$11;

            static {
                symbol$10 = Symbol$.MODULE$.apply("a");
                symbol$11 = Symbol$.MODULE$.apply("b");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$10).int()).$plus((Expression)package.expressions$.MODULE$.DslSymbol(symbol$11).int()), "(`a` + `b`)");
                this.$outer.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$10).int()).$minus((Expression)package.expressions$.MODULE$.DslSymbol(symbol$11).int()), "(`a` - `b`)");
                this.$outer.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$10).int()).$times((Expression)package.expressions$.MODULE$.DslSymbol(symbol$11).int()), "(`a` * `b`)");
                this.$outer.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$10).int()).$div((Expression)package.expressions$.MODULE$.DslSymbol(symbol$11).int()), "(`a` / `b`)");
                this.$outer.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$10).int()).$percent((Expression)package.expressions$.MODULE$.DslSymbol(symbol$11).int()), "(`a` % `b`)");
                this.$outer.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$10).int()).unary_$minus(), "(- `a`)");
                this.$outer.checkSQL(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$10).int()).$plus((Expression)package.expressions$.MODULE$.DslSymbol(symbol$11).int())).unary_$minus(), "(- (`a` + `b`))");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("window specification", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionSQLBuilderSuite $outer;
            private static Symbol symbol$12;
            private static Symbol symbol$13;
            private static Symbol symbol$14;
            private static Symbol symbol$15;

            static {
                symbol$12 = Symbol$.MODULE$.apply("a");
                symbol$13 = Symbol$.MODULE$.apply("b");
                symbol$14 = Symbol$.MODULE$.apply("c");
                symbol$15 = Symbol$.MODULE$.apply("d");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SpecifiedWindowFrame frame = SpecifiedWindowFrame$.MODULE$.defaultWindowFrame(true, true);
                AttributeReference attributeReference = package.expressions$.MODULE$.DslSymbol(symbol$12).int();
                this.$outer.checkSQL((Expression)new WindowSpecDefinition((Seq)Nil$.MODULE$.$colon$colon((Object)attributeReference), (Seq)Nil$.MODULE$, (WindowFrame)frame), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(PARTITION BY `a` ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{frame})));
                AttributeReference attributeReference2 = package.expressions$.MODULE$.DslSymbol(symbol$12).int();
                AttributeReference attributeReference3 = package.expressions$.MODULE$.DslSymbol(symbol$13).string();
                this.$outer.checkSQL((Expression)new WindowSpecDefinition((Seq)Nil$.MODULE$.$colon$colon((Object)attributeReference3).$colon$colon((Object)attributeReference2), (Seq)Nil$.MODULE$, (WindowFrame)frame), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(PARTITION BY `a`, `b` ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{frame})));
                SortOrder sortOrder = package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$12).int()).asc();
                this.$outer.checkSQL((Expression)new WindowSpecDefinition((Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder), (WindowFrame)frame), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(ORDER BY `a` ASC ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{frame})));
                SortOrder sortOrder2 = package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$12).int()).asc();
                SortOrder sortOrder3 = package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$13).string()).desc();
                this.$outer.checkSQL((Expression)new WindowSpecDefinition((Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder3).$colon$colon((Object)sortOrder2), (WindowFrame)frame), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(ORDER BY `a` ASC, `b` DESC ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{frame})));
                AttributeReference attributeReference4 = package.expressions$.MODULE$.DslSymbol(symbol$12).int();
                AttributeReference attributeReference5 = package.expressions$.MODULE$.DslSymbol(symbol$13).string();
                SortOrder sortOrder4 = package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$14).int()).asc();
                SortOrder sortOrder5 = package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$15).string()).desc();
                this.$outer.checkSQL((Expression)new WindowSpecDefinition((Seq)Nil$.MODULE$.$colon$colon((Object)attributeReference5).$colon$colon((Object)attributeReference4), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder5).$colon$colon((Object)sortOrder4), (WindowFrame)frame), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(PARTITION BY `a`, `b` ORDER BY `c` ASC, `d` DESC ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{frame})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("interval arithmetic", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionSQLBuilderSuite $outer;
            private static Symbol symbol$16;

            static {
                symbol$16 = Symbol$.MODULE$.apply("a");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Literal interval = Literal$.MODULE$.apply((Object)new CalendarInterval(0, 86400000000L));
                this.$outer.checkSQL((Expression)new TimeAdd((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$16), (Expression)interval), "`a` + interval 1 days");
                this.$outer.checkSQL((Expression)new TimeSub((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$16), (Expression)interval), "`a` - interval 1 days");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

