/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.execution.columnar.InMemoryTableScanExec;
import org.apache.spark.sql.hive.CachedTableSuite$;
import org.apache.spark.sql.hive.CachedTableSuite$$anonfun$14$;
import org.apache.spark.sql.hive.CachedTableSuite$$anonfun$14$$anonfun$apply$mcV$sp$22$;
import org.apache.spark.sql.hive.CachedTableSuite$$anonfun$15$;
import org.apache.spark.sql.hive.CachedTableSuite$$anonfun$15$$anonfun$apply$mcV$sp$23$;
import org.apache.spark.sql.hive.test.TestHiveContext;
import org.apache.spark.sql.hive.test.TestHiveSingleton;
import org.apache.spark.sql.hive.test.TestHiveSingleton$class;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestData$internalImplicits$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SQLTestUtils$testImplicits$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockResult;
import org.apache.spark.storage.RDDBlockId;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001q2A!\u0001\u0002\u0001\u001b\t\u00012)Y2iK\u0012$\u0016M\u00197f'VLG/\u001a\u0006\u0003\u0007\u0011\tA\u0001[5wK*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\n\u0019!\ty\u0001#D\u0001\u0005\u0013\t\tBAA\u0005Rk\u0016\u0014\u0018\u0010V3tiB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0005i\u0016\u001cH/\u0003\u0002\u0018)\ta1+\u0015'UKN$X\u000b^5mgB\u0011\u0011dG\u0007\u00025)\u0011QCA\u0005\u00039i\u0011\u0011\u0003V3ti\"Kg/Z*j]\u001edW\r^8o\u0011\u0015q\u0002\u0001\"\u0001 \u0003\u0019a\u0014N\\5u}Q\t\u0001\u0005\u0005\u0002\"\u00015\t!\u0001C\u0003$\u0001\u0011\u0005A%A\u0004sI\u0012LEm\u00144\u0015\u0005\u0015Z\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#aA%oi\")AF\ta\u0001[\u0005IA/\u00192mK:\u000bW.\u001a\t\u0003]Er!AJ\u0018\n\u0005A:\u0013A\u0002)sK\u0012,g-\u0003\u00023g\t11\u000b\u001e:j]\u001eT!\u0001M\u0014\t\u000bU\u0002A\u0011\u0001\u001c\u0002\u001d%\u001cX*\u0019;fe&\fG.\u001b>fIR\u0011qG\u000f\t\u0003MaJ!!O\u0014\u0003\u000f\t{w\u000e\\3b]\")1\b\u000ea\u0001K\u0005)!\u000f\u001a3JI\u0002")
public class CachedTableSuite
extends QueryTest
implements SQLTestUtils,
TestHiveSingleton {
    private final SparkSession spark;
    private final TestHiveContext hiveContext;
    private boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    private final Function1<String, Dataset<Row>> sql;
    private final Dataset<Row> emptyTestData;
    private final Dataset<Row> testData;
    private final Dataset<Row> testData2;
    private final Dataset<Row> testData3;
    private final Dataset<Row> negativeData;
    private final Dataset<Row> largeAndSmallInts;
    private final Dataset<Row> decimalData;
    private final Dataset<Row> binaryData;
    private final Dataset<Row> upperCaseData;
    private final Dataset<Row> lowerCaseData;
    private final RDD<SQLTestData.ArrayData> arrayData;
    private final RDD<SQLTestData.MapData> mapData;
    private final RDD<SQLTestData.StringData> repeatedData;
    private final RDD<SQLTestData.StringData> nullableRepeatedData;
    private final Dataset<Row> nullInts;
    private final Dataset<Row> allNulls;
    private final Dataset<Row> nullStrings;
    private final Dataset<Row> tableName;
    private final RDD<String> unparsedStrings;
    private final RDD<SQLTestData.IntField> withEmptyParts;
    private final Dataset<Row> person;
    private final Dataset<Row> salary;
    private final Dataset<Row> complexData;
    private final Dataset<Row> courseSales;
    private volatile int bitmap$0;
    private volatile SQLTestUtils$testImplicits$ testImplicits$module;
    private volatile SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits$module;

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public TestHiveContext hiveContext() {
        return this.hiveContext;
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveContext_$eq(TestHiveContext x$1) {
        this.hiveContext = x$1;
    }

    @Override
    public void afterAll() {
        TestHiveSingleton$class.afterAll(this);
    }

    public boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests() {
        return this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    }

    public void org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(boolean x$1) {
        this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests = x$1;
    }

    private Function1 sql$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 1) == 0) {
                this.sql = SQLTestUtils.class.sql((SQLTestUtils)this);
                this.bitmap$0 |= 1;
            }
            return this.sql;
        }
    }

    public Function1<String, Dataset<Row>> sql() {
        return (this.bitmap$0 & 1) == 0 ? this.sql$lzycompute() : this.sql;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SQLTestUtils$testImplicits$ testImplicits$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if (this.testImplicits$module != null) return this.testImplicits$module;
            this.testImplicits$module = new SQLTestUtils$testImplicits$((SQLTestUtils)this);
            return this.testImplicits$module;
        }
    }

    public SQLTestUtils$testImplicits$ testImplicits() {
        return this.testImplicits$module == null ? this.testImplicits$lzycompute() : this.testImplicits$module;
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    public SparkContext sparkContext() {
        return SQLTestUtils.class.sparkContext((SQLTestUtils)this);
    }

    public void setupTestData() {
        SQLTestUtils.class.setupTestData((SQLTestUtils)this);
    }

    public void beforeAll() {
        SQLTestUtils.class.beforeAll((SQLTestUtils)this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLTestUtils.class.withSQLConf((SQLTestUtils)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLTestUtils.class.withTempPath((SQLTestUtils)this, f);
    }

    public void withTempDir(Function1<File, BoxedUnit> f) {
        SQLTestUtils.class.withTempDir((SQLTestUtils)this, f);
    }

    public void withUserDefinedFunction(Seq<Tuple2<String, Object>> functions2, Function0<BoxedUnit> f) {
        SQLTestUtils.class.withUserDefinedFunction((SQLTestUtils)this, functions2, f);
    }

    public void withTempView(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtils.class.withTempView((SQLTestUtils)this, tableNames, f);
    }

    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtils.class.withTable((SQLTestUtils)this, tableNames, f);
    }

    public void withView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtils.class.withView((SQLTestUtils)this, viewNames, f);
    }

    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLTestUtils.class.withTempDatabase((SQLTestUtils)this, f);
    }

    public void activateDatabase(String db, Function0<BoxedUnit> f) {
        SQLTestUtils.class.activateDatabase((SQLTestUtils)this, (String)db, f);
    }

    public Dataset<Row> stripSparkFilter(Dataset<Row> df) {
        return SQLTestUtils.class.stripSparkFilter((SQLTestUtils)this, df);
    }

    public Dataset<Row> logicalPlanToSparkQuery(LogicalPlan plan) {
        return SQLTestUtils.class.logicalPlanToSparkQuery((SQLTestUtils)this, (LogicalPlan)plan);
    }

    public void testQuietly(String name, Function0<BoxedUnit> f) {
        SQLTestUtils.class.testQuietly((SQLTestUtils)this, (String)name, f);
    }

    public void testWithUninterruptibleThread(String name, boolean quietly, Function0<BoxedUnit> body) {
        SQLTestUtils.class.testWithUninterruptibleThread((SQLTestUtils)this, (String)name, (boolean)quietly, body);
    }

    public boolean testWithUninterruptibleThread$default$2() {
        return SQLTestUtils.class.testWithUninterruptibleThread$default$2((SQLTestUtils)this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if (this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module != null) return this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module;
            this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module = new SQLTestData$internalImplicits$((SQLTestData)this);
            return this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module;
        }
    }

    public final SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits() {
        return this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module == null ? this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute() : this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module;
    }

    private Dataset emptyTestData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 2) == 0) {
                this.emptyTestData = SQLTestData.class.emptyTestData((SQLTestData)this);
                this.bitmap$0 |= 2;
            }
            return this.emptyTestData;
        }
    }

    public Dataset<Row> emptyTestData() {
        return (this.bitmap$0 & 2) == 0 ? this.emptyTestData$lzycompute() : this.emptyTestData;
    }

    private Dataset testData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 4) == 0) {
                this.testData = SQLTestData.class.testData((SQLTestData)this);
                this.bitmap$0 |= 4;
            }
            return this.testData;
        }
    }

    public Dataset<Row> testData() {
        return (this.bitmap$0 & 4) == 0 ? this.testData$lzycompute() : this.testData;
    }

    private Dataset testData2$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 8) == 0) {
                this.testData2 = SQLTestData.class.testData2((SQLTestData)this);
                this.bitmap$0 |= 8;
            }
            return this.testData2;
        }
    }

    public Dataset<Row> testData2() {
        return (this.bitmap$0 & 8) == 0 ? this.testData2$lzycompute() : this.testData2;
    }

    private Dataset testData3$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.testData3 = SQLTestData.class.testData3((SQLTestData)this);
                this.bitmap$0 |= 0x10;
            }
            return this.testData3;
        }
    }

    public Dataset<Row> testData3() {
        return (this.bitmap$0 & 0x10) == 0 ? this.testData3$lzycompute() : this.testData3;
    }

    private Dataset negativeData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.negativeData = SQLTestData.class.negativeData((SQLTestData)this);
                this.bitmap$0 |= 0x20;
            }
            return this.negativeData;
        }
    }

    public Dataset<Row> negativeData() {
        return (this.bitmap$0 & 0x20) == 0 ? this.negativeData$lzycompute() : this.negativeData;
    }

    private Dataset largeAndSmallInts$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.largeAndSmallInts = SQLTestData.class.largeAndSmallInts((SQLTestData)this);
                this.bitmap$0 |= 0x40;
            }
            return this.largeAndSmallInts;
        }
    }

    public Dataset<Row> largeAndSmallInts() {
        return (this.bitmap$0 & 0x40) == 0 ? this.largeAndSmallInts$lzycompute() : this.largeAndSmallInts;
    }

    private Dataset decimalData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.decimalData = SQLTestData.class.decimalData((SQLTestData)this);
                this.bitmap$0 |= 0x80;
            }
            return this.decimalData;
        }
    }

    public Dataset<Row> decimalData() {
        return (this.bitmap$0 & 0x80) == 0 ? this.decimalData$lzycompute() : this.decimalData;
    }

    private Dataset binaryData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.binaryData = SQLTestData.class.binaryData((SQLTestData)this);
                this.bitmap$0 |= 0x100;
            }
            return this.binaryData;
        }
    }

    public Dataset<Row> binaryData() {
        return (this.bitmap$0 & 0x100) == 0 ? this.binaryData$lzycompute() : this.binaryData;
    }

    private Dataset upperCaseData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.upperCaseData = SQLTestData.class.upperCaseData((SQLTestData)this);
                this.bitmap$0 |= 0x200;
            }
            return this.upperCaseData;
        }
    }

    public Dataset<Row> upperCaseData() {
        return (this.bitmap$0 & 0x200) == 0 ? this.upperCaseData$lzycompute() : this.upperCaseData;
    }

    private Dataset lowerCaseData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.lowerCaseData = SQLTestData.class.lowerCaseData((SQLTestData)this);
                this.bitmap$0 |= 0x400;
            }
            return this.lowerCaseData;
        }
    }

    public Dataset<Row> lowerCaseData() {
        return (this.bitmap$0 & 0x400) == 0 ? this.lowerCaseData$lzycompute() : this.lowerCaseData;
    }

    private RDD arrayData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.arrayData = SQLTestData.class.arrayData((SQLTestData)this);
                this.bitmap$0 |= 0x800;
            }
            return this.arrayData;
        }
    }

    public RDD<SQLTestData.ArrayData> arrayData() {
        return (this.bitmap$0 & 0x800) == 0 ? this.arrayData$lzycompute() : this.arrayData;
    }

    private RDD mapData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.mapData = SQLTestData.class.mapData((SQLTestData)this);
                this.bitmap$0 |= 0x1000;
            }
            return this.mapData;
        }
    }

    public RDD<SQLTestData.MapData> mapData() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.mapData$lzycompute() : this.mapData;
    }

    private RDD repeatedData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.repeatedData = SQLTestData.class.repeatedData((SQLTestData)this);
                this.bitmap$0 |= 0x2000;
            }
            return this.repeatedData;
        }
    }

    public RDD<SQLTestData.StringData> repeatedData() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.repeatedData$lzycompute() : this.repeatedData;
    }

    private RDD nullableRepeatedData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.nullableRepeatedData = SQLTestData.class.nullableRepeatedData((SQLTestData)this);
                this.bitmap$0 |= 0x4000;
            }
            return this.nullableRepeatedData;
        }
    }

    public RDD<SQLTestData.StringData> nullableRepeatedData() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.nullableRepeatedData$lzycompute() : this.nullableRepeatedData;
    }

    private Dataset nullInts$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.nullInts = SQLTestData.class.nullInts((SQLTestData)this);
                this.bitmap$0 |= 0x8000;
            }
            return this.nullInts;
        }
    }

    public Dataset<Row> nullInts() {
        return (this.bitmap$0 & 0x8000) == 0 ? this.nullInts$lzycompute() : this.nullInts;
    }

    private Dataset allNulls$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.allNulls = SQLTestData.class.allNulls((SQLTestData)this);
                this.bitmap$0 |= 0x10000;
            }
            return this.allNulls;
        }
    }

    public Dataset<Row> allNulls() {
        return (this.bitmap$0 & 0x10000) == 0 ? this.allNulls$lzycompute() : this.allNulls;
    }

    private Dataset nullStrings$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.nullStrings = SQLTestData.class.nullStrings((SQLTestData)this);
                this.bitmap$0 |= 0x20000;
            }
            return this.nullStrings;
        }
    }

    public Dataset<Row> nullStrings() {
        return (this.bitmap$0 & 0x20000) == 0 ? this.nullStrings$lzycompute() : this.nullStrings;
    }

    private Dataset tableName$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.tableName = SQLTestData.class.tableName((SQLTestData)this);
                this.bitmap$0 |= 0x40000;
            }
            return this.tableName;
        }
    }

    public Dataset<Row> tableName() {
        return (this.bitmap$0 & 0x40000) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    private RDD unparsedStrings$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x80000) == 0) {
                this.unparsedStrings = SQLTestData.class.unparsedStrings((SQLTestData)this);
                this.bitmap$0 |= 0x80000;
            }
            return this.unparsedStrings;
        }
    }

    public RDD<String> unparsedStrings() {
        return (this.bitmap$0 & 0x80000) == 0 ? this.unparsedStrings$lzycompute() : this.unparsedStrings;
    }

    private RDD withEmptyParts$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.withEmptyParts = SQLTestData.class.withEmptyParts((SQLTestData)this);
                this.bitmap$0 |= 0x100000;
            }
            return this.withEmptyParts;
        }
    }

    public RDD<SQLTestData.IntField> withEmptyParts() {
        return (this.bitmap$0 & 0x100000) == 0 ? this.withEmptyParts$lzycompute() : this.withEmptyParts;
    }

    private Dataset person$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x200000) == 0) {
                this.person = SQLTestData.class.person((SQLTestData)this);
                this.bitmap$0 |= 0x200000;
            }
            return this.person;
        }
    }

    public Dataset<Row> person() {
        return (this.bitmap$0 & 0x200000) == 0 ? this.person$lzycompute() : this.person;
    }

    private Dataset salary$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.salary = SQLTestData.class.salary((SQLTestData)this);
                this.bitmap$0 |= 0x400000;
            }
            return this.salary;
        }
    }

    public Dataset<Row> salary() {
        return (this.bitmap$0 & 0x400000) == 0 ? this.salary$lzycompute() : this.salary;
    }

    private Dataset complexData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x800000) == 0) {
                this.complexData = SQLTestData.class.complexData((SQLTestData)this);
                this.bitmap$0 |= 0x800000;
            }
            return this.complexData;
        }
    }

    public Dataset<Row> complexData() {
        return (this.bitmap$0 & 0x800000) == 0 ? this.complexData$lzycompute() : this.complexData;
    }

    private Dataset courseSales$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x1000000) == 0) {
                this.courseSales = SQLTestData.class.courseSales((SQLTestData)this);
                this.bitmap$0 |= 0x1000000;
            }
            return this.courseSales;
        }
    }

    public Dataset<Row> courseSales() {
        return (this.bitmap$0 & 0x1000000) == 0 ? this.courseSales$lzycompute() : this.courseSales;
    }

    public void loadTestData() {
        SQLTestData.class.loadTestData((SQLTestData)this);
    }

    public int rddIdOf(String tableName) {
        SparkPlan plan = this.hiveContext().table(tableName).queryExecution().sparkPlan();
        return BoxesRunTime.unboxToInt((Object)plan.collect((PartialFunction)new Serializable(this, tableName, plan){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;
            private final String tableName$1;
            private final SparkPlan plan$1;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof InMemoryTableScanExec) {
                    InMemoryTableScanExec inMemoryTableScanExec = (InMemoryTableScanExec)A1;
                    InMemoryRelation relation = inMemoryTableScanExec.relation();
                    Integer n = BoxesRunTime.boxToInteger((int)relation.cachedColumnBuffers().id());
                    return (B1)n;
                }
                throw this.$outer.fail(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table ", " is not cached\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName$1}))).append((Object)this.plan$1).toString());
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                boolean bl = sparkPlan instanceof InMemoryTableScanExec ? true : true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tableName$1 = tableName$1;
                this.plan$1 = plan$1;
            }
        }).head());
    }

    public boolean isMaterialized(int rddId) {
        Option maybeBlock = this.sparkContext().env().blockManager().get((BlockId)new RDDBlockId(rddId, 0), ClassTag$.MODULE$.Nothing());
        maybeBlock.foreach((Function1)new Serializable(this, rddId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;
            private final int rddId$1;

            public final void apply(BlockResult x$1) {
                this.$outer.sparkContext().env().blockManager().releaseLock((BlockId)new RDDBlockId(this.rddId$1, 0));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.rddId$1 = rddId$1;
            }
        });
        return maybeBlock.nonEmpty();
    }

    public CachedTableSuite() {
        SQLTestData.class.$init$((SQLTestData)this);
        SQLTestUtils.class.$init$((SQLTestUtils)this);
        TestHiveSingleton$class.$init$(this);
        this.test("cache table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq preCacheResults = Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.$outer.sql().apply((Object)"SELECT * FROM src")).collect()).toSeq();
                this.$outer.hiveContext().cacheTable("src");
                this.$outer.assertCached((Dataset)this.$outer.sql().apply((Object)"SELECT * FROM src"), this.$outer.assertCached$default$2());
                this.$outer.checkAnswer((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final Dataset<Row> apply() {
                        return (Dataset)this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().sql().apply((Object)"SELECT * FROM src");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, preCacheResults);
                this.$outer.assertCached((Dataset)this.$outer.sql().apply((Object)"SELECT * FROM src s"), this.$outer.assertCached$default$2());
                this.$outer.checkAnswer((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final Dataset<Row> apply() {
                        return (Dataset)this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().sql().apply((Object)"SELECT * FROM src s");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, preCacheResults);
                this.$outer.hiveContext().uncacheTable("src");
                this.$outer.assertCached((Dataset)this.$outer.sql().apply((Object)"SELECT * FROM src"), 0);
            }

            public /* synthetic */ CachedTableSuite org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("cache invalidation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.sql().apply((Object)"CREATE TABLE cachedTable(key INT, value STRING)");
                this.$outer.sql().apply((Object)"INSERT INTO TABLE cachedTable SELECT * FROM src");
                this.$outer.checkAnswer((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final Dataset<Row> apply() {
                        return (Dataset)this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().sql().apply((Object)"SELECT * FROM cachedTable");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Predef$.MODULE$.refArrayOps((Object[])this.$outer.hiveContext().table("src").collect()).toSeq());
                this.$outer.hiveContext().cacheTable("cachedTable");
                this.$outer.checkAnswer((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final Dataset<Row> apply() {
                        return (Dataset)this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().sql().apply((Object)"SELECT * FROM cachedTable");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Predef$.MODULE$.refArrayOps((Object[])this.$outer.hiveContext().table("src").collect()).toSeq());
                this.$outer.sql().apply((Object)"INSERT INTO TABLE cachedTable SELECT * FROM src");
                this.$outer.checkAnswer((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final Dataset<Row> apply() {
                        return (Dataset)this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().sql().apply((Object)"SELECT * FROM cachedTable");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (Seq)Predef$.MODULE$.refArrayOps((Object[])this.$outer.hiveContext().table("src").collect()).toSeq().$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.$outer.hiveContext().table("src").collect()).toSeq(), Seq$.MODULE$.canBuildFrom()));
                this.$outer.sql().apply((Object)"DROP TABLE cachedTable");
            }

            public /* synthetic */ CachedTableSuite org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Drop cached table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.sql().apply((Object)"CREATE TABLE cachedTableTest(a INT)");
                this.$outer.hiveContext().cacheTable("cachedTableTest");
                ((Dataset)this.$outer.sql().apply((Object)"SELECT * FROM cachedTableTest")).collect();
                this.$outer.sql().apply((Object)"DROP TABLE cachedTableTest");
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final Row[] apply() {
                        return (Row[])((Dataset)this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().sql().apply((Object)"SELECT * FROM cachedTableTest")).collect();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
            }

            public /* synthetic */ CachedTableSuite org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("DROP nonexistant table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.sql().apply((Object)"DROP TABLE IF EXISTS nonexistantTable");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("correct error on uncache of nonexistant tables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().spark().catalog().uncacheTable("nonexistantTable");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchTableException.class));
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final Dataset<Row> apply() {
                        return (Dataset)this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().sql().apply((Object)"UNCACHE TABLE nonexistantTable");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchTableException.class));
            }

            public /* synthetic */ CachedTableSuite org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("no error on uncache of non-cached table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String tableName = "newTable";
                this.$outer.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)new Serializable(this, tableName){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    private final String tableName$2;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().sql().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE ", "(a INT)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName$2})));
                        this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().spark().catalog().uncacheTable(this.tableName$2);
                        this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().sql().apply((Object)"UNCACHE TABLE newTable");
                        this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().hiveContext().sparkSession().table(this.tableName$2).unpersist();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.tableName$2 = tableName$2;
                    }
                });
            }

            public /* synthetic */ CachedTableSuite org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("'CACHE TABLE' and 'UNCACHE TABLE' HiveQL statement", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.sql().apply((Object)"CACHE TABLE src");
                this.$outer.assertCached(this.$outer.hiveContext().table("src"), this.$outer.assertCached$default$2());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.spark().catalog().isCached("src"), "CachedTableSuite.this.spark.catalog.isCached(\"src\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Table 'src' should be cached");
                this.$outer.sql().apply((Object)"UNCACHE TABLE src");
                this.$outer.assertCached(this.$outer.hiveContext().table("src"), 0);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.spark().catalog().isCached("src"), "CachedTableSuite.this.spark.catalog.isCached(\"src\")"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Table 'src' should not be cached");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("CACHE TABLE tableName AS SELECT * FROM anotherTable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testCacheTable"}), (Function0<BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().sql().apply((Object)"CACHE TABLE testCacheTable AS SELECT * FROM src");
                        this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().assertCached(this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().hiveContext().table("testCacheTable"), this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().assertCached$default$2());
                        int rddId = this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().rddIdOf("testCacheTable");
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().isMaterialized(rddId), "CachedTableSuite.this.isMaterialized(rddId)");
                        this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Eagerly cached in-memory table should have already been materialized");
                        this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().hiveContext().uncacheTable("testCacheTable");
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().isMaterialized(rddId), "CachedTableSuite.this.isMaterialized(rddId)"));
                        this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Uncached in-memory table should have been unpersisted");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ CachedTableSuite org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("CACHE TABLE tableName AS SELECT ...", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testCacheTable"}), (Function0<BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().sql().apply((Object)"CACHE TABLE testCacheTable AS SELECT key FROM src LIMIT 10");
                        this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().assertCached(this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().hiveContext().table("testCacheTable"), this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().assertCached$default$2());
                        int rddId = this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().rddIdOf("testCacheTable");
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().isMaterialized(rddId), "CachedTableSuite.this.isMaterialized(rddId)");
                        this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Eagerly cached in-memory table should have already been materialized");
                        this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().hiveContext().uncacheTable("testCacheTable");
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().isMaterialized(rddId), "CachedTableSuite.this.isMaterialized(rddId)"));
                        this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Uncached in-memory table should have been unpersisted");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ CachedTableSuite org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("CACHE LAZY TABLE tableName", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.sql().apply((Object)"CACHE LAZY TABLE src");
                this.$outer.assertCached(this.$outer.hiveContext().table("src"), this.$outer.assertCached$default$2());
                int rddId = this.$outer.rddIdOf("src");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.isMaterialized(rddId), "CachedTableSuite.this.isMaterialized(rddId)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Lazily cached in-memory table shouldn't be materialized eagerly");
                ((Dataset)this.$outer.sql().apply((Object)"SELECT COUNT(*) FROM src")).collect();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.$outer.isMaterialized(rddId), "CachedTableSuite.this.isMaterialized(rddId)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Lazily cached in-memory table should have been materialized");
                this.$outer.hiveContext().uncacheTable("src");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.isMaterialized(rddId), "CachedTableSuite.this.isMaterialized(rddId)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"Uncached in-memory table should have been unpersisted");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("CACHE TABLE with Hive UDF", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"udfTest"}), (Function0<BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$11 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().sql().apply((Object)"CACHE TABLE udfTest AS SELECT * FROM src WHERE floor(key) = 1");
                        this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().assertCached(this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().hiveContext().table("udfTest"), this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().assertCached$default$2());
                        this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().hiveContext().uncacheTable("udfTest");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ CachedTableSuite org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("REFRESH TABLE also needs to recache the data (data source tables)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File tempPath = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                tempPath.delete();
                this.$outer.hiveContext().table("src").write().mode(SaveMode.Overwrite).parquet(tempPath.toString());
                this.$outer.sql().apply((Object)"DROP TABLE IF EXISTS refreshTable");
                this.$outer.hiveContext().sparkSession().catalog().createExternalTable("refreshTable", tempPath.toString(), "parquet");
                this.$outer.checkAnswer((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$12 $outer;

                    public final Dataset<Row> apply() {
                        return this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().hiveContext().table("refreshTable");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.$outer.hiveContext().table("src").collect()));
                this.$outer.sql().apply((Object)"CACHE TABLE refreshTable");
                this.$outer.assertCached(this.$outer.hiveContext().table("refreshTable"), this.$outer.assertCached$default$2());
                this.$outer.hiveContext().table("src").write().mode(SaveMode.Append).parquet(tempPath.toString());
                this.$outer.assertCached(this.$outer.hiveContext().table("refreshTable"), this.$outer.assertCached$default$2());
                this.$outer.checkAnswer((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$12 $outer;

                    public final Dataset<Row> apply() {
                        return this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().hiveContext().table("refreshTable");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.$outer.hiveContext().table("src").collect()));
                this.$outer.sql().apply((Object)"REFRESH TABLE refreshTable");
                this.$outer.assertCached(this.$outer.hiveContext().table("refreshTable"), this.$outer.assertCached$default$2());
                this.$outer.checkAnswer((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$12 $outer;

                    public final Dataset<Row> apply() {
                        return this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().hiveContext().table("refreshTable");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.$outer.hiveContext().table("src").union(this.$outer.hiveContext().table("src")).collect()));
                this.$outer.sql().apply((Object)"DROP TABLE refreshTable");
                this.$outer.hiveContext().sparkSession().catalog().createExternalTable("refreshTable", tempPath.toString(), "parquet");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.hiveContext().isCached("refreshTable"), "CachedTableSuite.this.hiveContext.isCached(\"refreshTable\")"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"refreshTable should not be cached.");
                this.$outer.sql().apply((Object)"REFRESH TABLE refreshTable");
                this.$outer.checkAnswer((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$12 $outer;

                    public final Dataset<Row> apply() {
                        return this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().hiveContext().table("refreshTable");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.$outer.hiveContext().table("src").union(this.$outer.hiveContext().table("src")).collect()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.hiveContext().isCached("refreshTable"), "CachedTableSuite.this.hiveContext.isCached(\"refreshTable\")"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"refreshTable should not be cached.");
                this.$outer.sql().apply((Object)"DROP TABLE refreshTable");
                Utils$.MODULE$.deleteRecursively(tempPath);
            }

            public /* synthetic */ CachedTableSuite org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("SPARK-15678: REFRESH PATH", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File tempPath = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                tempPath.delete();
                this.$outer.hiveContext().table("src").write().mode(SaveMode.Overwrite).parquet(tempPath.toString());
                this.$outer.sql().apply((Object)"DROP TABLE IF EXISTS refreshTable");
                this.$outer.hiveContext().sparkSession().catalog().createExternalTable("refreshTable", tempPath.toString(), "parquet");
                this.$outer.checkAnswer((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$13 $outer;

                    public final Dataset<Row> apply() {
                        return this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().hiveContext().table("refreshTable");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.$outer.hiveContext().table("src").collect()));
                this.$outer.sql().apply((Object)"CACHE TABLE refreshTable");
                this.$outer.assertCached(this.$outer.hiveContext().table("refreshTable"), this.$outer.assertCached$default$2());
                this.$outer.hiveContext().table("src").write().mode(SaveMode.Append).parquet(tempPath.toString());
                this.$outer.assertCached(this.$outer.hiveContext().table("refreshTable"), this.$outer.assertCached$default$2());
                this.$outer.checkAnswer((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$13 $outer;

                    public final Dataset<Row> apply() {
                        return this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().hiveContext().table("refreshTable");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.$outer.hiveContext().table("src").collect()));
                this.$outer.sql().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REFRESH ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tempPath.toString()})));
                this.$outer.assertCached(this.$outer.hiveContext().table("refreshTable"), this.$outer.assertCached$default$2());
                this.$outer.checkAnswer((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$13 $outer;

                    public final Dataset<Row> apply() {
                        return this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().hiveContext().table("refreshTable");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.$outer.hiveContext().table("src").union(this.$outer.hiveContext().table("src")).collect()));
                this.$outer.sql().apply((Object)"DROP TABLE refreshTable");
                this.$outer.hiveContext().sparkSession().catalog().createExternalTable("refreshTable", tempPath.toString(), "parquet");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.hiveContext().isCached("refreshTable"), "CachedTableSuite.this.hiveContext.isCached(\"refreshTable\")"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"refreshTable should not be cached.");
                this.$outer.sql().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REFRESH ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tempPath.toString()})));
                this.$outer.checkAnswer((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$13 $outer;

                    public final Dataset<Row> apply() {
                        return this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().hiveContext().table("refreshTable");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.$outer.hiveContext().table("src").union(this.$outer.hiveContext().table("src")).collect()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.hiveContext().isCached("refreshTable"), "CachedTableSuite.this.hiveContext.isCached(\"refreshTable\")"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"refreshTable should not be cached.");
                this.$outer.sql().apply((Object)"DROP TABLE refreshTable");
                Utils$.MODULE$.deleteRecursively(tempPath);
            }

            public /* synthetic */ CachedTableSuite org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Cache/Uncache Qualified Tables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDatabase((Function1<String, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$14 $outer;

                    public final void apply(String db) {
                        this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cachedTable"}), (Function0<BoxedUnit>)new Serializable(this, db){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$14$$anonfun$apply$mcV$sp$22 $outer;
                            private final String db$1;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().sql().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE ", ".cachedTable STORED AS PARQUET AS SELECT 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.db$1})));
                                this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().sql().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CACHE TABLE ", ".cachedTable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.db$1})));
                                this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().assertCached(this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().spark().table(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".cachedTable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.db$1}))), this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().assertCached$default$2());
                                this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().activateDatabase(this.db$1, (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$14$$anonfun$apply$mcV$sp$22$$anonfun$apply$1 $outer;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().assertCached(this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().spark().table("cachedTable"), this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().assertCached$default$2());
                                        this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().sql().apply((Object)"UNCACHE TABLE cachedTable");
                                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().spark().catalog().isCached("cachedTable"), "CachedTableSuite.this.spark.catalog.isCached(\"cachedTable\")"));
                                        this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Table 'cachedTable' should not be cached");
                                        this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().sql().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CACHE TABLE cachedTable"})).s((Seq)Nil$.MODULE$));
                                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().spark().catalog().isCached("cachedTable"), "CachedTableSuite.this.spark.catalog.isCached(\"cachedTable\")");
                                        this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Table 'cachedTable' should be cached");
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                                this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().sql().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UNCACHE TABLE ", ".cachedTable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.db$1})));
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().spark().catalog().isCached(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".cachedTable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.db$1}))), "CachedTableSuite.this.spark.catalog.isCached(scala.StringContext.apply(\"\", \".cachedTable\").s(db))"));
                                this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Table 'cachedTable' should not be cached");
                            }

                            public /* synthetic */ $anonfun$14$$anonfun$apply$mcV$sp$22 org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.db$1 = db$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$14 org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ CachedTableSuite org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Cache Table As Select - having database name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTempDatabase((Function1<String, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$15 $outer;

                    public final void apply(String db) {
                        this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cachedTable"}), (Function0<BoxedUnit>)new Serializable(this, db){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$15$$anonfun$apply$mcV$sp$23 $outer;
                            public final String db$2;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                Bool bool;
                                String $org_scalatest_assert_macro_right;
                                String e = ((ParseException)this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$15$$anonfun$apply$mcV$sp$23$$anonfun$apply$2 $outer;

                                    public final Dataset<Row> apply() {
                                        return (Dataset)this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().sql().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CACHE TABLE ", ".cachedTable AS SELECT 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.db$2})));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                }, ManifestFactory$.MODULE$.classType(ParseException.class))).getMessage();
                                String $org_scalatest_assert_macro_left = e;
                                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)($org_scalatest_assert_macro_right = "It is not allowed to add database prefix "), $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                                if ($org_scalatest_assert_macro_left2.value()) {
                                    String $org_scalatest_assert_macro_left3 = e;
                                    String $org_scalatest_assert_macro_right2 = "to the table name in CACHE TABLE AS SELECT";
                                    bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right2));
                                } else {
                                    bool = Bool$.MODULE$.simpleMacroBool(false, "");
                                }
                                Bool $org_scalatest_assert_macro_right3 = bool;
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp($org_scalatest_assert_macro_right3));
                                this.$outer.org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            }

                            public /* synthetic */ $anonfun$15$$anonfun$apply$mcV$sp$23 org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.db$2 = db$2;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$15 org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ CachedTableSuite org$apache$spark$sql$hive$CachedTableSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("SPARK-11246 cache parquet table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.sql().apply((Object)"CREATE TABLE cachedTable STORED AS PARQUET AS SELECT 1");
                this.$outer.hiveContext().cacheTable("cachedTable");
                SparkPlan sparkPlan = ((Dataset)this.$outer.sql().apply((Object)"SELECT * FROM cachedTable")).queryExecution().sparkPlan();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)sparkPlan.collect((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x2;
                        if (A1 instanceof InMemoryTableScanExec) {
                            InMemoryTableScanExec inMemoryTableScanExec = (InMemoryTableScanExec)A1;
                            object = inMemoryTableScanExec;
                        } else {
                            object = function1.apply(x2);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(SparkPlan x2) {
                        SparkPlan sparkPlan = x2;
                        boolean bl = sparkPlan instanceof InMemoryTableScanExec;
                        return bl;
                    }
                }).size()));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                this.$outer.sql().apply((Object)"DROP TABLE cachedTable");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

