/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.hive.HiveSessionCatalog;
import org.apache.spark.sql.hive.test.TestHive$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JavaMetastoreDataSourcesSuite {
    private transient JavaSparkContext sc;
    private transient SQLContext sqlContext;
    File path;
    Path hiveManagedPath;
    FileSystem fs;
    Dataset<Row> df;

    private static void checkAnswer(Dataset<Row> actual, List<Row> expected) {
        String errorMessage = QueryTest$.MODULE$.checkAnswer(actual, expected);
        if (errorMessage != null) {
            Assert.fail((String)errorMessage);
        }
    }

    @Before
    public void setUp() throws IOException {
        this.sqlContext = TestHive$.MODULE$;
        this.sc = new JavaSparkContext(this.sqlContext.sparkContext());
        this.path = Utils.createTempDir((String)System.getProperty("java.io.tmpdir"), (String)"datasource").getCanonicalFile();
        if (this.path.exists()) {
            this.path.delete();
        }
        HiveSessionCatalog catalog = (HiveSessionCatalog)this.sqlContext.sessionState().catalog();
        this.hiveManagedPath = new Path(catalog.hiveDefaultTableFilePath(new TableIdentifier("javaSavedTable")));
        this.fs = this.hiveManagedPath.getFileSystem(this.sc.hadoopConfiguration());
        if (this.fs.exists(this.hiveManagedPath)) {
            this.fs.delete(this.hiveManagedPath, true);
        }
        ArrayList<String> jsonObjects = new ArrayList<String>(10);
        for (int i = 0; i < 10; ++i) {
            jsonObjects.add("{\"a\":" + i + ", \"b\":\"str" + i + "\"}");
        }
        JavaRDD rdd = this.sc.parallelize(jsonObjects);
        this.df = this.sqlContext.read().json(rdd);
        this.df.createOrReplaceTempView("jsonTable");
    }

    @After
    public void tearDown() throws IOException {
        if (this.sqlContext != null) {
            this.sqlContext.sql("DROP TABLE IF EXISTS javaSavedTable");
            this.sqlContext.sql("DROP TABLE IF EXISTS externalTable");
        }
    }

    @Test
    public void saveExternalTableAndQueryIt() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("path", this.path.toString());
        this.df.write().format("org.apache.spark.sql.json").mode(SaveMode.Append).options(options).saveAsTable("javaSavedTable");
        JavaMetastoreDataSourcesSuite.checkAnswer((Dataset<Row>)this.sqlContext.sql("SELECT * FROM javaSavedTable"), this.df.collectAsList());
        Dataset loadedDF = this.sqlContext.createExternalTable("externalTable", "org.apache.spark.sql.json", options);
        JavaMetastoreDataSourcesSuite.checkAnswer((Dataset<Row>)loadedDF, this.df.collectAsList());
        JavaMetastoreDataSourcesSuite.checkAnswer((Dataset<Row>)this.sqlContext.sql("SELECT * FROM externalTable"), this.df.collectAsList());
    }

    @Test
    public void saveExternalTableWithSchemaAndQueryIt() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("path", this.path.toString());
        this.df.write().format("org.apache.spark.sql.json").mode(SaveMode.Append).options(options).saveAsTable("javaSavedTable");
        JavaMetastoreDataSourcesSuite.checkAnswer((Dataset<Row>)this.sqlContext.sql("SELECT * FROM javaSavedTable"), this.df.collectAsList());
        ArrayList<StructField> fields = new ArrayList<StructField>();
        fields.add(DataTypes.createStructField((String)"b", (DataType)DataTypes.StringType, (boolean)true));
        StructType schema = DataTypes.createStructType(fields);
        Dataset loadedDF = this.sqlContext.createExternalTable("externalTable", "org.apache.spark.sql.json", schema, options);
        JavaMetastoreDataSourcesSuite.checkAnswer((Dataset<Row>)loadedDF, this.sqlContext.sql("SELECT b FROM javaSavedTable").collectAsList());
        JavaMetastoreDataSourcesSuite.checkAnswer((Dataset<Row>)this.sqlContext.sql("SELECT * FROM externalTable"), this.sqlContext.sql("SELECT b FROM javaSavedTable").collectAsList());
    }

    @Test
    public void saveTableAndQueryIt() {
        HashMap options = new HashMap();
        this.df.write().format("org.apache.spark.sql.json").mode(SaveMode.Append).options(options).saveAsTable("javaSavedTable");
        JavaMetastoreDataSourcesSuite.checkAnswer((Dataset<Row>)this.sqlContext.sql("SELECT * FROM javaSavedTable"), this.df.collectAsList());
    }
}

