/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.File;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.command.AnalyzeTableCommand;
import org.apache.spark.sql.execution.joins.BroadcastHashJoinExec;
import org.apache.spark.sql.execution.joins.SortMergeJoinExec;
import org.apache.spark.sql.hive.MetastoreRelation;
import org.apache.spark.sql.hive.StatisticsSuite$;
import org.apache.spark.sql.hive.test.TestHiveContext;
import org.apache.spark.sql.hive.test.TestHiveSingleton;
import org.apache.spark.sql.hive.test.TestHiveSingleton$class;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestData$internalImplicits$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SQLTestUtils$testImplicits$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\t2A!\u0001\u0002\u0001\u001b\ty1\u000b^1uSN$\u0018nY:Tk&$XM\u0003\u0002\u0004\t\u0005!\u0001.\u001b<f\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001aB\u0005\r\u0011\u0005=\u0001R\"\u0001\u0003\n\u0005E!!!C)vKJLH+Z:u!\t\u0019b#D\u0001\u0015\u0015\t)\"!\u0001\u0003uKN$\u0018BA\f\u0015\u0005E!Vm\u001d;ISZ,7+\u001b8hY\u0016$xN\u001c\t\u00033mi\u0011A\u0007\u0006\u0003+\u0011I!\u0001\b\u000e\u0003\u0019M\u000bF\nV3tiV#\u0018\u000e\\:\t\u000by\u0001A\u0011A\u0010\u0002\rqJg.\u001b;?)\u0005\u0001\u0003CA\u0011\u0001\u001b\u0005\u0011\u0001")
public class StatisticsSuite
extends QueryTest
implements TestHiveSingleton,
SQLTestUtils {
    private boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    private final Function1<String, Dataset<Row>> sql;
    private final Dataset<Row> emptyTestData;
    private final Dataset<Row> testData;
    private final Dataset<Row> testData2;
    private final Dataset<Row> testData3;
    private final Dataset<Row> negativeData;
    private final Dataset<Row> largeAndSmallInts;
    private final Dataset<Row> decimalData;
    private final Dataset<Row> binaryData;
    private final Dataset<Row> upperCaseData;
    private final Dataset<Row> lowerCaseData;
    private final RDD<SQLTestData.ArrayData> arrayData;
    private final RDD<SQLTestData.MapData> mapData;
    private final RDD<SQLTestData.StringData> repeatedData;
    private final RDD<SQLTestData.StringData> nullableRepeatedData;
    private final Dataset<Row> nullInts;
    private final Dataset<Row> allNulls;
    private final Dataset<Row> nullStrings;
    private final Dataset<Row> tableName;
    private final RDD<String> unparsedStrings;
    private final RDD<SQLTestData.IntField> withEmptyParts;
    private final Dataset<Row> person;
    private final Dataset<Row> salary;
    private final Dataset<Row> complexData;
    private final Dataset<Row> courseSales;
    private final SparkSession spark;
    private final TestHiveContext hiveContext;
    private volatile int bitmap$0;
    private volatile SQLTestUtils$testImplicits$ testImplicits$module;
    private volatile SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits$module;

    public boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests() {
        return this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    }

    public void org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(boolean x$1) {
        this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests = x$1;
    }

    private Function1 sql$lzycompute() {
        StatisticsSuite statisticsSuite = this;
        synchronized (statisticsSuite) {
            if ((this.bitmap$0 & 1) == 0) {
                this.sql = SQLTestUtils.class.sql((SQLTestUtils)this);
                this.bitmap$0 |= 1;
            }
            return this.sql;
        }
    }

    public Function1<String, Dataset<Row>> sql() {
        return (this.bitmap$0 & 1) == 0 ? this.sql$lzycompute() : this.sql;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SQLTestUtils$testImplicits$ testImplicits$lzycompute() {
        StatisticsSuite statisticsSuite = this;
        synchronized (statisticsSuite) {
            if (this.testImplicits$module != null) return this.testImplicits$module;
            this.testImplicits$module = new SQLTestUtils$testImplicits$((SQLTestUtils)this);
            return this.testImplicits$module;
        }
    }

    public SQLTestUtils$testImplicits$ testImplicits() {
        return this.testImplicits$module == null ? this.testImplicits$lzycompute() : this.testImplicits$module;
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    public SparkContext sparkContext() {
        return SQLTestUtils.class.sparkContext((SQLTestUtils)this);
    }

    public void setupTestData() {
        SQLTestUtils.class.setupTestData((SQLTestUtils)this);
    }

    public void beforeAll() {
        SQLTestUtils.class.beforeAll((SQLTestUtils)this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLTestUtils.class.withSQLConf((SQLTestUtils)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLTestUtils.class.withTempPath((SQLTestUtils)this, f);
    }

    public void withTempDir(Function1<File, BoxedUnit> f) {
        SQLTestUtils.class.withTempDir((SQLTestUtils)this, f);
    }

    public void withUserDefinedFunction(Seq<Tuple2<String, Object>> functions2, Function0<BoxedUnit> f) {
        SQLTestUtils.class.withUserDefinedFunction((SQLTestUtils)this, functions2, f);
    }

    public void withTempView(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtils.class.withTempView((SQLTestUtils)this, tableNames, f);
    }

    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtils.class.withTable((SQLTestUtils)this, tableNames, f);
    }

    public void withView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtils.class.withView((SQLTestUtils)this, viewNames, f);
    }

    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLTestUtils.class.withTempDatabase((SQLTestUtils)this, f);
    }

    public void activateDatabase(String db, Function0<BoxedUnit> f) {
        SQLTestUtils.class.activateDatabase((SQLTestUtils)this, (String)db, f);
    }

    public Dataset<Row> stripSparkFilter(Dataset<Row> df) {
        return SQLTestUtils.class.stripSparkFilter((SQLTestUtils)this, df);
    }

    public Dataset<Row> logicalPlanToSparkQuery(LogicalPlan plan) {
        return SQLTestUtils.class.logicalPlanToSparkQuery((SQLTestUtils)this, (LogicalPlan)plan);
    }

    public void testQuietly(String name, Function0<BoxedUnit> f) {
        SQLTestUtils.class.testQuietly((SQLTestUtils)this, (String)name, f);
    }

    public void testWithUninterruptibleThread(String name, boolean quietly, Function0<BoxedUnit> body) {
        SQLTestUtils.class.testWithUninterruptibleThread((SQLTestUtils)this, (String)name, (boolean)quietly, body);
    }

    public boolean testWithUninterruptibleThread$default$2() {
        return SQLTestUtils.class.testWithUninterruptibleThread$default$2((SQLTestUtils)this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute() {
        StatisticsSuite statisticsSuite = this;
        synchronized (statisticsSuite) {
            if (this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module != null) return this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module;
            this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module = new SQLTestData$internalImplicits$((SQLTestData)this);
            return this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module;
        }
    }

    public final SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits() {
        return this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module == null ? this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute() : this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module;
    }

    private Dataset emptyTestData$lzycompute() {
        StatisticsSuite statisticsSuite = this;
        synchronized (statisticsSuite) {
            if ((this.bitmap$0 & 2) == 0) {
                this.emptyTestData = SQLTestData.class.emptyTestData((SQLTestData)this);
                this.bitmap$0 |= 2;
            }
            return this.emptyTestData;
        }
    }

    public Dataset<Row> emptyTestData() {
        return (this.bitmap$0 & 2) == 0 ? this.emptyTestData$lzycompute() : this.emptyTestData;
    }

    private Dataset testData$lzycompute() {
        StatisticsSuite statisticsSuite = this;
        synchronized (statisticsSuite) {
            if ((this.bitmap$0 & 4) == 0) {
                this.testData = SQLTestData.class.testData((SQLTestData)this);
                this.bitmap$0 |= 4;
            }
            return this.testData;
        }
    }

    public Dataset<Row> testData() {
        return (this.bitmap$0 & 4) == 0 ? this.testData$lzycompute() : this.testData;
    }

    private Dataset testData2$lzycompute() {
        StatisticsSuite statisticsSuite = this;
        synchronized (statisticsSuite) {
            if ((this.bitmap$0 & 8) == 0) {
                this.testData2 = SQLTestData.class.testData2((SQLTestData)this);
                this.bitmap$0 |= 8;
            }
            return this.testData2;
        }
    }

    public Dataset<Row> testData2() {
        return (this.bitmap$0 & 8) == 0 ? this.testData2$lzycompute() : this.testData2;
    }

    private Dataset testData3$lzycompute() {
        StatisticsSuite statisticsSuite = this;
        synchronized (statisticsSuite) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.testData3 = SQLTestData.class.testData3((SQLTestData)this);
                this.bitmap$0 |= 0x10;
            }
            return this.testData3;
        }
    }

    public Dataset<Row> testData3() {
        return (this.bitmap$0 & 0x10) == 0 ? this.testData3$lzycompute() : this.testData3;
    }

    private Dataset negativeData$lzycompute() {
        StatisticsSuite statisticsSuite = this;
        synchronized (statisticsSuite) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.negativeData = SQLTestData.class.negativeData((SQLTestData)this);
                this.bitmap$0 |= 0x20;
            }
            return this.negativeData;
        }
    }

    public Dataset<Row> negativeData() {
        return (this.bitmap$0 & 0x20) == 0 ? this.negativeData$lzycompute() : this.negativeData;
    }

    private Dataset largeAndSmallInts$lzycompute() {
        StatisticsSuite statisticsSuite = this;
        synchronized (statisticsSuite) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.largeAndSmallInts = SQLTestData.class.largeAndSmallInts((SQLTestData)this);
                this.bitmap$0 |= 0x40;
            }
            return this.largeAndSmallInts;
        }
    }

    public Dataset<Row> largeAndSmallInts() {
        return (this.bitmap$0 & 0x40) == 0 ? this.largeAndSmallInts$lzycompute() : this.largeAndSmallInts;
    }

    private Dataset decimalData$lzycompute() {
        StatisticsSuite statisticsSuite = this;
        synchronized (statisticsSuite) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.decimalData = SQLTestData.class.decimalData((SQLTestData)this);
                this.bitmap$0 |= 0x80;
            }
            return this.decimalData;
        }
    }

    public Dataset<Row> decimalData() {
        return (this.bitmap$0 & 0x80) == 0 ? this.decimalData$lzycompute() : this.decimalData;
    }

    private Dataset binaryData$lzycompute() {
        StatisticsSuite statisticsSuite = this;
        synchronized (statisticsSuite) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.binaryData = SQLTestData.class.binaryData((SQLTestData)this);
                this.bitmap$0 |= 0x100;
            }
            return this.binaryData;
        }
    }

    public Dataset<Row> binaryData() {
        return (this.bitmap$0 & 0x100) == 0 ? this.binaryData$lzycompute() : this.binaryData;
    }

    private Dataset upperCaseData$lzycompute() {
        StatisticsSuite statisticsSuite = this;
        synchronized (statisticsSuite) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.upperCaseData = SQLTestData.class.upperCaseData((SQLTestData)this);
                this.bitmap$0 |= 0x200;
            }
            return this.upperCaseData;
        }
    }

    public Dataset<Row> upperCaseData() {
        return (this.bitmap$0 & 0x200) == 0 ? this.upperCaseData$lzycompute() : this.upperCaseData;
    }

    private Dataset lowerCaseData$lzycompute() {
        StatisticsSuite statisticsSuite = this;
        synchronized (statisticsSuite) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.lowerCaseData = SQLTestData.class.lowerCaseData((SQLTestData)this);
                this.bitmap$0 |= 0x400;
            }
            return this.lowerCaseData;
        }
    }

    public Dataset<Row> lowerCaseData() {
        return (this.bitmap$0 & 0x400) == 0 ? this.lowerCaseData$lzycompute() : this.lowerCaseData;
    }

    private RDD arrayData$lzycompute() {
        StatisticsSuite statisticsSuite = this;
        synchronized (statisticsSuite) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.arrayData = SQLTestData.class.arrayData((SQLTestData)this);
                this.bitmap$0 |= 0x800;
            }
            return this.arrayData;
        }
    }

    public RDD<SQLTestData.ArrayData> arrayData() {
        return (this.bitmap$0 & 0x800) == 0 ? this.arrayData$lzycompute() : this.arrayData;
    }

    private RDD mapData$lzycompute() {
        StatisticsSuite statisticsSuite = this;
        synchronized (statisticsSuite) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.mapData = SQLTestData.class.mapData((SQLTestData)this);
                this.bitmap$0 |= 0x1000;
            }
            return this.mapData;
        }
    }

    public RDD<SQLTestData.MapData> mapData() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.mapData$lzycompute() : this.mapData;
    }

    private RDD repeatedData$lzycompute() {
        StatisticsSuite statisticsSuite = this;
        synchronized (statisticsSuite) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.repeatedData = SQLTestData.class.repeatedData((SQLTestData)this);
                this.bitmap$0 |= 0x2000;
            }
            return this.repeatedData;
        }
    }

    public RDD<SQLTestData.StringData> repeatedData() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.repeatedData$lzycompute() : this.repeatedData;
    }

    private RDD nullableRepeatedData$lzycompute() {
        StatisticsSuite statisticsSuite = this;
        synchronized (statisticsSuite) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.nullableRepeatedData = SQLTestData.class.nullableRepeatedData((SQLTestData)this);
                this.bitmap$0 |= 0x4000;
            }
            return this.nullableRepeatedData;
        }
    }

    public RDD<SQLTestData.StringData> nullableRepeatedData() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.nullableRepeatedData$lzycompute() : this.nullableRepeatedData;
    }

    private Dataset nullInts$lzycompute() {
        StatisticsSuite statisticsSuite = this;
        synchronized (statisticsSuite) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.nullInts = SQLTestData.class.nullInts((SQLTestData)this);
                this.bitmap$0 |= 0x8000;
            }
            return this.nullInts;
        }
    }

    public Dataset<Row> nullInts() {
        return (this.bitmap$0 & 0x8000) == 0 ? this.nullInts$lzycompute() : this.nullInts;
    }

    private Dataset allNulls$lzycompute() {
        StatisticsSuite statisticsSuite = this;
        synchronized (statisticsSuite) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.allNulls = SQLTestData.class.allNulls((SQLTestData)this);
                this.bitmap$0 |= 0x10000;
            }
            return this.allNulls;
        }
    }

    public Dataset<Row> allNulls() {
        return (this.bitmap$0 & 0x10000) == 0 ? this.allNulls$lzycompute() : this.allNulls;
    }

    private Dataset nullStrings$lzycompute() {
        StatisticsSuite statisticsSuite = this;
        synchronized (statisticsSuite) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.nullStrings = SQLTestData.class.nullStrings((SQLTestData)this);
                this.bitmap$0 |= 0x20000;
            }
            return this.nullStrings;
        }
    }

    public Dataset<Row> nullStrings() {
        return (this.bitmap$0 & 0x20000) == 0 ? this.nullStrings$lzycompute() : this.nullStrings;
    }

    private Dataset tableName$lzycompute() {
        StatisticsSuite statisticsSuite = this;
        synchronized (statisticsSuite) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.tableName = SQLTestData.class.tableName((SQLTestData)this);
                this.bitmap$0 |= 0x40000;
            }
            return this.tableName;
        }
    }

    public Dataset<Row> tableName() {
        return (this.bitmap$0 & 0x40000) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    private RDD unparsedStrings$lzycompute() {
        StatisticsSuite statisticsSuite = this;
        synchronized (statisticsSuite) {
            if ((this.bitmap$0 & 0x80000) == 0) {
                this.unparsedStrings = SQLTestData.class.unparsedStrings((SQLTestData)this);
                this.bitmap$0 |= 0x80000;
            }
            return this.unparsedStrings;
        }
    }

    public RDD<String> unparsedStrings() {
        return (this.bitmap$0 & 0x80000) == 0 ? this.unparsedStrings$lzycompute() : this.unparsedStrings;
    }

    private RDD withEmptyParts$lzycompute() {
        StatisticsSuite statisticsSuite = this;
        synchronized (statisticsSuite) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.withEmptyParts = SQLTestData.class.withEmptyParts((SQLTestData)this);
                this.bitmap$0 |= 0x100000;
            }
            return this.withEmptyParts;
        }
    }

    public RDD<SQLTestData.IntField> withEmptyParts() {
        return (this.bitmap$0 & 0x100000) == 0 ? this.withEmptyParts$lzycompute() : this.withEmptyParts;
    }

    private Dataset person$lzycompute() {
        StatisticsSuite statisticsSuite = this;
        synchronized (statisticsSuite) {
            if ((this.bitmap$0 & 0x200000) == 0) {
                this.person = SQLTestData.class.person((SQLTestData)this);
                this.bitmap$0 |= 0x200000;
            }
            return this.person;
        }
    }

    public Dataset<Row> person() {
        return (this.bitmap$0 & 0x200000) == 0 ? this.person$lzycompute() : this.person;
    }

    private Dataset salary$lzycompute() {
        StatisticsSuite statisticsSuite = this;
        synchronized (statisticsSuite) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.salary = SQLTestData.class.salary((SQLTestData)this);
                this.bitmap$0 |= 0x400000;
            }
            return this.salary;
        }
    }

    public Dataset<Row> salary() {
        return (this.bitmap$0 & 0x400000) == 0 ? this.salary$lzycompute() : this.salary;
    }

    private Dataset complexData$lzycompute() {
        StatisticsSuite statisticsSuite = this;
        synchronized (statisticsSuite) {
            if ((this.bitmap$0 & 0x800000) == 0) {
                this.complexData = SQLTestData.class.complexData((SQLTestData)this);
                this.bitmap$0 |= 0x800000;
            }
            return this.complexData;
        }
    }

    public Dataset<Row> complexData() {
        return (this.bitmap$0 & 0x800000) == 0 ? this.complexData$lzycompute() : this.complexData;
    }

    private Dataset courseSales$lzycompute() {
        StatisticsSuite statisticsSuite = this;
        synchronized (statisticsSuite) {
            if ((this.bitmap$0 & 0x1000000) == 0) {
                this.courseSales = SQLTestData.class.courseSales((SQLTestData)this);
                this.bitmap$0 |= 0x1000000;
            }
            return this.courseSales;
        }
    }

    public Dataset<Row> courseSales() {
        return (this.bitmap$0 & 0x1000000) == 0 ? this.courseSales$lzycompute() : this.courseSales;
    }

    public void loadTestData() {
        SQLTestData.class.loadTestData((SQLTestData)this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public TestHiveContext hiveContext() {
        return this.hiveContext;
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveContext_$eq(TestHiveContext x$1) {
        this.hiveContext = x$1;
    }

    @Override
    public void afterAll() {
        TestHiveSingleton$class.afterAll(this);
    }

    public StatisticsSuite() {
        TestHiveSingleton$class.$init$(this);
        SQLTestData.class.$init$((SQLTestData)this);
        SQLTestUtils.class.$init$((SQLTestUtils)this);
        this.test("parse analyze commands", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatisticsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.assertAnalyzeCommand$1("ANALYZE TABLE Table1 COMPUTE STATISTICS", AnalyzeTableCommand.class);
                this.assertAnalyzeCommand$1("ANALYZE TABLE Table1 PARTITION(ds='2008-04-09', hr=11) COMPUTE STATISTICS", AnalyzeTableCommand.class);
                this.assertAnalyzeCommand$1("ANALYZE TABLE Table1 PARTITION(ds='2008-04-09', hr=11) COMPUTE STATISTICS noscan", AnalyzeTableCommand.class);
                this.assertAnalyzeCommand$1("ANALYZE TABLE Table1 PARTITION(ds, hr) COMPUTE STATISTICS", AnalyzeTableCommand.class);
                this.assertAnalyzeCommand$1("ANALYZE TABLE Table1 PARTITION(ds, hr) COMPUTE STATISTICS noscan", AnalyzeTableCommand.class);
                this.assertAnalyzeCommand$1("ANALYZE TABLE Table1 COMPUTE STATISTICS nOscAn", AnalyzeTableCommand.class);
            }

            private final void assertAnalyzeCommand$1(String analyzeCommand, Class c) {
                LogicalPlan parsed = this.$outer.spark().sessionState().sqlParser().parsePlan(analyzeCommand);
                Seq operators = parsed.collect((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof AnalyzeTableCommand) {
                            AnalyzeTableCommand analyzeTableCommand = (AnalyzeTableCommand)A1;
                            object = analyzeTableCommand;
                        } else {
                            object = A1;
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x1) {
                        LogicalPlan logicalPlan = x1;
                        boolean bl = logicalPlan instanceof AnalyzeTableCommand ? true : true;
                        return bl;
                    }
                });
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)operators.size()));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Class<?> clazz = operators.apply(0).getClass();
                Class clazz2 = c;
                if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                    return;
                }
                throw this.$outer.fail(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " expected command: ", ", but got ", "\n             |parsed command:\n             |", "\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{analyzeCommand, c, operators.apply(0), parsed})))).stripMargin());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("MetastoreRelations fallback to HDFS for size estimation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatisticsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * WARNING - void declaration
             */
            public void apply$mcV$sp() {
                boolean enableFallBackToHdfsForStats = this.$outer.spark().sessionState().conf().fallBackToHdfsForStatsEnabled();
                try {
                    this.$outer.withTempDir((Function1<File, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$2 $outer;

                        public final void apply(File tempDir) {
                            File file1 = new File(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)tempDir), "/data1"));
                            PrintWriter writer1 = new PrintWriter(file1);
                            writer1.write("1,2");
                            writer1.close();
                            File file2 = new File(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)tempDir), "/data2"));
                            PrintWriter writer2 = new PrintWriter(file2);
                            writer2.write("1,2");
                            writer2.close();
                            this.$outer.org$apache$spark$sql$hive$StatisticsSuite$$anonfun$$$outer().sql().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE EXTERNAL TABLE csv_table(page_id INT, impressions INT)\n            ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.OpenCSVSerde'\n            WITH SERDEPROPERTIES (\n              \\\"separatorChar\\\" = \\\",\\\",\n              \\\"quoteChar\\\"     = \\\"\\\\\\\"\\\",\n              \\\"escapeChar\\\"    = \\\"\\\\\\\\\\\")\n            LOCATION '", "'\n          "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tempDir})));
                            this.$outer.org$apache$spark$sql$hive$StatisticsSuite$$anonfun$$$outer().spark().conf().set(SQLConf$.MODULE$.ENABLE_FALL_BACK_TO_HDFS_FOR_STATS().key(), true);
                            MetastoreRelation relation = (MetastoreRelation)this.$outer.org$apache$spark$sql$hive$StatisticsSuite$$anonfun$$$outer().spark().sessionState().catalog().lookupRelation(TableIdentifier$.MODULE$.apply("csv_table"), this.$outer.org$apache$spark$sql$hive$StatisticsSuite$$anonfun$$$outer().spark().sessionState().catalog().lookupRelation$default$2());
                            Map properties = relation.hiveQlTable().getParameters();
                            long $org_scalatest_assert_macro_left = new StringOps(Predef$.MODULE$.augmentString((String)properties.get("totalSize"))).toLong();
                            int $org_scalatest_assert_macro_right = 0;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "<=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left <= (long)$org_scalatest_assert_macro_right);
                            this.$outer.org$apache$spark$sql$hive$StatisticsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"external table totalSize must be <= 0");
                            long $org_scalatest_assert_macro_left2 = new StringOps(Predef$.MODULE$.augmentString((String)properties.get("rawDataSize"))).toLong();
                            int $org_scalatest_assert_macro_right2 = 0;
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "<=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 <= (long)$org_scalatest_assert_macro_right2);
                            this.$outer.org$apache$spark$sql$hive$StatisticsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"external table rawDataSize must be <= 0");
                            BigInt sizeInBytes = relation.statistics().sizeInBytes();
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$sql$hive$StatisticsSuite$$anonfun$$$outer().convertToEqualizer(sizeInBytes);
                            BigInt $org_scalatest_assert_macro_right3 = package$.MODULE$.BigInt().apply(file1.length() + file2.length());
                            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$sql$hive$StatisticsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                catch (Throwable throwable) {
                    void var1_1;
                    this.$outer.spark().conf().set(SQLConf$.MODULE$.ENABLE_FALL_BACK_TO_HDFS_FOR_STATS().key(), (boolean)var1_1);
                    this.$outer.sql().apply((Object)"DROP TABLE csv_table ");
                    throw throwable;
                }
                this.$outer.spark().conf().set(SQLConf$.MODULE$.ENABLE_FALL_BACK_TO_HDFS_FOR_STATS().key(), enableFallBackToHdfsForStats);
                this.$outer.sql().apply((Object)"DROP TABLE csv_table ");
            }

            public /* synthetic */ StatisticsSuite org$apache$spark$sql$hive$StatisticsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("analyze MetastoreRelations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatisticsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((Dataset)this.$outer.sql().apply((Object)"CREATE TABLE analyzeTable (key STRING, value STRING)")).collect();
                ((Dataset)this.$outer.sql().apply((Object)"INSERT INTO TABLE analyzeTable SELECT * FROM src")).collect();
                ((Dataset)this.$outer.sql().apply((Object)"INSERT INTO TABLE analyzeTable SELECT * FROM src")).collect();
                this.$outer.sql().apply((Object)"ANALYZE TABLE analyzeTable COMPUTE STATISTICS noscan");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.queryTotalSize$1("analyzeTable"));
                BigInt $org_scalatest_assert_macro_right = package$.MODULE$.BigInt().apply(11624);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                ((Dataset)this.$outer.sql().apply((Object)"DROP TABLE analyzeTable")).collect();
                ((Dataset)this.$outer.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE analyzeTable_part (key STRING, value STRING) PARTITIONED BY (ds STRING)\n      ")).stripMargin())).collect();
                ((Dataset)this.$outer.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO TABLE analyzeTable_part PARTITION (ds='2010-01-01')\n        |SELECT * FROM src\n      ")).stripMargin())).collect();
                ((Dataset)this.$outer.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO TABLE analyzeTable_part PARTITION (ds='2010-01-02')\n        |SELECT * FROM src\n      ")).stripMargin())).collect();
                ((Dataset)this.$outer.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO TABLE analyzeTable_part PARTITION (ds='2010-01-03')\n        |SELECT * FROM src\n      ")).stripMargin())).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(this.queryTotalSize$1("analyzeTable_part"));
                long $org_scalatest_assert_macro_right2 = this.$outer.spark().sessionState().conf().defaultSizeInBytes();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                this.$outer.sql().apply((Object)"ANALYZE TABLE analyzeTable_part COMPUTE STATISTICS noscan");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(this.queryTotalSize$1("analyzeTable_part"));
                BigInt $org_scalatest_assert_macro_right3 = package$.MODULE$.BigInt().apply(17436);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                ((Dataset)this.$outer.sql().apply((Object)"DROP TABLE analyzeTable_part")).collect();
                ((Dataset)this.$outer.sql().apply((Object)"SELECT * FROM src")).createOrReplaceTempView("tempTable");
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final Dataset<Row> apply() {
                        return (Dataset)this.$outer.org$apache$spark$sql$hive$StatisticsSuite$$anonfun$$$outer().sql().apply((Object)"ANALYZE TABLE tempTable COMPUTE STATISTICS");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
                this.$outer.spark().sessionState().catalog().dropTable(TableIdentifier$.MODULE$.apply("tempTable"), true);
            }

            public /* synthetic */ StatisticsSuite org$apache$spark$sql$hive$StatisticsSuite$$anonfun$$$outer() {
                return this.$outer;
            }

            private final BigInt queryTotalSize$1(String tableName) {
                return this.$outer.spark().sessionState().catalog().lookupRelation(TableIdentifier$.MODULE$.apply(tableName), this.$outer.spark().sessionState().catalog().lookupRelation$default$2()).statistics().sizeInBytes();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("estimates the size of a test MetastoreRelation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatisticsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Dataset df = (Dataset)this.$outer.sql().apply((Object)"SELECT * FROM src");
                Seq sizes = df.queryExecution().analyzed().collect((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x2;
                        if (A1 instanceof MetastoreRelation) {
                            MetastoreRelation metastoreRelation = (MetastoreRelation)A1;
                            object = metastoreRelation.statistics().sizeInBytes();
                        } else {
                            object = function1.apply(x2);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x2) {
                        LogicalPlan logicalPlan = x2;
                        boolean bl = logicalPlan instanceof MetastoreRelation;
                        return bl;
                    }
                });
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)sizes.size()));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Size wrong for:\\n ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{df.queryExecution()})));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(((BigInt)sizes.apply(0)).equals(package$.MODULE$.BigInt().apply(5812)), "sizes.apply(0).equals(scala.`package`.BigInt.apply(5812))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected exact size 5812 for test table 'src', got: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sizes.apply(0)})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("auto converts to broadcast hash join, by size estimate of a relation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatisticsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String metastoreQuery = "SELECT * FROM src a JOIN src b ON a.key = 238 AND a.key = b.key";
                Seq metastoreAnswer = (Seq)Seq$.MODULE$.fill(4, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Row apply() {
                        return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)238), "val_238", BoxesRunTime.boxToInteger((int)238), "val_238"}));
                    }
                });
                this.mkTest$1((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                    }
                }, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                    }
                }, metastoreQuery, metastoreAnswer, (ClassTag)Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.apply(MetastoreRelation.class)));
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private final void mkTest$1(Function0 before, Function0 after, String query, Seq expectedAnswer, ClassTag ct) {
                Bool bool;
                Bool bool2;
                before.apply$mcV$sp();
                ObjectRef df = ObjectRef.create((Object)((Dataset)this.$outer.sql().apply((Object)query)));
                Seq sizes = ((Dataset)df.elem).queryExecution().analyzed().collect((PartialFunction)new Serializable(this, ct){
                    public static final long serialVersionUID = 0L;
                    private final ClassTag ct$1;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                        A1 A1 = x3;
                        Object object = this.ct$1.runtimeClass().isAssignableFrom(A1.getClass()) ? A1.statistics().sizeInBytes() : function1.apply(x3);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x3) {
                        LogicalPlan logicalPlan = x3;
                        boolean bl = this.ct$1.runtimeClass().isAssignableFrom(logicalPlan.getClass());
                        return bl;
                    }
                    {
                        this.ct$1 = ct$1;
                    }
                });
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)sizes.size()));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                if ($org_scalatest_assert_macro_left2.value()) {
                    BigInt $org_scalatest_assert_macro_left3 = (BigInt)sizes.apply(0);
                    BigInt $org_scalatest_assert_macro_right2 = BigInt$.MODULE$.long2bigInt(this.$outer.spark().sessionState().conf().autoBroadcastJoinThreshold());
                    bool2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "<=", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$less$eq($org_scalatest_assert_macro_right2));
                } else {
                    bool2 = Bool$.MODULE$.simpleMacroBool(false, "");
                }
                Bool $org_scalatest_assert_macro_right3 = bool2;
                Bool $org_scalatest_assert_macro_left4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp($org_scalatest_assert_macro_right3));
                if ($org_scalatest_assert_macro_left4.value()) {
                    BigInt $org_scalatest_assert_macro_left5 = (BigInt)sizes.apply(1);
                    BigInt $org_scalatest_assert_macro_right4 = BigInt$.MODULE$.long2bigInt(this.$outer.spark().sessionState().conf().autoBroadcastJoinThreshold());
                    bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "<=", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.$less$eq($org_scalatest_assert_macro_right4));
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "");
                }
                Bool $org_scalatest_assert_macro_right5 = bool;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "&&", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left4.$amp$amp($org_scalatest_assert_macro_right5));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"query should contain two relations, each of which has size smaller than autoConvertSize"})).s((Seq)Nil$.MODULE$));
                Seq bhj = ((Dataset)df.elem).queryExecution().sparkPlan().collect((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x4;
                        if (A1 instanceof BroadcastHashJoinExec) {
                            BroadcastHashJoinExec broadcastHashJoinExec = (BroadcastHashJoinExec)A1;
                            object = broadcastHashJoinExec;
                        } else {
                            object = function1.apply(x4);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(SparkPlan x4) {
                        SparkPlan sparkPlan = x4;
                        boolean bl = sparkPlan instanceof BroadcastHashJoinExec;
                        return bl;
                    }
                });
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bhj.size()));
                int $org_scalatest_assert_macro_right6 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"actual query plans do not contain broadcast join: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Dataset)df.elem).queryExecution()})));
                this.$outer.checkAnswer((Function0)new Serializable(this, df){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef df$1;

                    public final Dataset<Row> apply() {
                        return (Dataset)this.df$1.elem;
                    }
                    {
                        this.df$1 = df$1;
                    }
                }, expectedAnswer);
                Map map = this.$outer.spark().sessionState().conf().settings();
                synchronized (map) {
                    long tmp = this.$outer.spark().sessionState().conf().autoBroadcastJoinThreshold();
                    this.$outer.sql().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SET ", "=-1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()})));
                    df.elem = (Dataset)this.$outer.sql().apply((Object)query);
                    Seq $org_scalatest_assert_macro_left7 = bhj = ((Dataset)df.elem).queryExecution().sparkPlan().collect((PartialFunction)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x5;
                            if (A1 instanceof BroadcastHashJoinExec) {
                                BroadcastHashJoinExec broadcastHashJoinExec = (BroadcastHashJoinExec)A1;
                                object = broadcastHashJoinExec;
                            } else {
                                object = function1.apply(x5);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(SparkPlan x5) {
                            SparkPlan sparkPlan = x5;
                            boolean bl = sparkPlan instanceof BroadcastHashJoinExec;
                            return bl;
                        }
                    });
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left7, "isEmpty", $org_scalatest_assert_macro_left7.isEmpty());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"BroadcastHashJoin still planned even though it is switched off");
                    Seq shj = ((Dataset)df.elem).queryExecution().sparkPlan().collect((PartialFunction)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x6;
                            if (A1 instanceof SortMergeJoinExec) {
                                SortMergeJoinExec sortMergeJoinExec = (SortMergeJoinExec)A1;
                                object = sortMergeJoinExec;
                            } else {
                                object = function1.apply(x6);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(SparkPlan x6) {
                            SparkPlan sparkPlan = x6;
                            boolean bl = sparkPlan instanceof SortMergeJoinExec;
                            return bl;
                        }
                    });
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)shj.size()));
                    int $org_scalatest_assert_macro_right7 = 1;
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"SortMergeJoin should be planned when BroadcastHashJoin is turned off");
                    this.$outer.sql().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SET ", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key(), BoxesRunTime.boxToLong((long)tmp)})));
                }
                after.apply$mcV$sp();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("auto converts to broadcast left semi join, by size estimate of a relation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatisticsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Bool bool;
                Bool bool2;
                int $org_scalatest_assert_macro_right;
                String leftSemiJoinQuery = new StringOps(Predef$.MODULE$.augmentString("SELECT * FROM src a\n        |left semi JOIN src b ON a.key=86 and a.key = b.key")).stripMargin();
                Row answer = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)86), "val_86"}));
                ObjectRef df = ObjectRef.create((Object)((Dataset)this.$outer.sql().apply((Object)leftSemiJoinQuery)));
                Seq sizes = ((Dataset)df.elem).queryExecution().analyzed().collect((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                        A1 A1 = x7;
                        Object object = ((ClassTag)Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.apply(MetastoreRelation.class))).runtimeClass().isAssignableFrom(A1.getClass()) ? A1.statistics().sizeInBytes() : function1.apply(x7);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x7) {
                        LogicalPlan logicalPlan = x7;
                        boolean bl = ((ClassTag)Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.apply(MetastoreRelation.class))).runtimeClass().isAssignableFrom(logicalPlan.getClass());
                        return bl;
                    }
                });
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)sizes.size()));
                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)($org_scalatest_assert_macro_right = 2)), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                if ($org_scalatest_assert_macro_left2.value()) {
                    BigInt $org_scalatest_assert_macro_left3 = (BigInt)sizes.apply(1);
                    BigInt $org_scalatest_assert_macro_right2 = BigInt$.MODULE$.long2bigInt(this.$outer.spark().sessionState().conf().autoBroadcastJoinThreshold());
                    bool2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "<=", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$less$eq($org_scalatest_assert_macro_right2));
                } else {
                    bool2 = Bool$.MODULE$.simpleMacroBool(false, "");
                }
                Bool $org_scalatest_assert_macro_right3 = bool2;
                Bool $org_scalatest_assert_macro_left4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp($org_scalatest_assert_macro_right3));
                if ($org_scalatest_assert_macro_left4.value()) {
                    BigInt $org_scalatest_assert_macro_left5 = (BigInt)sizes.apply(0);
                    BigInt $org_scalatest_assert_macro_right4 = BigInt$.MODULE$.long2bigInt(this.$outer.spark().sessionState().conf().autoBroadcastJoinThreshold());
                    bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "<=", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.$less$eq($org_scalatest_assert_macro_right4));
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "");
                }
                Bool $org_scalatest_assert_macro_right5 = bool;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "&&", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left4.$amp$amp($org_scalatest_assert_macro_right5));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"query should contain two relations, each of which has size smaller than autoConvertSize"})).s((Seq)Nil$.MODULE$));
                Seq bhj = ((Dataset)df.elem).queryExecution().sparkPlan().collect((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x8;
                        if (A1 instanceof BroadcastHashJoinExec) {
                            BroadcastHashJoinExec broadcastHashJoinExec = (BroadcastHashJoinExec)A1;
                            object = broadcastHashJoinExec;
                        } else {
                            object = function1.apply(x8);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(SparkPlan x8) {
                        SparkPlan sparkPlan = x8;
                        boolean bl = sparkPlan instanceof BroadcastHashJoinExec;
                        return bl;
                    }
                });
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bhj.size()));
                int $org_scalatest_assert_macro_right6 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"actual query plans do not contain broadcast join: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Dataset)df.elem).queryExecution()})));
                this.$outer.checkAnswer((Function0)new Serializable(this, df){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef df$2;

                    public final Dataset<Row> apply() {
                        return (Dataset)this.df$2.elem;
                    }
                    {
                        this.df$2 = df$2;
                    }
                }, answer);
                Map map = this.$outer.spark().sessionState().conf().settings();
                synchronized (map) {
                    long tmp = this.$outer.spark().sessionState().conf().autoBroadcastJoinThreshold();
                    this.$outer.sql().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SET ", "=-1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()})));
                    df.elem = (Dataset)this.$outer.sql().apply((Object)leftSemiJoinQuery);
                    Seq $org_scalatest_assert_macro_left7 = bhj = ((Dataset)df.elem).queryExecution().sparkPlan().collect((PartialFunction)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x9;
                            if (A1 instanceof BroadcastHashJoinExec) {
                                BroadcastHashJoinExec broadcastHashJoinExec = (BroadcastHashJoinExec)A1;
                                object = broadcastHashJoinExec;
                            } else {
                                object = function1.apply(x9);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(SparkPlan x9) {
                            SparkPlan sparkPlan = x9;
                            boolean bl = sparkPlan instanceof BroadcastHashJoinExec;
                            return bl;
                        }
                    });
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left7, "isEmpty", $org_scalatest_assert_macro_left7.isEmpty());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"BroadcastHashJoin still planned even though it is switched off");
                    Seq shj = ((Dataset)df.elem).queryExecution().sparkPlan().collect((PartialFunction)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x10, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x10;
                            if (A1 instanceof SortMergeJoinExec) {
                                SortMergeJoinExec sortMergeJoinExec = (SortMergeJoinExec)A1;
                                object = sortMergeJoinExec;
                            } else {
                                object = function1.apply(x10);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(SparkPlan x10) {
                            SparkPlan sparkPlan = x10;
                            boolean bl = sparkPlan instanceof SortMergeJoinExec;
                            return bl;
                        }
                    });
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)shj.size()));
                    int $org_scalatest_assert_macro_right7 = 1;
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"SortMergeJoinExec should be planned when BroadcastHashJoin is turned off");
                    this.$outer.sql().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SET ", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key(), BoxesRunTime.boxToLong((long)tmp)})));
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

