/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.aggregate;

import java.util.ArrayList;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.MutableAggregationBuffer;
import org.apache.spark.sql.expressions.UserDefinedAggregateFunction;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class MyDoubleSum
extends UserDefinedAggregateFunction {
    private StructType _inputDataType;
    private StructType _bufferSchema;
    private DataType _returnDataType;

    public MyDoubleSum() {
        ArrayList<StructField> inputFields = new ArrayList<StructField>();
        inputFields.add(DataTypes.createStructField((String)"inputDouble", (DataType)DataTypes.DoubleType, (boolean)true));
        this._inputDataType = DataTypes.createStructType(inputFields);
        ArrayList<StructField> bufferFields = new ArrayList<StructField>();
        bufferFields.add(DataTypes.createStructField((String)"bufferDouble", (DataType)DataTypes.DoubleType, (boolean)true));
        this._bufferSchema = DataTypes.createStructType(bufferFields);
        this._returnDataType = DataTypes.DoubleType;
    }

    public StructType inputSchema() {
        return this._inputDataType;
    }

    public StructType bufferSchema() {
        return this._bufferSchema;
    }

    public DataType dataType() {
        return this._returnDataType;
    }

    public boolean deterministic() {
        return true;
    }

    public void initialize(MutableAggregationBuffer buffer) {
        buffer.update(0, null);
    }

    public void update(MutableAggregationBuffer buffer, Row input) {
        if (!input.isNullAt(0)) {
            if (buffer.isNullAt(0)) {
                buffer.update(0, (Object)input.getDouble(0));
            } else {
                Double newValue = input.getDouble(0) + buffer.getDouble(0);
                buffer.update(0, (Object)newValue);
            }
        }
    }

    public void merge(MutableAggregationBuffer buffer1, Row buffer2) {
        if (!buffer2.isNullAt(0)) {
            if (buffer1.isNullAt(0)) {
                buffer1.update(0, (Object)buffer2.getDouble(0));
            } else {
                Double newValue = buffer2.getDouble(0) + buffer1.getDouble(0);
                buffer1.update(0, (Object)newValue);
            }
        }
    }

    public Object evaluate(Row buffer) {
        if (buffer.isNullAt(0)) {
            return null;
        }
        return buffer.getDouble(0);
    }
}

