/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst;

import java.sql.Timestamp;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame$;
import org.apache.spark.sql.catalyst.expressions.TimeAdd;
import org.apache.spark.sql.catalyst.expressions.TimeAdd$;
import org.apache.spark.sql.catalyst.expressions.TimeSub;
import org.apache.spark.sql.catalyst.expressions.TimeSub$;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.catalyst.expressions.WindowSpecDefinition;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.test.TestHiveContext;
import org.apache.spark.sql.hive.test.TestHiveSingleton;
import org.apache.spark.sql.hive.test.TestHiveSingleton$class;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e2A!\u0001\u0002\u0001\u001b\tIR\t\u001f9sKN\u001c\u0018n\u001c8T#2\u0013U/\u001b7eKJ\u001cV/\u001b;f\u0015\t\u0019A!\u0001\u0005dCR\fG._:u\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001aB\u0005\t\u0003\u001fAi\u0011\u0001B\u0005\u0003#\u0011\u0011\u0011\"U;fef$Vm\u001d;\u0011\u0005MAR\"\u0001\u000b\u000b\u0005U1\u0012\u0001\u0002;fgRT!a\u0006\u0003\u0002\t!Lg/Z\u0005\u00033Q\u0011\u0011\u0003V3ti\"Kg/Z*j]\u001edW\r^8o\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0003!\u0001\u0011E\u0011%\u0001\u0005dQ\u0016\u001c7nU)M)\r\u0011\u0003\u0006\r\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0005+:LG\u000fC\u0003*?\u0001\u0007!&A\u0001f!\tYc&D\u0001-\u0015\ti#!A\u0006fqB\u0014Xm]:j_:\u001c\u0018BA\u0018-\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\u0006c}\u0001\rAM\u0001\fKb\u0004Xm\u0019;fIN\u000bF\n\u0005\u00024m9\u00111\u0005N\u0005\u0003k\u0011\na\u0001\u0015:fI\u00164\u0017BA\u001c9\u0005\u0019\u0019FO]5oO*\u0011Q\u0007\n")
public class ExpressionSQLBuilderSuite
extends QueryTest
implements TestHiveSingleton {
    private final SparkSession spark;
    private final TestHiveContext hiveContext;
    private final HiveClient hiveClient;

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public TestHiveContext hiveContext() {
        return this.hiveContext;
    }

    @Override
    public HiveClient hiveClient() {
        return this.hiveClient;
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveContext_$eq(TestHiveContext x$1) {
        this.hiveContext = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveClient_$eq(HiveClient x$1) {
        this.hiveClient = x$1;
    }

    @Override
    public void afterAll() {
        TestHiveSingleton$class.afterAll(this);
    }

    public void checkSQL(Expression e, String expectedSQL) {
        String actualSQL = e.sql();
        try {
            String $org_scalatest_assert_macro_left = actualSQL;
            String $org_scalatest_assert_macro_right = expectedSQL;
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
            return;
        }
        catch (Throwable throwable) {
            throw this.fail(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong SQL generated for the following expression:\n             |\n             |", "\n             |\n             |", "\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.prettyName(), throwable})))).stripMargin(), new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
        }
    }

    public ExpressionSQLBuilderSuite() {
        TestHiveSingleton$class.$init$(this);
        this.test("literal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionSQLBuilderSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)"foo"), "'foo'");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)"\"foo\""), "'\"foo\"'");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)"'foo'"), "'\\'foo\\''");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToByte((byte)1)), "1Y");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)2)), "2S");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), "4");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)8L)), "8L");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)1.5f)), "CAST(1.5 AS FLOAT)");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)Float.POSITIVE_INFINITY)), "CAST('Infinity' AS FLOAT)");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)Float.NEGATIVE_INFINITY)), "CAST('-Infinity' AS FLOAT)");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)Float.NaN)), "CAST('NaN' AS FLOAT)");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)2.5)), "2.5D");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY)), "CAST('Infinity' AS DOUBLE)");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Double.NEGATIVE_INFINITY)), "CAST('-Infinity' AS DOUBLE)");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Double.NaN)), "CAST('NaN' AS DOUBLE)");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply("10.0000000").underlying()), "10.0000000BD");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply(Predef$.MODULE$.intArrayOps(new int[]{1, 163}).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final byte apply(int x$1) {
                        return (byte)x$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()))), "X'01A3'");
                this.$outer.checkSQL((Expression)Literal$.MODULE$.apply((Object)Timestamp.valueOf("2016-01-01 00:00:00")), "TIMESTAMP('2016-01-01 00:00:00.0')");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        this.test("attributes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionSQLBuilderSuite $outer;
            private static Symbol symbol$1;
            private static Symbol symbol$2;
            private static Symbol symbol$3;

            static {
                symbol$1 = Symbol$.MODULE$.apply("a");
                symbol$2 = Symbol$.MODULE$.apply("foo bar");
                symbol$3 = Symbol$.MODULE$.apply("int");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslSymbol(symbol$1).int(), "`a`");
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslSymbol(symbol$2).int(), "`foo bar`");
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslSymbol(symbol$3).int(), "`int`");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        this.test("binary comparisons", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionSQLBuilderSuite $outer;
            private static Symbol symbol$4;
            private static Symbol symbol$5;
            private static Symbol symbol$6;

            static {
                symbol$4 = Symbol$.MODULE$.apply("a");
                symbol$5 = Symbol$.MODULE$.apply("b");
                symbol$6 = Symbol$.MODULE$.apply("c");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$4).int()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslSymbol(symbol$5).int()), "(`a` = `b`)");
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$4).int()).$less$eq$greater((Expression)package.expressions$.MODULE$.DslSymbol(symbol$5).int()), "(`a` <=> `b`)");
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$4).int()).$eq$bang$eq((Expression)package.expressions$.MODULE$.DslSymbol(symbol$5).int()), "(NOT (`a` = `b`))");
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$4).int()).$less((Expression)package.expressions$.MODULE$.DslSymbol(symbol$5).int()), "(`a` < `b`)");
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$4).int()).$less$eq((Expression)package.expressions$.MODULE$.DslSymbol(symbol$5).int()), "(`a` <= `b`)");
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$4).int()).$greater((Expression)package.expressions$.MODULE$.DslSymbol(symbol$5).int()), "(`a` > `b`)");
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$4).int()).$greater$eq((Expression)package.expressions$.MODULE$.DslSymbol(symbol$5).int()), "(`a` >= `b`)");
                this.$outer.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$4).int()).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslSymbol(symbol$5).int(), package.expressions$.MODULE$.DslSymbol(symbol$6).int()})), "(`a` IN (`b`, `c`))");
                this.$outer.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$4).int()).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(1), package.expressions$.MODULE$.intToLiteral(2)})), "(`a` IN (1, 2))");
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$4).int()).isNull(), "(`a` IS NULL)");
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$4).int()).isNotNull(), "(`a` IS NOT NULL)");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("logical operators", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionSQLBuilderSuite $outer;
            private static Symbol symbol$7;
            private static Symbol symbol$8;
            private static Symbol symbol$9;

            static {
                symbol$7 = Symbol$.MODULE$.apply("a");
                symbol$8 = Symbol$.MODULE$.apply("b");
                symbol$9 = Symbol$.MODULE$.apply("c");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$7).boolean()).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol(symbol$8).boolean()), "(`a` AND `b`)");
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$7).boolean()).$bar$bar((Expression)package.expressions$.MODULE$.DslSymbol(symbol$8).boolean()), "(`a` OR `b`)");
                this.$outer.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$7).boolean()).unary_$bang(), "(NOT `a`)");
                this.$outer.checkSQL((Expression)new If((Expression)package.expressions$.MODULE$.DslSymbol(symbol$7).boolean(), (Expression)package.expressions$.MODULE$.DslSymbol(symbol$8).int(), (Expression)package.expressions$.MODULE$.DslSymbol(symbol$9).int()), "(IF(`a`, `b`, `c`))");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("arithmetic expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionSQLBuilderSuite $outer;
            private static Symbol symbol$10;
            private static Symbol symbol$11;

            static {
                symbol$10 = Symbol$.MODULE$.apply("a");
                symbol$11 = Symbol$.MODULE$.apply("b");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$10).int()).$plus((Expression)package.expressions$.MODULE$.DslSymbol(symbol$11).int()), "(`a` + `b`)");
                this.$outer.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$10).int()).$minus((Expression)package.expressions$.MODULE$.DslSymbol(symbol$11).int()), "(`a` - `b`)");
                this.$outer.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$10).int()).$times((Expression)package.expressions$.MODULE$.DslSymbol(symbol$11).int()), "(`a` * `b`)");
                this.$outer.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$10).int()).$div((Expression)package.expressions$.MODULE$.DslSymbol(symbol$11).int()), "(`a` / `b`)");
                this.$outer.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$10).int()).$percent((Expression)package.expressions$.MODULE$.DslSymbol(symbol$11).int()), "(`a` % `b`)");
                this.$outer.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$10).int()).unary_$minus(), "(- `a`)");
                this.$outer.checkSQL(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$10).int()).$plus((Expression)package.expressions$.MODULE$.DslSymbol(symbol$11).int())).unary_$minus(), "(- (`a` + `b`))");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("window specification", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionSQLBuilderSuite $outer;
            private static Symbol symbol$12;
            private static Symbol symbol$13;
            private static Symbol symbol$14;
            private static Symbol symbol$15;

            static {
                symbol$12 = Symbol$.MODULE$.apply("a");
                symbol$13 = Symbol$.MODULE$.apply("b");
                symbol$14 = Symbol$.MODULE$.apply("c");
                symbol$15 = Symbol$.MODULE$.apply("d");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SpecifiedWindowFrame frame = SpecifiedWindowFrame$.MODULE$.defaultWindowFrame(true, true);
                AttributeReference attributeReference = package.expressions$.MODULE$.DslSymbol(symbol$12).int();
                this.$outer.checkSQL((Expression)new WindowSpecDefinition((Seq)Nil$.MODULE$.$colon$colon((Object)attributeReference), (Seq)Nil$.MODULE$, (WindowFrame)frame), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(PARTITION BY `a` ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{frame.sql()})));
                AttributeReference attributeReference2 = package.expressions$.MODULE$.DslSymbol(symbol$12).int();
                AttributeReference attributeReference3 = package.expressions$.MODULE$.DslSymbol(symbol$13).string();
                this.$outer.checkSQL((Expression)new WindowSpecDefinition((Seq)Nil$.MODULE$.$colon$colon((Object)attributeReference3).$colon$colon((Object)attributeReference2), (Seq)Nil$.MODULE$, (WindowFrame)frame), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(PARTITION BY `a`, `b` ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{frame.sql()})));
                SortOrder sortOrder = package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$12).int()).asc();
                this.$outer.checkSQL((Expression)new WindowSpecDefinition((Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder), (WindowFrame)frame), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(ORDER BY `a` ASC NULLS FIRST ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{frame.sql()})));
                SortOrder sortOrder2 = package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$12).int()).asc();
                SortOrder sortOrder3 = package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$13).string()).desc();
                this.$outer.checkSQL((Expression)new WindowSpecDefinition((Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder3).$colon$colon((Object)sortOrder2), (WindowFrame)frame), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(ORDER BY `a` ASC NULLS FIRST, `b` DESC NULLS LAST ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{frame.sql()})));
                AttributeReference attributeReference4 = package.expressions$.MODULE$.DslSymbol(symbol$12).int();
                AttributeReference attributeReference5 = package.expressions$.MODULE$.DslSymbol(symbol$13).string();
                SortOrder sortOrder4 = package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$14).int()).asc();
                SortOrder sortOrder5 = package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$15).string()).desc();
                this.$outer.checkSQL((Expression)new WindowSpecDefinition((Seq)Nil$.MODULE$.$colon$colon((Object)attributeReference5).$colon$colon((Object)attributeReference4), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder5).$colon$colon((Object)sortOrder4), (WindowFrame)frame), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(PARTITION BY `a`, `b` ORDER BY `c` ASC NULLS FIRST, `d` DESC NULLS LAST ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{frame.sql()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        this.test("interval arithmetic", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionSQLBuilderSuite $outer;
            private static Symbol symbol$16;

            static {
                symbol$16 = Symbol$.MODULE$.apply("a");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Literal interval = Literal$.MODULE$.apply((Object)new CalendarInterval(0, 86400000000L));
                this.$outer.checkSQL((Expression)new TimeAdd((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$16), (Expression)interval, TimeAdd$.MODULE$.apply$default$3()), "`a` + interval 1 days");
                this.$outer.checkSQL((Expression)new TimeSub((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$16), (Expression)interval, TimeSub$.MODULE$.apply$default$3()), "`a` - interval 1 days");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
    }
}

