/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.File;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.TestUtils$;
import org.apache.spark.sql.hive.HiveExternalCatalogVersionsSuite$;
import org.apache.spark.sql.hive.PROCESS_TABLES$;
import org.apache.spark.sql.hive.SparkSubmitTestUtils;
import org.apache.spark.sql.hive.SparkSubmitTestUtils$class;
import org.apache.spark.util.Utils$;
import org.scalactic.Prettifier;
import org.scalactic.source.Position;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Tag;
import org.scalatest.concurrent.Signaler;
import org.scalatest.concurrent.TimeLimits;
import org.scalatest.enablers.Timed;
import org.scalatest.exceptions.StackDepthException;
import org.scalatest.time.Span;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.sys.process.package$;

@ScalaSignature(bytes="\u0006\u0001%4A!\u0001\u0002\u0001\u001b\t\u0001\u0003*\u001b<f\u000bb$XM\u001d8bY\u000e\u000bG/\u00197pOZ+'o]5p]N\u001cV/\u001b;f\u0015\t\u0019A!\u0001\u0003iSZ,'BA\u0003\u0007\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f%A\u0011q\u0002E\u0007\u0002\r%\u0011\u0011C\u0002\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005M!R\"\u0001\u0002\n\u0005U\u0011!\u0001F*qCJ\\7+\u001e2nSR$Vm\u001d;Vi&d7\u000fC\u0003\u0018\u0001\u0011\u0005\u0001$\u0001\u0004=S:LGO\u0010\u000b\u00023A\u00111\u0003\u0001\u0005\b7\u0001\u0011\r\u0011\"\u0003\u001d\u000359\u0018M]3I_V\u001cX\rU1uQV\tQ\u0004\u0005\u0002\u001fG5\tqD\u0003\u0002!C\u0005\u0011\u0011n\u001c\u0006\u0002E\u0005!!.\u0019<b\u0013\t!sD\u0001\u0003GS2,\u0007B\u0002\u0014\u0001A\u0003%Q$\u0001\bxCJ,\u0007j\\;tKB\u000bG\u000f\u001b\u0011\t\u000f!\u0002!\u0019!C\u00059\u0005QA/\u001c9ECR\fG)\u001b:\t\r)\u0002\u0001\u0015!\u0003\u001e\u0003-!X\u000e\u001d#bi\u0006$\u0015N\u001d\u0011\t\u000f1\u0002!\u0019!C\u00059\u0005y1\u000f]1sWR+7\u000f^5oO\u0012K'\u000f\u0003\u0004/\u0001\u0001\u0006I!H\u0001\u0011gB\f'o\u001b+fgRLgn\u001a#je\u0002Bq\u0001\r\u0001C\u0002\u0013%\u0011'A\u0005v]V\u001cX\r\u001a&beV\t!\u0007\u0005\u00024m5\tAG\u0003\u00026C\u0005\u0019a.\u001a;\n\u0005]\"$aA+S\u0019\"1\u0011\b\u0001Q\u0001\nI\n!\"\u001e8vg\u0016$'*\u0019:!\u0011\u0015Y\u0004\u0001\"\u0011=\u0003!\tg\r^3s\u00032dG#A\u001f\u0011\u0005y\nU\"A \u000b\u0003\u0001\u000bQa]2bY\u0006L!AQ \u0003\tUs\u0017\u000e\u001e\u0005\u0006\t\u0002!I!R\u0001\u0011iJLHi\\<oY>\fGm\u00159be.$2!\u0010$P\u0011\u001595\t1\u0001I\u0003\u001d1XM]:j_:\u0004\"!\u0013'\u000f\u0005yR\u0015BA&@\u0003\u0019\u0001&/\u001a3fM&\u0011QJ\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-{\u0004\"\u0002)D\u0001\u0004A\u0015\u0001\u00029bi\"DQA\u0015\u0001\u0005\nM\u000bQ\u0002Z8x]2|\u0017\rZ*qCJ\\GCA\u001fU\u0011\u00159\u0015\u000b1\u0001I\u0011\u00151\u0006\u0001\"\u0003X\u0003)9WM\u001c#bi\u0006$\u0015N\u001d\u000b\u0003\u0011bCQ!W+A\u0002!\u000bAA\\1nK\")1\f\u0001C\u00059\u0006qq-\u001a;GS2,gI]8n+JdG\u0003B\u001f^?\u0006DQA\u0018.A\u0002!\u000b\u0011\"\u001e:m'R\u0014\u0018N\\4\t\u000b\u0001T\u0006\u0019\u0001%\u0002\u0013Q\f'oZ3u\t&\u0014\b\"\u00022[\u0001\u0004A\u0015\u0001\u00034jY\u0016t\u0017-\\3\t\u000b\u0011\u0004A\u0011B3\u0002!\u001d,Go\u0015;sS:<gI]8n+JdGC\u0001%g\u0011\u0015q6\r1\u0001I\u0011\u0015A\u0007\u0001\"\u0011=\u0003%\u0011WMZ8sK\u0006cG\u000e")
public class HiveExternalCatalogVersionsSuite
extends SparkFunSuite
implements SparkSubmitTestUtils {
    private final File org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$wareHousePath;
    private final File tmpDataDir;
    private final File org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$sparkTestingDir;
    private final URL org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$unusedJar;
    private final Signaler defaultSignaler;

    @Override
    public Signaler defaultSignaler() {
        return this.defaultSignaler;
    }

    @Override
    public void org$apache$spark$sql$hive$SparkSubmitTestUtils$_setter_$defaultSignaler_$eq(Signaler x$1) {
        this.defaultSignaler = x$1;
    }

    @Override
    public void runSparkSubmit(Seq<String> args, Option<String> sparkHomeOpt) {
        SparkSubmitTestUtils$class.runSparkSubmit(this, args, sparkHomeOpt);
    }

    @Override
    public Option<String> runSparkSubmit$default$2() {
        return SparkSubmitTestUtils$class.runSparkSubmit$default$2(this);
    }

    public <T> T failAfter(Span timeout, Function0<T> fun, Signaler signaler, Prettifier prettifier, Position pos, Timed<T> timed) {
        return (T)TimeLimits.class.failAfter((TimeLimits)this, (Span)timeout, fun, (Signaler)signaler, (Prettifier)prettifier, (Position)pos, timed);
    }

    public <T> T failAfterImpl(Span timeout, Signaler signaler, Prettifier prettifier, Option<Position> pos, Function1<StackDepthException, Object> stackDepthFun, Function0<T> fun, Timed<T> timed) {
        return (T)TimeLimits.class.failAfterImpl((TimeLimits)this, (Span)timeout, (Signaler)signaler, (Prettifier)prettifier, pos, stackDepthFun, fun, timed);
    }

    public <T> T cancelAfter(Span timeout, Function0<T> fun, Signaler signaler, Prettifier prettifier, Position pos, Timed<T> timed) {
        return (T)TimeLimits.class.cancelAfter((TimeLimits)this, (Span)timeout, fun, (Signaler)signaler, (Prettifier)prettifier, (Position)pos, timed);
    }

    public <T> T cancelAfterImpl(Span timeout, Signaler signaler, Prettifier prettifier, Option<Position> pos, Function1<StackDepthException, Object> stackDepthFun, Function0<T> fun, Timed<T> timed) {
        return (T)TimeLimits.class.cancelAfterImpl((TimeLimits)this, (Span)timeout, (Signaler)signaler, (Prettifier)prettifier, pos, stackDepthFun, fun, timed);
    }

    public <T> Prettifier failAfter$default$4(Span timeout, Function0<T> fun) {
        return TimeLimits.class.failAfter$default$4((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> Position failAfter$default$5(Span timeout, Function0<T> fun) {
        return TimeLimits.class.failAfter$default$5((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> Timed<T> failAfter$default$6(Span timeout, Function0<T> fun) {
        return TimeLimits.class.failAfter$default$6((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> Prettifier cancelAfter$default$4(Span timeout, Function0<T> fun) {
        return TimeLimits.class.cancelAfter$default$4((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> Position cancelAfter$default$5(Span timeout, Function0<T> fun) {
        return TimeLimits.class.cancelAfter$default$5((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> Timed<T> cancelAfter$default$6(Span timeout, Function0<T> fun) {
        return TimeLimits.class.cancelAfter$default$6((TimeLimits)this, (Span)timeout, fun);
    }

    public File org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$wareHousePath() {
        return this.org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$wareHousePath;
    }

    private File tmpDataDir() {
        return this.tmpDataDir;
    }

    public File org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$sparkTestingDir() {
        return this.org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$sparkTestingDir;
    }

    public URL org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$unusedJar() {
        return this.org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$unusedJar;
    }

    public void afterAll() {
        Utils$.MODULE$.deleteRecursively(this.org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$wareHousePath());
        Utils$.MODULE$.deleteRecursively(this.tmpDataDir());
        Utils$.MODULE$.deleteRecursively(this.org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$sparkTestingDir());
        super.afterAll();
    }

    private void tryDownloadSpark(String version, String path) {
        Object object = new Object();
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)new Serializable(this, version, path, object){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HiveExternalCatalogVersionsSuite $outer;
                public final String version$1;
                private final String path$1;
                private final Object nonLocalReturnKey1$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    String preferredMirror = this.$outer.org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$getStringFromUrl("https://www.apache.org/dyn/closer.lua?preferred=true");
                    String filename = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark-", "-bin-hadoop2.7.tgz"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.version$1}));
                    String url = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/spark/spark-", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{preferredMirror, this.version$1, filename}));
                    this.$outer.logInfo((Function0)new Serializable(this, url){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$tryDownloadSpark$1 $outer;
                        private final String url$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Downloading Spark ", " from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.version$1, this.url$1}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.url$1 = url$1;
                        }
                    });
                    try {
                        this.$outer.org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$getFileFromUrl(url, this.path$1, filename);
                        throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                    }
                    catch (Exception exception) {
                        this.$outer.logWarning((Function0)new Serializable(this, url){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$tryDownloadSpark$1 $outer;
                            private final String url$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to download Spark ", " from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.version$1, this.url$1}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.url$1 = url$1;
                            }
                        }, exception);
                        return;
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.version$1 = version$1;
                    this.path$1 = path$1;
                    this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                }
            });
            throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to download Spark ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{version})), new Position("HiveExternalCatalogVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                nonLocalReturnControl.value$mcV$sp();
                return;
            }
            throw nonLocalReturnControl;
        }
    }

    public void org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$downloadSpark(String version) {
        this.tryDownloadSpark(version, this.org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$sparkTestingDir().getCanonicalPath());
        String downloaded = new File(this.org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$sparkTestingDir(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark-", "-bin-hadoop2.7.tgz"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{version}))).getCanonicalPath();
        String targetDir = new File(this.org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$sparkTestingDir(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{version}))).getCanonicalPath();
        package$.MODULE$.stringSeqToProcess((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mkdir", targetDir}))).$bang();
        package$.MODULE$.stringSeqToProcess((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tar", "-xzf", downloaded, "-C", targetDir, "--strip-components=1"}))).$bang();
        package$.MODULE$.stringSeqToProcess((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rm", downloaded}))).$bang();
    }

    private String genDataDir(String name) {
        return new File(this.tmpDataDir(), name).getCanonicalPath();
    }

    public void org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$getFileFromUrl(String urlString, String targetDir, String filename) {
        SparkConf conf = new SparkConf();
        conf.set("spark.files.overwrite", "true");
        SecurityManager securityManager = new SecurityManager(conf, SecurityManager$.MODULE$.$lessinit$greater$default$2());
        Configuration hadoopConf = new Configuration();
        File outDir = new File(targetDir);
        Object object = outDir.exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)outDir.mkdirs());
        Utils$.MODULE$.doFetchFile(urlString, outDir, filename, conf, securityManager, hadoopConf);
    }

    public String org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$getStringFromUrl(String urlString) {
        File contentFile = File.createTempFile("string-", ".txt");
        contentFile.deleteOnExit();
        this.org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$getFileFromUrl(urlString, contentFile.getParent(), contentFile.getName());
        Path contentPath = Paths.get(contentFile.toURI());
        return new String(Files.readAllBytes(contentPath), StandardCharsets.UTF_8);
    }

    public void beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
        File tempPyFile = File.createTempFile("test", ".py");
        Files.write(tempPyFile.toPath(), new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |from pyspark.sql import SparkSession\n        |import os\n        |\n        |spark = SparkSession.builder.enableHiveSupport().getOrCreate()\n        |version_index = spark.conf.get(\"spark.sql.test.version.index\", None)\n        |\n        |spark.sql(\"create table data_source_tbl_{} using json as select 1 i\".format(version_index))\n        |\n        |spark.sql(\"create table hive_compatible_data_source_tbl_{} using parquet as select 1 i\".format(version_index))\n        |\n        |json_file = \"", "\" + str(version_index)\n        |spark.range(1, 2).selectExpr(\"cast(id as int) as i\").write.json(json_file)\n        |spark.sql(\"create table external_data_source_tbl_{}(i int) using json options (path '{}')\".format(version_index, json_file))\n        |\n        |parquet_file = \"", "\" + str(version_index)\n        |spark.range(1, 2).selectExpr(\"cast(id as int) as i\").write.parquet(parquet_file)\n        |spark.sql(\"create table hive_compatible_external_data_source_tbl_{}(i int) using parquet options (path '{}')\".format(version_index, parquet_file))\n        |\n        |json_file2 = \"", "\" + str(version_index)\n        |spark.range(1, 2).selectExpr(\"cast(id as int) as i\").write.json(json_file2)\n        |spark.sql(\"create table external_table_without_schema_{} using json options (path '{}')\".format(version_index, json_file2))\n        |\n        |parquet_file2 = \"", "\" + str(version_index)\n        |spark.range(1, 3).selectExpr(\"1 as i\", \"cast(id as int) as p\", \"1 as j\").write.parquet(os.path.join(parquet_file2, \"p=1\"))\n        |spark.sql(\"create table tbl_with_col_overlap_{} using parquet options(path '{}')\".format(version_index, parquet_file2))\n        |\n        |spark.sql(\"create view v_{} as select 1 i\".format(version_index))\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genDataDir("json_"), this.genDataDir("parquet_"), this.genDataDir("json2_"), this.genDataDir("parquet2_")})))).stripMargin().getBytes("utf8"), new OpenOption[0]);
        ((IterableLike)PROCESS_TABLES$.MODULE$.testingVersions().zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, tempPyFile){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HiveExternalCatalogVersionsSuite $outer;
            private final File tempPyFile$1;

            public final void apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String version = (String)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    File sparkHome = new File(this.$outer.org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$sparkTestingDir(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{version})));
                    if (!sparkHome.exists()) {
                        this.$outer.org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$downloadSpark(version);
                    }
                    Seq args = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--name", "prepare testing tables", "--master", "local[2]", "--conf", "spark.ui.enabled=false", "--conf", "spark.master.rest.enabled=false", "--conf", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark.sql.warehouse.dir=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$wareHousePath().getCanonicalPath()})), "--conf", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark.sql.test.version.index=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index)})), "--driver-java-options", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-Dderby.system.home=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$wareHousePath().getCanonicalPath()})), this.tempPyFile$1.getCanonicalPath()}));
                    this.$outer.runSparkSubmit((Seq<String>)args, (Option<String>)new Some((Object)sparkHome.getCanonicalPath()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tempPyFile$1 = tempPyFile$1;
            }
        });
        tempPyFile.delete();
    }

    public HiveExternalCatalogVersionsSuite() {
        TimeLimits.class.$init$((TimeLimits)this);
        SparkSubmitTestUtils$class.$init$(this);
        String x$7 = "warehouse";
        String x$8 = Utils$.MODULE$.createTempDir$default$1();
        this.org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$wareHousePath = Utils$.MODULE$.createTempDir(x$8, x$7);
        String x$9 = "test-data";
        String x$10 = Utils$.MODULE$.createTempDir$default$1();
        this.tmpDataDir = Utils$.MODULE$.createTempDir(x$10, x$9);
        this.org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$sparkTestingDir = new File("/tmp/test-spark");
        this.org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$unusedJar = TestUtils$.MODULE$.createJarWithClasses((Seq)Seq$.MODULE$.empty(), TestUtils$.MODULE$.createJarWithClasses$default$2(), TestUtils$.MODULE$.createJarWithClasses$default$3(), TestUtils$.MODULE$.createJarWithClasses$default$4());
        this.test("backward compatibility", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HiveExternalCatalogVersionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq args = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--class", new StringOps(Predef$.MODULE$.augmentString(((Object)((Object)PROCESS_TABLES$.MODULE$)).getClass().getName())).stripSuffix("$"), "--name", "HiveExternalCatalog backward compatibility test", "--master", "local[2]", "--conf", "spark.ui.enabled=false", "--conf", "spark.master.rest.enabled=false", "--conf", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark.sql.warehouse.dir=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$wareHousePath().getCanonicalPath()})), "--driver-java-options", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-Dderby.system.home=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$wareHousePath().getCanonicalPath()})), this.$outer.org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$unusedJar().toString()}));
                this.$outer.runSparkSubmit((Seq<String>)args, this.$outer.runSparkSubmit$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("HiveExternalCatalogVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
    }
}

