/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.File;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.apache.spark.sql.hive.SparkSubmitTestUtils;
import org.apache.spark.sql.hive.SparkSubmitTestUtils$;
import org.apache.spark.sql.test.ProcessTestUtils;
import org.apache.spark.util.Utils$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.concurrent.Signaler;
import org.scalatest.concurrent.ThreadSignaler$;
import org.scalatest.enablers.Timed$;
import org.scalatest.exceptions.TestFailedDueToTimeoutException;
import org.scalatest.time.SpanSugar$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;

public abstract class SparkSubmitTestUtils$class {
    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void runSparkSubmit(SparkSubmitTestUtils $this, Seq args, Option sparkHomeOpt) {
        String sparkHome = (String)sparkHomeOpt.getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkSubmitTestUtils $outer;

            public final String apply() {
                return (String)package$.MODULE$.props().getOrElse((Object)"spark.test.home", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ SparkSubmitTestUtils$.anonfun.2 $outer;

                    public final Nothing$ apply() {
                        return ((Assertions)this.$outer.org$apache$spark$sql$hive$SparkSubmitTestUtils$$anonfun$$$outer()).fail("spark.test.home is not set!", new Position("SparkSubmitTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ SparkSubmitTestUtils org$apache$spark$sql$hive$SparkSubmitTestUtils$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ArrayBuffer history = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        String sparkSubmit = Utils$.MODULE$.isWindows() ? new File("..\\..\\bin\\spark-submit.cmd").getAbsolutePath() : "./bin/spark-submit";
        Seq commands = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sparkSubmit}))).$plus$plus((GenTraversableOnce)args, Seq$.MODULE$.canBuildFrom());
        String commandLine = commands.mkString("'", "' '", "'");
        ProcessBuilder builder = new ProcessBuilder((String[])commands.toArray(ClassTag$.MODULE$.apply(String.class))).directory(new File(sparkHome));
        Map<String, String> env = builder.environment();
        env.put("SPARK_TESTING", "1");
        env.put("SPARK_HOME", sparkHome);
        Process process = builder.start();
        new ProcessTestUtils.ProcessOutputCapturer(process.getInputStream(), (Function1)new Serializable($this, history){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkSubmitTestUtils $outer;
            private final ArrayBuffer history$1;

            public final void apply(String line) {
                SparkSubmitTestUtils$class.captureOutput$1(this.$outer, "stdout", line, this.history$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.history$1 = history$1;
            }
        }).start();
        new ProcessTestUtils.ProcessOutputCapturer(process.getErrorStream(), (Function1)new Serializable($this, history){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkSubmitTestUtils $outer;
            private final ArrayBuffer history$1;

            public final void apply(String line) {
                SparkSubmitTestUtils$class.captureOutput$1(this.$outer, "stderr", line, this.history$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.history$1 = history$1;
            }
        }).start();
        try {
            int exitCode = BoxesRunTime.unboxToInt((Object)$this.failAfter(SpanSugar$.MODULE$.convertIntToGrainOfTime(300).seconds(), (Function0)new Serializable($this, process){
                public static final long serialVersionUID = 0L;
                private final Process process$1;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return this.process$1.waitFor();
                }
                {
                    this.process$1 = process$1;
                }
            }, $this.defaultSignaler(), Prettifier$.MODULE$.default(), new Position("SparkSubmitTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78), Timed$.MODULE$.timed()));
            if (exitCode != 0) {
                Thread.sleep(1000L);
                String historyLog = history.mkString("\n");
                throw ((Assertions)$this).fail(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark-submit returned with exit code ", ".\n             |Command line: ", "\n             |\n             |", "\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)exitCode), commandLine, historyLog})))).stripMargin(), new Position("SparkSubmitTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            }
            process.destroy();
            return;
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
                catch (TestFailedDueToTimeoutException testFailedDueToTimeoutException) {
                    void var7_7;
                    void var4_4;
                    String historyLog = var4_4.mkString("\n");
                    throw ((Assertions)$this).fail(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timeout of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var7_7}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" See the log4j logs for more detail."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{historyLog}))).toString(), (Throwable)testFailedDueToTimeoutException, new Position("SparkSubmitTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
                }
            }
            catch (Throwable throwable2) {
                void var10_10;
                var10_10.destroy();
                throw throwable2;
            }
        }
    }

    public static Option runSparkSubmit$default$2(SparkSubmitTestUtils $this) {
        return None$.MODULE$;
    }

    public static final void captureOutput$1(SparkSubmitTestUtils $this, String source, String line, ArrayBuffer history$1) {
        String logLine = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " - ", "> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new Timestamp(new Date().getTime()), source, line}));
        Predef$.MODULE$.println((Object)logLine);
        history$1.$plus$eq((Object)logLine);
    }

    public static void $init$(SparkSubmitTestUtils $this) {
        $this.org$apache$spark$sql$hive$SparkSubmitTestUtils$_setter_$defaultSignaler_$eq((Signaler)ThreadSignaler$.MODULE$);
    }
}

