/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.hive.TemporaryHiveUDFTest$;
import org.apache.spark.sql.hive.test.TestHiveContext;
import org.apache.spark.sql.hive.test.TestHiveContext$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class TemporaryHiveUDFTest$
implements Logging {
    public static final TemporaryHiveUDFTest$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new TemporaryHiveUDFTest$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public void main(String[] args) {
        Utils$.MODULE$.configTestLog4j("INFO");
        SparkConf conf = new SparkConf();
        conf.set("spark.ui.enabled", "false");
        SparkContext sc = new SparkContext(conf);
        TestHiveContext hiveContext = new TestHiveContext(sc, TestHiveContext$.MODULE$.$lessinit$greater$default$2());
        this.logInfo((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Registering a temporary Hive UDF provided in a jar.";
            }
        });
        String jar = hiveContext.getHiveFile("hive-contrib-0.13.1.jar").getCanonicalPath();
        hiveContext.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |CREATE TEMPORARY FUNCTION example_max\n         |AS 'org.apache.hadoop.hive.contrib.udaf.example.UDAFExampleMax'\n         |USING JAR '", "'\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jar})))).stripMargin());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_sql_hive_TemporaryHiveUDFTest$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$)})));
            }

            public Org_apache_spark_sql_hive_TemporaryHiveUDFTest$$typecreator1$1() {
            }
        }
        Dataset source = hiveContext.createDataFrame((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, String> apply(int i) {
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"str", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom()), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_TemporaryHiveUDFTest$$typecreator1$1())).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", "val"}));
        source.createOrReplaceTempView("sourceTable");
        this.logInfo((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Using the UDF.";
            }
        });
        Dataset result = hiveContext.sql("SELECT example_max(key) as key, val FROM sourceTable GROUP BY val");
        this.logInfo((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Running a simple query on the table.";
            }
        });
        long count = result.orderBy("key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"val"})).count();
        if (count != 10L) {
            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Result table should have 10 rows instead of ", " rows"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)count)})));
        }
        hiveContext.sql("DROP temporary FUNCTION example_max");
        this.logInfo((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Test finishes.";
            }
        });
        sc.stop();
    }

    private TemporaryHiveUDFTest$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

