/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.hive.execution.HiveComparisonTest;
import org.apache.spark.sql.hive.execution.HiveTableScanExec;
import org.apache.spark.sql.hive.test.TestHive$;
import org.apache.spark.sql.hive.test.TestHiveQueryExecution;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u001d3A!\u0001\u0002\u0001\u001f\ta\u0001K];oS:<7+^5uK*\u00111\u0001B\u0001\nKb,7-\u001e;j_:T!!\u0002\u0004\u0002\t!Lg/\u001a\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001A!\u0002CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005IA\u0015N^3D_6\u0004\u0018M]5t_:$Vm\u001d;\u0011\u0005UAR\"\u0001\f\u000b\u0005]a\u0011!C:dC2\fG/Z:u\u0013\tIbC\u0001\bCK\u001a|'/Z!oI\u00063G/\u001a:\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002CA\t\u0001\u0011\u0015y\u0002\u0001\"\u0011!\u0003%\u0011WMZ8sK\u0006cG\u000eF\u0001\"!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0011)f.\u001b;\t\u000b!\u0002A\u0011A\u0015\u0002#\r\u0014X-\u0019;f!J,h.\u001b8h)\u0016\u001cH\u000f\u0006\u0004\"UM\"$\t\u0012\u0005\u0006W\u001d\u0002\r\u0001L\u0001\ri\u0016\u001cHoQ1tK:\u000bW.\u001a\t\u0003[Ar!A\t\u0018\n\u0005=\u001a\u0013A\u0002)sK\u0012,g-\u0003\u00022e\t11\u000b\u001e:j]\u001eT!aL\u0012\t\u000b\u001d9\u0003\u0019\u0001\u0017\t\u000bU:\u0003\u0019\u0001\u001c\u0002+\u0015D\b/Z2uK\u0012|U\u000f\u001e9vi\u000e{G.^7ogB\u0019qg\u0010\u0017\u000f\u0005ajdBA\u001d=\u001b\u0005Q$BA\u001e\u000f\u0003\u0019a$o\\8u}%\tA%\u0003\u0002?G\u00059\u0001/Y2lC\u001e,\u0017B\u0001!B\u0005\r\u0019V-\u001d\u0006\u0003}\rBQaQ\u0014A\u0002Y\na#\u001a=qK\u000e$X\rZ*dC:tW\rZ\"pYVlgn\u001d\u0005\u0006\u000b\u001e\u0002\rAR\u0001\u0013Kb\u0004Xm\u0019;fIB\u000b'\u000f\u001e,bYV,7\u000fE\u00028\u007fY\u0002")
public class PruningSuite
extends HiveComparisonTest
implements BeforeAndAfter {
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public void beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
        TestHive$.MODULE$.setCacheTables(false);
        TestHive$.MODULE$.reset();
    }

    public void createPruningTest(String testCaseName, String sql, Seq<String> expectedOutputColumns, Seq<String> expectedScannedColumns, Seq<Seq<String>> expectedPartValues) {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " - pruning test"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{testCaseName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, sql, expectedOutputColumns, expectedScannedColumns, expectedPartValues){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PruningSuite $outer;
            private final String sql$1;
            private final Seq expectedOutputColumns$1;
            private final Seq expectedScannedColumns$1;
            private final Seq expectedPartValues$1;

            public final Assertion apply() {
                SparkPlan plan = new TestHiveQueryExecution(this.sql$1).sparkPlan();
                Seq actualOutputColumns = (Seq)plan.output().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Attribute x$1) {
                        return x$1.name();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Tuple2 tuple2 = (Tuple2)plan.collect((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof HiveTableScanExec) {
                            HiveTableScanExec hiveTableScanExec = (HiveTableScanExec)A1;
                            Seq columns = hiveTableScanExec.requestedAttributes();
                            HiveTableRelation relation = hiveTableScanExec.relation();
                            Seq columnNames = (Seq)columns.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(Attribute x$2) {
                                    return x$2.name();
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                            Seq partValues = relation.isPartitioned() ? (Seq)hiveTableScanExec.prunePartitions(hiveTableScanExec.rawPartitions()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final List<String> apply(Partition x$3) {
                                    return x$3.getValues();
                                }
                            }, Seq$.MODULE$.canBuildFrom()) : (Seq)Seq$.MODULE$.empty();
                            object = new Tuple2((Object)columnNames, (Object)partValues);
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(SparkPlan x1) {
                        SparkPlan sparkPlan = x1;
                        boolean bl = sparkPlan instanceof HiveTableScanExec;
                        return bl;
                    }
                }).head();
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    Seq actualScannedColumns = (Seq)tuple2._1();
                    Seq actualPartValues = (Seq)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)actualScannedColumns, (Object)actualPartValues);
                    Seq actualScannedColumns2 = (Seq)tuple23._1();
                    Seq actualPartValues2 = (Seq)tuple23._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(actualOutputColumns);
                    Seq $org_scalatest_assert_macro_right = this.expectedOutputColumns$1;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Output columns mismatch", Prettifier$.MODULE$.default(), new Position("PruningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(actualScannedColumns2.sorted((Ordering)Ordering.String$.MODULE$));
                    Seq $org_scalatest_assert_macro_right2 = (Seq)this.expectedScannedColumns$1.sorted((Ordering)Ordering.String$.MODULE$);
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Scanned columns mismatch", Prettifier$.MODULE$.default(), new Position("PruningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
                    Seq actualPartitions = (Seq)((SeqLike)actualPartValues2.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(List<String> x$5) {
                            return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$5).asScala()).mkString(",");
                        }
                    }, Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$);
                    Seq expectedPartitions = (Seq)((SeqLike)this.expectedPartValues$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Seq<String> x$6) {
                            return x$6.mkString(",");
                        }
                    }, Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(actualPartitions);
                    Seq $org_scalatest_assert_macro_right3 = expectedPartitions;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"Partitions selected do not match", Prettifier$.MODULE$.default(), new Position("PruningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sql$1 = sql$1;
                this.expectedOutputColumns$1 = expectedOutputColumns$1;
                this.expectedScannedColumns$1 = expectedScannedColumns$1;
                this.expectedPartValues$1 = expectedPartValues$1;
            }
        }, new Position("PruningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        this.createQueryTest(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " - query test"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{testCaseName})), sql, this.createQueryTest$default$3(), this.createQueryTest$default$4(), this.createQueryTest$default$5());
    }

    public PruningSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        this.createPruningTest("Column pruning - with partitioned table", "SELECT key FROM srcpart WHERE ds = '2008-04-08' LIMIT 3", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2008-04-08", "11"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2008-04-08", "12"}))}))));
        this.createPruningTest("Column pruning - with non-partitioned table", "SELECT key FROM src WHERE key > 10 LIMIT 3", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.empty()));
        this.createPruningTest("Column pruning - with multiple projects", "SELECT c1 FROM (SELECT key AS c1 FROM src WHERE key > 10) t1 LIMIT 3", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c1"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.empty()));
        this.createPruningTest("Column pruning - projects alias substituting", "SELECT c1 AS c2 FROM (SELECT key AS c1 FROM src WHERE key > 10) t1 LIMIT 3", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c2"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.empty()));
        this.createPruningTest("Column pruning - filter alias in-lining", "SELECT c1 FROM (SELECT key AS c1 FROM src WHERE key > 10) t1 WHERE c1 < 100 LIMIT 3", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c1"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.empty()));
        this.createPruningTest("Column pruning - without filters", "SELECT c1 FROM (SELECT key AS c1 FROM src) t1 LIMIT 3", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c1"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.empty()));
        this.createPruningTest("Column pruning - simple top project without aliases", "SELECT key FROM (SELECT key FROM src WHERE key > 10) t1 WHERE key < 100 LIMIT 3", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.empty()));
        this.createPruningTest("Column pruning - non-trivial top project with aliases", "SELECT c1 * 2 AS dbl FROM (SELECT key AS c1 FROM src WHERE key > 10) t1 LIMIT 3", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dbl"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.empty()));
        this.createPruningTest("Partition pruning - non-partitioned, non-trivial project", "SELECT key * 2 AS dbl FROM src WHERE value IS NOT NULL", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dbl"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", "value"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.empty()));
        this.createPruningTest("Partition pruning - non-partitioned table", "SELECT value FROM src WHERE key IS NOT NULL", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", "key"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.empty()));
        this.createPruningTest("Partition pruning - with filter on string partition key", "SELECT value, hr FROM srcpart1 WHERE ds = '2008-04-08'", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", "hr"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", "hr"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2008-04-08", "11"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2008-04-08", "12"}))}))));
        this.createPruningTest("Partition pruning - with filter on int partition key", "SELECT value, hr FROM srcpart1 WHERE hr < 12", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", "hr"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", "hr"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2008-04-08", "11"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2008-04-09", "11"}))}))));
        this.createPruningTest("Partition pruning - left only 1 partition", "SELECT value, hr FROM srcpart1 WHERE ds = '2008-04-08' AND hr < 12", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", "hr"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", "hr"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2008-04-08", "11"}))}))));
        this.createPruningTest("Partition pruning - all partitions pruned", "SELECT value, hr FROM srcpart1 WHERE ds = '2014-01-27' AND hr = 11", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", "hr"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", "hr"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.empty()));
        this.createPruningTest("Partition pruning - pruning with both column key and partition key", "SELECT value, hr FROM srcpart1 WHERE value IS NOT NULL AND hr < 12", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", "hr"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", "hr"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2008-04-08", "11"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2008-04-09", "11"}))}))));
    }
}

