/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.util.VersionInfo;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.client.HiveClientImpl;
import org.apache.spark.sql.hive.client.HiveClientImpl$;
import org.apache.spark.sql.hive.client.IsolatedClientLoader;
import org.apache.spark.sql.hive.client.IsolatedClientLoader$;
import org.apache.spark.sql.hive.client.package;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.ChildFirstURLClassLoader;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class HiveUtils$
implements Logging {
    public static HiveUtils$ MODULE$;
    private final String builtinHiveVersion;
    private final ConfigEntry<String> HIVE_METASTORE_VERSION;
    private final ConfigEntry<String> FAKE_HIVE_VERSION;
    private final ConfigEntry<String> HIVE_METASTORE_JARS;
    private final ConfigEntry<Object> CONVERT_METASTORE_PARQUET;
    private final ConfigEntry<Object> CONVERT_METASTORE_PARQUET_WITH_SCHEMA_MERGING;
    private final ConfigEntry<Object> CONVERT_METASTORE_ORC;
    private final ConfigEntry<Seq<String>> HIVE_METASTORE_SHARED_PREFIXES;
    private final ConfigEntry<Seq<String>> HIVE_METASTORE_BARRIER_PREFIXES;
    private final ConfigEntry<Object> HIVE_THRIFT_SERVER_ASYNC;
    private final Seq<AtomicType> primitiveTypes;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new HiveUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkContext withHiveExternalCatalog(SparkContext sc) {
        sc.conf().set(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION().key(), "hive");
        return sc;
    }

    public String builtinHiveVersion() {
        return this.builtinHiveVersion;
    }

    public ConfigEntry<String> HIVE_METASTORE_VERSION() {
        return this.HIVE_METASTORE_VERSION;
    }

    public ConfigEntry<String> FAKE_HIVE_VERSION() {
        return this.FAKE_HIVE_VERSION;
    }

    public ConfigEntry<String> HIVE_METASTORE_JARS() {
        return this.HIVE_METASTORE_JARS;
    }

    public ConfigEntry<Object> CONVERT_METASTORE_PARQUET() {
        return this.CONVERT_METASTORE_PARQUET;
    }

    public ConfigEntry<Object> CONVERT_METASTORE_PARQUET_WITH_SCHEMA_MERGING() {
        return this.CONVERT_METASTORE_PARQUET_WITH_SCHEMA_MERGING;
    }

    public ConfigEntry<Object> CONVERT_METASTORE_ORC() {
        return this.CONVERT_METASTORE_ORC;
    }

    public ConfigEntry<Seq<String>> HIVE_METASTORE_SHARED_PREFIXES() {
        return this.HIVE_METASTORE_SHARED_PREFIXES;
    }

    private Seq<String> jdbcPrefixes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"com.mysql.jdbc", "org.postgresql", "com.microsoft.sqlserver", "oracle.jdbc"}));
    }

    public ConfigEntry<Seq<String>> HIVE_METASTORE_BARRIER_PREFIXES() {
        return this.HIVE_METASTORE_BARRIER_PREFIXES;
    }

    public ConfigEntry<Object> HIVE_THRIFT_SERVER_ASYNC() {
        return this.HIVE_THRIFT_SERVER_ASYNC;
    }

    private String hiveMetastoreVersion(SQLConf conf) {
        return (String)conf.getConf(this.HIVE_METASTORE_VERSION());
    }

    private String hiveMetastoreJars(SQLConf conf) {
        return (String)conf.getConf(this.HIVE_METASTORE_JARS());
    }

    private Seq<String> hiveMetastoreSharedPrefixes(SQLConf conf) {
        return (Seq)((TraversableLike)conf.getConf(this.HIVE_METASTORE_SHARED_PREFIXES())).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HiveUtils$.$anonfun$hiveMetastoreSharedPrefixes$1(x$1)));
    }

    private Seq<String> hiveMetastoreBarrierPrefixes(SQLConf conf) {
        return (Seq)((TraversableLike)conf.getConf(this.HIVE_METASTORE_BARRIER_PREFIXES())).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HiveUtils$.$anonfun$hiveMetastoreBarrierPrefixes$1(x$2)));
    }

    public Map<String, String> formatTimeVarsForHiveClient(Configuration hadoopConf) {
        return ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_CLIENT_CONNECT_RETRY_DELAY), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_CLIENT_SOCKET_TIMEOUT), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_CLIENT_SOCKET_LIFETIME), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HMSHANDLERINTERVAL), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_EVENT_DB_LISTENER_TTL), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_EVENT_CLEAN_FREQ), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_EVENT_EXPIRY_DURATION), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_AGGREGATE_STATS_CACHE_TTL), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_AGGREGATE_STATS_CACHE_MAX_WRITER_WAIT), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_AGGREGATE_STATS_CACHE_MAX_READER_WAIT), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVES_AUTO_PROGRESS_TIMEOUT), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_LOG_INCREMENTAL_PLAN_PROGRESS_INTERVAL), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_STATS_JDBC_TIMEOUT), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_STATS_RETRIES_WAIT), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_LOCK_SLEEP_BETWEEN_RETRIES), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_ZOOKEEPER_SESSION_TIMEOUT), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_ZOOKEEPER_CONNECTION_BASESLEEPTIME), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_TXN_TIMEOUT), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_COMPACTOR_WORKER_TIMEOUT), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_COMPACTOR_CHECK_INTERVAL), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RUN_INTERVAL), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_MAX_IDLE_TIME), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_WORKER_KEEPALIVE_TIME), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_COOKIE_MAX_AGE), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_THRIFT_LOGIN_BEBACKOFF_SLOT_LENGTH), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_THRIFT_LOGIN_TIMEOUT), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_THRIFT_WORKER_KEEPALIVE_TIME), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_SHUTDOWN_TIMEOUT), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_KEEPALIVE_TIME), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_LONG_POLLING_TIMEOUT), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_SESSION_CHECK_INTERVAL), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_IDLE_SESSION_TIMEOUT), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_IDLE_OPERATION_TIMEOUT), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.SERVER_READ_SOCKET_TIMEOUT), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_LOCALIZE_RESOURCE_WAIT_INTERVAL), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.SPARK_CLIENT_FUTURE_TIMEOUT), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.SPARK_JOB_MONITOR_TIMEOUT), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.SPARK_RPC_CLIENT_CONNECT_TIMEOUT), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.SPARK_RPC_CLIENT_HANDSHAKE_TIMEOUT), (Object)TimeUnit.MILLISECONDS)}))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            HiveConf.ConfVars confVar = (HiveConf.ConfVars)tuple2._1();
            TimeUnit unit = (TimeUnit)((Object)((Object)tuple2._2()));
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)confVar.varname), (Object)((Object)BoxesRunTime.boxToLong((long)HiveConf.getTimeVar((Configuration)hadoopConf, (HiveConf.ConfVars)confVar, (TimeUnit)unit))).toString());
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    /*
     * WARNING - void declaration
     */
    public boolean isCliSessionState() {
        void var3_3;
        boolean found = false;
        for (Class temp = (state = SessionState.get()) != null ? state.getClass() : null; temp != null && !found; temp = temp.getSuperclass()) {
            String string = temp.getName();
            String string2 = "org.apache.hadoop.hive.cli.CliSessionState";
            found = !(string != null ? !string.equals(string2) : string2 != null);
        }
        return (boolean)var3_3;
    }

    public HiveClientImpl newClientForExecution(SparkConf conf, Configuration hadoopConf) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Initializing execution hive, version ").append(MODULE$.builtinHiveVersion()).toString());
        package.HiveVersion x$1 = IsolatedClientLoader$.MODULE$.hiveVersion(this.builtinHiveVersion());
        SparkConf x$2 = conf;
        Seq x$3 = (Seq)Seq$.MODULE$.empty();
        Configuration x$4 = hadoopConf;
        Map<String, String> x$5 = this.newTemporaryConfiguration(true);
        boolean x$6 = false;
        ClassLoader x$7 = Utils$.MODULE$.getContextOrSparkClassLoader();
        boolean x$8 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$7();
        ClassLoader x$9 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$8();
        Seq<String> x$10 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$10();
        Seq<String> x$11 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$11();
        IsolatedClientLoader loader = new IsolatedClientLoader(x$1, x$2, x$4, (Seq<URL>)x$3, x$5, x$6, x$8, x$9, x$7, x$10, x$11);
        return (HiveClientImpl)loader.createClient();
    }

    public HiveClient newClientForMetadata(SparkConf conf, Configuration hadoopConf) {
        Map<String, String> configurations = this.formatTimeVarsForHiveClient(hadoopConf);
        return this.newClientForMetadata(conf, hadoopConf, configurations);
    }

    public HiveClient newClientForMetadata(SparkConf conf, Configuration hadoopConf, Map<String, String> configurations) {
        IsolatedClientLoader isolatedClientLoader;
        SQLConf sqlConf = new SQLConf();
        sqlConf.setConf(SQLContext$.MODULE$.getSQLProperties(conf));
        String hiveMetastoreVersion = this.hiveMetastoreVersion(sqlConf);
        String hiveMetastoreJars = this.hiveMetastoreJars(sqlConf);
        Seq<String> hiveMetastoreSharedPrefixes = this.hiveMetastoreSharedPrefixes(sqlConf);
        Seq<String> hiveMetastoreBarrierPrefixes = this.hiveMetastoreBarrierPrefixes(sqlConf);
        package.HiveVersion metaVersion = IsolatedClientLoader$.MODULE$.hiveVersion(hiveMetastoreVersion);
        String string = hiveMetastoreJars;
        String string2 = "builtin";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = this.builtinHiveVersion();
            String string4 = hiveMetastoreVersion;
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                throw new IllegalArgumentException(new StringBuilder(181).append("Builtin jars can only be used when hive execution version == hive metastore version. ").append("Execution: ").append(this.builtinHiveVersion()).append(" != Metastore: ").append(hiveMetastoreVersion).append(". ").append("Specify a valid path to the correct hive jars using ").append(this.HIVE_METASTORE_JARS().key()).append(" ").append("or change ").append(this.HIVE_METASTORE_VERSION().key()).append(" to ").append(this.builtinHiveVersion()).append(".").toString());
            }
            ClassLoader classLoader = Utils$.MODULE$.getContextOrSparkClassLoader();
            URL[] jars = this.allJars$1(classLoader);
            if (jars.length == 0) {
                throw new IllegalArgumentException(new StringBuilder(64).append("Unable to locate hive jars to connect to metastore. ").append("Please set ").append(this.HIVE_METASTORE_JARS().key()).append(".").toString());
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Initializing HiveMetastoreConnection version ").append(hiveMetastoreVersion).append(" using Spark classes.").toString());
            package.HiveVersion x$1 = metaVersion;
            SparkConf x$2 = conf;
            Configuration x$3 = hadoopConf;
            Seq x$4 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])jars)).toSeq();
            Map<String, String> x$52 = configurations;
            boolean x$6 = !this.isCliSessionState();
            Seq<String> x$7 = hiveMetastoreBarrierPrefixes;
            Seq<String> x$8 = hiveMetastoreSharedPrefixes;
            boolean x$9 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$7();
            ClassLoader x$10 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$8();
            ClassLoader x$11 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$9();
            isolatedClientLoader = new IsolatedClientLoader(x$1, x$2, x$3, (Seq<URL>)x$4, x$52, x$6, x$9, x$10, x$11, x$8, x$7);
        } else {
            String string5 = hiveMetastoreJars;
            String string6 = "maven";
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Initializing HiveMetastoreConnection version ").append(hiveMetastoreVersion).append(" using maven.").toString());
                String x$12 = hiveMetastoreVersion;
                String x$13 = VersionInfo.getVersion();
                SparkConf x$14 = conf;
                Configuration x$15 = hadoopConf;
                Map<String, String> x$16 = configurations;
                Seq<String> x$17 = hiveMetastoreBarrierPrefixes;
                Seq<String> x$18 = hiveMetastoreSharedPrefixes;
                Option<String> x$19 = IsolatedClientLoader$.MODULE$.forVersion$default$6();
                boolean x$20 = IsolatedClientLoader$.MODULE$.forVersion$default$9();
                isolatedClientLoader = IsolatedClientLoader$.MODULE$.forVersion(x$12, x$13, x$14, x$15, x$16, x$19, x$18, x$17, x$20);
            } else {
                URL[] jars = (URL[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hiveMetastoreJars.split(File.pathSeparator))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    List list;
                    String string = x0$1;
                    String string2 = new File(string).getName();
                    String string3 = "*";
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        ArrayOps.ofRef ofRef2;
                        File[] files = new File(string).getParentFile().listFiles();
                        if (files == null) {
                            MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Hive jar path '").append(string).append("' does not exist.").toString());
                            ofRef2 = Nil$.MODULE$;
                        } else {
                            ofRef2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HiveUtils$.$anonfun$newClientForMetadata$5(x$3)))));
                        }
                        list = ofRef2;
                    } else {
                        File file = new File(string);
                        list = Nil$.MODULE$.$colon$colon((Object)file);
                    }
                    return list;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toURI().toURL(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(URL.class)));
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Initializing HiveMetastoreConnection version ").append(hiveMetastoreVersion).append(" ").append("using ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])jars)).mkString(":")).toString());
                package.HiveVersion x$21 = metaVersion;
                SparkConf x$22 = conf;
                Configuration x$23 = hadoopConf;
                Seq x$24 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])jars)).toSeq();
                Map<String, String> x$25 = configurations;
                boolean x$26 = true;
                Seq<String> x$27 = hiveMetastoreBarrierPrefixes;
                Seq<String> x$28 = hiveMetastoreSharedPrefixes;
                boolean x$29 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$7();
                ClassLoader x$30 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$8();
                ClassLoader x$31 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$9();
                isolatedClientLoader = new IsolatedClientLoader(x$21, x$22, x$23, (Seq<URL>)x$24, x$25, x$26, x$29, x$30, x$31, x$28, x$27);
            }
        }
        IsolatedClientLoader isolatedLoader = isolatedClientLoader;
        return isolatedLoader.createClient();
    }

    public Map<String, String> newTemporaryConfiguration(boolean useInMemoryDerby) {
        String withInMemoryMode = useInMemoryDerby ? "memory:" : "";
        File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        File localMetastore = new File(tempDir, "metastore");
        HashMap propMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])HiveConf.ConfVars.values())).foreach((Function1 & Serializable & scala.Serializable)confvar -> confvar.varname.contains("datanucleus") || confvar.varname.contains("jdo") || confvar.varname.contains("hive.metastore.rawstore.impl") ? propMap.put((Object)confvar.varname, (Object)confvar.getDefaultExpr()) : BoxedUnit.UNIT);
        propMap.put((Object)StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key(), (Object)localMetastore.toURI().toString());
        propMap.put((Object)HiveConf.ConfVars.METASTORECONNECTURLKEY.varname, (Object)new StringBuilder(37).append("jdbc:derby:").append(withInMemoryMode).append(";databaseName=").append(localMetastore.getAbsolutePath()).append(";create=true").toString());
        propMap.put((Object)"datanucleus.rdbms.datastoreAdapterClassName", (Object)"org.datanucleus.store.rdbms.adapter.DerbyAdapter");
        propMap.put((Object)HiveConf.ConfVars.METASTOREURIS.varname, (Object)"");
        propMap.put((Object)HiveConf.ConfVars.METASTORE_PRE_EVENT_LISTENERS.varname, (Object)"");
        propMap.put((Object)HiveConf.ConfVars.METASTORE_EVENT_LISTENERS.varname, (Object)"");
        propMap.put((Object)HiveConf.ConfVars.METASTORE_END_FUNCTION_LISTENERS.varname, (Object)"");
        SparkHadoopUtil$.MODULE$.get().appendSparkHadoopConfigs(package$.MODULE$.props().toMap(Predef$.MODULE$.$conforms()), propMap);
        return propMap.toMap(Predef$.MODULE$.$conforms());
    }

    public Seq<AtomicType> primitiveTypes() {
        return this.primitiveTypes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toHiveString(Tuple2<Object, DataType> a2) {
        Object object;
        Tuple2<Object, DataType> tuple2 = a2;
        if (tuple2 != null) {
            Object struct = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (struct instanceof Row) {
                Row row = (Row)struct;
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    StructField[] fields = structType.fields();
                    return ((TraversableOnce)((TraversableLike)row.toSeq().zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])fields), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Object v = tuple2._1();
                        StructField t = (StructField)tuple2._2();
                        String string = new StringBuilder(3).append("\"").append(t.name()).append("\":").append(MODULE$.toHiveStructString((Tuple2<Object, DataType>)new Tuple2(v, (Object)t.dataType()))).toString();
                        return string;
                    }, Seq$.MODULE$.canBuildFrom())).mkString("{", ",", "}");
                }
            }
        }
        if (tuple2 != null) {
            Object seq = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (seq instanceof Seq) {
                Seq seq2 = (Seq)seq;
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType typ = arrayType.elementType();
                    return ((TraversableOnce)((TraversableLike)seq2.map((Function1 & Serializable & scala.Serializable)v -> new Tuple2(v, (Object)typ), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)a -> MODULE$.toHiveStructString((Tuple2<Object, DataType>)a), Seq$.MODULE$.canBuildFrom())).mkString("[", ",", "]");
                }
            }
        }
        if (tuple2 != null) {
            Object map = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (map instanceof Map) {
                Map map2 = (Map)map;
                if (dataType instanceof MapType) {
                    MapType mapType = (MapType)dataType;
                    DataType kType = mapType.keyType();
                    DataType vType = mapType.valueType();
                    return ((TraversableOnce)((TraversableOnce)map2.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Object key = tuple2._1();
                        Object value = tuple2._2();
                        String string = new StringBuilder(1).append(MODULE$.toHiveStructString((Tuple2<Object, DataType>)new Tuple2(key, (Object)kType))).append(":").append(MODULE$.toHiveStructString((Tuple2<Object, DataType>)new Tuple2(value, (Object)vType))).toString();
                        return string;
                    }, Iterable$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString("{", ",", "}");
                }
            }
        }
        if (tuple2 != null && (object = tuple2._1()) == null) {
            return "NULL";
        }
        if (tuple2 != null) {
            Object d = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (d instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)d);
                if (DateType$.MODULE$.equals(dataType)) {
                    return new DateWritable(n).toString();
                }
            }
        }
        if (tuple2 != null) {
            Object t = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (t instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)t;
                if (TimestampType$.MODULE$.equals(dataType)) {
                    return new TimestampWritable(timestamp).toString();
                }
            }
        }
        if (tuple2 != null) {
            Object bin = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (bin instanceof byte[]) {
                byte[] byArray = (byte[])bin;
                if (BinaryType$.MODULE$.equals(dataType)) {
                    return new String(byArray, StandardCharsets.UTF_8);
                }
            }
        }
        if (tuple2 != null) {
            Object decimal = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (decimal instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)decimal;
                if (DecimalType$.MODULE$.unapply(dataType)) {
                    return HiveDecimal.create((BigDecimal)bigDecimal).toString();
                }
            }
        }
        if (tuple2 != null) {
            Object other = tuple2._1();
            if (tuple2._2() instanceof UserDefinedType) {
                return other.toString();
            }
        }
        if (tuple2 == null) throw new MatchError(tuple2);
        Object other = tuple2._1();
        DataType tpe = (DataType)tuple2._2();
        if (!this.primitiveTypes().contains((Object)tpe)) throw new MatchError(tuple2);
        return other.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toHiveStructString(Tuple2<Object, DataType> a2) {
        Object object;
        Tuple2<Object, DataType> tuple2 = a2;
        if (tuple2 != null) {
            Object struct = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (struct instanceof Row) {
                Row row = (Row)struct;
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    StructField[] fields = structType.fields();
                    return ((TraversableOnce)((TraversableLike)row.toSeq().zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])fields), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Object v = tuple2._1();
                        StructField t = (StructField)tuple2._2();
                        String string = new StringBuilder(3).append("\"").append(t.name()).append("\":").append(MODULE$.toHiveStructString((Tuple2<Object, DataType>)new Tuple2(v, (Object)t.dataType()))).toString();
                        return string;
                    }, Seq$.MODULE$.canBuildFrom())).mkString("{", ",", "}");
                }
            }
        }
        if (tuple2 != null) {
            Object seq = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (seq instanceof Seq) {
                Seq seq2 = (Seq)seq;
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType typ = arrayType.elementType();
                    return ((TraversableOnce)((TraversableLike)seq2.map((Function1 & Serializable & scala.Serializable)v -> new Tuple2(v, (Object)typ), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)a -> MODULE$.toHiveStructString((Tuple2<Object, DataType>)a), Seq$.MODULE$.canBuildFrom())).mkString("[", ",", "]");
                }
            }
        }
        if (tuple2 != null) {
            Object map = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (map instanceof Map) {
                Map map2 = (Map)map;
                if (dataType instanceof MapType) {
                    MapType mapType = (MapType)dataType;
                    DataType kType = mapType.keyType();
                    DataType vType = mapType.valueType();
                    return ((TraversableOnce)((TraversableOnce)map2.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Object key = tuple2._1();
                        Object value = tuple2._2();
                        String string = new StringBuilder(1).append(MODULE$.toHiveStructString((Tuple2<Object, DataType>)new Tuple2(key, (Object)kType))).append(":").append(MODULE$.toHiveStructString((Tuple2<Object, DataType>)new Tuple2(value, (Object)vType))).toString();
                        return string;
                    }, Iterable$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString("{", ",", "}");
                }
            }
        }
        if (tuple2 != null && (object = tuple2._1()) == null) {
            return "null";
        }
        if (tuple2 != null) {
            Object s = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (s instanceof String) {
                String string = (String)s;
                if (StringType$.MODULE$.equals(dataType)) {
                    return new StringBuilder(2).append("\"").append(string).append("\"").toString();
                }
            }
        }
        if (tuple2 != null) {
            Object decimal = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DecimalType$.MODULE$.unapply(dataType)) {
                return decimal.toString();
            }
        }
        if (tuple2 == null) throw new MatchError(tuple2);
        Object other = tuple2._1();
        DataType tpe = (DataType)tuple2._2();
        if (!this.primitiveTypes().contains((Object)tpe)) throw new MatchError(tuple2);
        return other.toString();
    }

    public CatalogTable inferSchema(CatalogTable table) {
        CatalogTable catalogTable;
        if (DDLUtils$.MODULE$.isDatasourceTable(table) || table.dataSchema().nonEmpty()) {
            catalogTable = table;
        } else {
            Table hiveTable = HiveClientImpl$.MODULE$.toHiveTable(table, HiveClientImpl$.MODULE$.toHiveTable$default$2());
            Buffer partCols = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(hiveTable.getPartCols()).asScala()).map((Function1 & Serializable & scala.Serializable)hc -> HiveClientImpl$.MODULE$.fromHiveColumn((FieldSchema)hc), Buffer$.MODULE$.canBuildFrom());
            Buffer dataCols = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(hiveTable.getCols()).asScala()).map((Function1 & Serializable & scala.Serializable)hc -> HiveClientImpl$.MODULE$.fromHiveColumn((FieldSchema)hc), Buffer$.MODULE$.canBuildFrom());
            StructType x$1 = StructType$.MODULE$.apply((Seq)dataCols.$plus$plus((GenTraversableOnce)partCols));
            TableIdentifier x$2 = table.copy$default$1();
            CatalogTableType x$3 = table.copy$default$2();
            CatalogStorageFormat x$4 = table.copy$default$3();
            Option x$5 = table.copy$default$5();
            Seq x$6 = table.copy$default$6();
            Option x$7 = table.copy$default$7();
            String x$8 = table.copy$default$8();
            long x$9 = table.copy$default$9();
            long x$10 = table.copy$default$10();
            String x$11 = table.copy$default$11();
            Map x$12 = table.copy$default$12();
            Option x$13 = table.copy$default$13();
            Option x$14 = table.copy$default$14();
            Option x$15 = table.copy$default$15();
            Seq x$16 = table.copy$default$16();
            boolean x$17 = table.copy$default$17();
            boolean x$18 = table.copy$default$18();
            Map x$19 = table.copy$default$19();
            catalogTable = table.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19);
        }
        return catalogTable;
    }

    public static final /* synthetic */ boolean $anonfun$hiveMetastoreSharedPrefixes$1(String x$1) {
        String string = x$1;
        String string2 = "";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$hiveMetastoreBarrierPrefixes$1(String x$2) {
        String string = x$2;
        String string2 = "";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final URL[] allJars$1(ClassLoader classLoader) {
        URL[] uRLArray;
        while (true) {
            ClassLoader classLoader2;
            if ((classLoader2 = classLoader) == null) {
                uRLArray = (URL[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(URL.class));
                break;
            }
            if (classLoader2 instanceof ChildFirstURLClassLoader) {
                ChildFirstURLClassLoader childFirstURLClassLoader = (ChildFirstURLClassLoader)classLoader2;
                uRLArray = (URL[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])childFirstURLClassLoader.getURLs())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.allJars$1(Utils$.MODULE$.getSparkClassLoader()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(URL.class)));
                break;
            }
            if (classLoader2 instanceof URLClassLoader) {
                URLClassLoader uRLClassLoader = (URLClassLoader)classLoader2;
                uRLArray = (URL[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])uRLClassLoader.getURLs())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.allJars$1(uRLClassLoader.getParent()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(URL.class)));
                break;
            }
            classLoader = classLoader2.getParent();
        }
        return uRLArray;
    }

    public static final /* synthetic */ boolean $anonfun$newClientForMetadata$5(File x$3) {
        return x$3.getName().toLowerCase(Locale.ROOT).endsWith(".jar");
    }

    private HiveUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.builtinHiveVersion = "1.2.1";
        this.HIVE_METASTORE_VERSION = SQLConf$.MODULE$.buildConf("spark.sql.hive.metastore.version").doc(new StringBuilder(100).append("Version of the Hive metastore. Available options are ").append("<code>0.12.0</code> through <code>2.3.3</code>.").toString()).stringConf().createWithDefault((Object)this.builtinHiveVersion());
        this.FAKE_HIVE_VERSION = SQLConf$.MODULE$.buildConf("spark.sql.hive.version").doc(new StringBuilder(57).append("deprecated, please use ").append(this.HIVE_METASTORE_VERSION().key()).append(" to get the Hive version in Spark.").toString()).stringConf().createWithDefault((Object)this.builtinHiveVersion());
        this.HIVE_METASTORE_JARS = SQLConf$.MODULE$.buildConf("spark.sql.hive.metastore.jars").doc(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(590).append("\n      | Location of the jars that should be used to instantiate the HiveMetastoreClient.\n      | This property can be one of three options: \"\n      | 1. \"builtin\"\n      |   Use Hive ").append(this.builtinHiveVersion()).append(", which is bundled with the Spark assembly when\n      |   <code>-Phive</code> is enabled. When this option is chosen,\n      |   <code>spark.sql.hive.metastore.version</code> must be either\n      |   <code>").append(this.builtinHiveVersion()).append("</code> or not defined.\n      | 2. \"maven\"\n      |   Use Hive jars of specified version downloaded from Maven repositories.\n      | 3. A classpath in the standard format for both Hive and Hadoop.\n      ").toString())).stripMargin()).stringConf().createWithDefault((Object)"builtin");
        this.CONVERT_METASTORE_PARQUET = SQLConf$.MODULE$.buildConf("spark.sql.hive.convertMetastoreParquet").doc("When set to true, the built-in Parquet reader and writer are used to process parquet tables created by using the HiveQL syntax, instead of Hive serde.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.CONVERT_METASTORE_PARQUET_WITH_SCHEMA_MERGING = SQLConf$.MODULE$.buildConf("spark.sql.hive.convertMetastoreParquet.mergeSchema").doc("When true, also tries to merge possibly different but compatible Parquet schemas in different Parquet data files. This configuration is only effective when \"spark.sql.hive.convertMetastoreParquet\" is true.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.CONVERT_METASTORE_ORC = SQLConf$.MODULE$.buildConf("spark.sql.hive.convertMetastoreOrc").doc("When set to true, the built-in ORC reader and writer are used to process ORC tables created by using the HiveQL syntax, instead of Hive serde.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.HIVE_METASTORE_SHARED_PREFIXES = SQLConf$.MODULE$.buildConf("spark.sql.hive.metastore.sharedPrefixes").doc("A comma separated list of class prefixes that should be loaded using the classloader that is shared between Spark SQL and a specific version of Hive. An example of classes that should be shared is JDBC drivers that are needed to talk to the metastore. Other classes that need to be shared are those that interact with classes that are already shared. For example, custom appenders that are used by log4j.").stringConf().toSequence().createWithDefault(this.jdbcPrefixes());
        this.HIVE_METASTORE_BARRIER_PREFIXES = SQLConf$.MODULE$.buildConf("spark.sql.hive.metastore.barrierPrefixes").doc("A comma separated list of class prefixes that should explicitly be reloaded for each version of Hive that Spark SQL is communicating with. For example, Hive UDFs that are declared in a prefix that typically would be shared (i.e. <code>org.apache.spark.*</code>).").stringConf().toSequence().createWithDefault((Object)Nil$.MODULE$);
        this.HIVE_THRIFT_SERVER_ASYNC = SQLConf$.MODULE$.buildConf("spark.sql.hive.thriftServer.async").doc("When set to true, Hive Thrift server executes SQL queries in an asynchronous way.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.primitiveTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, DoubleType$.MODULE$, FloatType$.MODULE$, BooleanType$.MODULE$, ByteType$.MODULE$, ShortType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$, BinaryType$.MODULE$}));
    }
}

