/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class SparkOrcNewRecordReader
extends org.apache.hadoop.mapreduce.RecordReader<NullWritable, OrcStruct> {
    private final RecordReader reader;
    private final int numColumns;
    OrcStruct value;
    private float progress = 0.0f;
    private ObjectInspector objectInspector;

    public SparkOrcNewRecordReader(Reader file, Configuration conf, long offset, long length) throws IOException {
        this.numColumns = file.getTypes().isEmpty() ? 0 : ((OrcProto.Type)file.getTypes().get(0)).getSubtypesCount();
        this.value = new OrcStruct(this.numColumns);
        this.reader = OrcInputFormat.createReaderFromFile((Reader)file, (Configuration)conf, (long)offset, (long)length);
        this.objectInspector = file.getObjectInspector();
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public NullWritable getCurrentKey() throws IOException, InterruptedException {
        return NullWritable.get();
    }

    public OrcStruct getCurrentValue() throws IOException, InterruptedException {
        return this.value;
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.progress;
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.reader.hasNext()) {
            this.reader.next((Object)this.value);
            this.progress = this.reader.getProgress();
            return true;
        }
        return false;
    }

    public ObjectInspector getObjectInspector() {
        return this.objectInspector;
    }
}

