/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import java.io.Serializable;
import java.util.Locale;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.orc.OrcConf;
import org.apache.spark.sql.execution.datasources.orc.OrcOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.internal.SQLConf;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;

public final class HiveOptions$
implements scala.Serializable {
    public static HiveOptions$ MODULE$;
    private final Set<String> org$apache$spark$sql$hive$execution$HiveOptions$$lowerCasedOptionNames;
    private final String FILE_FORMAT;
    private final String INPUT_FORMAT;
    private final String OUTPUT_FORMAT;
    private final String SERDE;
    private final Map<String, String> delimiterOptions;

    static {
        new HiveOptions$();
    }

    public Set<String> org$apache$spark$sql$hive$execution$HiveOptions$$lowerCasedOptionNames() {
        return this.org$apache$spark$sql$hive$execution$HiveOptions$$lowerCasedOptionNames;
    }

    private String newOption(String name) {
        this.org$apache$spark$sql$hive$execution$HiveOptions$$lowerCasedOptionNames().$plus$eq((Object)name.toLowerCase(Locale.ROOT));
        return name;
    }

    public String FILE_FORMAT() {
        return this.FILE_FORMAT;
    }

    public String INPUT_FORMAT() {
        return this.INPUT_FORMAT;
    }

    public String OUTPUT_FORMAT() {
        return this.OUTPUT_FORMAT;
    }

    public String SERDE() {
        return this.SERDE;
    }

    public Map<String, String> delimiterOptions() {
        return this.delimiterOptions;
    }

    public Option<Tuple2<String, String>> getHiveWriteCompression(TableDesc tableInfo, SQLConf sqlConf) {
        None$ none$;
        Map tableProps = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(tableInfo.getProperties()).asScala()).toMap(Predef$.MODULE$.$conforms());
        String string = tableInfo.getOutputFileFormatClassName().toLowerCase(Locale.ROOT);
        if (string.endsWith("parquetoutputformat")) {
            String compressionCodec = new ParquetOptions(tableProps, sqlConf).compressionCodecClassName();
            none$ = Option$.MODULE$.apply((Object)new Tuple2((Object)"parquet.compression", (Object)compressionCodec));
        } else if (string.endsWith("orcoutputformat")) {
            String compressionCodec = new OrcOptions(tableProps, sqlConf).compressionCodec();
            none$ = Option$.MODULE$.apply((Object)new Tuple2((Object)OrcConf.COMPRESS.getAttribute(), (Object)compressionCodec));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private HiveOptions$() {
        MODULE$ = this;
        this.org$apache$spark$sql$hive$execution$HiveOptions$$lowerCasedOptionNames = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.FILE_FORMAT = this.newOption("fileFormat");
        this.INPUT_FORMAT = this.newOption("inputFormat");
        this.OUTPUT_FORMAT = this.newOption("outputFormat");
        this.SERDE = this.newOption("serde");
        this.delimiterOptions = (Map)((TraversableLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldDelim"), (Object)"field.delim"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"escapeDelim"), (Object)"escape.delim"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"collectionDelim"), (Object)"colelction.delim"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mapkeyDelim"), (Object)"mapkey.delim"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lineDelim"), (Object)"line.delim")}))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k.toLowerCase(Locale.ROOT)), (Object)v);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }
}

