/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.hive.ParquetEncryptionSuite$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.test.TestHiveContext;
import org.apache.spark.sql.hive.test.TestHiveSingleton;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001)4A\u0001D\u0007\u00011!)1\u0005\u0001C\u0001I!9q\u0005\u0001b\u0001\n\u0013A\u0003BB\u001b\u0001A\u0003%\u0011\u0006C\u00047\u0001\t\u0007I\u0011B\u001c\t\ry\u0002\u0001\u0015!\u00039\u0011\u001dy\u0004A1A\u0005\n]Ba\u0001\u0011\u0001!\u0002\u0013A\u0004bB!\u0001\u0005\u0004%Ia\u000e\u0005\u0007\u0005\u0002\u0001\u000b\u0011\u0002\u001d\t\u000b\r\u0003A\u0011\u0002#\t\u000b]\u0003A\u0011\u0002-\u0003-A\u000b'/];fi\u0016s7M]=qi&|gnU;ji\u0016T!AD\b\u0002\t!Lg/\u001a\u0006\u0003!E\t1a]9m\u0015\t\u00112#A\u0003ta\u0006\u00148N\u0003\u0002\u0015+\u00051\u0011\r]1dQ\u0016T\u0011AF\u0001\u0004_J<7\u0001A\n\u0004\u0001ei\u0002C\u0001\u000e\u001c\u001b\u0005y\u0011B\u0001\u000f\u0010\u0005%\tV/\u001a:z)\u0016\u001cH\u000f\u0005\u0002\u001fC5\tqD\u0003\u0002!\u001b\u0005!A/Z:u\u0013\t\u0011sDA\tUKN$\b*\u001b<f'&tw\r\\3u_:\fa\u0001P5oSRtD#A\u0013\u0011\u0005\u0019\u0002Q\"A\u0007\u0002\u000f\u0015t7m\u001c3feV\t\u0011\u0006\u0005\u0002+e9\u00111\u0006M\u0007\u0002Y)\u0011QFL\u0001\u0005kRLGNC\u00010\u0003\u0011Q\u0017M^1\n\u0005Eb\u0013A\u0002\"bg\u00164D'\u0003\u00024i\t9QI\\2pI\u0016\u0014(BA\u0019-\u0003!)gnY8eKJ\u0004\u0013!\u00034p_R,'oS3z+\u0005A\u0004CA\u001d=\u001b\u0005Q$BA\u001e/\u0003\u0011a\u0017M\\4\n\u0005uR$AB*ue&tw-\u0001\u0006g_>$XM]&fs\u0002\nAa[3zc\u0005)1.Z=2A\u0005!1.Z=3\u0003\u0015YW-\u001f\u001a!\u0003Y1XM]5gsB\u000b'/];fi\u0016s7M]=qi\u0016$GCA#L!\t1\u0015*D\u0001H\u0015\u0005A\u0015!B:dC2\f\u0017B\u0001&H\u0005\u0011)f.\u001b;\t\u000b1S\u0001\u0019A'\u0002\u0015A\f'/];fi\u0012K'\u000f\u0005\u0002O+:\u0011qj\u0015\t\u0003!\u001ek\u0011!\u0015\u0006\u0003%^\ta\u0001\u0010:p_Rt\u0014B\u0001+H\u0003\u0019\u0001&/\u001a3fM&\u0011QH\u0016\u0006\u0003)\u001e\u000bQcZ3u\u0019&\u001cHo\u00144QCJ\fX/\u001a;GS2,7\u000f\u0006\u0002ZQB\u0019!l\u00182\u000f\u0005mkfB\u0001)]\u0013\u0005A\u0015B\u00010H\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001Y1\u0003\t1K7\u000f\u001e\u0006\u0003=\u001e\u0003\"a\u00194\u000e\u0003\u0011T!!\u001a\u0018\u0002\u0005%|\u0017BA4e\u0005\u00111\u0015\u000e\\3\t\u000b%\\\u0001\u0019\u00012\u0002\u0007\u0011L'\u000f")
public class ParquetEncryptionSuite
extends QueryTest
implements TestHiveSingleton {
    private final Base64.Encoder encoder;
    private final String footerKey;
    private final String key1;
    private final String key2;
    private final boolean enableAutoThreadAudit;
    private final SparkSession spark;
    private final TestHiveContext hiveContext;
    private final HiveClient hiveClient;

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public void afterAll() {
        TestHiveSingleton.afterAll$(this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public TestHiveContext hiveContext() {
        return this.hiveContext;
    }

    @Override
    public HiveClient hiveClient() {
        return this.hiveClient;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveContext_$eq(TestHiveContext x$1) {
        this.hiveContext = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveClient_$eq(HiveClient x$1) {
        this.hiveClient = x$1;
    }

    private Base64.Encoder encoder() {
        return this.encoder;
    }

    private String footerKey() {
        return this.footerKey;
    }

    private String key1() {
        return this.key1;
    }

    private String key2() {
        return this.key2;
    }

    private void verifyParquetEncrypted(String parquetDir) {
        List<File> parquetPartitionFiles = this.getListOfParquetFiles(new File(parquetDir));
        int $org_scalatest_assert_macro_left = parquetPartitionFiles.size();
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left >= $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetEncryptionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        parquetPartitionFiles.foreach((Function1 & Serializable & scala.Serializable)parquetFile -> {
            String magicString = "PARE";
            int magicStringLength = magicString.length();
            byte[] byteArray = new byte[magicStringLength];
            try (RandomAccessFile randomAccessFile = new RandomAccessFile((File)parquetFile, "r");){
                randomAccessFile.read(byteArray, 0, magicStringLength);
            }
            String stringRead = new String(byteArray, StandardCharsets.UTF_8);
            String $org_scalatest_assert_macro_left = magicString;
            String $org_scalatest_assert_macro_right = stringRead;
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetEncryptionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        });
    }

    private List<File> getListOfParquetFiles(File dir) {
        return (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isFile())))).toList().filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)ParquetEncryptionSuite.$anonfun$getListOfParquetFiles$2(file)));
    }

    public static final /* synthetic */ boolean $anonfun$getListOfParquetFiles$2(File file) {
        return file.getName().endsWith("parquet");
    }

    public ParquetEncryptionSuite() {
        TestHiveSingleton.$init$(this);
        this.encoder = Base64.getEncoder();
        this.footerKey = this.encoder().encodeToString("0123456789012345".getBytes(StandardCharsets.UTF_8));
        this.key1 = this.encoder().encodeToString("1234567890123450".getBytes(StandardCharsets.UTF_8));
        this.key2 = this.encoder().encodeToString("1234567890123451".getBytes(StandardCharsets.UTF_8));
        this.test("SPARK-34990: Write and read an encrypted parquet", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1 & Serializable & scala.Serializable)dir -> {
            this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parquet.crypto.factory.class"), (Object)"org.apache.parquet.crypto.keytools.PropertiesDrivenCryptoFactory"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parquet.encryption.kms.client.class"), (Object)"org.apache.parquet.crypto.keytools.mocks.InMemoryKMS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parquet.encryption.key.list"), (Object)new StringBuilder(27).append("footerKey: ").append(this.footerKey()).append(", key1: ").append(this.key1()).append(", key2: ").append(this.key2()).toString())}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ParquetEncryptionSuite.class.getClassLoader());
                public final class $typecreator6$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                    }

                    public $typecreator6$1(ParquetEncryptionSuite $outer) {
                    }
                }
                Dataset inputDF = $this.spark().implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)22), (Object)BoxesRunTime.boxToInteger((int)333)), (List)Nil$.MODULE$), $this.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new $typecreator6$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}));
                String parquetDir = new File(dir, "parquet").getCanonicalPath();
                inputDF.write().option("parquet.encryption.column.keys", "key1: a, b; key2: c").option("parquet.encryption.footer.key", "footerKey").parquet(parquetDir);
                $this.verifyParquetEncrypted(parquetDir);
                Dataset parquetDF = $this.spark().read().parquet(parquetDir);
                Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])parquetDF.inputFiles());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "nonEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left).nonEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetEncryptionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
                Dataset readDataset = parquetDF.select("a", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c"}));
                $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> readDataset, inputDF);
            });
            return BoxedUnit.UNIT;
        }), new Position("ParquetEncryptionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        this.test("SPARK-37117: Can't read files in Parquet encryption external key material mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1 & Serializable & scala.Serializable)dir -> {
            this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parquet.crypto.factory.class"), (Object)"org.apache.parquet.crypto.keytools.PropertiesDrivenCryptoFactory"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parquet.encryption.kms.client.class"), (Object)"org.apache.parquet.crypto.keytools.mocks.InMemoryKMS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parquet.encryption.key.material.store.internally"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parquet.encryption.key.list"), (Object)new StringBuilder(27).append("footerKey: ").append(this.footerKey()).append(", key1: ").append(this.key1()).append(", key2: ").append(this.key2()).toString())}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ParquetEncryptionSuite.class.getClassLoader());
                public final class $typecreator16$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                    }

                    public $typecreator16$1(ParquetEncryptionSuite $outer) {
                    }
                }
                Dataset inputDF = $this.spark().implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)22), (Object)BoxesRunTime.boxToInteger((int)333)), (List)Nil$.MODULE$), $this.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new $typecreator16$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}));
                String parquetDir = new File(dir, "parquet").getCanonicalPath();
                inputDF.write().option("parquet.encryption.column.keys", "key1: a, b; key2: c").option("parquet.encryption.footer.key", "footerKey").parquet(parquetDir);
                Dataset parquetDF = $this.spark().read().parquet(parquetDir);
                Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])parquetDF.inputFiles());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "nonEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left).nonEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetEncryptionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
                Dataset readDataset = parquetDF.select("a", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c"}));
                $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> readDataset, inputDF);
            });
            return BoxedUnit.UNIT;
        }), new Position("ParquetEncryptionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        this.test("SPARK-42114: Test of uniform parquet encryption", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1 & Serializable & scala.Serializable)dir -> {
            this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parquet.crypto.factory.class"), (Object)"org.apache.parquet.crypto.keytools.PropertiesDrivenCryptoFactory"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parquet.encryption.kms.client.class"), (Object)"org.apache.parquet.crypto.keytools.mocks.InMemoryKMS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parquet.encryption.key.list"), (Object)new StringBuilder(6).append("key1: ").append(this.key1()).toString())}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ParquetEncryptionSuite.class.getClassLoader());
                public final class $typecreator26$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                    }

                    public $typecreator26$1(ParquetEncryptionSuite $outer) {
                    }
                }
                Dataset inputDF = $this.spark().implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)22), (Object)BoxesRunTime.boxToInteger((int)333)), (List)Nil$.MODULE$), $this.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new $typecreator26$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}));
                String parquetDir = new File(dir, "parquet").getCanonicalPath();
                inputDF.write().option("parquet.encryption.uniform.key", "key1").parquet(parquetDir);
                $this.verifyParquetEncrypted(parquetDir);
                Dataset parquetDF = $this.spark().read().parquet(parquetDir);
                Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])parquetDF.inputFiles());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "nonEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left).nonEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetEncryptionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
                Dataset readDataset = parquetDF.select("a", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c"}));
                $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> readDataset, inputDF);
            });
            return BoxedUnit.UNIT;
        }), new Position("ParquetEncryptionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
    }
}

