/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import java.io.File;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.hive.HiveExternalCatalog;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.test.TestHiveContext;
import org.apache.spark.sql.hive.test.TestHiveSingleton;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.tags.ExtendedHiveTest;
import org.apache.spark.tags.SlowHiveTest;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@SlowHiveTest
@ExtendedHiveTest
@ScalaSignature(bytes="\u0006\u0001=4A!\u0003\u0006\u0001/!)!\u0005\u0001C\u0001G!9a\u0005\u0001a\u0001\n\u00139\u0003b\u0002\u0017\u0001\u0001\u0004%I!\f\u0005\u0007m\u0001\u0001\u000b\u0015\u0002\u0015\t\u000b]\u0002A\u0011\t\u001d\t\u000be\u0002A\u0011\t\u001d\t\u000bi\u0002A\u0011B\u001e\t\u000fa\u0003\u0011\u0013!C\u00053\n\t\u0002*\u001b<f?Jz\u0016g\u0018#E\u0019N+\u0018\u000e^3\u000b\u0005-a\u0011!C3yK\u000e,H/[8o\u0015\tia\"\u0001\u0003iSZ,'BA\b\u0011\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003#I\tQa\u001d9be.T!a\u0005\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0012aA8sO\u000e\u00011c\u0001\u0001\u00199A\u0011\u0011DG\u0007\u0002!%\u00111\u0004\u0005\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}a\u0011\u0001\u0002;fgRL!!\t\u0010\u0003#Q+7\u000f\u001e%jm\u0016\u001c\u0016N\\4mKR|g.\u0001\u0004=S:LGO\u0010\u000b\u0002IA\u0011Q\u0005A\u0007\u0002\u0015\u000591-\u0019;bY><W#\u0001\u0015\u0011\u0005%RS\"\u0001\u0007\n\u0005-b!a\u0005%jm\u0016,\u0005\u0010^3s]\u0006d7)\u0019;bY><\u0017aC2bi\u0006dwnZ0%KF$\"A\f\u001b\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\tUs\u0017\u000e\u001e\u0005\bk\r\t\t\u00111\u0001)\u0003\rAH%M\u0001\tG\u0006$\u0018\r\\8hA\u0005I\u0011M\u001a;fe\u0016\u000b7\r\u001b\u000b\u0002]\u0005A\u0011M\u001a;fe\u0006cG.\u0001\buKN$\u0018\t\u001c;feR\u000b'\r\\3\u0015\u000b9b\u0014jS*\t\u000bu:\u0001\u0019\u0001 \u0002\u0013Q\f'\r\\3OC6,\u0007CA G\u001d\t\u0001E\t\u0005\u0002Ba5\t!I\u0003\u0002D-\u00051AH]8pizJ!!\u0012\u0019\u0002\rA\u0013X\rZ3g\u0013\t9\u0005J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000bBBQAS\u0004A\u0002y\nqb\u0019:fCR,G+\u00192mKN#X\u000e\u001e\u0005\u0006\u0019\u001e\u0001\r!T\u0001\u000ekB$\u0017\r^3e'\u000eDW-\\1\u0011\u00059\u000bV\"A(\u000b\u0005As\u0011!\u0002;za\u0016\u001c\u0018B\u0001*P\u0005)\u0019FO];diRK\b/\u001a\u0005\b)\u001e\u0001\n\u00111\u0001V\u00039A\u0017N^3D_6\u0004\u0018\r^5cY\u0016\u0004\"a\f,\n\u0005]\u0003$a\u0002\"p_2,\u0017M\\\u0001\u0019i\u0016\u001cH/\u00117uKJ$\u0016M\u00197fI\u0011,g-Y;mi\u0012\"T#\u0001.+\u0005U[6&\u0001/\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017!C;oG\",7m[3e\u0015\t\t\u0007'\u0001\u0006b]:|G/\u0019;j_:L!a\u00190\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u000b\u0002\u0001KB\u0011a-[\u0007\u0002O*\u0011\u0001\u000eE\u0001\u0005i\u0006<7/\u0003\u0002kO\n\u0001R\t\u001f;f]\u0012,G\rS5wKR+7\u000f\u001e\u0015\u0003\u00011\u0004\"AZ7\n\u00059<'\u0001D*m_^D\u0015N^3UKN$\b")
public class Hive_2_1_DDLSuite
extends SparkFunSuite
implements TestHiveSingleton {
    private HiveExternalCatalog catalog;
    private final boolean enableAutoThreadAudit;
    private final SparkSession spark;
    private final TestHiveContext hiveContext;
    private final HiveClient hiveClient;

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public TestHiveContext hiveContext() {
        return this.hiveContext;
    }

    @Override
    public HiveClient hiveClient() {
        return this.hiveClient;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveContext_$eq(TestHiveContext x$1) {
        this.hiveContext = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveClient_$eq(HiveClient x$1) {
        this.hiveClient = x$1;
    }

    private HiveExternalCatalog catalog() {
        return this.catalog;
    }

    private void catalog_$eq(HiveExternalCatalog x$1) {
        this.catalog = x$1;
    }

    public void afterEach() {
        this.catalog().listTables("default").foreach((Function1 & Serializable & scala.Serializable)t -> {
            Hive_2_1_DDLSuite.$anonfun$afterEach$1(this, t);
            return BoxedUnit.UNIT;
        });
        this.spark().sessionState().catalog().reset();
    }

    @Override
    public void afterAll() {
        try {
            this.catalog_$eq(null);
        }
        finally {
            TestHiveSingleton.afterAll$(this);
        }
    }

    private void testAlterTable(String tableName, String createTableStmt, StructType updatedSchema, boolean hiveCompatible) {
        this.spark().sql(createTableStmt);
        CatalogTable oldTable = this.spark().sessionState().catalog().externalCatalog().getTable("default", tableName);
        this.catalog().createTable(oldTable, true);
        this.catalog().alterTableDataSchema("default", tableName, updatedSchema);
        CatalogTable updatedTable = this.catalog().getTable("default", tableName);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(updatedTable.schema().fieldNames());
        String[] $org_scalatest_assert_macro_right = updatedSchema.fieldNames();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("Hive_2_1_DDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
    }

    private boolean testAlterTable$default$4() {
        return true;
    }

    public static final /* synthetic */ void $anonfun$afterEach$1(Hive_2_1_DDLSuite $this, String t) {
        $this.catalog().dropTable("default", t, true, false);
    }

    public Hive_2_1_DDLSuite() {
        TestHiveSingleton.$init$(this);
        File warehouse = Utils$.MODULE$.createTempDir();
        File metastore = Utils$.MODULE$.createTempDir();
        metastore.delete();
        SparkConf sparkConf = new SparkConf().set("spark.master", "local").set(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key(), warehouse.toURI().toString()).set(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION().key(), "hive").set(HiveUtils$.MODULE$.HIVE_METASTORE_VERSION().key(), "2.1").set(HiveUtils$.MODULE$.HIVE_METASTORE_JARS().key(), "maven");
        Configuration hadoopConf = new Configuration();
        hadoopConf.set("hive.metastore.warehouse.dir", warehouse.toURI().toString());
        hadoopConf.set("javax.jdo.option.ConnectionURL", new StringBuilder(37).append("jdbc:derby:;databaseName=").append(metastore.getAbsolutePath()).append(";create=true").toString());
        hadoopConf.set("datanucleus.schema.autoCreateAll", "true");
        hadoopConf.set("hive.metastore.schema.verification", "false");
        this.catalog = new HiveExternalCatalog(sparkConf, hadoopConf);
        this.test("SPARK-21617: ALTER TABLE for non-compatible DataSource tables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testAlterTable("t1", "CREATE TABLE t1 (c1 int) USING json", new StructType((StructField[])((Object[])new StructField[]{new StructField("c1", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("c2", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})), false), new Position("Hive_2_1_DDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        this.test("SPARK-21617: ALTER TABLE for Hive-compatible DataSource tables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testAlterTable("t1", "CREATE TABLE t1 (c1 int) USING parquet", new StructType((StructField[])((Object[])new StructField[]{new StructField("c1", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("c2", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})), this.testAlterTable$default$4()), new Position("Hive_2_1_DDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        this.test("SPARK-21617: ALTER TABLE for Hive tables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testAlterTable("t1", "CREATE TABLE t1 (c1 int) STORED AS parquet", new StructType((StructField[])((Object[])new StructField[]{new StructField("c1", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("c2", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})), this.testAlterTable$default$4()), new Position("Hive_2_1_DDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        this.test("SPARK-21617: ALTER TABLE with incompatible schema on Hive-compatible table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AnalysisException x$1 = (AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testAlterTable("t1", "CREATE TABLE t1 (c1 string) USING parquet", new StructType((StructField[])((Object[])new StructField[]{new StructField("c2", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})), this.testAlterTable$default$4()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("Hive_2_1_DDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            Object x$2 = null;
            Map x$3 = Predef$.MODULE$.Map().empty();
            Option x$4 = this.checkError$default$3();
            boolean x$5 = this.checkError$default$5();
            QueryContext[] x$6 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$1, null, x$4, x$3, x$5, x$6);
        }, new Position("Hive_2_1_DDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
    }
}

