/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.orc;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Output;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Type;
import java.net.URI;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.SparkOrcNewRecordReader;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.orc.OrcConf;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.SchemaMergeUtils$;
import org.apache.spark.sql.execution.datasources.orc.OrcFilters$;
import org.apache.spark.sql.execution.datasources.orc.OrcOptions;
import org.apache.spark.sql.hive.HiveInspectors;
import org.apache.spark.sql.hive.orc.OrcFileFormat$;
import org.apache.spark.sql.hive.orc.OrcFileOperator$;
import org.apache.spark.sql.hive.orc.OrcOutputWriter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t=c\u0001B\u000b\u0017\u0001\rBQ\u0001\u0012\u0001\u0005\u0002\u0015CQ\u0001\u0013\u0001\u0005B%CQA\u0015\u0001\u0005B%CQa\u0015\u0001\u0005BQCQA\u001e\u0001\u0005B]Dq!a\u0004\u0001\t\u0003\n\t\u0002C\u0004\u0002(\u0001!\t%!\u000b\t\u000f\u0005M\u0004\u0001\"\u0011\u0002v!9\u0011\u0011\u0011\u0001\u0005\n\u0005\ru\u0001CAO-!\u0005a#a(\u0007\u000fU1\u0002\u0012\u0001\f\u0002\"\"1Ai\u0003C\u0001\u0003\u0007D!\"!2\f\u0005\u0004%\tAFAd\u0011!\t\u0019n\u0003Q\u0001\n\u0005%\u0007\"CAk\u0017\t\u0007I\u0011AAl\u0011!\t9o\u0003Q\u0001\n\u0005e\u0007bBAu\u0017\u0011\u0005\u00111\u001e\u0005\b\u00053YA\u0011\u0001B\u000e\u0011\u001d\u0011Yc\u0003C\u0001\u0005[A\u0011B!\u0012\f\u0003\u0003%IAa\u0012\u0003\u001b=\u00138MR5mK\u001a{'/\\1u\u0015\t9\u0002$A\u0002pe\u000eT!!\u0007\u000e\u0002\t!Lg/\u001a\u0006\u00037q\t1a]9m\u0015\tib$A\u0003ta\u0006\u00148N\u0003\u0002 A\u00051\u0011\r]1dQ\u0016T\u0011!I\u0001\u0004_J<7\u0001A\n\u0006\u0001\u0011R#\u0007\u000f\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005-\u0002T\"\u0001\u0017\u000b\u00055r\u0013a\u00033bi\u0006\u001cx.\u001e:dKNT!a\f\u000e\u0002\u0013\u0015DXmY;uS>t\u0017BA\u0019-\u0005)1\u0015\u000e\\3G_Jl\u0017\r\u001e\t\u0003gYj\u0011\u0001\u000e\u0006\u0003ki\tqa]8ve\u000e,7/\u0003\u00028i\t\u0011B)\u0019;b'>,(oY3SK\u001eL7\u000f^3s!\tI\u0014I\u0004\u0002;\u007f9\u00111HP\u0007\u0002y)\u0011QHI\u0001\u0007yI|w\u000e\u001e \n\u0003\u001dJ!\u0001\u0011\u0014\u0002\u000fA\f7m[1hK&\u0011!i\u0011\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u0001\u001a\na\u0001P5oSRtD#\u0001$\u0011\u0005\u001d\u0003Q\"\u0001\f\u0002\u0013MDwN\u001d;OC6,G#\u0001&\u0011\u0005-{eB\u0001'N!\tYd%\u0003\u0002OM\u00051\u0001K]3eK\u001aL!\u0001U)\u0003\rM#(/\u001b8h\u0015\tqe%\u0001\u0005u_N#(/\u001b8h\u0003-IgNZ3s'\u000eDW-\\1\u0015\tUsF-\u001b\t\u0004KYC\u0016BA,'\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011\fX\u0007\u00025*\u00111LG\u0001\u0006if\u0004Xm]\u0005\u0003;j\u0013!b\u0015;sk\u000e$H+\u001f9f\u0011\u0015yF\u00011\u0001a\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\t\t'-D\u0001\u001b\u0013\t\u0019'D\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0003f\t\u0001\u0007a-A\u0004paRLwN\\:\u0011\t-;'JS\u0005\u0003QF\u00131!T1q\u0011\u0015QG\u00011\u0001l\u0003\u00151\u0017\u000e\\3t!\rIDN\\\u0005\u0003[\u000e\u00131aU3r!\tyG/D\u0001q\u0015\t\t(/\u0001\u0002gg*\u00111OH\u0001\u0007Q\u0006$wn\u001c9\n\u0005U\u0004(A\u0003$jY\u0016\u001cF/\u0019;vg\u0006a\u0001O]3qCJ,wK]5uKR9\u0001p\u001f?\u0002\n\u0005-\u0001CA\u0016z\u0013\tQHFA\nPkR\u0004X\u000f^,sSR,'OR1di>\u0014\u0018\u0010C\u0003`\u000b\u0001\u0007\u0001\rC\u0003~\u000b\u0001\u0007a0A\u0002k_\n\u00042a`A\u0003\u001b\t\t\tAC\u0002\u0002\u0004I\f\u0011\"\\1qe\u0016$WoY3\n\t\u0005\u001d\u0011\u0011\u0001\u0002\u0004\u0015>\u0014\u0007\"B3\u0006\u0001\u00041\u0007BBA\u0007\u000b\u0001\u0007\u0001,\u0001\u0006eCR\f7k\u00195f[\u0006\f1\"[:Ta2LG/\u00192mKRA\u00111CA\r\u00037\ti\u0002E\u0002&\u0003+I1!a\u0006'\u0005\u001d\u0011un\u001c7fC:DQa\u0018\u0004A\u0002\u0001DQ!\u001a\u0004A\u0002\u0019Dq!a\b\u0007\u0001\u0004\t\t#\u0001\u0003qCRD\u0007cA8\u0002$%\u0019\u0011Q\u00059\u0003\tA\u000bG\u000f[\u0001\fEVLG\u000e\u001a*fC\u0012,'\u000f\u0006\t\u0002,\u0005%\u00131JA'\u0003#\n)&!\u0019\u0002dA9Q%!\f\u00022\u0005]\u0012bAA\u0018M\tIa)\u001e8di&|g.\r\t\u0004W\u0005M\u0012bAA\u001bY\ty\u0001+\u0019:uSRLwN\\3e\r&dW\rE\u0003:\u0003s\ti$C\u0002\u0002<\r\u0013\u0001\"\u0013;fe\u0006$xN\u001d\t\u0005\u0003\u007f\t)%\u0004\u0002\u0002B)\u0019\u00111\t\u000e\u0002\u0011\r\fG/\u00197zgRLA!a\u0012\u0002B\tY\u0011J\u001c;fe:\fGNU8x\u0011\u0015yv\u00011\u0001a\u0011\u0019\tia\u0002a\u00011\"1\u0011qJ\u0004A\u0002a\u000bq\u0002]1si&$\u0018n\u001c8TG\",W.\u0019\u0005\u0007\u0003':\u0001\u0019\u0001-\u0002\u001dI,\u0017/^5sK\u0012\u001c6\r[3nC\"9\u0011qK\u0004A\u0002\u0005e\u0013a\u00024jYR,'o\u001d\t\u0005s1\fY\u0006E\u00024\u0003;J1!a\u00185\u0005\u00191\u0015\u000e\u001c;fe\")Qm\u0002a\u0001M\"9\u0011QM\u0004A\u0002\u0005\u001d\u0014A\u00035bI>|\u0007oQ8oMB!\u0011\u0011NA8\u001b\t\tYGC\u0002\u0002nI\fAaY8oM&!\u0011\u0011OA6\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006y1/\u001e9q_J$H)\u0019;b)f\u0004X\r\u0006\u0003\u0002\u0014\u0005]\u0004bBA=\u0011\u0001\u0007\u00111P\u0001\tI\u0006$\u0018\rV=qKB\u0019\u0011,! \n\u0007\u0005}$L\u0001\u0005ECR\fG+\u001f9f\u0003\u0019!xn\u0013:z_R\u0019!*!\"\t\u000f\u0005\u001d\u0015\u00021\u0001\u0002\n\u0006!1/\u0019:h!\u0011\tY)!'\u000e\u0005\u00055%\u0002BAD\u0003\u001fSA!!%\u0002\u0014\u0006\u0011\u0011n\u001c\u0006\u0005\u0003+\u000b9*\u0001\u0002rY*\u0011\u0011D]\u0005\u0005\u00037\u000biI\u0001\bTK\u0006\u00148\r[!sOVlWM\u001c;\u0002\u001b=\u00138MR5mK\u001a{'/\\1u!\t95b\u0005\u0005\fI\u0005\r\u00161VA\\!\u0011\t)+a*\u000e\u0003aI1!!+\u0019\u00059A\u0015N^3J]N\u0004Xm\u0019;peN\u0004B!!,\u000246\u0011\u0011q\u0016\u0006\u0004\u0003cc\u0012\u0001C5oi\u0016\u0014h.\u00197\n\t\u0005U\u0016q\u0016\u0002\b\u0019><w-\u001b8h!\u0011\tI,!1\u000e\u0005\u0005m&\u0002BAI\u0003{S!!a0\u0002\t)\fg/Y\u0005\u0004\u0005\u0006mFCAAP\u00035\u0019\u0016IU$`!V\u001b\u0006\nR(X\u001dV\u0011\u0011\u0011\u001a\t\u0005\u0003\u0017\f\t.\u0004\u0002\u0002N*!\u0011qZA_\u0003\u0011a\u0017M\\4\n\u0007A\u000bi-\u0001\bT\u0003J;u\fU+T\u0011\u0012{uK\u0014\u0011\u0002E\u0015DH/\u001a8tS>t7OR8s\u0007>l\u0007O]3tg&|gnQ8eK\u000et\u0015-\\3t+\t\tI\u000e\u0005\u0005\u0002\\\u0006\u0015\u0018\u0011ZAe\u001b\t\tiN\u0003\u0003\u0002`\u0006\u0005\u0018!C5n[V$\u0018M\u00197f\u0015\r\t\u0019OJ\u0001\u000bG>dG.Z2uS>t\u0017b\u00015\u0002^\u0006\u0019S\r\u001f;f]NLwN\\:G_J\u001cu.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7MT1nKN\u0004\u0013\u0001E;ooJ\f\u0007o\u0014:d'R\u0014Xo\u0019;t)1\t9$!<\u0002p\u0006E\u00181\u001fB\u0005\u0011\u001d\ti'\u0005a\u0001\u0003OBa!!\u0004\u0012\u0001\u0004A\u0006BBA*#\u0001\u0007\u0001\fC\u0004\u0002vF\u0001\r!a>\u0002\u001b5\f\u0017PY3TiJ,8\r^(J!\u0011)c+!?\u0011\t\u0005m(QA\u0007\u0003\u0003{TA!a@\u0003\u0002\u0005yqN\u00196fGRLgn\u001d9fGR|'O\u0003\u0003\u0003\u0004\u0005]\u0015AB:fe\u0012,''\u0003\u0003\u0003\b\u0005u(!F*ueV\u001cGo\u00142kK\u000e$\u0018J\\:qK\u000e$xN\u001d\u0005\b\u0005\u0017\t\u0002\u0019\u0001B\u0007\u0003!IG/\u001a:bi>\u0014\b#B\u001d\u0002:\t=\u0001\u0003\u0002B\t\u0005+i!Aa\u0005\u000b\u0007\u0005E%/\u0003\u0003\u0003\u0018\tM!\u0001C,sSR\f'\r\\3\u0002%M,GOU3rk&\u0014X\rZ\"pYVlgn\u001d\u000b\t\u0005;\u0011\u0019C!\n\u0003(A\u0019QEa\b\n\u0007\t\u0005bE\u0001\u0003V]&$\bbBA7%\u0001\u0007\u0011q\r\u0005\u0007\u0003\u001b\u0011\u0002\u0019\u0001-\t\r\t%\"\u00031\u0001Y\u0003=\u0011X-];fgR,GmU2iK6\f\u0017aF1eIN\u0003\u0018M]6WKJ\u001c\u0018n\u001c8NKR\fG-\u0019;b)\u0011\u0011iBa\f\t\u000f\tE2\u00031\u0001\u00034\u0005a!/Z2pe\u0012<&/\u001b;feBA!Q\u0007B\u001e\u0005\u007f\u0011y!\u0004\u0002\u00038)\u0019!\u0011\b:\u0002\r5\f\u0007O]3e\u0013\u0011\u0011iDa\u000e\u0003\u0019I+7m\u001c:e/JLG/\u001a:\u0011\t\tE!\u0011I\u0005\u0005\u0005\u0007\u0012\u0019B\u0001\u0007Ok2dwK]5uC\ndW-\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003JA!\u00111\u001aB&\u0013\u0011\u0011i%!4\u0003\r=\u0013'.Z2u\u0001")
public class OrcFileFormat
implements FileFormat,
DataSourceRegister,
Serializable {
    public static void addSparkVersionMetadata(RecordWriter<NullWritable, Writable> recordWriter) {
        OrcFileFormat$.MODULE$.addSparkVersionMetadata(recordWriter);
    }

    public static void setRequiredColumns(Configuration configuration, StructType structType, StructType structType2) {
        OrcFileFormat$.MODULE$.setRequiredColumns(configuration, structType, structType2);
    }

    public static Iterator<InternalRow> unwrapOrcStructs(Configuration configuration, StructType structType, StructType structType2, Option<StructObjectInspector> option, Iterator<Writable> iterator) {
        return OrcFileFormat$.MODULE$.unwrapOrcStructs(configuration, structType, structType2, option, iterator);
    }

    public static Map<String, String> extensionsForCompressionCodecNames() {
        return OrcFileFormat$.MODULE$.extensionsForCompressionCodecNames();
    }

    public static HiveInspectors.typeInfoConversions typeInfoConversions(DataType dataType) {
        return OrcFileFormat$.MODULE$.typeInfoConversions(dataType);
    }

    public static DataType inspectorToDataType(ObjectInspector objectInspector) {
        return OrcFileFormat$.MODULE$.inspectorToDataType(objectInspector);
    }

    public static ObjectInspector toInspector(Expression expression) {
        return OrcFileFormat$.MODULE$.toInspector(expression);
    }

    public static ObjectInspector toInspector(DataType dataType) {
        return OrcFileFormat$.MODULE$.toInspector(dataType);
    }

    public static Object[] wrap(Seq<Object> seq, Function1<Object, Object>[] function1Array, Object[] objectArray, DataType[] dataTypeArray) {
        return OrcFileFormat$.MODULE$.wrap(seq, function1Array, objectArray, dataTypeArray);
    }

    public static Object[] wrap(InternalRow internalRow, Function1<Object, Object>[] function1Array, Object[] objectArray, DataType[] dataTypeArray) {
        return OrcFileFormat$.MODULE$.wrap(internalRow, function1Array, objectArray, dataTypeArray);
    }

    public static Object wrap(Object object, ObjectInspector objectInspector, DataType dataType) {
        return OrcFileFormat$.MODULE$.wrap(object, objectInspector, dataType);
    }

    public static Function3<Object, InternalRow, Object, BoxedUnit> unwrapperFor(StructField structField) {
        return OrcFileFormat$.MODULE$.unwrapperFor(structField);
    }

    public static Function1<Object, Object> unwrapperFor(ObjectInspector objectInspector) {
        return OrcFileFormat$.MODULE$.unwrapperFor(objectInspector);
    }

    public static DataType javaTypeToDataType(Type type) {
        return OrcFileFormat$.MODULE$.javaTypeToDataType(type);
    }

    public boolean supportBatch(SparkSession sparkSession, StructType dataSchema) {
        return FileFormat.supportBatch$((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema);
    }

    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return FileFormat.vectorTypes$((FileFormat)this, (StructType)requiredSchema, (StructType)partitionSchema, (SQLConf)sqlConf);
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReaderWithPartitionValues$((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema, (StructType)partitionSchema, (StructType)requiredSchema, filters, options, (Configuration)hadoopConf);
    }

    public boolean supportFieldName(String name) {
        return FileFormat.supportFieldName$((FileFormat)this, (String)name);
    }

    public String shortName() {
        return "orc";
    }

    public String toString() {
        return "ORC";
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        Option<StructType> option;
        OrcOptions orcOptions = new OrcOptions(options, sparkSession.sessionState().conf());
        if (orcOptions.mergeSchema()) {
            option = SchemaMergeUtils$.MODULE$.mergeSchemasInParallel(sparkSession, options, files, (Function3 & Serializable)(partFiles, conf, ignoreCorruptFiles) -> OrcFileOperator$.MODULE$.readOrcSchemasInParallel((Seq<FileStatus>)partFiles, conf, BoxesRunTime.unboxToBoolean((Object)ignoreCorruptFiles)));
        } else {
            boolean ignoreCorruptFiles2 = sparkSession.sessionState().conf().ignoreCorruptFiles();
            option = OrcFileOperator$.MODULE$.readSchema((Seq<String>)((Seq)files.map((Function1 & Serializable)x$1 -> x$1.getPath().toString())), (Option<Configuration>)new Some((Object)sparkSession.sessionState().newHadoopConfWithOptions(options)), ignoreCorruptFiles2);
        }
        return option;
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        OrcOptions orcOptions = new OrcOptions(options, sparkSession.sessionState().conf());
        Configuration configuration = job.getConfiguration();
        configuration.set(OrcConf.COMPRESS.getAttribute(), orcOptions.compressionCodec());
        Configuration configuration2 = configuration;
        if (configuration2 instanceof JobConf) {
            JobConf jobConf = (JobConf)configuration2;
            jobConf.setOutputFormat(OrcOutputFormat.class);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            configuration2.setClass("mapred.output.format.class", OrcOutputFormat.class, OutputFormat.class);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return new OutputWriterFactory(null){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new OrcOutputWriter(path, dataSchema, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                String name = context.getConfiguration().get(OrcConf.COMPRESS.getAttribute());
                String compressionExtension = (String)OrcFileFormat$.MODULE$.extensionsForCompressionCodecNames().getOrElse((Object)name, (Function0 & Serializable)() -> "");
                return new StringBuilder(4).append(compressionExtension).append(".orc").toString();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$getFileExtension$1()}, serializedLambda);
            }
        };
    }

    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return true;
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        if (sparkSession.sessionState().conf().orcFilterPushDown()) {
            OrcFilters$.MODULE$.createFilter(requiredSchema, filters).foreach((Function1 & Serializable)f -> {
                OrcFileFormat.$anonfun$buildReader$1(this, hadoopConf, f);
                return BoxedUnit.UNIT;
            });
        }
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        boolean ignoreCorruptFiles = sparkSession.sessionState().conf().ignoreCorruptFiles();
        return (Function1 & Serializable)file -> {
            Iterator<InternalRow> iterator;
            Configuration conf = ((SerializableConfiguration)broadcastedHadoopConf.value()).value();
            Path filePath = new Path(new URI(file.filePath()));
            boolean isEmptyFile = OrcFileOperator$.MODULE$.readSchema((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{filePath.toString()}))), (Option<Configuration>)new Some((Object)conf), ignoreCorruptFiles).isEmpty();
            if (isEmptyFile) {
                iterator = package$.MODULE$.Iterator().empty();
            } else {
                OrcFileFormat$.MODULE$.setRequiredColumns(conf, dataSchema, requiredSchema);
                Job job = Job.getInstance((Configuration)conf);
                FileInputFormat.setInputPaths((Job)job, (String)file.filePath());
                Reader orcReader = OrcFile.createReader((Path)filePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
                SparkOrcNewRecordReader orcRecordReader = new SparkOrcNewRecordReader(orcReader, conf, file.start(), file.length());
                RecordReaderIterator recordsIterator = new RecordReaderIterator((RecordReader)orcRecordReader);
                Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable)x$2 -> x$2.addTaskCompletionListener((Function1 & Serializable)x$3 -> {
                    recordsIterator.close();
                    return BoxedUnit.UNIT;
                }));
                iterator = OrcFileFormat$.MODULE$.unwrapOrcStructs(conf, dataSchema, requiredSchema, (Option<StructObjectInspector>)new Some((Object)((StructObjectInspector)orcRecordReader.getObjectInspector())), (Iterator<Writable>)recordsIterator);
            }
            return iterator;
        };
    }

    public boolean supportDataType(DataType dataType) {
        boolean bl;
        DataType dataType2 = dataType;
        if (dataType2 instanceof AnsiIntervalType) {
            bl = false;
        } else if (dataType2 instanceof AtomicType) {
            bl = true;
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            bl = structType.forall((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.supportDataType(f.dataType())));
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            bl = this.supportDataType(elementType);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            bl = this.supportDataType(keyType) && this.supportDataType(valueType);
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            bl = this.supportDataType(userDefinedType.sqlType());
        } else {
            bl = false;
        }
        return bl;
    }

    private String toKryo(SearchArgument sarg) {
        Kryo kryo = new Kryo();
        Output out = new Output(4096, 0xA00000);
        kryo.writeObject(out, (Object)sarg);
        out.close();
        return Base64.encodeBase64String((byte[])out.toBytes());
    }

    public static final /* synthetic */ void $anonfun$buildReader$1(OrcFileFormat $this, Configuration hadoopConf$1, SearchArgument f) {
        hadoopConf$1.set(OrcFileFormat$.MODULE$.SARG_PUSHDOWN(), $this.toKryo(f));
        hadoopConf$1.setBoolean(HiveConf.ConfVars.HIVEOPTINDEXFILTER.varname, true);
    }

    public OrcFileFormat() {
        FileFormat.$init$((FileFormat)this);
    }
}

