/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hive.common.util.HiveVersionInfo;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.sql.SQLContext$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.client.HiveClientImpl;
import org.apache.spark.sql.hive.client.HiveClientImpl$;
import org.apache.spark.sql.hive.client.IsolatedClientLoader;
import org.apache.spark.sql.hive.client.IsolatedClientLoader$;
import org.apache.spark.sql.hive.client.package;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.ChildFirstURLClassLoader;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

public final class HiveUtils$
implements Logging {
    public static final HiveUtils$ MODULE$ = new HiveUtils$();
    private static final String builtinHiveVersion;
    private static final ConfigEntry<String> BUILTIN_HIVE_VERSION;
    private static final ConfigEntry<String> HIVE_METASTORE_VERSION;
    private static final ConfigEntry<String> HIVE_METASTORE_JARS;
    private static final ConfigEntry<Seq<String>> HIVE_METASTORE_JARS_PATH;
    private static final ConfigEntry<Object> CONVERT_METASTORE_PARQUET;
    private static final ConfigEntry<Object> CONVERT_METASTORE_PARQUET_WITH_SCHEMA_MERGING;
    private static final ConfigEntry<Object> CONVERT_METASTORE_ORC;
    private static final ConfigEntry<Object> CONVERT_INSERTING_PARTITIONED_TABLE;
    private static final ConfigEntry<Object> CONVERT_METASTORE_CTAS;
    private static final ConfigEntry<Seq<String>> HIVE_METASTORE_SHARED_PREFIXES;
    private static final ConfigEntry<Seq<String>> HIVE_METASTORE_BARRIER_PREFIXES;
    private static final ConfigEntry<Object> HIVE_THRIFT_SERVER_ASYNC;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        builtinHiveVersion = HiveVersionInfo.getVersion();
        BUILTIN_HIVE_VERSION = SQLConf$.MODULE$.buildStaticConf("spark.sql.hive.version").doc("The compiled, a.k.a, builtin Hive version of the Spark distribution bundled with. Note that, this a read-only conf and only used to report the built-in hive version. If you want a different metastore client for Spark to call, please refer to spark.sql.hive.metastore.version.").version("1.1.1").stringConf().checkValue((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HiveUtils$.$anonfun$BUILTIN_HIVE_VERSION$1(x$1)), "The builtin Hive version is read-only, please use spark.sql.hive.metastore.version").createWithDefault((Object)MODULE$.builtinHiveVersion());
        HIVE_METASTORE_VERSION = SQLConf$.MODULE$.buildStaticConf("spark.sql.hive.metastore.version").doc("Version of the Hive metastore. Available options are <code>0.12.0</code> through <code>2.3.9</code> and <code>3.0.0</code> through <code>3.1.2</code>.").version("1.4.0").stringConf().checkValue((Function1 & Serializable)hiveVersionStr -> BoxesRunTime.boxToBoolean((boolean)HiveUtils$.MODULE$.isCompatibleHiveVersion(hiveVersionStr)), "Unsupported Hive Metastore version").createWithDefault((Object)MODULE$.builtinHiveVersion());
        HIVE_METASTORE_JARS = SQLConf$.MODULE$.buildStaticConf("spark.sql.hive.metastore.jars").doc(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(876).append("\n      | Location of the jars that should be used to instantiate the HiveMetastoreClient.\n      | This property can be one of four options:\n      | 1. \"builtin\"\n      |   Use Hive ").append(MODULE$.builtinHiveVersion()).append(", which is bundled with the Spark assembly when\n      |   <code>-Phive</code> is enabled. When this option is chosen,\n      |   <code>spark.sql.hive.metastore.version</code> must be either\n      |   <code>").append(MODULE$.builtinHiveVersion()).append("</code> or not defined.\n      | 2. \"maven\"\n      |   Use Hive jars of specified version downloaded from Maven repositories.\n      | 3. \"path\"\n      |   Use Hive jars configured by `spark.sql.hive.metastore.jars.path`\n      |   in comma separated format. Support both local or remote paths.The provided jars\n      |   should be the same version as `").append(MODULE$.HIVE_METASTORE_VERSION().key()).append("`.\n      | 4. A classpath in the standard format for both Hive and Hadoop. The provided jars\n      |   should be the same version as `").append(MODULE$.HIVE_METASTORE_VERSION().key()).append("`.\n      ").toString()))).version("1.4.0").stringConf().createWithDefault((Object)"builtin");
        HIVE_METASTORE_JARS_PATH = SQLConf$.MODULE$.buildStaticConf("spark.sql.hive.metastore.jars.path").doc(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(655).append("\n      | Comma-separated paths of the jars that used to instantiate the HiveMetastoreClient.\n      | This configuration is useful only when `").append(MODULE$.HIVE_METASTORE_JARS().key()).append("` is set as `path`.\n      | The paths can be any of the following format:\n      | 1. file://path/to/jar/foo.jar\n      | 2. hdfs://nameservice/path/to/jar/foo.jar\n      | 3. /path/to/jar/ (path without URI scheme follow conf `fs.defaultFS`'s URI schema)\n      | 4. [http/https/ftp]://path/to/jar/foo.jar\n      | Note that 1, 2, and 3 support wildcard. For example:\n      | 1. file://path/to/jar/*,file://path2/to/jar/*/*.jar\n      | 2. hdfs://nameservice/path/to/jar/*,hdfs://nameservice2/path/to/jar/*/*.jar\n      ").toString()))).version("3.1.0").stringConf().toSequence().createWithDefault((Object)package$.MODULE$.Nil());
        CONVERT_METASTORE_PARQUET = SQLConf$.MODULE$.buildConf("spark.sql.hive.convertMetastoreParquet").doc("When set to true, the built-in Parquet reader and writer are used to process parquet tables created by using the HiveQL syntax, instead of Hive serde.").version("1.1.1").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        CONVERT_METASTORE_PARQUET_WITH_SCHEMA_MERGING = SQLConf$.MODULE$.buildConf("spark.sql.hive.convertMetastoreParquet.mergeSchema").doc("When true, also tries to merge possibly different but compatible Parquet schemas in different Parquet data files. This configuration is only effective when \"spark.sql.hive.convertMetastoreParquet\" is true.").version("1.3.1").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        CONVERT_METASTORE_ORC = SQLConf$.MODULE$.buildConf("spark.sql.hive.convertMetastoreOrc").doc("When set to true, the built-in ORC reader and writer are used to process ORC tables created by using the HiveQL syntax, instead of Hive serde.").version("2.0.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        CONVERT_INSERTING_PARTITIONED_TABLE = SQLConf$.MODULE$.buildConf("spark.sql.hive.convertInsertingPartitionedTable").doc("When set to true, and `spark.sql.hive.convertMetastoreParquet` or `spark.sql.hive.convertMetastoreOrc` is true, the built-in ORC/Parquet writer is usedto process inserting into partitioned ORC/Parquet tables created by using the HiveSQL syntax.").version("3.0.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        CONVERT_METASTORE_CTAS = SQLConf$.MODULE$.buildConf("spark.sql.hive.convertMetastoreCtas").doc("When set to true,  Spark will try to use built-in data source writer instead of Hive serde in CTAS. This flag is effective only if `spark.sql.hive.convertMetastoreParquet` or `spark.sql.hive.convertMetastoreOrc` is enabled respectively for Parquet and ORC formats").version("3.0.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        HIVE_METASTORE_SHARED_PREFIXES = SQLConf$.MODULE$.buildStaticConf("spark.sql.hive.metastore.sharedPrefixes").doc("A comma separated list of class prefixes that should be loaded using the classloader that is shared between Spark SQL and a specific version of Hive. An example of classes that should be shared is JDBC drivers that are needed to talk to the metastore. Other classes that need to be shared are those that interact with classes that are already shared. For example, custom appenders that are used by log4j.").version("1.4.0").stringConf().toSequence().createWithDefault(MODULE$.jdbcPrefixes());
        HIVE_METASTORE_BARRIER_PREFIXES = SQLConf$.MODULE$.buildStaticConf("spark.sql.hive.metastore.barrierPrefixes").doc("A comma separated list of class prefixes that should explicitly be reloaded for each version of Hive that Spark SQL is communicating with. For example, Hive UDFs that are declared in a prefix that typically would be shared (i.e. <code>org.apache.spark.*</code>).").version("1.4.0").stringConf().toSequence().createWithDefault((Object)package$.MODULE$.Nil());
        HIVE_THRIFT_SERVER_ASYNC = SQLConf$.MODULE$.buildConf("spark.sql.hive.thriftServer.async").doc("When set to true, Hive Thrift server executes SQL queries in an asynchronous way.").version("1.5.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String builtinHiveVersion() {
        return builtinHiveVersion;
    }

    public ConfigEntry<String> BUILTIN_HIVE_VERSION() {
        return BUILTIN_HIVE_VERSION;
    }

    private boolean isCompatibleHiveVersion(String hiveVersionStr) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> IsolatedClientLoader$.MODULE$.hiveVersion(hiveVersionStr)).isSuccess();
    }

    public ConfigEntry<String> HIVE_METASTORE_VERSION() {
        return HIVE_METASTORE_VERSION;
    }

    public ConfigEntry<String> HIVE_METASTORE_JARS() {
        return HIVE_METASTORE_JARS;
    }

    public ConfigEntry<Seq<String>> HIVE_METASTORE_JARS_PATH() {
        return HIVE_METASTORE_JARS_PATH;
    }

    public ConfigEntry<Object> CONVERT_METASTORE_PARQUET() {
        return CONVERT_METASTORE_PARQUET;
    }

    public ConfigEntry<Object> CONVERT_METASTORE_PARQUET_WITH_SCHEMA_MERGING() {
        return CONVERT_METASTORE_PARQUET_WITH_SCHEMA_MERGING;
    }

    public ConfigEntry<Object> CONVERT_METASTORE_ORC() {
        return CONVERT_METASTORE_ORC;
    }

    public ConfigEntry<Object> CONVERT_INSERTING_PARTITIONED_TABLE() {
        return CONVERT_INSERTING_PARTITIONED_TABLE;
    }

    public ConfigEntry<Object> CONVERT_METASTORE_CTAS() {
        return CONVERT_METASTORE_CTAS;
    }

    public ConfigEntry<Seq<String>> HIVE_METASTORE_SHARED_PREFIXES() {
        return HIVE_METASTORE_SHARED_PREFIXES;
    }

    private Seq<String> jdbcPrefixes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"com.mysql.jdbc", "org.postgresql", "com.microsoft.sqlserver", "oracle.jdbc"}));
    }

    public ConfigEntry<Seq<String>> HIVE_METASTORE_BARRIER_PREFIXES() {
        return HIVE_METASTORE_BARRIER_PREFIXES;
    }

    public ConfigEntry<Object> HIVE_THRIFT_SERVER_ASYNC() {
        return HIVE_THRIFT_SERVER_ASYNC;
    }

    private String hiveMetastoreVersion(SQLConf conf) {
        return (String)conf.getConf(this.HIVE_METASTORE_VERSION());
    }

    private String hiveMetastoreJars(SQLConf conf) {
        return (String)conf.getConf(this.HIVE_METASTORE_JARS());
    }

    private Seq<String> hiveMetastoreJarsPath(SQLConf conf) {
        return (Seq)conf.getConf(this.HIVE_METASTORE_JARS_PATH());
    }

    private Seq<String> hiveMetastoreSharedPrefixes(SQLConf conf) {
        return (Seq)((IterableOps)conf.getConf(this.HIVE_METASTORE_SHARED_PREFIXES())).filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HiveUtils$.$anonfun$hiveMetastoreSharedPrefixes$1(x$2)));
    }

    private Seq<String> hiveMetastoreBarrierPrefixes(SQLConf conf) {
        return (Seq)((IterableOps)conf.getConf(this.HIVE_METASTORE_BARRIER_PREFIXES())).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HiveUtils$.$anonfun$hiveMetastoreBarrierPrefixes$1(x$3)));
    }

    public Map<String, String> formatTimeVarsForHiveClient(Configuration hadoopConf) {
        Seq commonTimeVars = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_CLIENT_CONNECT_RETRY_DELAY), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_CLIENT_SOCKET_TIMEOUT), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_CLIENT_SOCKET_LIFETIME), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HMSHANDLERINTERVAL), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_EVENT_DB_LISTENER_TTL), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_EVENT_CLEAN_FREQ), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_EVENT_EXPIRY_DURATION), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_AGGREGATE_STATS_CACHE_TTL), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_AGGREGATE_STATS_CACHE_MAX_WRITER_WAIT), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_AGGREGATE_STATS_CACHE_MAX_READER_WAIT), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVES_AUTO_PROGRESS_TIMEOUT), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_LOG_INCREMENTAL_PLAN_PROGRESS_INTERVAL), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_LOCK_SLEEP_BETWEEN_RETRIES), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_ZOOKEEPER_SESSION_TIMEOUT), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_ZOOKEEPER_CONNECTION_BASESLEEPTIME), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_TXN_TIMEOUT), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_COMPACTOR_WORKER_TIMEOUT), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_COMPACTOR_CHECK_INTERVAL), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RUN_INTERVAL), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_MAX_IDLE_TIME), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_WORKER_KEEPALIVE_TIME), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_COOKIE_MAX_AGE), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_THRIFT_LOGIN_BEBACKOFF_SLOT_LENGTH), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_THRIFT_LOGIN_TIMEOUT), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_THRIFT_WORKER_KEEPALIVE_TIME), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_SHUTDOWN_TIMEOUT), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_KEEPALIVE_TIME), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_LONG_POLLING_TIMEOUT), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_SESSION_CHECK_INTERVAL), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_IDLE_SESSION_TIMEOUT), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_SERVER2_IDLE_OPERATION_TIMEOUT), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.SERVER_READ_SOCKET_TIMEOUT), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.HIVE_LOCALIZE_RESOURCE_WAIT_INTERVAL), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.SPARK_CLIENT_FUTURE_TIMEOUT), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.SPARK_JOB_MONITOR_TIMEOUT), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.SPARK_RPC_CLIENT_CONNECT_TIMEOUT), (Object)TimeUnit.MILLISECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.SPARK_RPC_CLIENT_HANDSHAKE_TIMEOUT), (Object)TimeUnit.MILLISECONDS)})).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            HiveConf.ConfVars confVar = (HiveConf.ConfVars)tuple2._1();
            TimeUnit unit = (TimeUnit)((Object)((Object)tuple2._2()));
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)confVar.varname), (Object)Long.toString(HiveConf.getTimeVar((Configuration)hadoopConf, (HiveConf.ConfVars)confVar, (TimeUnit)unit)));
            return tuple22;
        });
        Seq hardcodingTimeVars = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"hive.stats.jdbc.timeout", (Object)"30s")), (Object)TimeUnit.SECONDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"hive.stats.retries.wait", (Object)"3000ms")), (Object)TimeUnit.MILLISECONDS)})).map((Function1 & Serializable)x0$2 -> {
            TimeUnit unit;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$2;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    unit = (TimeUnit)((Object)((Object)tuple22._2()));
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            String key = (String)tuple2._1();
            String defaultValue = (String)tuple2._2();
            String value = hadoopConf.get(key, defaultValue);
            Tuple2 tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)Long.toString(HiveConf.toTime((String)value, (TimeUnit)unit, (TimeUnit)unit)));
            return tuple23;
        });
        return ((IterableOnceOps)commonTimeVars.$plus$plus((IterableOnce)hardcodingTimeVars)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    /*
     * WARNING - void declaration
     */
    public boolean isCliSessionState() {
        void var3_3;
        boolean found = false;
        for (Class temp = (state = SessionState.get()) != null ? state.getClass() : null; temp != null && !found; temp = temp.getSuperclass()) {
            String string = temp.getName();
            String string2 = "org.apache.hadoop.hive.cli.CliSessionState";
            found = !(string != null ? !string.equals(string2) : string2 != null);
        }
        return (boolean)var3_3;
    }

    public HiveClientImpl newClientForExecution(SparkConf conf, Configuration hadoopConf) {
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("Initializing execution hive, version ").append(MODULE$.builtinHiveVersion()).toString());
        package.HiveVersion x$1 = IsolatedClientLoader$.MODULE$.hiveVersion(this.builtinHiveVersion());
        SparkConf x$2 = conf;
        Seq x$3 = (Seq)package$.MODULE$.Seq().empty();
        Configuration x$4 = hadoopConf;
        Map<String, String> x$5 = this.newTemporaryConfiguration(true);
        boolean x$6 = false;
        ClassLoader x$7 = Utils$.MODULE$.getContextOrSparkClassLoader();
        Seq<String> x$8 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$8();
        Seq<String> x$9 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$9();
        IsolatedClientLoader loader = new IsolatedClientLoader(x$1, x$2, x$4, (Seq<URL>)x$3, x$5, false, x$7, x$8, x$9);
        return (HiveClientImpl)loader.createClient();
    }

    public HiveClient newClientForMetadata(SparkConf conf, Configuration hadoopConf) {
        Map<String, String> configurations = this.formatTimeVarsForHiveClient(hadoopConf);
        return this.newClientForMetadata(conf, hadoopConf, configurations);
    }

    public HiveClient newClientForMetadata(SparkConf conf, Configuration hadoopConf, Map<String, String> configurations) {
        IsolatedClientLoader isolatedClientLoader;
        SQLConf sqlConf = new SQLConf();
        sqlConf.setConf(SQLContext$.MODULE$.getSQLProperties(conf));
        String hiveMetastoreVersion = this.hiveMetastoreVersion(sqlConf);
        String hiveMetastoreJars = this.hiveMetastoreJars(sqlConf);
        Seq<String> hiveMetastoreSharedPrefixes = this.hiveMetastoreSharedPrefixes(sqlConf);
        Seq<String> hiveMetastoreBarrierPrefixes = this.hiveMetastoreBarrierPrefixes(sqlConf);
        package.HiveVersion metaVersion = IsolatedClientLoader$.MODULE$.hiveVersion(hiveMetastoreVersion);
        String string = hiveMetastoreJars;
        String string2 = "builtin";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            URL[] uRLArray;
            String string3 = this.builtinHiveVersion();
            String string4 = hiveMetastoreVersion;
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                throw new IllegalArgumentException(new StringBuilder(85).append("Builtin jars can only be used when hive execution version == hive metastore version. ").append(new StringBuilder(28).append("Execution: ").append(this.builtinHiveVersion()).append(" != Metastore: ").append(hiveMetastoreVersion).append(". ").toString()).append(new StringBuilder(53).append("Specify a valid path to the correct hive jars using ").append(this.HIVE_METASTORE_JARS().key()).append(" ").toString()).append(new StringBuilder(15).append("or change ").append(this.HIVE_METASTORE_VERSION().key()).append(" to ").append(this.builtinHiveVersion()).append(".").toString()).toString());
            }
            ClassLoader classLoader = Utils$.MODULE$.getContextOrSparkClassLoader();
            if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9)) {
                uRLArray = (URL[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(URL.class));
            } else {
                URL[] loadedJars = this.allJars$1(classLoader);
                if (loadedJars.length == 0) {
                    throw new IllegalArgumentException(new StringBuilder(52).append("Unable to locate hive jars to connect to metastore. ").append(new StringBuilder(12).append("Please set ").append(this.HIVE_METASTORE_JARS().key()).append(".").toString()).toString());
                }
                uRLArray = loadedJars;
            }
            URL[] jars = uRLArray;
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(66).append("Initializing HiveMetastoreConnection version ").append(hiveMetastoreVersion).append(" using Spark classes.").toString());
            package.HiveVersion x$1 = metaVersion;
            SparkConf x$2 = conf;
            Configuration x$3 = hadoopConf;
            Seq x$4 = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])jars));
            Map<String, String> x$5 = configurations;
            boolean x$6 = !this.isCliSessionState();
            Seq<String> x$7 = hiveMetastoreBarrierPrefixes;
            Seq<String> x$8 = hiveMetastoreSharedPrefixes;
            ClassLoader x$9 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$7();
            isolatedClientLoader = new IsolatedClientLoader(x$1, x$2, x$3, (Seq<URL>)x$4, x$5, x$6, x$9, x$8, x$7);
        } else {
            String string5 = hiveMetastoreJars;
            String string6 = "maven";
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Initializing HiveMetastoreConnection version ").append(hiveMetastoreVersion).append(" using maven.").toString());
                String x$10 = hiveMetastoreVersion;
                String x$11 = VersionInfo.getVersion();
                SparkConf x$12 = conf;
                Configuration x$13 = hadoopConf;
                Map<String, String> x$14 = configurations;
                Seq<String> x$15 = hiveMetastoreBarrierPrefixes;
                Seq<String> x$16 = hiveMetastoreSharedPrefixes;
                Option<String> x$17 = IsolatedClientLoader$.MODULE$.forVersion$default$6();
                isolatedClientLoader = IsolatedClientLoader$.MODULE$.forVersion(x$10, x$11, x$12, x$13, x$14, x$17, x$16, x$15);
            } else {
                String string7 = hiveMetastoreJars;
                String string8 = "path";
                if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                    Seq jars = (Seq)this.hiveMetastoreJarsPath(sqlConf).flatMap((Function1 & Serializable)x0$1 -> {
                        Seq seq;
                        String string = x0$1;
                        switch (string == null ? 0 : string.hashCode()) {
                            default: 
                        }
                        if (string.contains("\\") && Utils$.MODULE$.isWindows()) {
                            seq = this.addLocalHiveJars$1(new File(string));
                        } else {
                            Seq x$18 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{string}));
                            Configuration x$19 = hadoopConf;
                            boolean x$20 = true;
                            boolean x$21 = false;
                            boolean x$22 = true;
                            Integer x$23 = DataSource$.MODULE$.checkAndGlobPathIfNecessary$default$5();
                            seq = (Seq)DataSource$.MODULE$.checkAndGlobPathIfNecessary(x$18, x$19, true, false, x$23, true).map((Function1 & Serializable)x$6 -> x$6.toUri().toURL());
                        }
                        Seq seq2 = seq;
                        return seq2;
                    });
                    this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(46).append("Initializing HiveMetastoreConnection version ").append(hiveMetastoreVersion).append(" ").toString()).append(new StringBuilder(12).append("using path: ").append(jars.mkString(";")).toString()).toString());
                    package.HiveVersion x$24 = metaVersion;
                    SparkConf x$25 = conf;
                    Configuration x$26 = hadoopConf;
                    Seq x$27 = jars;
                    Map<String, String> x$28 = configurations;
                    boolean x$29 = true;
                    Seq<String> x$30 = hiveMetastoreBarrierPrefixes;
                    Seq<String> x$31 = hiveMetastoreSharedPrefixes;
                    ClassLoader x$32 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$7();
                    isolatedClientLoader = new IsolatedClientLoader(x$24, x$25, x$26, (Seq<URL>)x$27, x$28, true, x$32, x$31, x$30);
                } else {
                    URL[] jars = (URL[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])hiveMetastoreJars.split(File.pathSeparator)), (Function1 & Serializable)path -> this.addLocalHiveJars$1(new File((String)path)), ClassTag$.MODULE$.apply(URL.class));
                    this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(46).append("Initializing HiveMetastoreConnection version ").append(hiveMetastoreVersion).append(" ").toString()).append(new StringBuilder(6).append("using ").append(Predef$.MODULE$.wrapRefArray((Object[])jars).mkString(":")).toString()).toString());
                    package.HiveVersion x$33 = metaVersion;
                    SparkConf x$34 = conf;
                    Configuration x$35 = hadoopConf;
                    Seq x$36 = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])jars));
                    Map<String, String> x$37 = configurations;
                    boolean x$38 = true;
                    Seq<String> x$39 = hiveMetastoreBarrierPrefixes;
                    Seq<String> x$40 = hiveMetastoreSharedPrefixes;
                    ClassLoader x$41 = IsolatedClientLoader$.MODULE$.$lessinit$greater$default$7();
                    isolatedClientLoader = new IsolatedClientLoader(x$33, x$34, x$35, (Seq<URL>)x$36, x$37, true, x$41, x$40, x$39);
                }
            }
        }
        IsolatedClientLoader isolatedLoader = isolatedClientLoader;
        return isolatedLoader.createClient();
    }

    public Map<String, String> newTemporaryConfiguration(boolean useInMemoryDerby) {
        String withInMemoryMode = useInMemoryDerby ? "memory:" : "";
        File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        File localMetastore = new File(tempDir, "metastore");
        HashMap propMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])HiveConf.ConfVars.values()), (Function1 & Serializable)confvar -> confvar.varname.contains("datanucleus") || confvar.varname.contains("jdo") || confvar.varname.contains("hive.metastore.rawstore.impl") ? propMap.put((Object)confvar.varname, (Object)confvar.getDefaultExpr()) : BoxedUnit.UNIT);
        propMap.put((Object)StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key(), (Object)localMetastore.toURI().toString());
        propMap.put((Object)HiveConf.ConfVars.METASTORECONNECTURLKEY.varname, (Object)new StringBuilder(37).append("jdbc:derby:").append(withInMemoryMode).append(";databaseName=").append(localMetastore.getAbsolutePath()).append(";create=true").toString());
        propMap.put((Object)"datanucleus.rdbms.datastoreAdapterClassName", (Object)"org.datanucleus.store.rdbms.adapter.DerbyAdapter");
        propMap.put((Object)"hive.metastore.schema.verification", (Object)"false");
        propMap.put((Object)"datanucleus.schema.autoCreateAll", (Object)"true");
        propMap.put((Object)HiveConf.ConfVars.METASTOREURIS.varname, (Object)"");
        propMap.put((Object)HiveConf.ConfVars.METASTORE_PRE_EVENT_LISTENERS.varname, (Object)"");
        propMap.put((Object)HiveConf.ConfVars.METASTORE_EVENT_LISTENERS.varname, (Object)"");
        propMap.put((Object)HiveConf.ConfVars.METASTORE_END_FUNCTION_LISTENERS.varname, (Object)"");
        SparkHadoopUtil$.MODULE$.get().appendSparkHadoopConfigs(scala.sys.package$.MODULE$.props().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), propMap);
        SparkHadoopUtil$.MODULE$.get().appendSparkHiveConfigs(scala.sys.package$.MODULE$.props().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), propMap);
        return propMap.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public CatalogTable inferSchema(CatalogTable table) {
        CatalogTable catalogTable;
        if (DDLUtils$.MODULE$.isDatasourceTable(table) || table.dataSchema().nonEmpty()) {
            catalogTable = table;
        } else {
            Table hiveTable = HiveClientImpl$.MODULE$.toHiveTable(table, HiveClientImpl$.MODULE$.toHiveTable$default$2());
            Buffer partCols = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(hiveTable.getPartCols()).asScala()).map((Function1 & Serializable)hc -> HiveClientImpl$.MODULE$.fromHiveColumn((FieldSchema)hc));
            Buffer dataCols = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(hiveTable.getCols()).asScala()).map((Function1 & Serializable)hc -> HiveClientImpl$.MODULE$.fromHiveColumn((FieldSchema)hc));
            StructType x$1 = StructType$.MODULE$.apply(((IterableOnceOps)dataCols.$plus$plus((IterableOnce)partCols)).toSeq());
            TableIdentifier x$2 = table.copy$default$1();
            CatalogTableType x$3 = table.copy$default$2();
            CatalogStorageFormat x$4 = table.copy$default$3();
            Option x$5 = table.copy$default$5();
            Seq x$6 = table.copy$default$6();
            Option x$7 = table.copy$default$7();
            String x$8 = table.copy$default$8();
            long x$9 = table.copy$default$9();
            long x$10 = table.copy$default$10();
            String x$11 = table.copy$default$11();
            Map x$12 = table.copy$default$12();
            Option x$13 = table.copy$default$13();
            Option x$14 = table.copy$default$14();
            Option x$15 = table.copy$default$15();
            Seq x$16 = table.copy$default$16();
            boolean x$17 = table.copy$default$17();
            boolean x$18 = table.copy$default$18();
            Map x$19 = table.copy$default$19();
            Option x$20 = table.copy$default$20();
            catalogTable = table.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        }
        return catalogTable;
    }

    public static final /* synthetic */ boolean $anonfun$BUILTIN_HIVE_VERSION$1(String x$1) {
        String string = x$1;
        String string2 = MODULE$.builtinHiveVersion();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$hiveMetastoreSharedPrefixes$1(String x$2) {
        String string = x$2;
        String string2 = "";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$hiveMetastoreBarrierPrefixes$1(String x$3) {
        String string = x$3;
        String string2 = "";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$newClientForMetadata$2(File x$4) {
        return x$4.getName().toLowerCase(Locale.ROOT).endsWith(".jar");
    }

    private final Seq addLocalHiveJars$1(File file) {
        List list;
        String string = file.getName();
        String string2 = "*";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            File[] files = file.getParentFile().listFiles();
            if (files == null) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("Hive jar path '").append(file.getPath()).append("' does not exist.").toString());
                list = package$.MODULE$.Nil();
            } else {
                list = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)HiveUtils$.$anonfun$newClientForMetadata$2(x$4)))), (Function1 & Serializable)x$5 -> x$5.toURI().toURL(), ClassTag$.MODULE$.apply(URL.class))));
            }
        } else {
            URL uRL = file.toURI().toURL();
            list = package$.MODULE$.Nil().$colon$colon((Object)uRL);
        }
        return list;
    }

    private final URL[] allJars$1(ClassLoader classLoader) {
        URL[] uRLArray;
        while (true) {
            ClassLoader classLoader2;
            if ((classLoader2 = classLoader) == null) {
                uRLArray = (URL[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(URL.class));
                break;
            }
            if (classLoader2 instanceof ChildFirstURLClassLoader) {
                ChildFirstURLClassLoader childFirstURLClassLoader = (ChildFirstURLClassLoader)classLoader2;
                uRLArray = (URL[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])childFirstURLClassLoader.getURLs()), (Object)this.allJars$1(Utils$.MODULE$.getSparkClassLoader()), ClassTag$.MODULE$.apply(URL.class));
                break;
            }
            if (classLoader2 instanceof URLClassLoader) {
                URLClassLoader uRLClassLoader = (URLClassLoader)classLoader2;
                uRLArray = (URL[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])uRLClassLoader.getURLs()), (Object)this.allJars$1(uRLClassLoader.getParent()), ClassTag$.MODULE$.apply(URL.class));
                break;
            }
            classLoader = classLoader2.getParent();
        }
        return uRLArray;
    }

    private HiveUtils$() {
    }
}

