/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.orc;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.hive.orc.OrcFileFormat$;
import org.apache.spark.sql.hive.orc.OrcSerializer;
import org.apache.spark.sql.types.StructType;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005i4Q!\u0004\b\u0001\u001diA\u0001b\t\u0001\u0003\u0006\u0004%\t!\n\u0005\tg\u0001\u0011\t\u0011)A\u0005M!AA\u0007\u0001B\u0001B\u0003%Q\u0007\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u0019Y\u0005\u0001)A\u0005\u0019\"9q\n\u0001a\u0001\n\u0013\u0001\u0006bB+\u0001\u0001\u0004%IA\u0016\u0005\u00079\u0002\u0001\u000b\u0015B)\t\u0011u\u0003\u0001R1A\u0005\nyCQA\u001c\u0001\u0005B=DQ\u0001\u001f\u0001\u0005Be\u0014qb\u0014:d\u001fV$\b/\u001e;Xe&$XM\u001d\u0006\u0003\u001fA\t1a\u001c:d\u0015\t\t\"#\u0001\u0003iSZ,'BA\n\u0015\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003+Y\tQa\u001d9be.T!a\u0006\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0012aA8sON\u0011\u0001a\u0007\t\u00039\u0005j\u0011!\b\u0006\u0003=}\t1\u0002Z1uCN|WO]2fg*\u0011\u0001EE\u0001\nKb,7-\u001e;j_:L!AI\u000f\u0003\u0019=+H\u000f];u/JLG/\u001a:\u0002\tA\fG\u000f[\u0002\u0001+\u00051\u0003CA\u00141\u001d\tAc\u0006\u0005\u0002*Y5\t!F\u0003\u0002,I\u00051AH]8pizR\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\na\u0001\u0015:fI\u00164\u0017BA\u00193\u0005\u0019\u0019FO]5oO*\u0011q\u0006L\u0001\u0006a\u0006$\b\u000eI\u0001\u000bI\u0006$\u0018mU2iK6\f\u0007C\u0001\u001c:\u001b\u00059$B\u0001\u001d\u0013\u0003\u0015!\u0018\u0010]3t\u0013\tQtG\u0001\u0006TiJ,8\r\u001e+za\u0016\fqaY8oi\u0016DH\u000f\u0005\u0002>\u00056\taH\u0003\u0002@\u0001\u0006IQ.\u00199sK\u0012,8-\u001a\u0006\u0003\u0003Z\ta\u0001[1e_>\u0004\u0018BA\"?\u0005I!\u0016m]6BiR,W\u000e\u001d;D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\u00111\u0005*\u0013&\u0011\u0005\u001d\u0003Q\"\u0001\b\t\u000b\r*\u0001\u0019\u0001\u0014\t\u000bQ*\u0001\u0019A\u001b\t\u000bm*\u0001\u0019\u0001\u001f\u0002\u0015M,'/[1mSj,'\u000f\u0005\u0002H\u001b&\u0011aJ\u0004\u0002\u000e\u001fJ\u001c7+\u001a:jC2L'0\u001a:\u00021I,7m\u001c:e/JLG/\u001a:J]N$\u0018M\u001c;jCR,G-F\u0001R!\t\u00116+D\u0001-\u0013\t!FFA\u0004C_>dW-\u00198\u00029I,7m\u001c:e/JLG/\u001a:J]N$\u0018M\u001c;jCR,Gm\u0018\u0013fcR\u0011qK\u0017\t\u0003%bK!!\u0017\u0017\u0003\tUs\u0017\u000e\u001e\u0005\b7\"\t\t\u00111\u0001R\u0003\rAH%M\u0001\u001ae\u0016\u001cwN\u001d3Xe&$XM]%ogR\fg\u000e^5bi\u0016$\u0007%\u0001\u0007sK\u000e|'\u000fZ,sSR,'/F\u0001`!\u0011\u00017-Z6\u000e\u0003\u0005T!A\u0019!\u0002\r5\f\u0007O]3e\u0013\t!\u0017M\u0001\u0007SK\u000e|'\u000fZ,sSR,'\u000f\u0005\u0002gS6\tqM\u0003\u0002i\u0001\u0006\u0011\u0011n\\\u0005\u0003U\u001e\u0014ABT;mY^\u0013\u0018\u000e^1cY\u0016\u0004\"A\u001a7\n\u00055<'\u0001C,sSR\f'\r\\3\u0002\u000b]\u0014\u0018\u000e^3\u0015\u0005]\u0003\b\"B9\f\u0001\u0004\u0011\u0018a\u0001:poB\u00111O^\u0007\u0002i*\u0011QOE\u0001\tG\u0006$\u0018\r\\=ti&\u0011q\u000f\u001e\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0003dY>\u001cX\rF\u0001X\u0001")
public class OrcOutputWriter
extends OutputWriter {
    private RecordWriter<NullWritable, Writable> recordWriter;
    private final String path;
    private final TaskAttemptContext context;
    private final OrcSerializer serializer;
    private boolean recordWriterInstantiated;
    private volatile boolean bitmap$0;

    public String path() {
        return this.path;
    }

    private boolean recordWriterInstantiated() {
        return this.recordWriterInstantiated;
    }

    private void recordWriterInstantiated_$eq(boolean x$1) {
        this.recordWriterInstantiated = x$1;
    }

    private RecordWriter<NullWritable, Writable> recordWriter$lzycompute() {
        OrcOutputWriter orcOutputWriter = this;
        synchronized (orcOutputWriter) {
            if (!this.bitmap$0) {
                this.recordWriterInstantiated_$eq(true);
                this.recordWriter = new OrcOutputFormat().getRecordWriter(new Path(this.path()).getFileSystem(this.context.getConfiguration()), (JobConf)this.context.getConfiguration(), this.path(), (Progressable)Reporter.NULL);
                this.bitmap$0 = true;
            }
        }
        return this.recordWriter;
    }

    private RecordWriter<NullWritable, Writable> recordWriter() {
        return !this.bitmap$0 ? this.recordWriter$lzycompute() : this.recordWriter;
    }

    public void write(InternalRow row) {
        this.recordWriter().write((Object)NullWritable.get(), (Object)this.serializer.serialize(row));
    }

    public void close() {
        block0: {
            if (!this.recordWriterInstantiated()) break block0;
            OrcFileFormat$.MODULE$.addSparkVersionMetadata(this.recordWriter());
            this.recordWriter().close(Reporter.NULL);
        }
    }

    public OrcOutputWriter(String path, StructType dataSchema, TaskAttemptContext context) {
        this.path = path;
        this.context = context;
        this.serializer = new OrcSerializer(dataSchema, context.getConfiguration());
        this.recordWriterInstantiated = false;
    }
}

