/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.File;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.hive.HiveExternalCatalog;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.internal.SharedState;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00012Aa\u0001\u0003\u0001\u001f!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C!3\t!\u0002*\u001b<f'\"\f'/\u001a3Ti\u0006$XmU;ji\u0016T!!\u0002\u0004\u0002\t!Lg/\u001a\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0001\"!\u0005\n\u000e\u0003!I!a\u0005\u0005\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\ta\u0003\u0005\u0002\u0018\u00015\tA!\u0001\u0006cK\u001a|'/Z#bG\"$\u0012A\u0007\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0005+:LG\u000f")
public class HiveSharedStateSuite
extends SparkFunSuite {
    public void beforeEach() {
        SparkSession$.MODULE$.clearActiveSession();
        SparkSession$.MODULE$.clearDefaultSession();
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    public HiveSharedStateSuite() {
        this.test("initial configs should be passed to SharedState but not SparkContext", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster("local").setAppName("SharedState Test");
            SparkContext sc = SparkContext$.MODULE$.getOrCreate(conf);
            String warehousePath = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toString();
            String invalidPath = "invalid/path";
            File metastorePath = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            String tmpDb = "tmp_db";
            Map initialConfigs = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.foo"), (Object)"bar"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key()), (Object)warehousePath), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTOREWAREHOUSE.varname), (Object)warehousePath), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION().key()), (Object)"hive"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORECONNECTURLKEY.varname), (Object)new StringBuilder(50).append("jdbc:derby:;databaseName=").append(metastorePath).append("/metastore_db;create=true").toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE().key()), (Object)tmpDb)}));
            SparkSession.Builder builder = SparkSession$.MODULE$.builder();
            initialConfigs.foreach((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                SparkSession.Builder builder = builder.config(k, v);
                return builder;
            });
            SparkSession ss = builder.getOrCreate();
            SharedState state = ss.sharedState();
            String qualifiedWHPath = FileUtils.makeQualified((Path)new Path(warehousePath), (Configuration)sc.hadoopConfiguration()).toString();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(sc.conf().get(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key()));
            String $org_scalatest_assert_macro_right = qualifiedWHPath;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"initial warehouse conf in session options can affect application wide spark conf", Prettifier$.MODULE$.default(), new Position("HiveSharedStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(sc.hadoopConfiguration().get(HiveConf.ConfVars.METASTOREWAREHOUSE.varname));
            String $org_scalatest_assert_macro_right2 = qualifiedWHPath;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"initial warehouse conf in session options can affect application wide hadoop conf", Prettifier$.MODULE$.default(), new Position("HiveSharedStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            SparkConf $org_scalatest_assert_macro_left3 = state.sparkContext().conf();
            String $org_scalatest_assert_macro_right3 = "spark.foo";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"static spark conf should not be affected by session", Prettifier$.MODULE$.default(), new Position("HiveSharedStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            ExternalCatalog $org_scalatest_assert_macro_left4 = state.externalCatalog().unwrapped();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left4, "isInstanceOf", "org.apache.spark.sql.hive.HiveExternalCatalog", $org_scalatest_assert_macro_left4 instanceof HiveExternalCatalog, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"Initial SparkSession options can determine the catalog", Prettifier$.MODULE$.default(), new Position("HiveSharedStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
            HiveClient client = ((HiveExternalCatalog)state.externalCatalog().unwrapped()).client();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(client.getConf("spark.foo", ""));
            String $org_scalatest_assert_macro_right4 = "bar";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"session level conf should be passed to catalog", Prettifier$.MODULE$.default(), new Position("HiveSharedStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(client.getConf(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, ""));
            String $org_scalatest_assert_macro_right5 = qualifiedWHPath;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"session level conf should be passed to catalog", Prettifier$.MODULE$.default(), new Position("HiveSharedStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(state.globalTempViewManager().database());
            String $org_scalatest_assert_macro_right6 = tmpDb;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSharedStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
            SparkSession ss2 = builder.config("spark.foo", "bar2222").config(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key(), invalidPath).getOrCreate();
            String $org_scalatest_assert_macro_left8 = ss2.sparkContext().conf().get(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key());
            String $org_scalatest_assert_macro_right7 = invalidPath;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left8.contains($org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"warehouse conf in session options can't affect application wide spark conf", Prettifier$.MODULE$.default(), new Position("HiveSharedStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(ss2.sparkContext().hadoopConfiguration().get(HiveConf.ConfVars.METASTOREWAREHOUSE.varname));
            String $org_scalatest_assert_macro_right8 = invalidPath;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "!==", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left9.$bang$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"warehouse conf in session options can't affect application wide hadoop conf", Prettifier$.MODULE$.default(), new Position("HiveSharedStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(ss.conf().get("spark.foo"));
            String $org_scalatest_assert_macro_right9 = "bar2222";
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"session level conf should be passed to catalog", Prettifier$.MODULE$.default(), new Position("HiveSharedStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            String $org_scalatest_assert_macro_left11 = (String)ss.conf().get(StaticSQLConf$.MODULE$.WAREHOUSE_PATH());
            String $org_scalatest_assert_macro_right10 = invalidPath;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "contains", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left11.contains($org_scalatest_assert_macro_right10), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"session level conf should be passed to catalog", Prettifier$.MODULE$.default(), new Position("HiveSharedStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        }, new Position("HiveSharedStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.test("SPARK-34568: When SparkContext's conf not enable hive, we should respect `enableHiveSupport()` when build SparkSession too", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Assertion assertion;
            SparkConf conf = new SparkConf().setMaster("local").setAppName("SPARK-34568").set(UI$.MODULE$.UI_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            SparkContext sc = SparkContext$.MODULE$.getOrCreate(conf);
            String catalog = (String)sc.conf().get(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION());
            try {
                sc.conf().set(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION(), (Object)"in-memory");
                SparkSession sparkSession = SparkSession$.MODULE$.builder().enableHiveSupport().sparkContext(sc).getOrCreate();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(sparkSession.sparkContext().conf().get(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION()));
                String $org_scalatest_assert_macro_right = "in-memory";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSharedStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(sparkSession.sharedState().conf().get(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION()));
                String $org_scalatest_assert_macro_right2 = "hive";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSharedStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
                String $org_scalatest_assert_macro_left3 = sparkSession.sessionState().catalog().getClass().getCanonicalName();
                String $org_scalatest_assert_macro_right3 = "HiveSessionCatalog";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSharedStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            }
            finally {
                sc.conf().set(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION(), (Object)catalog);
            }
            return assertion;
        }, new Position("HiveSharedStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
    }
}

