/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.TestUtils$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.hive.SparkSubmitClassLoaderTest$;
import org.apache.spark.sql.hive.test.TestHiveContext;
import org.apache.spark.sql.hive.test.TestHiveContext$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class SparkSubmitClassLoaderTest$
implements Logging {
    public static final SparkSubmitClassLoaderTest$ MODULE$ = new SparkSubmitClassLoaderTest$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void main(String[] args) {
        TestUtils$.MODULE$.configTestLog4j2("INFO");
        SparkConf conf = new SparkConf();
        File hiveWarehouseLocation = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        conf.set(UI$.MODULE$.UI_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        conf.set(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key(), hiveWarehouseLocation.toString());
        SparkContext sc = new SparkContext(conf);
        TestHiveContext hiveContext = new TestHiveContext(sc, TestHiveContext$.MODULE$.$lessinit$greater$default$2());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_sql_hive_SparkSubmitClassLoaderTest$$typecreator1$4
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_hive_SparkSubmitClassLoaderTest$$typecreator1$4() {
            }
        }
        Dataset df = hiveContext.createDataFrame((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 100).map((Function1 & Serializable)i -> SparkSubmitClassLoaderTest$.$anonfun$main$18(BoxesRunTime.unboxToInt((Object)i))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_SparkSubmitClassLoaderTest$$typecreator1$4())).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"}));
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Testing load classes at the driver side.");
        try {
            Utils$.MODULE$.classForName(args[0], Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
            Utils$.MODULE$.classForName(args[1], Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
        }
        catch (Throwable t) {
            throw new Exception("Could not load user class from jar:\n", t);
        }
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Testing load classes at the executor side.");
        String[] result = (String[])df.rdd().mapPartitions((Function1 & Serializable)x -> {
            Class clazz;
            String exception = null;
            try {
                Utils$.MODULE$.classForName(args[0], Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
                clazz = Utils$.MODULE$.classForName(args[1], Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
            }
            catch (Throwable t) {
                exception = new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)t), "\n")).append(Utils$.MODULE$.exceptionString(t)).toString();
                exception = exception.replaceAll("\n", "\n\t");
                clazz = BoxedUnit.UNIT;
            }
            return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)exception)).toSeq().iterator();
        }, df.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(String.class)).collect();
        if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])result))) {
            throw new Exception(new StringBuilder(36).append("Could not load user class from jar:\n").append(result[0]).toString());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Registering temporary Hive UDF provided in a jar.");
        hiveContext.sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |CREATE TEMPORARY FUNCTION example_max\n        |AS 'org.apache.hadoop.hive.contrib.udaf.example.UDAFExampleMax'\n      ")));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_sql_hive_SparkSubmitClassLoaderTest$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_hive_SparkSubmitClassLoaderTest$$typecreator2$1() {
            }
        }
        Dataset source = hiveContext.createDataFrame((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)i -> SparkSubmitClassLoaderTest$.$anonfun$main$23(BoxesRunTime.unboxToInt((Object)i))), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_hive_SparkSubmitClassLoaderTest$$typecreator2$1())).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key", "val"}));
        source.createOrReplaceTempView("sourceTable");
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Creating a Hive table with a SerDe provided in a jar.");
        hiveContext.sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |CREATE TABLE t1(key int, val string)\n        |ROW FORMAT SERDE 'org.apache.hive.hcatalog.data.JsonSerDe'\n      ")));
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Writing data into the table.");
        hiveContext.sql("INSERT INTO TABLE t1 SELECT example_max(key) as key, val FROM sourceTable GROUP BY val");
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Running a simple query on the table.");
        long count = hiveContext.table("t1").orderBy("key", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"val"})).count();
        if (count != 10L) {
            throw new Exception(new StringBuilder(45).append("table t1 should have 10 rows instead of ").append(count).append(" rows").toString());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Test finishes.");
        sc.stop();
    }

    public static final /* synthetic */ Tuple2 $anonfun$main$18(int i) {
        return new Tuple2.mcII.sp(i, i);
    }

    public static final /* synthetic */ Tuple2 $anonfun$main$23(int i) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)new StringBuilder(3).append("str").append(i).toString());
    }

    private SparkSubmitClassLoaderTest$() {
    }
}

