/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.client;

import java.io.File;
import java.io.Serializable;
import java.sql.Date;
import java.time.ZoneId;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.Concat;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.InSet;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.Substring;
import org.apache.spark.sql.catalyst.expressions.Year;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.client.HiveVersionSuite;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Eg\u0001B\u0012%\u0001EB\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\u0006%\u0002!\ta\u0015\u0005\b-\u0002\u0011\r\u0011\"\u0003X\u0011\u0019y\u0006\u0001)A\u00051\"9\u0001\r\u0001b\u0001\n\u0013\t\u0007B\u00022\u0001A\u0003%Q\tC\u0004d\u0001\t\u0007I\u0011B1\t\r\u0011\u0004\u0001\u0015!\u0003F\u0011\u001d)\u0007A1A\u0005\n\u0019Daa\u001b\u0001!\u0002\u00139\u0007b\u00027\u0001\u0005\u0004%I!\u001c\u0005\u0007u\u0002\u0001\u000b\u0011\u00028\t\u000fm\u0004!\u0019!C\u0005[\"1A\u0010\u0001Q\u0001\n9Dq! \u0001C\u0002\u0013%a\u0010C\u0004\u0002\u0006\u0001\u0001\u000b\u0011B@\t\u0011\u0005\u001d\u0001A1A\u0005\nyDq!!\u0003\u0001A\u0003%q\u0010\u0003\u0005\u0002\f\u0001\u0011\r\u0011\"\u0003\u007f\u0011\u001d\ti\u0001\u0001Q\u0001\n}D\u0011\"a\u0004\u0001\u0005\u0004%I!!\u0005\t\u0011\u0005e\u0001\u0001)A\u0005\u0003'A\u0011\"a\u0007\u0001\u0005\u0004%I!!\b\t\u0011\u0005-\u0002\u0001)A\u0005\u0003?A1\"!\f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00020!Y\u0011q\u0007\u0001A\u0002\u0003\u0007I\u0011BA\u001d\u0011-\t)\u0005\u0001a\u0001\u0002\u0003\u0006K!!\r\t\u000f\u0005\u001d\u0003\u0001\"\u0003\u0002J!9\u0011Q\u000b\u0001\u0005\n\u0005]\u0003bBA5\u0001\u0011\u0005\u00131\u000e\u0005\b\u0003[\u0002A\u0011BA8\u0011\u001d\ti\u0007\u0001C\u0005\u0003CCq!!\u001c\u0001\t\u0013\tI\fC\u0004\u0002n\u0001!I!!3\u00037!Kg/\u001a)beRLG/[8o\r&dG/\u001a:j]\u001e\u001cV/\u001b;f\u0015\t)c%\u0001\u0004dY&,g\u000e\u001e\u0006\u0003O!\nA\u0001[5wK*\u0011\u0011FK\u0001\u0004gFd'BA\u0016-\u0003\u0015\u0019\b/\u0019:l\u0015\tic&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002_\u0005\u0019qN]4\u0004\u0001M!\u0001A\r\u001c=!\t\u0019D'D\u0001%\u0013\t)DE\u0001\tISZ,g+\u001a:tS>t7+^5uKB\u0011qGO\u0007\u0002q)\u0011\u0011HL\u0001\ng\u000e\fG.\u0019;fgRL!a\u000f\u001d\u0003#\t+gm\u001c:f\u0003:$\u0017I\u001a;fe\u0006cG\u000e\u0005\u0002>\u00056\taH\u0003\u0002@\u0001\u0006)\u0001\u000f\\1og*\u0011\u0011\tK\u0001\tG\u0006$\u0018\r\\=ti&\u00111I\u0010\u0002\n'Fc\u0005*\u001a7qKJ\fqA^3sg&|g\u000e\u0005\u0002G\u001f:\u0011q)\u0014\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015B\na\u0001\u0010:p_Rt$\"\u0001'\u0002\u000bM\u001c\u0017\r\\1\n\u00059[\u0015A\u0002)sK\u0012,g-\u0003\u0002Q#\n11\u000b\u001e:j]\u001eT!AT&\u0002\rqJg.\u001b;?)\t!V\u000b\u0005\u00024\u0001!)AI\u0001a\u0001\u000b\u0006yAO]=ESJ,7\r^*rY.+\u00170F\u0001Y!\tIf,D\u0001[\u0015\tYF,\u0001\u0003mC:<'\"A/\u0002\t)\fg/Y\u0005\u0003!j\u000b\u0001\u0003\u001e:z\t&\u0014Xm\u0019;Tc2\\U-\u001f\u0011\u0002\u0017\u0019\fG\u000e\u001c2bG.\\U-_\u000b\u0002\u000b\u0006aa-\u00197mE\u0006\u001c7nS3zA\u0005\u0019\u0002O];oS:<g)Y:u\r\u0006dGNY1dW\u0006!\u0002O];oS:<g)Y:u\r\u0006dGNY1dW\u0002\n\u0001\u0003Z3gCVdG\u000fU1si&$\u0018n\u001c8\u0016\u0003\u001d\u00042\u0001[5Y\u001b\u0005Y\u0015B\u00016L\u0005\u0019y\u0005\u000f^5p]\u0006\tB-\u001a4bk2$\b+\u0019:uSRLwN\u001c\u0011\u0002\u000f\u0011\u001ch+\u00197vKV\ta\u000e\u0005\u0002po:\u0011\u0001/^\u0007\u0002c*\u0011!o]\u0001\nS6lW\u000f^1cY\u0016T!\u0001^&\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002wc\u0006)!+\u00198hK&\u0011\u00010\u001f\u0002\n\u0013:\u001cG.^:jm\u0016T!A^9\u0002\u0011\u0011\u001ch+\u00197vK\u0002\na\u0001\u001b,bYV,\u0017a\u00025WC2,X\rI\u0001\u000bG\",hn\u001b,bYV,W#A@\u0011\tA\f\t\u0001W\u0005\u0004\u0003\u0007\t(aA*fc\u0006Y1\r[;oWZ\u000bG.^3!\u0003%!\u0017\r^3WC2,X-\u0001\u0006eCR,g+\u00197vK\u0002\nA\u0002Z1uKN#(OV1mk\u0016\fQ\u0002Z1uKN#(OV1mk\u0016\u0004\u0013A\u0005;fgR\u0004\u0016M\u001d;ji&|gnQ8v]R,\"!a\u0005\u0011\u0007!\f)\"C\u0002\u0002\u0018-\u00131!\u00138u\u0003M!Xm\u001d;QCJ$\u0018\u000e^5p]\u000e{WO\u001c;!\u00035\u0019Ho\u001c:bO\u00164uN]7biV\u0011\u0011q\u0004\t\u0005\u0003C\t9#\u0004\u0002\u0002$)\u0019\u0011Q\u0005!\u0002\u000f\r\fG/\u00197pO&!\u0011\u0011FA\u0012\u0005Q\u0019\u0015\r^1m_\u001e\u001cFo\u001c:bO\u00164uN]7bi\u0006q1\u000f^8sC\u001e,gi\u001c:nCR\u0004\u0013AF2mS\u0016tGoV5uQ>,H\u000fR5sK\u000e$8+\u001d7\u0016\u0005\u0005E\u0002cA\u001a\u00024%\u0019\u0011Q\u0007\u0013\u0003\u0015!Kg/Z\"mS\u0016tG/\u0001\u000edY&,g\u000e^,ji\"|W\u000f\u001e#je\u0016\u001cGoU9m?\u0012*\u0017\u000f\u0006\u0003\u0002<\u0005\u0005\u0003c\u00015\u0002>%\u0019\u0011qH&\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u0007R\u0012\u0011!a\u0001\u0003c\t1\u0001\u001f\u00132\u0003]\u0019G.[3oi^KG\u000f[8vi\u0012K'/Z2u'Fd\u0007%\u0001\u0003j]&$H\u0003BA\u0019\u0003\u0017Bq!!\u0014\u001d\u0001\u0004\ty%\u0001\u0007uef$\u0015N]3diN\u000bH\u000eE\u0002i\u0003#J1!a\u0015L\u0005\u001d\u0011un\u001c7fC:\fA!\u0019;ueR!\u0011\u0011LA3!\u0011\tY&!\u0019\u000e\u0005\u0005u#bAA0\u0001\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\u0011\t\u0019'!\u0018\u0003\u0013\u0005#HO]5ckR,\u0007BBA4;\u0001\u0007Q)\u0001\u0003oC6,\u0017!\u00032fM>\u0014X-\u00117m)\t\tY$A\u0010uKN$X*\u001a;bgR|'/\u001a)beRLG/[8o\r&dG/\u001a:j]\u001e$b\"a\u000f\u0002r\u0005m\u0014qRAJ\u00033\u000bi\nC\u0004\u0002t}\u0001\r!!\u001e\u0002\u0015\u0019LG\u000e^3s\u000bb\u0004(\u000f\u0005\u0003\u0002\\\u0005]\u0014\u0002BA=\u0003;\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0011\u001d\tih\ba\u0001\u0003\u007f\n!\"\u001a=qK\u000e$X\r\u001a#t!\u0019\t\t)a#\u0002\u00149!\u00111QAD\u001d\rA\u0015QQ\u0005\u0002\u0019&\u0019\u0011\u0011R&\u0002\u000fA\f7m[1hK&!\u00111AAG\u0015\r\tIi\u0013\u0005\b\u0003#{\u0002\u0019AA@\u0003%)\u0007\u0010]3di\u0016$\u0007\nC\u0004\u0002\u0016~\u0001\r!a&\u0002\u001d\u0015D\b/Z2uK\u0012\u001c\u0005.\u001e8lgB)\u0011\u0011QAF\u000b\"9\u00111T\u0010A\u0002\u0005]\u0015!C3ya\u0016\u001cG/\u001a3E\u0011\u001d\tyj\ba\u0001\u0003/\u000bq\"\u001a=qK\u000e$X\r\u001a#bi\u0016\u001cHO\u001d\u000b\u0011\u0003w\t\u0019+!*\u0002(\u0006%\u00161VAW\u0003_Cq!a\u001d!\u0001\u0004\t)\bC\u0004\u0002~\u0001\u0002\r!a \t\u000f\u0005E\u0005\u00051\u0001\u0002\u0000!9\u0011Q\u0013\u0011A\u0002\u0005]\u0005bBANA\u0001\u0007\u0011q\u0013\u0005\b\u0003?\u0003\u0003\u0019AAL\u0011\u001d\t\t\f\ta\u0001\u0003g\u000b\u0011\u0002\u001e:b]N4wN]7\u0011\u000f!\f),!\u001e\u0002v%\u0019\u0011qW&\u0003\u0013\u0019+hn\u0019;j_:\fDCBA\u001e\u0003w\u000bi\fC\u0004\u0002t\u0005\u0002\r!!\u001e\t\u000f\u0005}\u0016\u00051\u0001\u0002B\u00061R\r\u001f9fGR,G\rU1si&$\u0018n\u001c8Dk\n,7\u000f\u0005\u0004\u0002\u0002\u0006-\u00151\u0019\t\u000eQ\u0006\u0015\u0017qPA@\u0003/\u000b9*a&\n\u0007\u0005\u001d7J\u0001\u0004UkBdW-\u000e\u000b\t\u0003w\tY-!4\u0002P\"9\u00111\u000f\u0012A\u0002\u0005U\u0004bBA`E\u0001\u0007\u0011\u0011\u0019\u0005\b\u0003c\u0013\u0003\u0019AAZ\u0001")
public class HivePartitionFilteringSuite
extends HiveVersionSuite
implements SQLHelper {
    private final String tryDirectSqlKey;
    private final String fallbackKey;
    private final String pruningFastFallback;
    private final Option<String> defaultPartition;
    private final Range.Inclusive dsValue;
    private final Range.Inclusive hValue;
    private final Seq<String> chunkValue;
    private final Seq<String> dateValue;
    private final Seq<String> dateStrValue;
    private final int testPartitionCount;
    private final CatalogStorageFormat storageFormat;
    private HiveClient clientWithoutDirectSql;
    private String sparkHome;
    private volatile boolean bitmap$0;

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    private String sparkHome$lzycompute() {
        HivePartitionFilteringSuite hivePartitionFilteringSuite = this;
        synchronized (hivePartitionFilteringSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    private String tryDirectSqlKey() {
        return this.tryDirectSqlKey;
    }

    private String fallbackKey() {
        return this.fallbackKey;
    }

    private String pruningFastFallback() {
        return this.pruningFastFallback;
    }

    private Option<String> defaultPartition() {
        return this.defaultPartition;
    }

    private Range.Inclusive dsValue() {
        return this.dsValue;
    }

    private Range.Inclusive hValue() {
        return this.hValue;
    }

    private Seq<String> chunkValue() {
        return this.chunkValue;
    }

    private Seq<String> dateValue() {
        return this.dateValue;
    }

    private Seq<String> dateStrValue() {
        return this.dateStrValue;
    }

    private int testPartitionCount() {
        return this.testPartitionCount;
    }

    private CatalogStorageFormat storageFormat() {
        return this.storageFormat;
    }

    private HiveClient clientWithoutDirectSql() {
        return this.clientWithoutDirectSql;
    }

    private void clientWithoutDirectSql_$eq(HiveClient x$1) {
        this.clientWithoutDirectSql = x$1;
    }

    /*
     * WARNING - void declaration
     */
    private HiveClient init(boolean tryDirectSql) {
        void var3_3;
        IndexedSeq partitions;
        Configuration hadoopConf = new Configuration();
        hadoopConf.setBoolean(this.tryDirectSqlKey(), tryDirectSql);
        hadoopConf.set("hive.metastore.warehouse.dir", Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toURI().toString());
        HiveClient client = this.buildClient(hadoopConf);
        StructType tableSchema = new StructType().add("value", "int").add("ds", "int").add("h", "int").add("chunk", "string").add("d", "date").add("datestr", "string");
        TableIdentifier x$1 = new TableIdentifier("test", (Option)new Some((Object)"default"));
        CatalogTableType x$2 = CatalogTableType$.MODULE$.MANAGED();
        StructType x$3 = tableSchema;
        Seq x$4 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ds", "h", "chunk", "d", "datestr"}));
        CatalogStorageFormat x$5 = this.storageFormat();
        Option x$6 = CatalogTable$.MODULE$.apply$default$5();
        Option x$7 = CatalogTable$.MODULE$.apply$default$7();
        String x$8 = CatalogTable$.MODULE$.apply$default$8();
        long x$9 = CatalogTable$.MODULE$.apply$default$9();
        long x$10 = CatalogTable$.MODULE$.apply$default$10();
        String x$11 = CatalogTable$.MODULE$.apply$default$11();
        Map x$12 = CatalogTable$.MODULE$.apply$default$12();
        Option x$13 = CatalogTable$.MODULE$.apply$default$13();
        Option x$14 = CatalogTable$.MODULE$.apply$default$14();
        Option x$15 = CatalogTable$.MODULE$.apply$default$15();
        Seq x$16 = CatalogTable$.MODULE$.apply$default$16();
        boolean x$17 = CatalogTable$.MODULE$.apply$default$17();
        boolean x$18 = CatalogTable$.MODULE$.apply$default$18();
        Map x$19 = CatalogTable$.MODULE$.apply$default$19();
        Option x$20 = CatalogTable$.MODULE$.apply$default$20();
        CatalogTable table = new CatalogTable(x$1, x$2, x$5, x$3, x$6, x$4, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        client.createTable(table, false);
        IndexedSeq $org_scalatest_assert_macro_left = partitions = (IndexedSeq)this.dsValue().flatMap((Function1 & Serializable)ds -> HivePartitionFilteringSuite.$anonfun$init$1(this, BoxesRunTime.unboxToInt((Object)ds)));
        int $org_scalatest_assert_macro_right = this.testPartitionCount();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        client.createPartitions("default", "test", (Seq)partitions, false);
        return var3_3;
    }

    private Attribute attr(String name) {
        Option option = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])this.client().getTable("default", "test").partitionSchema().fields()), (Function1 & Serializable)field -> BoxesRunTime.boxToBoolean((boolean)HivePartitionFilteringSuite.$anonfun$attr$1(name, field)));
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw this.fail(new StringBuilder(37).append("Illegal name of partition attribute: ").append(name).toString(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        StructField field2 = (StructField)some.value();
        String x$1 = field2.name();
        DataType x$2 = field2.dataType();
        boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
        AttributeReference attributeReference = new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
        return attributeReference;
    }

    public void beforeAll() {
        super.beforeAll();
        this.client_$eq(this.init(true));
        this.clientWithoutDirectSql_$eq(this.init(false));
    }

    private void testMetastorePartitionFiltering(Expression filterExpr, Seq<Object> expectedDs, Seq<Object> expectedH, Seq<String> expectedChunks, Seq<String> expectedD, Seq<String> expectedDatestr) {
        Tuple5 tuple5 = new Tuple5(expectedDs, expectedH, expectedChunks, expectedD, expectedDatestr);
        this.testMetastorePartitionFiltering(filterExpr, (Seq<Tuple5<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>>>)package$.MODULE$.Nil().$colon$colon((Object)tuple5), (Function1<Expression, Expression>)(Function1 & Serializable)x -> (Expression)Predef$.MODULE$.identity(x));
    }

    private void testMetastorePartitionFiltering(Expression filterExpr, Seq<Object> expectedDs, Seq<Object> expectedH, Seq<String> expectedChunks, Seq<String> expectedD, Seq<String> expectedDatestr, Function1<Expression, Expression> transform) {
        Tuple5 tuple5 = new Tuple5(expectedDs, expectedH, expectedChunks, expectedD, expectedDatestr);
        this.testMetastorePartitionFiltering(filterExpr, (Seq<Tuple5<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>>>)package$.MODULE$.Nil().$colon$colon((Object)tuple5), transform);
    }

    private void testMetastorePartitionFiltering(Expression filterExpr, Seq<Tuple5<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>>> expectedPartitionCubes) {
        this.testMetastorePartitionFiltering(filterExpr, expectedPartitionCubes, (Function1<Expression, Expression>)(Function1 & Serializable)x -> (Expression)Predef$.MODULE$.identity(x));
    }

    private void testMetastorePartitionFiltering(Expression filterExpr, Seq<Tuple5<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>>> expectedPartitionCubes, Function1<Expression, Expression> transform) {
        int actualFilteredPartitionCount;
        Seq filteredPartitions = this.client().getPartitionsByFilter(this.client().getRawHiveTable("default", "test"), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)transform.apply((Object)filterExpr)})));
        int expectedPartitionCount = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)expectedPartitionCubes.map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)HivePartitionFilteringSuite.$anonfun$testMetastorePartitionFiltering$3(x0$1)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Seq expectedPartitions = (Seq)((IterableOnceOps)expectedPartitionCubes.map((Function1 & Serializable)x0$2 -> {
            Tuple5 tuple5 = x0$2;
            if (tuple5 == null) {
                throw new MatchError((Object)tuple5);
            }
            Seq expectedDs = (Seq)tuple5._1();
            Seq expectedH = (Seq)tuple5._2();
            Seq expectedChunks = (Seq)tuple5._3();
            Seq expectedD = (Seq)tuple5._4();
            Seq expectedDatestr = (Seq)tuple5._5();
            Seq seq = (Seq)expectedDs.flatMap((Function1 & Serializable)ds -> HivePartitionFilteringSuite.$anonfun$testMetastorePartitionFiltering$5(expectedH, expectedChunks, expectedD, expectedDatestr, BoxesRunTime.unboxToInt((Object)ds)));
            return seq;
        })).reduce((Function2 & Serializable)(x$5, x$6) -> (Seq)x$5.$plus$plus((IterableOnce)x$6));
        int $org_scalatest_assert_macro_left = actualFilteredPartitionCount = filteredPartitions.size();
        int $org_scalatest_assert_macro_right = expectedPartitionCount;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(29).append("Expected ").append(expectedPartitionCount).append(" partitions but got ").append(actualFilteredPartitionCount).toString(), Prettifier$.MODULE$.default(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 738));
        Set $org_scalatest_assert_macro_left2 = ((IterableOnceOps)filteredPartitions.map((Function1 & Serializable)x$7 -> x$7.spec().toSet())).toSet();
        Set $org_scalatest_assert_macro_right2 = expectedPartitions.toSet();
        Set set = $org_scalatest_assert_macro_left2;
        Set set2 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 740));
    }

    public static final /* synthetic */ Seq $anonfun$init$2(HivePartitionFilteringSuite $this, int ds$1, int h) {
        return (Seq)$this.chunkValue().flatMap((Function1 & Serializable)chunk -> (Seq)$this.dateValue().flatMap((Function1 & Serializable)date -> (Seq)$this.dateStrValue().map((Function1 & Serializable)dateStr -> new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)Integer.toString(ds$1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"h"), (Object)Integer.toString(h)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"chunk"), chunk), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), date), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datestr"), dateStr)})), $this.storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6()))));
    }

    public static final /* synthetic */ IndexedSeq $anonfun$init$1(HivePartitionFilteringSuite $this, int ds) {
        return (IndexedSeq)$this.hValue().flatMap((Function1 & Serializable)h -> HivePartitionFilteringSuite.$anonfun$init$2($this, ds, BoxesRunTime.unboxToInt((Object)h)));
    }

    public static final /* synthetic */ boolean $anonfun$attr$1(String name$1, StructField field) {
        return field.name().equals(name$1);
    }

    private final void check$1(Expression condition, Seq result) {
        this.testMetastorePartitionFiltering(condition, (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)result, this.dateValue(), this.dateStrValue());
    }

    private final void check$2(Expression condition, Seq result) {
        this.testMetastorePartitionFiltering(condition, (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)result, this.dateStrValue());
    }

    public static final /* synthetic */ void $anonfun$new$66(HivePartitionFilteringSuite $this, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String pruningFastFallbackEnabled = (String)tuple2._1();
        Seq prunedPartition = (Seq)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pruningFastFallback()), (Object)pruningFastFallbackEnabled)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)$this.attr("datestr")).cast((DataType)IntegerType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20200104)), (Seq<Object>)$this.dsValue(), (Seq<Object>)$this.hValue(), $this.chunkValue(), $this.dateValue(), (Seq<String>)prunedPartition));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ int $anonfun$testMetastorePartitionFiltering$3(Tuple5 x0$1) {
        Tuple5 tuple5 = x0$1;
        if (tuple5 == null) {
            throw new MatchError((Object)tuple5);
        }
        Seq expectedDs = (Seq)tuple5._1();
        Seq expectedH = (Seq)tuple5._2();
        Seq expectedChunks = (Seq)tuple5._3();
        Seq expectedD = (Seq)tuple5._4();
        Seq expectedDatestr = (Seq)tuple5._5();
        int n = expectedDs.size() * expectedH.size() * expectedChunks.size() * expectedD.size() * expectedDatestr.size();
        return n;
    }

    public static final /* synthetic */ Seq $anonfun$testMetastorePartitionFiltering$6(Seq expectedChunks$1, Seq expectedD$1, Seq expectedDatestr$1, int ds$2, int h) {
        return (Seq)expectedChunks$1.flatMap((Function1 & Serializable)chunk -> (Seq)expectedD$1.flatMap((Function1 & Serializable)d -> (Seq)expectedDatestr$1.map((Function1 & Serializable)datestr -> (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)Integer.toString(ds$2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"h"), (Object)Integer.toString(h)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"chunk"), chunk), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), d), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datestr"), datestr)})))));
    }

    public static final /* synthetic */ Seq $anonfun$testMetastorePartitionFiltering$5(Seq expectedH$1, Seq expectedChunks$1, Seq expectedD$1, Seq expectedDatestr$1, int ds) {
        return (Seq)expectedH$1.flatMap((Function1 & Serializable)h -> HivePartitionFilteringSuite.$anonfun$testMetastorePartitionFiltering$6(expectedChunks$1, expectedD$1, expectedDatestr$1, ds, BoxesRunTime.unboxToInt((Object)h)));
    }

    public HivePartitionFilteringSuite(String version) {
        super(version);
        SQLHelper.$init$((SQLHelper)this);
        this.tryDirectSqlKey = HiveConf.ConfVars.METASTORE_TRY_DIRECT_SQL.varname;
        this.fallbackKey = SQLConf$.MODULE$.HIVE_METASTORE_PARTITION_PRUNING_FALLBACK_ON_EXCEPTION().key();
        this.pruningFastFallback = SQLConf$.MODULE$.HIVE_METASTORE_PARTITION_PRUNING_FAST_FALLBACK().key();
        this.defaultPartition = StringOps$.MODULE$.$greater$eq$extension(Predef$.MODULE$.augmentString(version), "2.0") ? new Some((Object)ExternalCatalogUtils$.MODULE$.DEFAULT_PARTITION_NAME()) : None$.MODULE$;
        this.dsValue = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170101), 20170103);
        this.hValue = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4);
        this.chunkValue = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"aa", "ab", "ba", "bb"}));
        this.dateValue = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"2019-01-01", "2019-01-02", "2019-01-03"})).$plus$plus(this.defaultPartition());
        this.dateStrValue = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"2020-01-01", "2020-01-02", "2020-01-03", "20200104", "20200105"}));
        this.testPartitionCount = this.dsValue().size() * this.hValue().size() * this.chunkValue().size() * this.dateValue().size() * this.dateStrValue().size();
        this.storageFormat = new CatalogStorageFormat((Option)None$.MODULE$, (Option)new Some((Object)TextInputFormat.class.getName()), (Option)new Some((Object)HiveIgnoreKeyTextOutputFormat.class.getName()), (Option)new Some((Object)LazySimpleSerDe.class.getName()), false, Predef$.MODULE$.Map().empty());
        this.test(new StringBuilder(55).append("getPartitionsByFilter returns all partitions when ").append(this.fallbackKey()).append("=true").toString(), (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fallbackKey()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Seq filteredPartitions;
            Seq $org_scalatest_assert_macro_left = filteredPartitions = this.clientWithoutDirectSql().getPartitionsByFilter(this.clientWithoutDirectSql().getRawHiveTable("default", "test"), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Predicate[]{package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))})));
            int $org_scalatest_assert_macro_right = this.testPartitionCount();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        this.test(new StringBuilder(45).append("getPartitionsByFilter should fail when ").append(this.fallbackKey()).append("=false").toString(), (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fallbackKey()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            RuntimeException e = (RuntimeException)this.intercept((Function0 & Serializable)() -> this.clientWithoutDirectSql().getPartitionsByFilter(this.clientWithoutDirectSql().getRawHiveTable("default", "test"), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Predicate[]{package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))}))), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "Caught Hive MetaException";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        this.test("getPartitionsByFilter: ds<=>20170101", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$less$eq$greater((Expression)package.expressions$.MODULE$.intToLiteral(20170101)), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        this.test("getPartitionsByFilter: ds=20170101", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101)), (Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170101), 20170101), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        this.test("getPartitionsByFilter: ds=(20170101 + 1) and h=0", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)20170101))).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1)))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(0))), (Seq<Object>)this.dsValue(), (Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 0), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        this.test("getPartitionsByFilter: chunk='aa'", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("aa")), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)package$.MODULE$.Nil().$colon$colon((Object)"aa"), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        this.test("getPartitionsByFilter: cast(chunk as int)=1 (not a valid partition predicate)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).cast((DataType)IntegerType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        this.test("getPartitionsByFilter: cast(chunk as boolean)=true (not a valid partition predicate)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).cast((DataType)BooleanType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.booleanToLiteral(true)), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
        this.test("getPartitionsByFilter: 20170101=ds", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)20170101))).$eq$eq$eq((Expression)this.attr("ds")), (Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170101), 20170101), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        this.test("getPartitionsByFilter: ds=20170101 and h=2", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))), (Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170101), 20170101), (Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(2), 2), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
        this.test("getPartitionsByFilter: cast(ds as long)=20170101L and h=2", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).cast((DataType)LongType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.longToLiteral(20170101L))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))), (Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170101), 20170101), (Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(2), 2), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
        this.test("getPartitionsByFilter: ds=20170101 or ds=20170102", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170102))), (Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170101), 20170102), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
        this.test("getPartitionsByFilter: ds in (20170102, 20170103) (using IN expression)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).in((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(20170102), package.expressions$.MODULE$.intToLiteral(20170103)})), (Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170102), 20170103), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
        this.test("getPartitionsByFilter: cast(ds as long) in (20170102L, 20170103L) (using IN expression)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).cast((DataType)LongType$.MODULE$)).in((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.longToLiteral(20170102L), package.expressions$.MODULE$.longToLiteral(20170103L)})), (Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170102), 20170103), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        this.test("getPartitionsByFilter: ds in (20170102, 20170103) (using INSET expression)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).in((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(20170102), package.expressions$.MODULE$.intToLiteral(20170103)})), (Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170102), 20170103), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue(), (Function1<Expression, Expression>)(Function1 & Serializable)x0$1 -> {
            Seq list;
            Expression v;
            block3: {
                Expression expression;
                block2: {
                    expression = x0$1;
                    if (!(expression instanceof In)) break block2;
                    In in = (In)expression;
                    v = in.value();
                    list = in.list();
                    if (in.inSetConvertible()) break block3;
                }
                throw new MatchError((Object)expression);
            }
            InSet inSet = new InSet(v, ((IterableOnceOps)list.map((Function1 & Serializable)x$2 -> x$2.eval(org.apache.spark.sql.catalyst.expressions.package$.MODULE$.EmptyRow()))).toSet());
            return inSet;
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
        this.test("getPartitionsByFilter: cast(ds as long) in (20170102L, 20170103L) (using INSET expression)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).cast((DataType)LongType$.MODULE$)).in((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.longToLiteral(20170102L), package.expressions$.MODULE$.longToLiteral(20170103L)})), (Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170102), 20170103), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue(), (Function1<Expression, Expression>)(Function1 & Serializable)x0$2 -> {
            Seq list;
            Expression v;
            block3: {
                Expression expression;
                block2: {
                    expression = x0$2;
                    if (!(expression instanceof In)) break block2;
                    In in = (In)expression;
                    v = in.value();
                    list = in.list();
                    if (in.inSetConvertible()) break block3;
                }
                throw new MatchError((Object)expression);
            }
            InSet inSet = new InSet(v, ((IterableOnceOps)list.map((Function1 & Serializable)x$3 -> x$3.eval(org.apache.spark.sql.catalyst.expressions.package$.MODULE$.EmptyRow()))).toSet());
            return inSet;
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
        this.test("getPartitionsByFilter: chunk in ('ab', 'ba') (using IN expression)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).in((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("ab"), package.expressions$.MODULE$.stringToLiteral("ba")})), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)package$.MODULE$.Nil().$colon$colon((Object)"ba").$colon$colon((Object)"ab"), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
        this.test("getPartitionsByFilter: chunk in ('ab', 'ba') (using INSET expression)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).in((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("ab"), package.expressions$.MODULE$.stringToLiteral("ba")})), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)package$.MODULE$.Nil().$colon$colon((Object)"ba").$colon$colon((Object)"ab"), this.dateValue(), this.dateStrValue(), (Function1<Expression, Expression>)(Function1 & Serializable)x0$3 -> {
            Seq list;
            Expression v;
            block3: {
                Expression expression;
                block2: {
                    expression = x0$3;
                    if (!(expression instanceof In)) break block2;
                    In in = (In)expression;
                    v = in.value();
                    list = in.list();
                    if (in.inSetConvertible()) break block3;
                }
                throw new MatchError((Object)expression);
            }
            InSet inSet = new InSet(v, ((IterableOnceOps)list.map((Function1 & Serializable)x$4 -> x$4.eval(org.apache.spark.sql.catalyst.expressions.package$.MODULE$.EmptyRow()))).toSet());
            return inSet;
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
        this.test("getPartitionsByFilter: (ds=20170101 and h>=2) or (ds=20170102 and h<2)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Tuple5 day1 = new Tuple5((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170101), 20170101), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(2), 4), this.chunkValue(), this.dateValue(), this.dateStrValue());
            Tuple5 day2 = new Tuple5((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170102), 20170102), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 1), this.chunkValue(), this.dateValue(), this.dateStrValue());
            Tuple5 tuple5 = day1;
            Tuple5 tuple52 = day2;
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170102))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$less((Expression)package.expressions$.MODULE$.intToLiteral(2)))), (Seq<Tuple5<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>>>)package$.MODULE$.Nil().$colon$colon((Object)tuple52).$colon$colon((Object)tuple5));
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
        this.test("getPartitionsByFilter: (ds=20170101 and h>=2) or (ds=20170102 and h<(1+1))", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Tuple5 day1 = new Tuple5((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170101), 20170101), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(2), 4), this.chunkValue(), this.dateValue(), this.dateStrValue());
            Tuple5 day2 = new Tuple5((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170102), 20170102), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4), this.chunkValue(), this.dateValue(), this.dateStrValue());
            Tuple5 tuple5 = day1;
            Tuple5 tuple52 = day2;
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170102))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$less(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))))), (Seq<Tuple5<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>>>)package$.MODULE$.Nil().$colon$colon((Object)tuple52).$colon$colon((Object)tuple5));
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
        this.test("getPartitionsByFilter: chunk in ('ab', 'ba') and ((ds=20170101 and h>=2) or (ds=20170102 and h<2))", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Tuple5 day1 = new Tuple5((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170101), 20170101), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(2), 4), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ab", "ba"})), this.dateValue(), this.dateStrValue());
            Tuple5 day2 = new Tuple5((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170102), 20170102), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 1), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ab", "ba"})), this.dateValue(), this.dateStrValue());
            Tuple5 tuple5 = day1;
            Tuple5 tuple52 = day2;
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).in((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("ab"), package.expressions$.MODULE$.stringToLiteral("ba")}))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170102))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$less((Expression)package.expressions$.MODULE$.intToLiteral(2))))), (Seq<Tuple5<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>>>)package$.MODULE$.Nil().$colon$colon((Object)tuple52).$colon$colon((Object)tuple5));
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
        this.test("getPartitionsByFilter: chunk contains bb", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).contains((Expression)package.expressions$.MODULE$.stringToLiteral("bb")), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bb"}))), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
        this.test("getPartitionsByFilter: chunk startsWith b", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).startsWith((Expression)package.expressions$.MODULE$.stringToLiteral("b")), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ba", "bb"}))), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
        this.test("getPartitionsByFilter: chunk endsWith b", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).endsWith((Expression)package.expressions$.MODULE$.stringToLiteral("b")), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ab", "bb"}))), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358));
        this.test("getPartitionsByFilter: chunk in ('ab', 'ba') and ((cast(ds as string)>'20170102')", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).in((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("ab"), package.expressions$.MODULE$.stringToLiteral("ba")}))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).cast((DataType)StringType$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.stringToLiteral("20170102"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ab", "ba"}))), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
        this.test("getPartitionsByFilter: ds<>20170101", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$bang$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101)), (Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20170102), 20170103), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 378));
        this.test("getPartitionsByFilter: h<>0 and chunk<>ab and d<>2019-01-01", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$eq$bang$eq((Expression)package.expressions$.MODULE$.intToLiteral(0))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).$eq$bang$eq((Expression)package.expressions$.MODULE$.stringToLiteral("ab")))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$eq$bang$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01")))), (Seq<Object>)this.dsValue(), (Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 4), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"aa", "ba", "bb"}))), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"2019-01-02", "2019-01-03"}))), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
        this.test("getPartitionsByFilter: d=2019-01-01", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$eq$eq$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"2019-01-01"}))), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398));
        this.test("getPartitionsByFilter: d>2019-01-02", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$greater((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-02"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"2019-01-03"}))), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408));
        this.test("getPartitionsByFilter: In(d, 2019-01-01, 2019-01-02)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)new In((Expression)this.attr("d"), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"2019-01-01", "2019-01-02"})).map((Function1 & Serializable)d -> Literal$.MODULE$.apply((Object)Date.valueOf(d)))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"2019-01-01", "2019-01-02"}))), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 418));
        this.test("getPartitionsByFilter: InSet(d, 2019-01-01, 2019-01-02)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)new InSet((Expression)this.attr("d"), (Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"2019-01-01", "2019-01-02"}))).map((Function1 & Serializable)d -> Literal$.MODULE$.apply((Object)Date.valueOf(d)).eval(org.apache.spark.sql.catalyst.expressions.package$.MODULE$.EmptyRow()))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"2019-01-01", "2019-01-02"}))), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 429));
        this.test("getPartitionsByFilter: not in/inset string type", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.check$1((Expression)new Not((Expression)new In((Expression)this.attr("chunk"), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)"aa"), Literal$.MODULE$.apply((Object)"ab")})))), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ba", "bb"})));
            this.check$1((Expression)new Not((Expression)new In((Expression)this.attr("chunk"), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)"aa"), Literal$.MODULE$.apply((Object)"ab"), Literal$.MODULE$.apply(null)})))), this.chunkValue());
            Object[] objectArray = new Object[2];
            Literal qual$1 = Literal$.MODULE$.apply((Object)"aa");
            InternalRow x$1 = qual$1.eval$default$1();
            objectArray[0] = qual$1.eval(x$1);
            Literal qual$2 = Literal$.MODULE$.apply((Object)"ab");
            InternalRow x$2 = qual$2.eval$default$1();
            objectArray[1] = qual$2.eval(x$2);
            this.check$1((Expression)new Not((Expression)new InSet((Expression)this.attr("chunk"), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray)))), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ba", "bb"})));
            this.check$1((Expression)new Not((Expression)new InSet((Expression)this.attr("chunk"), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"aa", "ab", null})))), this.chunkValue());
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 440));
        this.test("getPartitionsByFilter: not in/inset date type", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.check$2((Expression)new Not((Expression)new In((Expression)this.attr("d"), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-01")), Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-02"))})))), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"2019-01-03"})));
            this.check$2((Expression)new Not((Expression)new In((Expression)this.attr("d"), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-01")), Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-02")), Literal$.MODULE$.apply(null)})))), this.dateValue());
            Object[] objectArray = new Object[2];
            Literal qual$3 = Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-01"));
            InternalRow x$3 = qual$3.eval$default$1();
            objectArray[0] = qual$3.eval(x$3);
            Literal qual$4 = Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-02"));
            InternalRow x$4 = qual$4.eval$default$1();
            objectArray[1] = qual$4.eval(x$4);
            this.check$2((Expression)new Not((Expression)new InSet((Expression)this.attr("d"), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray)))), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"2019-01-03"})));
            Object[] objectArray2 = new Object[3];
            Literal qual$5 = Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-01"));
            InternalRow x$5 = qual$5.eval$default$1();
            objectArray2[0] = qual$5.eval(x$5);
            Literal qual$6 = Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-02"));
            InternalRow x$6 = qual$6.eval$default$1();
            objectArray2[1] = qual$6.eval(x$6);
            objectArray2[2] = null;
            this.check$2((Expression)new Not((Expression)new InSet((Expression)this.attr("d"), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray2)))), this.dateValue());
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 471));
        this.test("getPartitionsByFilter: cast(datestr as date)= 2020-01-01", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("datestr")).cast((DataType)DateType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2020-01-01"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 510));
        this.test("getPartitionsByFilter: IS NULL / IS NOT NULL", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Predicate[]{package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).isNull(), package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).isNotNull()})).foreach((Function1 & Serializable)filterExpr -> {
            this.testMetastorePartitionFiltering((Expression)filterExpr, (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue());
            return BoxedUnit.UNIT;
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 520));
        this.test("getPartitionsByFilter: IS NULL / IS NOT NULL with other filter", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Predicate[]{package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).isNull(), package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).isNotNull()})).foreach((Function1 & Serializable)filterExpr -> {
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)filterExpr).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$eq$eq$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01")))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"2019-01-01"}))), this.dateStrValue());
            return BoxedUnit.UNIT;
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 533));
        this.test("getPartitionsByFilter: d =!= 2019-01-01", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$eq$bang$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"2019-01-02", "2019-01-03"}))), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 545));
        this.test("getPartitionsByFilter: d =!= 2019-01-01 || IS NULL", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$eq$bang$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01")))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).isNull()), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 555));
        this.test("getPartitionsByFilter: d <=> 2019-01-01", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$less$eq$greater((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 565));
        this.test("getPartitionsByFilter: d <=> null", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$less$eq$greater((Expression)new Literal(null, (DataType)DateType$.MODULE$)), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 575));
        this.test("SPARK-35437: getPartitionsByFilter: substr(chunk,0,1)=a", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"true"), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"aa", "ab"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"false"), this.chunkValue())})).foreach((Function1 & Serializable)t -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pruningFastFallback()), t._1())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)new Substring((Expression)this.attr("chunk"), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)))).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("a")), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)((Seq)t._2()), this.dateValue(), this.dateStrValue()));
            return BoxedUnit.UNIT;
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 585));
        this.test("SPARK-35437: getPartitionsByFilter: year(d)=2019", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"true"), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"2019-01-01", "2019-01-02", "2019-01-03"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"false"), this.dateValue())})).foreach((Function1 & Serializable)t -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pruningFastFallback()), t._1())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)new Year((Expression)this.attr("d"))).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2019)), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)((Seq)t._2()), this.dateStrValue()));
            return BoxedUnit.UNIT;
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 599));
        this.test("SPARK-35437: getPartitionsByFilter: datestr=concat(2020-,01-,01)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"true"), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"2020-01-01"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"false"), this.dateStrValue())})).foreach((Function1 & Serializable)t -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pruningFastFallback()), t._1())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("datestr")).$eq$eq$eq((Expression)new Concat((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{package.expressions$.MODULE$.stringToLiteral("2020-"), package.expressions$.MODULE$.stringToLiteral("01-"), package.expressions$.MODULE$.stringToLiteral("01")})))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), (Seq<String>)((Seq)t._2())));
            return BoxedUnit.UNIT;
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 614));
        this.test(new StringBuilder(58).append("SPARK-35437: getPartitionsByFilter: ds=20170101 when ").append(this.fallbackKey()).append("=true").toString(), (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fallbackKey()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pruningFastFallback()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Seq filteredPartitions;
            Seq $org_scalatest_assert_macro_left = filteredPartitions = this.clientWithoutDirectSql().getPartitionsByFilter(this.clientWithoutDirectSql().getRawHiveTable("default", "test"), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Predicate[]{package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))})));
            int $org_scalatest_assert_macro_right = 1 * this.hValue().size() * this.chunkValue().size() * this.dateValue().size() * this.dateStrValue().size();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 634));
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 628));
        this.test("SPARK-35437: getPartitionsByFilter: relax cast if does not need timezone", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            BoxedUnit boxedUnit;
            if (!SQLConf$.MODULE$.get().ansiEnabled()) {
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"true", (Object)package$.MODULE$.Nil().$colon$colon((Object)"20200104")), new Tuple2((Object)"false", this.dateStrValue())})).foreach((Function1 & Serializable)x0$4 -> {
                    HivePartitionFilteringSuite.$anonfun$new$66(this, x0$4);
                    return BoxedUnit.UNIT;
                });
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"true", "false"})).foreach((Function1 & Serializable)pruningFastFallbackEnabled -> {
                    this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pruningFastFallback()), (Object)pruningFastFallbackEnabled)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("datestr")).cast((DataType)DateType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2020-01-01"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()));
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 639));
    }
}

