/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.TestUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.execution.BaseScriptTransformationExec;
import org.apache.spark.sql.execution.BaseScriptTransformationSuite;
import org.apache.spark.sql.execution.ExceptionInjectingOperator;
import org.apache.spark.sql.execution.ScriptTransformationIOSchema;
import org.apache.spark.sql.execution.ScriptTransformationIOSchema$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.SparkPlanTest$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.execution.HiveScriptTransformationExec;
import org.apache.spark.sql.hive.execution.HiveScriptTransformationSuite$;
import org.apache.spark.sql.hive.test.TestHiveContext;
import org.apache.spark.sql.hive.test.TestHiveSingleton;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TestUDT;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.tags.SlowHiveTest;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.exceptions.TestFailedException;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple1;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@SlowHiveTest
@ScalaSignature(bytes="\u0006\u0005\u00054AAB\u0004\u0001)!)\u0001\u0005\u0001C\u0001C!)A\u0005\u0001C)K!)1\u0007\u0001C!i!9q\u000b\u0001b\u0001\n\u0013A\u0006BB-\u0001A\u0003%AKA\u000fISZ,7k\u0019:jaR$&/\u00198tM>\u0014X.\u0019;j_:\u001cV/\u001b;f\u0015\tA\u0011\"A\u0005fq\u0016\u001cW\u000f^5p]*\u0011!bC\u0001\u0005Q&4XM\u0003\u0002\r\u001b\u0005\u00191/\u001d7\u000b\u00059y\u0011!B:qCJ\\'B\u0001\t\u0012\u0003\u0019\t\u0007/Y2iK*\t!#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001+i\u0001\"A\u0006\r\u000e\u0003]Q!\u0001C\u0006\n\u0005e9\"!\b\"bg\u0016\u001c6M]5qiR\u0013\u0018M\\:g_Jl\u0017\r^5p]N+\u0018\u000e^3\u0011\u0005mqR\"\u0001\u000f\u000b\u0005uI\u0011\u0001\u0002;fgRL!a\b\u000f\u0003#Q+7\u000f\u001e%jm\u0016\u001c\u0016N\\4mKR|g.\u0001\u0004=S:LGO\u0010\u000b\u0002EA\u00111\u0005A\u0007\u0002\u000f\u0005aA-\u001a4bk2$8+\u001a:EKR\ta\u0005\u0005\u0002(a9\u0011\u0001F\f\t\u0003S1j\u0011A\u000b\u0006\u0003WM\ta\u0001\u0010:p_Rt$\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b\u0013A\u0002)sK\u0012,g-\u0003\u00022e\t11\u000b\u001e:j]\u001eT!a\f\u0017\u0002=\r\u0014X-\u0019;f'\u000e\u0014\u0018\u000e\u001d;Ue\u0006t7OZ8s[\u0006$\u0018n\u001c8Fq\u0016\u001cG#B\u001b9u5\u0013\u0006C\u0001\f7\u0013\t9tC\u0001\u000fCCN,7k\u0019:jaR$&/\u00198tM>\u0014X.\u0019;j_:,\u00050Z2\t\u000be\u001a\u0001\u0019\u0001\u0014\u0002\rM\u001c'/\u001b9u\u0011\u0015Y4\u00011\u0001=\u0003\u0019yW\u000f\u001e9viB\u0019QHQ#\u000f\u0005y\u0002eBA\u0015@\u0013\u0005i\u0013BA!-\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0011#\u0003\u0007M+\u0017O\u0003\u0002BYA\u0011aiS\u0007\u0002\u000f*\u0011\u0001*S\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002K\u0017\u0005A1-\u0019;bYf\u001cH/\u0003\u0002M\u000f\nI\u0011\t\u001e;sS\n,H/\u001a\u0005\u0006\u001d\u000e\u0001\raT\u0001\u0006G\"LG\u000e\u001a\t\u0003-AK!!U\f\u0003\u0013M\u0003\u0018M]6QY\u0006t\u0007\"B*\u0004\u0001\u0004!\u0016\u0001C5pg\u000eDW-\\1\u0011\u0005Y)\u0016B\u0001,\u0018\u0005q\u00196M]5qiR\u0013\u0018M\\:g_Jl\u0017\r^5p]&{5k\u00195f[\u0006\fA\u0002[5wK&{5k\u00195f[\u0006,\u0012\u0001V\u0001\u000eQ&4X-S(TG\",W.\u0019\u0011)\u0005\u0001Y\u0006C\u0001/`\u001b\u0005i&B\u00010\u000e\u0003\u0011!\u0018mZ:\n\u0005\u0001l&\u0001D*m_^D\u0015N^3UKN$\b")
public class HiveScriptTransformationSuite
extends BaseScriptTransformationSuite
implements TestHiveSingleton {
    private final ScriptTransformationIOSchema hiveIOSchema;
    private boolean enableAutoThreadAudit;
    private SparkSession spark;
    private TestHiveContext hiveContext;
    private HiveClient hiveClient;

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public void afterAll() {
        TestHiveSingleton.afterAll$(this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public TestHiveContext hiveContext() {
        return this.hiveContext;
    }

    @Override
    public HiveClient hiveClient() {
        return this.hiveClient;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveContext_$eq(TestHiveContext x$1) {
        this.hiveContext = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveClient_$eq(HiveClient x$1) {
        this.hiveClient = x$1;
    }

    public String defaultSerDe() {
        return "hive-serde";
    }

    public BaseScriptTransformationExec createScriptTransformationExec(String script, Seq<Attribute> output, SparkPlan child, ScriptTransformationIOSchema ioschema) {
        return new HiveScriptTransformationExec(script, output, child, ioschema);
    }

    private ScriptTransformationIOSchema hiveIOSchema() {
        return this.hiveIOSchema;
    }

    public HiveScriptTransformationSuite() {
        TestHiveSingleton.$init$(this);
        Some x$1 = new Some((Object)LazySimpleSerDe.class.getCanonicalName());
        Some x$2 = new Some((Object)LazySimpleSerDe.class.getCanonicalName());
        Seq x$3 = ScriptTransformationIOSchema$.MODULE$.defaultIOSchema().copy$default$1();
        Seq x$4 = ScriptTransformationIOSchema$.MODULE$.defaultIOSchema().copy$default$2();
        Seq x$5 = ScriptTransformationIOSchema$.MODULE$.defaultIOSchema().copy$default$5();
        Seq x$6 = ScriptTransformationIOSchema$.MODULE$.defaultIOSchema().copy$default$6();
        Option x$7 = ScriptTransformationIOSchema$.MODULE$.defaultIOSchema().copy$default$7();
        Option x$8 = ScriptTransformationIOSchema$.MODULE$.defaultIOSchema().copy$default$8();
        boolean x$9 = ScriptTransformationIOSchema$.MODULE$.defaultIOSchema().copy$default$9();
        this.hiveIOSchema = ScriptTransformationIOSchema$.MODULE$.defaultIOSchema().copy(x$3, x$4, (Option)x$1, (Option)x$2, x$5, x$6, x$7, x$8, x$9);
        this.test("cat with LazySimpleSerDe", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestUtils$.MODULE$.testCommandAvailable("/bin/bash"), "org.apache.spark.TestUtils.testCommandAvailable(\"/bin/bash\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(HiveScriptTransformationSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator10$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator10$1(HiveScriptTransformationSuite $outer) {
                }
            }
            Dataset rowsDf = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})).map((Function1 & Serializable)_1 -> new Tuple1(_1)), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator10$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}));
            this.checkAnswer(rowsDf, (Function1 & Serializable)child -> {
                AttributeReference[] attributeReferenceArray = new AttributeReference[1];
                String x$10 = "a";
                StringType$ x$11 = StringType$.MODULE$;
                boolean x$12 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$13 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$14 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$11, x$12, x$13);
                Seq x$15 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$11, x$12, x$13);
                attributeReferenceArray[0] = new AttributeReference("a", (DataType)x$11, x$12, x$13, x$14, x$15);
                return this.createScriptTransformationExec("cat", (Seq<Attribute>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])attributeReferenceArray))), (SparkPlan)child, this.hiveIOSchema());
            }, (Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(rowsDf.collect()), this.checkAnswer$default$4());
            Option $org_scalatest_assert_macro_left = this.uncaughtExceptionHandler().exception();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        }, new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        this.test("script transformation should not swallow errors from upstream operators (hive serde)", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestUtils$.MODULE$.testCommandAvailable("/bin/bash"), "org.apache.spark.TestUtils.testCommandAvailable(\"/bin/bash\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(HiveScriptTransformationSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator20$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator20$1(HiveScriptTransformationSuite $outer) {
                }
            }
            Dataset rowsDf = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})).map((Function1 & Serializable)_1 -> new Tuple1(_1)), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator20$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}));
            TestFailedException e = (TestFailedException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.checkAnswer(rowsDf, (Function1 & Serializable)child -> {
                AttributeReference[] attributeReferenceArray = new AttributeReference[1];
                String x$16 = "a";
                StringType$ x$17 = StringType$.MODULE$;
                boolean x$18 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$19 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$20 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$17, x$18, x$19);
                Seq x$21 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$17, x$18, x$19);
                attributeReferenceArray[0] = new AttributeReference("a", (DataType)x$17, x$18, x$19, x$20, x$21);
                return this.createScriptTransformationExec("cat", (Seq<Attribute>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])attributeReferenceArray))), (SparkPlan)new ExceptionInjectingOperator(child), this.hiveIOSchema());
            }, (Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(rowsDf.collect()), this.checkAnswer$default$4()), ClassTag$.MODULE$.apply(TestFailedException.class), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "intentional exception";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            Option $org_scalatest_assert_macro_left2 = this.uncaughtExceptionHandler().exception();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        }, new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        this.test("SPARK-14400 script transformation should fail for bad script command (hive serde)", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestUtils$.MODULE$.testCommandAvailable("/bin/bash"), "org.apache.spark.TestUtils.testCommandAvailable(\"/bin/bash\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(HiveScriptTransformationSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator30$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator30$1(HiveScriptTransformationSuite $outer) {
                }
            }
            Dataset rowsDf = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})).map((Function1 & Serializable)_1 -> new Tuple1(_1)), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator30$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}));
            SparkException e = (SparkException)this.intercept((Function0 & Serializable)() -> {
                AttributeReference[] attributeReferenceArray = new AttributeReference[1];
                String x$22 = "a";
                StringType$ x$23 = StringType$.MODULE$;
                boolean x$24 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$25 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$26 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$23, x$24, x$25);
                Seq x$27 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$23, x$24, x$25);
                attributeReferenceArray[0] = new AttributeReference("a", (DataType)x$23, x$24, x$25, x$26, x$27);
                BaseScriptTransformationExec plan = this.createScriptTransformationExec("some_non_existent_command", (Seq<Attribute>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])attributeReferenceArray))), rowsDf.queryExecution().sparkPlan(), this.hiveIOSchema());
                return SparkPlanTest$.MODULE$.executePlan((SparkPlan)plan, (SQLContext)this.hiveContext());
            }, ClassTag$.MODULE$.apply(SparkException.class), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "Subprocess exited with status";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
            Option $org_scalatest_assert_macro_left2 = this.uncaughtExceptionHandler().exception();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        }, new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        this.test("SPARK-24339 verify the result after pruning the unused columns (hive serde)", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(HiveScriptTransformationSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator40$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator40$1(HiveScriptTransformationSuite $outer) {
                }
            }
            Dataset rowsDf = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"Bob", (Object)BoxesRunTime.boxToInteger((int)16), (Object)BoxesRunTime.boxToInteger((int)176)), new Tuple3((Object)"Alice", (Object)BoxesRunTime.boxToInteger((int)32), (Object)BoxesRunTime.boxToInteger((int)164)), new Tuple3((Object)"David", (Object)BoxesRunTime.boxToInteger((int)60), (Object)BoxesRunTime.boxToInteger((int)192)), new Tuple3((Object)"Amy", (Object)BoxesRunTime.boxToInteger((int)24), (Object)BoxesRunTime.boxToInteger((int)180))})), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator40$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name", "age", "height"}));
            this.checkAnswer(rowsDf, (Function1 & Serializable)child -> {
                AttributeReference[] attributeReferenceArray = new AttributeReference[1];
                String x$28 = "name";
                StringType$ x$29 = StringType$.MODULE$;
                boolean x$30 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$31 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$32 = AttributeReference$.MODULE$.apply$default$5("name", (DataType)x$29, x$30, x$31);
                Seq x$33 = AttributeReference$.MODULE$.apply$default$6("name", (DataType)x$29, x$30, x$31);
                attributeReferenceArray[0] = new AttributeReference("name", (DataType)x$29, x$30, x$31, x$32, x$33);
                return this.createScriptTransformationExec("cat", (Seq<Attribute>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])attributeReferenceArray))), (SparkPlan)child, this.hiveIOSchema());
            }, (Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(rowsDf.select("name", (Seq)Nil$.MODULE$).collect()), this.checkAnswer$default$4());
            Option $org_scalatest_assert_macro_left = this.uncaughtExceptionHandler().exception();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        }, new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        this.test("SPARK-30973: TRANSFORM should wait for the termination of the script (hive serde)", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestUtils$.MODULE$.testCommandAvailable("/bin/bash"), "org.apache.spark.TestUtils.testCommandAvailable(\"/bin/bash\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(HiveScriptTransformationSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator50$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator50$1(HiveScriptTransformationSuite $outer) {
                }
            }
            Dataset rowsDf = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})).map((Function1 & Serializable)_1 -> new Tuple1(_1)), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator50$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}));
            SparkException e = (SparkException)this.intercept((Function0 & Serializable)() -> {
                AttributeReference[] attributeReferenceArray = new AttributeReference[1];
                String x$34 = "a";
                StringType$ x$35 = StringType$.MODULE$;
                boolean x$36 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$37 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$38 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$35, x$36, x$37);
                Seq x$39 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$35, x$36, x$37);
                attributeReferenceArray[0] = new AttributeReference("a", (DataType)x$35, x$36, x$37, x$38, x$39);
                BaseScriptTransformationExec plan = this.createScriptTransformationExec("some_non_existent_command", (Seq<Attribute>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])attributeReferenceArray))), rowsDf.queryExecution().sparkPlan(), this.hiveIOSchema());
                return SparkPlanTest$.MODULE$.executePlan((SparkPlan)plan, (SQLContext)this.hiveContext());
            }, ClassTag$.MODULE$.apply(SparkException.class), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "Subprocess exited with status";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
            Option $org_scalatest_assert_macro_left2 = this.uncaughtExceptionHandler().exception();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        }, new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
        this.test("SPARK-32388: TRANSFORM should handle schema less correctly (hive serde)", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(HiveScriptTransformationSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator60$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.math.BigDecimal").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.sql.Timestamp").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
                }

                public Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator60$1(HiveScriptTransformationSuite $outer) {
                }
            }
            Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"1", (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)scala.package$.MODULE$.BigDecimal().apply(1.0), (Object)new Timestamp(1L)), new Tuple5((Object)BoxesRunTime.boxToInteger((int)2), (Object)"2", (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)scala.package$.MODULE$.BigDecimal().apply(2.0), (Object)new Timestamp(2L)), new Tuple5((Object)BoxesRunTime.boxToInteger((int)3), (Object)"3", (Object)BoxesRunTime.boxToDouble((double)3.0), (Object)scala.package$.MODULE$.BigDecimal().apply(3.0), (Object)new Timestamp(3L))})), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator60$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c", "d", "e"}));
            df.createTempView("v");
            this.checkAnswer((Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |SELECT TRANSFORM(a, b, c, d, e)\n             |  USING 'cat'\n             |FROM v\n        "))), (Function1 & Serializable)x -> (SparkPlan)Predef$.MODULE$.identity(x), (Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(df.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "a")).cast("string").as("key"), functions$.MODULE$.concat_ws("\t", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "b")).cast("string"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "c")).cast("string"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "d")).cast("string"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "e")).cast("string")})).as("value")})).collect()), this.checkAnswer$default$4());
            this.checkAnswer((Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |SELECT TRANSFORM(a, b, c, d, e)\n             |  ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe'\n             |  WITH SERDEPROPERTIES (\n             |    'field.delim' = '\t'\n             |  )\n             |  USING 'cat'\n             |  ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe'\n             |  WITH SERDEPROPERTIES (\n             |    'field.delim' = '\t'\n             |  )\n             |FROM v\n        "))), (Function1 & Serializable)x -> (SparkPlan)Predef$.MODULE$.identity(x), (Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(df.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "a")).cast("string").as("key"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "b")).cast("string").as("value")})).collect()), this.checkAnswer$default$4());
            this.checkAnswer((Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |SELECT TRANSFORM(a, b, c, d, e)\n             |  ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe'\n             |  WITH SERDEPROPERTIES (\n             |    'field.delim' = '\t',\n             |    'serialization.last.column.takes.rest' = 'true'\n             |  )\n             |  USING 'cat'\n             |  ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe'\n             |  WITH SERDEPROPERTIES (\n             |    'field.delim' = '\t',\n             |    'serialization.last.column.takes.rest' = 'true'\n             |  )\n             |FROM v\n        "))), (Function1 & Serializable)x -> (SparkPlan)Predef$.MODULE$.identity(x), (Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(df.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "a")).cast("string").as("key"), functions$.MODULE$.concat_ws("\t", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "b")).cast("string"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "c")).cast("string"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "d")).cast("string"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "e")).cast("string")})).as("value")})).collect()), this.checkAnswer$default$4());
            this.checkAnswer((Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |SELECT TRANSFORM(a, b, c, d, e)\n             |  ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe'\n             |  WITH SERDEPROPERTIES (\n             |    'field.delim' = '\t',\n             |    'serialization.last.column.takes.rest' = 'false'\n             |  )\n             |  USING 'cat'\n             |  ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe'\n             |  WITH SERDEPROPERTIES (\n             |    'field.delim' = '\t',\n             |    'serialization.last.column.takes.rest' = 'false'\n             |  )\n             |FROM v\n        "))), (Function1 & Serializable)x -> (SparkPlan)Predef$.MODULE$.identity(x), (Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(df.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "a")).cast("string").as("key"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "b")).cast("string").as("value")})).collect()), this.checkAnswer$default$4());
            this.checkAnswer((Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |SELECT TRANSFORM(a, b)\n             |  ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe'\n             |  WITH SERDEPROPERTIES (\n             |    'field.delim' = '\t',\n             |    'serialization.last.column.takes.rest' = 'true'\n             |  )\n             |  USING 'cat'\n             |  ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe'\n             |  WITH SERDEPROPERTIES (\n             |    'field.delim' = '\t',\n             |    'serialization.last.column.takes.rest' = 'true'\n             |  )\n             |FROM v\n        "))), (Function1 & Serializable)x -> (SparkPlan)Predef$.MODULE$.identity(x), (Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(df.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "a")).cast("string").as("key"), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "b")).cast("string").as("value")})).collect()), this.checkAnswer$default$4());
            this.checkAnswer((Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |SELECT TRANSFORM(a)\n             |  ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe'\n             |  WITH SERDEPROPERTIES (\n             |    'field.delim' = '\t',\n             |    'serialization.last.column.takes.rest' = 'true'\n             |  )\n             |  USING 'cat'\n             |  ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe'\n             |  WITH SERDEPROPERTIES (\n             |    'field.delim' = '\t',\n             |    'serialization.last.column.takes.rest' = 'true'\n             |  )\n             |FROM v\n        "))), (Function1 & Serializable)x -> (SparkPlan)Predef$.MODULE$.identity(x), (Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(df.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "a")).cast("string").as("key"), functions$.MODULE$.lit(null)})).collect()), this.checkAnswer$default$4());
        }), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        this.testBasicInputDataTypesWith(this.hiveIOSchema(), "hive serde");
        this.test("SPARK-32400: TRANSFORM supports complex data types type (hive serde)", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestUtils$.MODULE$.testCommandAvailable("/bin/bash"), "org.apache.spark.TestUtils.testCommandAvailable(\"/bin/bash\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325));
            this.withTempView((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(HiveScriptTransformationSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator70$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Map"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)))));
                    }

                    public Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator70$1(HiveScriptTransformationSuite $outer) {
                    }
                }
                Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)"1", (Object)new int[]{0, 1, 2}, Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1))}))), new Tuple4((Object)BoxesRunTime.boxToInteger((int)2), (Object)"2", (Object)new int[]{3, 4, 5}, Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)2))})))})), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator70$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c", "d"})).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "a")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "b")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "c")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "d")), functions$.MODULE$.struct((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "a")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "b"))})).as("e")}));
                df.createTempView("v");
                this.checkAnswer(df.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "c")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "d")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "e"))})), (Function1 & Serializable)child -> {
                    AttributeReference[] attributeReferenceArray = new AttributeReference[3];
                    String x$40 = "c";
                    ArrayType x$41 = ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$);
                    boolean x$42 = AttributeReference$.MODULE$.apply$default$3();
                    Metadata x$43 = AttributeReference$.MODULE$.apply$default$4();
                    ExprId x$44 = AttributeReference$.MODULE$.apply$default$5("c", (DataType)x$41, x$42, x$43);
                    Seq x$45 = AttributeReference$.MODULE$.apply$default$6("c", (DataType)x$41, x$42, x$43);
                    attributeReferenceArray[0] = new AttributeReference("c", (DataType)x$41, x$42, x$43, x$44, x$45);
                    String x$46 = "d";
                    MapType x$47 = MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$);
                    boolean x$48 = AttributeReference$.MODULE$.apply$default$3();
                    Metadata x$49 = AttributeReference$.MODULE$.apply$default$4();
                    ExprId x$50 = AttributeReference$.MODULE$.apply$default$5("d", (DataType)x$47, x$48, x$49);
                    Seq x$51 = AttributeReference$.MODULE$.apply$default$6("d", (DataType)x$47, x$48, x$49);
                    attributeReferenceArray[1] = new AttributeReference("d", (DataType)x$47, x$48, x$49, x$50, x$51);
                    String x$52 = "e";
                    StructType x$53 = StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("col1", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("col2", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4())})));
                    boolean x$54 = AttributeReference$.MODULE$.apply$default$3();
                    Metadata x$55 = AttributeReference$.MODULE$.apply$default$4();
                    ExprId x$56 = AttributeReference$.MODULE$.apply$default$5("e", (DataType)x$53, x$54, x$55);
                    Seq x$57 = AttributeReference$.MODULE$.apply$default$6("e", (DataType)x$53, x$54, x$55);
                    attributeReferenceArray[2] = new AttributeReference("e", (DataType)x$53, x$54, x$55, x$56, x$57);
                    return this.createScriptTransformationExec("cat", (Seq<Attribute>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])attributeReferenceArray))), (SparkPlan)child, this.hiveIOSchema());
                }, (Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(df.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "c")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "d")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "e"))})).collect()), this.checkAnswer$default$4());
            });
        }, new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
        this.test("SPARK-32400: TRANSFORM supports complex data types end to end (hive serde)", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestUtils$.MODULE$.testCommandAvailable("/bin/bash"), "org.apache.spark.TestUtils.testCommandAvailable(\"/bin/bash\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
            this.withTempView((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(HiveScriptTransformationSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator80$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Map"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)))));
                    }

                    public Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator80$1(HiveScriptTransformationSuite $outer) {
                    }
                }
                Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)"1", (Object)new int[]{0, 1, 2}, Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1))}))), new Tuple4((Object)BoxesRunTime.boxToInteger((int)2), (Object)"2", (Object)new int[]{3, 4, 5}, Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)2))})))})), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator80$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c", "d"})).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "a")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "b")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "c")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "d")), functions$.MODULE$.struct((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "a")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "b"))})).as("e")}));
                df.createTempView("v");
                Dataset query = (Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |SELECT TRANSFORM (c, d, e)\n          |USING 'cat' AS (c array<int>, d map<string, int>, e struct<col1:int, col2:string>)\n          |FROM v\n        ")));
                this.checkAnswer(query, (Function1 & Serializable)x -> (SparkPlan)Predef$.MODULE$.identity(x), (Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(df.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "c")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "d")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "e"))})).collect()), this.checkAnswer$default$4());
            });
        }, new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
        this.test("SPARK-32400: TRANSFORM doesn't support CalendarIntervalType/UserDefinedType (hive serde)", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestUtils$.MODULE$.testCommandAvailable("/bin/bash"), "org.apache.spark.TestUtils.testCommandAvailable(\"/bin/bash\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 375));
            this.withTempView((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                String e2;
                String e1;
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(HiveScriptTransformationSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator90$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.unsafe.types.CalendarInterval").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("org.apache.spark.sql.types").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("org.apache.spark.sql.types.TestUDT")), (Symbols.SymbolApi)$m.staticClass("org.apache.spark.sql.types.TestUDT.MyDenseVector"), (List)Nil$.MODULE$), (List)Nil$.MODULE$))));
                    }

                    public Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator90$1(HiveScriptTransformationSuite $outer) {
                    }
                }
                Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)new CalendarInterval(7, 1, 1000L), (Object)new TestUDT.MyDenseVector(new double[]{1.0, 2.0, 3.0})), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)new CalendarInterval(7, 1, 1000L), (Object)new TestUDT.MyDenseVector(new double[]{1.0, 2.0, 3.0}))})), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator90$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}));
                df.createTempView("v");
                String $org_scalatest_assert_macro_left = e1 = ((Throwable)this.intercept((Function0 & Serializable)() -> {
                    AttributeReference[] attributeReferenceArray = new AttributeReference[2];
                    String x$58 = "a";
                    IntegerType$ x$59 = IntegerType$.MODULE$;
                    boolean x$60 = AttributeReference$.MODULE$.apply$default$3();
                    Metadata x$61 = AttributeReference$.MODULE$.apply$default$4();
                    ExprId x$62 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$59, x$60, x$61);
                    Seq x$63 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$59, x$60, x$61);
                    attributeReferenceArray[0] = new AttributeReference("a", (DataType)x$59, x$60, x$61, x$62, x$63);
                    String x$64 = "b";
                    CalendarIntervalType$ x$65 = CalendarIntervalType$.MODULE$;
                    boolean x$66 = AttributeReference$.MODULE$.apply$default$3();
                    Metadata x$67 = AttributeReference$.MODULE$.apply$default$4();
                    ExprId x$68 = AttributeReference$.MODULE$.apply$default$5("b", (DataType)x$65, x$66, x$67);
                    Seq x$69 = AttributeReference$.MODULE$.apply$default$6("b", (DataType)x$65, x$66, x$67);
                    attributeReferenceArray[1] = new AttributeReference("b", (DataType)x$65, x$66, x$67, x$68, x$69);
                    BaseScriptTransformationExec plan = this.createScriptTransformationExec("cat", (Seq<Attribute>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])attributeReferenceArray))), df.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "a")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "b"))})).queryExecution().sparkPlan(), this.hiveIOSchema());
                    return SparkPlanTest$.MODULE$.executePlan((SparkPlan)plan, (SQLContext)this.hiveContext());
                }, ClassTag$.MODULE$.apply(SparkException.class), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383))).getMessage();
                String $org_scalatest_assert_macro_right = "interval cannot be converted to Hive TypeInfo";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393));
                String $org_scalatest_assert_macro_left2 = e2 = ((Throwable)this.intercept((Function0 & Serializable)() -> {
                    AttributeReference[] attributeReferenceArray = new AttributeReference[2];
                    String x$70 = "a";
                    IntegerType$ x$71 = IntegerType$.MODULE$;
                    boolean x$72 = AttributeReference$.MODULE$.apply$default$3();
                    Metadata x$73 = AttributeReference$.MODULE$.apply$default$4();
                    ExprId x$74 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$71, x$72, x$73);
                    Seq x$75 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$71, x$72, x$73);
                    attributeReferenceArray[0] = new AttributeReference("a", (DataType)x$71, x$72, x$73, x$74, x$75);
                    String x$76 = "c";
                    TestUDT.MyDenseVectorUDT x$77 = new TestUDT.MyDenseVectorUDT();
                    boolean x$78 = AttributeReference$.MODULE$.apply$default$3();
                    Metadata x$79 = AttributeReference$.MODULE$.apply$default$4();
                    ExprId x$80 = AttributeReference$.MODULE$.apply$default$5("c", (DataType)x$77, x$78, x$79);
                    Seq x$81 = AttributeReference$.MODULE$.apply$default$6("c", (DataType)x$77, x$78, x$79);
                    attributeReferenceArray[1] = new AttributeReference("c", (DataType)x$77, x$78, x$79, x$80, x$81);
                    BaseScriptTransformationExec plan = this.createScriptTransformationExec("cat", (Seq<Attribute>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])attributeReferenceArray))), df.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "a")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).queryExecution().sparkPlan(), this.hiveIOSchema());
                    return SparkPlanTest$.MODULE$.executePlan((SparkPlan)plan, (SQLContext)this.hiveContext());
                }, ClassTag$.MODULE$.apply(SparkException.class), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395))).getMessage();
                String $org_scalatest_assert_macro_right2 = "array<double> cannot be converted to Hive TypeInfo";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 405));
            });
        }, new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
        this.test("SPARK-32400: TRANSFORM doesn't support CalendarIntervalType/UserDefinedType end to end (hive serde)", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestUtils$.MODULE$.testCommandAvailable("/bin/bash"), "org.apache.spark.TestUtils.testCommandAvailable(\"/bin/bash\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 411));
            this.withTempView((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                String e2;
                String e1;
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(HiveScriptTransformationSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator100$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.unsafe.types.CalendarInterval").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("org.apache.spark.sql.types").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("org.apache.spark.sql.types.TestUDT")), (Symbols.SymbolApi)$m.staticClass("org.apache.spark.sql.types.TestUDT.MyDenseVector"), (List)Nil$.MODULE$), (List)Nil$.MODULE$))));
                    }

                    public Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator100$1(HiveScriptTransformationSuite $outer) {
                    }
                }
                Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)new CalendarInterval(7, 1, 1000L), (Object)new TestUDT.MyDenseVector(new double[]{1.0, 2.0, 3.0})), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)new CalendarInterval(7, 1, 1000L), (Object)new TestUDT.MyDenseVector(new double[]{1.0, 2.0, 3.0}))})), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveScriptTransformationSuite$$typecreator100$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}));
                df.createTempView("v");
                String $org_scalatest_assert_macro_left = e1 = ((Throwable)this.intercept((Function0 & Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n            |SELECT TRANSFORM(a, b) USING 'cat' AS (a, b)\n            |FROM v\n          ")))).collect(), ClassTag$.MODULE$.apply(SparkException.class), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419))).getMessage();
                String $org_scalatest_assert_macro_right = "interval cannot be converted to Hive TypeInfo";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 426));
                String $org_scalatest_assert_macro_left2 = e2 = ((Throwable)this.intercept((Function0 & Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n            |SELECT TRANSFORM(a, c) USING 'cat' AS (a, c)\n            |FROM v\n          ")))).collect(), ClassTag$.MODULE$.apply(SparkException.class), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 428))).getMessage();
                String $org_scalatest_assert_macro_right2 = "array<double> cannot be converted to Hive TypeInfo";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
            });
        }, new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 410));
        this.test("SPARK-32685: When use specified serde, filed.delim's default value is '\t'", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Dataset query1 = (Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |SELECT split(value, \"\\t\") FROM (\n        |SELECT TRANSFORM(a, b, c)\n        |USING 'cat'\n        |FROM (SELECT 1 AS a, 2 AS b, 3 AS c) t\n        |) temp;\n      ")));
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"2", "3"}))}));
            this.checkAnswer(query1, (Function1 & Serializable)x -> (SparkPlan)Predef$.MODULE$.identity(x), (Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)row), this.checkAnswer$default$4());
            Dataset query2 = (Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |SELECT split(value, \"\\t\") FROM (\n        |SELECT TRANSFORM(a, b, c)\n        |  ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe'\n        |USING 'cat'\n        |  ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe'\n        |  WITH SERDEPROPERTIES (\n        |   'serialization.last.column.takes.rest' = 'true'\n        |  )\n        |FROM (SELECT 1 AS a, 2 AS b, 3 AS c) t\n        |) temp;\n      ")));
            Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"2", "3"}))}));
            this.checkAnswer(query2, (Function1 & Serializable)x -> (SparkPlan)Predef$.MODULE$.identity(x), (Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)row2), this.checkAnswer$default$4());
            Dataset query3 = (Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |SELECT split(value, \"&\") FROM (\n        |SELECT TRANSFORM(a, b, c)\n        |  ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe'\n        |  WITH SERDEPROPERTIES (\n        |   'field.delim' = '&'\n        |  )\n        |USING 'cat'\n        |  ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe'\n        |  WITH SERDEPROPERTIES (\n        |   'serialization.last.column.takes.rest' = 'true',\n        |   'field.delim' = '&'\n        |  )\n        |FROM (SELECT 1 AS a, 2 AS b, 3 AS c) t\n        |) temp;\n      ")));
            Row row3 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"2", "3"}))}));
            this.checkAnswer(query3, (Function1 & Serializable)x -> (SparkPlan)Predef$.MODULE$.identity(x), (Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)row3), this.checkAnswer$default$4());
            Dataset query4 = (Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |SELECT split(value, \"&\") FROM (\n        |SELECT TRANSFORM(a, b, c)\n        |  ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe'\n        |USING 'cat'\n        |  ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe'\n        |  WITH SERDEPROPERTIES (\n        |   'serialization.last.column.takes.rest' = 'true',\n        |   'field.delim' = '&'\n        |  )\n        |FROM (SELECT 1 AS a, 2 AS b, 3 AS c) t\n        |) temp;\n      ")));
            Row row4 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null}));
            this.checkAnswer(query4, (Function1 & Serializable)x -> (SparkPlan)Predef$.MODULE$.identity(x), (Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)row4), this.checkAnswer$default$4());
        }, new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439));
        this.test("SPARK-32684: Script transform hive serde mode null format is same with hive as '\\N'", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Dataset query1 = (Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |SELECT TRANSFORM(null, null, null)\n        |USING 'cat'\n        |FROM (SELECT 1 AS a) t\n      ")));
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null, "\\N\t\\N"}));
            this.checkAnswer(query1, (Function1 & Serializable)x -> (SparkPlan)Predef$.MODULE$.identity(x), (Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)row), this.checkAnswer$default$4());
            Dataset query2 = (Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |SELECT TRANSFORM(null, null, null)\n        |  ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe'\n        |  WITH SERDEPROPERTIES (\n        |   'field.delim' = ','\n        |  )\n        |USING 'cat' AS (a)\n        |  ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe'\n        |  WITH SERDEPROPERTIES (\n        |   'field.delim' = '&'\n        |  )\n        |FROM (SELECT 1 AS a) t\n      ")));
            Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"\\N,\\N,\\N"}));
            this.checkAnswer(query2, (Function1 & Serializable)x -> (SparkPlan)Predef$.MODULE$.identity(x), (Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)row2), this.checkAnswer$default$4());
        }, new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501));
        this.test("SPARK-34879, SPARK-35733: HiveInspectors supports all type of DayTimeIntervalType", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestUtils$.MODULE$.testCommandAvailable("/bin/bash"), "org.apache.spark.TestUtils.testCommandAvailable(\"/bin/bash\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 529));
            this.withTempView((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                StructType schema = StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.DAY()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.HOUR()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("c", (DataType)new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.MINUTE()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("d", (DataType)new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("e", (DataType)DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.HOUR()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("f", (DataType)new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.MINUTE()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("g", (DataType)new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.SECOND()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("h", (DataType)DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.MINUTE()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("i", (DataType)new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.MINUTE(), DayTimeIntervalType$.MODULE$.SECOND()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("j", (DataType)DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.SECOND()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
                SparkContext qual$1 = this.sparkContext();
                Seq x$82 = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Duration.ofDays(1L), Duration.ofHours(11L), Duration.ofMinutes(1L), Duration.ofSeconds(100L).plusNanos(123456L), Duration.of(Long.MAX_VALUE, ChronoUnit.MICROS), Duration.ofDays(1L), Duration.ofHours(11L), Duration.ofMinutes(1L), Duration.ofSeconds(100L).plusNanos(123456L), Duration.ofSeconds(9223372036854L)}))}));
                int x$83 = qual$1.parallelize$default$2();
                Dataset df = this.spark().createDataFrame(qual$1.parallelize(x$82, x$83, ClassTag$.MODULE$.apply(Row.class)), schema);
                this.checkAnswer(df, (Function1 & Serializable)child -> {
                    AttributeReference[] attributeReferenceArray = new AttributeReference[10];
                    String x$84 = "a";
                    DayTimeIntervalType x$85 = DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.DAY());
                    boolean x$86 = AttributeReference$.MODULE$.apply$default$3();
                    Metadata x$87 = AttributeReference$.MODULE$.apply$default$4();
                    ExprId x$88 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$85, x$86, x$87);
                    Seq x$89 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$85, x$86, x$87);
                    attributeReferenceArray[0] = new AttributeReference("a", (DataType)x$85, x$86, x$87, x$88, x$89);
                    String x$90 = "b";
                    DayTimeIntervalType x$91 = new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.HOUR());
                    boolean x$92 = AttributeReference$.MODULE$.apply$default$3();
                    Metadata x$93 = AttributeReference$.MODULE$.apply$default$4();
                    ExprId x$94 = AttributeReference$.MODULE$.apply$default$5("b", (DataType)x$91, x$92, x$93);
                    Seq x$95 = AttributeReference$.MODULE$.apply$default$6("b", (DataType)x$91, x$92, x$93);
                    attributeReferenceArray[1] = new AttributeReference("b", (DataType)x$91, x$92, x$93, x$94, x$95);
                    String x$96 = "c";
                    DayTimeIntervalType x$97 = new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.MINUTE());
                    boolean x$98 = AttributeReference$.MODULE$.apply$default$3();
                    Metadata x$99 = AttributeReference$.MODULE$.apply$default$4();
                    ExprId x$100 = AttributeReference$.MODULE$.apply$default$5("c", (DataType)x$97, x$98, x$99);
                    Seq x$101 = AttributeReference$.MODULE$.apply$default$6("c", (DataType)x$97, x$98, x$99);
                    attributeReferenceArray[2] = new AttributeReference("c", (DataType)x$97, x$98, x$99, x$100, x$101);
                    String x$102 = "d";
                    DayTimeIntervalType x$103 = new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND());
                    boolean x$104 = AttributeReference$.MODULE$.apply$default$3();
                    Metadata x$105 = AttributeReference$.MODULE$.apply$default$4();
                    ExprId x$106 = AttributeReference$.MODULE$.apply$default$5("d", (DataType)x$103, x$104, x$105);
                    Seq x$107 = AttributeReference$.MODULE$.apply$default$6("d", (DataType)x$103, x$104, x$105);
                    attributeReferenceArray[3] = new AttributeReference("d", (DataType)x$103, x$104, x$105, x$106, x$107);
                    String x$108 = "e";
                    DayTimeIntervalType x$109 = DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.HOUR());
                    boolean x$110 = AttributeReference$.MODULE$.apply$default$3();
                    Metadata x$111 = AttributeReference$.MODULE$.apply$default$4();
                    ExprId x$112 = AttributeReference$.MODULE$.apply$default$5("e", (DataType)x$109, x$110, x$111);
                    Seq x$113 = AttributeReference$.MODULE$.apply$default$6("e", (DataType)x$109, x$110, x$111);
                    attributeReferenceArray[4] = new AttributeReference("e", (DataType)x$109, x$110, x$111, x$112, x$113);
                    String x$114 = "f";
                    DayTimeIntervalType x$115 = new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.MINUTE());
                    boolean x$116 = AttributeReference$.MODULE$.apply$default$3();
                    Metadata x$117 = AttributeReference$.MODULE$.apply$default$4();
                    ExprId x$118 = AttributeReference$.MODULE$.apply$default$5("f", (DataType)x$115, x$116, x$117);
                    Seq x$119 = AttributeReference$.MODULE$.apply$default$6("f", (DataType)x$115, x$116, x$117);
                    attributeReferenceArray[5] = new AttributeReference("f", (DataType)x$115, x$116, x$117, x$118, x$119);
                    String x$120 = "g";
                    DayTimeIntervalType x$121 = new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.SECOND());
                    boolean x$122 = AttributeReference$.MODULE$.apply$default$3();
                    Metadata x$123 = AttributeReference$.MODULE$.apply$default$4();
                    ExprId x$124 = AttributeReference$.MODULE$.apply$default$5("g", (DataType)x$121, x$122, x$123);
                    Seq x$125 = AttributeReference$.MODULE$.apply$default$6("g", (DataType)x$121, x$122, x$123);
                    attributeReferenceArray[6] = new AttributeReference("g", (DataType)x$121, x$122, x$123, x$124, x$125);
                    String x$126 = "h";
                    DayTimeIntervalType x$127 = DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.MINUTE());
                    boolean x$128 = AttributeReference$.MODULE$.apply$default$3();
                    Metadata x$129 = AttributeReference$.MODULE$.apply$default$4();
                    ExprId x$130 = AttributeReference$.MODULE$.apply$default$5("h", (DataType)x$127, x$128, x$129);
                    Seq x$131 = AttributeReference$.MODULE$.apply$default$6("h", (DataType)x$127, x$128, x$129);
                    attributeReferenceArray[7] = new AttributeReference("h", (DataType)x$127, x$128, x$129, x$130, x$131);
                    String x$132 = "i";
                    DayTimeIntervalType x$133 = new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.MINUTE(), DayTimeIntervalType$.MODULE$.SECOND());
                    boolean x$134 = AttributeReference$.MODULE$.apply$default$3();
                    Metadata x$135 = AttributeReference$.MODULE$.apply$default$4();
                    ExprId x$136 = AttributeReference$.MODULE$.apply$default$5("i", (DataType)x$133, x$134, x$135);
                    Seq x$137 = AttributeReference$.MODULE$.apply$default$6("i", (DataType)x$133, x$134, x$135);
                    attributeReferenceArray[8] = new AttributeReference("i", (DataType)x$133, x$134, x$135, x$136, x$137);
                    String x$138 = "j";
                    DayTimeIntervalType x$139 = DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.SECOND());
                    boolean x$140 = AttributeReference$.MODULE$.apply$default$3();
                    Metadata x$141 = AttributeReference$.MODULE$.apply$default$4();
                    ExprId x$142 = AttributeReference$.MODULE$.apply$default$5("j", (DataType)x$139, x$140, x$141);
                    Seq x$143 = AttributeReference$.MODULE$.apply$default$6("j", (DataType)x$139, x$140, x$141);
                    attributeReferenceArray[9] = new AttributeReference("j", (DataType)x$139, x$140, x$141, x$142, x$143);
                    return this.createScriptTransformationExec("cat", (Seq<Attribute>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])attributeReferenceArray))), (SparkPlan)child, this.hiveIOSchema());
                }, (Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(df.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$), this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$), this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"f"}))).$((Seq)Nil$.MODULE$), this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"g"}))).$((Seq)Nil$.MODULE$), this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"h"}))).$((Seq)Nil$.MODULE$), this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"i"}))).$((Seq)Nil$.MODULE$), this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"j"}))).$((Seq)Nil$.MODULE$)})).collect()), this.checkAnswer$default$4());
            });
        }, new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 528));
        this.test("SPARK-34879, SPARK-35722: HiveInspectors supports all type of YearMonthIntervalType", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestUtils$.MODULE$.testCommandAvailable("/bin/bash"), "org.apache.spark.TestUtils.testCommandAvailable(\"/bin/bash\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 579));
            this.withTempView((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                StructType schema = StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)YearMonthIntervalType$.MODULE$.apply(YearMonthIntervalType$.MODULE$.YEAR()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)new YearMonthIntervalType(YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("c", (DataType)YearMonthIntervalType$.MODULE$.apply(YearMonthIntervalType$.MODULE$.MONTH()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
                SparkContext qual$2 = this.sparkContext();
                Seq x$144 = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Period.ofMonths(13), Period.ofMonths(13), Period.ofMonths(13)}))}));
                int x$145 = qual$2.parallelize$default$2();
                Dataset df = this.spark().createDataFrame(qual$2.parallelize(x$144, x$145, ClassTag$.MODULE$.apply(Row.class)), schema);
                this.checkAnswer(df, (Function1 & Serializable)child -> {
                    AttributeReference[] attributeReferenceArray = new AttributeReference[3];
                    String x$146 = "a";
                    YearMonthIntervalType x$147 = YearMonthIntervalType$.MODULE$.apply(YearMonthIntervalType$.MODULE$.YEAR());
                    boolean x$148 = AttributeReference$.MODULE$.apply$default$3();
                    Metadata x$149 = AttributeReference$.MODULE$.apply$default$4();
                    ExprId x$150 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$147, x$148, x$149);
                    Seq x$151 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$147, x$148, x$149);
                    attributeReferenceArray[0] = new AttributeReference("a", (DataType)x$147, x$148, x$149, x$150, x$151);
                    String x$152 = "b";
                    YearMonthIntervalType x$153 = new YearMonthIntervalType(YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH());
                    boolean x$154 = AttributeReference$.MODULE$.apply$default$3();
                    Metadata x$155 = AttributeReference$.MODULE$.apply$default$4();
                    ExprId x$156 = AttributeReference$.MODULE$.apply$default$5("b", (DataType)x$153, x$154, x$155);
                    Seq x$157 = AttributeReference$.MODULE$.apply$default$6("b", (DataType)x$153, x$154, x$155);
                    attributeReferenceArray[1] = new AttributeReference("b", (DataType)x$153, x$154, x$155, x$156, x$157);
                    String x$158 = "c";
                    YearMonthIntervalType x$159 = YearMonthIntervalType$.MODULE$.apply(YearMonthIntervalType$.MODULE$.MONTH());
                    boolean x$160 = AttributeReference$.MODULE$.apply$default$3();
                    Metadata x$161 = AttributeReference$.MODULE$.apply$default$4();
                    ExprId x$162 = AttributeReference$.MODULE$.apply$default$5("c", (DataType)x$159, x$160, x$161);
                    Seq x$163 = AttributeReference$.MODULE$.apply$default$6("c", (DataType)x$159, x$160, x$161);
                    attributeReferenceArray[2] = new AttributeReference("c", (DataType)x$159, x$160, x$161, x$162, x$163);
                    return this.createScriptTransformationExec("cat", (Seq<Attribute>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])attributeReferenceArray))), (SparkPlan)child, this.hiveIOSchema());
                }, (Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(df.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)})).collect()), this.checkAnswer$default$4());
            });
        }, new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 578));
        this.test("SPARK-34879: HiveInspectors throw overflow when HiveIntervalDayTime overflow then DayTimeIntervalType", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String e;
            Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"579025220 15:30:06.000001000"})), this.testImplicits().newStringEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}));
            df.createTempView("v");
            String $org_scalatest_assert_macro_left = e = ((Throwable)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.checkAnswer(df, (Function1 & Serializable)child -> {
                AttributeReference[] attributeReferenceArray = new AttributeReference[1];
                String x$164 = "a";
                DayTimeIntervalType x$165 = DayTimeIntervalType$.MODULE$.apply();
                boolean x$166 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$167 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$168 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$165, x$166, x$167);
                Seq x$169 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$165, x$166, x$167);
                attributeReferenceArray[0] = new AttributeReference("a", (DataType)x$165, x$166, x$167, x$168, x$169);
                return this.createScriptTransformationExec("cat", (Seq<Attribute>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])attributeReferenceArray))), (SparkPlan)child, this.hiveIOSchema());
            }, (Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(df.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)})).collect()), this.checkAnswer$default$4()), ClassTag$.MODULE$.apply(Exception.class), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 611))).getMessage();
            String $org_scalatest_assert_macro_right = "java.lang.ArithmeticException: long overflow";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 621));
        }), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 606));
        this.test("SPARK-38075: ORDER BY with LIMIT should not add fake rows", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), this.testImplicits().newIntEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}));
            df.createTempView("v");
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1"}));
            Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"2"}));
            Row row3 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"3"}));
            this.checkAnswer((Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |SELECT TRANSFORM(a)\n          |  USING 'cat' AS (a)\n          |FROM v\n          |ORDER BY a\n          |LIMIT 10\n          |"))), (Function1 & Serializable)x -> (SparkPlan)Predef$.MODULE$.identity(x), (Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row), this.checkAnswer$default$4());
        }), new Position("HiveScriptTransformationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 625));
        Statics.releaseFence();
    }
}

