/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.hive.test.TestHive$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class InsertIntoHiveTableBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark {
    public static final InsertIntoHiveTableBenchmark$ MODULE$ = new InsertIntoHiveTableBenchmark$();
    private static final String tempView;
    private static final int numRows;
    private static final Function1<String, Dataset<Row>> sql;
    private static final Configuration hadoopConf;
    private static SparkSession spark;
    private static String sparkHome;
    private static volatile boolean bitmap$0;

    static {
        SQLHelper.$init$((SQLHelper)MODULE$);
        SqlBasedBenchmark.$init$((SqlBasedBenchmark)MODULE$);
        tempView = "temp";
        numRows = 10240;
        sql = (Function1 & Serializable)sqlText -> MODULE$.spark().sql(sqlText);
        hadoopConf = MODULE$.spark().sparkContext().hadoopConfiguration();
        MODULE$.hadoopConf().set("hive.exec.dynamic.partition", "true");
        MODULE$.hadoopConf().set("hive.exec.dynamic.partition.mode", "nonstrict");
        MODULE$.hadoopConf().set("hive.exec.max.dynamic.partitions", Integer.toString(MODULE$.numRows()));
    }

    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$((SqlBasedBenchmark)this, (String)name, (long)cardinality, f);
    }

    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$((SqlBasedBenchmark)this, ds);
    }

    public void prepareDataInfo(Benchmark benchmark) {
        SqlBasedBenchmark.prepareDataInfo$((SqlBasedBenchmark)this, (Benchmark)benchmark);
    }

    public StructType writeWideRow(String path, int rowsNum, int numCols) {
        return SqlBasedBenchmark.writeWideRow$((SqlBasedBenchmark)this, (String)path, (int)rowsNum, (int)numCols);
    }

    public void afterAll() {
        SqlBasedBenchmark.afterAll$((SqlBasedBenchmark)this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    public SparkSession spark() {
        return spark;
    }

    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        spark = x$1;
    }

    private String sparkHome$lzycompute() {
        InsertIntoHiveTableBenchmark$ insertIntoHiveTableBenchmark$ = this;
        synchronized (insertIntoHiveTableBenchmark$) {
            if (!bitmap$0) {
                sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                bitmap$0 = true;
            }
        }
        return sparkHome;
    }

    public String sparkHome() {
        return !bitmap$0 ? this.sparkHome$lzycompute() : sparkHome;
    }

    public SparkSession getSparkSession() {
        return TestHive$.MODULE$.sparkSession();
    }

    public String tempView() {
        return tempView;
    }

    public int numRows() {
        return numRows;
    }

    public Function1<String, Dataset<Row>> sql() {
        return sql;
    }

    private Configuration hadoopConf() {
        return hadoopConf;
    }

    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        tableNames.foreach((Function1 & Serializable)name -> (Dataset)MODULE$.sql().apply((Object)new StringBuilder(69).append("CREATE TABLE ").append((String)name).append("(a INT) STORED AS TEXTFILE PARTITIONED BY (b INT, c INT)").toString()));
        try {
            f.apply$mcV$sp();
        }
        finally {
            tableNames.foreach((Function1 & Serializable)name -> MODULE$.spark().sql(new StringBuilder(21).append("DROP TABLE IF EXISTS ").append((String)name).toString()));
        }
    }

    public void insertOverwriteDynamic(String table, Benchmark benchmark) {
        benchmark.addCase("INSERT OVERWRITE DYNAMIC", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> MODULE$.sql().apply((Object)new StringBuilder(0).append(new StringBuilder(52).append("INSERT OVERWRITE TABLE ").append(table).append(" SELECT CAST(id AS INT) AS a,").toString()).append(new StringBuilder(60).append(" CAST(id % 10 AS INT) AS b, CAST(id % 100 AS INT) AS c FROM ").append(MODULE$.tempView()).toString()).toString()));
    }

    public void insertOverwriteHybrid(String table, Benchmark benchmark) {
        benchmark.addCase("INSERT OVERWRITE HYBRID", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> MODULE$.sql().apply((Object)new StringBuilder(0).append(new StringBuilder(70).append("INSERT OVERWRITE TABLE ").append(table).append(" partition(b=1, c) SELECT CAST(id AS INT) AS a,").toString()).append(new StringBuilder(32).append(" CAST(id % 10 AS INT) AS c FROM ").append(MODULE$.tempView()).toString()).toString()));
    }

    public void insertOverwriteStatic(String table, Benchmark benchmark) {
        benchmark.addCase("INSERT OVERWRITE STATIC", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> MODULE$.sql().apply((Object)new StringBuilder(0).append(new StringBuilder(72).append("INSERT OVERWRITE TABLE ").append(table).append(" partition(b=1, c=10) SELECT CAST(id AS INT) AS a").toString()).append(new StringBuilder(6).append(" FROM ").append(MODULE$.tempView()).toString()).toString()));
    }

    public void insertIntoDynamic(String table, Benchmark benchmark) {
        benchmark.addCase("INSERT INTO DYNAMIC", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> MODULE$.sql().apply((Object)new StringBuilder(0).append(new StringBuilder(47).append("INSERT INTO TABLE ").append(table).append(" SELECT CAST(id AS INT) AS a,").toString()).append(new StringBuilder(60).append(" CAST(id % 10 AS INT) AS b, CAST(id % 100 AS INT) AS c FROM ").append(MODULE$.tempView()).toString()).toString()));
    }

    public void insertIntoHybrid(String table, Benchmark benchmark) {
        benchmark.addCase("INSERT INTO HYBRID", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> MODULE$.sql().apply((Object)new StringBuilder(0).append(new StringBuilder(65).append("INSERT INTO TABLE ").append(table).append(" partition(b=1, c) SELECT CAST(id AS INT) AS a,").toString()).append(new StringBuilder(32).append(" CAST(id % 10 AS INT) AS c FROM ").append(MODULE$.tempView()).toString()).toString()));
    }

    public void insertIntoStatic(String table, Benchmark benchmark) {
        benchmark.addCase("INSERT INTO STATIC", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> MODULE$.sql().apply((Object)new StringBuilder(0).append(new StringBuilder(67).append("INSERT INTO TABLE ").append(table).append(" partition(b=1, c=10) SELECT CAST(id AS INT) AS a").toString()).append(new StringBuilder(6).append(" FROM ").append(MODULE$.tempView()).toString()).toString()));
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.spark().range((long)this.numRows()).createOrReplaceTempView(this.tempView());
        try {
            String t1 = "t1";
            String t2 = "t2";
            String t3 = "t3";
            String t4 = "t4";
            String t5 = "t5";
            String t6 = "t6";
            String x$1 = "insert hive table benchmark";
            long x$2 = this.numRows();
            Option x$3 = this.output();
            int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t1, t2, t3, t4, t5, t6}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                MODULE$.insertIntoDynamic(t1, benchmark);
                MODULE$.insertIntoHybrid(t2, benchmark);
                MODULE$.insertIntoStatic(t3, benchmark);
                MODULE$.insertOverwriteDynamic(t4, benchmark);
                MODULE$.insertOverwriteHybrid(t5, benchmark);
                MODULE$.insertOverwriteStatic(t6, benchmark);
                benchmark.run();
            });
        }
        finally {
            this.spark().catalog().dropTempView(this.tempView());
        }
    }

    public String suffix() {
        return "-hive2.3";
    }

    private InsertIntoHiveTableBenchmark$() {
    }
}

