/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.DataSourceScanExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.InsertIntoHadoopFsRelationCommand;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.hive.HiveParquetMetastoreSuite$;
import org.apache.spark.sql.hive.HiveSessionCatalog;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.ParquetPartitioningTest;
import org.apache.spark.sql.hive.execution.HiveTableScanExec;
import org.apache.spark.sql.sources.BaseRelation;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple1;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005M3AAB\u0004\u0001%!)q\u0003\u0001C\u00011!)!\u0004\u0001C!7!)!\u0005\u0001C!7!)1\u0005\u0001C\u0001I!)\u0011\t\u0001C\u0005\u0005\nI\u0002*\u001b<f!\u0006\u0014\u0018/^3u\u001b\u0016$\u0018m\u001d;pe\u0016\u001cV/\u001b;f\u0015\tA\u0011\"\u0001\u0003iSZ,'B\u0001\u0006\f\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00195\tQa\u001d9be.T!AD\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0012aA8sO\u000e\u00011C\u0001\u0001\u0014!\t!R#D\u0001\b\u0013\t1rAA\fQCJ\fX/\u001a;QCJ$\u0018\u000e^5p]&tw\rV3ti\u00061A(\u001b8jiz\"\u0012!\u0007\t\u0003)\u0001\t\u0011BY3g_J,\u0017\t\u001c7\u0015\u0003q\u0001\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011A!\u00168ji\u0006A\u0011M\u001a;fe\u0006cG.A\fd_2dWm\u0019;IC\u0012|w\u000e\u001d$t%\u0016d\u0017\r^5p]R\u0011Q%\f\t\u0003M-j\u0011a\n\u0006\u0003Q%\n1\u0002Z1uCN|WO]2fg*\u0011!&C\u0001\nKb,7-\u001e;j_:L!\u0001L\u0014\u0003!!\u000bGm\\8q\rN\u0014V\r\\1uS>t\u0007\"\u0002\u0018\u0005\u0001\u0004y\u0013A\u00013g!\t\u0001dH\u0004\u00022y9\u0011!g\u000f\b\u0003gir!\u0001N\u001d\u000f\u0005UBT\"\u0001\u001c\u000b\u0005]\n\u0012A\u0002\u001fs_>$h(C\u0001\u0011\u0013\tqq\"\u0003\u0002\r\u001b%\u0011!bC\u0005\u0003{%\tq\u0001]1dW\u0006<W-\u0003\u0002@\u0001\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003{%\t\u0001dZ3u\u0007\u0006\u001c\u0007.\u001a3ECR\f7k\\;sG\u0016$\u0016M\u00197f)\t\u0019U\n\u0005\u0002E\u00176\tQI\u0003\u0002G\u000f\u00069An\\4jG\u0006d'B\u0001%J\u0003\u0015\u0001H.\u00198t\u0015\tQ\u0015\"\u0001\u0005dCR\fG._:u\u0013\taUIA\u0006M_\u001eL7-\u00197QY\u0006t\u0007\"\u0002(\u0006\u0001\u0004y\u0015!\u0002;bE2,\u0007C\u0001)R\u001b\u0005I\u0015B\u0001*J\u0005=!\u0016M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\b")
public class HiveParquetMetastoreSuite
extends ParquetPartitioningTest {
    @Override
    public void beforeAll() {
        super.beforeAll();
        this.dropTables((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"partitioned_parquet", "partitioned_parquet_with_key", "partitioned_parquet_with_complextypes", "partitioned_parquet_with_key_and_complextypes", "normal_parquet", "jt", "jt_array", "test_parquet"}));
        this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(470).append("\n        |create external table partitioned_parquet\n        |(\n        |  intField INT,\n        |  stringField STRING\n        |)\n        |PARTITIONED BY (p int)\n        |ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe'\n        | STORED AS\n        | INPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat'\n        | OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat'\n        |location '").append(this.partitionedTableDir().toURI()).append("'\n      ").toString())));
        this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(479).append("\n        |create external table partitioned_parquet_with_key\n        |(\n        |  intField INT,\n        |  stringField STRING\n        |)\n        |PARTITIONED BY (p int)\n        |ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe'\n        | STORED AS\n        | INPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat'\n        | OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat'\n        |location '").append(this.partitionedTableDirWithKey().toURI()).append("'\n      ").toString())));
        this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(433).append("\n        |create external table normal_parquet\n        |(\n        |  intField INT,\n        |  stringField STRING\n        |)\n        |ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe'\n        | STORED AS\n        | INPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat'\n        | OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat'\n        |location '").append(new File(this.normalTableDir(), "normal").toURI()).append("'\n      ").toString())));
        this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(601).append("\n        |CREATE EXTERNAL TABLE partitioned_parquet_with_complextypes\n        |(\n        |  intField INT,\n        |  stringField STRING,\n        |  structField STRUCT<intStructField: INT, stringStructField: STRING>,\n        |  arrayField ARRAY<INT>\n        |)\n        |PARTITIONED BY (p int)\n        |ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe'\n        | STORED AS\n        | INPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat'\n        | OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat'\n        |LOCATION '").append(this.partitionedTableDirWithComplexTypes().toURI()).append("'\n      ").toString())));
        this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(609).append("\n        |CREATE EXTERNAL TABLE partitioned_parquet_with_key_and_complextypes\n        |(\n        |  intField INT,\n        |  stringField STRING,\n        |  structField STRUCT<intStructField: INT, stringStructField: STRING>,\n        |  arrayField ARRAY<INT>\n        |)\n        |PARTITIONED BY (p int)\n        |ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe'\n        | STORED AS\n        | INPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat'\n        | OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat'\n        |LOCATION '").append(this.partitionedTableDirWithKeyAndComplexTypes().toURI()).append("'\n      ").toString())));
        this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |create table test_parquet\n        |(\n        |  intField INT,\n        |  stringField STRING\n        |)\n        |ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe'\n        |STORED AS\n        |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat'\n        |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat'\n      ")));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).foreach((Function1 & Serializable)p -> HiveParquetMetastoreSuite.$anonfun$beforeAll$1(this, BoxesRunTime.unboxToInt((Object)p)));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).foreach((Function1 & Serializable)p -> HiveParquetMetastoreSuite.$anonfun$beforeAll$2(this, BoxesRunTime.unboxToInt((Object)p)));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).foreach((Function1 & Serializable)p -> HiveParquetMetastoreSuite.$anonfun$beforeAll$3(this, BoxesRunTime.unboxToInt((Object)p)));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).foreach((Function1 & Serializable)p -> HiveParquetMetastoreSuite.$anonfun$beforeAll$4(this, BoxesRunTime.unboxToInt((Object)p)));
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(HiveParquetMetastoreSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_hive_HiveParquetMetastoreSuite$$typecreator10$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_hive_HiveParquetMetastoreSuite$$typecreator10$1(HiveParquetMetastoreSuite $outer) {
            }
        }
        this.spark().implicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)i -> HiveParquetMetastoreSuite.$anonfun$beforeAll$5(BoxesRunTime.unboxToInt((Object)i))), this.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_HiveParquetMetastoreSuite$$typecreator10$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})).createOrReplaceTempView("jt");
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(HiveParquetMetastoreSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_hive_HiveParquetMetastoreSuite$$typecreator20$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Seq"), (List)new .colon.colon((Object)$m.staticClass("java.lang.Integer").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_sql_hive_HiveParquetMetastoreSuite$$typecreator20$1(HiveParquetMetastoreSuite $outer) {
            }
        }
        this.spark().implicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)i -> HiveParquetMetastoreSuite.$anonfun$beforeAll$6(BoxesRunTime.unboxToInt((Object)i))), this.spark().implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_hive_HiveParquetMetastoreSuite$$typecreator20$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).createOrReplaceTempView("jt_array");
        String $org_scalatest_assert_macro_left = this.spark().sqlContext().getConf(HiveUtils$.MODULE$.CONVERT_METASTORE_PARQUET().key());
        String $org_scalatest_assert_macro_right = "true";
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
    }

    @Override
    public void afterAll() {
        try {
            this.dropTables((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"partitioned_parquet", "partitioned_parquet_with_key", "partitioned_parquet_with_complextypes", "partitioned_parquet_with_key_and_complextypes", "normal_parquet", "jt", "jt_array", "test_parquet"}));
        }
        finally {
            super.afterAll();
        }
    }

    public HadoopFsRelation collectHadoopFsRelation(Dataset<Row> df) {
        LogicalPlan plan = df.queryExecution().analyzed();
        return (HadoopFsRelation)plan.collectFirst((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                LogicalRelation logicalRelation;
                BaseRelation r;
                A1 A1 = x1;
                if (A1 instanceof LogicalRelation && (r = (logicalRelation = (LogicalRelation)A1).relation()) instanceof HadoopFsRelation) {
                    HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)r;
                    object = hadoopFsRelation;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalRelation logicalRelation;
                BaseRelation r;
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof LogicalRelation && (r = (logicalRelation = (LogicalRelation)logicalPlan).relation()) instanceof HadoopFsRelation;
                return bl;
            }
        }).getOrElse((Function0 & Serializable)() -> this.fail(new StringBuilder(41).append("Expecting a HadoopFsRelation 2, but got:\n").append(plan).toString(), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366)));
    }

    private LogicalPlan getCachedDataSourceTable(TableIdentifier table) {
        return ((HiveSessionCatalog)this.hiveContext().sessionState().catalog()).metastoreCatalog().getCachedDataSourceTable(table);
    }

    public static final /* synthetic */ Dataset $anonfun$beforeAll$1(HiveParquetMetastoreSuite $this, int p) {
        return (Dataset)$this.sql().apply((Object)new StringBuilder(50).append("ALTER TABLE partitioned_parquet ADD PARTITION (p=").append(p).append(")").toString());
    }

    public static final /* synthetic */ Dataset $anonfun$beforeAll$2(HiveParquetMetastoreSuite $this, int p) {
        return (Dataset)$this.sql().apply((Object)new StringBuilder(59).append("ALTER TABLE partitioned_parquet_with_key ADD PARTITION (p=").append(p).append(")").toString());
    }

    public static final /* synthetic */ Dataset $anonfun$beforeAll$3(HiveParquetMetastoreSuite $this, int p) {
        return (Dataset)$this.sql().apply((Object)new StringBuilder(76).append("ALTER TABLE partitioned_parquet_with_key_and_complextypes ADD PARTITION (p=").append(p).append(")").toString());
    }

    public static final /* synthetic */ Dataset $anonfun$beforeAll$4(HiveParquetMetastoreSuite $this, int p) {
        return (Dataset)$this.sql().apply((Object)new StringBuilder(68).append("ALTER TABLE partitioned_parquet_with_complextypes ADD PARTITION (p=").append(p).append(")").toString());
    }

    public static final /* synthetic */ Tuple2 $anonfun$beforeAll$5(int i) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)new StringBuilder(3).append("str").append(i).toString());
    }

    public static final /* synthetic */ Tuple1 $anonfun$beforeAll$6(int i) {
        return new Tuple1((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{i, null})));
    }

    private final void checkCached$1(TableIdentifier tableIdentifier) {
        LogicalRelation logicalRelation;
        LogicalPlan logicalPlan = this.getCachedDataSourceTable(tableIdentifier);
        if (logicalPlan == null) {
            throw this.fail(new StringBuilder(41).append("Converted ").append(tableIdentifier.table()).append(" should be cached in the cache.").toString(), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 443));
        }
        if (!(logicalPlan instanceof LogicalRelation) || !((logicalRelation = (LogicalRelation)logicalPlan).relation() instanceof HadoopFsRelation)) {
            throw this.fail(new StringBuilder(54).append("The cached test_parquet should be a Parquet Relation. ").append(new StringBuilder(37).append("However, ").append(logicalPlan).append(" is returned form the cache.").toString()).toString(), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 446));
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$37(HiveParquetMetastoreSuite $this, File src) {
        URI partitionDir = new File(src, "partition").toURI();
        $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n            |CREATE TABLE test_added_partitions (a STRING)\n            |PARTITIONED BY (b INT)\n            |STORED AS PARQUET\n          ")));
        $this.spark().implicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), $this.spark().implicits().newStringEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).createOrReplaceTempView("test_temp");
        $this.sql().apply((Object)"INSERT INTO test_added_partitions PARTITION(b='0') SELECT a FROM test_temp");
        $this.checkAnswer((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT * FROM test_added_partitions"), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"foo", BoxesRunTime.boxToInteger((int)0)})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"bar", BoxesRunTime.boxToInteger((int)0)}))})));
        $this.sql().apply((Object)new StringBuilder(67).append("ALTER TABLE test_added_partitions ADD PARTITION (b='1') LOCATION '").append(partitionDir).append("'").toString());
        $this.checkAnswer((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT * FROM test_added_partitions"), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"foo", BoxesRunTime.boxToInteger((int)0)})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"bar", BoxesRunTime.boxToInteger((int)0)}))})));
        $this.sql().apply((Object)"INSERT INTO TABLE test_added_partitions PARTITION (b=1) select 'baz' as a");
        $this.checkAnswer((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT * FROM test_added_partitions"), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"foo", BoxesRunTime.boxToInteger((int)0)})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"bar", BoxesRunTime.boxToInteger((int)0)})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"baz", BoxesRunTime.boxToInteger((int)1)}))})));
        $this.checkAnswer((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT * FROM test_added_partitions where b = 0"), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"foo", BoxesRunTime.boxToInteger((int)0)})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"bar", BoxesRunTime.boxToInteger((int)0)}))})));
        $this.checkAnswer((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT * FROM test_added_partitions where b = 1"), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"baz", BoxesRunTime.boxToInteger((int)1)}))})));
        $this.checkAnswer((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT * FROM test_added_partitions where b = 2"), (Seq)package$.MODULE$.Seq().empty());
        String[] $org_scalatest_assert_macro_left = ((Dataset)$this.sql().apply((Object)"select * from test_added_partitions")).inputFiles();
        int $org_scalatest_assert_macro_right = 2;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 588));
        String[] $org_scalatest_assert_macro_left2 = ((Dataset)$this.sql().apply((Object)"select * from test_added_partitions where b = 0")).inputFiles();
        int $org_scalatest_assert_macro_right2 = 1;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 589));
        String[] $org_scalatest_assert_macro_left3 = ((Dataset)$this.sql().apply((Object)"select * from test_added_partitions where b = 1")).inputFiles();
        int $org_scalatest_assert_macro_right3 = 1;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 590));
        String[] $org_scalatest_assert_macro_left4 = ((Dataset)$this.sql().apply((Object)"select * from test_added_partitions where b = 2")).inputFiles();
        int $org_scalatest_assert_macro_right4 = 0;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 591));
    }

    public static final /* synthetic */ void $anonfun$new$46(HiveParquetMetastoreSuite $this, File src) {
        String newPartitionDir = src.toURI().toString();
        $this.spark().range(2L).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"cast(id as string)"})).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).write().mode("overwrite").parquet(newPartitionDir);
        $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n            |CREATE TABLE test_added_partitions (a STRING)\n            |PARTITIONED BY (b INT)\n            |STORED AS PARQUET\n          ")));
        $this.sql().apply((Object)"ALTER TABLE test_added_partitions ADD PARTITION (b='1')");
        $this.checkAnswer((Function0 & Serializable)() -> $this.spark().table("test_added_partitions"), (Seq)package$.MODULE$.Seq().empty());
        $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(126).append("\n             |LOAD DATA LOCAL INPATH '").append(newPartitionDir).append("' OVERWRITE\n             |INTO TABLE test_added_partitions PARTITION(b='1')\n           ").toString())));
        $this.checkAnswer((Function0 & Serializable)() -> $this.spark().table("test_added_partitions"), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"0", BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", BoxesRunTime.boxToInteger((int)1)}))})));
    }

    public static final /* synthetic */ void $anonfun$new$51(HiveParquetMetastoreSuite $this, File src) {
        String newPartitionDir = src.toURI().toString();
        $this.spark().range(2L).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"cast(id as string)"})).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).write().mode("overwrite").parquet(newPartitionDir);
        $this.sql().apply((Object)"CREATE TABLE tab (a STRING) STORED AS PARQUET");
        $this.checkAnswer((Function0 & Serializable)() -> $this.spark().table("tab"), (Seq)package$.MODULE$.Seq().empty());
        $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(91).append("\n             |LOAD DATA LOCAL INPATH '").append(newPartitionDir).append("' OVERWRITE\n             |INTO TABLE tab\n           ").toString())));
        $this.checkAnswer((Function0 & Serializable)() -> $this.spark().table("tab"), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"0"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1"}))})));
    }

    public HiveParquetMetastoreSuite() {
        this.test("conversion is working", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Seq $org_scalatest_assert_macro_left = ((Dataset)this.sql().apply((Object)"SELECT * FROM normal_parquet")).queryExecution().sparkPlan().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Object object = A1 instanceof HiveTableScanExec ? BoxesRunTime.boxToBoolean((boolean)true) : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(SparkPlan x1) {
                    SparkPlan sparkPlan = x1;
                    boolean bl = sparkPlan instanceof HiveTableScanExec;
                    return bl;
                }
            });
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
            Seq $org_scalatest_assert_macro_left2 = ((Dataset)this.sql().apply((Object)"SELECT * FROM normal_parquet")).queryExecution().sparkPlan().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    Object object = A1 instanceof DataSourceScanExec ? BoxesRunTime.boxToBoolean((boolean)true) : function1.apply(x2);
                    return (B1)object;
                }

                public final boolean isDefinedAt(SparkPlan x2) {
                    SparkPlan sparkPlan = x2;
                    boolean bl = sparkPlan instanceof DataSourceScanExec;
                    return bl;
                }
            });
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "nonEmpty", $org_scalatest_assert_macro_left2.nonEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        }, new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        this.test("scan an empty parquet table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.checkAnswer((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT count(*) FROM test_parquet"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)}))), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        this.test("scan an empty parquet table with upper case", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.checkAnswer((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT count(INTFIELD) FROM TEST_parquet"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)}))), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
        this.test("insert into an empty parquet table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.dropTables((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test_insert_parquet"}));
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |create table test_insert_parquet\n        |(\n        |  intField INT,\n        |  stringField STRING\n        |)\n        |ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe'\n        |STORED AS\n        |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat'\n        |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat'\n      ")));
            this.sql().apply((Object)"insert into table test_insert_parquet select a, b from jt where jt.a > 5");
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "str6"}));
            Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), "str7"}));
            this.checkAnswer((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT intField, stringField FROM test_insert_parquet WHERE intField < 8"), (Seq)package$.MODULE$.Nil().$colon$colon((Object)row2).$colon$colon((Object)row));
            this.sql().apply((Object)"insert overwrite table test_insert_parquet select a, b from jt where jt.a < 5");
            Row row3 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "str3"}));
            Row row4 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "str4"}));
            this.checkAnswer((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT intField, stringField FROM test_insert_parquet WHERE intField > 2"), (Seq)package$.MODULE$.Nil().$colon$colon((Object)row4).$colon$colon((Object)row3));
            this.dropTables((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test_insert_parquet"}));
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |create table test_insert_parquet\n        |(\n        |  intField INT,\n        |  stringField STRING\n        |)\n        |ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe'\n        |STORED AS\n        |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat'\n        |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat'\n      ")));
            this.sql().apply((Object)"insert overwrite table test_insert_parquet select a, b from jt where jt.a < 5");
            Row row5 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "str3"}));
            Row row6 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "str4"}));
            this.checkAnswer((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT intField, stringField FROM test_insert_parquet WHERE intField > 2"), (Seq)package$.MODULE$.Nil().$colon$colon((Object)row6).$colon$colon((Object)row5));
            this.sql().apply((Object)"insert into table test_insert_parquet select a, b from jt");
            this.checkAnswer((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT intField, stringField FROM test_insert_parquet"), (Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)i -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), new StringBuilder(3).append("str").append(BoxesRunTime.unboxToInt((Object)i)).toString()}))).$plus$plus((IterableOnce)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 4).map((Function1 & Serializable)i -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), new StringBuilder(3).append("str").append(BoxesRunTime.unboxToInt((Object)i)).toString()})))));
            this.dropTables((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test_insert_parquet"}));
        }, new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
        this.test("scan a parquet table created through a CTAS statement", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test_parquet_ctas"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalRelation logicalRelation;
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |create table test_parquet_ctas ROW FORMAT\n          |SERDE 'org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe'\n          |STORED AS\n          |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat'\n          |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat'\n          |AS select * from jt\n        ")));
            this.checkAnswer((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT a, b FROM test_parquet_ctas WHERE a = 1"), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "str1"}))})));
            LogicalPlan logicalPlan = this.hiveContext().table("test_parquet_ctas").queryExecution().optimizedPlan();
            if (!(logicalPlan instanceof LogicalRelation) || !((logicalRelation = (LogicalRelation)logicalPlan).relation() instanceof HadoopFsRelation)) {
                throw this.fail(new StringBuilder(41).append("test_parquet_ctas should be converted to ").append(String.valueOf(HadoopFsRelation.class.getCanonicalName())).toString(), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
        this.test("MetastoreRelation in InsertIntoTable will be converted", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test_insert_parquet"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |create table test_insert_parquet\n          |(\n          |  intField INT\n          |)\n          |ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe'\n          |STORED AS\n          |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat'\n          |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat'\n        ")));
            Dataset df = (Dataset)this.sql().apply((Object)"INSERT INTO TABLE test_insert_parquet SELECT a FROM jt");
            LogicalPlan logicalPlan = df.queryExecution().analyzed();
            if (!(logicalPlan instanceof InsertIntoHadoopFsRelationCommand)) {
                throw this.fail(new StringBuilder(45).append("test_insert_parquet should be converted to a ").append(new StringBuilder(19).append(HadoopFsRelation.class.getCanonicalName()).append(". However, found a ").append(logicalPlan.toString()).toString()).toString(), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
            }
            InsertIntoHadoopFsRelationCommand insertIntoHadoopFsRelationCommand = (InsertIntoHadoopFsRelationCommand)logicalPlan;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(insertIntoHadoopFsRelationCommand.catalogTable().map((Function1 & Serializable)x$1 -> x$1.identifier().table()));
            Some $org_scalatest_assert_macro_right = new Some((Object)"test_insert_parquet");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
            this.checkAnswer((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT intField FROM test_insert_parquet WHERE test_insert_parquet.intField > 5"), (Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(((Dataset)this.sql().apply((Object)"SELECT a FROM jt WHERE jt.a > 5")).collect()));
        }), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
        this.test("MetastoreRelation in InsertIntoHiveTable will be converted", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test_insert_parquet"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |create table test_insert_parquet\n          |(\n          |  int_array array<int>\n          |)\n          |ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe'\n          |STORED AS\n          |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat'\n          |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat'\n        ")));
            Dataset df = (Dataset)this.sql().apply((Object)"INSERT INTO TABLE test_insert_parquet SELECT a FROM jt_array");
            LogicalPlan logicalPlan = df.queryExecution().analyzed();
            if (!(logicalPlan instanceof InsertIntoHadoopFsRelationCommand)) {
                throw this.fail(new StringBuilder(45).append("test_insert_parquet should be converted to a ").append(new StringBuilder(19).append(HadoopFsRelation.class.getCanonicalName()).append(". However, found a ").append(logicalPlan.toString()).toString()).toString(), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325));
            }
            InsertIntoHadoopFsRelationCommand insertIntoHadoopFsRelationCommand = (InsertIntoHadoopFsRelationCommand)logicalPlan;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(insertIntoHadoopFsRelationCommand.catalogTable().map((Function1 & Serializable)x$2 -> x$2.identifier().table()));
            Some $org_scalatest_assert_macro_right = new Some((Object)"test_insert_parquet");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
            this.checkAnswer((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT int_array FROM test_insert_parquet"), (Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(((Dataset)this.sql().apply((Object)"SELECT a FROM jt_array")).collect()));
        }), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307));
        this.test("SPARK-6450 regression test", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ms_convert"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE TABLE IF NOT EXISTS ms_convert (key INT)\n          |ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe'\n          |STORED AS\n          |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat'\n          |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat'\n        ")));
            LogicalPlan analyzed = ((Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("SELECT key FROM ms_convert\n          |UNION ALL\n          |SELECT key FROM ms_convert\n        ")))).queryExecution().analyzed();
            this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)analyzed.collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    LogicalRelation logicalRelation;
                    A1 A1 = x3;
                    Object object = A1 instanceof LogicalRelation && (logicalRelation = (LogicalRelation)A1).relation() instanceof HadoopFsRelation ? logicalRelation : function1.apply(x3);
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x3) {
                    LogicalRelation logicalRelation;
                    LogicalPlan logicalPlan = x3;
                    boolean bl = logicalPlan instanceof LogicalRelation && (logicalRelation = (LogicalRelation)logicalPlan).relation() instanceof HadoopFsRelation;
                    return bl;
                }
            }).size()), Prettifier$.MODULE$.default(), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
        }), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
        this.test("SPARK-7749: non-partitioned metastore Parquet table lookup should use cached relation", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"nonPartitioned"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |CREATE TABLE nonPartitioned (\n          |  key INT,\n          |  value STRING\n          |)\n          |STORED AS PARQUET\n        ")));
            HadoopFsRelation r1 = this.collectHadoopFsRelation((Dataset<Row>)this.hiveContext().table("nonPartitioned"));
            HadoopFsRelation r2 = this.collectHadoopFsRelation((Dataset<Row>)this.hiveContext().table("nonPartitioned"));
            HadoopFsRelation $org_scalatest_assert_macro_left = r1;
            HadoopFsRelation $org_scalatest_assert_macro_right = r2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "eq", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
        }), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
        this.test("SPARK-7749: partitioned metastore Parquet table lookup should use cached relation", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"partitioned"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |CREATE TABLE partitioned (\n          |  key INT,\n          |  value STRING\n          |)\n          |PARTITIONED BY (part INT)\n          |STORED AS PARQUET\n        ")));
            HadoopFsRelation r1 = this.collectHadoopFsRelation((Dataset<Row>)this.hiveContext().table("partitioned"));
            HadoopFsRelation r2 = this.collectHadoopFsRelation((Dataset<Row>)this.hiveContext().table("partitioned"));
            HadoopFsRelation $org_scalatest_assert_macro_left = r1;
            HadoopFsRelation $org_scalatest_assert_macro_right = r2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "eq", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 407));
        }), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 390));
        this.test("SPARK-15968: nonempty partitioned metastore Parquet table lookup should use cached relation", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"partitioned"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |CREATE TABLE partitioned (\n          |  key INT,\n          |  value STRING\n          |)\n          |PARTITIONED BY (part INT)\n          |STORED AS PARQUET\n        ")));
            this.sql().apply((Object)"INSERT INTO TABLE partitioned PARTITION(part=0) SELECT 1 as key, 'one' as value");
            HadoopFsRelation r1 = this.collectHadoopFsRelation((Dataset<Row>)this.hiveContext().table("partitioned"));
            HadoopFsRelation r2 = this.collectHadoopFsRelation((Dataset<Row>)this.hiveContext().table("partitioned"));
            HadoopFsRelation $org_scalatest_assert_macro_left = r1;
            HadoopFsRelation $org_scalatest_assert_macro_right = r2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "eq", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 430));
        }), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 412));
        this.test("Caching converted data source Parquet Relations", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.dropTables((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test_insert_parquet", "test_parquet_partitioned_cache_test"}));
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |create table test_insert_parquet\n        |(\n        |  intField INT,\n        |  stringField STRING\n        |)\n        |ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe'\n        |STORED AS\n        |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat'\n        |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat'\n      ")));
            TableIdentifier tableIdentifier = TableIdentifier$.MODULE$.apply("test_insert_parquet", (Option)new Some((Object)"default"));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getCachedDataSourceTable(tableIdentifier));
            Null$ $org_scalatest_assert_macro_right = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 470));
            this.hiveContext().table("test_insert_parquet");
            this.checkCached$1(tableIdentifier);
            this.spark().catalog().refreshTable("test_insert_parquet");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.getCachedDataSourceTable(tableIdentifier));
            Null$ $org_scalatest_assert_macro_right2 = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", null, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 477));
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |INSERT INTO TABLE test_insert_parquet\n        |select a, b from jt\n      ")));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.getCachedDataSourceTable(tableIdentifier));
            Null$ $org_scalatest_assert_macro_right3 = null;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", null, $org_scalatest_assert_macro_left3.$eq$eq$eq($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 483));
            this.checkAnswer((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"select * from test_insert_parquet"), (Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(((Dataset)this.sql().apply((Object)"select a, b from jt")).collect()));
            this.spark().catalog().refreshTable("test_insert_parquet");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(this.getCachedDataSourceTable(tableIdentifier));
            Null$ $org_scalatest_assert_macro_right4 = null;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", null, $org_scalatest_assert_macro_left4.$eq$eq$eq($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 490));
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |create table test_parquet_partitioned_cache_test\n        |(\n        |  intField INT,\n        |  stringField STRING\n        |)\n        |PARTITIONED BY (`date` string)\n        |ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe'\n        |STORED AS\n        |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat'\n        |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat'\n      ")));
            tableIdentifier = TableIdentifier$.MODULE$.apply("test_parquet_partitioned_cache_test", (Option)new Some((Object)"default"));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(this.getCachedDataSourceTable(tableIdentifier));
            Null$ $org_scalatest_assert_macro_right5 = null;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", null, $org_scalatest_assert_macro_left5.$eq$eq$eq($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 508));
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |INSERT INTO TABLE test_parquet_partitioned_cache_test\n        |PARTITION (`date`='2015-04-01')\n        |select a, b from jt\n      ")));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(this.getCachedDataSourceTable(tableIdentifier));
            Null$ $org_scalatest_assert_macro_right6 = null;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", null, $org_scalatest_assert_macro_left6.$eq$eq$eq($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 517));
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |INSERT INTO TABLE test_parquet_partitioned_cache_test\n        |PARTITION (`date`='2015-04-02')\n        |select a, b from jt\n      ")));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(this.getCachedDataSourceTable(tableIdentifier));
            Null$ $org_scalatest_assert_macro_right7 = null;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", null, $org_scalatest_assert_macro_left7.$eq$eq$eq($org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 524));
            this.hiveContext().table("test_parquet_partitioned_cache_test");
            this.checkCached$1(tableIdentifier);
            this.checkAnswer((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"select STRINGField, `date`, intField from test_parquet_partitioned_cache_test"), (Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(((Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |select b, '2015-04-01', a FROM jt\n          |UNION ALL\n          |select b, '2015-04-02', a FROM jt\n        ")))).collect()));
            this.spark().catalog().refreshTable("test_parquet_partitioned_cache_test");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(this.getCachedDataSourceTable(tableIdentifier));
            Null$ $org_scalatest_assert_macro_right8 = null;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", null, $org_scalatest_assert_macro_left8.$eq$eq$eq($org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 540));
            this.dropTables((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test_insert_parquet", "test_parquet_partitioned_cache_test"}));
        }, new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439));
        this.test("SPARK-15248: explicitly added partitions should be readable", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test_added_partitions", "test_temp"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)src -> {
            HiveParquetMetastoreSuite.$anonfun$new$37(this, src);
            return BoxedUnit.UNIT;
        })), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 545));
        this.test("Explicitly added partitions should be readable after load", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test_added_partitions"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)src -> {
            HiveParquetMetastoreSuite.$anonfun$new$46(this, src);
            return BoxedUnit.UNIT;
        })), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 596));
        this.test("Non-partitioned table readable after load", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tab"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable)src -> {
            HiveParquetMetastoreSuite.$anonfun$new$51(this, src);
            return BoxedUnit.UNIT;
        })), new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 629));
        this.test("self-join", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Dataset table = this.spark().table("normal_parquet");
            Dataset selfJoin = table.as("t1").crossJoin(table.as("t2"));
            this.checkAnswer((Function0 & Serializable)() -> selfJoin, (Dataset)this.sql().apply((Object)"SELECT * FROM normal_parquet x CROSS JOIN normal_parquet y"));
        }, new Position("HiveParquetMetastoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 653));
    }
}

