/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import org.apache.spark.SparkContext;
import org.apache.spark.metrics.source.HiveCatalogMetrics$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.catalog.CatalogManager$;
import org.apache.spark.sql.execution.adaptive.DisableAdaptiveExecution;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.test.TestHiveContext;
import org.apache.spark.sql.hive.test.TestHiveSingleton;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestData$internalImplicits$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SQLTestUtilsBase;
import org.apache.spark.sql.test.SQLTestUtilsBase$testImplicits$;
import org.apache.spark.tags.SlowHiveTest;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.enablers.Retrying;
import org.scalatest.funsuite.AnyFunSuiteLike;
import org.scalatest.time.Span;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@SlowHiveTest
@ScalaSignature(bytes="\u0006\u0005-2AAA\u0002\u0001!!)\u0001\u0005\u0001C\u0001C\t\u0001\u0002*\u001b<f\u000bb\u0004H.Y5o'VLG/\u001a\u0006\u0003\t\u0015\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\u00199\u0011\u0001\u00025jm\u0016T!\u0001C\u0005\u0002\u0007M\fHN\u0003\u0002\u000b\u0017\u0005)1\u000f]1sW*\u0011A\"D\u0001\u0007CB\f7\r[3\u000b\u00039\t1a\u001c:h\u0007\u0001\u0019B\u0001A\t\u00167A\u0011!cE\u0007\u0002\u000f%\u0011Ac\u0002\u0002\n#V,'/\u001f+fgR\u0004\"AF\r\u000e\u0003]Q!\u0001G\u0004\u0002\tQ,7\u000f^\u0005\u00035]\u0011AbU)M)\u0016\u001cH/\u0016;jYN\u0004\"\u0001\b\u0010\u000e\u0003uQ!\u0001G\u0003\n\u0005}i\"!\u0005+fgRD\u0015N^3TS:<G.\u001a;p]\u00061A(\u001b8jiz\"\u0012A\t\t\u0003G\u0001i\u0011a\u0001\u0015\u0003\u0001\u0015\u0002\"AJ\u0015\u000e\u0003\u001dR!\u0001K\u0005\u0002\tQ\fwm]\u0005\u0003U\u001d\u0012Ab\u00157po\"Kg/\u001a+fgR\u0004")
public class HiveExplainSuite
extends QueryTest
implements SQLTestUtils,
TestHiveSingleton {
    private boolean enableAutoThreadAudit;
    private SparkSession spark;
    private TestHiveContext hiveContext;
    private HiveClient hiveClient;
    private boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    private Function1<String, Dataset<Row>> sql;
    private volatile SQLTestUtilsBase$testImplicits$ testImplicits$module;
    private volatile SQLTestData$internalImplicits$ internalImplicits$module;
    private Dataset<Row> emptyTestData;
    private Dataset<Row> testData;
    private Dataset<Row> testData2;
    private Dataset<Row> testData3;
    private Dataset<Row> negativeData;
    private Dataset<Row> largeAndSmallInts;
    private Dataset<Row> decimalData;
    private Dataset<Row> binaryData;
    private Dataset<Row> upperCaseData;
    private Dataset<Row> lowerCaseData;
    private Dataset<Row> lowerCaseDataWithDuplicates;
    private RDD<SQLTestData.ArrayData> arrayData;
    private RDD<SQLTestData.MapData> mapData;
    private RDD<SQLTestData.IntervalData> calendarIntervalData;
    private RDD<SQLTestData.StringData> repeatedData;
    private RDD<SQLTestData.StringData> nullableRepeatedData;
    private Dataset<Row> nullInts;
    private Dataset<Row> allNulls;
    private Dataset<Row> nullStrings;
    private Dataset<Row> tableName;
    private RDD<String> unparsedStrings;
    private RDD<SQLTestData.IntField> withEmptyParts;
    private Dataset<Row> person;
    private Dataset<Row> salary;
    private Dataset<Row> complexData;
    private Dataset<Row> courseSales;
    private Dataset<Row> trainingSales;
    private Dataset<Row> intervalData;
    private AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private volatile int bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public void afterAll() {
        TestHiveSingleton.afterAll$(this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll() {
        super.beforeAll();
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$withTempDir(Function1 f) {
        super.withTempDir(f);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$test(String testName, Seq testTags, Function0 testFun, Position pos) {
        AnyFunSuiteLike.test$((AnyFunSuiteLike)this, (String)testName, (Seq)testTags, (Function0)testFun, (Position)pos);
    }

    public void beforeAll() {
        SQLTestUtils.beforeAll$((SQLTestUtils)this);
    }

    public void withTempDir(Function1<File, BoxedUnit> f) {
        SQLTestUtils.withTempDir$((SQLTestUtils)this, f);
    }

    public void testWithWholeStageCodegenOnAndOff(String testName, Function1<String, BoxedUnit> f) {
        SQLTestUtils.testWithWholeStageCodegenOnAndOff$((SQLTestUtils)this, (String)testName, f);
    }

    public void setupTestData() {
        SQLTestUtils.setupTestData$((SQLTestUtils)this);
    }

    public void testQuietly(String name, Function0<BoxedUnit> f) {
        SQLTestUtils.testQuietly$((SQLTestUtils)this, (String)name, f);
    }

    public void test(String testName, Seq<Tag> testTags, Function0<Object> testFun, Position pos) {
        SQLTestUtils.test$((SQLTestUtils)this, (String)testName, testTags, testFun, (Position)pos);
    }

    public void testWithUninterruptibleThread(String name, boolean quietly, Function0<BoxedUnit> body) {
        SQLTestUtils.testWithUninterruptibleThread$((SQLTestUtils)this, (String)name, (boolean)quietly, body);
    }

    public boolean testWithUninterruptibleThread$default$2() {
        return SQLTestUtils.testWithUninterruptibleThread$default$2$((SQLTestUtils)this);
    }

    public void withResourceTempPath(String resourcePath, Function1<File, BoxedUnit> f) {
        SQLTestUtils.withResourceTempPath$((SQLTestUtils)this, (String)resourcePath, f);
    }

    public void waitForTasksToFinish() {
        SQLTestUtils.waitForTasksToFinish$((SQLTestUtils)this);
    }

    public void withTempPaths(int numPaths, Function1<Seq<File>, BoxedUnit> f) {
        SQLTestUtils.withTempPaths$((SQLTestUtils)this, (int)numPaths, f);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtilsBase$$super$withSQLConf(Seq pairs, Function0 f) {
        SQLHelper.withSQLConf$((SQLHelper)this, (Seq)pairs, (Function0)f);
    }

    public SparkContext sparkContext() {
        return SQLTestUtilsBase.sparkContext$((SQLTestUtilsBase)this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withSQLConf$((SQLTestUtilsBase)this, pairs, f);
    }

    public void withUserDefinedFunction(Seq<Tuple2<String, Object>> functions2, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withUserDefinedFunction$((SQLTestUtilsBase)this, functions2, f);
    }

    public void withTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTempView$((SQLTestUtilsBase)this, viewNames, f);
    }

    public void withGlobalTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withGlobalTempView$((SQLTestUtilsBase)this, viewNames, f);
    }

    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTable$((SQLTestUtilsBase)this, tableNames, f);
    }

    public void withView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withView$((SQLTestUtilsBase)this, viewNames, f);
    }

    public void withCache(Seq<String> cacheNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withCache$((SQLTestUtilsBase)this, cacheNames, f);
    }

    public void uncacheTable(String tableName) {
        SQLTestUtilsBase.uncacheTable$((SQLTestUtilsBase)this, (String)tableName);
    }

    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDatabase$((SQLTestUtilsBase)this, f);
    }

    public void withDatabase(Seq<String> dbNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withDatabase$((SQLTestUtilsBase)this, dbNames, f);
    }

    public void withNamespace(Seq<String> namespaces, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withNamespace$((SQLTestUtilsBase)this, namespaces, f);
    }

    public void withCurrentCatalogAndNamespace(Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withCurrentCatalogAndNamespace$((SQLTestUtilsBase)this, f);
    }

    public void withLocale(String language, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withLocale$((SQLTestUtilsBase)this, (String)language, f);
    }

    public void activateDatabase(String db, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.activateDatabase$((SQLTestUtilsBase)this, (String)db, f);
    }

    public Dataset<Row> stripSparkFilter(Dataset<Row> df) {
        return SQLTestUtilsBase.stripSparkFilter$((SQLTestUtilsBase)this, df);
    }

    public Dataset<Row> logicalPlanToSparkQuery(LogicalPlan plan) {
        return SQLTestUtilsBase.logicalPlanToSparkQuery$((SQLTestUtilsBase)this, (LogicalPlan)plan);
    }

    public URI makeQualifiedPath(String path) {
        return SQLTestUtilsBase.makeQualifiedPath$((SQLTestUtilsBase)this, (String)path);
    }

    public String testFile(String fileName) {
        return SQLTestUtilsBase.testFile$((SQLTestUtilsBase)this, (String)fileName);
    }

    public long getLocalDirSize(File file) {
        return SQLTestUtilsBase.getLocalDirSize$((SQLTestUtilsBase)this, (File)file);
    }

    public void loadTestData() {
        SQLTestData.loadTestData$((SQLTestData)this);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public TestHiveContext hiveContext() {
        return this.hiveContext;
    }

    @Override
    public HiveClient hiveClient() {
        return this.hiveClient;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveContext_$eq(TestHiveContext x$1) {
        this.hiveContext = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveClient_$eq(HiveClient x$1) {
        this.hiveClient = x$1;
    }

    public boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests() {
        return this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    }

    public void org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(boolean x$1) {
        this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests = x$1;
    }

    private Function1<String, Dataset<Row>> sql$lzycompute() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if ((this.bitmap$0 & 1) == 0) {
                this.sql = SQLTestUtilsBase.sql$((SQLTestUtilsBase)this);
                this.bitmap$0 |= 1;
            }
        }
        return this.sql;
    }

    public Function1<String, Dataset<Row>> sql() {
        return (this.bitmap$0 & 1) == 0 ? this.sql$lzycompute() : this.sql;
    }

    public SQLTestUtilsBase$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    public SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits() {
        if (this.internalImplicits$module == null) {
            this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1();
        }
        return this.internalImplicits$module;
    }

    private Dataset<Row> emptyTestData$lzycompute() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if ((this.bitmap$0 & 2) == 0) {
                this.emptyTestData = SQLTestData.emptyTestData$((SQLTestData)this);
                this.bitmap$0 |= 2;
            }
        }
        return this.emptyTestData;
    }

    public Dataset<Row> emptyTestData() {
        return (this.bitmap$0 & 2) == 0 ? this.emptyTestData$lzycompute() : this.emptyTestData;
    }

    private Dataset<Row> testData$lzycompute() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if ((this.bitmap$0 & 4) == 0) {
                this.testData = SQLTestData.testData$((SQLTestData)this);
                this.bitmap$0 |= 4;
            }
        }
        return this.testData;
    }

    public Dataset<Row> testData() {
        return (this.bitmap$0 & 4) == 0 ? this.testData$lzycompute() : this.testData;
    }

    private Dataset<Row> testData2$lzycompute() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if ((this.bitmap$0 & 8) == 0) {
                this.testData2 = SQLTestData.testData2$((SQLTestData)this);
                this.bitmap$0 |= 8;
            }
        }
        return this.testData2;
    }

    public Dataset<Row> testData2() {
        return (this.bitmap$0 & 8) == 0 ? this.testData2$lzycompute() : this.testData2;
    }

    private Dataset<Row> testData3$lzycompute() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.testData3 = SQLTestData.testData3$((SQLTestData)this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.testData3;
    }

    public Dataset<Row> testData3() {
        return (this.bitmap$0 & 0x10) == 0 ? this.testData3$lzycompute() : this.testData3;
    }

    private Dataset<Row> negativeData$lzycompute() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.negativeData = SQLTestData.negativeData$((SQLTestData)this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.negativeData;
    }

    public Dataset<Row> negativeData() {
        return (this.bitmap$0 & 0x20) == 0 ? this.negativeData$lzycompute() : this.negativeData;
    }

    private Dataset<Row> largeAndSmallInts$lzycompute() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.largeAndSmallInts = SQLTestData.largeAndSmallInts$((SQLTestData)this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.largeAndSmallInts;
    }

    public Dataset<Row> largeAndSmallInts() {
        return (this.bitmap$0 & 0x40) == 0 ? this.largeAndSmallInts$lzycompute() : this.largeAndSmallInts;
    }

    private Dataset<Row> decimalData$lzycompute() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.decimalData = SQLTestData.decimalData$((SQLTestData)this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.decimalData;
    }

    public Dataset<Row> decimalData() {
        return (this.bitmap$0 & 0x80) == 0 ? this.decimalData$lzycompute() : this.decimalData;
    }

    private Dataset<Row> binaryData$lzycompute() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.binaryData = SQLTestData.binaryData$((SQLTestData)this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.binaryData;
    }

    public Dataset<Row> binaryData() {
        return (this.bitmap$0 & 0x100) == 0 ? this.binaryData$lzycompute() : this.binaryData;
    }

    private Dataset<Row> upperCaseData$lzycompute() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.upperCaseData = SQLTestData.upperCaseData$((SQLTestData)this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.upperCaseData;
    }

    public Dataset<Row> upperCaseData() {
        return (this.bitmap$0 & 0x200) == 0 ? this.upperCaseData$lzycompute() : this.upperCaseData;
    }

    private Dataset<Row> lowerCaseData$lzycompute() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.lowerCaseData = SQLTestData.lowerCaseData$((SQLTestData)this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.lowerCaseData;
    }

    public Dataset<Row> lowerCaseData() {
        return (this.bitmap$0 & 0x400) == 0 ? this.lowerCaseData$lzycompute() : this.lowerCaseData;
    }

    private Dataset<Row> lowerCaseDataWithDuplicates$lzycompute() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.lowerCaseDataWithDuplicates = SQLTestData.lowerCaseDataWithDuplicates$((SQLTestData)this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.lowerCaseDataWithDuplicates;
    }

    public Dataset<Row> lowerCaseDataWithDuplicates() {
        return (this.bitmap$0 & 0x800) == 0 ? this.lowerCaseDataWithDuplicates$lzycompute() : this.lowerCaseDataWithDuplicates;
    }

    private RDD<SQLTestData.ArrayData> arrayData$lzycompute() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.arrayData = SQLTestData.arrayData$((SQLTestData)this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.arrayData;
    }

    public RDD<SQLTestData.ArrayData> arrayData() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.arrayData$lzycompute() : this.arrayData;
    }

    private RDD<SQLTestData.MapData> mapData$lzycompute() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.mapData = SQLTestData.mapData$((SQLTestData)this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.mapData;
    }

    public RDD<SQLTestData.MapData> mapData() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.mapData$lzycompute() : this.mapData;
    }

    private RDD<SQLTestData.IntervalData> calendarIntervalData$lzycompute() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.calendarIntervalData = SQLTestData.calendarIntervalData$((SQLTestData)this);
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.calendarIntervalData;
    }

    public RDD<SQLTestData.IntervalData> calendarIntervalData() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.calendarIntervalData$lzycompute() : this.calendarIntervalData;
    }

    private RDD<SQLTestData.StringData> repeatedData$lzycompute() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.repeatedData = SQLTestData.repeatedData$((SQLTestData)this);
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.repeatedData;
    }

    public RDD<SQLTestData.StringData> repeatedData() {
        return (this.bitmap$0 & 0x8000) == 0 ? this.repeatedData$lzycompute() : this.repeatedData;
    }

    private RDD<SQLTestData.StringData> nullableRepeatedData$lzycompute() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.nullableRepeatedData = SQLTestData.nullableRepeatedData$((SQLTestData)this);
                this.bitmap$0 |= 0x10000;
            }
        }
        return this.nullableRepeatedData;
    }

    public RDD<SQLTestData.StringData> nullableRepeatedData() {
        return (this.bitmap$0 & 0x10000) == 0 ? this.nullableRepeatedData$lzycompute() : this.nullableRepeatedData;
    }

    private Dataset<Row> nullInts$lzycompute() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.nullInts = SQLTestData.nullInts$((SQLTestData)this);
                this.bitmap$0 |= 0x20000;
            }
        }
        return this.nullInts;
    }

    public Dataset<Row> nullInts() {
        return (this.bitmap$0 & 0x20000) == 0 ? this.nullInts$lzycompute() : this.nullInts;
    }

    private Dataset<Row> allNulls$lzycompute() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.allNulls = SQLTestData.allNulls$((SQLTestData)this);
                this.bitmap$0 |= 0x40000;
            }
        }
        return this.allNulls;
    }

    public Dataset<Row> allNulls() {
        return (this.bitmap$0 & 0x40000) == 0 ? this.allNulls$lzycompute() : this.allNulls;
    }

    private Dataset<Row> nullStrings$lzycompute() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if ((this.bitmap$0 & 0x80000) == 0) {
                this.nullStrings = SQLTestData.nullStrings$((SQLTestData)this);
                this.bitmap$0 |= 0x80000;
            }
        }
        return this.nullStrings;
    }

    public Dataset<Row> nullStrings() {
        return (this.bitmap$0 & 0x80000) == 0 ? this.nullStrings$lzycompute() : this.nullStrings;
    }

    private Dataset<Row> tableName$lzycompute() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.tableName = SQLTestData.tableName$((SQLTestData)this);
                this.bitmap$0 |= 0x100000;
            }
        }
        return this.tableName;
    }

    public Dataset<Row> tableName() {
        return (this.bitmap$0 & 0x100000) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    private RDD<String> unparsedStrings$lzycompute() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if ((this.bitmap$0 & 0x200000) == 0) {
                this.unparsedStrings = SQLTestData.unparsedStrings$((SQLTestData)this);
                this.bitmap$0 |= 0x200000;
            }
        }
        return this.unparsedStrings;
    }

    public RDD<String> unparsedStrings() {
        return (this.bitmap$0 & 0x200000) == 0 ? this.unparsedStrings$lzycompute() : this.unparsedStrings;
    }

    private RDD<SQLTestData.IntField> withEmptyParts$lzycompute() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.withEmptyParts = SQLTestData.withEmptyParts$((SQLTestData)this);
                this.bitmap$0 |= 0x400000;
            }
        }
        return this.withEmptyParts;
    }

    public RDD<SQLTestData.IntField> withEmptyParts() {
        return (this.bitmap$0 & 0x400000) == 0 ? this.withEmptyParts$lzycompute() : this.withEmptyParts;
    }

    private Dataset<Row> person$lzycompute() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if ((this.bitmap$0 & 0x800000) == 0) {
                this.person = SQLTestData.person$((SQLTestData)this);
                this.bitmap$0 |= 0x800000;
            }
        }
        return this.person;
    }

    public Dataset<Row> person() {
        return (this.bitmap$0 & 0x800000) == 0 ? this.person$lzycompute() : this.person;
    }

    private Dataset<Row> salary$lzycompute() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if ((this.bitmap$0 & 0x1000000) == 0) {
                this.salary = SQLTestData.salary$((SQLTestData)this);
                this.bitmap$0 |= 0x1000000;
            }
        }
        return this.salary;
    }

    public Dataset<Row> salary() {
        return (this.bitmap$0 & 0x1000000) == 0 ? this.salary$lzycompute() : this.salary;
    }

    private Dataset<Row> complexData$lzycompute() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if ((this.bitmap$0 & 0x2000000) == 0) {
                this.complexData = SQLTestData.complexData$((SQLTestData)this);
                this.bitmap$0 |= 0x2000000;
            }
        }
        return this.complexData;
    }

    public Dataset<Row> complexData() {
        return (this.bitmap$0 & 0x2000000) == 0 ? this.complexData$lzycompute() : this.complexData;
    }

    private Dataset<Row> courseSales$lzycompute() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if ((this.bitmap$0 & 0x4000000) == 0) {
                this.courseSales = SQLTestData.courseSales$((SQLTestData)this);
                this.bitmap$0 |= 0x4000000;
            }
        }
        return this.courseSales;
    }

    public Dataset<Row> courseSales() {
        return (this.bitmap$0 & 0x4000000) == 0 ? this.courseSales$lzycompute() : this.courseSales;
    }

    private Dataset<Row> trainingSales$lzycompute() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if ((this.bitmap$0 & 0x8000000) == 0) {
                this.trainingSales = SQLTestData.trainingSales$((SQLTestData)this);
                this.bitmap$0 |= 0x8000000;
            }
        }
        return this.trainingSales;
    }

    public Dataset<Row> trainingSales() {
        return (this.bitmap$0 & 0x8000000) == 0 ? this.trainingSales$lzycompute() : this.trainingSales;
    }

    private Dataset<Row> intervalData$lzycompute() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if ((this.bitmap$0 & 0x10000000) == 0) {
                this.intervalData = SQLTestData.intervalData$((SQLTestData)this);
                this.bitmap$0 |= 0x10000000;
            }
        }
        return this.intervalData;
    }

    public Dataset<Row> intervalData() {
        return (this.bitmap$0 & 0x10000000) == 0 ? this.intervalData$lzycompute() : this.intervalData;
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    private final void testImplicits$lzycompute$1() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new SQLTestUtilsBase$testImplicits$((SQLTestUtilsBase)this);
            }
        }
    }

    private final void org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if (this.internalImplicits$module == null) {
                this.internalImplicits$module = new SQLTestData$internalImplicits$((SQLTestData)this);
            }
        }
    }

    private final void PatienceConfig$lzycompute$1() {
        HiveExplainSuite hiveExplainSuite = this;
        synchronized (hiveExplainSuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$8(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$new$9(HiveExplainSuite $this, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String useIdInClassName = (String)tuple2._1();
        String expectedClassName = (String)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_USE_ID_IN_CLASS_NAME().key()), (Object)useIdInClassName)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.checkKeywordsExist((Dataset)$this.sql().apply((Object)"EXPLAIN CODEGEN SELECT 1"), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"WholeStageCodegen", "Generated code:", "/* 001 */ public Object generate(Object[] references) {", new StringBuilder(36).append("/* 002 */   return new ").append(expectedClassName).append("(references);").toString(), "/* 003 */ }"})));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public HiveExplainSuite() {
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        SQLTestData.$init$((SQLTestData)this);
        SQLTestUtilsBase.$init$((SQLTestUtilsBase)this);
        SQLTestUtils.$init$((SQLTestUtils)this);
        TestHiveSingleton.$init$(this);
        this.test("show cost in explain command", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String explainCostCommand = "EXPLAIN COST  SELECT * FROM src";
            this.checkKeywordsExist((Dataset)this.sql().apply((Object)explainCostCommand), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Optimized Logical Plan", "Physical Plan"}));
            this.checkKeywordsNotExist((Dataset)this.sql().apply((Object)explainCostCommand), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Parsed Logical Plan", "Analyzed Logical Plan"}));
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CBO_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.checkKeywordsExist((Dataset)this.sql().apply((Object)explainCostCommand), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sizeInBytes"}));
                this.checkKeywordsNotExist((Dataset)this.sql().apply((Object)explainCostCommand), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"rowCount"}));
                this.sql().apply((Object)"ANALYZE TABLE src COMPUTE STATISTICS");
                this.checkKeywordsExist((Dataset)this.sql().apply((Object)explainCostCommand), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sizeInBytes", "rowCount"}));
            });
            this.spark().sessionState().catalog().refreshTable(TableIdentifier$.MODULE$.apply("src"));
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CBO_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.checkKeywordsExist((Dataset)this.sql().apply((Object)explainCostCommand), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sizeInBytes"}));
                this.checkKeywordsNotExist((Dataset)this.sql().apply((Object)explainCostCommand), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"rowCount"}));
            });
            this.checkKeywordsNotExist((Dataset)this.sql().apply((Object)"EXPLAIN  SELECT * FROM src "), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sizeInBytes", "rowCount"}));
        }, new Position("HiveExplainSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        this.test("explain extended command", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkKeywordsExist((Dataset)this.sql().apply((Object)" explain   select * from src where key=123 "), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"== Physical Plan ==", "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe"}));
            this.checkKeywordsNotExist((Dataset)this.sql().apply((Object)" explain   select * from src where key=123 "), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"== Parsed Logical Plan ==", "== Analyzed Logical Plan ==", "== Optimized Logical Plan ==", "Owner", "Database", "Created", "Last Access", "Type", "Provider", "Properties", "Statistics", "Location", "Serde Library", "InputFormat", "OutputFormat", "Partition Provider", "Schema"}));
            this.checkKeywordsExist((Dataset)this.sql().apply((Object)" explain   extended select * from src where key=123 "), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"== Parsed Logical Plan ==", "== Analyzed Logical Plan ==", "== Optimized Logical Plan ==", "== Physical Plan =="}));
        }, new Position("HiveExplainSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        this.test("explain create table command", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkKeywordsExist((Dataset)this.sql().apply((Object)"explain create table temp__b using hive as select * from src limit 2"), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"== Physical Plan ==", "CreateHiveTableAsSelect"}));
            this.checkKeywordsExist((Dataset)this.sql().apply((Object)"explain extended create table temp__b using hive as select * from src limit 2"), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"== Parsed Logical Plan ==", "== Analyzed Logical Plan ==", "== Optimized Logical Plan ==", "== Physical Plan ==", "CreateHiveTableAsSelect"}));
            this.checkKeywordsExist((Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        | EXPLAIN EXTENDED CREATE TABLE temp__b\n        | ROW FORMAT SERDE \"org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe\"\n        | WITH SERDEPROPERTIES(\"serde_p1\"=\"p1\",\"serde_p2\"=\"p2\")\n        | STORED AS RCFile\n        | TBLPROPERTIES(\"tbl_p1\"=\"p11\", \"tbl_p2\"=\"p22\")\n        | AS SELECT * FROM src LIMIT 2\n      "))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"== Parsed Logical Plan ==", "== Analyzed Logical Plan ==", "== Optimized Logical Plan ==", "== Physical Plan ==", "CreateHiveTableAsSelect"}));
        }, new Position("HiveExplainSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("explain output of physical plan should contain proper codegen stage ID", (Seq<Tag>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[]{new DisableAdaptiveExecution("Adaptive explain is different")}), (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.checkKeywordsExist((Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |EXPLAIN SELECT t1.id AS a, t2.id AS b FROM\n        |(SELECT * FROM range(3)) t1 JOIN\n        |(SELECT * FROM range(10)) t2 ON t1.id == t2.id % 3\n      "))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"== Physical Plan ==", "*(2) Project ", "+- *(2) BroadcastHashJoin ", "   :- BroadcastExchange ", "   :  +- *(1) Range ", "   +- *(2) Range "})), new Position("HiveExplainSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("EXPLAIN CODEGEN command", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"true", (Object)"GeneratedIteratorForCodegenStage1"), new Tuple2((Object)"false", (Object)"GeneratedIterator")})).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)HiveExplainSuite.$anonfun$new$8(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
                HiveExplainSuite.$anonfun$new$9(this, x$1);
                return BoxedUnit.UNIT;
            });
            this.checkKeywordsNotExist((Dataset)this.sql().apply((Object)"EXPLAIN CODEGEN SELECT 1"), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"== Physical Plan =="}));
            return (ParseException)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"EXPLAIN EXTENDED CODEGEN SELECT 1"), ClassTag$.MODULE$.apply(ParseException.class), new Position("HiveExplainSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        }, new Position("HiveExplainSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
        this.test("SPARK-23034 show relation names in Hive table scan nodes", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String tableName = "tab";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(32).append("CREATE TABLE ").append(tableName).append("(c1 int) USING hive").toString());
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                Console$.MODULE$.withOut((OutputStream)output, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.spark().table(tableName).explain(false));
                String $org_scalatest_assert_macro_left = output.toString();
                String $org_scalatest_assert_macro_right = new StringBuilder(19).append("Scan hive ").append(CatalogManager$.MODULE$.SESSION_CATALOG_NAME()).append(".default.").append(tableName).toString();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveExplainSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
            });
        }, new Position("HiveExplainSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
        this.test("SPARK-28595: explain should not trigger partition listing", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)legacyBucketedScan -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_BUCKETED_TABLE_SCAN_OUTPUT_ORDERING().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)legacyBucketedScan)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                HiveCatalogMetrics$.MODULE$.reset();
                $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n              |CREATE TABLE t USING json\n              |PARTITIONED BY (j)\n              |CLUSTERED BY (i) SORTED BY (i) INTO 4 BUCKETS\n              |AS SELECT 1 i, 2 j\n            ")));
                    long $org_scalatest_assert_macro_left = HiveCatalogMetrics$.MODULE$.METRIC_PARTITIONS_FETCHED().getCount();
                    int $org_scalatest_assert_macro_right = 0;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveExplainSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
                    $this.spark().table("t").sort((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{$this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"i"}))).$((Seq)Nil$.MODULE$)})).explain();
                    if (legacyBucketedScan) {
                        long $org_scalatest_assert_macro_left2 = HiveCatalogMetrics$.MODULE$.METRIC_PARTITIONS_FETCHED().getCount();
                        int $org_scalatest_assert_macro_right2 = 0;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveExplainSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
                    } else {
                        long $org_scalatest_assert_macro_left3 = HiveCatalogMetrics$.MODULE$.METRIC_PARTITIONS_FETCHED().getCount();
                        int $org_scalatest_assert_macro_right3 = 0;
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == (long)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveExplainSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
                    }
                });
            });
            return BoxedUnit.UNIT;
        }), new Position("HiveExplainSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
        Statics.releaseFence();
    }
}

