/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.test;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.thrift.ThriftDeserializer;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OneRowRelation;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.QueryExecution$;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.hive.HiveExternalCatalog;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.test.TestHiveContext$;
import org.apache.spark.sql.hive.test.TestHiveQueryExecution;
import org.apache.spark.sql.hive.test.TestHiveSessionStateBuilder;
import org.apache.spark.sql.hive.test.TestHiveSharedState;
import org.apache.spark.sql.hive.test.TestHiveSharedState$;
import org.apache.spark.sql.hive.test.TestHiveSparkSession$TestTable$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.Utils$;
import org.apache.thrift.protocol.TBinaryProtocol;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\r\ra!B!C\u0001\u0011s\u0005\u0002C-\u0001\u0005\u000b\u0007I\u0011B.\t\u0011\u0001\u0004!\u0011!Q\u0001\nqC\u0001\u0002\u001b\u0001\u0003\u0006\u0004%I!\u001b\u0005\tc\u0002\u0011\t\u0011)A\u0005U\"A1\u000f\u0001BC\u0002\u0013%A\u000f\u0003\u0005|\u0001\t\u0005\t\u0015!\u0003v\u0011!i\bA!b\u0001\n\u0013q\b\"CA\u0003\u0001\t\u0005\t\u0015!\u0003\u0000\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013Aq!a\u0002\u0001\t\u0003\t)\u0002C\u0004\u0002\b\u0001!\t!a\u0007\t\u0015\u0005E\u0002\u0001#b\u0001\n\u0003\n\u0019\u0004\u0003\u0006\u00028\u0001A)\u0019!C!\u0003sA!\"!\u0010\u0001\u0011\u000b\u0007I\u0011AA \u0011\u00199\u0005\u0001\"\u0011\u0002B!9\u00111\u0010\u0001\u0005B\u0005u\u0004bBA@\u0001\u0011\u0005\u0013\u0011\u0011\u0005\t\u0003\u0007\u0003\u0001\u0019!C\u0005}\"I\u0011Q\u0011\u0001A\u0002\u0013%\u0011q\u0011\u0005\b\u0003'\u0003\u0001\u0015)\u0003\u0000\u0011\u001d\t)\n\u0001C\u0001\u0003/C!\"!(\u0001\u0011\u000b\u0007I\u0011AAP\u0011)\t\u0019\f\u0001EC\u0002\u0013\u0005\u0011q\u0014\u0005\b\u0003k\u0003A\u0011BA\\\u0011%\ti\f\u0001b\u0001\n\u0003\ty\f\u0003\u0005\u0002B\u0002\u0001\u000b\u0011BAR\u0011\u001d\t\u0019\r\u0001C\u0001\u0003\u000bDq!a3\u0001\t\u0013\ti\rC\u0004\u0002\\\u0002!\t!!8\t\u0013\u0005}\u0007A1A\u0005\u0002\u0005\u0005\b\u0002CAz\u0001\u0001\u0006I!a9\u0007\r\u0005U\b\u0001QA|\u0011)\u0011)\u0002\tBK\u0002\u0013\u0005!q\u0003\u0005\u000b\u00053\u0001#\u0011#Q\u0001\n\u0005-\u0004B\u0003B\u000eA\tU\r\u0011\"\u0001\u0003\u001e!Q!1\u0006\u0011\u0003\u0012\u0003\u0006IAa\b\t\u000f\u0005\u001d\u0001\u0005\"\u0001\u0003.!I!q\u0007\u0011\u0002\u0002\u0013\u0005#\u0011\b\u0005\n\u0005w\u0001\u0013\u0011!C\u0001\u0005{A\u0011B!\u0012!\u0003\u0003%\tAa\u0012\t\u0013\tE\u0003%!A\u0005B\tM\u0003\"\u0003B1A\u0005\u0005I\u0011\u0001B2\u0011%\u00119\u0007IA\u0001\n\u0003\u0012I\u0007C\u0005\u0003n\u0001\n\t\u0011\"\u0011\u0003p!I!\u0011\u000f\u0011\u0002\u0002\u0013\u0005#1\u000f\u0005\n\u0005k\u0002\u0013\u0011!C!\u0005o:\u0011Ba\u001f\u0001\u0003\u0003E\tA! \u0007\u0013\u0005U\b!!A\t\u0002\t}\u0004bBA\u0004a\u0011\u0005!\u0011\u0013\u0005\n\u0005c\u0002\u0014\u0011!C#\u0005gB\u0011Ba%1\u0003\u0003%\tI!&\t\u0013\tm\u0005'!A\u0005\u0002\nuea\u0002BY\u0001%!%1\u0017\u0005\n\u000fV\u0012\t\u0011)A\u0005\u0003WBq!a\u00026\t\u0003\u0011)\fC\u0004\u0003<V\"\tA!0\t\u0015\t}\u0006!!A\u0005\u0014\u0011\u0013\t\r\u0003\u0006\u0003F\u0002A)\u0019!C\u0001\u0005\u000fDqAa6\u0001\t\u0003\u0011I\u000eC\u0004\u0003`\u0002!\tA!9\t\u000f\t%\b\u0001\"\u0001\u0003l\"I!q\u001e\u0001C\u0002\u0013E!\u0011\u001f\u0005\t\u0005{\u0004\u0001\u0015!\u0003\u0003t\"9!q \u0001\u0005\u0002\r\u0005!\u0001\u0006+fgRD\u0015N^3Ta\u0006\u00148nU3tg&|gN\u0003\u0002D\t\u0006!A/Z:u\u0015\t)e)\u0001\u0003iSZ,'BA$I\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013*\u000bQa\u001d9be.T!a\u0013'\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0015aA8sON\u0019\u0001aT*\u0011\u0005A\u000bV\"\u0001$\n\u0005I3%\u0001D*qCJ\\7+Z:tS>t\u0007C\u0001+X\u001b\u0005)&B\u0001,I\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001-V\u0005\u001daunZ4j]\u001e\f!a]2\u0004\u0001U\tA\f\u0005\u0002^=6\t\u0001*\u0003\u0002`\u0011\na1\u000b]1sW\u000e{g\u000e^3yi\u0006\u00191o\u0019\u0011)\u0005\t\u0011\u0007CA2g\u001b\u0005!'\"A3\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d$'!\u0003;sC:\u001c\u0018.\u001a8u\u0003M)\u00070[:uS:<7\u000b[1sK\u0012\u001cF/\u0019;f+\u0005Q\u0007cA2l[&\u0011A\u000e\u001a\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00059|W\"\u0001\"\n\u0005A\u0014%a\u0005+fgRD\u0015N^3TQ\u0006\u0014X\rZ*uCR,\u0017\u0001F3ySN$\u0018N\\4TQ\u0006\u0014X\rZ*uCR,\u0007\u0005\u000b\u0002\u0005E\u0006\u0011\u0002/\u0019:f]R\u001cVm]:j_:\u001cF/\u0019;f+\u0005)\bcA2lmB\u0011q/_\u0007\u0002q*\u0011aKR\u0005\u0003ub\u0014AbU3tg&|gn\u0015;bi\u0016\f1\u0003]1sK:$8+Z:tS>t7\u000b^1uK\u0002B#A\u00022\u0002\u001d1|\u0017\r\u001a+fgR$\u0016M\u00197fgV\tq\u0010E\u0002d\u0003\u0003I1!a\u0001e\u0005\u001d\u0011un\u001c7fC:\fq\u0002\\8bIR+7\u000f\u001e+bE2,7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015\u0005-\u0011QBA\b\u0003#\t\u0019\u0002\u0005\u0002o\u0001!)\u0011,\u0003a\u00019\")\u0001.\u0003a\u0001U\")1/\u0003a\u0001k\")Q0\u0003a\u0001\u007fR1\u00111BA\f\u00033AQ!\u0017\u0006A\u0002qCQ! \u0006A\u0002}$\u0002\"a\u0003\u0002\u001e\u0005}\u0011q\u0006\u0005\u00063.\u0001\r\u0001\u0018\u0005\b\u0003CY\u0001\u0019AA\u0012\u0003)A\u0017N^3DY&,g\u000e\u001e\t\u0005\u0003K\tY#\u0004\u0002\u0002()\u0019\u0011\u0011\u0006#\u0002\r\rd\u0017.\u001a8u\u0013\u0011\ti#a\n\u0003\u0015!Kg/Z\"mS\u0016tG\u000fC\u0003~\u0017\u0001\u0007q0A\u0006tQ\u0006\u0014X\rZ*uCR,W#A7)\u00051\u0011\u0017\u0001D:fgNLwN\\*uCR,W#\u0001<)\u00055\u0011\u0017\u0001D7fi\u0006$\u0017\r^1ISZ,WCAA\u0012)\u0011\t\u0019%a\u001a\u0011\t\u0005\u0015\u0013\u0011\r\b\u0005\u0003\u000f\niF\u0004\u0003\u0002J\u0005mc\u0002BA&\u00033rA!!\u0014\u0002X9!\u0011qJA+\u001b\t\t\tFC\u0002\u0002Ti\u000ba\u0001\u0010:p_Rt\u0014\"A'\n\u0005-c\u0015BA%K\u0013\t9\u0005*C\u0002\u0002`\u0019\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002d\u0005\u0015$!\u0003#bi\u00064%/Y7f\u0015\r\tyF\u0012\u0005\b\u0003Sz\u0001\u0019AA6\u0003\u001d\u0019\u0018\u000f\u001c+fqR\u0004B!!\u001c\u0002v9!\u0011qNA9!\r\ty\u0005Z\u0005\u0004\u0003g\"\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002x\u0005e$AB*ue&twMC\u0002\u0002t\u0011\f!B\\3x'\u0016\u001c8/[8o)\t\tY!\u0001\u0007dY>tWmU3tg&|g\u000eF\u0001P\u0003-\u0019\u0017m\u00195f)\u0006\u0014G.Z:\u0002\u001f\r\f7\r[3UC\ndWm]0%KF$B!!#\u0002\u0010B\u00191-a#\n\u0007\u00055EM\u0001\u0003V]&$\b\u0002CAI'\u0005\u0005\t\u0019A@\u0002\u0007a$\u0013'\u0001\u0007dC\u000eDW\rV1cY\u0016\u001c\b%\u0001\btKR\u001c\u0015m\u00195f)\u0006\u0014G.Z:\u0015\t\u0005%\u0015\u0011\u0014\u0005\u0007\u00037+\u0002\u0019A@\u0002\u0003\r\f\u0001\u0002[5wK\"{W.Z\u000b\u0003\u0003C\u0003BaY6\u0002$B!\u0011QUAX\u001b\t\t9K\u0003\u0003\u0002*\u0006-\u0016AA5p\u0015\t\ti+\u0001\u0003kCZ\f\u0017\u0002BAY\u0003O\u0013AAR5mK\u0006Y\u0001.\u001b<f\t\u00164\bj\\7f\u00031)gN\u001e,beR{g)\u001b7f)\u0011\t\t+!/\t\u000f\u0005m\u0006\u00041\u0001\u0002l\u00051QM\u001c<WCJ\fQ\u0002[5wK\u001aKG.Z:UK6\u0004XCAAR\u00039A\u0017N^3GS2,7\u000fV3na\u0002\n1bZ3u\u0011&4XMR5mKR!\u00111UAd\u0011\u001d\tIm\u0007a\u0001\u0003W\nA\u0001]1uQ\u0006i\u0011/^8uK\"Kg/\u001a$jY\u0016$B!a4\u0002ZB!\u0011\u0011[Al\u001b\t\t\u0019N\u0003\u0003\u0002V\u0006-\u0016\u0001\u00027b]\u001eLA!a\u001e\u0002T\"9\u0011\u0011\u001a\u000fA\u0002\u0005-\u0014\u0001E4fi^\u000b'/\u001a5pkN,\u0007+\u0019;i)\t\tY'\u0001\beKN\u001c'/\u001b2fIR\u000b'\r\\3\u0016\u0005\u0005\r\b\u0003BAs\u0003_l!!a:\u000b\t\u0005%\u00181^\u0001\t[\u0006$8\r[5oO*\u0019\u0011Q\u001e3\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003c\f9OA\u0003SK\u001e,\u00070A\beKN\u001c'/\u001b2fIR\u000b'\r\\3!\u0005%!Vm\u001d;UC\ndWmE\u0004!\u0003s\fyP!\u0002\u0011\u0007\r\fY0C\u0002\u0002~\u0012\u0014a!\u00118z%\u00164\u0007cA2\u0003\u0002%\u0019!1\u00013\u0003\u000fA\u0013x\u000eZ;diB!!q\u0001B\b\u001d\u0011\u0011IA!\u0004\u000f\t\u0005=#1B\u0005\u0002K&\u0019\u0011q\f3\n\t\tE!1\u0003\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0004\u0003?\"\u0017\u0001\u00028b[\u0016,\"!a\u001b\u0002\u000b9\fW.\u001a\u0011\u0002\u0011\r|W.\\1oIN,\"Aa\b\u0011\u000b\r\u0014\tC!\n\n\u0007\t\rBM\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002Ra\u0019B\u0014\u0003\u0013K1A!\u000be\u0005%1UO\\2uS>t\u0007'A\u0005d_6l\u0017M\u001c3tAQ1!q\u0006B\u001a\u0005k\u00012A!\r!\u001b\u0005\u0001\u0001b\u0002B\u000bK\u0001\u0007\u00111\u000e\u0005\b\u00057)\u0003\u0019\u0001B\u0010\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011qZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005\u007f\u00012a\u0019B!\u0013\r\u0011\u0019\u0005\u001a\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005\u0013\u0012y\u0005E\u0002d\u0005\u0017J1A!\u0014e\u0005\r\te.\u001f\u0005\n\u0003#C\u0013\u0011!a\u0001\u0005\u007f\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005+\u0002bAa\u0016\u0003^\t%SB\u0001B-\u0015\r\u0011Y\u0006Z\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B0\u00053\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019qP!\u001a\t\u0013\u0005E%&!AA\u0002\t%\u0013A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a4\u0003l!I\u0011\u0011S\u0016\u0002\u0002\u0003\u0007!qH\u0001\tQ\u0006\u001c\bnQ8eKR\u0011!qH\u0001\ti>\u001cFO]5oOR\u0011\u0011qZ\u0001\u0007KF,\u0018\r\\:\u0015\u0007}\u0014I\bC\u0005\u0002\u0012:\n\t\u00111\u0001\u0003J\u0005IA+Z:u)\u0006\u0014G.\u001a\t\u0004\u0005c\u00014#\u0002\u0019\u0003\u0002\n5\u0005C\u0003BB\u0005\u0013\u000bYGa\b\u000305\u0011!Q\u0011\u0006\u0004\u0005\u000f#\u0017a\u0002:v]RLW.Z\u0005\u0005\u0005\u0017\u0013)IA\tBEN$(/Y2u\rVt7\r^5p]J\u0002B!!*\u0003\u0010&!!\u0011CAT)\t\u0011i(A\u0003baBd\u0017\u0010\u0006\u0004\u00030\t]%\u0011\u0014\u0005\b\u0005+\u0019\u0004\u0019AA6\u0011\u001d\u0011Yb\ra\u0001\u0005?\t!\"\u001e8baBd\u0017pU3r)\u0011\u0011yJ!,\u0011\t\r\\'\u0011\u0015\t\bG\n\r\u00161\u000eBT\u0013\r\u0011)\u000b\u001a\u0002\u0007)V\u0004H.\u001a\u001a\u0011\r\t\u001d!\u0011\u0016B\u0013\u0013\u0011\u0011YKa\u0005\u0003\u0007M+\u0017\u000fC\u0005\u00030R\n\t\u00111\u0001\u00030\u0005\u0019\u0001\u0010\n\u0019\u0003\rM\u000bHnQ7e'\r)\u0014\u0011 \u000b\u0005\u0005o\u0013I\fE\u0002\u00032UBaaR\u001cA\u0002\u0005-\u0014aA2nIV\u0011!QE\u0001\u0007'Fd7)\u001c3\u0015\t\t]&1\u0019\u0005\u0007\u000ff\u0002\r!a\u001b\u0002\u0015Q,7\u000f\u001e+bE2,7/\u0006\u0002\u0003JBA!1\u001aBi\u0003W\u0012y#\u0004\u0002\u0003N*!!q\u001aB-\u0003\u001diW\u000f^1cY\u0016LAAa5\u0003N\n9\u0001*Y:i\u001b\u0006\u0004\bF\u0001\u001ec\u0003E\u0011XmZ5ti\u0016\u0014H+Z:u)\u0006\u0014G.\u001a\u000b\u0005\u0003\u0013\u0013Y\u000eC\u0004\u0003^n\u0002\rAa\f\u0002\u0013Q,7\u000f\u001e+bE2,\u0017aD4fi2{\u0017\rZ3e)\u0006\u0014G.Z:\u0016\u0005\t\r\bC\u0002Bf\u0005K\fY'\u0003\u0003\u0003h\n5'a\u0002%bg\"\u001cV\r^\u0001\u000eY>\fG\rV3tiR\u000b'\r\\3\u0015\t\u0005%%Q\u001e\u0005\b\u0005+i\u0004\u0019AA6\u00031y'/[4j]\u0006dW\u000b\u0012$t+\t\u0011\u0019\u0010\u0005\u0004\u0003v\ne\u00181N\u0007\u0003\u0005oTA!!<\u0002,&!!1 B|\u0005\r\u0019V\r^\u0001\u000e_JLw-\u001b8bYV#ei\u001d\u0011\u0002\u000bI,7/\u001a;\u0015\u0005\u0005%\u0005")
public class TestHiveSparkSession
extends SparkSession {
    private transient TestHiveSharedState sharedState;
    private transient SessionState sessionState;
    private HiveClient metadataHive;
    private Option<File> hiveHome;
    private Option<File> hiveDevHome;
    private volatile TestHiveSparkSession$TestTable$ TestTable$module;
    private transient HashMap<String, TestTable> testTables;
    private final transient SparkContext sc;
    private transient Option<TestHiveSharedState> existingSharedState;
    private final transient Option<SessionState> parentSessionState;
    private final boolean loadTestTables;
    private boolean cacheTables;
    private final File hiveFilesTemp;
    private final Regex describedTable;
    private final Set<String> originalUDFs;
    private volatile transient byte bitmap$trans$0;
    private volatile byte bitmap$0;

    public TestHiveSparkSession$TestTable$ TestTable() {
        if (this.TestTable$module == null) {
            this.TestTable$lzycompute$1();
        }
        return this.TestTable$module;
    }

    private SparkContext sc() {
        return this.sc;
    }

    private Option<TestHiveSharedState> existingSharedState() {
        return this.existingSharedState;
    }

    private Option<SessionState> parentSessionState() {
        return this.parentSessionState;
    }

    private boolean loadTestTables() {
        return this.loadTestTables;
    }

    private TestHiveSharedState sharedState$lzycompute() {
        TestHiveSparkSession testHiveSparkSession = this;
        synchronized (testHiveSparkSession) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.sharedState = (TestHiveSharedState)((Object)this.existingSharedState().getOrElse((Function0 & Serializable)() -> new TestHiveSharedState(this.sc(), TestHiveSharedState$.MODULE$.$lessinit$greater$default$2())));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        this.existingSharedState = null;
        return this.sharedState;
    }

    public TestHiveSharedState sharedState() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.sharedState$lzycompute() : this.sharedState;
    }

    private SessionState sessionState$lzycompute() {
        TestHiveSparkSession testHiveSparkSession = this;
        synchronized (testHiveSparkSession) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.sessionState = new TestHiveSessionStateBuilder(this, this.parentSessionState()).build();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.sessionState;
    }

    public SessionState sessionState() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.sessionState$lzycompute() : this.sessionState;
    }

    private HiveClient metadataHive$lzycompute() {
        TestHiveSparkSession testHiveSparkSession = this;
        synchronized (testHiveSparkSession) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.metadataHive = ((HiveExternalCatalog)this.sharedState().externalCatalog().unwrapped()).client().newSession();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.metadataHive;
    }

    public HiveClient metadataHive() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.metadataHive$lzycompute() : this.metadataHive;
    }

    public Dataset<Row> sql(String sqlText) {
        return (Dataset)this.withActive((Function0 & Serializable)() -> {
            LogicalPlan plan = this.sessionState().sqlParser().parsePlan(sqlText);
            return Dataset$.MODULE$.ofRows((SparkSession)this, plan);
        });
    }

    public TestHiveSparkSession newSession() {
        return (TestHiveSparkSession)((Object)this.withActive((Function0 & Serializable)() -> new TestHiveSparkSession(this.sc(), (Option<TestHiveSharedState>)new Some((Object)this.sharedState()), (Option<SessionState>)None$.MODULE$, this.loadTestTables())));
    }

    public SparkSession cloneSession() {
        return (SparkSession)this.withActive((Function0 & Serializable)() -> {
            void var1_1;
            TestHiveSparkSession result = new TestHiveSparkSession(this.sparkContext(), (Option<TestHiveSharedState>)new Some((Object)this.sharedState()), (Option<SessionState>)new Some((Object)this.sessionState()), this.loadTestTables());
            result.sessionState();
            return var1_1;
        });
    }

    private boolean cacheTables() {
        return this.cacheTables;
    }

    private void cacheTables_$eq(boolean x$1) {
        this.cacheTables = x$1;
    }

    public void setCacheTables(boolean c) {
        this.cacheTables_$eq(c);
    }

    private Option<File> hiveHome$lzycompute() {
        TestHiveSparkSession testHiveSparkSession = this;
        synchronized (testHiveSparkSession) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.hiveHome = this.envVarToFile("HIVE_HOME");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.hiveHome;
    }

    public Option<File> hiveHome() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.hiveHome$lzycompute() : this.hiveHome;
    }

    private Option<File> hiveDevHome$lzycompute() {
        TestHiveSparkSession testHiveSparkSession = this;
        synchronized (testHiveSparkSession) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.hiveDevHome = this.envVarToFile("HIVE_DEV_HOME");
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.hiveDevHome;
    }

    public Option<File> hiveDevHome() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.hiveDevHome$lzycompute() : this.hiveDevHome;
    }

    private Option<File> envVarToFile(String envVar) {
        return Option$.MODULE$.apply((Object)System.getenv(envVar)).map((Function1 & Serializable)x$1 -> new File((String)x$1));
    }

    public File hiveFilesTemp() {
        return this.hiveFilesTemp;
    }

    public File getHiveFile(String path) {
        return new File(Thread.currentThread().getContextClassLoader().getResource(path).getFile());
    }

    private String quoteHiveFile(String path) {
        return Utils$.MODULE$.isWindows() ? this.getHiveFile(path).getPath().replace('\\', '/') : this.getHiveFile(path).getPath();
    }

    public String getWarehousePath() {
        SQLConf tempConf = new SQLConf();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.sc().conf().getAll()), (Function1 & Serializable)x0$1 -> {
            TestHiveSparkSession.$anonfun$getWarehousePath$1(tempConf, x0$1);
            return BoxedUnit.UNIT;
        });
        return tempConf.warehousePath();
    }

    public Regex describedTable() {
        return this.describedTable;
    }

    public SqlCmd SqlCmd(String sql) {
        return new SqlCmd(this, sql);
    }

    private HashMap<String, TestTable> testTables$lzycompute() {
        TestHiveSparkSession testHiveSparkSession = this;
        synchronized (testHiveSparkSession) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.testTables = new HashMap();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.testTables;
    }

    public HashMap<String, TestTable> testTables() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.testTables$lzycompute() : this.testTables;
    }

    public void registerTestTable(TestTable testTable) {
        this.testTables().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testTable.name()), (Object)testTable));
    }

    public HashSet<String> getLoadedTables() {
        return this.sharedState().loadedTables();
    }

    public void loadTestTable(String name) {
        block3: {
            Object object;
            if (!this.sessionState().catalog().getTempView(name).isEmpty() || this.sharedState().loadedTables().contains((Object)name)) break block3;
            this.sharedState().loadedTables().$plus$eq((Object)name);
            this.logDebug((Function0 & Serializable)() -> new StringBuilder(19).append("Loading test table ").append(name).toString());
            Seq createCmds = (Seq)this.testTables().get((Object)name).map((Function1 & Serializable)x$2 -> x$2.commands()).getOrElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.error(new StringBuilder(19).append("Unknown test table ").append(name).toString()));
            if (this.sparkContext().getLocalProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY()) == null) {
                object = SQLExecution$.MODULE$.withNewExecutionId(new QueryExecution((SparkSession)this, (LogicalPlan)new OneRowRelation(), QueryExecution$.MODULE$.$lessinit$greater$default$3(), QueryExecution$.MODULE$.$lessinit$greater$default$4()), SQLExecution$.MODULE$.withNewExecutionId$default$2(), (Function0)(JFunction0.mcV.sp & Serializable)() -> createCmds.foreach((Function1 & Serializable)x$3 -> {
                    x$3.apply$mcV$sp();
                    return BoxedUnit.UNIT;
                }));
            } else {
                createCmds.foreach((Function1 & Serializable)x$4 -> {
                    x$4.apply$mcV$sp();
                    return BoxedUnit.UNIT;
                });
                object = BoxedUnit.UNIT;
            }
            if (this.cacheTables()) {
                new SQLContext((SparkSession)this).cacheTable(name);
            }
        }
    }

    public Set<String> originalUDFs() {
        return this.originalUDFs;
    }

    public void reset() {
        try {
            ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(((LoggerContext)LogManager.getContext((boolean)false)).getConfiguration().getLoggers()).asScala()).foreach((Function1 & Serializable)x0$1 -> {
                TestHiveSparkSession.$anonfun$reset$1(x0$1);
                return BoxedUnit.UNIT;
            });
            File warehouseDir = new File(new URI(this.sparkContext().conf().get(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key())).getPath());
            Utils$.MODULE$.deleteRecursively(warehouseDir);
            warehouseDir.mkdir();
            this.sharedState().cacheManager().clearCache();
            this.sharedState().loadedTables().clear();
            this.sessionState().catalog().reset();
            this.metadataHive().reset();
            Configuration hadoopConf = this.sessionState().newHadoopConf();
            Path location = new Path(hadoopConf.get(HiveConf.ConfVars.SCRATCHDIR.varname));
            FileSystem fs = location.getFileSystem(hadoopConf);
            fs.delete(location, true);
            this.sessionState().conf().setConfString("fs.defaultFS", new File(".").toURI().toString());
            this.metadataHive().runSqlHive("RESET");
            this.metadataHive().runSqlHive("set hive.table.parameters.default=");
            this.metadataHive().runSqlHive("set hive.metastore.partition.name.whitelist.pattern=.*");
            this.sessionState().catalog().setCurrentDatabase("default");
        }
        catch (Exception e) {
            this.logError((Function0 & Serializable)() -> "FATAL ERROR: Failed to reset TestDB state.", e);
        }
    }

    private final void TestTable$lzycompute$1() {
        TestHiveSparkSession testHiveSparkSession = this;
        synchronized (testHiveSparkSession) {
            if (this.TestTable$module == null) {
                this.TestTable$module = new TestHiveSparkSession$TestTable$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$new$2(TestHiveSparkSession $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        $this.sc().hadoopConfiguration().set(k, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$getWarehousePath$1(SQLConf tempConf$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        tempConf$1.setConfString(k, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final String createTableSQL$1(String tblName) {
        return new StringBuilder(56).append("CREATE TABLE ").append(tblName).append(" (key INT, value STRING) STORED AS textfile").toString();
    }

    public static final /* synthetic */ void $anonfun$new$5(TestHiveSparkSession $this, String ds$1, String hr) {
        $this.SqlCmd(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(118).append("\n             |LOAD DATA LOCAL INPATH '").append($this.quoteHiveFile("data/files/kv1.txt")).append("'\n             |OVERWRITE INTO TABLE srcpart PARTITION (ds='").append(ds$1).append("',hr='").append(hr).append("')\n          ").toString()))).cmd().apply$mcV$sp();
    }

    public static final /* synthetic */ void $anonfun$new$4(TestHiveSparkSession $this, String ds) {
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"11", "12"})).foreach((Function1 & Serializable)hr -> {
            TestHiveSparkSession.$anonfun$new$5($this, ds, hr);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$7(TestHiveSparkSession $this, String ds) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(11), 12).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)hr -> $this.SqlCmd(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(119).append("\n             |LOAD DATA LOCAL INPATH '").append($this.quoteHiveFile("data/files/kv1.txt")).append("'\n             |OVERWRITE INTO TABLE srcpart1 PARTITION (ds='").append(ds).append("',hr='").append(hr).append("')\n          ").toString()))).cmd().apply$mcV$sp());
    }

    public static final /* synthetic */ void $anonfun$reset$1(Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            LoggerConfig log = (LoggerConfig)tuple2._2();
            if (!log.getName().contains("org.apache.spark")) {
                log.setLevel(Level.WARN);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public TestHiveSparkSession(SparkContext sc, Option<TestHiveSharedState> existingSharedState, Option<SessionState> parentSessionState, boolean loadTestTables) {
        this.sc = sc;
        this.existingSharedState = existingSharedState;
        this.parentSessionState = parentSessionState;
        this.loadTestTables = loadTestTables;
        super(sc);
        SparkSession$.MODULE$.setDefaultSession((SparkSession)this);
        SparkSession$.MODULE$.setActiveSession((SparkSession)this);
        Map metastoreTempConf = (Map)((MapOps)HiveUtils$.MODULE$.newTemporaryConfiguration(false).$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_INTEGER_JDO_PUSHDOWN.varname), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.SCRATCHDIR.varname), (Object)TestHiveContext$.MODULE$.makeScratchDir().toURI().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_CLIENT_CONNECT_RETRY_DELAY.varname), (Object)"1")})))).$plus$plus((IterableOnce)existingSharedState.map((Function1 & Serializable)state -> {
            String connKey = state.sparkContext().hadoopConfiguration().get(HiveConf.ConfVars.METASTORECONNECTURLKEY.varname);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORECONNECTURLKEY.varname), (Object)connKey);
        }));
        metastoreTempConf.foreach((Function1 & Serializable)x0$1 -> {
            TestHiveSparkSession.$anonfun$new$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
        Object object = sc.conf().get(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION());
        String string = "hive";
        Predef$.MODULE$.assert(!(object != null ? !object.equals(string) : string != null));
        this.cacheTables = false;
        System.clearProperty("spark.hostPort");
        Object object2 = parentSessionState.isEmpty() ? System.setProperty("test.tmp.dir", Utils$.MODULE$.createTempDir().toURI().getPath()) : BoxedUnit.UNIT;
        this.hiveFilesTemp = File.createTempFile("catalystHiveFiles", "");
        this.hiveFilesTemp().delete();
        this.hiveFilesTemp().mkdir();
        ShutdownHookManager$.MODULE$.registerShutdownDeleteDir(this.hiveFilesTemp());
        this.describedTable = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("DESCRIBE (\\w+)"));
        if (loadTestTables) {
            Seq hiveQTestUtilTables = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TestTable[]{new TestTable(this, "src", (Seq<Function0<BoxedUnit>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(TestHiveSparkSession.createTableSQL$1("src")).cmd(), this.SqlCmd(new StringBuilder(40).append("LOAD DATA LOCAL INPATH '").append(this.quoteHiveFile("data/files/kv1.txt")).append("' INTO TABLE src").toString()).cmd()})), new TestTable(this, "src1", (Seq<Function0<BoxedUnit>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(TestHiveSparkSession.createTableSQL$1("src1")).cmd(), this.SqlCmd(new StringBuilder(41).append("LOAD DATA LOCAL INPATH '").append(this.quoteHiveFile("data/files/kv3.txt")).append("' INTO TABLE src1").toString()).cmd()})), new TestTable(this, "srcpart", (Seq<Function0<BoxedUnit>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable)() -> {
                this.SqlCmd(new StringBuilder(38).append(TestHiveSparkSession.createTableSQL$1("srcpart")).append(" PARTITIONED BY (ds STRING, hr STRING)").toString()).cmd().apply$mcV$sp();
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"2008-04-08", "2008-04-09"})).foreach((Function1 & Serializable)ds -> {
                    TestHiveSparkSession.$anonfun$new$4(this, ds);
                    return BoxedUnit.UNIT;
                });
            }})), new TestTable(this, "srcpart1", (Seq<Function0<BoxedUnit>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable)() -> {
                this.SqlCmd(new StringBuilder(35).append(TestHiveSparkSession.createTableSQL$1("srcpart1")).append(" PARTITIONED BY (ds STRING, hr INT)").toString()).cmd().apply$mcV$sp();
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"2008-04-08", "2008-04-09"})).foreach((Function1 & Serializable)ds -> {
                    TestHiveSparkSession.$anonfun$new$7(this, ds);
                    return BoxedUnit.UNIT;
                });
            }})), new TestTable(this, "src_thrift", (Seq<Function0<BoxedUnit>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable)() -> {
                this.SqlCmd(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(330).append("\n           |CREATE TABLE src_thrift(fake INT)\n           |ROW FORMAT SERDE '").append(ThriftDeserializer.class.getName()).append("'\n           |WITH SERDEPROPERTIES(\n           |  'serialization.class'='org.apache.spark.sql.hive.test.Complex',\n           |  'serialization.format'='").append(TBinaryProtocol.class.getName()).append("'\n           |)\n           |STORED AS\n           |INPUTFORMAT '").append(SequenceFileInputFormat.class.getName()).append("'\n           |OUTPUTFORMAT '").append(SequenceFileOutputFormat.class.getName()).append("'\n        ").toString()))).cmd().apply$mcV$sp();
                this.SqlCmd(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(81).append("\n           |LOAD DATA LOCAL INPATH '").append(this.quoteHiveFile("data/files/complex.seq")).append("'\n           |INTO TABLE src_thrift\n        ").toString()))).cmd().apply$mcV$sp();
            }})), new TestTable(this, "serdeins", (Seq<Function0<BoxedUnit>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(141).append("CREATE TABLE serdeins (key INT, value STRING)\n           |ROW FORMAT SERDE '").append(LazySimpleSerDe.class.getCanonicalName()).append("'\n           |WITH SERDEPROPERTIES ('field.delim'='\\t')\n         ").toString()))).cmd(), this.SqlCmd("INSERT OVERWRITE TABLE serdeins SELECT * FROM src").cmd()})), new TestTable(this, "episodes", (Seq<Function0<BoxedUnit>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE TABLE episodes (title STRING, air_date STRING, doctor INT)\n           |STORED AS avro\n           |TBLPROPERTIES (\n           |  'avro.schema.literal'='{\n           |    \"type\": \"record\",\n           |    \"name\": \"episodes\",\n           |    \"namespace\": \"testing.hive.avro.serde\",\n           |    \"fields\": [\n           |      {\n           |          \"name\": \"title\",\n           |          \"type\": \"string\",\n           |          \"doc\": \"episode title\"\n           |      },\n           |      {\n           |          \"name\": \"air_date\",\n           |          \"type\": \"string\",\n           |          \"doc\": \"initial date\"\n           |      },\n           |      {\n           |          \"name\": \"doctor\",\n           |          \"type\": \"int\",\n           |          \"doc\": \"main actor playing the Doctor in episode\"\n           |      }\n           |    ]\n           |  }'\n           |)\n         "))).cmd(), this.SqlCmd(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(80).append("\n           |LOAD DATA LOCAL INPATH '").append(this.quoteHiveFile("data/files/episodes.avro")).append("'\n           |INTO TABLE episodes\n         ").toString()))).cmd()})), new TestTable(this, "episodes_part", (Seq<Function0<BoxedUnit>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE TABLE episodes_part (title STRING, air_date STRING, doctor INT)\n           |PARTITIONED BY (doctor_pt INT)\n           |STORED AS avro\n           |TBLPROPERTIES (\n           |  'avro.schema.literal'='{\n           |    \"type\": \"record\",\n           |    \"name\": \"episodes\",\n           |    \"namespace\": \"testing.hive.avro.serde\",\n           |    \"fields\": [\n           |      {\n           |          \"name\": \"title\",\n           |          \"type\": \"string\",\n           |          \"doc\": \"episode title\"\n           |      },\n           |      {\n           |          \"name\": \"air_date\",\n           |          \"type\": \"string\",\n           |          \"doc\": \"initial date\"\n           |      },\n           |      {\n           |          \"name\": \"doctor\",\n           |          \"type\": \"int\",\n           |          \"doc\": \"main actor playing the Doctor in episode\"\n           |      }\n           |    ]\n           |  }'\n           |)\n         "))).cmd(), this.SqlCmd(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |ALTER TABLE episodes_part SET SERDEPROPERTIES (\n           |  'avro.schema.literal'='{\n           |    \"type\": \"record\",\n           |    \"name\": \"episodes\",\n           |    \"namespace\": \"testing.hive.avro.serde\",\n           |    \"fields\": [\n           |      {\n           |          \"name\": \"title\",\n           |          \"type\": \"string\",\n           |          \"doc\": \"episode title\"\n           |      },\n           |      {\n           |          \"name\": \"air_date\",\n           |          \"type\": \"string\",\n           |          \"doc\": \"initial date\"\n           |      },\n           |      {\n           |          \"name\": \"doctor\",\n           |          \"type\": \"int\",\n           |          \"doc\": \"main actor playing the Doctor in episode\"\n           |      }\n           |    ]\n           |  }'\n           |)\n          "))).cmd(), this.SqlCmd("\n          INSERT OVERWRITE TABLE episodes_part PARTITION (doctor_pt=1)\n          SELECT title, air_date, doctor FROM episodes\n        ").cmd()})), new TestTable(this, "src_json", (Seq<Function0<BoxedUnit>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE TABLE src_json (json STRING) STORED AS TEXTFILE\n         "))).cmd(), this.SqlCmd(new StringBuilder(45).append("LOAD DATA LOCAL INPATH '").append(this.quoteHiveFile("data/files/json.txt")).append("' INTO TABLE src_json").toString()).cmd()}))}));
            hiveQTestUtilTables.foreach((Function1 & Serializable)testTable -> {
                this.registerTestTable(testTable);
                return BoxedUnit.UNIT;
            });
        }
        this.originalUDFs = FunctionRegistry.getFunctionNames();
    }

    public TestHiveSparkSession(SparkContext sc, boolean loadTestTables) {
        this(sc, (Option<TestHiveSharedState>)None$.MODULE$, (Option<SessionState>)None$.MODULE$, loadTestTables);
    }

    public TestHiveSparkSession(SparkContext sc, HiveClient hiveClient, boolean loadTestTables) {
        this(sc, (Option<TestHiveSharedState>)new Some((Object)new TestHiveSharedState(sc, (Option<HiveClient>)new Some((Object)hiveClient))), (Option<SessionState>)None$.MODULE$, loadTestTables);
    }

    public class SqlCmd {
        private final String sql;
        public final /* synthetic */ TestHiveSparkSession $outer;

        public Function0<BoxedUnit> cmd() {
            return (JFunction0.mcV.sp & Serializable)() -> new TestHiveQueryExecution($this.sql).executedPlan().executeCollect();
        }

        public /* synthetic */ TestHiveSparkSession org$apache$spark$sql$hive$test$TestHiveSparkSession$SqlCmd$$$outer() {
            return this.$outer;
        }

        public SqlCmd(TestHiveSparkSession $outer, String sql) {
            this.sql = sql;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class TestTable
    implements Product,
    Serializable {
        private final String name;
        private final Seq<Function0<BoxedUnit>> commands;
        public final /* synthetic */ TestHiveSparkSession $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String name() {
            return this.name;
        }

        public Seq<Function0<BoxedUnit>> commands() {
            return this.commands;
        }

        public String productPrefix() {
            return "TestTable";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.name();
                    break;
                }
                case 1: {
                    object = this.commands();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TestTable;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "name";
                    break;
                }
                case 1: {
                    string = "commands";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TestTable)) return false;
            if (((TestTable)object).org$apache$spark$sql$hive$test$TestHiveSparkSession$TestTable$$$outer() != this.org$apache$spark$sql$hive$test$TestHiveSparkSession$TestTable$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            TestTable testTable = (TestTable)x$1;
            String string = this.name();
            String string2 = testTable.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Seq<Function0<BoxedUnit>> seq = this.commands();
            Seq<Function0<BoxedUnit>> seq2 = testTable.commands();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!testTable.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ TestHiveSparkSession org$apache$spark$sql$hive$test$TestHiveSparkSession$TestTable$$$outer() {
            return this.$outer;
        }

        public TestTable(TestHiveSparkSession $outer, String name, Seq<Function0<BoxedUnit>> commands) {
            this.name = name;
            this.commands = commands;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

