/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.CatalogTestUtils;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogSuite;
import org.apache.spark.sql.execution.QueryExecutionException;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.hive.HiveExternalCatalog;
import org.apache.spark.sql.hive.HiveExternalCatalog$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005Q2Aa\u0002\u0005\u0001'!)A\u0004\u0001C\u0001;!9\u0001\u0005\u0001b\u0001\n\u0013\t\u0003BB\u0013\u0001A\u0003%!\u0005C\u0004'\u0001\t\u0007I\u0011K\u0014\t\r-\u0002\u0001\u0015!\u0003)\u0011\u0015a\u0003\u0001\"\u0015.\u0005aA\u0015N^3FqR,'O\\1m\u0007\u0006$\u0018\r\\8h'VLG/\u001a\u0006\u0003\u0013)\tA\u0001[5wK*\u00111\u0002D\u0001\u0004gFd'BA\u0007\u000f\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ii\u0011A\u0006\u0006\u0003/a\tqaY1uC2|wM\u0003\u0002\u001a\u0015\u0005A1-\u0019;bYf\u001cH/\u0003\u0002\u001c-\t!R\t\u001f;fe:\fGnQ1uC2|wmU;ji\u0016\fa\u0001P5oSRtD#\u0001\u0010\u0011\u0005}\u0001Q\"\u0001\u0005\u0002\u001f\u0015DH/\u001a:oC2\u001c\u0015\r^1m_\u001e,\u0012A\t\t\u0003?\rJ!\u0001\n\u0005\u0003'!Kg/Z#yi\u0016\u0014h.\u00197DCR\fGn\\4\u0002!\u0015DH/\u001a:oC2\u001c\u0015\r^1m_\u001e\u0004\u0013!B;uS2\u001cX#\u0001\u0015\u0011\u0005UI\u0013B\u0001\u0016\u0017\u0005A\u0019\u0015\r^1m_\u001e$Vm\u001d;Vi&d7/\u0001\u0004vi&d7\u000fI\u0001\u000be\u0016\u001cX\r^*uCR,G#\u0001\u0018\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\tUs\u0017\u000e\u001e")
public class HiveExternalCatalogSuite
extends ExternalCatalogSuite {
    private final HiveExternalCatalog org$apache$spark$sql$hive$HiveExternalCatalogSuite$$externalCatalog;
    private final CatalogTestUtils utils;

    public HiveExternalCatalog org$apache$spark$sql$hive$HiveExternalCatalogSuite$$externalCatalog() {
        return this.org$apache$spark$sql$hive$HiveExternalCatalogSuite$$externalCatalog;
    }

    public CatalogTestUtils utils() {
        return this.utils;
    }

    public void resetState() {
        this.org$apache$spark$sql$hive$HiveExternalCatalogSuite$$externalCatalog().client().reset();
    }

    /*
     * WARNING - void declaration
     */
    public HiveExternalCatalogSuite() {
        void var1_1;
        HiveExternalCatalog catalog = new HiveExternalCatalog(new SparkConf(), new Configuration());
        catalog.client().reset();
        this.org$apache$spark$sql$hive$HiveExternalCatalogSuite$$externalCatalog = var1_1;
        this.utils = new CatalogTestUtils(this){
            private final String tableInputFormat;
            private final String tableOutputFormat;
            private final String defaultProvider;
            private final /* synthetic */ HiveExternalCatalogSuite $outer;

            public String tableInputFormat() {
                return this.tableInputFormat;
            }

            public String tableOutputFormat() {
                return this.tableOutputFormat;
            }

            public ExternalCatalog newEmptyCatalog() {
                return this.$outer.org$apache$spark$sql$hive$HiveExternalCatalogSuite$$externalCatalog();
            }

            public String defaultProvider() {
                return this.defaultProvider;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tableInputFormat = "org.apache.hadoop.mapred.SequenceFileInputFormat";
                this.tableOutputFormat = "org.apache.hadoop.mapred.SequenceFileOutputFormat";
                this.defaultProvider = "hive";
            }
        };
        this.test("SPARK-18647: do not put provider in table properties for Hive serde table", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogTable hiveTable = new CatalogTable(TableIdentifier$.MODULE$.apply("hive_tbl", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.MANAGED(), this.utils().storageFormat(), new StructType().add("col1", "int").add("col2", "string"), (Option)new Some((Object)"hive"), CatalogTable$.MODULE$.apply$default$6(), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19(), CatalogTable$.MODULE$.apply$default$20());
            catalog.createTable(hiveTable, false);
            CatalogTable rawTable = this.org$apache$spark$sql$hive$HiveExternalCatalogSuite$$externalCatalog().client().getTable("db1", "hive_tbl");
            Map $org_scalatest_assert_macro_left = rawTable.properties();
            String $org_scalatest_assert_macro_right = HiveExternalCatalog$.MODULE$.DATASOURCE_PROVIDER();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(DDLUtils$.MODULE$.isHiveTable(this.org$apache$spark$sql$hive$HiveExternalCatalogSuite$$externalCatalog().getTable("db1", "hive_tbl")), "org.apache.spark.sql.execution.command.DDLUtils.isHiveTable(HiveExternalCatalogSuite.this.externalCatalog.getTable(\"db1\", \"hive_tbl\"))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        }, new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"parquet", "hive"})).foreach((Function1 & Serializable)format -> {
            this.test(new StringBuilder(74).append("Partition columns should be put at the end of table schema for the format ").append(format).toString(), (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                ExternalCatalog catalog = $this.utils().newBasicCatalog();
                StructType newSchema = new StructType().add("col1", "int").add("col2", "string").add("partCol1", "int").add("partCol2", "string");
                CatalogTable table = new CatalogTable(TableIdentifier$.MODULE$.apply("tbl", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.MANAGED(), CatalogStorageFormat$.MODULE$.empty(), new StructType().add("col1", "int").add("partCol1", "int").add("partCol2", "string").add("col2", "string"), (Option)new Some((Object)format), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"partCol1", "partCol2"})), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19(), CatalogTable$.MODULE$.apply$default$20());
                catalog.createTable(table, false);
                CatalogTable restoredTable = $this.org$apache$spark$sql$hive$HiveExternalCatalogSuite$$externalCatalog().getTable("db1", "tbl");
                StructType $org_scalatest_assert_macro_left = restoredTable.schema();
                StructType $org_scalatest_assert_macro_right = newSchema;
                StructType structType = $org_scalatest_assert_macro_left;
                StructType structType2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            }, new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            return BoxedUnit.UNIT;
        });
        this.test("SPARK-22306: alter table schema should not erase the bucketing metadata at hive side", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String bucketString;
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.org$apache$spark$sql$hive$HiveExternalCatalogSuite$$externalCatalog().client().runSqlHive(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |CREATE TABLE db1.t(a string, b string)\n        |CLUSTERED BY (a, b) SORTED BY (a, b) INTO 10 BUCKETS\n        |STORED AS PARQUET\n      ")));
            StructType newSchema = new StructType().add("a", "string").add("b", "string").add("c", "string");
            catalog.alterTableDataSchema("db1", "t", newSchema);
            StructType $org_scalatest_assert_macro_left = catalog.getTable("db1", "t").schema();
            StructType $org_scalatest_assert_macro_right = newSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            String $org_scalatest_assert_macro_left2 = bucketString = (String)((IterableOps)this.org$apache$spark$sql$hive$HiveExternalCatalogSuite$$externalCatalog().client().runSqlHive("DESC FORMATTED db1.t").filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains("Num Buckets")))).head();
            String $org_scalatest_assert_macro_right2 = "10";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        }, new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        this.test("SPARK-30050: analyze/rename table should not erase the bucketing metadata at hive side", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String bucketString3;
            String bucketString2;
            String bucketString1;
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.org$apache$spark$sql$hive$HiveExternalCatalogSuite$$externalCatalog().client().runSqlHive(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |CREATE TABLE db1.t(a string, b string)\n        |CLUSTERED BY (a, b) SORTED BY (a, b) INTO 10 BUCKETS\n        |STORED AS PARQUET\n      ")));
            String $org_scalatest_assert_macro_left = bucketString1 = (String)((IterableOps)this.org$apache$spark$sql$hive$HiveExternalCatalogSuite$$externalCatalog().client().runSqlHive("DESC FORMATTED db1.t").filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains("Num Buckets")))).head();
            String $org_scalatest_assert_macro_right = "10";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            catalog.alterTableStats("db1", "t", (Option)None$.MODULE$);
            String $org_scalatest_assert_macro_left2 = bucketString2 = (String)((IterableOps)this.org$apache$spark$sql$hive$HiveExternalCatalogSuite$$externalCatalog().client().runSqlHive("DESC FORMATTED db1.t").filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.contains("Num Buckets")))).head();
            String $org_scalatest_assert_macro_right2 = "10";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
            catalog.renameTable("db1", "t", "t2");
            String $org_scalatest_assert_macro_left3 = bucketString3 = (String)((IterableOps)this.org$apache$spark$sql$hive$HiveExternalCatalogSuite$$externalCatalog().client().runSqlHive("DESC FORMATTED db1.t2").filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.contains("Num Buckets")))).head();
            String $org_scalatest_assert_macro_right3 = "10";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        }, new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        this.test("SPARK-23001: NullPointerException when running desc database", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogDatabase qual$1 = this.utils().newDb("dbWithNullDesc");
            Object x$1 = null;
            String x$2 = qual$1.copy$default$1();
            URI x$3 = qual$1.copy$default$3();
            Map x$4 = qual$1.copy$default$4();
            catalog.createDatabase(qual$1.copy(x$2, null, x$3, x$4), false);
            String $org_scalatest_assert_macro_left = catalog.getDatabase("dbWithNullDesc").description();
            String $org_scalatest_assert_macro_right = "";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        }, new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        this.test("SPARK-29498 CatalogTable to HiveTable should not change the table's ownership", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            String owner = "SPARK-29498";
            TableIdentifier x$5 = TableIdentifier$.MODULE$.apply("spark_29498", (Option)new Some((Object)"db1"));
            CatalogTableType x$6 = CatalogTableType$.MODULE$.MANAGED();
            CatalogStorageFormat x$7 = this.utils().storageFormat();
            String x$8 = owner;
            StructType x$9 = new StructType().add("i", "int");
            Some x$10 = new Some((Object)"hive");
            Seq x$11 = CatalogTable$.MODULE$.apply$default$6();
            Option x$12 = CatalogTable$.MODULE$.apply$default$7();
            long x$13 = CatalogTable$.MODULE$.apply$default$9();
            long x$14 = CatalogTable$.MODULE$.apply$default$10();
            String x$15 = CatalogTable$.MODULE$.apply$default$11();
            Map x$16 = CatalogTable$.MODULE$.apply$default$12();
            Option x$17 = CatalogTable$.MODULE$.apply$default$13();
            Option x$18 = CatalogTable$.MODULE$.apply$default$14();
            Option x$19 = CatalogTable$.MODULE$.apply$default$15();
            Seq x$20 = CatalogTable$.MODULE$.apply$default$16();
            boolean x$21 = CatalogTable$.MODULE$.apply$default$17();
            boolean x$22 = CatalogTable$.MODULE$.apply$default$18();
            Map x$23 = CatalogTable$.MODULE$.apply$default$19();
            Option x$24 = CatalogTable$.MODULE$.apply$default$20();
            CatalogTable hiveTable = new CatalogTable(x$5, x$6, x$7, x$9, (Option)x$10, x$11, x$12, x$8, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24);
            catalog.createTable(hiveTable, false);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(catalog.getTable("db1", "spark_29498").owner());
            String $org_scalatest_assert_macro_right = owner;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        }, new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        this.test("SPARK-30868 throw an exception if HiveClient#runSqlHive fails", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            HiveClient client = this.org$apache$spark$sql$hive$HiveExternalCatalogSuite$$externalCatalog().client();
            String jarPath = "file:///tmp/not_exists.jar";
            this.assertThrows((Function0 & Serializable)() -> client.runSqlHive(new StringBuilder(8).append("ADD JAR ").append(jarPath).toString()), ClassTag$.MODULE$.apply(QueryExecutionException.class), new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
            this.assertThrows((Function0 & Serializable)() -> client.runSqlHive("use db_not_exists"), ClassTag$.MODULE$.apply(QueryExecutionException.class), new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
            this.assertThrows((Function0 & Serializable)() -> client.runSqlHive("CREATE TABLE t(n into)"), ClassTag$.MODULE$.apply(QueryExecutionException.class), new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
            this.assertThrows((Function0 & Serializable)() -> client.runSqlHive("DESC FORMATED t"), ClassTag$.MODULE$.apply(QueryExecutionException.class), new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
            return this.assertThrows((Function0 & Serializable)() -> client.runSqlHive("INSERT overwrite directory \"fs://localhost/tmp\" select 1 as a"), ClassTag$.MODULE$.apply(QueryExecutionException.class), new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
        }, new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        this.test("SPARK-31061: alterTable should be able to change table provider/hive", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"parquet", "hive"})).foreach((Function1 & Serializable)provider -> {
                CatalogTable tableDDL = new CatalogTable(TableIdentifier$.MODULE$.apply("parq_tbl", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.MANAGED(), this.utils().storageFormat(), new StructType().add("col1", "int"), (Option)new Some(provider), CatalogTable$.MODULE$.apply$default$6(), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19(), CatalogTable$.MODULE$.apply$default$20());
                catalog.dropTable("db1", "parq_tbl", true, true);
                catalog.createTable(tableDDL, false);
                CatalogTable rawTable = this.org$apache$spark$sql$hive$HiveExternalCatalogSuite$$externalCatalog().getTable("db1", "parq_tbl");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(rawTable.provider());
                Some $org_scalatest_assert_macro_right = new Some(provider);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
                Some x$25 = new Some((Object)"foo");
                TableIdentifier x$26 = rawTable.copy$default$1();
                CatalogTableType x$27 = rawTable.copy$default$2();
                CatalogStorageFormat x$28 = rawTable.copy$default$3();
                StructType x$29 = rawTable.copy$default$4();
                Seq x$30 = rawTable.copy$default$6();
                Option x$31 = rawTable.copy$default$7();
                String x$32 = rawTable.copy$default$8();
                long x$33 = rawTable.copy$default$9();
                long x$34 = rawTable.copy$default$10();
                String x$35 = rawTable.copy$default$11();
                Map x$36 = rawTable.copy$default$12();
                Option x$37 = rawTable.copy$default$13();
                Option x$38 = rawTable.copy$default$14();
                Option x$39 = rawTable.copy$default$15();
                Seq x$40 = rawTable.copy$default$16();
                boolean x$41 = rawTable.copy$default$17();
                boolean x$42 = rawTable.copy$default$18();
                Map x$43 = rawTable.copy$default$19();
                Option x$44 = rawTable.copy$default$20();
                CatalogTable fooTable = rawTable.copy(x$26, x$27, x$28, x$29, (Option)x$25, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44);
                catalog.alterTable(fooTable);
                CatalogTable alteredTable = this.org$apache$spark$sql$hive$HiveExternalCatalogSuite$$externalCatalog().getTable("db1", "parq_tbl");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(alteredTable.provider());
                Some $org_scalatest_assert_macro_right2 = new Some((Object)"foo");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
            });
        }, new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
    }
}

