/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.sql.hive.execution.HiveComparisonTest;
import org.apache.spark.sql.hive.test.TestHive$;
import org.apache.spark.util.Utils$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005Y2AAB\u0004\u0001)!)q\u0004\u0001C\u0001A!9!\u0005\u0001b\u0001\n\u0013\u0019\u0003B\u0002\u0017\u0001A\u0003%A\u0005C\u0003.\u0001\u0011\u0005c\u0006C\u00036\u0001\u0011\u0005cF\u0001\u000fISZ,w+\u001b8e_^4UO\\2uS>t\u0017+^3ssN+\u0018\u000e^3\u000b\u0005!I\u0011!C3yK\u000e,H/[8o\u0015\tQ1\"\u0001\u0003iSZ,'B\u0001\u0007\u000e\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u001d=\tQa\u001d9be.T!\u0001E\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0012aA8sO\u000e\u00011c\u0001\u0001\u00163A\u0011acF\u0007\u0002\u000f%\u0011\u0001d\u0002\u0002\u0013\u0011&4XmQ8na\u0006\u0014\u0018n]8o)\u0016\u001cH\u000f\u0005\u0002\u001b;5\t1D\u0003\u0002\u001d#\u0005I1oY1mCR,7\u000f^\u0005\u0003=m\u0011aBQ3g_J,\u0017I\u001c3BMR,'/\u0001\u0004=S:LGO\u0010\u000b\u0002CA\u0011a\u0003A\u0001\fi\u0016\u001cH\u000fV3na\u0012K'/F\u0001%!\t)#&D\u0001'\u0015\t9\u0003&\u0001\u0002j_*\t\u0011&\u0001\u0003kCZ\f\u0017BA\u0016'\u0005\u00111\u0015\u000e\\3\u0002\u0019Q,7\u000f\u001e+f[B$\u0015N\u001d\u0011\u0002\u0013\t,gm\u001c:f\u00032dG#A\u0018\u0011\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0003\tUs\u0017\u000e^\u0001\tC\u001a$XM]!mY\u0002")
public class HiveWindowFunctionQuerySuite
extends HiveComparisonTest
implements BeforeAndAfter {
    private final File testTempDir;
    private AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private File testTempDir() {
        return this.testTempDir;
    }

    public void beforeAll() {
        super.beforeAll();
        TestHive$.MODULE$.setCacheTables(true);
        TestHive$.MODULE$.sql("DROP TABLE IF EXISTS part");
        TestHive$.MODULE$.sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |CREATE TABLE part(\n        |  p_partkey INT,\n        |  p_name STRING,\n        |  p_mfgr STRING,\n        |  p_brand STRING,\n        |  p_type STRING,\n        |  p_size INT,\n        |  p_container STRING,\n        |  p_retailprice DOUBLE,\n        |  p_comment STRING) USING hive\n      ")));
        String testData1 = TestHive$.MODULE$.getHiveFile("data/files/part_tiny.txt").getCanonicalPath();
        TestHive$.MODULE$.sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(68).append("\n        |LOAD DATA LOCAL INPATH '").append(testData1).append("' overwrite into table part\n      ").toString())));
        TestHive$.MODULE$.sql("DROP TABLE IF EXISTS over1k");
        TestHive$.MODULE$.sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |create table over1k(\n        |  t tinyint,\n        |  si smallint,\n        |  i int,\n        |  b bigint,\n        |  f float,\n        |  d double,\n        |  bo boolean,\n        |  s string,\n        |  ts timestamp,\n        |  dec decimal(4,2),\n        |  bin binary)\n        |row format delimited\n        |fields terminated by '|'\n      ")));
        String testData2 = TestHive$.MODULE$.getHiveFile("data/files/over1k").getCanonicalPath();
        TestHive$.MODULE$.sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(70).append("\n        |LOAD DATA LOCAL INPATH '").append(testData2).append("' overwrite into table over1k\n      ").toString())));
        TestHive$.MODULE$.sql("set hive.plan.serialization.format=kryo");
        TestHive$.MODULE$.sql(new StringBuilder(25).append("set fs.defaultFS=file://").append(this.testTempDir()).append("/").toString());
        TestHive$.MODULE$.sql("set mapreduce.jobtracker.address=local");
    }

    @Override
    public void afterAll() {
        try {
            TestHive$.MODULE$.setCacheTables(false);
            TestHive$.MODULE$.reset();
        }
        finally {
            super.afterAll();
        }
    }

    public HiveWindowFunctionQuerySuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.testTempDir = Utils$.MODULE$.createTempDir();
        this.createQueryTest("windowing_multipartitioning.q (deterministic) 1", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select s,\n      |rank() over (partition by s order by si) r,\n      |sum(b) over (partition by s order by si) sum\n      |from over1k\n      |order by s, r, sum;\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing_multipartitioning.q (deterministic) 3", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select s, sum(i) over (partition by s), sum(f) over (partition by si)\n      |from over1k where s = 'tom allen' or s = 'bob steinbeck';\n     ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing_multipartitioning.q (deterministic) 4", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select s, rank() over (partition by s order by bo),\n      |rank() over (partition by si order by bin desc) from over1k\n      |where s = 'tom allen' or s = 'bob steinbeck';\n     ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing_multipartitioning.q (deterministic) 5", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select s, sum(f) over (partition by i), row_number() over (order by f)\n      |from over1k where s = 'tom allen' or s = 'bob steinbeck';\n     ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing_multipartitioning.q (deterministic) 6", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select s, rank() over w1,\n      |rank() over w2\n      |from over1k\n      |where s = 'tom allen' or s = 'bob steinbeck'\n      |window\n      |w1 as (partition by s order by dec),\n      |w2 as (partition by si order by f) ;\n     ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing_navfn.q (deterministic)", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select s, row_number() over (partition by d order by dec) rn from over1k\n      |order by s, rn desc;\n      |select i, lead(s) over (partition by cast(bin as string) order by d,i desc) as l\n      |from over1k\n      |order by i desc, l;\n      |select i, lag(dec) over (partition by i order by s,i,dec) l from over1k\n      |order by i, l;\n      |select s, last_value(t) over (partition by d order by f) l from over1k\n      |order by s, l;\n      |select s, first_value(s) over (partition by bo order by s) f from over1k\n      |order by s, f;\n      |select t, s, i, last_value(i) over (partition by t order by s)\n      |from over1k where (s = 'oscar allen' or s = 'oscar carson') and t = 10;\n     ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing_ntile.q (deterministic)", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select i, ntile(10) over (partition by s order by i) n from over1k\n      |order by i, n;\n      |select s, ntile(100) over (partition by i order by s) n from over1k\n      |order by s, n;\n      |select f, ntile(4) over (partition by d order by f) n from over1k\n      |order by f, n;\n      |select d, ntile(1000) over (partition by dec order by d) n from over1k\n      |order by d, n;\n     ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing_udaf.q (deterministic)", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select s, min(i) over (partition by s) m from over1k\n      |order by s, m;\n      |select s, avg(f) over (partition by si order by s) a from over1k\n      |order by s, a;\n      |select s, avg(i) over (partition by t, b order by s) a from over1k\n      |order by s, a;\n      |select max(i) over w m from over1k\n      |order by m window w as (partition by f) ;\n      |select s, avg(d) over (partition by t order by f) a from over1k\n      |order by s, a;\n     ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing_windowspec.q (deterministic)", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select s, sum(b) over (partition by i order by s,b rows unbounded preceding) as sum\n      |from over1k order by s, sum;\n      |select s, sum(f) over (partition by d order by s,f rows unbounded preceding) as sum\n      |from over1k order by s, sum;\n      |select s, sum(f) over\n      |(partition by ts order by f range between current row and unbounded following) as sum\n      |from over1k order by s, sum;\n      |select s, avg(f)\n      |over (partition by ts order by s,f rows between current row and 5 following) avg\n      |from over1k order by s, avg;\n      |select s, avg(d) over\n      |(partition by t order by s,d desc rows between 5 preceding and 5 following) avg\n      |from over1k order by s, avg;\n      |select s, sum(i) over(partition by ts order by s) sum from over1k\n      |order by s, sum;\n      |select f, sum(f) over\n      |(partition by ts order by f range between unbounded preceding and current row) sum\n      |from over1k order by f, sum;\n      |select s, i, round(avg(d) over (partition by s order by i) / 10.0 , 2) avg\n      |from over1k order by s, i, avg;\n      |select s, i, round((avg(d) over  w1 + 10.0) - (avg(d) over w1 - 10.0),2) avg\n      |from over1k\n      |order by s, i, avg window w1 as (partition by s order by i);\n     ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing_rank.q (deterministic) 1", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select s, rank() over (partition by f order by t) r from over1k order by s, r;\n      |select s, dense_rank() over (partition by ts order by i,s desc) as r from over1k\n      |order by s desc, r desc;\n      |select s, cume_dist() over (partition by bo order by b,s) cd from over1k\n      |order by s, cd;\n      |select s, percent_rank() over (partition by dec order by f) r from over1k\n      |order by s desc, r desc;\n     ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing_rank.q (deterministic) 2", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select ts, dec, rnk\n      |from\n      |  (select ts, dec,\n      |          rank() over (partition by ts order by dec)  as rnk\n      |          from\n      |            (select other.ts, other.dec\n      |             from over1k other\n      |             join over1k on (other.b = over1k.b)\n      |            ) joined\n      |  ) ranked\n      |where rnk =  1\n      |order by ts, dec, rnk;\n     ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing_rank.q (deterministic) 3", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select ts, dec, rnk\n      |from\n      |  (select ts, dec,\n      |          rank() over (partition by ts order by dec)  as rnk\n      |          from\n      |            (select other.ts, other.dec\n      |             from over1k other\n      |             join over1k on (other.b = over1k.b)\n      |            ) joined\n      |  ) ranked\n      |where dec = 89.5\n      |order by ts, dec, rnk;\n     ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing_rank.q (deterministic) 4", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select ts, dec, rnk\n      |from\n      |  (select ts, dec,\n      |          rank() over (partition by ts order by dec)  as rnk\n      |          from\n      |            (select other.ts, other.dec\n      |             from over1k other\n      |             join over1k on (other.b = over1k.b)\n      |             where other.t < 10\n      |            ) joined\n      |  ) ranked\n      |where rnk = 1\n      |order by ts, dec, rnk;\n     ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 1. testWindowing", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select p_mfgr, p_name, p_size,\n      |rank() over(distribute by p_mfgr sort by p_name) as r,\n      |dense_rank() over(distribute by p_mfgr sort by p_name) as dr,\n      |sum(p_retailprice) over\n      |(distribute by p_mfgr sort by p_name rows between unbounded preceding and current row) as s1\n      |from part\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 2. testGroupByWithPartitioning", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select p_mfgr, p_name, p_size,\n      |min(p_retailprice),\n      |rank() over(distribute by p_mfgr sort by p_name)as r,\n      |dense_rank() over(distribute by p_mfgr sort by p_name) as dr,\n      |p_size, p_size - lag(p_size,1,p_size) over(distribute by p_mfgr sort by p_name) as deltaSz\n      |from part\n      |group by p_mfgr, p_name, p_size\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 3. testGroupByHavingWithSWQ", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select p_mfgr, p_name, p_size, min(p_retailprice),\n      |rank() over(distribute by p_mfgr sort by p_name) as r,\n      |dense_rank() over(distribute by p_mfgr sort by p_name) as dr,\n      |p_size, p_size - lag(p_size,1,p_size) over(distribute by p_mfgr sort by p_name) as deltaSz\n      |from part\n      |group by p_mfgr, p_name, p_size\n      |having p_size > 0\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 4. testCount", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select p_mfgr, p_name,\n      |count(p_size) over(distribute by p_mfgr sort by p_name) as cd\n      |from part\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 5. testCountWithWindowingUDAF", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select p_mfgr, p_name,\n      |rank() over(distribute by p_mfgr sort by p_name) as r,\n      |dense_rank() over(distribute by p_mfgr sort by p_name) as dr,\n      |count(p_size) over(distribute by p_mfgr sort by p_name) as cd,\n      |p_retailprice, sum(p_retailprice) over (distribute by p_mfgr sort by p_name\n      |                                  rows between unbounded preceding and current row) as s1,\n      |p_size, p_size - lag(p_size,1,p_size) over(distribute by p_mfgr sort by p_name) as deltaSz\n      |from part\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 6. testCountInSubQ", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select sub1.r, sub1.dr, sub1.cd, sub1.s1, sub1.deltaSz\n      |from (select p_mfgr, p_name,\n      |rank() over(distribute by p_mfgr sort by p_name) as r,\n      |dense_rank() over(distribute by p_mfgr sort by p_name) as dr,\n      |count(p_size) over(distribute by p_mfgr sort by p_name) as cd,\n      |p_retailprice, sum(p_retailprice) over (distribute by p_mfgr sort by p_name\n      |                                  rows between unbounded preceding and current row) as s1,\n      |p_size, p_size - lag(p_size,1,p_size) over(distribute by p_mfgr sort by p_name) as deltaSz\n      |from part\n      |) sub1\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 8. testMixedCaseAlias", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select p_mfgr, p_name, p_size,\n      |rank() over(distribute by p_mfgr sort by p_name, p_size desc) as R\n      |from part\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 9. testHavingWithWindowingNoGBY", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select p_mfgr, p_name, p_size,\n      |rank() over(distribute by p_mfgr sort by p_name) as r,\n      |dense_rank() over(distribute by p_mfgr sort by p_name) as dr,\n      |sum(p_retailprice) over (distribute by p_mfgr sort by p_name\n      |                        rows between unbounded preceding and current row)  as s1\n      |from part\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 10. testHavingWithWindowingCondRankNoGBY", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select p_mfgr, p_name, p_size,\n      |rank() over(distribute by p_mfgr sort by p_name) as r,\n      |dense_rank() over(distribute by p_mfgr sort by p_name) as dr,\n      |sum(p_retailprice) over (distribute by p_mfgr sort by p_name\n      |                        rows between unbounded preceding and current row) as s1\n      |from part\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 11. testFirstLast", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select  p_mfgr,p_name, p_size,\n      |sum(p_size) over (distribute by p_mfgr sort by p_name\n      |rows between current row and current row) as s2,\n      |first_value(p_size) over w1  as f,\n      |last_value(p_size, false) over w1  as l\n      |from part\n      |window w1 as (distribute by p_mfgr sort by p_name rows between 2 preceding and 2 following)\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 12. testFirstLastWithWhere", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select  p_mfgr,p_name, p_size,\n      |rank() over(distribute by p_mfgr sort by p_name) as r,\n      |sum(p_size) over (distribute by p_mfgr sort by p_name\n      |rows between current row and current row) as s2,\n      |first_value(p_size) over w1 as f,\n      |last_value(p_size, false) over w1 as l\n      |from part\n      |where p_mfgr = 'Manufacturer#3'\n      |window w1 as (distribute by p_mfgr sort by p_name rows between 2 preceding and 2 following)\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 13. testSumWindow", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select  p_mfgr,p_name, p_size,\n      |sum(p_size) over w1 as s1,\n      |sum(p_size) over (distribute by p_mfgr  sort by p_name\n      |rows between current row and current row)  as s2\n      |from part\n      |window w1 as (distribute by p_mfgr  sort by p_name rows between 2 preceding and 2 following)\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 14. testNoSortClause", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select  p_mfgr,p_name, p_size,\n      |rank() over(distribute by p_mfgr sort by p_name) as r,\n      |dense_rank() over(distribute by p_mfgr sort by p_name) as dr\n      |from part\n      |window w1 as (distribute by p_mfgr sort by p_name rows between 2 preceding and 2 following)\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 16. testMultipleWindows", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select  p_mfgr,p_name, p_size,\n      |rank() over(distribute by p_mfgr sort by p_name) as r,\n      |dense_rank() over(distribute by p_mfgr sort by p_name) as dr,\n      |cume_dist() over(distribute by p_mfgr sort by p_name) as cud,\n      |sum(p_size) over (distribute by p_mfgr sort by p_name\n      |range between unbounded preceding and current row) as s1,\n      |sum(p_size) over (distribute by p_mfgr sort by p_size\n      |range between 5 preceding and current row) as s2,\n      |first_value(p_size) over w1  as fv1\n      |from part\n      |window w1 as (distribute by p_mfgr sort by p_mfgr, p_name\n      |             rows between 2 preceding and 2 following)\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 17. testCountStar", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select  p_mfgr,p_name, p_size,\n      |count(*) over(distribute by p_mfgr sort by p_name ) as c,\n      |count(p_size) over(distribute by p_mfgr sort by p_name) as ca,\n      |first_value(p_size) over w1  as fvW1\n      |from part\n      |window w1 as (distribute by p_mfgr sort by p_mfgr, p_name\n      |             rows between 2 preceding and 2 following)\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 18. testUDAFs", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select  p_mfgr,p_name, p_size,\n      |sum(p_retailprice) over w1 as s,\n      |min(p_retailprice) over w1 as mi,\n      |max(p_retailprice) over w1 as ma,\n      |avg(p_retailprice) over w1 as ag\n      |from part\n      |window w1 as (distribute by p_mfgr sort by p_mfgr, p_name\n      |             rows between 2 preceding and 2 following)\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 19. testUDAFsWithGBY", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select  p_mfgr,p_name, p_size, p_retailprice,\n      |sum(p_retailprice) over w1 as s,\n      |min(p_retailprice) as mi ,\n      |max(p_retailprice) as ma ,\n      |avg(p_retailprice) over w1 as ag\n      |from part\n      |group by p_mfgr,p_name, p_size, p_retailprice\n      |window w1 as (distribute by p_mfgr sort by p_mfgr, p_name\n      |             rows between 2 preceding and 2 following);\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 21. testDISTs", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select  p_mfgr,p_name, p_size,\n      |histogram_numeric(p_retailprice, 5) over w1 as hist,\n      |percentile(p_partkey, cast(0.5 as double)) over w1 as per,\n      |row_number() over(distribute by p_mfgr sort by p_name) as rn\n      |from part\n      |window w1 as (distribute by p_mfgr sort by p_mfgr, p_name\n      |             rows between 2 preceding and 2 following)\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 24. testLateralViews", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select p_mfgr, p_name,\n      |lv_col, p_size, sum(p_size) over w1   as s\n      |from (select p_mfgr, p_name, p_size, array(1,2,3) arr from part) p\n      |lateral view explode(arr) part_lv as lv_col\n      |window w1 as (distribute by p_mfgr sort by p_size, lv_col\n      |             rows between 2 preceding and current row)\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 26. testGroupByHavingWithSWQAndAlias", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select p_mfgr, p_name, p_size, min(p_retailprice) as mi,\n      |rank() over(distribute by p_mfgr sort by p_name) as r,\n      |dense_rank() over(distribute by p_mfgr sort by p_name) as dr,\n      |p_size, p_size - lag(p_size,1,p_size) over(distribute by p_mfgr sort by p_name) as deltaSz\n      |from part\n      |group by p_mfgr, p_name, p_size\n      |having p_size > 0\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 27. testMultipleRangeWindows", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select  p_mfgr,p_name, p_size,\n      |sum(p_size) over (distribute by p_mfgr sort by p_size\n      |range between 10 preceding and current row) as s2,\n      |sum(p_size) over (distribute by p_mfgr sort by p_size\n      |range between current row and 10 following )  as s1\n      |from part\n      |window w1 as (rows between 2 preceding and 2 following)\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 28. testPartOrderInUDAFInvoke", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select p_mfgr, p_name, p_size,\n      |sum(p_size) over (partition by p_mfgr  order by p_name\n      |rows between 2 preceding and 2 following) as s\n      |from part\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 29. testPartOrderInWdwDef", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select p_mfgr, p_name, p_size,\n      |sum(p_size) over w1 as s\n      |from part\n      |window w1 as (partition by p_mfgr  order by p_name\n      |             rows between 2 preceding and 2 following)\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 30. testDefaultPartitioningSpecRules", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select p_mfgr, p_name, p_size,\n      |sum(p_size) over w1 as s,\n      |sum(p_size) over w2 as s2\n      |from part\n      |window w1 as (distribute by p_mfgr sort by p_name rows between 2 preceding and 2 following),\n      |       w2 as (partition by p_mfgr order by p_name)\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 36. testRankWithPartitioning", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select p_mfgr, p_name, p_size,\n      |rank() over (partition by p_mfgr order by p_name )  as r\n      |from part\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 37. testPartitioningVariousForms", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select p_mfgr,\n      |round(sum(p_retailprice) over (partition by p_mfgr order by p_mfgr),2) as s1,\n      |min(p_retailprice) over (partition by p_mfgr) as s2,\n      |max(p_retailprice) over (distribute by p_mfgr sort by p_mfgr) as s3,\n      |round(avg(p_retailprice) over (distribute by p_mfgr),2) as s4,\n      |count(p_retailprice) over (cluster by p_mfgr ) as s5\n      |from part\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 38. testPartitioningVariousForms2", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select p_mfgr, p_name, p_size,\n      |sum(p_retailprice) over (partition by p_mfgr, p_name order by p_mfgr, p_name\n      |rows between unbounded preceding and current row) as s1,\n      |min(p_retailprice) over (distribute by p_mfgr, p_name sort by p_mfgr, p_name\n      |rows between unbounded preceding and current row) as s2,\n      |max(p_retailprice) over (partition by p_mfgr, p_name order by p_name) as s3\n      |from part\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 39. testUDFOnOrderCols", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select p_mfgr, p_type, substr(p_type, 2) as short_ptype,\n      |rank() over (partition by p_mfgr order by substr(p_type, 2))  as r\n      |from part\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 40. testNoBetweenForRows", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select p_mfgr, p_name, p_size,\n      |sum(p_retailprice) over (distribute by p_mfgr sort by p_name rows unbounded preceding) as s1\n      |from part\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 41. testNoBetweenForRange", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select p_mfgr, p_name, p_size,\n      |sum(p_retailprice) over (distribute by p_mfgr sort by p_size range unbounded preceding) as s1\n      |from part\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 42. testUnboundedFollowingForRows", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select p_mfgr, p_name, p_size,\n      |sum(p_retailprice) over (distribute by p_mfgr sort by p_name\n      |rows between current row and unbounded following) as s1\n      |from part\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 43. testUnboundedFollowingForRange", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select p_mfgr, p_name, p_size,\n      |sum(p_retailprice) over (distribute by p_mfgr sort by p_size\n      |range between current row and unbounded following) as s1\n      |from part\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("windowing.q -- 44. testOverNoPartitionSingleAggregate", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select p_name, p_retailprice,\n      |round(avg(p_retailprice) over(),2)\n      |from part\n      |order by p_name\n    ")), false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        Statics.releaseFence();
    }
}

