/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.QueryTest$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.expressions.UserDefinedAggregateFunction;
import org.apache.spark.sql.expressions.Window;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.hive.test.TestHive$;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import test.org.apache.spark.sql.MyDoubleSum;

public class JavaDataFrameSuite {
    private transient SQLContext hc;
    Dataset<Row> df;

    private static void checkAnswer(Dataset<Row> actual, List<Row> expected) {
        QueryTest$.MODULE$.checkAnswer(actual, expected);
    }

    @Before
    public void setUp() throws IOException {
        this.hc = TestHive$.MODULE$;
        ArrayList<String> jsonObjects = new ArrayList<String>(10);
        for (int i = 0; i < 10; ++i) {
            jsonObjects.add("{\"key\":" + i + ", \"value\":\"str" + i + "\"}");
        }
        this.df = this.hc.read().json(this.hc.createDataset(jsonObjects, Encoders.STRING()));
        this.df.createOrReplaceTempView("window_table");
    }

    @After
    public void tearDown() throws IOException {
        if (this.hc != null) {
            this.hc.sql("DROP TABLE IF EXISTS window_table");
        }
    }

    @Test
    public void saveTableAndQueryIt() {
        JavaDataFrameSuite.checkAnswer((Dataset<Row>)this.df.select(new Column[]{functions.avg((String)"key").over(Window.partitionBy((String)"value", (String[])new String[0]).orderBy("key", new String[0]).rowsBetween(-1L, 1L))}), this.hc.sql("SELECT avg(key) OVER (PARTITION BY value       ORDER BY key       ROWS BETWEEN 1 preceding and 1 following) FROM window_table").collectAsList());
    }

    @Test
    public void testUDAF() {
        Dataset df = this.hc.range(0L, 100L).union(this.hc.range(0L, 100L)).select(new Column[]{functions.col((String)"id").as("value")});
        MyDoubleSum udaf = new MyDoubleSum();
        UserDefinedAggregateFunction registeredUDAF = this.hc.udf().register("mydoublesum", (UserDefinedAggregateFunction)udaf);
        Dataset aggregatedDF = df.groupBy(new Column[0]).agg(udaf.distinct(new Column[]{functions.col((String)"value")}), new Column[]{udaf.apply(new Column[]{functions.col((String)"value")}), registeredUDAF.apply(new Column[]{functions.col((String)"value")}), functions.callUDF((String)"mydoublesum", (Column[])new Column[]{functions.col((String)"value")})});
        ArrayList<Row> expectedResult = new ArrayList<Row>();
        expectedResult.add(RowFactory.create((Object[])new Object[]{4950.0, 9900.0, 9900.0, 9900.0}));
        JavaDataFrameSuite.checkAnswer((Dataset<Row>)aggregatedDF, expectedResult);
    }
}

