/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.time.ZoneId;
import org.apache.hadoop.hive.serde2.RegexSerDe;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.execution.command.CreateTableCommand;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.metric.InputOutputMetricsHelper$;
import org.apache.spark.sql.hive.execution.HiveComparisonTest;
import org.apache.spark.sql.hive.test.TestHive$;
import org.apache.spark.sql.internal.HiveSerDe$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.tags.SlowHiveTest;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@SlowHiveTest
@ScalaSignature(bytes="\u0006\u000554Aa\u0002\u0005\u0001+!)\u0001\u0006\u0001C\u0001S!)1\u0006\u0001C!Y!)1\u0007\u0001C\u0005i!)Q\n\u0001C\u0005\u001d\")\u0001\u000b\u0001C!#\"Ya\f\u0001I\u0001\u0004\u0003\u0005I\u0011B0d\u00059A\u0015N^3TKJ$UmU;ji\u0016T!!\u0003\u0006\u0002\u0013\u0015DXmY;uS>t'BA\u0006\r\u0003\u0011A\u0017N^3\u000b\u00055q\u0011aA:rY*\u0011q\u0002E\u0001\u0006gB\f'o\u001b\u0006\u0003#I\ta!\u00199bG\",'\"A\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u00011\"D\t\t\u0003/ai\u0011\u0001C\u0005\u00033!\u0011!\u0003S5wK\u000e{W\u000e]1sSN|g\u000eV3tiB\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0006a2\fgn\u001d\u0006\u0003?1\t\u0001bY1uC2L8\u000f^\u0005\u0003Cq\u0011\u0001\u0002\u00157b]R+7\u000f\u001e\t\u0003G\u0019j\u0011\u0001\n\u0006\u0003KI\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005\u001d\"#!\u0005\"fM>\u0014X-\u00118e\u0003\u001a$XM]!mY\u00061A(\u001b8jiz\"\u0012A\u000b\t\u0003/\u0001\t\u0011BY3g_J,\u0017\t\u001c7\u0015\u00035\u0002\"AL\u0019\u000e\u0003=R\u0011\u0001M\u0001\u0006g\u000e\fG.Y\u0005\u0003e=\u0012A!\u00168ji\u0006\u0001R\r\u001f;sC\u000e$H+\u00192mK\u0012+7o\u0019\u000b\u0003k\u0005\u0003BA\f\u001c9}%\u0011qg\f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005ebT\"\u0001\u001e\u000b\u0005mr\u0012aB2bi\u0006dwnZ\u0005\u0003{i\u0012AbQ1uC2|w\rV1cY\u0016\u0004\"AL \n\u0005\u0001{#a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u001b\r\u0001\rA\u0011\t\u0003\u0007*s!\u0001\u0012%\u0011\u0005\u0015{S\"\u0001$\u000b\u0005\u001d#\u0012A\u0002\u001fs_>$h(\u0003\u0002J_\u00051\u0001K]3eK\u001aL!a\u0013'\u0003\rM#(/\u001b8h\u0015\tIu&\u0001\nb]\u0006d\u0017P_3De\u0016\fG/\u001a+bE2,GC\u0001\u001dP\u0011\u0015iA\u00011\u0001C\u0003-9\u0018\u000e\u001e5T#2\u001buN\u001c4\u0015\u0005ICFCA\u0017T\u0011\u0019!V\u0001\"a\u0001+\u0006\ta\rE\u0002/-6J!aV\u0018\u0003\u0011q\u0012\u0017P\\1nKzBQ!W\u0003A\u0002i\u000bQ\u0001]1jeN\u00042AL.^\u0013\tavF\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002BA\f\u001cC\u0005\u0006\t2/\u001e9fe\u0012:\u0018\u000e\u001e5T#2\u001buN\u001c4\u0015\u0005\u0001\u0014GCA\u0017b\u0011\u0019!f\u0001\"a\u0001+\")\u0011L\u0002a\u00015&\u0011\u0001\u000bZ\u0005\u0003Kr\u0011\u0011bU)M\u0011\u0016d\u0007/\u001a:)\u0005\u00019\u0007C\u00015l\u001b\u0005I'B\u00016\u000f\u0003\u0011!\u0018mZ:\n\u00051L'\u0001D*m_^D\u0015N^3UKN$\b")
public class HiveSerDeSuite
extends HiveComparisonTest
implements PlanTest {
    private String sparkHome;
    private volatile boolean bitmap$0;

    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$((PlanTestBase)this, (LogicalPlan)plan1, (LogicalPlan)plan2, (boolean)checkAnalysis);
    }

    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$((PlanTestBase)this);
    }

    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$((PlanTestBase)this, (Expression)e1, (Expression)e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    private String sparkHome$lzycompute() {
        HiveSerDeSuite hiveSerDeSuite = this;
        synchronized (hiveSerDeSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    private /* synthetic */ void super$withSQLConf(Seq pairs, Function0 f) {
        SQLHelper.withSQLConf$((SQLHelper)this, (Seq)pairs, (Function0)f);
    }

    public void beforeAll() {
        super.beforeAll();
        TestHive$.MODULE$.setCacheTables(false);
        TestHive$.MODULE$.sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(157).append("CREATE TABLE IF NOT EXISTS sales (key STRING, value INT)\n       |ROW FORMAT SERDE '").append(RegexSerDe.class.getCanonicalName()).append("'\n       |WITH SERDEPROPERTIES (\"input.regex\" = \"([^ ]*)\t([^ ]*)\")\n       ").toString())));
        TestHive$.MODULE$.sql(new StringBuilder(42).append("LOAD DATA LOCAL INPATH '").append(TestHive$.MODULE$.getHiveFile("data/files/sales.txt").toURI()).append("' INTO TABLE sales").toString());
    }

    private Tuple2<CatalogTable, Object> extractTableDesc(String sql) {
        return (Tuple2)TestHive$.MODULE$.sessionState().analyzer().execute(TestHive$.MODULE$.sessionState().sqlParser().parsePlan(sql)).collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof CreateTableCommand) {
                    CreateTableCommand createTableCommand = (CreateTableCommand)A1;
                    CatalogTable tableDesc = createTableCommand.table();
                    boolean ifNotExists = createTableCommand.ignoreIfExists();
                    object = new Tuple2((Object)tableDesc, (Object)BoxesRunTime.boxToBoolean((boolean)ifNotExists));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof CreateTableCommand;
                return bl;
            }
        }).head();
    }

    private CatalogTable analyzeCreateTable(String sql) {
        return (CatalogTable)TestHive$.MODULE$.sessionState().analyzer().execute(TestHive$.MODULE$.sessionState().sqlParser().parsePlan(sql)).collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof CreateTableCommand) {
                    CreateTableCommand createTableCommand = (CreateTableCommand)A1;
                    CatalogTable tableDesc = createTableCommand.table();
                    object = tableDesc;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof CreateTableCommand;
                return bl;
            }
        }).head();
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLConf$.MODULE$.withExistingConf(TestHive$.MODULE$.conf(), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.super$withSQLConf(pairs, f));
    }

    public HiveSerDeSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$((SQLHelper)this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$((PlanTestBase)this);
        this.createQueryTest("Read with RegexSerDe", "SELECT * FROM sales", false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("Read and write with LazySimpleSerDe (tab separated)", "SELECT * from serdeins", this.createQueryTest$default$3(), this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("Read with AvroSerDe", "SELECT * FROM episodes", this.createQueryTest$default$3(), this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("Read Partitioned with AvroSerDe", "SELECT * FROM episodes_part", this.createQueryTest$default$3(), this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.test("Checking metrics correctness", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            long episodesCnt = TestHive$.MODULE$.sql("select * from episodes").count();
            List episodesRes = InputOutputMetricsHelper$.MODULE$.run(TestHive$.MODULE$.sql("select * from episodes").toDF());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(episodesRes);
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)episodesCnt), (Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)episodesCnt));
            List $org_scalatest_assert_macro_right = package$.MODULE$.Nil().$colon$colon((Object)tuple3);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            long serdeinsCnt = TestHive$.MODULE$.sql("select * from serdeins").count();
            List serdeinsRes = InputOutputMetricsHelper$.MODULE$.run(TestHive$.MODULE$.sql("select * from serdeins").toDF());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(serdeinsRes);
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToLong((long)serdeinsCnt), (Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)serdeinsCnt));
            List $org_scalatest_assert_macro_right2 = package$.MODULE$.Nil().$colon$colon((Object)tuple32);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        }, new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.test("Test the default fileformat for Hive-serde tables", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.default.fileformat"), (Object)"orc")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Tuple2<CatalogTable, Object> tuple2 = this.extractTableDesc("CREATE TABLE IF NOT EXISTS fileformat_test (id int) USING hive");
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                CatalogTable desc = (CatalogTable)tuple2._1();
                boolean exists = tuple2._2$mcZ$sp();
                Tuple2 tuple22 = new Tuple2((Object)desc, (Object)BoxesRunTime.boxToBoolean((boolean)exists));
                Tuple2 tuple23 = tuple22;
                CatalogTable desc2 = (CatalogTable)tuple23._1();
                boolean exists2 = tuple23._2$mcZ$sp();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(exists2, "exists", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
                Option $org_scalatest_assert_macro_left = desc2.storage().inputFormat();
                Some $org_scalatest_assert_macro_right = new Some((Object)"org.apache.hadoop.hive.ql.io.orc.OrcInputFormat");
                Option option = $org_scalatest_assert_macro_left;
                Some some = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
                Option $org_scalatest_assert_macro_left2 = desc2.storage().outputFormat();
                Some $org_scalatest_assert_macro_right2 = new Some((Object)"org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat");
                Option option2 = $org_scalatest_assert_macro_left2;
                Some some2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
                Option $org_scalatest_assert_macro_left3 = desc2.storage().serde();
                Some $org_scalatest_assert_macro_right3 = new Some((Object)"org.apache.hadoop.hive.ql.io.orc.OrcSerde");
                Option option3 = $org_scalatest_assert_macro_left3;
                Some some3 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option3 != null ? !option3.equals(some3) : some3 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.default.fileformat"), (Object)"parquet")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Tuple2<CatalogTable, Object> tuple2 = this.extractTableDesc("CREATE TABLE IF NOT EXISTS fileformat_test (id int) USING hive");
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                CatalogTable desc = (CatalogTable)tuple2._1();
                boolean exists = tuple2._2$mcZ$sp();
                Tuple2 tuple22 = new Tuple2((Object)desc, (Object)BoxesRunTime.boxToBoolean((boolean)exists));
                Tuple2 tuple23 = tuple22;
                CatalogTable desc2 = (CatalogTable)tuple23._1();
                boolean exists2 = tuple23._2$mcZ$sp();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(exists2, "exists", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
                Option input = desc2.storage().inputFormat();
                Option output = desc2.storage().outputFormat();
                Option serde = desc2.storage().serde();
                Option $org_scalatest_assert_macro_left = input;
                Some $org_scalatest_assert_macro_right = new Some((Object)"org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat");
                Option option = $org_scalatest_assert_macro_left;
                Some some = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
                Option $org_scalatest_assert_macro_left2 = output;
                Some $org_scalatest_assert_macro_right2 = new Some((Object)"org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat");
                Option option2 = $org_scalatest_assert_macro_left2;
                Some some2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
                Option $org_scalatest_assert_macro_left3 = serde;
                Some $org_scalatest_assert_macro_right3 = new Some((Object)"org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe");
                Option option3 = $org_scalatest_assert_macro_left3;
                Some some3 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option3 != null ? !option3.equals(some3) : some3 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.default.fileformat"), (Object)"orc")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Tuple2<CatalogTable, Object> tuple2 = this.extractTableDesc("CREATE TABLE IF NOT EXISTS fileformat_test (id int) STORED AS textfile");
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                CatalogTable desc = (CatalogTable)tuple2._1();
                boolean exists = tuple2._2$mcZ$sp();
                Tuple2 tuple22 = new Tuple2((Object)desc, (Object)BoxesRunTime.boxToBoolean((boolean)exists));
                Tuple2 tuple23 = tuple22;
                CatalogTable desc2 = (CatalogTable)tuple23._1();
                boolean exists2 = tuple23._2$mcZ$sp();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(exists2, "exists", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
                Option $org_scalatest_assert_macro_left = desc2.storage().inputFormat();
                Some $org_scalatest_assert_macro_right = new Some((Object)"org.apache.hadoop.mapred.TextInputFormat");
                Option option = $org_scalatest_assert_macro_left;
                Some some = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
                Option $org_scalatest_assert_macro_left2 = desc2.storage().outputFormat();
                Some $org_scalatest_assert_macro_right2 = new Some((Object)"org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat");
                Option option2 = $org_scalatest_assert_macro_left2;
                Some some2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
                Option $org_scalatest_assert_macro_left3 = desc2.storage().serde();
                Some $org_scalatest_assert_macro_right3 = new Some((Object)"org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe");
                Option option3 = $org_scalatest_assert_macro_left3;
                Some some3 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option3 != null ? !option3.equals(some3) : some3 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.default.fileformat"), (Object)"orc")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Tuple2<CatalogTable, Object> tuple2 = this.extractTableDesc("CREATE TABLE IF NOT EXISTS fileformat_test (id int) STORED AS sequencefile");
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                CatalogTable desc = (CatalogTable)tuple2._1();
                boolean exists = tuple2._2$mcZ$sp();
                Tuple2 tuple22 = new Tuple2((Object)desc, (Object)BoxesRunTime.boxToBoolean((boolean)exists));
                Tuple2 tuple23 = tuple22;
                CatalogTable desc2 = (CatalogTable)tuple23._1();
                boolean exists2 = tuple23._2$mcZ$sp();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(exists2, "exists", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
                Option $org_scalatest_assert_macro_left = desc2.storage().inputFormat();
                Some $org_scalatest_assert_macro_right = new Some((Object)"org.apache.hadoop.mapred.SequenceFileInputFormat");
                Option option = $org_scalatest_assert_macro_left;
                Some some = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
                Option $org_scalatest_assert_macro_left2 = desc2.storage().outputFormat();
                Some $org_scalatest_assert_macro_right2 = new Some((Object)"org.apache.hadoop.mapred.SequenceFileOutputFormat");
                Option option2 = $org_scalatest_assert_macro_left2;
                Some some2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
                Option $org_scalatest_assert_macro_left3 = desc2.storage().serde();
                Some $org_scalatest_assert_macro_right3 = new Some((Object)"org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe");
                Option option3 = $org_scalatest_assert_macro_left3;
                Some some3 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option3 != null ? !option3.equals(some3) : some3 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
            });
        }, new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("create hive serde table with new syntax - basic", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sql = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |CREATE TABLE t\n        |(id int, name string COMMENT 'blabla')\n        |USING hive\n        |OPTIONS (fileFormat 'parquet', my_prop 1)\n        |LOCATION '/tmp/file'\n        |COMMENT 'BLABLA'\n      "));
            CatalogTable table = this.analyzeCreateTable(sql);
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = new StructType().add("id", "int").add("name", "string", true, "blabla");
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
            Option $org_scalatest_assert_macro_left2 = table.provider();
            Some $org_scalatest_assert_macro_right2 = new Some((Object)DDLUtils$.MODULE$.HIVE_PROVIDER());
            Option option = $org_scalatest_assert_macro_left2;
            Some some = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
            Option $org_scalatest_assert_macro_left3 = table.storage().locationUri();
            Some $org_scalatest_assert_macro_right3 = new Some((Object)new URI("file:///tmp/file"));
            Option option2 = $org_scalatest_assert_macro_left3;
            Some some2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
            Map $org_scalatest_assert_macro_left4 = table.storage().properties();
            Map $org_scalatest_assert_macro_right4 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"my_prop"), (Object)"1")}));
            Map map = $org_scalatest_assert_macro_left4;
            Map map2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            Option $org_scalatest_assert_macro_left5 = table.comment();
            Some $org_scalatest_assert_macro_right5 = new Some((Object)"BLABLA");
            Option option3 = $org_scalatest_assert_macro_left5;
            Some some3 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(option3 != null ? !option3.equals(some3) : some3 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
            Option $org_scalatest_assert_macro_left6 = table.storage().inputFormat();
            Some $org_scalatest_assert_macro_right6 = new Some((Object)"org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat");
            Option option4 = $org_scalatest_assert_macro_left6;
            Some some4 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(option4 != null ? !option4.equals(some4) : some4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
            Option $org_scalatest_assert_macro_left7 = table.storage().outputFormat();
            Some $org_scalatest_assert_macro_right7 = new Some((Object)"org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat");
            Option option5 = $org_scalatest_assert_macro_left7;
            Some some5 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(option5 != null ? !option5.equals(some5) : some5 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            Option $org_scalatest_assert_macro_left8 = table.storage().serde();
            Some $org_scalatest_assert_macro_right8 = new Some((Object)"org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe");
            Option option6 = $org_scalatest_assert_macro_left8;
            Some some6 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right8, !(option6 != null ? !option6.equals(some6) : some6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        }, new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        this.test("create hive serde table with new syntax - with partition and bucketing", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String v1 = "CREATE TABLE t (c1 int, c2 int) USING hive PARTITIONED BY (c2)";
            CatalogTable table = this.analyzeCreateTable(v1);
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = new StructType().add("c1", "int").add("c2", "int");
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
            Seq $org_scalatest_assert_macro_left2 = table.partitionColumnNames();
            Seq $org_scalatest_assert_macro_right2 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c2"}));
            Seq seq = $org_scalatest_assert_macro_left2;
            Seq seq2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
            Option $org_scalatest_assert_macro_left3 = table.storage().serde();
            Some $org_scalatest_assert_macro_right3 = new Some((Object)"org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe");
            Option option = $org_scalatest_assert_macro_left3;
            Some some = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
            Option $org_scalatest_assert_macro_left4 = table.storage().inputFormat();
            Some $org_scalatest_assert_macro_right4 = new Some((Object)"org.apache.hadoop.mapred.TextInputFormat");
            Option option2 = $org_scalatest_assert_macro_left4;
            Some some2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
            Option $org_scalatest_assert_macro_left5 = table.storage().outputFormat();
            Some $org_scalatest_assert_macro_right5 = new Some((Object)"org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat");
            Option option3 = $org_scalatest_assert_macro_left5;
            Some some3 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(option3 != null ? !option3.equals(some3) : some3 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
            String v2 = "CREATE TABLE t (c1 int, c2 int) USING hive CLUSTERED BY (c2) INTO 4 BUCKETS";
            AnalysisException e2 = (AnalysisException)this.intercept((Function0 & Serializable)() -> this.analyzeCreateTable(v2), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            String $org_scalatest_assert_macro_left6 = e2.message();
            String $org_scalatest_assert_macro_right6 = "Creating bucketed Hive serde table is not supported yet";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.contains($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
            String v3 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |CREATE TABLE t (c1 int, c2 int) USING hive\n        |PARTITIONED BY (c2)\n        |CLUSTERED BY (c2) INTO 4 BUCKETS"));
            AnalysisException e3 = (AnalysisException)this.intercept((Function0 & Serializable)() -> this.analyzeCreateTable(v3), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
            String $org_scalatest_assert_macro_left7 = e3.message();
            String $org_scalatest_assert_macro_right7 = "Creating bucketed Hive serde table is not supported yet";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.contains($org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        }, new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
        this.test("create hive serde table with new syntax - Hive options error checking", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String v1 = "CREATE TABLE t (c1 int) USING hive OPTIONS (inputFormat 'abc')";
            IllegalArgumentException e1 = (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> this.analyzeCreateTable(v1), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
            String $org_scalatest_assert_macro_left = e1.getMessage();
            String $org_scalatest_assert_macro_right = "Cannot specify only inputFormat or outputFormat";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
            String v2 = "CREATE TABLE t (c1 int) USING hive OPTIONS (fileFormat 'x', inputFormat 'a', outputFormat 'b')";
            IllegalArgumentException e2 = (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> this.analyzeCreateTable(v2), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
            String $org_scalatest_assert_macro_left2 = e2.getMessage();
            String $org_scalatest_assert_macro_right2 = "Cannot specify fileFormat and inputFormat/outputFormat together";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
            String v3 = "CREATE TABLE t (c1 int) USING hive OPTIONS (fileFormat 'parquet', serde 'a')";
            IllegalArgumentException e3 = (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> this.analyzeCreateTable(v3), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            String $org_scalatest_assert_macro_left3 = e3.getMessage();
            String $org_scalatest_assert_macro_right3 = "fileFormat 'parquet' already specifies a serde";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
            String v4 = "CREATE TABLE t (c1 int) USING hive OPTIONS (serde 'a', fieldDelim ' ')";
            IllegalArgumentException e4 = (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> this.analyzeCreateTable(v4), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
            String $org_scalatest_assert_macro_left4 = e4.getMessage();
            String $org_scalatest_assert_macro_right4 = "Cannot specify delimiters with a custom serde";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
            String v5 = "CREATE TABLE t (c1 int) USING hive OPTIONS (fieldDelim ' ')";
            IllegalArgumentException e5 = (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> this.analyzeCreateTable(v5), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
            String $org_scalatest_assert_macro_left5 = e5.getMessage();
            String $org_scalatest_assert_macro_right5 = "Cannot specify delimiters without fileFormat";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
            String v6 = "CREATE TABLE t (c1 int) USING hive OPTIONS (fileFormat 'parquet', fieldDelim ' ')";
            IllegalArgumentException e6 = (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> this.analyzeCreateTable(v6), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
            String $org_scalatest_assert_macro_left6 = e6.getMessage();
            String $org_scalatest_assert_macro_right6 = "Cannot specify delimiters as they are only compatible with fileFormat 'textfile'";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.contains($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
            String v7 = "CREATE TABLE t (c1 int) USING hive OPTIONS (fileFormat 'TEXTFILE', lineDelim ',')";
            IllegalArgumentException e7 = (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> this.analyzeCreateTable(v7), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
            String $org_scalatest_assert_macro_left7 = e7.getMessage();
            String $org_scalatest_assert_macro_right7 = "Hive data source only support newline '\\n' as line delimiter";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.contains($org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
            String v8 = "CREATE TABLE t (c1 int) USING hive OPTIONS (fileFormat 'wrong')";
            IllegalArgumentException e8 = (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> this.analyzeCreateTable(v8), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
            String $org_scalatest_assert_macro_left8 = e8.getMessage();
            String $org_scalatest_assert_macro_right8 = "invalid fileFormat: 'wrong'";
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "contains", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.contains($org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
        }, new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        this.test("SPARK-27555: fall back to hive-site.xml if hive.default.fileformat is not found in SQLConf ", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Assertion assertion;
            SparkSession testSession = (SparkSession)SparkSession$.MODULE$.getActiveSession().get();
            try {
                testSession.sparkContext().hadoopConfiguration().set("hive.default.fileformat", "parquetfile");
                SQLConf sqlConf = new SQLConf();
                CatalogStorageFormat storageFormat = HiveSerDe$.MODULE$.getDefaultStorage(sqlConf);
                Option $org_scalatest_assert_macro_left = storageFormat.serde();
                String $org_scalatest_assert_macro_right = "org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
                sqlConf.setConfString("hive.default.fileformat", "orc");
                storageFormat = HiveSerDe$.MODULE$.getDefaultStorage(sqlConf);
                Option $org_scalatest_assert_macro_left2 = storageFormat.serde();
                String $org_scalatest_assert_macro_right2 = "org.apache.hadoop.hive.ql.io.orc.OrcSerde";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
            }
            finally {
                testSession.sparkContext().hadoopConfiguration().unset("hive.default.fileformat");
            }
            return assertion;
        }, new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
    }
}

