/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.ql.exec.TaskRunner;
import org.apache.spark.SparkException$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogWithListener;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.hive.HiveExternalCatalog;
import org.apache.spark.sql.hive.client.package;
import org.apache.spark.sql.hive.client.package$hive$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005c\u0001\u0002\u000b\u0016\u0001\tB\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\ti\u0001\u0011)\u0019!C\u0001k!Aa\b\u0001B\u0001B\u0003%a\u0007\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0011\u00151\u0005\u0001\"\u0001H\u0011\u001di\u0005\u00011A\u0005\n9CqA\u0015\u0001A\u0002\u0013%1\u000b\u0003\u0004Z\u0001\u0001\u0006Ka\u0014\u0005\t5\u0002A)\u0019!C\u00017\"AA\f\u0001EC\u0002\u0013%Q\fC\u0003i\u0001\u0011%\u0011\u000eC\u0003[\u0001\u0011%1\u000eC\u0003{\u0001\u0011%1\u0010\u0003\u0005\u0002\f\u0001!\taFA\u0007\u0011\u001d\t)\u0002\u0001C\u0005\u0003/Aq!a\f\u0001\t\u0013\t\t\u0004C\u0004\u00024\u0001!\t!!\u000e\t\u000f\u0005]\u0002\u0001\"\u0001\u00026!9\u0011\u0011\b\u0001\u0005\u0002\u0005m\"\u0001\u0004%jm\u0016$V-\u001c9QCRD'B\u0001\f\u0018\u0003%)\u00070Z2vi&|gN\u0003\u0002\u00193\u0005!\u0001.\u001b<f\u0015\tQ2$A\u0002tc2T!\u0001H\u000f\u0002\u000bM\u0004\u0018M]6\u000b\u0005yy\u0012AB1qC\u000eDWMC\u0001!\u0003\ry'oZ\u0002\u0001'\r\u00011%\u000b\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005)jS\"A\u0016\u000b\u00051Z\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u00059Z#a\u0002'pO\u001eLgnZ\u0001\bg\u0016\u001c8/[8o!\t\t$'D\u0001\u001a\u0013\t\u0019\u0014D\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\u0006iC\u0012|w\u000e]\"p]\u001a,\u0012A\u000e\t\u0003oqj\u0011\u0001\u000f\u0006\u0003si\nAaY8oM*\u00111(H\u0001\u0007Q\u0006$wn\u001c9\n\u0005uB$!D\"p]\u001aLw-\u001e:bi&|g.A\u0006iC\u0012|w\u000e]\"p]\u001a\u0004\u0013\u0001\u00029bi\"\u0004\"!\u0011#\u000e\u0003\tS!a\u0011\u001e\u0002\u0005\u0019\u001c\u0018BA#C\u0005\u0011\u0001\u0016\r\u001e5\u0002\rqJg.\u001b;?)\u0011A%j\u0013'\u0011\u0005%\u0003Q\"A\u000b\t\u000b=*\u0001\u0019\u0001\u0019\t\u000bQ*\u0001\u0019\u0001\u001c\t\u000b}*\u0001\u0019\u0001!\u0002+M$\u0018mZ5oO\u0012K'OR8s\u0007J,\u0017\r^5oOV\tq\nE\u0002%!\u0002K!!U\u0013\u0003\r=\u0003H/[8o\u0003e\u0019H/Y4j]\u001e$\u0015N\u001d$pe\u000e\u0013X-\u0019;j]\u001e|F%Z9\u0015\u0005Q;\u0006C\u0001\u0013V\u0013\t1VE\u0001\u0003V]&$\bb\u0002-\b\u0003\u0003\u0005\raT\u0001\u0004q\u0012\n\u0014AF:uC\u001eLgn\u001a#je\u001a{'o\u0011:fCRLgn\u001a\u0011\u0002!\u0015DH/\u001a:oC2$V-\u001c9QCRDW#\u0001!\u0002#\u0011\fG/\u001a+j[\u00164uN]7biR,'/F\u0001_!\tyf-D\u0001a\u0015\t\t'-\u0001\u0004g_Jl\u0017\r\u001e\u0006\u0003G\u0012\fA\u0001^5nK*\tQ-\u0001\u0003kCZ\f\u0017BA4a\u0005E!\u0015\r^3US6,gi\u001c:nCR$XM]\u0001\u0013O\u0016$X\t\u001f;fe:\fG\u000eV7q!\u0006$\b\u000e\u0006\u0002AU\")qh\u0003a\u0001\u0001R\u0019\u0001\t\\7\t\u000b}b\u0001\u0019\u0001!\t\u000b9d\u0001\u0019A8\u0002\u0015M$\u0018mZ5oO\u0012K'\u000f\u0005\u0002qo:\u0011\u0011/\u001e\t\u0003e\u0016j\u0011a\u001d\u0006\u0003i\u0006\na\u0001\u0010:p_Rt\u0014B\u0001<&\u0003\u0019\u0001&/\u001a3fM&\u0011\u00010\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Y,\u0013!F4fi\u0016CH/\u001a:oC2\u001c6M]1uG\"$\u0015N\u001d\u000b\u0005\u0001r\fI\u0001C\u0003~\u001b\u0001\u0007a0\u0001\u0004fqR,&+\u0013\t\u0004\u007f\u0006\u0015QBAA\u0001\u0015\r\t\u0019\u0001Z\u0001\u0004]\u0016$\u0018\u0002BA\u0004\u0003\u0003\u00111!\u0016*J\u0011\u0015qW\u00021\u0001p\u000359W\r^*uC\u001eLgn\u001a#jeR)\u0001)a\u0004\u0002\u0014!1\u0011\u0011\u0003\bA\u0002\u0001\u000b\u0011\"\u001b8qkR\u0004\u0016\r\u001e5\t\u000b9t\u0001\u0019A8\u0002\u0011%\u001c8+\u001e2ESJ$\u0002\"!\u0007\u0002 \u0005\r\u0012q\u0005\t\u0004I\u0005m\u0011bAA\u000fK\t9!i\\8mK\u0006t\u0007BBA\u0011\u001f\u0001\u0007\u0001)\u0001\u0002qc!1\u0011QE\bA\u0002\u0001\u000b!\u0001\u001d\u001a\t\r\r{\u0001\u0019AA\u0015!\r\t\u00151F\u0005\u0004\u0003[\u0011%A\u0003$jY\u0016\u001c\u0016p\u001d;f[\u0006YQ\r_3dkRLwN\\%e+\u0005y\u0017!\u00043fY\u0016$X\rV7q!\u0006$\b\u000eF\u0001U\u00035\u0019'/Z1uKRk\u0007\u000fU1uQ\u0006)B-\u001a7fi\u0016LeMT8u'R\fw-\u001b8h\t&\u0014H#\u0002+\u0002>\u0005}\u0002\"B \u0014\u0001\u0004\u0001\u0005BB\"\u0014\u0001\u0004\tI\u0003")
public class HiveTempPath
implements Logging {
    private Path externalTempPath;
    private DateTimeFormatter dateTimeFormatter;
    private final SparkSession session;
    private final Configuration hadoopConf;
    private Path path;
    private Option<Path> stagingDirForCreating;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Configuration hadoopConf() {
        return this.hadoopConf;
    }

    private Option<Path> stagingDirForCreating() {
        return this.stagingDirForCreating;
    }

    private void stagingDirForCreating_$eq(Option<Path> x$1) {
        this.stagingDirForCreating = x$1;
    }

    private Path externalTempPath$lzycompute() {
        HiveTempPath hiveTempPath = this;
        synchronized (hiveTempPath) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.externalTempPath = this.getExternalTmpPath(this.path);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.path = null;
        return this.externalTempPath;
    }

    public Path externalTempPath() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.externalTempPath$lzycompute();
        }
        return this.externalTempPath;
    }

    private DateTimeFormatter dateTimeFormatter$lzycompute() {
        HiveTempPath hiveTempPath = this;
        synchronized (hiveTempPath) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss_SSS", Locale.US).withZone(ZoneId.systemDefault());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.dateTimeFormatter;
    }

    private DateTimeFormatter dateTimeFormatter() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.dateTimeFormatter$lzycompute();
        }
        return this.dateTimeFormatter;
    }

    private Path getExternalTmpPath(Path path) {
        ExternalCatalogWithListener externalCatalog = this.session.sharedState().externalCatalog();
        package.HiveVersion hiveVersion = ((HiveExternalCatalog)externalCatalog.unwrapped()).client().version();
        String stagingDir = this.hadoopConf().get("hive.exec.stagingdir", ".hive-staging");
        if (package$hive$.MODULE$.allSupportedHiveVersions().contains((Object)hiveVersion)) {
            return this.externalTempPath(path, stagingDir);
        }
        throw SparkException$.MODULE$.internalError("Unsupported hive version: " + hiveVersion.fullVersion());
    }

    private Path externalTempPath(Path path, String stagingDir) {
        URI extURI = path.toUri();
        String string = extURI.getScheme();
        String string2 = "viewfs";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Path qualifiedStagingDir = this.getStagingDir(path, stagingDir);
            this.stagingDirForCreating_$eq((Option<Path>)new Some((Object)qualifiedStagingDir));
            return new Path(qualifiedStagingDir, "-ext-10000");
        }
        Path qualifiedStagingDir = this.getExternalScratchDir(extURI, stagingDir);
        this.stagingDirForCreating_$eq((Option<Path>)new Some((Object)qualifiedStagingDir));
        return new Path(qualifiedStagingDir, "-ext-10000");
    }

    private Path getExternalScratchDir(URI extURI, String stagingDir) {
        return this.getStagingDir(new Path(extURI.getScheme(), extURI.getAuthority(), extURI.getPath()), stagingDir);
    }

    public Path getStagingDir(Path inputPath, String stagingDir) {
        String inputPathName = inputPath.toString();
        FileSystem fs = inputPath.getFileSystem(this.hadoopConf());
        ObjectRef stagingPathName = ObjectRef.create((Object)(inputPathName.indexOf(stagingDir) == -1 ? new Path(inputPathName, stagingDir).toString() : inputPathName.substring(0, inputPathName.indexOf(stagingDir) + stagingDir.length())));
        if (this.isSubDir(new Path((String)stagingPathName.elem), inputPath, fs) && !StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString((String)stagingPathName.elem), inputPathName)), "/").startsWith(".")) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "The staging dir '" + (String)stagingPathName$1.elem + "' should be a child directory starts with '.' to avoid being deleted if we set hive.exec.stagingdir under the table directory.");
            stagingPathName.elem = new Path(inputPathName, ".hive-staging").toString();
        }
        Path dir = fs.makeQualified(new Path((String)stagingPathName.elem + "_" + this.executionId() + "-" + TaskRunner.getTaskRunnerID()));
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Created staging dir = " + dir + " for path = " + inputPath);
        return dir;
    }

    private boolean isSubDir(Path p1, Path p2, FileSystem fs) {
        String path1 = fs.makeQualified(p1).toString() + "/";
        String path2 = fs.makeQualified(p2).toString() + "/";
        return path1.startsWith(path2);
    }

    private String executionId() {
        Random rand = new Random();
        return "hive_" + this.dateTimeFormatter().format(new Date().toInstant()) + "_" + Math.abs(rand.nextLong());
    }

    public void deleteTmpPath() {
        try {
            this.stagingDirForCreating().foreach((Function1 & Serializable)stagingDir -> {
                FileSystem fs = stagingDir.getFileSystem(this.hadoopConf());
                if (fs.delete(stagingDir, true)) {
                    return BoxesRunTime.boxToBoolean((boolean)fs.cancelDeleteOnExit(stagingDir));
                }
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                String stagingDir2 = this.hadoopConf().get("hive.exec.stagingdir", ".hive-staging");
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to delete staging directory: ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, (Object)stagingDir2)}))), throwable2);
            }
            throw throwable;
        }
    }

    public void createTmpPath() {
        try {
            this.stagingDirForCreating().foreach((Function1 & Serializable)stagingDir -> BoxesRunTime.boxToBoolean((boolean)HiveTempPath.$anonfun$createTmpPath$1(this, stagingDir)));
        }
        catch (IOException e) {
            throw QueryExecutionErrors$.MODULE$.cannotCreateStagingDirError("'" + this.stagingDirForCreating().toString() + "': " + e.getMessage(), e);
        }
    }

    public void deleteIfNotStagingDir(Path path, FileSystem fs) {
        Option option = Option$.MODULE$.apply((Object)path);
        Option<Path> option2 = this.stagingDirForCreating();
        if (option == null ? option2 != null : !option.equals(option2)) {
            fs.delete(path, true);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$createTmpPath$1(HiveTempPath $this, Path stagingDir) {
        FileSystem fs = stagingDir.getFileSystem($this.hadoopConf());
        if (!FileUtils.mkdir((FileSystem)fs, (Path)stagingDir, (boolean)true, (Configuration)$this.hadoopConf())) {
            throw SparkException$.MODULE$.internalError("Cannot create staging directory  '" + stagingDir.toString() + "'");
        }
        return fs.deleteOnExit(stagingDir);
    }

    public HiveTempPath(SparkSession session, Configuration hadoopConf, Path path) {
        this.session = session;
        this.hadoopConf = hadoopConf;
        this.path = path;
        Logging.$init$((Logging)this);
        this.stagingDirForCreating = None$.MODULE$;
    }
}

