/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType;
import org.apache.spark.sql.types.VariantType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class HiveExternalCatalog$ {
    public static final HiveExternalCatalog$ MODULE$ = new HiveExternalCatalog$();
    private static final String SPARK_SQL_PREFIX = "spark.sql.";
    private static final String DATASOURCE_PREFIX = MODULE$.SPARK_SQL_PREFIX() + "sources.";
    private static final String DATASOURCE_PROVIDER = MODULE$.DATASOURCE_PREFIX() + "provider";
    private static final String DATASOURCE_SCHEMA = MODULE$.DATASOURCE_PREFIX() + "schema";
    private static final String DATASOURCE_SCHEMA_PREFIX = MODULE$.DATASOURCE_SCHEMA() + ".";
    private static final String DATASOURCE_SCHEMA_NUMPARTCOLS = MODULE$.DATASOURCE_SCHEMA_PREFIX() + "numPartCols";
    private static final String DATASOURCE_SCHEMA_NUMSORTCOLS = MODULE$.DATASOURCE_SCHEMA_PREFIX() + "numSortCols";
    private static final String DATASOURCE_SCHEMA_NUMBUCKETS = MODULE$.DATASOURCE_SCHEMA_PREFIX() + "numBuckets";
    private static final String DATASOURCE_SCHEMA_NUMBUCKETCOLS = MODULE$.DATASOURCE_SCHEMA_PREFIX() + "numBucketCols";
    private static final String DATASOURCE_SCHEMA_PART_PREFIX = MODULE$.DATASOURCE_SCHEMA_PREFIX() + "part.";
    private static final String DATASOURCE_SCHEMA_PARTCOL_PREFIX = MODULE$.DATASOURCE_SCHEMA_PREFIX() + "partCol.";
    private static final String DATASOURCE_SCHEMA_BUCKETCOL_PREFIX = MODULE$.DATASOURCE_SCHEMA_PREFIX() + "bucketCol.";
    private static final String DATASOURCE_SCHEMA_SORTCOL_PREFIX = MODULE$.DATASOURCE_SCHEMA_PREFIX() + "sortCol.";
    private static final String STATISTICS_PREFIX = MODULE$.SPARK_SQL_PREFIX() + "statistics.";
    private static final String STATISTICS_TOTAL_SIZE = MODULE$.STATISTICS_PREFIX() + "totalSize";
    private static final String STATISTICS_NUM_ROWS = MODULE$.STATISTICS_PREFIX() + "numRows";
    private static final String STATISTICS_COL_STATS_PREFIX = MODULE$.STATISTICS_PREFIX() + "colStats.";
    private static final String TABLE_PARTITION_PROVIDER = MODULE$.SPARK_SQL_PREFIX() + "partitionProvider";
    private static final String TABLE_PARTITION_PROVIDER_CATALOG = "catalog";
    private static final String TABLE_PARTITION_PROVIDER_FILESYSTEM = "filesystem";
    private static final String CREATED_SPARK_VERSION = MODULE$.SPARK_SQL_PREFIX() + "create.version";
    private static final Set<String> HIVE_GENERATED_TABLE_PROPERTIES = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"transient_lastDdlTime"}));
    private static final Set<String> HIVE_GENERATED_STORAGE_PROPERTIES = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"serialization.format"}));
    private static final StructType EMPTY_DATA_SCHEMA = new StructType().add("col", "array<string>", true, "from deserializer");

    public String SPARK_SQL_PREFIX() {
        return SPARK_SQL_PREFIX;
    }

    public String DATASOURCE_PREFIX() {
        return DATASOURCE_PREFIX;
    }

    public String DATASOURCE_PROVIDER() {
        return DATASOURCE_PROVIDER;
    }

    public String DATASOURCE_SCHEMA() {
        return DATASOURCE_SCHEMA;
    }

    public String DATASOURCE_SCHEMA_PREFIX() {
        return DATASOURCE_SCHEMA_PREFIX;
    }

    public String DATASOURCE_SCHEMA_NUMPARTCOLS() {
        return DATASOURCE_SCHEMA_NUMPARTCOLS;
    }

    public String DATASOURCE_SCHEMA_NUMSORTCOLS() {
        return DATASOURCE_SCHEMA_NUMSORTCOLS;
    }

    public String DATASOURCE_SCHEMA_NUMBUCKETS() {
        return DATASOURCE_SCHEMA_NUMBUCKETS;
    }

    public String DATASOURCE_SCHEMA_NUMBUCKETCOLS() {
        return DATASOURCE_SCHEMA_NUMBUCKETCOLS;
    }

    public String DATASOURCE_SCHEMA_PART_PREFIX() {
        return DATASOURCE_SCHEMA_PART_PREFIX;
    }

    public String DATASOURCE_SCHEMA_PARTCOL_PREFIX() {
        return DATASOURCE_SCHEMA_PARTCOL_PREFIX;
    }

    public String DATASOURCE_SCHEMA_BUCKETCOL_PREFIX() {
        return DATASOURCE_SCHEMA_BUCKETCOL_PREFIX;
    }

    public String DATASOURCE_SCHEMA_SORTCOL_PREFIX() {
        return DATASOURCE_SCHEMA_SORTCOL_PREFIX;
    }

    public String STATISTICS_PREFIX() {
        return STATISTICS_PREFIX;
    }

    public String STATISTICS_TOTAL_SIZE() {
        return STATISTICS_TOTAL_SIZE;
    }

    public String STATISTICS_NUM_ROWS() {
        return STATISTICS_NUM_ROWS;
    }

    public String STATISTICS_COL_STATS_PREFIX() {
        return STATISTICS_COL_STATS_PREFIX;
    }

    public String TABLE_PARTITION_PROVIDER() {
        return TABLE_PARTITION_PROVIDER;
    }

    public String TABLE_PARTITION_PROVIDER_CATALOG() {
        return TABLE_PARTITION_PROVIDER_CATALOG;
    }

    public String TABLE_PARTITION_PROVIDER_FILESYSTEM() {
        return TABLE_PARTITION_PROVIDER_FILESYSTEM;
    }

    public String CREATED_SPARK_VERSION() {
        return CREATED_SPARK_VERSION;
    }

    public Set<String> HIVE_GENERATED_TABLE_PROPERTIES() {
        return HIVE_GENERATED_TABLE_PROPERTIES;
    }

    public Set<String> HIVE_GENERATED_STORAGE_PROPERTIES() {
        return HIVE_GENERATED_STORAGE_PROPERTIES;
    }

    public StructType EMPTY_DATA_SCHEMA() {
        return EMPTY_DATA_SCHEMA;
    }

    private Seq<String> getColumnNamesByType(Map<String, String> props, String colType, String typeName) {
        return (Seq)Option$.MODULE$.option2Iterable(props.get((Object)("spark.sql.sources.schema.num" + StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(colType)) + "Cols"))).toSeq().flatMap((Function1 & Serializable)numCols -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(numCols))).map((Function1 & Serializable)index -> HiveExternalCatalog$.$anonfun$getColumnNamesByType$2(props, colType, typeName, numCols, BoxesRunTime.unboxToInt((Object)index))));
    }

    public Seq<String> org$apache$spark$sql$hive$HiveExternalCatalog$$getPartitionColumnsFromTableProperties(CatalogTable metadata) {
        return this.getColumnNamesByType((Map<String, String>)metadata.properties(), "part", "partitioning columns");
    }

    public Option<BucketSpec> org$apache$spark$sql$hive$HiveExternalCatalog$$getBucketSpecFromTableProperties(CatalogTable metadata) {
        return metadata.properties().get((Object)this.DATASOURCE_SCHEMA_NUMBUCKETS()).map((Function1 & Serializable)numBuckets -> new BucketSpec(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(numBuckets)), MODULE$.getColumnNamesByType((Map<String, String>)metadata.properties(), "bucket", "bucketing columns"), MODULE$.getColumnNamesByType((Map<String, String>)metadata.properties(), "sort", "sorting columns")));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDatasourceTable(CatalogTable table) {
        Option provider = table.provider().orElse((Function0 & Serializable)() -> table.properties().get((Object)MODULE$.DATASOURCE_PROVIDER()));
        if (!provider.isDefined()) return false;
        Option option = provider;
        Some some = new Some((Object)DDLUtils$.MODULE$.HIVE_PROVIDER());
        if (option == null) {
            if (some == null) return false;
            return true;
        } else if (option.equals(some)) return false;
        return true;
    }

    public boolean isHiveCompatibleDataType(DataType dt) {
        DataType dataType;
        block7: {
            while (true) {
                if ((dataType = dt) instanceof AnsiIntervalType) {
                    return false;
                }
                if (dataType instanceof TimestampNTZType) {
                    return false;
                }
                if (dataType instanceof VariantType) {
                    return false;
                }
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    return structType.forall((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HiveExternalCatalog$.MODULE$.isHiveCompatibleDataType(f.dataType())));
                }
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    dt = arrayType.elementType();
                    continue;
                }
                if (!(dataType instanceof MapType)) break block7;
                MapType mapType = (MapType)dataType;
                if (!this.isHiveCompatibleDataType(mapType.keyType())) break;
                dt = mapType.valueType();
            }
            return false;
        }
        if (dataType instanceof StringType) {
            StringType stringType = (StringType)dataType;
            return stringType.isUTF8BinaryCollation();
        }
        return true;
    }

    public static final /* synthetic */ String $anonfun$getColumnNamesByType$2(Map props$1, String colType$1, String typeName$1, String numCols$1, int index) {
        return (String)props$1.getOrElse((Object)(MODULE$.DATASOURCE_SCHEMA_PREFIX() + colType$1 + "Col." + index), (Function0 & Serializable)() -> {
            throw new AnalysisException("_LEGACY_ERROR_TEMP_3089", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"typeName"), (Object)typeName$1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numCols"), (Object)numCols$1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index"), (Object)Integer.toString(index))})));
        });
    }

    private HiveExternalCatalog$() {
    }
}

