/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.client;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.MetadataTypedColumnsetSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics$;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.hive.HiveExternalCatalog$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Ordered;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class HiveClientImpl$
implements Logging {
    public static final HiveClientImpl$ MODULE$ = new HiveClientImpl$();
    private static final Set<String> org$apache$spark$sql$hive$client$HiveClientImpl$$HiveStatisticsProperties;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        org$apache$spark$sql$hive$client$HiveClientImpl$$HiveStatisticsProperties = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"COLUMN_STATS_ACCURATE", "numFiles", "numPartitions", "numRows", "rawDataSize", "totalSize"}));
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public FieldSchema toHiveColumn(StructField c) {
        String typeString = SQLConf$.MODULE$.get().charVarcharAsString() ? c.dataType().catalogString() : (String)CharVarcharUtils$.MODULE$.getRawTypeString(c.metadata()).getOrElse((Function0 & Serializable)() -> c.dataType().catalogString());
        return new FieldSchema(c.name(), typeString, (String)c.getComment().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private DataType getSparkSQLDataType(FieldSchema hc) {
        DataType dataType;
        String typeStr = hc.getType().replaceAll("(?<=struct<|,)([^,<:]+)(?=:)", "`$1`");
        try {
            dataType = CatalystSqlParser$.MODULE$.parseDataType(typeStr);
        }
        catch (ParseException e) {
            throw QueryExecutionErrors$.MODULE$.cannotRecognizeHiveTypeError(e, typeStr, hc.getName());
        }
        return dataType;
    }

    public StructField fromHiveColumn(FieldSchema hc) {
        DataType columnType = this.getSparkSQLDataType(hc);
        StructField field = new StructField(hc.getName(), columnType, true, StructField$.MODULE$.apply$default$4());
        return (StructField)Option$.MODULE$.apply((Object)hc.getComment()).map((Function1 & Serializable)comment -> field.withComment(comment)).getOrElse((Function0 & Serializable)() -> field);
    }

    public void org$apache$spark$sql$hive$client$HiveClientImpl$$verifyColumnDataType(StructType schema) {
        schema.foreach((Function1 & Serializable)col -> MODULE$.getSparkSQLDataType(MODULE$.toHiveColumn((StructField)col)));
    }

    private Class<InputFormat<?, ?>> toInputFormat(String name) {
        return Utils$.MODULE$.classForName(name, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
    }

    private Class<HiveOutputFormat<?, ?>> toOutputFormat(String name) {
        return Utils$.MODULE$.classForName(name, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
    }

    public TableType toHiveTableType(CatalogTableType catalogTableType) {
        CatalogTableType catalogTableType2 = catalogTableType;
        CatalogTableType catalogTableType3 = CatalogTableType$.MODULE$.EXTERNAL();
        CatalogTableType catalogTableType4 = catalogTableType2;
        if (!(catalogTableType3 != null ? !catalogTableType3.equals(catalogTableType4) : catalogTableType4 != null)) {
            return TableType.EXTERNAL_TABLE;
        }
        CatalogTableType catalogTableType5 = CatalogTableType$.MODULE$.MANAGED();
        CatalogTableType catalogTableType6 = catalogTableType2;
        if (!(catalogTableType5 != null ? !catalogTableType5.equals(catalogTableType6) : catalogTableType6 != null)) {
            return TableType.MANAGED_TABLE;
        }
        CatalogTableType catalogTableType7 = CatalogTableType$.MODULE$.VIEW();
        CatalogTableType catalogTableType8 = catalogTableType2;
        if (!(catalogTableType7 != null ? !catalogTableType7.equals(catalogTableType8) : catalogTableType8 != null)) {
            return TableType.VIRTUAL_VIEW;
        }
        throw new IllegalArgumentException("Unknown table type is found at toHiveTableType: " + catalogTableType2);
    }

    public Table toHiveTable(CatalogTable table, Option<String> userName) {
        Table hiveTable;
        block4: {
            Tuple2 tuple2;
            hiveTable = new Table(table.database(), table.identifier().table());
            hiveTable.setTableType(this.toHiveTableType(table.tableType()));
            CatalogTableType catalogTableType = table.tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.EXTERNAL();
            if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
                hiveTable.setProperty("EXTERNAL", "TRUE");
            }
            if ((tuple2 = ((IterableOps)table.schema().map((Function1 & Serializable)c -> MODULE$.toHiveColumn((StructField)c))).partition((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)HiveClientImpl$.$anonfun$toHiveTable$2(table, c)))) == null) {
                throw new MatchError((Object)tuple2);
            }
            scala.collection.immutable.Seq partCols = (scala.collection.immutable.Seq)tuple2._1();
            scala.collection.immutable.Seq schema = (scala.collection.immutable.Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)partCols, (Object)schema);
            scala.collection.immutable.Seq partCols2 = (scala.collection.immutable.Seq)tuple22._1();
            scala.collection.immutable.Seq schema2 = (scala.collection.immutable.Seq)tuple22._2();
            hiveTable.setFields(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)schema2).asJava());
            hiveTable.setPartCols(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partCols2).asJava());
            Option$.MODULE$.apply((Object)table.owner()).filter((Function1 & Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$25)))).orElse((Function0 & Serializable)() -> userName).foreach((Function1 & Serializable)x$1 -> {
                hiveTable.setOwner(x$1);
                return BoxedUnit.UNIT;
            });
            hiveTable.setCreateTime((int)TimeUnit.MILLISECONDS.toSeconds(table.createTime()));
            hiveTable.setLastAccessTime((int)TimeUnit.MILLISECONDS.toSeconds(table.lastAccessTime()));
            table.storage().locationUri().map((Function1 & Serializable)uri -> CatalogUtils$.MODULE$.URIToString(uri)).foreach((Function1 & Serializable)loc -> {
                HiveClientImpl$.$anonfun$toHiveTable$7(hiveTable, loc);
                return BoxedUnit.UNIT;
            });
            table.storage().inputFormat().map((Function1 & Serializable)name -> MODULE$.toInputFormat((String)name)).foreach((Function1 & Serializable)x$1 -> {
                hiveTable.setInputFormatClass(x$1);
                return BoxedUnit.UNIT;
            });
            table.storage().outputFormat().map((Function1 & Serializable)name -> MODULE$.toOutputFormat((String)name)).foreach((Function1 & Serializable)x$1 -> {
                hiveTable.setOutputFormatClass(x$1);
                return BoxedUnit.UNIT;
            });
            hiveTable.setSerializationLib((String)table.storage().serde().getOrElse((Function0 & Serializable)() -> "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe"));
            table.storage().properties().foreach((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    return hiveTable.setSerdeParam(k, v);
                }
                throw new MatchError((Object)tuple2);
            });
            table.properties().foreach((Function1 & Serializable)x0$2 -> {
                HiveClientImpl$.$anonfun$toHiveTable$14(hiveTable, x0$2);
                return BoxedUnit.UNIT;
            });
            table.comment().foreach((Function1 & Serializable)c -> {
                hiveTable.setProperty("comment", c);
                return BoxedUnit.UNIT;
            });
            table.viewText().foreach((Function1 & Serializable)t -> {
                HiveClientImpl$.$anonfun$toHiveTable$16(hiveTable, t);
                return BoxedUnit.UNIT;
            });
            Option option = table.bucketSpec();
            if (!(option instanceof Some)) break block4;
            Some some = (Some)option;
            BucketSpec bucketSpec = (BucketSpec)some.value();
            if (!HiveExternalCatalog$.MODULE$.isDatasourceTable(table)) {
                hiveTable.setNumBuckets(bucketSpec.numBuckets());
                hiveTable.setBucketCols(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)bucketSpec.bucketColumnNames().toList()).asJava());
                if (bucketSpec.sortColumnNames().nonEmpty()) {
                    hiveTable.setSortCols(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)bucketSpec.sortColumnNames().map((Function1 & Serializable)col -> new Order(col, 1))).toList()).asJava());
                }
            }
        }
        return hiveTable;
    }

    public Option<String> toHiveTable$default$2() {
        return None$.MODULE$;
    }

    public Partition toHivePartition(CatalogTablePartition p, Table ht) {
        org.apache.hadoop.hive.metastore.api.Partition tpart = new org.apache.hadoop.hive.metastore.api.Partition();
        Buffer partValues = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(ht.getPartCols()).asScala().map((Function1 & Serializable)hc -> (String)p.spec().getOrElse((Object)hc.getName(), (Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Partition spec is missing a value for column '" + hc.getName() + "': " + p.spec());
        }));
        StorageDescriptor storageDesc = new StorageDescriptor();
        SerDeInfo serdeInfo = new SerDeInfo();
        p.storage().locationUri().map((Function1 & Serializable)x$26 -> CatalogUtils$.MODULE$.URIToString(x$26)).foreach((Function1 & Serializable)x$1 -> {
            storageDesc.setLocation(x$1);
            return BoxedUnit.UNIT;
        });
        p.storage().inputFormat().foreach((Function1 & Serializable)x$1 -> {
            storageDesc.setInputFormat(x$1);
            return BoxedUnit.UNIT;
        });
        p.storage().outputFormat().foreach((Function1 & Serializable)x$1 -> {
            storageDesc.setOutputFormat(x$1);
            return BoxedUnit.UNIT;
        });
        p.storage().serde().foreach((Function1 & Serializable)x$1 -> {
            serdeInfo.setSerializationLib(x$1);
            return BoxedUnit.UNIT;
        });
        serdeInfo.setParameters(CollectionConverters$.MODULE$.MapHasAsJava((Map)p.storage().properties()).asJava());
        storageDesc.setSerdeInfo(serdeInfo);
        tpart.setDbName(ht.getDbName());
        tpart.setTableName(ht.getTableName());
        tpart.setValues(CollectionConverters$.MODULE$.BufferHasAsJava(partValues).asJava());
        tpart.setSd(storageDesc);
        tpart.setCreateTime((int)TimeUnit.MILLISECONDS.toSeconds(p.createTime()));
        tpart.setLastAccessTime((int)TimeUnit.MILLISECONDS.toSeconds(p.lastAccessTime()));
        tpart.setParameters(CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)Map$.MODULE$.apply(p.parameters().toSeq())).asJava());
        return new Partition(ht, tpart);
    }

    public CatalogTablePartition fromHivePartition(Partition hp) {
        org.apache.hadoop.hive.metastore.api.Partition apiPartition = hp.getTPartition();
        scala.collection.immutable.Map properties = hp.getParameters() != null ? CollectionConverters$.MODULE$.MapHasAsScala(hp.getParameters()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()) : Predef$.MODULE$.Map().empty();
        scala.collection.immutable.Map x$1 = (scala.collection.immutable.Map)Option$.MODULE$.apply((Object)hp.getSpec()).map((Function1 & Serializable)x$27 -> CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)x$27).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty());
        CatalogStorageFormat x$2 = new CatalogStorageFormat(Option$.MODULE$.apply((Object)CatalogUtils$.MODULE$.stringToURI(apiPartition.getSd().getLocation())), Option$.MODULE$.apply((Object)apiPartition.getSd().getInputFormat()), Option$.MODULE$.apply((Object)apiPartition.getSd().getOutputFormat()), Option$.MODULE$.apply((Object)apiPartition.getSd().getSerdeInfo().getSerializationLib()), apiPartition.getSd().isCompressed(), (scala.collection.immutable.Map)Option$.MODULE$.apply((Object)apiPartition.getSd().getSerdeInfo().getParameters()).map((Function1 & Serializable)x$28 -> CollectionConverters$.MODULE$.MapHasAsScala(x$28).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        long x$3 = (long)apiPartition.getCreateTime() * 1000L;
        long x$4 = (long)apiPartition.getLastAccessTime() * 1000L;
        scala.collection.immutable.Map x$5 = properties;
        Option<CatalogStatistics> x$6 = this.org$apache$spark$sql$hive$client$HiveClientImpl$$readHiveStats((scala.collection.immutable.Map<String, String>)properties);
        return new CatalogTablePartition(x$1, x$2, x$5, x$3, x$4, x$6);
    }

    public org.apache.hadoop.hive.metastore.api.Table extraFixesForNonView(org.apache.hadoop.hive.metastore.api.Table tTable) {
        block2: {
            char[] b;
            String sf;
            String string = TableType.VIRTUAL_VIEW.toString();
            String string2 = tTable.getTableType();
            if (!(string == null ? string2 != null : !string.equals(string2))) break block2;
            java.util.Map parameters = tTable.getSd().getParameters();
            Object object = parameters != null ? ((sf = (String)parameters.get("serialization.format")) != null ? ((b = sf.toCharArray()).length == 1 && b[0] < '\n' ? parameters.put("serialization.format", Integer.toString(b[0])) : BoxedUnit.UNIT) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
            String string3 = MetadataTypedColumnsetSerDe.class.getName();
            String string4 = tTable.getSd().getSerdeInfo().getSerializationLib();
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                if (tTable.getSd().getColsSize() > 0 && ((FieldSchema)tTable.getSd().getCols().get(0)).getType().indexOf(60) == -1) {
                    tTable.getSd().getSerdeInfo().setSerializationLib(LazySimpleSerDe.class.getName());
                }
            }
        }
        return tTable;
    }

    public Option<CatalogStatistics> org$apache$spark$sql$hive$client$HiveClientImpl$$readHiveStats(scala.collection.immutable.Map<String, String> properties) {
        Option totalSize = properties.get((Object)"totalSize").filter((Function1 & Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$29)))).map((Function1 & Serializable)x$30 -> package$.MODULE$.BigInt().apply(x$30));
        Option rawDataSize = properties.get((Object)"rawDataSize").filter((Function1 & Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$31)))).map((Function1 & Serializable)x$32 -> package$.MODULE$.BigInt().apply(x$32));
        Option rowCount = properties.get((Object)"numRows").filter((Function1 & Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$33)))).map((Function1 & Serializable)x$34 -> package$.MODULE$.BigInt().apply(x$34));
        if (totalSize.isDefined() && ((Ordered)totalSize.get()).$greater((Object)BigInt$.MODULE$.long2bigInt(0L))) {
            return new Some((Object)new CatalogStatistics((BigInt)totalSize.get(), rowCount.filter((Function1 & Serializable)x$35 -> BoxesRunTime.boxToBoolean((boolean)x$35.$greater((Object)BigInt$.MODULE$.int2bigInt(0)))), CatalogStatistics$.MODULE$.apply$default$3()));
        }
        if (rawDataSize.isDefined() && ((Ordered)rawDataSize.get()).$greater((Object)BigInt$.MODULE$.int2bigInt(0))) {
            return new Some((Object)new CatalogStatistics((BigInt)rawDataSize.get(), rowCount.filter((Function1 & Serializable)x$36 -> BoxesRunTime.boxToBoolean((boolean)x$36.$greater((Object)BigInt$.MODULE$.int2bigInt(0)))), CatalogStatistics$.MODULE$.apply$default$3()));
        }
        return None$.MODULE$;
    }

    public Set<String> org$apache$spark$sql$hive$client$HiveClientImpl$$HiveStatisticsProperties() {
        return org$apache$spark$sql$hive$client$HiveClientImpl$$HiveStatisticsProperties;
    }

    public HiveConf newHiveConf(SparkConf sparkConf, Iterable<Map.Entry<String, String>> hadoopConf, scala.collection.immutable.Map<String, String> extraConfig, Option<ClassLoader> classLoader) {
        HiveConf hiveConf;
        block2: {
            String cpType;
            String engine;
            hiveConf = new HiveConf(SessionState.class);
            classLoader.foreach((Function1 & Serializable)x$1 -> {
                hiveConf.setClassLoader(x$1);
                return BoxedUnit.UNIT;
            });
            scala.collection.immutable.Map confMap = CollectionConverters$.MODULE$.IteratorHasAsScala(hadoopConf.iterator()).asScala().map((Function1 & Serializable)kv -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(kv.getKey()), kv.getValue())).$plus$plus((Function0 & Serializable)() -> Predef$.MODULE$.wrapRefArray((Object[])sparkConf.getAll()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).$plus$plus((Function0 & Serializable)() -> extraConfig).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            confMap.foreach((Function1 & Serializable)x0$1 -> {
                HiveClientImpl$.$anonfun$newHiveConf$5(hiveConf, x0$1);
                return BoxedUnit.UNIT;
            });
            SQLConf$.MODULE$.get().redactOptions(confMap).foreach((Function1 & Serializable)x0$2 -> {
                HiveClientImpl$.$anonfun$newHiveConf$6(x0$2);
                return BoxedUnit.UNIT;
            });
            hiveConf.setBoolean("hive.cbo.enable", false);
            if (hiveConf.getBoolean("hive.session.history.enabled", false)) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Detected HiveConf hive.session.history.enabled is true and will be reset to false to disable useless hive logic");
                hiveConf.setBoolean("hive.session.history.enabled", false);
            }
            String string = engine = hiveConf.get("hive.execution.engine");
            String string2 = "mr";
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Detected HiveConf hive.execution.engine is '", "' and "}))).log((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.ENGINE$.MODULE$, (Object)engine)})).$plus(MODULE$.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"will be reset to 'mr' to disable useless hive logic"}))).log((scala.collection.immutable.Seq)Nil$.MODULE$))));
                hiveConf.set("hive.execution.engine", "mr", SparkHadoopUtil$.MODULE$.SOURCE_SPARK());
            }
            if (!"bonecp".equalsIgnoreCase(cpType = hiveConf.get("datanucleus.connectionPoolingType"))) break block2;
            hiveConf.set("datanucleus.connectionPoolingType", "DBCP", SparkHadoopUtil$.MODULE$.SOURCE_SPARK());
        }
        return hiveConf;
    }

    public scala.collection.immutable.Map<String, String> newHiveConf$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public Option<ClassLoader> newHiveConf$default$4() {
        return None$.MODULE$;
    }

    public Hive getHive(Configuration conf) {
        Hive hive;
        HiveConf hiveConf;
        Configuration configuration = conf;
        HiveConf hiveConf2 = configuration instanceof HiveConf ? (hiveConf = (HiveConf)configuration) : new HiveConf(conf, HiveConf.class);
        try {
            hive = Hive.getWithoutRegisterFns((HiveConf)hiveConf2);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            hive = Hive.get((HiveConf)hiveConf2);
        }
        return hive;
    }

    public static final /* synthetic */ boolean $anonfun$toHiveTable$2(CatalogTable table$9, FieldSchema c) {
        return table$9.partitionColumnNames().contains((Object)c.getName());
    }

    public static final /* synthetic */ void $anonfun$toHiveTable$7(Table hiveTable$5, String loc) {
        hiveTable$5.getTTable().getSd().setLocation(loc);
    }

    public static final /* synthetic */ void $anonfun$toHiveTable$14(Table hiveTable$5, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            hiveTable$5.setProperty(k, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$toHiveTable$16(Table hiveTable$5, String t) {
        hiveTable$5.setViewOriginalText(t);
        hiveTable$5.setViewExpandedText(t);
    }

    public static final /* synthetic */ void $anonfun$newHiveConf$5(HiveConf hiveConf$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            hiveConf$1.set(k, v, SparkHadoopUtil$.MODULE$.SOURCE_SPARK());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$newHiveConf$6(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> "Applying Hadoop/Hive/Spark and extra properties to Hive Conf:" + k + "=" + v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private HiveClientImpl$() {
    }
}

