/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.sql.hive.execution.HiveComparisonTest;
import org.apache.spark.sql.hive.test.TestHive$;
import org.apache.spark.sql.hive.test.TestHiveSparkSession;
import org.apache.spark.tags.SlowHiveTest;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@SlowHiveTest
@ScalaSignature(bytes="\u0006\u0005\u00114A\u0001C\u0005\u0001-!)1\u0004\u0001C\u00019!9a\u0004\u0001b\u0001\n\u0003y\u0002B\u0002\u0015\u0001A\u0003%\u0001\u0005C\u0004*\u0001\t\u0007I\u0011\u0001\u0016\t\rE\u0002\u0001\u0015!\u0003,\u0011\u001d\u0011\u0004A1A\u0005\u0002MBa\u0001\u0018\u0001!\u0002\u0013!$!\u0006\"jO\u0012\u000bG/\u0019\"f]\u000eDW.\u0019:l'VLG/\u001a\u0006\u0003\u0015-\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u00051i\u0011\u0001\u00025jm\u0016T!AD\b\u0002\u0007M\fHN\u0003\u0002\u0011#\u0005)1\u000f]1sW*\u0011!cE\u0001\u0007CB\f7\r[3\u000b\u0003Q\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\f\u0011\u0005aIR\"A\u0005\n\u0005iI!A\u0005%jm\u0016\u001cu.\u001c9be&\u001cxN\u001c+fgR\fa\u0001P5oSRtD#A\u000f\u0011\u0005a\u0001\u0011!\u0005;fgR$\u0015\r^1ESJ,7\r^8ssV\t\u0001\u0005\u0005\u0002\"M5\t!E\u0003\u0002$I\u0005\u0011\u0011n\u001c\u0006\u0002K\u0005!!.\u0019<b\u0013\t9#E\u0001\u0003GS2,\u0017A\u0005;fgR$\u0015\r^1ESJ,7\r^8ss\u0002\nQ\"^:feZK7/\u001b;QCRDW#A\u0016\u0011\u00051zS\"A\u0017\u000b\u00059\"\u0013\u0001\u00027b]\u001eL!\u0001M\u0017\u0003\rM#(/\u001b8h\u00039)8/\u001a:WSNLG\u000fU1uQ\u0002\n!\u0002^3tiR\u000b'\r\\3t+\u0005!\u0004cA\u001b=}5\taG\u0003\u00028q\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003si\n!bY8mY\u0016\u001cG/[8o\u0015\u0005Y\u0014!B:dC2\f\u0017BA\u001f7\u0005\r\u0019V-\u001d\t\u0003\u007fas!\u0001\u0011+\u000f\u0005\u0005\u000bfB\u0001\"P\u001d\t\u0019eJ\u0004\u0002E\u001b:\u0011Q\t\u0014\b\u0003\r.s!a\u0012&\u000e\u0003!S!!S\u000b\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0012B\u0001\n\u0014\u0013\t\u0001\u0012#\u0003\u0002\u000f\u001f%\u0011A\"D\u0005\u0003!.\tA\u0001^3ti&\u0011!kU\u0001\t)\u0016\u001cH\u000fS5wK*\u0011\u0001kC\u0005\u0003+Z\u000bAb\u001d9be.\u001cVm]:j_:L!aV*\u0003\u001fQ+7\u000f\u001e%jm\u0016\u001cuN\u001c;fqRL!!\u0017.\u0003\u0013Q+7\u000f\u001e+bE2,\u0017BA.T\u0005Q!Vm\u001d;ISZ,7\u000b]1sWN+7o]5p]\u0006YA/Z:u)\u0006\u0014G.Z:!Q\t\u0001a\f\u0005\u0002`E6\t\u0001M\u0003\u0002b\u001f\u0005!A/Y4t\u0013\t\u0019\u0007M\u0001\u0007TY><\b*\u001b<f)\u0016\u001cH\u000f")
public class BigDataBenchmarkSuite
extends HiveComparisonTest {
    private final File testDataDirectory = new File("target" + File.separator + "big-data-benchmark-testdata");
    private final String userVisitPath = new File(this.testDataDirectory(), "uservisits").getCanonicalPath();
    private final Seq<TestHiveSparkSession.TestTable> testTables = new .colon.colon((Object)new TestHiveSparkSession.TestTable(TestHive$.MODULE$.sparkSession(), "rankings", (Seq<Function0<BoxedUnit>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{TestHive$.MODULE$.sparkSession().SqlCmd(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |CREATE EXTERNAL TABLE rankings (\n        |  pageURL STRING,\n        |  pageRank INT,\n        |  avgDuration INT)\n        |  ROW FORMAT DELIMITED FIELDS TERMINATED BY \",\"\n        |  STORED AS TEXTFILE LOCATION \"" + new File(this.testDataDirectory(), "rankings").getCanonicalPath() + "\"\n      "))).cmd()})), (List)new .colon.colon((Object)new TestHiveSparkSession.TestTable(TestHive$.MODULE$.sparkSession(), "scratch", (Seq<Function0<BoxedUnit>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{TestHive$.MODULE$.sparkSession().SqlCmd(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |CREATE EXTERNAL TABLE scratch (\n        |  pageURL STRING,\n        |  pageRank INT,\n        |  avgDuration INT)\n        |  ROW FORMAT DELIMITED FIELDS TERMINATED BY \",\"\n        |  STORED AS TEXTFILE LOCATION \"" + new File(this.testDataDirectory(), "scratch").getCanonicalPath() + "\"\n      "))).cmd()})), (List)new .colon.colon((Object)new TestHiveSparkSession.TestTable(TestHive$.MODULE$.sparkSession(), "uservisits", (Seq<Function0<BoxedUnit>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{TestHive$.MODULE$.sparkSession().SqlCmd(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |CREATE EXTERNAL TABLE uservisits (\n        |  sourceIP STRING,\n        |  destURL STRING,\n        |  visitDate STRING,\n        |  adRevenue DOUBLE,\n        |  userAgent STRING,\n        |  countryCode STRING,\n        |  languageCode STRING,\n        |  searchWord STRING,\n        |  duration INT)\n        |  ROW FORMAT DELIMITED FIELDS TERMINATED BY \",\"\n        |  STORED AS TEXTFILE LOCATION \"" + this.userVisitPath() + "\"\n      "))).cmd()})), (List)new .colon.colon((Object)new TestHiveSparkSession.TestTable(TestHive$.MODULE$.sparkSession(), "documents", (Seq<Function0<BoxedUnit>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{TestHive$.MODULE$.sparkSession().SqlCmd(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |CREATE EXTERNAL TABLE documents (line STRING)\n        |STORED AS TEXTFILE\n        |LOCATION \"" + new File(this.testDataDirectory(), "crawl").getCanonicalPath() + "\"\n      "))).cmd()})), (List)Nil$.MODULE$))));

    public File testDataDirectory() {
        return this.testDataDirectory;
    }

    public String userVisitPath() {
        return this.userVisitPath;
    }

    public Seq<TestHiveSparkSession.TestTable> testTables() {
        return this.testTables;
    }

    public static final /* synthetic */ void $anonfun$new$1(TestHiveSparkSession.TestTable testTable) {
        TestHive$.MODULE$.sparkSession().registerTestTable(testTable);
    }

    public BigDataBenchmarkSuite() {
        this.testTables().foreach((Function1 & Serializable)testTable -> {
            BigDataBenchmarkSuite.$anonfun$new$1(testTable);
            return BoxedUnit.UNIT;
        });
        if (!this.testDataDirectory().exists()) {
            this.ignore("No data files found for BigDataBenchmark tests.", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {}, new Position("BigDataBenchmarkSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        } else {
            this.createQueryTest("query1", "SELECT pageURL, pageRank FROM rankings WHERE pageRank > 1", this.createQueryTest$default$3(), this.createQueryTest$default$4(), this.createQueryTest$default$5());
            this.createQueryTest("query2", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |SELECT SUBSTR(sourceIP, 1, 10), SUM(adRevenue) FROM uservisits\n        |GROUP BY SUBSTR(sourceIP, 1, 10)\n      ")), this.createQueryTest$default$3(), this.createQueryTest$default$4(), this.createQueryTest$default$5());
            this.createQueryTest("query3", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |SELECT sourceIP,\n        |       sum(adRevenue) as totalRevenue,\n        |       avg(pageRank) as pageRank\n        |FROM\n        |  rankings R JOIN\n        |  (SELECT sourceIP, destURL, adRevenue\n        |   FROM uservisits UV\n        |   WHERE UV.visitDate > \"1980-01-01\"\n        |   AND UV.visitDate < \"1980-04-01\")\n        |   NUV ON (R.pageURL = NUV.destURL)\n        |GROUP BY sourceIP\n        |ORDER BY totalRevenue DESC\n        |LIMIT 1\n      ")), this.createQueryTest$default$3(), this.createQueryTest$default$4(), this.createQueryTest$default$5());
            this.createQueryTest("query4", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |DROP TABLE IF EXISTS url_counts_partial;\n        |CREATE TABLE url_counts_partial AS\n        |  SELECT TRANSFORM (line)\n        |  USING 'python3 target/url_count.py' as (sourcePage,\n        |    destPage, count) from documents;\n        |DROP TABLE IF EXISTS url_counts_total;\n        |CREATE TABLE url_counts_total AS\n        |  SELECT SUM(count) AS totalCount, destpage\n        |  FROM url_counts_partial GROUP BY destpage\n        |-- The following queries run, but generate different results in HIVE\n        |-- likely because the UDF is not deterministic given different input splits.\n        |-- SELECT CAST(SUM(count) AS INT) FROM url_counts_partial\n        |-- SELECT COUNT(*) FROM url_counts_partial\n        |-- SELECT * FROM url_counts_partial\n        |-- SELECT * FROM url_counts_total\n      ")), this.createQueryTest$default$3(), this.createQueryTest$default$4(), this.createQueryTest$default$5());
        }
    }
}

