/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.net.URL;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.package$;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.connector.catalog.CatalogManager$;
import org.apache.spark.sql.execution.command.DDLSuite;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.orc.OrcCompressionCodec;
import org.apache.spark.sql.execution.datasources.orc.OrcUtils$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetCompressionCodec;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFooterReader;
import org.apache.spark.sql.execution.streaming.MemoryStream;
import org.apache.spark.sql.execution.streaming.MemoryStream$;
import org.apache.spark.sql.hive.HiveExternalCatalog;
import org.apache.spark.sql.hive.HiveExternalCatalog$;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.execution.HiveDDLSuite$;
import org.apache.spark.sql.hive.orc.OrcFileOperator$;
import org.apache.spark.sql.hive.test.TestHive$;
import org.apache.spark.sql.hive.test.TestHiveContext;
import org.apache.spark.sql.hive.test.TestHiveSingleton;
import org.apache.spark.sql.hive.test.TestHiveSparkSession;
import org.apache.spark.sql.internal.HiveSerDe;
import org.apache.spark.sql.internal.HiveSerDe$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.tags.SlowHiveTest;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.ArrayOps;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@SlowHiveTest
@ScalaSignature(bytes="\u0006\u0005\t%b\u0001\u0002\r\u001a\u0001\u0019BQa\u0010\u0001\u0005\u0002\u0001Cqa\u0011\u0001C\u0002\u0013\u0005A\t\u0003\u0004X\u0001\u0001\u0006I!\u0012\u0005\u00061\u0002!\t%\u0017\u0005\u0006=\u0002!\tf\u0018\u0005\n\u0003/\u0001\u0011\u0013!C\t\u00033Aq!a\f\u0001\t#\n\t\u0004C\u0004\u00028\u0001!I!!\u000f\t\u0013\u0005%\u0003!%A\u0005\n\u0005-\u0003bBA(\u0001\u0011%\u0011\u0011\u000b\u0005\b\u0003K\u0002A\u0011BA4\u0011\u001d\ti\b\u0001C\u0005\u0003\u007fBq!!#\u0001\t\u0013\tY\tC\u0004\u0002\u0016\u0002!I!a&\t\u000f\u0005u\u0005\u0001\"\u0003\u0002 \"9\u0011Q\u0015\u0001\u0005\n\u0005\u001d\u0006bBAW\u0001\u0011%\u0011q\u0016\u0005\b\u0003k\u0003A\u0011BA\\\u0011\u001d\ti\f\u0001C\u0005\u0003\u007fCq!!6\u0001\t\u0013\t9\u000eC\u0004\u0002b\u0002!I!a9\t\u000f\u0005%\b\u0001\"\u0003\u0002l\"9!q\u0001\u0001\u0005\n\t%!\u0001\u0004%jm\u0016$E\tT*vSR,'B\u0001\u000e\u001c\u0003%)\u00070Z2vi&|gN\u0003\u0002\u001d;\u0005!\u0001.\u001b<f\u0015\tqr$A\u0002tc2T!\u0001I\u0011\u0002\u000bM\u0004\u0018M]6\u000b\u0005\t\u001a\u0013AB1qC\u000eDWMC\u0001%\u0003\ry'oZ\u0002\u0001'\u0015\u0001qE\f\u001b:!\tAC&D\u0001*\u0015\tQ3&A\u0004d_6l\u0017M\u001c3\u000b\u0005ii\u0012BA\u0017*\u0005!!E\tT*vSR,\u0007CA\u00183\u001b\u0005\u0001$BA\u0019\u001e\u0003\u0011!Xm\u001d;\n\u0005M\u0002$\u0001D*R\u0019R+7\u000f^+uS2\u001c\bCA\u001b8\u001b\u00051$BA\u0019\u001c\u0013\tAdGA\tUKN$\b*\u001b<f'&tw\r\\3u_:\u0004\"AO\u001f\u000e\u0003mR!\u0001P\u0012\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018B\u0001 <\u0005I\u0011UMZ8sK\u0006sG-\u00114uKJ,\u0015m\u00195\u0002\rqJg.\u001b;?)\u0005\t\u0005C\u0001\"\u0001\u001b\u0005I\u0012a\u00035jm\u00164uN]7biN,\u0012!\u0012\t\u0004\r6{U\"A$\u000b\u0005!K\u0015!C5n[V$\u0018M\u00197f\u0015\tQ5*\u0001\u0006d_2dWm\u0019;j_:T\u0011\u0001T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001d\u001e\u00131aU3r!\t\u0001V+D\u0001R\u0015\t\u00116+\u0001\u0003mC:<'\"\u0001+\u0002\t)\fg/Y\u0005\u0003-F\u0013aa\u0015;sS:<\u0017\u0001\u00045jm\u00164uN]7biN\u0004\u0013!C1gi\u0016\u0014X)Y2i)\u0005Q\u0006CA.]\u001b\u0005Y\u0015BA/L\u0005\u0011)f.\u001b;\u0002\u001b\u001d,g.\u001a:bi\u0016$\u0016M\u00197f)\u0015\u0001\u0007\u000e\u001c:x!\t\tg-D\u0001c\u0015\t\u0019G-A\u0004dCR\fGn\\4\u000b\u0005\u0015l\u0012\u0001C2bi\u0006d\u0017p\u001d;\n\u0005\u001d\u0014'\u0001D\"bi\u0006dwn\u001a+bE2,\u0007\"B2\u0006\u0001\u0004I\u0007CA1k\u0013\tY'M\u0001\bTKN\u001c\u0018n\u001c8DCR\fGn\\4\t\u000b5,\u0001\u0019\u00018\u0002\t9\fW.\u001a\t\u0003_Bl\u0011\u0001Z\u0005\u0003c\u0012\u0014q\u0002V1cY\u0016LE-\u001a8uS\u001aLWM\u001d\u0005\bg\u0016\u0001\n\u00111\u0001u\u00031I7\u000fR1uCN{WO]2f!\tYV/\u0003\u0002w\u0017\n9!i\\8mK\u0006t\u0007b\u0002=\u0006!\u0003\u0005\r!_\u0001\u000ea\u0006\u0014H/\u001b;j_:\u001cu\u000e\\:\u0011\u000bi\f)!!\u0003\u000f\u0007m\f\tA\u0004\u0002}\u007f6\tQP\u0003\u0002\u007fK\u00051AH]8pizJ\u0011\u0001T\u0005\u0004\u0003\u0007Y\u0015a\u00029bG.\fw-Z\u0005\u0004\u001d\u0006\u001d!bAA\u0002\u0017B!\u00111BA\n\u001d\u0011\ti!a\u0004\u0011\u0005q\\\u0015bAA\t\u0017\u00061\u0001K]3eK\u001aL1AVA\u000b\u0015\r\t\tbS\u0001\u0018O\u0016tWM]1uKR\u000b'\r\\3%I\u00164\u0017-\u001e7uIQ*\"!a\u0007+\u0007e\fib\u000b\u0002\u0002 A!\u0011\u0011EA\u0016\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012!C;oG\",7m[3e\u0015\r\tIcS\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0017\u0003G\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003UqwN]7bY&TXmQ1uC2|w\rV1cY\u0016$2\u0001YA\u001a\u0011\u0019\t)d\u0002a\u0001A\u0006)A/\u00192mK\u0006!B/\u00192mK\u0012K'/Z2u_JLX\t_5tiN$R\u0001^A\u001e\u0003\u007fAa!!\u0010\t\u0001\u0004q\u0017a\u0004;bE2,\u0017\nZ3oi&4\u0017.\u001a:\t\u0013\u0005\u0005\u0003\u0002%AA\u0002\u0005\r\u0013A\u00023c!\u0006$\b\u000eE\u0003\\\u0003\u000b\nI!C\u0002\u0002H-\u0013aa\u00149uS>t\u0017A\b;bE2,G)\u001b:fGR|'/_#ySN$8\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tiE\u000b\u0003\u0002D\u0005u\u0011\u0001H1tg\u0016\u0014H/\u00118bYf\u001c\u0018n]#se>\u00148i\u001c8eSRLwN\u001c\u000b\b5\u0006M\u0013qKA.\u0011\u001d\t)F\u0003a\u0001\u0003\u0013\tqa]9m)\u0016DH\u000fC\u0004\u0002Z)\u0001\r!!\u0003\u0002\u0013\r|g\u000eZ5uS>t\u0007bBA/\u0015\u0001\u0007\u0011qL\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\b\u0003CA\u0006\u0003C\nI!!\u0003\n\t\u0005\r\u0014Q\u0003\u0002\u0004\u001b\u0006\u0004\u0018AG2sK\u0006$X\rR1uC\n\f7/Z,ji\"dunY1uS>tG#\u0002.\u0002j\u0005e\u0004bBA6\u0017\u0001\u0007\u0011QN\u0001\u0007i6\u0004H)\u001b:\u0011\t\u0005=\u0014QO\u0007\u0003\u0003cR1!a\u001dT\u0003\tIw.\u0003\u0003\u0002x\u0005E$\u0001\u0002$jY\u0016Da!a\u001f\f\u0001\u0004!\u0018!\u00033je\u0016C\u0018n\u001d;t\u00031!'o\u001c9ECR\f'-Y:f)\u0015Q\u0016\u0011QAC\u0011\u0019\t\u0019\t\u0004a\u0001i\u000691-Y:dC\u0012,\u0007BBAD\u0019\u0001\u0007A/A\u0006uC\ndW-\u0012=jgR\u001c\u0018aG<ji\"\u001c%/Z1uKR\u000b'\r\\3MS.,G+Z7q-&,w\u000fF\u0003[\u0003\u001b\u000b\t\nC\u0004\u0002\u00106\u0001\r!a\u0011\u0002\u00111|7-\u0019;j_:Dq!a%\u000e\u0001\u0004\t\u0019%\u0001\u0005qe>4\u0018\u000eZ3s\u0003i9\u0018\u000e\u001e5De\u0016\fG/\u001a+bE2,G*[6f\tN#\u0016M\u00197f)\u0015Q\u0016\u0011TAN\u0011\u001d\tyI\u0004a\u0001\u0003\u0007Bq!a%\u000f\u0001\u0004\t\u0019%A\u000fxSRD7I]3bi\u0016$\u0016M\u00197f\u0019&\\W-\u0012=u\tN#\u0016M\u00197f)\u0015Q\u0016\u0011UAR\u0011\u001d\tyi\u0004a\u0001\u0003\u0007Bq!a%\u0010\u0001\u0004\t\u0019%A\u0012xSRD7I]3bi\u0016$\u0016M\u00197f\u0019&\\W-T1oC\u001e,G\rS5wKR\u000b'\r\\3\u0015\u000bi\u000bI+a+\t\u000f\u0005=\u0005\u00031\u0001\u0002D!9\u00111\u0013\tA\u0002\u0005\r\u0013aH<ji\"\u001c%/Z1uKR\u000b'\r\\3MS.,W\t\u001f;ISZ,G+\u00192mKR)!,!-\u00024\"9\u0011qR\tA\u0002\u0005\r\u0003bBAJ#\u0001\u0007\u00111I\u0001\u0018o&$\bn\u0011:fCR,G+\u00192mK2K7.\u001a,jK^$RAWA]\u0003wCq!a$\u0013\u0001\u0004\t\u0019\u0005C\u0004\u0002\u0014J\u0001\r!a\u0011\u0002)\rDWmY6De\u0016\fG/\u001a+bE2,G*[6f)%Q\u0016\u0011YAc\u0003\u0013\f\u0019\u000e\u0003\u0004\u0002DN\u0001\r\u0001Y\u0001\fg>,(oY3UC\ndW\r\u0003\u0004\u0002HN\u0001\r\u0001Y\u0001\fi\u0006\u0014x-\u001a;UC\ndW\rC\u0004\u0002LN\u0001\r!!4\u0002\u0013Q\f'\r\\3UsB,\u0007cA1\u0002P&\u0019\u0011\u0011\u001b2\u0003!\r\u000bG/\u00197pOR\u000b'\r\\3UsB,\u0007bBAJ'\u0001\u0007\u00111I\u0001\"G\",7m[!we>\u001c6\r[3nC\u00163x\u000e\\;uS>t\u0017\t\u001a3D_2,XN\u001c\u000b\u00065\u0006e\u0017Q\u001c\u0005\b\u00037$\u0002\u0019AA\u0005\u0003]y'/[4j]\u0006d7+\u001a:eKB\u0013x\u000e]3si&,7\u000fC\u0004\u0002`R\u0001\r!!\u0003\u0002-\u00154x\u000e\u001c<fIN+'\u000fZ3Qe>\u0004XM\u001d;jKN\fAe\u00195fG.\feO]8TG\",W.Y#w_2,H/[8o%\u0016lwN^3D_2,XN\u001c\u000b\u00065\u0006\u0015\u0018q\u001d\u0005\b\u00037,\u0002\u0019AA\u0005\u0011\u001d\ty.\u0006a\u0001\u0003\u0013\t\u0011#Y:tKJ$8i\\7qe\u0016\u001c8/[8o)!\ti/!?\u0002\u0000\n\r\u0001\u0003BAx\u0003gt1AOAy\u0013\r\t\u0019aO\u0005\u0005\u0003k\f9PA\u0005BgN,'\u000f^5p]*\u0019\u00111A\u001e\t\u000f\u0005mh\u00031\u0001\u0002~\u0006IQ.Y=cK\u001aKG.\u001a\t\u00067\u0006\u0015\u0013Q\u000e\u0005\b\u0005\u00031\u0002\u0019AA\u0005\u0003\u00191wN]7bi\"9!Q\u0001\fA\u0002\u0005%\u0011aC2p[B\u0014Xm]:j_:\f\u0011bZ3u%\u0016\fG-\u001a:\u0015\t\t-!q\u0003\t\u0005\u0005\u001b\u0011\u0019\"\u0004\u0002\u0003\u0010)\u0019!\u0011C\u0011\u0002\u0007=\u00148-\u0003\u0003\u0003\u0016\t=!A\u0002*fC\u0012,'\u000fC\u0004\u0003\u001a]\u0001\r!!\u0003\u0002\tA\fG\u000f\u001b\u0015\u0004\u0001\tu\u0001\u0003\u0002B\u0010\u0005Ki!A!\t\u000b\u0007\t\rr$\u0001\u0003uC\u001e\u001c\u0018\u0002\u0002B\u0014\u0005C\u0011Ab\u00157po\"Kg/\u001a+fgR\u0004")
public class HiveDDLSuite
extends DDLSuite
implements TestHiveSingleton {
    private final scala.collection.immutable.Seq<String> hiveFormats;
    private boolean enableAutoThreadAudit;
    private SparkSession spark;
    private TestHiveContext hiveContext;
    private HiveClient hiveClient;

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public void afterAll() {
        TestHiveSingleton.afterAll$(this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public TestHiveContext hiveContext() {
        return this.hiveContext;
    }

    @Override
    public HiveClient hiveClient() {
        return this.hiveClient;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveContext_$eq(TestHiveContext x$1) {
        this.hiveContext = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveClient_$eq(HiveClient x$1) {
        this.hiveClient = x$1;
    }

    public scala.collection.immutable.Seq<String> hiveFormats() {
        return this.hiveFormats;
    }

    @Override
    public void afterEach() {
        try {
            this.spark().sessionState().catalog().reset();
        }
        finally {
            TestHiveSingleton.afterEach$(this);
        }
    }

    public CatalogTable generateTable(SessionCatalog catalog, TableIdentifier name, boolean isDataSource, scala.collection.immutable.Seq<String> partitionCols) {
        CatalogStorageFormat catalogStorageFormat;
        if (isDataSource) {
            Option serde = HiveSerDe$.MODULE$.sourceToSerDe("parquet");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(serde.isDefined(), "serde.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The default format is not Hive compatible", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            catalogStorageFormat = new CatalogStorageFormat((Option)new Some((Object)catalog.defaultTablePath(name)), ((HiveSerDe)serde.get()).inputFormat(), ((HiveSerDe)serde.get()).outputFormat(), ((HiveSerDe)serde.get()).serde(), false, Predef$.MODULE$.Map().empty());
        } else {
            catalogStorageFormat = new CatalogStorageFormat((Option)new Some((Object)catalog.defaultTablePath(name)), (Option)new Some((Object)"org.apache.hadoop.mapred.SequenceFileInputFormat"), (Option)new Some((Object)"org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat"), (Option)new Some((Object)"org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe"), false, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"serialization.format"), (Object)"1")})));
        }
        CatalogStorageFormat storage = catalogStorageFormat;
        Metadata metadata = new MetadataBuilder().putString("key", "value").build();
        StructType schema = new StructType().add("col1", "int", true, metadata).add("col2", "string");
        TableIdentifier x$12 = name;
        CatalogTableType x$2 = CatalogTableType$.MODULE$.EXTERNAL();
        CatalogStorageFormat x$3 = storage;
        StructType x$4 = schema.copy((StructField[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (IterableOnce)partitionCols.map((Function1 & Serializable)x$1 -> new StructField(x$1, (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())), ClassTag$.MODULE$.apply(StructField.class)));
        Some x$5 = isDataSource ? new Some((Object)"parquet") : new Some((Object)"hive");
        scala.collection.immutable.Seq<String> x$6 = partitionCols;
        long x$7 = 0L;
        String x$8 = package$.MODULE$.SPARK_VERSION();
        boolean x$9 = true;
        Option x$10 = CatalogTable$.MODULE$.apply$default$7();
        String x$11 = CatalogTable$.MODULE$.apply$default$8();
        long x$122 = CatalogTable$.MODULE$.apply$default$10();
        Map x$13 = CatalogTable$.MODULE$.apply$default$12();
        Option x$14 = CatalogTable$.MODULE$.apply$default$13();
        Option x$15 = CatalogTable$.MODULE$.apply$default$14();
        Option x$16 = CatalogTable$.MODULE$.apply$default$15();
        Option x$17 = CatalogTable$.MODULE$.apply$default$16();
        scala.collection.immutable.Seq x$18 = CatalogTable$.MODULE$.apply$default$17();
        boolean x$19 = CatalogTable$.MODULE$.apply$default$19();
        Map x$20 = CatalogTable$.MODULE$.apply$default$20();
        Option x$21 = CatalogTable$.MODULE$.apply$default$21();
        return new CatalogTable(x$12, x$2, x$3, x$4, (Option)x$5, x$6, x$10, x$11, 0L, x$122, x$8, x$13, x$14, x$15, x$16, x$17, x$18, true, x$19, x$20, x$21);
    }

    public scala.collection.immutable.Seq<String> generateTable$default$4() {
        return new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$));
    }

    public CatalogTable normalizeCatalogTable(CatalogTable table) {
        Set nondeterministicProps = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"CreateTime", "transient_lastDdlTime", "grantTime", "lastUpdateTime", "last_modified_by", "last_modified_time", "Owner:", "COLUMN_STATS_ACCURATE", "numFiles", "numRows", "rawDataSize", "totalSize", "totalNumberFiles", "maxFileSize", "minFileSize"}));
        long x$1 = 0L;
        long x$2 = 0L;
        String x$3 = "";
        Map x$4 = (Map)table.properties().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)HiveDDLSuite.$anonfun$normalizeCatalogTable$1(nondeterministicProps, x0$1)));
        None$ x$5 = None$.MODULE$;
        TableIdentifier x$6 = table.copy$default$1();
        CatalogTableType x$7 = table.copy$default$2();
        CatalogStorageFormat x$8 = table.copy$default$3();
        StructType x$9 = table.copy$default$4();
        Option x$10 = table.copy$default$5();
        scala.collection.immutable.Seq x$11 = table.copy$default$6();
        Option x$12 = table.copy$default$7();
        String x$13 = table.copy$default$11();
        Option x$14 = table.copy$default$13();
        Option x$15 = table.copy$default$15();
        Option x$16 = table.copy$default$16();
        scala.collection.immutable.Seq x$17 = table.copy$default$17();
        boolean x$18 = table.copy$default$18();
        boolean x$19 = table.copy$default$19();
        Map x$20 = table.copy$default$20();
        Option x$21 = table.copy$default$21();
        return table.copy(x$6, x$7, x$8, x$9, x$10, x$11, x$12, "", 0L, 0L, x$13, x$4, x$14, (Option)x$5, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
    }

    private boolean tableDirectoryExists(TableIdentifier tableIdentifier, Option<String> dbPath) {
        URI expectedTablePath = dbPath.isEmpty() ? this.hiveContext().sessionState().catalog().defaultTablePath(tableIdentifier) : new Path(new Path((String)dbPath.get()), tableIdentifier.table()).toUri();
        Path filesystemPath = new Path(expectedTablePath.toString());
        FileSystem fs = filesystemPath.getFileSystem(this.spark().sessionState().newHadoopConf());
        return fs.exists(filesystemPath);
    }

    private Option<String> tableDirectoryExists$default$2() {
        return None$.MODULE$;
    }

    private void assertAnalysisErrorCondition(String sqlText, String condition, Map<String, String> parameters) {
        AnalysisException e;
        AnalysisException x$1 = e = (AnalysisException)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)sqlText), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 776));
        String x$2 = condition;
        Map<String, String> x$3 = parameters;
        Option x$4 = this.checkError$default$3();
        boolean x$5 = this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
        this.checkError((SparkThrowable)x$1, x$2, x$4, x$3, x$5, x$6);
    }

    private void createDatabaseWithLocation(File tmpDir, boolean dirExists) {
        SessionCatalog catalog = this.spark().sessionState().catalog();
        String dbName = "db1";
        String tabName = "tab1";
        FileSystem fs = new Path(tmpDir.toString()).getFileSystem(this.spark().sessionState().newHadoopConf());
        this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tabName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            if (dirExists) {
                Object $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])tmpDir.listFiles());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left), Prettifier$.MODULE$.default());
                v0 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1254));
            } else {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(fs.exists(new Path(tmpDir.toString())), "fs.exists(new org.apache.hadoop.fs.Path(tmpDir.toString()))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                v0 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1256));
            }
            this.sql().apply((Object)("CREATE DATABASE " + dbName + " Location '" + StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(tmpDir.toURI().getPath()), "/") + "'"));
            CatalogDatabase db1 = catalog.getDatabaseMetadata(dbName);
            URI dbPath = new URI(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(tmpDir.toURI().toString()), "/"));
            Map x$1 = (Map)db1.properties().$minus$minus((IterableOnce)new .colon.colon((Object)"owner", (List)Nil$.MODULE$));
            String x$2 = db1.copy$default$1();
            String x$3 = db1.copy$default$2();
            URI x$4 = db1.copy$default$3();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(db1.copy(x$2, x$3, x$4, x$1));
            CatalogDatabase $org_scalatest_assert_macro_right = new CatalogDatabase(dbName, "", dbPath, Predef$.MODULE$.Map().empty());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1261));
            this.sql().apply((Object)"USE db1");
            this.sql().apply((Object)("CREATE TABLE " + tabName + " as SELECT 1"));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.tableDirectoryExists(TableIdentifier$.MODULE$.apply(tabName), (Option<String>)Option$.MODULE$.apply((Object)tmpDir.toString())), "HiveDDLSuite.this.tableDirectoryExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(tabName), scala.Option.apply[String](tmpDir.toString()))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1266));
            Object $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])tmpDir.listFiles());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left2), "nonEmpty", ArrayOps$.MODULE$.nonEmpty$extension($org_scalatest_assert_macro_left2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1268));
            this.sql().apply((Object)("DROP TABLE " + tabName));
            Object $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])tmpDir.listFiles());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left3), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1271));
            this.sql().apply((Object)"USE default");
            this.sql().apply((Object)("DROP DATABASE " + dbName));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(fs.exists(new Path(tmpDir.toString())), "fs.exists(new org.apache.hadoop.fs.Path(tmpDir.toString()))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1274));
        });
    }

    private void dropDatabase(boolean cascade, boolean tableExists) {
        String dbName = "db1";
        Path dbPath = new Path(this.spark().sessionState().conf().warehousePath());
        FileSystem fs = dbPath.getFileSystem(this.spark().sessionState().newHadoopConf());
        this.sql().apply((Object)("CREATE DATABASE " + dbName));
        SessionCatalog catalog = this.spark().sessionState().catalog();
        String expectedDBLocation = "file:" + StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(dbPath.toUri().getPath()), "/") + "/" + dbName + ".db";
        URI expectedDBUri = CatalogUtils$.MODULE$.stringToURI(expectedDBLocation);
        CatalogDatabase db1 = catalog.getDatabaseMetadata(dbName);
        Map x$1 = (Map)db1.properties().$minus$minus((IterableOnce)new .colon.colon((Object)"owner", (List)Nil$.MODULE$));
        String x$2 = db1.copy$default$1();
        String x$3 = db1.copy$default$2();
        URI x$4 = db1.copy$default$3();
        CatalogDatabase $org_scalatest_assert_macro_left = db1.copy(x$2, x$3, x$4, x$1);
        CatalogDatabase $org_scalatest_assert_macro_right = new CatalogDatabase(dbName, "", expectedDBUri, Predef$.MODULE$.Map().empty());
        CatalogDatabase catalogDatabase = $org_scalatest_assert_macro_left;
        CatalogDatabase catalogDatabase2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(catalogDatabase != null ? !catalogDatabase.equals(catalogDatabase2) : catalogDatabase2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1300));
        Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.simpleMacroBool(fs.exists(dbPath), "fs.exists(dbPath)", Prettifier$.MODULE$.default());
        Bool $org_scalatest_assert_macro_right2 = $org_scalatest_assert_macro_left2.value() ? Bool$.MODULE$.simpleMacroBool(fs.getFileStatus(dbPath).isDirectory(), "fs.getFileStatus(dbPath).isDirectory()", Prettifier$.MODULE$.default()) : Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1307));
        this.sql().apply((Object)("USE " + dbName));
        String tabName = "tab1";
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.tableDirectoryExists(TableIdentifier$.MODULE$.apply(tabName), (Option<String>)Option$.MODULE$.apply((Object)expectedDBLocation)), "HiveDDLSuite.this.tableDirectoryExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(tabName), scala.Option.apply[String](expectedDBLocation))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1311));
        this.sql().apply((Object)("CREATE TABLE " + tabName + " as SELECT 1"));
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(this.tableDirectoryExists(TableIdentifier$.MODULE$.apply(tabName), (Option<String>)Option$.MODULE$.apply((Object)expectedDBLocation)), "HiveDDLSuite.this.tableDirectoryExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(tabName), scala.Option.apply[String](expectedDBLocation))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1313));
        if (!tableExists) {
            this.sql().apply((Object)("DROP TABLE " + tabName));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.tableDirectoryExists(TableIdentifier$.MODULE$.apply(tabName), (Option<String>)Option$.MODULE$.apply((Object)expectedDBLocation)), "HiveDDLSuite.this.tableDirectoryExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(tabName), scala.Option.apply[String](expectedDBLocation))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            v1 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1317));
        } else {
            v1 = BoxedUnit.UNIT;
        }
        this.sql().apply((Object)"USE default");
        String sqlDropDatabase = "DROP DATABASE " + dbName + " " + (cascade ? "CASCADE" : "RESTRICT");
        if (tableExists && !cascade) {
            this.assertAnalysisErrorCondition(sqlDropDatabase, "SCHEMA_NOT_EMPTY", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schemaName"), (Object)("`" + dbName + "`"))}))));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(fs.exists(new Path(expectedDBLocation)), "fs.exists(new org.apache.hadoop.fs.Path(expectedDBLocation))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1328));
            return;
        }
        this.sql().apply((Object)sqlDropDatabase);
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(fs.exists(new Path(expectedDBLocation)), "fs.exists(new org.apache.hadoop.fs.Path(expectedDBLocation))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1332));
    }

    private void withCreateTableLikeTempView(Option<String> location, Option<String> provider) {
        String sourceViewName = "tab1";
        String targetTabName = "tab2";
        CatalogTableType tableType = location.isDefined() ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED();
        this.withTempView((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{sourceViewName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{targetTabName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().range(10L).select((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((scala.collection.immutable.Seq)Nil$.MODULE$).as("a"), this.testImplicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((scala.collection.immutable.Seq)Nil$.MODULE$).as("b"), this.testImplicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((scala.collection.immutable.Seq)Nil$.MODULE$).as("c"), this.testImplicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((scala.collection.immutable.Seq)Nil$.MODULE$).as("d")})).createTempView(sourceViewName);
            String locationClause = location.nonEmpty() ? "LOCATION '" + location.getOrElse((Function0 & Serializable)() -> "") + "'" : "";
            String providerClause = provider.nonEmpty() ? "USING " + provider.get() : "";
            this.sql().apply((Object)("CREATE TABLE " + targetTabName + " LIKE " + sourceViewName + " " + providerClause + " " + locationClause));
            CatalogTable sourceTable = this.spark().sessionState().catalog().getTempViewOrPermanentTableMetadata(TableIdentifier$.MODULE$.apply(sourceViewName));
            CatalogTable targetTable = this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(targetTabName, (Option)new Some((Object)"default")));
            this.checkCreateTableLike(sourceTable, targetTable, tableType, provider);
        }));
    }

    private void withCreateTableLikeDSTable(Option<String> location, Option<String> provider) {
        String sourceTabName = "tab1";
        String targetTabName = "tab2";
        CatalogTableType tableType = location.isDefined() ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED();
        this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{sourceTabName, targetTabName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().range(10L).select((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((scala.collection.immutable.Seq)Nil$.MODULE$).as("a"), this.testImplicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((scala.collection.immutable.Seq)Nil$.MODULE$).as("b"), this.testImplicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((scala.collection.immutable.Seq)Nil$.MODULE$).as("c"), this.testImplicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((scala.collection.immutable.Seq)Nil$.MODULE$).as("d")})).write().format("json").saveAsTable(sourceTabName);
            String locationClause = location.nonEmpty() ? "LOCATION '" + location.getOrElse((Function0 & Serializable)() -> "") + "'" : "";
            String providerClause = provider.nonEmpty() ? "USING " + provider.get() : "";
            this.sql().apply((Object)("CREATE TABLE " + targetTabName + " LIKE " + sourceTabName + " " + providerClause + " " + locationClause));
            CatalogTable sourceTable = this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(sourceTabName, (Option)new Some((Object)"default")));
            CatalogTable targetTable = this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(targetTabName, (Option)new Some((Object)"default")));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(DDLUtils$.MODULE$.isDatasourceTable(sourceTable), "org.apache.spark.sql.execution.command.DDLUtils.isDatasourceTable(sourceTable)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1466));
            CatalogTableType $org_scalatest_assert_macro_left = sourceTable.tableType();
            CatalogTableType $org_scalatest_assert_macro_right = CatalogTableType$.MODULE$.MANAGED();
            CatalogTableType catalogTableType = $org_scalatest_assert_macro_left;
            CatalogTableType catalogTableType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1467));
            this.checkCreateTableLike(sourceTable, targetTable, tableType, provider);
        });
    }

    private void withCreateTableLikeExtDSTable(Option<String> location, Option<String> provider) {
        String sourceTabName = "tab1";
        String targetTabName = "tab2";
        CatalogTableType tableType = location.isDefined() ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED();
        this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{sourceTabName, targetTabName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1 & Serializable)dir -> {
            HiveDDLSuite.$anonfun$withCreateTableLikeExtDSTable$2(this, sourceTabName, location, provider, targetTabName, tableType, dir);
            return BoxedUnit.UNIT;
        }));
    }

    private void withCreateTableLikeManagedHiveTable(Option<String> location, Option<String> provider) {
        String sourceTabName = "tab1";
        String targetTabName = "tab2";
        CatalogTableType tableType = location.isDefined() ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED();
        SessionCatalog catalog = this.spark().sessionState().catalog();
        this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{sourceTabName, targetTabName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)("CREATE TABLE " + sourceTabName + " TBLPROPERTIES('prop1'='value1') AS SELECT 1 key, 'a'"));
            String locationClause = location.nonEmpty() ? "LOCATION '" + location.getOrElse((Function0 & Serializable)() -> "") + "'" : "";
            String providerClause = provider.nonEmpty() ? "USING " + provider.get() : "";
            this.sql().apply((Object)("CREATE TABLE " + targetTabName + " LIKE " + sourceTabName + " " + providerClause + " " + locationClause));
            CatalogTable sourceTable = catalog.getTableMetadata(TableIdentifier$.MODULE$.apply(sourceTabName, (Option)new Some((Object)"default")));
            CatalogTableType $org_scalatest_assert_macro_left = sourceTable.tableType();
            CatalogTableType $org_scalatest_assert_macro_right = CatalogTableType$.MODULE$.MANAGED();
            CatalogTableType catalogTableType = $org_scalatest_assert_macro_left;
            CatalogTableType catalogTableType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1540));
            Option $org_scalatest_assert_macro_left2 = sourceTable.properties().get((Object)"prop1");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "nonEmpty", $org_scalatest_assert_macro_left2.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1541));
            CatalogTable targetTable = catalog.getTableMetadata(TableIdentifier$.MODULE$.apply(targetTabName, (Option)new Some((Object)"default")));
            this.checkCreateTableLike(sourceTable, targetTable, tableType, provider);
        });
    }

    private void withCreateTableLikeExtHiveTable(Option<String> location, Option<String> provider) {
        SessionCatalog catalog = this.spark().sessionState().catalog();
        CatalogTableType tableType = location.isDefined() ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED();
        this.withTempDir((Function1 & Serializable)tmpDir -> {
            HiveDDLSuite.$anonfun$withCreateTableLikeExtHiveTable$1(this, location, provider, catalog, tableType, tmpDir);
            return BoxedUnit.UNIT;
        });
    }

    private void withCreateTableLikeView(Option<String> location, Option<String> provider) {
        String sourceTabName = "tab1";
        String sourceViewName = "view";
        String targetTabName = "tab2";
        CatalogTableType tableType = location.isDefined() ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED();
        this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{sourceTabName, targetTabName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withView((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{sourceViewName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().range(10L).select((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((scala.collection.immutable.Seq)Nil$.MODULE$).as("a"), this.testImplicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((scala.collection.immutable.Seq)Nil$.MODULE$).as("b"), this.testImplicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((scala.collection.immutable.Seq)Nil$.MODULE$).as("c"), this.testImplicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((scala.collection.immutable.Seq)Nil$.MODULE$).as("d")})).write().format("json").saveAsTable(sourceTabName);
            this.sql().apply((Object)("CREATE VIEW " + sourceViewName + " AS SELECT * FROM " + sourceTabName));
            String locationClause = location.nonEmpty() ? "LOCATION '" + location.getOrElse((Function0 & Serializable)() -> "") + "'" : "";
            String providerClause = provider.nonEmpty() ? "USING " + provider.get() : "";
            this.sql().apply((Object)("CREATE TABLE " + targetTabName + " LIKE " + sourceViewName + " " + providerClause + " " + locationClause));
            CatalogTable sourceView = this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(sourceViewName, (Option)new Some((Object)"default")));
            CatalogTableType $org_scalatest_assert_macro_left = sourceView.tableType();
            CatalogTableType $org_scalatest_assert_macro_right = CatalogTableType$.MODULE$.VIEW();
            CatalogTableType catalogTableType = $org_scalatest_assert_macro_left;
            CatalogTableType catalogTableType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1632));
            Option $org_scalatest_assert_macro_left2 = sourceView.viewText();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "nonEmpty", $org_scalatest_assert_macro_left2.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1633));
            scala.collection.immutable.Seq $org_scalatest_assert_macro_left3 = sourceView.viewCatalogAndNamespace();
            .colon.colon $org_scalatest_assert_macro_right2 = new .colon.colon((Object)CatalogManager$.MODULE$.SESSION_CATALOG_NAME(), (List)new .colon.colon((Object)"default", (List)Nil$.MODULE$));
            scala.collection.immutable.Seq seq = $org_scalatest_assert_macro_left3;
            .colon.colon colon2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1634));
            scala.collection.immutable.Seq $org_scalatest_assert_macro_left4 = sourceView.viewQueryColumnNames();
            .colon.colon $org_scalatest_assert_macro_right3 = new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)new .colon.colon((Object)"d", (List)Nil$.MODULE$))));
            scala.collection.immutable.Seq seq2 = $org_scalatest_assert_macro_left4;
            .colon.colon colon3 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(seq2 != null ? !seq2.equals(colon3) : colon3 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1636));
            CatalogTable targetTable = this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(targetTabName, (Option)new Some((Object)"default")));
            this.checkCreateTableLike(sourceView, targetTable, tableType, provider);
        }));
    }

    /*
     * Unable to fully structure code
     */
    private void checkCreateTableLike(CatalogTable sourceTable, CatalogTable targetTable, CatalogTableType tableType, Option<String> provider) {
        block10: {
            block11: {
                block9: {
                    $org_scalatest_assert_macro_left = targetTable.tableType();
                    $org_scalatest_assert_macro_right = tableType;
                    v0 = $org_scalatest_assert_macro_left;
                    var9_7 = $org_scalatest_assert_macro_right;
                    $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(v0 != null ? v0.equals(var9_7) == false : var9_7 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("the created table must be a/an " + tableType.name() + " table"), Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1651));
                    $org_scalatest_assert_macro_left = targetTable.viewText();
                    $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"the view text in the created table must be empty", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1653));
                    $org_scalatest_assert_macro_left = targetTable.viewCatalogAndNamespace();
                    $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"the view catalog and namespace in the created table must be empty", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1655));
                    $org_scalatest_assert_macro_left = targetTable.viewQueryColumnNames();
                    $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"the view query output columns in the created table must be empty", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1657));
                    $org_scalatest_assert_macro_left = targetTable.comment();
                    $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"the comment in the created table must be empty", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1659));
                    $org_scalatest_assert_macro_left = targetTable.unsupportedFeatures();
                    $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"the unsupportedFeatures in the create table must be empty", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1661));
                    metastoreGeneratedProperties = (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"CreateTime", "transient_lastDdlTime", "grantTime", "lastUpdateTime", "last_modified_by", "last_modified_time", "Owner:", "totalNumberFiles", "maxFileSize", "minFileSize"}));
                    $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(targetTable.properties().forall((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$checkCreateTableLike$1$adapted(scala.collection.immutable.Seq scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((scala.collection.immutable.Seq)metastoreGeneratedProperties)), "targetTable.properties.forall(((x0$1: (String, String)) => x0$1 match {\n  case (_1: String, _2: String): (String, String)((k @ _), _) => metastoreGeneratedProperties.contains[String](k)\n}))", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"the table properties of source tables should not be copied in the created table", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1676));
                    var22_21 = provider;
                    if (!(var22_21 instanceof Some)) break block9;
                    $org_scalatest_assert_macro_left = targetTable.provider();
                    $org_scalatest_assert_macro_right = provider;
                    v1 = $org_scalatest_assert_macro_left;
                    var26_24 = $org_scalatest_assert_macro_right;
                    $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", $org_scalatest_assert_macro_right, !(v1 != null ? v1.equals(var26_24) == false : var26_24 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1682));
                    if (DDLUtils$.MODULE$.isHiveTable(provider)) {
                        $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(DDLUtils$.MODULE$.isHiveTable(targetTable), "org.apache.spark.sql.execution.command.DDLUtils.isHiveTable(targetTable)", Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"the target table should be a hive table if provider is hive", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1684));
                    }
                    break block10;
                }
                if (!None$.MODULE$.equals(var22_21)) break block11;
                v2 = sourceTable.tableType();
                var28_27 = CatalogTableType$.MODULE$.VIEW();
                if (!(v2 != null ? v2.equals(var28_27) == false : var28_27 != null)) {
                    $org_scalatest_assert_macro_left = targetTable.provider();
                    $org_scalatest_assert_macro_right = Option$.MODULE$.apply((Object)this.spark().sessionState().conf().defaultDataSourceName());
                    v3 = $org_scalatest_assert_macro_left;
                    var32_30 = $org_scalatest_assert_macro_right;
                    $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(v3 != null ? v3.equals(var32_30) == false : var32_30 != null), Prettifier$.MODULE$.default());
                    v4 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1691));
                } else {
                    $org_scalatest_assert_macro_left = targetTable.provider();
                    $org_scalatest_assert_macro_right = sourceTable.provider();
                    v5 = $org_scalatest_assert_macro_left;
                    var36_34 = $org_scalatest_assert_macro_right;
                    $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(v5 != null ? v5.equals(var36_34) == false : var36_34 != null), Prettifier$.MODULE$.default());
                    v4 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1693));
                }
                if (DDLUtils$.MODULE$.isDatasourceTable(sourceTable)) ** GOTO lbl-1000
                v6 = sourceTable.tableType();
                var37_36 = CatalogTableType$.MODULE$.VIEW();
                if (!(v6 != null ? v6.equals(var37_36) == false : var37_36 != null)) lbl-1000:
                // 2 sources

                {
                    $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(DDLUtils$.MODULE$.isDatasourceTable(targetTable), "org.apache.spark.sql.execution.command.DDLUtils.isDatasourceTable(targetTable)", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"the target table should be a data source table", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1697));
                } else {
                    $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(DDLUtils$.MODULE$.isDatasourceTable(targetTable), "org.apache.spark.sql.execution.command.DDLUtils.isDatasourceTable(targetTable)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"the target table should be a Hive serde table", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1700));
                }
                break block10;
            }
            throw new MatchError(var22_21);
        }
        $org_scalatest_assert_macro_left = targetTable.storage().locationUri();
        $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"target table path should not be empty", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1705));
        v7 = tableType;
        var42_41 = CatalogTableType$.MODULE$.EXTERNAL();
        if (v7 == null ? var42_41 != null : v7.equals(var42_41) == false) {
            $org_scalatest_assert_macro_left = sourceTable.storage().locationUri();
            $org_scalatest_assert_macro_right = targetTable.storage().locationUri();
            v8 = $org_scalatest_assert_macro_left;
            var46_44 = $org_scalatest_assert_macro_right;
            $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, v8 == null ? var46_44 != null : v8.equals(var46_44) == false, Prettifier$.MODULE$.default());
            v9 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"source table/view path should be different from target table path", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1710));
        } else {
            v9 = BoxedUnit.UNIT;
        }
        if (DDLUtils$.MODULE$.isHiveTable(targetTable)) {
            $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(targetTable.tracksPartitionsInCatalog(), "targetTable.tracksPartitionsInCatalog", Prettifier$.MODULE$.default());
            v10 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1715));
        } else {
            $org_scalatest_assert_macro_left = targetTable.tracksPartitionsInCatalog();
            $org_scalatest_assert_macro_right = sourceTable.tracksPartitionsInCatalog();
            $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            v10 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1717));
        }
        $org_scalatest_assert_macro_left = this.spark().table(sourceTable.identifier()).count();
        $org_scalatest_assert_macro_right = 0;
        $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "!=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left != (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"the source table should be nonempty", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1721));
        $org_scalatest_assert_macro_left = this.spark().table(targetTable.identifier()).count();
        $org_scalatest_assert_macro_right = 0;
        $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"the target table should be empty", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1722));
        this.checkAnswer((Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$checkCreateTableLike$2(org.apache.spark.sql.hive.execution.HiveDDLSuite org.apache.spark.sql.catalyst.catalog.CatalogTable ), ()Lorg/apache/spark/sql/classic/Dataset;)((HiveDDLSuite)this, (CatalogTable)sourceTable), (Dataset)this.sql().apply((Object)("DESC " + targetTable.identifier())));
        this.withSQLConf((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.exec.dynamic.partition.mode"), (Object)"nonstrict")}), (Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$checkCreateTableLike$3(org.apache.spark.sql.hive.execution.HiveDDLSuite org.apache.spark.sql.catalyst.catalog.CatalogTable org.apache.spark.sql.catalyst.catalog.CatalogTable ), ()Lorg/apache/spark/sql/classic/Dataset;)((HiveDDLSuite)this, (CatalogTable)targetTable, (CatalogTable)sourceTable));
        this.checkAnswer((Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$checkCreateTableLike$4(org.apache.spark.sql.hive.execution.HiveDDLSuite org.apache.spark.sql.catalyst.catalog.CatalogTable ), ()Lorg/apache/spark/sql/classic/Dataset;)((HiveDDLSuite)this, (CatalogTable)sourceTable), (Dataset)this.sql().apply((Object)("SELECT * FROM " + targetTable.identifier())));
    }

    private void checkAvroSchemaEvolutionAddColumn(String originalSerdeProperties, String evolvedSerdeProperties) {
        this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |CREATE TABLE t PARTITIONED BY (ds string)\n          |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe'\n          |WITH SERDEPROPERTIES (" + originalSerdeProperties + ")\n          |STORED AS\n          |INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat'\n          |OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat'\n        ")));
            this.sql().apply((Object)"INSERT INTO t partition (ds='1981-01-07') VALUES ('col2_value')");
            this.sql().apply((Object)("ALTER TABLE t SET SERDEPROPERTIES (" + evolvedSerdeProperties + ")"));
            this.sql().apply((Object)"INSERT INTO t partition (ds='1983-04-27') VALUES ('col1_value', 'col2_value')");
            Row row = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"col1_default", "col2_value", "1981-01-07"}));
            Row row2 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"col1_value", "col2_value", "1983-04-27"}));
            this.checkAnswer((Function0 & Serializable)() -> this.spark().table("t"), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
        });
    }

    private void checkAvroSchemaEvolutionRemoveColumn(String originalSerdeProperties, String evolvedSerdeProperties) {
        this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |CREATE TABLE t PARTITIONED BY (ds string)\n          |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe'\n          |WITH SERDEPROPERTIES (" + originalSerdeProperties + ")\n          |STORED AS\n          |INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat'\n          |OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat'\n        ")));
            this.sql().apply((Object)"INSERT INTO t partition (ds='1983-04-27') VALUES ('col1_value', 'col2_value')");
            this.sql().apply((Object)("ALTER TABLE t SET SERDEPROPERTIES (" + evolvedSerdeProperties + ")"));
            this.sql().apply((Object)"INSERT INTO t partition (ds='1981-01-07') VALUES ('col2_value')");
            Row row = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"col2_value", "1981-01-07"}));
            Row row2 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"col2_value", "1983-04-27"}));
            this.checkAnswer((Function0 & Serializable)() -> this.spark().table("t"), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
        });
    }

    private Assertion assertCompression(Option<File> maybeFile, String format, String compression) {
        String string;
        block4: {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(maybeFile.isDefined(), "maybeFile.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2687));
            String string2 = format;
            switch (string2 == null ? 0 : string2.hashCode()) {
                case -793011724: {
                    if (!"parquet".equals(string2)) break;
                    ParquetMetadata footer = ParquetFooterReader.readFooter((Configuration)this.sparkContext().hadoopConfiguration(), (Path)new Path(((File)maybeFile.get()).getPath()), (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
                    string = ((ColumnChunkMetaData)((BlockMetaData)footer.getBlocks().get(0)).getColumns().get(0)).getCodec().toString();
                    break block4;
                }
                case 110304: {
                    if (!"orc".equals(string2)) break;
                    string = ((org.apache.hadoop.hive.ql.io.orc.Reader)OrcFileOperator$.MODULE$.getFileReader(((Object)((File)maybeFile.get()).toPath()).toString(), OrcFileOperator$.MODULE$.getFileReader$default$2(), OrcFileOperator$.MODULE$.getFileReader$default$3()).get()).getCompression().name();
                    break block4;
                }
            }
            throw new MatchError((Object)string2);
        }
        String actualCompression = string;
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(compression);
        String $org_scalatest_assert_macro_right = actualCompression;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2699));
    }

    private Reader getReader(String path) {
        scala.collection.immutable.Seq files;
        Configuration conf = this.spark().sessionState().newHadoopConf();
        scala.collection.immutable.Seq $org_scalatest_assert_macro_left = files = OrcUtils$.MODULE$.listOrcFiles(path, conf);
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2734));
        Path file = (Path)files.head();
        FileSystem fs = file.getFileSystem(conf);
        OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions((Configuration)conf).filesystem(fs);
        return OrcFile.createReader((Path)file, (OrcFile.ReaderOptions)readerOptions);
    }

    public static final /* synthetic */ boolean $anonfun$normalizeCatalogTable$1(Set nondeterministicProps$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return !nondeterministicProps$1.contains((Object)k);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$50(HiveDDLSuite $this, File tmpDir) {
        String tabName = "tab1";
        $this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tabName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Object $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])tmpDir.listFiles());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419));
            $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |create table " + tabName + "\n             |stored as parquet\n             |location '" + tmpDir.toURI() + "'\n             |as select 1, '3'\n          ")));
            CatalogTable hiveTable = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tabName, (Option)new Some((Object)"default")));
            CatalogTableType $org_scalatest_assert_macro_left2 = hiveTable.tableType();
            CatalogTableType $org_scalatest_assert_macro_right = CatalogTableType$.MODULE$.EXTERNAL();
            CatalogTableType catalogTableType = $org_scalatest_assert_macro_left2;
            CatalogTableType catalogTableType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 430));
            Object $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])tmpDir.listFiles());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left3), "nonEmpty", ArrayOps$.MODULE$.nonEmpty$extension($org_scalatest_assert_macro_left3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 432));
            $this.sql().apply((Object)("DROP TABLE " + tabName));
            Object $org_scalatest_assert_macro_left4 = Predef$.MODULE$.refArrayOps((Object[])tmpDir.listFiles());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left4), "nonEmpty", ArrayOps$.MODULE$.nonEmpty$extension($org_scalatest_assert_macro_left4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 434));
        });
    }

    public static final /* synthetic */ void $anonfun$new$53(HiveDDLSuite $this, File tmpDir) {
        String tabName = "tab1";
        $this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tabName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Object $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])tmpDir.listFiles());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 443));
            $this.withSQLConf((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(HiveDDLSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator20$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator20$1(HiveDDLSuite $outer) {
                    }
                }
                $this.testImplicits().localSeqToDatasetHolder((scala.collection.immutable.Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"a"), (List)Nil$.MODULE$), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator20$1(null)))).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"})).write().mode(SaveMode.Overwrite).format("parquet").option("path", tmpDir.toString()).saveAsTable(tabName);
            });
            CatalogTable hiveTable = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tabName, (Option)new Some((Object)"default")));
            CatalogTableType $org_scalatest_assert_macro_left2 = hiveTable.tableType();
            CatalogTableType $org_scalatest_assert_macro_right = CatalogTableType$.MODULE$.EXTERNAL();
            CatalogTableType catalogTableType = $org_scalatest_assert_macro_left2;
            CatalogTableType catalogTableType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 457));
            Object $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])tmpDir.listFiles());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left3), "nonEmpty", ArrayOps$.MODULE$.nonEmpty$extension($org_scalatest_assert_macro_left3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 459));
            $this.sql().apply((Object)("DROP TABLE " + tabName));
            Object $org_scalatest_assert_macro_left4 = Predef$.MODULE$.refArrayOps((Object[])tmpDir.listFiles());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left4), "nonEmpty", ArrayOps$.MODULE$.nonEmpty$extension($org_scalatest_assert_macro_left4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 462));
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$72(File dir) {
        return dir.listFiles() == null || ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles()));
    }

    public static final /* synthetic */ boolean $anonfun$new$74(File dir) {
        return dir.listFiles() == null || ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles()));
    }

    public static final /* synthetic */ boolean $anonfun$new$78(File dir) {
        return dir.listFiles() == null || ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles()));
    }

    public static final /* synthetic */ void $anonfun$new$71(HiveDDLSuite $this, String tab$1, File tmpDir) {
        File basePath = new File(tmpDir.getCanonicalPath());
        File part1Path = new File(new File(basePath, "part10"), "part11");
        File part2Path = new File(new File(basePath, "part20"), "part21");
        File file = part1Path;
        File file2 = part2Path;
        List dirSet = Nil$.MODULE$.$colon$colon((Object)file2).$colon$colon((Object)file);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(dirSet.forall((Function1 & Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)HiveDDLSuite.$anonfun$new$72(dir))), "dirSet.forall(((dir: java.io.File) => dir.listFiles().==(null).||(scala.Predef.refArrayOps[java.io.File](dir.listFiles()).isEmpty)))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 562));
        $this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tab$1}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Bool bool;
            $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |CREATE TABLE " + tab$1 + " (key INT, value STRING)\n             |PARTITIONED BY (ds STRING, hr STRING)\n           ")));
            $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |ALTER TABLE " + tab$1 + " ADD\n             |PARTITION (ds='2008-04-08', hr=11) LOCATION '" + part1Path.toURI() + "'\n             |PARTITION (ds='2008-04-08', hr=12) LOCATION '" + part2Path.toURI() + "'\n           ")));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(dirSet.forall((Function1 & Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)HiveDDLSuite.$anonfun$new$74(dir))), "dirSet.forall(((dir: java.io.File) => dir.listFiles().==(null).||(scala.Predef.refArrayOps[java.io.File](dir.listFiles()).isEmpty)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 576));
            $this.sql().apply((Object)("INSERT OVERWRITE TABLE " + tab$1 + " partition (ds='2008-04-08', hr=11) SELECT 1, 'a'"));
            $this.sql().apply((Object)("INSERT OVERWRITE TABLE " + tab$1 + " partition (ds='2008-04-08', hr=12) SELECT 2, 'b'"));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(dirSet.forall((Function1 & Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles())))), "dirSet.forall(((dir: java.io.File) => scala.Predef.refArrayOps[java.io.File](dir.listFiles()).nonEmpty))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 581));
            Row row = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", "2008-04-08", "11"}));
            Row row2 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b", "2008-04-08", "12"}));
            $this.checkAnswer((Function0 & Serializable)() -> $this.spark().table(tab$1), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
            $this.sql().apply((Object)("ALTER TABLE " + tab$1 + " DROP PARTITION (ds='2008-04-08', hr=11)"));
            File[] $org_scalatest_assert_macro_left = part1Path.listFiles();
            Object $org_scalatest_assert_macro_right = null;
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", null, $org_scalatest_assert_macro_left == null, Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left2.value()) {
                bool = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
            } else {
                Object $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])part1Path.listFiles());
                bool = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left3), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left3), Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right2 = bool;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "||", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$bar$bar((Function0 & Serializable)() -> $org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 589));
            Object $org_scalatest_assert_macro_left4 = Predef$.MODULE$.refArrayOps((Object[])part2Path.listFiles());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left4), "nonEmpty", ArrayOps$.MODULE$.nonEmpty$extension($org_scalatest_assert_macro_left4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 590));
            $this.sql().apply((Object)("DROP TABLE " + tab$1));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(dirSet.forall((Function1 & Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)HiveDDLSuite.$anonfun$new$78(dir))), "dirSet.forall(((dir: java.io.File) => dir.listFiles().==(null).||(scala.Predef.refArrayOps[java.io.File](dir.listFiles()).isEmpty)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 594));
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$84(File dir) {
        return dir.listFiles() == null || ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles()));
    }

    public static final /* synthetic */ void $anonfun$new$85(HiveDDLSuite $this, String externalTab$1, String ds) {
        new .colon.colon((Object)"11", (List)new .colon.colon((Object)"12", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)hr -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n               |INSERT OVERWRITE TABLE " + externalTab$1 + "\n               |partition (ds='" + ds + "',hr='" + hr + "')\n               |SELECT 1, 'a'\n             "))));
    }

    public static final /* synthetic */ void $anonfun$new$82(HiveDDLSuite $this, SessionCatalog catalog$4, File tmpDir) {
        String basePath = tmpDir.getCanonicalPath();
        File partitionPath_1stCol_part1 = new File(basePath + "/ds=2008-04-08");
        File partitionPath_1stCol_part2 = new File(basePath + "/ds=2008-04-09");
        File partitionPath_part1 = new File(basePath + "/ds=2008-04-08/hr=11");
        File partitionPath_part2 = new File(basePath + "/ds=2008-04-09/hr=11");
        File partitionPath_part3 = new File(basePath + "/ds=2008-04-08/hr=12");
        File partitionPath_part4 = new File(basePath + "/ds=2008-04-09/hr=12");
        File file = tmpDir;
        File file2 = partitionPath_1stCol_part1;
        File file3 = partitionPath_1stCol_part2;
        File file4 = partitionPath_part1;
        File file5 = partitionPath_part2;
        File file6 = partitionPath_part3;
        File file7 = partitionPath_part4;
        List dirSet = Nil$.MODULE$.$colon$colon((Object)file7).$colon$colon((Object)file6).$colon$colon((Object)file5).$colon$colon((Object)file4).$colon$colon((Object)file3).$colon$colon((Object)file2).$colon$colon((Object)file);
        String externalTab = "extTable_with_partitions";
        $this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{externalTab}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Object $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])tmpDir.listFiles());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 630));
            $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |CREATE EXTERNAL TABLE " + externalTab + " (key INT, value STRING)\n             |PARTITIONED BY (ds STRING, hr STRING)\n             |LOCATION '" + tmpDir.toURI() + "'\n          ")));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(dirSet.forall((Function1 & Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)HiveDDLSuite.$anonfun$new$84(dir))), "dirSet.forall(((dir: java.io.File) => dir.listFiles().==(null).||(scala.Predef.refArrayOps[java.io.File](dir.listFiles()).isEmpty)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 639));
            new .colon.colon((Object)"2008-04-08", (List)new .colon.colon((Object)"2008-04-09", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)ds -> {
                HiveDDLSuite.$anonfun$new$85($this, externalTab, ds);
                return BoxedUnit.UNIT;
            });
            CatalogTable hiveTable = catalog$4.getTableMetadata(TableIdentifier$.MODULE$.apply(externalTab, (Option)new Some((Object)"default")));
            CatalogTableType $org_scalatest_assert_macro_left2 = hiveTable.tableType();
            CatalogTableType $org_scalatest_assert_macro_right = CatalogTableType$.MODULE$.EXTERNAL();
            CatalogTableType catalogTableType = $org_scalatest_assert_macro_left2;
            CatalogTableType catalogTableType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 651));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(dirSet.forall((Function1 & Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles())))), "dirSet.forall(((dir: java.io.File) => scala.Predef.refArrayOps[java.io.File](dir.listFiles()).nonEmpty))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 653));
            AnalysisException x$25 = (AnalysisException)$this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)("ALTER TABLE " + externalTab + " DROP PARTITION (ds='2008-04-09', unknownCol='12')")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 656));
            String x$26 = "PARTITIONS_NOT_FOUND";
            Map x$27 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitionList"), (Object)"`unknownCol`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)("`" + CatalogManager$.MODULE$.SESSION_CATALOG_NAME() + "`.`default`.`exttable_with_partitions`"))}));
            Option x$28 = $this.checkError$default$3();
            boolean x$29 = $this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$30 = $this.checkError$default$6();
            $this.checkError((SparkThrowable)x$25, "PARTITIONS_NOT_FOUND", x$28, x$27, x$29, x$30);
            $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |ALTER TABLE " + externalTab + " DROP PARTITION (ds='2008-04-08'),\n             |PARTITION (hr='12')\n          ")));
            Set $org_scalatest_assert_macro_left3 = ((IterableOnceOps)catalog$4.listPartitions(TableIdentifier$.MODULE$.apply(externalTab), catalog$4.listPartitions$default$2()).map((Function1 & Serializable)x$2 -> x$2.spec())).toSet();
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2008-04-09"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)"11")}))}));
            Set set = $org_scalatest_assert_macro_left3;
            Set set2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 670));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(dirSet.forall((Function1 & Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles())))), "dirSet.forall(((dir: java.io.File) => scala.Predef.refArrayOps[java.io.File](dir.listFiles()).nonEmpty))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 673));
            $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |ALTER TABLE " + externalTab + " ADD PARTITION (ds='2008-04-08', hr='12')\n             |PARTITION (ds='2008-04-08', hr=11)\n          ")));
            Set $org_scalatest_assert_macro_left4 = ((IterableOnceOps)catalog$4.listPartitions(TableIdentifier$.MODULE$.apply(externalTab), catalog$4.listPartitions$default$2()).map((Function1 & Serializable)x$3 -> x$3.spec())).toSet();
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2008-04-08"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)"11")})), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2008-04-08"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)"12")})), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2008-04-09"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)"11")}))}));
            Set set3 = $org_scalatest_assert_macro_left4;
            Set set4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 680));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(dirSet.forall((Function1 & Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles())))), "dirSet.forall(((dir: java.io.File) => scala.Predef.refArrayOps[java.io.File](dir.listFiles()).nonEmpty))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 685));
            $this.sql().apply((Object)("DROP TABLE " + externalTab));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(dirSet.forall((Function1 & Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles())))), "dirSet.forall(((dir: java.io.File) => scala.Predef.refArrayOps[java.io.File](dir.listFiles()).nonEmpty))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 689));
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$103(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            return new .colon.colon((Object)"transient_lastDdlTime", (List)new .colon.colon((Object)CatalogTable$.MODULE$.VIEW_DEFAULT_DATABASE(), (List)Nil$.MODULE$)).contains((Object)key) || key.startsWith(CatalogTable$.MODULE$.VIEW_QUERY_OUTPUT_PREFIX());
        }
        throw new MatchError((Object)tuple2);
    }

    private final boolean checkProperties$1(Map expected, String viewName$3) {
        Map properties = this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(viewName$3)).properties();
        Object object = properties.filterNot((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)HiveDDLSuite.$anonfun$new$103(x0$1)));
        Map map = expected;
        return !(object != null ? !object.equals(map) : map != null);
    }

    public static final /* synthetic */ void $anonfun$new$131(HiveDDLSuite $this, File path) {
        $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                |CREATE TABLE tbl2(ID long) USING hive\n                |OPTIONS(fileFormat 'parquet')\n                |LOCATION '" + path.toURI() + "'\n              ")));
        $this.spark().sql("INSERT OVERWRITE TABLE tbl2 SELECT ID FROM view1");
        StructType expectedSchema = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("ID", (DataType)LongType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        StructType $org_scalatest_assert_macro_left = $this.spark().read().parquet(path.toString()).schema();
        StructType $org_scalatest_assert_macro_right = expectedSchema;
        StructType structType = $org_scalatest_assert_macro_left;
        StructType structType2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1004));
        $this.checkAnswer((Function0 & Serializable)() -> $this.spark().table("tbl2"), (scala.collection.immutable.Seq)new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$new$137(HiveDDLSuite $this, File path) {
        $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                |CREATE TABLE tbl2 USING hive\n                |OPTIONS(fileFormat 'parquet')\n                |LOCATION '" + path.toURI() + "'\n                |AS SELECT ID FROM view1\n              ")));
        StructType expectedSchema = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("ID", (DataType)LongType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        StructType $org_scalatest_assert_macro_left = $this.spark().read().parquet(path.toString()).schema();
        StructType $org_scalatest_assert_macro_right = expectedSchema;
        StructType structType = $org_scalatest_assert_macro_left;
        StructType structType2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1028));
        $this.checkAnswer((Function0 & Serializable)() -> $this.spark().table("tbl2"), (scala.collection.immutable.Seq)new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$new$143(HiveDDLSuite $this, File path) {
        $this.spark().sql("INSERT OVERWRITE LOCAL DIRECTORY '" + path.getCanonicalPath() + "' STORED AS PARQUET SELECT ID FROM view1");
        StructType expectedSchema = StructType$.MODULE$.apply((scala.collection.immutable.Seq)new .colon.colon((Object)new StructField("ID", (DataType)LongType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        StructType $org_scalatest_assert_macro_left = $this.spark().read().parquet(path.toString()).schema();
        StructType $org_scalatest_assert_macro_right = expectedSchema;
        StructType structType = $org_scalatest_assert_macro_left;
        StructType structType2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1047));
        $this.checkAnswer((Function0 & Serializable)() -> $this.spark().read().parquet(path.toString()), (scala.collection.immutable.Seq)new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$new$147(Map expectedSerdeProps$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return expectedSerdeProps$1.contains((Object)k);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$new$148(Map expectedSerdeProps$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return expectedSerdeProps$1.contains((Object)k);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$190(HiveDDLSuite $this, Option provider) {
        $this.withCreateTableLikeTempView((Option<String>)None$.MODULE$, (Option<String>)provider);
        $this.withTempDir((Function1 & Serializable)tmpDir -> {
            $this.withCreateTableLikeTempView((Option<String>)new Some((Object)tmpDir.toURI().toString()), (Option<String>)provider);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$193(HiveDDLSuite $this, Option provider) {
        $this.withCreateTableLikeDSTable((Option<String>)None$.MODULE$, (Option<String>)provider);
        $this.withTempDir((Function1 & Serializable)tmpDir -> {
            $this.withCreateTableLikeDSTable((Option<String>)new Some((Object)tmpDir.toURI().toString()), (Option<String>)provider);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$196(HiveDDLSuite $this, Option provider) {
        $this.withCreateTableLikeExtDSTable((Option<String>)None$.MODULE$, (Option<String>)provider);
        $this.withTempDir((Function1 & Serializable)tmpDir -> {
            $this.withCreateTableLikeExtDSTable((Option<String>)new Some((Object)tmpDir.toURI().toString()), (Option<String>)provider);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$withCreateTableLikeExtDSTable$2(HiveDDLSuite $this, String sourceTabName$2, Option location$3, Option provider$6, String targetTabName$3, CatalogTableType tableType$3, File dir) {
        String path = dir.getCanonicalPath();
        $this.spark().range(10L).select((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{$this.testImplicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((scala.collection.immutable.Seq)Nil$.MODULE$).as("a"), $this.testImplicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((scala.collection.immutable.Seq)Nil$.MODULE$).as("b"), $this.testImplicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((scala.collection.immutable.Seq)Nil$.MODULE$).as("c"), $this.testImplicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((scala.collection.immutable.Seq)Nil$.MODULE$).as("d")})).write().format("parquet").save(path);
        $this.sql().apply((Object)("CREATE TABLE " + sourceTabName$2 + " USING parquet OPTIONS (PATH '" + dir.toURI() + "')"));
        String locationClause = location$3.nonEmpty() ? "LOCATION '" + location$3.getOrElse((Function0 & Serializable)() -> "") + "'" : "";
        String providerClause = provider$6.nonEmpty() ? "USING " + provider$6.get() : "";
        $this.sql().apply((Object)("CREATE TABLE " + targetTabName$3 + " LIKE " + sourceTabName$2 + " " + providerClause + " " + locationClause));
        CatalogTable sourceTable = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(sourceTabName$2, (Option)new Some((Object)"default")));
        CatalogTable targetTable = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(targetTabName$3, (Option)new Some((Object)"default")));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(DDLUtils$.MODULE$.isDatasourceTable(sourceTable), "org.apache.spark.sql.execution.command.DDLUtils.isDatasourceTable(sourceTable)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1506));
        CatalogTableType $org_scalatest_assert_macro_left = sourceTable.tableType();
        CatalogTableType $org_scalatest_assert_macro_right = CatalogTableType$.MODULE$.EXTERNAL();
        CatalogTableType catalogTableType = $org_scalatest_assert_macro_left;
        CatalogTableType catalogTableType2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1507));
        $this.checkCreateTableLike(sourceTable, targetTable, tableType$3, (Option<String>)provider$6);
    }

    public static final /* synthetic */ void $anonfun$new$199(HiveDDLSuite $this, Option provider) {
        $this.withCreateTableLikeManagedHiveTable((Option<String>)None$.MODULE$, (Option<String>)provider);
        $this.withTempDir((Function1 & Serializable)tmpDir -> {
            $this.withCreateTableLikeManagedHiveTable((Option<String>)new Some((Object)tmpDir.toURI().toString()), (Option<String>)provider);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$202(HiveDDLSuite $this, Option provider) {
        $this.withCreateTableLikeExtHiveTable((Option<String>)None$.MODULE$, (Option<String>)provider);
        $this.withTempDir((Function1 & Serializable)tmpDir -> {
            $this.withCreateTableLikeExtHiveTable((Option<String>)new Some((Object)tmpDir.toURI().toString()), (Option<String>)provider);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$withCreateTableLikeExtHiveTable$3(HiveDDLSuite $this, String sourceTabName$4, String ds) {
        new .colon.colon((Object)"11", (List)new .colon.colon((Object)"12", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)hr -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n               |INSERT OVERWRITE TABLE " + sourceTabName$4 + "\n               |partition (ds='" + ds + "',hr='" + hr + "')\n               |SELECT 1, 'a'\n             "))));
    }

    public static final /* synthetic */ void $anonfun$withCreateTableLikeExtHiveTable$1(HiveDDLSuite $this, Option location$5, Option provider$10, SessionCatalog catalog$7, CatalogTableType tableType$5, File tmpDir) {
        URI basePath = tmpDir.toURI();
        String sourceTabName = "tab1";
        String targetTabName = "tab2";
        $this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{sourceTabName, targetTabName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Object $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])tmpDir.listFiles());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1569));
            $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |CREATE EXTERNAL TABLE " + sourceTabName + " (key INT comment 'test', value STRING)\n             |COMMENT 'Apache Spark'\n             |PARTITIONED BY (ds STRING, hr STRING)\n             |LOCATION '" + basePath + "'\n           ")));
            new .colon.colon((Object)"2008-04-08", (List)new .colon.colon((Object)"2008-04-09", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)ds -> {
                HiveDDLSuite.$anonfun$withCreateTableLikeExtHiveTable$3($this, sourceTabName, ds);
                return BoxedUnit.UNIT;
            });
            String locationClause = location$5.nonEmpty() ? "LOCATION '" + location$5.getOrElse((Function0 & Serializable)() -> "") + "'" : "";
            String providerClause = provider$10.nonEmpty() ? "USING " + provider$10.get() : "";
            $this.sql().apply((Object)("CREATE TABLE " + targetTabName + " LIKE " + sourceTabName + " " + providerClause + " " + locationClause));
            CatalogTable sourceTable = catalog$7.getTableMetadata(TableIdentifier$.MODULE$.apply(sourceTabName, (Option)new Some((Object)"default")));
            CatalogTableType $org_scalatest_assert_macro_left2 = sourceTable.tableType();
            CatalogTableType $org_scalatest_assert_macro_right = CatalogTableType$.MODULE$.EXTERNAL();
            CatalogTableType catalogTableType = $org_scalatest_assert_macro_left2;
            CatalogTableType catalogTableType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1592));
            Option $org_scalatest_assert_macro_left3 = sourceTable.comment();
            Option $org_scalatest_assert_macro_right2 = Option$.MODULE$.apply((Object)"Apache Spark");
            Option option = $org_scalatest_assert_macro_left3;
            Option option2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(option != null ? !option.equals(option2) : option2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1593));
            CatalogTable targetTable = catalog$7.getTableMetadata(TableIdentifier$.MODULE$.apply(targetTabName, (Option)new Some((Object)"default")));
            $this.checkCreateTableLike(sourceTable, targetTable, tableType$5, (Option<String>)provider$10);
        });
    }

    public static final /* synthetic */ void $anonfun$new$205(HiveDDLSuite $this, Option provider) {
        $this.withCreateTableLikeView((Option<String>)None$.MODULE$, (Option<String>)provider);
        $this.withTempDir((Function1 & Serializable)tmpDir -> {
            $this.withCreateTableLikeView((Option<String>)new Some((Object)tmpDir.toURI().toString()), (Option<String>)provider);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$checkCreateTableLike$1(scala.collection.immutable.Seq metastoreGeneratedProperties$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return metastoreGeneratedProperties$1.contains((Object)k);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ org.apache.spark.sql.classic.Dataset $anonfun$checkCreateTableLike$2(HiveDDLSuite $this, CatalogTable sourceTable$1) {
        return (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)("DESC " + sourceTable$1.identifier()));
    }

    public static final /* synthetic */ org.apache.spark.sql.classic.Dataset $anonfun$checkCreateTableLike$3(HiveDDLSuite $this, CatalogTable targetTable$1, CatalogTable sourceTable$1) {
        return (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)("INSERT INTO TABLE " + targetTable$1.identifier() + " SELECT * FROM " + sourceTable$1.identifier()));
    }

    public static final /* synthetic */ org.apache.spark.sql.classic.Dataset $anonfun$checkCreateTableLike$4(HiveDDLSuite $this, CatalogTable sourceTable$1) {
        return (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)("SELECT * FROM " + sourceTable$1.identifier()));
    }

    public static final /* synthetic */ void $anonfun$new$220(HiveDDLSuite $this, String fileFormat$1, File dir) {
        scala.collection.immutable.Seq desc;
        String path = dir.toURI().toString();
        $this.spark().range(1L).write().format(fileFormat$1).save(path);
        $this.sql().apply((Object)("CREATE TABLE t1 USING " + fileFormat$1 + " OPTIONS (PATH '" + path + "')"));
        scala.collection.immutable.Seq $org_scalatest_assert_macro_left = desc = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])((org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)"DESC FORMATTED t1")).collect()));
        Row $org_scalatest_assert_macro_right = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"id", "bigint", null}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1852));
    }

    public static final /* synthetic */ void $anonfun$new$223(HiveDDLSuite $this, String forbiddenPrefix) {
        AnalysisException x$103 = (AnalysisException)$this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)("ALTER TABLE tbl SET TBLPROPERTIES ('" + forbiddenPrefix + "foo' = 'loser')")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1867));
        String x$104 = "_LEGACY_ERROR_TEMP_3086";
        Map x$105 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"spark_catalog.default.tbl"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalidKeys"), (Object)("[" + forbiddenPrefix + "foo]"))}));
        Option x$106 = $this.checkError$default$3();
        boolean x$107 = $this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$108 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$103, "_LEGACY_ERROR_TEMP_3086", x$106, x$105, x$107, x$108);
        AnalysisException x$109 = (AnalysisException)$this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)("CREATE TABLE tbl2 (a INT) TBLPROPERTIES ('" + forbiddenPrefix + "foo'='anything')")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1876));
        String x$110 = "_LEGACY_ERROR_TEMP_3086";
        Map x$111 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"spark_catalog.default.tbl2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalidKeys"), (Object)("[" + forbiddenPrefix + "foo]"))}));
        Option x$112 = $this.checkError$default$3();
        boolean x$113 = $this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$114 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$109, "_LEGACY_ERROR_TEMP_3086", x$112, x$111, x$113, x$114);
    }

    public static final /* synthetic */ boolean $anonfun$new$230(File x$5) {
        return x$5.getName().startsWith("part");
    }

    public static final /* synthetic */ void $anonfun$new$228(HiveDDLSuite $this, File path) {
        $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n            |CREATE TABLE t(id int) USING hive\n            |OPTIONS(fileFormat 'orc', compression 'Zlib')\n            |LOCATION '" + path.toURI() + "'\n          ")));
        CatalogTable table = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply("t"));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(DDLUtils$.MODULE$.isHiveTable(table), "org.apache.spark.sql.execution.command.DDLUtils.isHiveTable(table)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1898));
        Option $org_scalatest_assert_macro_left = table.storage().serde();
        Some $org_scalatest_assert_macro_right = new Some((Object)"org.apache.hadoop.hive.ql.io.orc.OrcSerde");
        Option option = $org_scalatest_assert_macro_left;
        Some some = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1899));
        Option $org_scalatest_assert_macro_left2 = table.storage().properties().get((Object)"compression");
        Some $org_scalatest_assert_macro_right2 = new Some((Object)"Zlib");
        Option option2 = $org_scalatest_assert_macro_left2;
        Some some2 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1900));
        Object $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])$this.spark().table("t").collect());
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left3), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left3), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1901));
        $this.sql().apply((Object)"INSERT INTO t SELECT 1");
        $this.checkAnswer((Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
        Option maybeOrcFile = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])path.listFiles()), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)HiveDDLSuite.$anonfun$new$230(x$5)));
        $this.assertCompression((Option<File>)maybeOrcFile, "orc", OrcCompressionCodec.ZLIB.name());
        $this.sql().apply((Object)"CREATE TABLE t2 USING HIVE AS SELECT 1 AS c1, 'a' AS c2");
        CatalogTable table2 = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply("t2"));
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(DDLUtils$.MODULE$.isHiveTable(table2), "org.apache.spark.sql.execution.command.DDLUtils.isHiveTable(table2)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1911));
        Option $org_scalatest_assert_macro_left4 = table2.storage().serde();
        Some $org_scalatest_assert_macro_right3 = new Some((Object)"org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe");
        Option option3 = $org_scalatest_assert_macro_left4;
        Some some3 = $org_scalatest_assert_macro_right3;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(option3 != null ? !option3.equals(some3) : some3 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1912));
        $this.checkAnswer((Function0 & Serializable)() -> $this.spark().table("t2"), Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a"})));
        $this.sql().apply((Object)"CREATE TABLE t3(a int, p int) USING hive PARTITIONED BY (p)");
        $this.sql().apply((Object)"INSERT INTO t3 PARTITION(p=1) SELECT 0");
        $this.checkAnswer((Function0 & Serializable)() -> $this.spark().table("t3"), Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)1)})));
    }

    public static final /* synthetic */ void $anonfun$new$235(HiveDDLSuite $this, File dir) {
        org.apache.spark.sql.classic.Dataset df = $this.spark().catalog().createTable("t", "hive", new StructType().add("i", "int"), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)dir.getCanonicalPath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fileFormat"), (Object)"parquet")})));
        Object $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])df.collect());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1930));
        CatalogTable table = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply("t"));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(DDLUtils$.MODULE$.isHiveTable(table), "org.apache.spark.sql.execution.command.DDLUtils.isHiveTable(table)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1933));
        Option $org_scalatest_assert_macro_left2 = table.storage().inputFormat();
        Some $org_scalatest_assert_macro_right = new Some((Object)"org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat");
        Option option = $org_scalatest_assert_macro_left2;
        Some some = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1934));
        Option $org_scalatest_assert_macro_left3 = table.storage().outputFormat();
        Some $org_scalatest_assert_macro_right2 = new Some((Object)"org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat");
        Option option2 = $org_scalatest_assert_macro_left3;
        Some some2 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1936));
        Option $org_scalatest_assert_macro_left4 = table.storage().serde();
        Some $org_scalatest_assert_macro_right3 = new Some((Object)"org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe");
        Option option3 = $org_scalatest_assert_macro_left4;
        Some some3 = $org_scalatest_assert_macro_right3;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(option3 != null ? !option3.equals(some3) : some3 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1938));
        $this.sql().apply((Object)"INSERT INTO t SELECT 1");
        $this.checkAnswer((Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
    }

    public static final /* synthetic */ void $anonfun$new$262(HiveDDLSuite $this, File dir) {
        AnalysisException e = (AnalysisException)$this.intercept((Function0 & Serializable)() -> $this.spark().read().format("hive").load(dir.getAbsolutePath()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2173));
        String $org_scalatest_assert_macro_left = e.message();
        String $org_scalatest_assert_macro_right = "Hive data source can only be used with tables";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2176));
        AnalysisException e2 = (AnalysisException)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(HiveDDLSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator151$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator151$1(HiveDDLSuite $outer) {
                }
            }
            $this.testImplicits().localSeqToDatasetHolder((scala.collection.immutable.Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"a"), (List)Nil$.MODULE$), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator151$1(null)))).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"})).write().format("hive").save(dir.getAbsolutePath());
        }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2178));
        String $org_scalatest_assert_macro_left2 = e2.message();
        String $org_scalatest_assert_macro_right2 = "Hive data source can only be used with tables";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2181));
        AnalysisException e3 = (AnalysisException)$this.intercept((Function0 & Serializable)() -> $this.spark().readStream().format("hive").load(dir.getAbsolutePath()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2183));
        String $org_scalatest_assert_macro_left3 = e3.message();
        String $org_scalatest_assert_macro_right3 = "Hive data source can only be used with tables";
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2186));
        AnalysisException e4 = (AnalysisException)$this.intercept((Function0 & Serializable)() -> $this.spark().readStream().schema(new StructType()).parquet(dir.getAbsolutePath()).writeStream().format("hive").start(dir.getAbsolutePath()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2188));
        String $org_scalatest_assert_macro_left4 = e4.message();
        String $org_scalatest_assert_macro_right4 = "Hive data source can only be used with tables";
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2192));
    }

    private final scala.collection.immutable.Seq getTableColumns$1(String tblName) {
        return (scala.collection.immutable.Seq)this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tblName)).schema().map((Function1 & Serializable)x$6 -> x$6.name());
    }

    public static final /* synthetic */ void $anonfun$new$270(HiveDDLSuite $this, String provider$13, File path) {
        String dataPath = new File(new File(path, "d=1"), "b=1").getCanonicalPath();
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(HiveDDLSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator171$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator171$1(HiveDDLSuite $outer) {
            }
        }
        $this.testImplicits().localSeqToDatasetHolder((scala.collection.immutable.Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator171$1(null)))).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "c"})).write().save(dataPath);
        $this.sql().apply((Object)("CREATE TABLE t3 USING " + provider$13 + " LOCATION '" + path.toURI() + "'"));
        scala.collection.immutable.Seq $org_scalatest_assert_macro_left = $this.getTableColumns$1("t3");
        .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"a", (List)new .colon.colon((Object)"c", (List)new .colon.colon((Object)"d", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$))));
        scala.collection.immutable.Seq seq = $org_scalatest_assert_macro_left;
        .colon.colon colon2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2217));
    }

    public static final /* synthetic */ void $anonfun$new$274(HiveDDLSuite $this, File dir) {
        $this.spark().sql("CREATE TABLE t(a int, b int) USING hive LOCATION '" + dir.toURI() + "'");
        CatalogTable table = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply("t"));
        URI $org_scalatest_assert_macro_left = table.location();
        URI $org_scalatest_assert_macro_right = $this.makeQualifiedPath(dir.getAbsolutePath());
        URI uRI = $org_scalatest_assert_macro_left;
        URI uRI2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(uRI != null ? !((Object)uRI).equals(uRI2) : uRI2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2240));
        $this.spark().sql("INSERT INTO TABLE t SELECT 1, 2");
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(dir.exists(), "dir.exists()", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2243));
        $this.checkAnswer((Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})));
    }

    public static final /* synthetic */ void $anonfun$new$276(HiveDDLSuite $this, File dir) {
        $this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |CREATE TABLE t1(a int, b int)\n             |USING hive\n             |PARTITIONED BY(a)\n             |LOCATION '" + dir.toURI() + "'\n           ")));
        CatalogTable table = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply("t1"));
        URI $org_scalatest_assert_macro_left = table.location();
        URI $org_scalatest_assert_macro_right = $this.makeQualifiedPath(dir.getAbsolutePath());
        URI uRI = $org_scalatest_assert_macro_left;
        URI uRI2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(uRI != null ? !((Object)uRI).equals(uRI2) : uRI2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2258));
        $this.spark().sql("INSERT INTO TABLE t1 PARTITION(a=1) SELECT 2");
        File partDir = new File(dir, "a=1");
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(partDir.exists(), "partDir.exists()", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2263));
        $this.checkAnswer((Function0 & Serializable)() -> $this.spark().table("t1"), Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})));
    }

    public static final /* synthetic */ void $anonfun$new$282(HiveDDLSuite $this, boolean shouldDelete$1, File dir) {
        Object object = shouldDelete$1 ? BoxesRunTime.boxToBoolean((boolean)dir.delete()) : BoxedUnit.UNIT;
        $this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE t\n                 |USING hive\n                 |LOCATION '" + dir.toURI() + "'\n                 |AS SELECT 3 as a, 4 as b, 1 as c, 2 as d\n               ")));
        CatalogTable table = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply("t"));
        URI $org_scalatest_assert_macro_left = table.location();
        URI $org_scalatest_assert_macro_right = $this.makeQualifiedPath(dir.getAbsolutePath());
        URI uRI = $org_scalatest_assert_macro_left;
        URI uRI2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(uRI != null ? !((Object)uRI).equals(uRI2) : uRI2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2286));
        $this.checkAnswer((Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})));
    }

    public static final /* synthetic */ void $anonfun$new$284(HiveDDLSuite $this, boolean shouldDelete$1, File dir) {
        Object object = shouldDelete$1 ? BoxesRunTime.boxToBoolean((boolean)dir.delete()) : BoxedUnit.UNIT;
        $this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE t1\n                 |USING hive\n                 |PARTITIONED BY(a, b)\n                 |LOCATION '" + dir.toURI() + "'\n                 |AS SELECT 3 as a, 4 as b, 1 as c, 2 as d\n               ")));
        CatalogTable table = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply("t1"));
        URI $org_scalatest_assert_macro_left = table.location();
        URI $org_scalatest_assert_macro_right = $this.makeQualifiedPath(dir.getAbsolutePath());
        URI uRI = $org_scalatest_assert_macro_left;
        URI uRI2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(uRI != null ? !((Object)uRI).equals(uRI2) : uRI2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2302));
        File partDir = new File(dir, "a=3");
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(partDir.exists(), "partDir.exists()", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2305));
        $this.checkAnswer((Function0 & Serializable)() -> $this.spark().table("t1"), Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)4)})));
    }

    public static final /* synthetic */ void $anonfun$new$278(HiveDDLSuite $this, boolean shouldDelete) {
        String tcName = shouldDelete ? "non-existing" : "existed";
        $this.test("CTAS for external hive table with a " + tcName + " location", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t", "t1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> $this.withSQLConf((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.exec.dynamic.partition.mode"), (Object)"nonstrict")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            $this.withTempDir((Function1 & Serializable)dir -> {
                HiveDDLSuite.$anonfun$new$282($this, shouldDelete, dir);
                return BoxedUnit.UNIT;
            });
            $this.withTempDir((Function1 & Serializable)dir -> {
                HiveDDLSuite.$anonfun$new$284($this, shouldDelete, dir);
                return BoxedUnit.UNIT;
            });
        })), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2273));
    }

    public static final /* synthetic */ void $anonfun$new$290(HiveDDLSuite $this, String specialChars$1, String datasource$1, File dir) {
        $this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE t(a string, `" + specialChars$1 + "` string)\n                 |USING " + datasource$1 + "\n                 |PARTITIONED BY(`" + specialChars$1 + "`)\n                 |LOCATION '" + dir.toURI() + "'\n               ")));
        Object $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])dir.listFiles());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2327));
        $this.spark().sql("INSERT INTO TABLE t PARTITION(`" + specialChars$1 + "`=2) SELECT 1");
        String partEscaped = ExternalCatalogUtils$.MODULE$.escapePathName(specialChars$1) + "=2";
        File partFile = new File(dir, partEscaped);
        Object $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])partFile.listFiles());
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left2), "nonEmpty", ArrayOps$.MODULE$.nonEmpty$extension($org_scalatest_assert_macro_left2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2331));
        Row row = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", "2"}));
        $this.checkAnswer((Function0 & Serializable)() -> $this.spark().table("t"), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row));
        $this.withSQLConf((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.exec.dynamic.partition.mode"), (Object)"nonstrict")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            $this.spark().sql("INSERT INTO TABLE t PARTITION(`" + specialChars$1 + "`) SELECT 3, 4");
            String partEscaped1 = ExternalCatalogUtils$.MODULE$.escapePathName(specialChars$1) + "=4";
            File partFile1 = new File(dir, partEscaped1);
            Object $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])partFile1.listFiles());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left), "nonEmpty", ArrayOps$.MODULE$.nonEmpty$extension($org_scalatest_assert_macro_left), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2338));
            Row row = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", "2"}));
            Row row2 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"3", "4"}));
            $this.checkAnswer((Function0 & Serializable)() -> $this.spark().table("t"), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
        });
    }

    public static final /* synthetic */ void $anonfun$new$286(HiveDDLSuite $this, String datasource) {
        new .colon.colon((Object)"a b", (List)new .colon.colon((Object)"a:b", (List)new .colon.colon((Object)"a%b", (List)new .colon.colon((Object)"a,b", (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)specialChars -> {
            $this.test("partition column name of " + datasource + " table containing " + specialChars, (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> $this.withTempDir((Function1 & Serializable)dir -> {
                HiveDDLSuite.$anonfun$new$290($this, specialChars, datasource$1, dir);
                return BoxedUnit.UNIT;
            })), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2316));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$298(HiveDDLSuite $this, String specialChars$2, File dir) {
        File loc = new File(dir, specialChars$2);
        loc.mkdir();
        String escapedLoc = loc.getAbsolutePath().replace("\\", "\\\\");
        $this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n               |CREATE TABLE t(a string)\n               |USING hive\n               |LOCATION '" + escapedLoc + "'\n             ")));
        CatalogTable table = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply("t"));
        URI $org_scalatest_assert_macro_left = table.location();
        URI $org_scalatest_assert_macro_right = $this.makeQualifiedPath(loc.getAbsolutePath());
        URI uRI = $org_scalatest_assert_macro_left;
        URI uRI2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(uRI != null ? !((Object)uRI).equals(uRI2) : uRI2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2368));
        String $org_scalatest_assert_macro_left2 = new Path(table.location()).toString();
        String $org_scalatest_assert_macro_right2 = specialChars$2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2369));
        Object $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])loc.listFiles());
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left3), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left3), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2371));
        String string = specialChars$2;
        String string2 = "a:b";
        if (string == null ? string2 != null : !string.equals(string2)) {
            $this.spark().sql("INSERT INTO TABLE t SELECT 1");
            int $org_scalatest_assert_macro_left4 = loc.listFiles().length;
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4 >= $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2374));
            Row row = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1"}));
            $this.checkAnswer((Function0 & Serializable)() -> $this.spark().table("t"), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row));
            return;
        }
        AnalysisException x$121 = (AnalysisException)$this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)"INSERT INTO TABLE t SELECT 1"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2378));
        String x$122 = "_LEGACY_ERROR_TEMP_3065";
        Map x$123 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clazz"), (Object)"java.lang.IllegalArgumentException"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)"java.net.URISyntaxException: Relative path in absolute URI: a:b")}));
        Option x$124 = $this.checkError$default$3();
        boolean x$125 = $this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$126 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$121, "_LEGACY_ERROR_TEMP_3065", x$124, x$123, x$125, x$126);
    }

    public static final /* synthetic */ void $anonfun$new$301(HiveDDLSuite $this, String specialChars$2, File dir) {
        File loc = new File(dir, specialChars$2);
        loc.mkdir();
        String escapedLoc = loc.getAbsolutePath().replace("\\", "\\\\");
        $this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n               |CREATE TABLE t1(a string, b string)\n               |USING hive\n               |PARTITIONED BY(b)\n               |LOCATION '" + escapedLoc + "'\n             ")));
        CatalogTable table = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply("t1"));
        URI $org_scalatest_assert_macro_left = table.location();
        URI $org_scalatest_assert_macro_right = $this.makeQualifiedPath(loc.getAbsolutePath());
        URI uRI = $org_scalatest_assert_macro_left;
        URI uRI2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(uRI != null ? !((Object)uRI).equals(uRI2) : uRI2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2402));
        String $org_scalatest_assert_macro_left2 = new Path(table.location()).toString();
        String $org_scalatest_assert_macro_right2 = specialChars$2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2403));
        Object $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])loc.listFiles());
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left3), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left3), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2405));
        String string = specialChars$2;
        String string2 = "a:b";
        if (string == null ? string2 != null : !string.equals(string2)) {
            $this.spark().sql("INSERT INTO TABLE t1 PARTITION(b=2) SELECT 1");
            File partFile = new File(loc, "b=2");
            Object $org_scalatest_assert_macro_left4 = Predef$.MODULE$.refArrayOps((Object[])partFile.listFiles());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left4), "nonEmpty", ArrayOps$.MODULE$.nonEmpty$extension($org_scalatest_assert_macro_left4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2409));
            Row row = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", "2"}));
            $this.checkAnswer((Function0 & Serializable)() -> $this.spark().table("t1"), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row));
            $this.spark().sql("INSERT INTO TABLE t1 PARTITION(b='2017-03-03 12:13%3A14') SELECT 1");
            File partFile1 = new File(loc, "b=2017-03-03 12:13%3A14");
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(partFile1.exists(), "partFile1.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2414));
            if (!Utils$.MODULE$.isWindows()) {
                File partFile2 = new File(loc, "b=2017-03-03 12%3A13%253A14");
                Object $org_scalatest_assert_macro_left5 = Predef$.MODULE$.refArrayOps((Object[])partFile2.listFiles());
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left5), "nonEmpty", ArrayOps$.MODULE$.nonEmpty$extension($org_scalatest_assert_macro_left5), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2419));
                Row row2 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", "2"}));
                Row row3 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", "2017-03-03 12:13%3A14"}));
                $this.checkAnswer((Function0 & Serializable)() -> $this.spark().table("t1"), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2));
                return;
            }
            return;
        }
        AnalysisException x$127 = (AnalysisException)$this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)"INSERT INTO TABLE t1 PARTITION(b=2) SELECT 1"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2425));
        String x$128 = "_LEGACY_ERROR_TEMP_3065";
        Map x$129 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clazz"), (Object)"java.lang.IllegalArgumentException"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)"java.net.URISyntaxException: Relative path in absolute URI: a:b")}));
        Option x$130 = $this.checkError$default$3();
        boolean x$131 = $this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$132 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$127, "_LEGACY_ERROR_TEMP_3065", x$130, x$129, x$131, x$132);
        AnalysisException x$133 = (AnalysisException)$this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)"INSERT INTO TABLE t1 PARTITION(b='2017-03-03 12:13%3A14') SELECT 1"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2435));
        String x$134 = "_LEGACY_ERROR_TEMP_3065";
        Map x$135 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clazz"), (Object)"java.lang.IllegalArgumentException"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)"java.net.URISyntaxException: Relative path in absolute URI: a:b")}));
        Option x$136 = $this.checkError$default$3();
        boolean x$137 = $this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$138 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$133, "_LEGACY_ERROR_TEMP_3065", x$136, x$135, x$137, x$138);
    }

    public static final /* synthetic */ boolean $anonfun$new$315(StructField x$7) {
        String string = x$7.name();
        String string2 = "c5";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$351(File x$8) {
        return x$8.getName().startsWith("part");
    }

    public static final /* synthetic */ void $anonfun$new$349(HiveDDLSuite $this, String fileFormat$2, String compression$1, File path) {
        $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                |CREATE TABLE t(id int) USING hive\n                |OPTIONS(fileFormat '" + fileFormat$2 + "', compression '" + compression$1 + "')\n                |LOCATION '" + path.toURI() + "'\n              ")));
        CatalogTable table = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply("t"));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(DDLUtils$.MODULE$.isHiveTable(table), "org.apache.spark.sql.execution.command.DDLUtils.isHiveTable(table)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2716));
        String $org_scalatest_assert_macro_left = (String)table.storage().serde().get();
        String $org_scalatest_assert_macro_right = fileFormat$2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2717));
        Option $org_scalatest_assert_macro_left2 = table.storage().properties().get((Object)"compression");
        Some $org_scalatest_assert_macro_right2 = new Some((Object)compression$1);
        Option option = $org_scalatest_assert_macro_left2;
        Some some = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2718));
        Object $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])$this.spark().table("t").collect());
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left3), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left3), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2719));
        $this.sql().apply((Object)"INSERT INTO t SELECT 1");
        $this.checkAnswer((Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
        Option maybeFile = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])path.listFiles()), (Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)HiveDDLSuite.$anonfun$new$351(x$8)));
        $this.assertCompression((Option<File>)maybeFile, fileFormat$2, compression$1);
    }

    public static final /* synthetic */ void $anonfun$new$345(HiveDDLSuite $this, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            String fileFormat = (String)tuple2._1();
            String compression = (String)tuple2._2();
            $this.test("SPARK-22158 convertMetastore should not ignore table property - " + fileFormat, (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> $this.withSQLConf((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_ORC().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_PARQUET().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> $this.withTempPath((Function1 & Serializable)path -> {
                HiveDDLSuite.$anonfun$new$349($this, fileFormat, compression, path);
                return BoxedUnit.UNIT;
            }))), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2705));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$new$358(File x$9) {
        return x$9.getName().startsWith("part");
    }

    public static final /* synthetic */ void $anonfun$new$356(HiveDDLSuite $this, File path) {
        $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                |CREATE TABLE t(id int) STORED AS ORC\n                |TBLPROPERTIES (\n                |  orc.compress 'ZLIB',\n                |  orc.compress.size '1001',\n                |  orc.row.index.stride '2002',\n                |  hive.exec.orc.default.block.size '3003',\n                |  hive.exec.orc.compression.strategy 'COMPRESSION')\n                |LOCATION '" + path.toURI() + "'\n              ")));
        CatalogTable table = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply("t"));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(DDLUtils$.MODULE$.isHiveTable(table), "org.apache.spark.sql.execution.command.DDLUtils.isHiveTable(table)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2758));
        String $org_scalatest_assert_macro_left = (String)table.storage().serde().get();
        String $org_scalatest_assert_macro_right = "orc";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2759));
        Map properties = table.properties();
        Option $org_scalatest_assert_macro_left2 = properties.get((Object)"orc.compress");
        Some $org_scalatest_assert_macro_right2 = new Some((Object)OrcCompressionCodec.ZLIB.name());
        Option option = $org_scalatest_assert_macro_left2;
        Some some = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2761));
        Option $org_scalatest_assert_macro_left3 = properties.get((Object)"orc.compress.size");
        Some $org_scalatest_assert_macro_right3 = new Some((Object)"1001");
        Option option2 = $org_scalatest_assert_macro_left3;
        Some some2 = $org_scalatest_assert_macro_right3;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2762));
        Option $org_scalatest_assert_macro_left4 = properties.get((Object)"orc.row.index.stride");
        Some $org_scalatest_assert_macro_right4 = new Some((Object)"2002");
        Option option3 = $org_scalatest_assert_macro_left4;
        Some some3 = $org_scalatest_assert_macro_right4;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(option3 != null ? !option3.equals(some3) : some3 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2763));
        Option $org_scalatest_assert_macro_left5 = properties.get((Object)"hive.exec.orc.default.block.size");
        Some $org_scalatest_assert_macro_right5 = new Some((Object)"3003");
        Option option4 = $org_scalatest_assert_macro_left5;
        Some some4 = $org_scalatest_assert_macro_right5;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(option4 != null ? !option4.equals(some4) : some4 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2764));
        Option $org_scalatest_assert_macro_left6 = properties.get((Object)"hive.exec.orc.compression.strategy");
        Some $org_scalatest_assert_macro_right6 = new Some((Object)"COMPRESSION");
        Option option5 = $org_scalatest_assert_macro_left6;
        Some some5 = $org_scalatest_assert_macro_right6;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(option5 != null ? !option5.equals(some5) : some5 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2765));
        Object $org_scalatest_assert_macro_left7 = Predef$.MODULE$.refArrayOps((Object[])$this.spark().table("t").collect());
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left7), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left7), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2766));
        $this.sql().apply((Object)"INSERT INTO t SELECT 1");
        $this.checkAnswer((Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
        Option maybeFile = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])path.listFiles()), (Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)HiveDDLSuite.$anonfun$new$358(x$9)));
        Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> $this.getReader(((File)Option$.MODULE$.option2Iterable(maybeFile).head()).getCanonicalPath()), (Function1 & Serializable)reader -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(reader.getCompressionKind().name());
            String $org_scalatest_assert_macro_right = OrcCompressionCodec.ZLIB.name();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2773));
            int $org_scalatest_assert_macro_left2 = reader.getCompressionSize();
            int $org_scalatest_assert_macro_right2 = 1001;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2774));
            int $org_scalatest_assert_macro_left3 = reader.getRowIndexStride();
            int $org_scalatest_assert_macro_right3 = 2002;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2775));
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$366(File x$10) {
        return x$10.getName().startsWith("part");
    }

    public static final /* synthetic */ void $anonfun$new$364(HiveDDLSuite $this, File path) {
        $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n               |CREATE TABLE t(id int) STORED AS PARQUET\n               |TBLPROPERTIES (\n               |  parquet.compression 'GZIP'\n               |)\n               |LOCATION '" + path.toURI() + "'\n            ")));
        CatalogTable table = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply("t"));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(DDLUtils$.MODULE$.isHiveTable(table), "org.apache.spark.sql.execution.command.DDLUtils.isHiveTable(table)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2796));
        String $org_scalatest_assert_macro_left = (String)table.storage().serde().get();
        String $org_scalatest_assert_macro_right = "parquet";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2797));
        Map properties = table.properties();
        Option $org_scalatest_assert_macro_left2 = properties.get((Object)"parquet.compression");
        Some $org_scalatest_assert_macro_right2 = new Some((Object)ParquetCompressionCodec.GZIP.name());
        Option option = $org_scalatest_assert_macro_left2;
        Some some = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2799));
        Object $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])$this.spark().table("t").collect());
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left3), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left3), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2800));
        $this.sql().apply((Object)"INSERT INTO t SELECT 1");
        $this.checkAnswer((Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
        Option maybeFile = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])path.listFiles()), (Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)HiveDDLSuite.$anonfun$new$366(x$10)));
        $this.assertCompression((Option<File>)maybeFile, "parquet", ParquetCompressionCodec.GZIP.name());
    }

    public static final /* synthetic */ void $anonfun$new$377(HiveDDLSuite $this, String c) {
        String typ = "array<struct<`abc" + c + "xyz`:int>>";
        AnalysisException e = (AnalysisException)$this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)("CREATE TABLE t (a " + typ + ") USING hive")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2853));
        $this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            AnalysisException x$181 = e;
            String x$182 = "_LEGACY_ERROR_TEMP_3065";
            Map x$183 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clazz"), (Object)e.getCause().getClass().getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)e.getCause().getMessage())}));
            Option x$184 = $this.checkError$default$3();
            boolean x$185 = $this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$186 = $this.checkError$default$6();
            $this.checkError((SparkThrowable)x$181, "_LEGACY_ERROR_TEMP_3065", x$184, x$183, x$185, x$186);
        });
    }

    public static final /* synthetic */ void $anonfun$new$392(HiveDDLSuite $this, SessionCatalog catalog$8, String tableType) {
        Option expectedSerde = HiveSerDe$.MODULE$.sourceToSerDe(tableType);
        $this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t LIKE s STORED AS " + tableType));
            CatalogTable table = catalog$8.getTableMetadata(TableIdentifier$.MODULE$.apply("t"));
            Option $org_scalatest_assert_macro_left = table.provider();
            Some $org_scalatest_assert_macro_right = new Some((Object)"hive");
            Option option = $org_scalatest_assert_macro_left;
            Some some = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2946));
            Option $org_scalatest_assert_macro_left2 = table.storage().serde();
            Option $org_scalatest_assert_macro_right2 = ((HiveSerDe)expectedSerde.get()).serde();
            Option option2 = $org_scalatest_assert_macro_left2;
            Option option3 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option2 != null ? !option2.equals(option3) : option3 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2947));
            Option $org_scalatest_assert_macro_left3 = table.storage().inputFormat();
            Option $org_scalatest_assert_macro_right3 = ((HiveSerDe)expectedSerde.get()).inputFormat();
            Option option4 = $org_scalatest_assert_macro_left3;
            Option option5 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option4 != null ? !option4.equals(option5) : option5 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2948));
            Option $org_scalatest_assert_macro_left4 = table.storage().outputFormat();
            Option $org_scalatest_assert_macro_right4 = ((HiveSerDe)expectedSerde.get()).outputFormat();
            Option option6 = $org_scalatest_assert_macro_left4;
            Option option7 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(option6 != null ? !option6.equals(option7) : option7 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2949));
        });
    }

    public static final /* synthetic */ void $anonfun$new$396(HiveDDLSuite $this, SessionCatalog catalog$9, String tableType) {
        Option expectedSerde = HiveSerDe$.MODULE$.sourceToSerDe(tableType);
        $this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)("CREATE TABLE t LIKE v STORED AS " + tableType));
            CatalogTable table = catalog$9.getTableMetadata(TableIdentifier$.MODULE$.apply("t"));
            Option $org_scalatest_assert_macro_left = table.provider();
            Some $org_scalatest_assert_macro_right = new Some((Object)"hive");
            Option option = $org_scalatest_assert_macro_left;
            Some some = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2964));
            Option $org_scalatest_assert_macro_left2 = table.storage().serde();
            Option $org_scalatest_assert_macro_right2 = ((HiveSerDe)expectedSerde.get()).serde();
            Option option2 = $org_scalatest_assert_macro_left2;
            Option option3 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option2 != null ? !option2.equals(option3) : option3 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2965));
            Option $org_scalatest_assert_macro_left3 = table.storage().inputFormat();
            Option $org_scalatest_assert_macro_right3 = ((HiveSerDe)expectedSerde.get()).inputFormat();
            Option option4 = $org_scalatest_assert_macro_left3;
            Option option5 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option4 != null ? !option4.equals(option5) : option5 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2966));
            Option $org_scalatest_assert_macro_left4 = table.storage().outputFormat();
            Option $org_scalatest_assert_macro_right4 = ((HiveSerDe)expectedSerde.get()).outputFormat();
            Option option6 = $org_scalatest_assert_macro_left4;
            Option option7 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(option6 != null ? !option6.equals(option7) : option7 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2967));
        });
    }

    public static final /* synthetic */ void $anonfun$new$413(HiveDDLSuite $this, scala.collection.immutable.Seq allowSerdeFileFormats$1, SessionCatalog catalog$12, String sourceTable) {
        allowSerdeFileFormats$1.foreach((Function1 & Serializable)format -> {
            $this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"targetTable"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                $this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE targetTable LIKE " + sourceTable$2 + "\n                 |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe'\n                 |STORED AS " + format + "\n             ")));
                Option expectedSerde = HiveSerDe$.MODULE$.sourceToSerDe(format);
                CatalogTable table = catalog$12.getTableMetadata(TableIdentifier$.MODULE$.apply("targetTable", (Option)new Some((Object)"default")));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(table.provider());
                Some $org_scalatest_assert_macro_right = new Some((Object)"hive");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3102));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(table.storage().inputFormat());
                Some $org_scalatest_assert_macro_right2 = new Some(((HiveSerDe)expectedSerde.get()).inputFormat().get());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3103));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(table.storage().outputFormat());
                Some $org_scalatest_assert_macro_right3 = new Some(((HiveSerDe)expectedSerde.get()).outputFormat().get());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3104));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(table.storage().serde());
                Some $org_scalatest_assert_macro_right4 = new Some((Object)"org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3105));
            });
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)$this.hiveFormats().filterNot((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)allowSerdeFileFormats$1.contains((Object)x$11)))).foreach((Function1 & Serializable)format -> {
            $this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"targetTable"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                String sql1 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE TABLE targetTable LIKE " + sourceTable$2 + "\n                 |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe'\n                 |STORED AS " + format));
                $this.checkError((SparkThrowable)$this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)sql1), ClassTag$.MODULE$.apply(ParseException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3118)), "_LEGACY_ERROR_TEMP_0035", (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)("ROW FORMAT SERDE is incompatible with format '" + format.toLowerCase(Locale.ROOT) + "', which also specifies a serde"))})), $this.ExpectedContext().apply(sql1, 0, 110 + sourceTable$2.length() + format.length()));
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$423(HiveDDLSuite $this, SessionCatalog catalog$12, String tableType) {
        Option expectedSerde = HiveSerDe$.MODULE$.sourceToSerDe(tableType);
        new .colon.colon((Object)"sourceHiveTable", (List)new .colon.colon((Object)"sourceDsTable", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)sourceTable -> {
            $this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"targetTable"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                $this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE targetTable LIKE " + sourceTable + "\n                 |ROW FORMAT SERDE '" + ((HiveSerDe)expectedSerde$3.get()).serde().get() + "'\n                 |STORED AS INPUTFORMAT '" + ((HiveSerDe)expectedSerde$3.get()).inputFormat().get() + "'\n                 |OUTPUTFORMAT '" + ((HiveSerDe)expectedSerde$3.get()).outputFormat().get() + "'\n               ")));
                CatalogTable table = catalog$12.getTableMetadata(TableIdentifier$.MODULE$.apply("targetTable", (Option)new Some((Object)"default")));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(table.provider());
                Some $org_scalatest_assert_macro_right = new Some((Object)"hive");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3186));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(table.storage().inputFormat());
                Some $org_scalatest_assert_macro_right2 = new Some(((HiveSerDe)expectedSerde$3.get()).inputFormat().get());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3187));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(table.storage().outputFormat());
                Some $org_scalatest_assert_macro_right3 = new Some(((HiveSerDe)expectedSerde$3.get()).outputFormat().get());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3188));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(table.storage().serde());
                Some $org_scalatest_assert_macro_right4 = new Some(((HiveSerDe)expectedSerde$3.get()).serde().get());
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3189));
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$430(HiveDDLSuite $this, File path$2, String format) {
        AnalysisException x$187 = (AnalysisException)((Throwable)$this.intercept((Function0 & Serializable)() -> $this.spark().sql("INSERT OVERWRITE LOCAL DIRECTORY '" + path$2.getCanonicalPath() + "' STORED AS " + format + " SELECT ID, if(1=1, 1, 0), abs(id), '^-' FROM v"), ClassTag$.MODULE$.apply(SparkException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3203))).getCause();
        String x$188 = "INVALID_COLUMN_NAME_AS_PATH";
        Map x$189 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datasource"), (Object)"HiveFileFormat"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)"`(IF((1 = 1), 1, 0))`")}));
        Option x$190 = $this.checkError$default$3();
        boolean x$191 = $this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$192 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$187, "INVALID_COLUMN_NAME_AS_PATH", x$190, x$189, x$191, x$192);
    }

    public static final /* synthetic */ void $anonfun$new$429(HiveDDLSuite $this, File path) {
        new .colon.colon((Object)"PARQUET", (List)new .colon.colon((Object)"ORC", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)format -> {
            HiveDDLSuite.$anonfun$new$430($this, path, format);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$435(HiveDDLSuite $this, File path) {
        AnalysisException x$193 = (AnalysisException)((Throwable)$this.intercept((Function0 & Serializable)() -> $this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                   |INSERT OVERWRITE LOCAL DIRECTORY '" + path.getCanonicalPath() + "'\n                   |STORED AS PARQUET\n                   |SELECT\n                   |NAMED_STRUCT('ID', ID, 'IF(ID=1,ID,0)', IF(ID=1,ID,0), 'B', ABS(ID)) AS col1\n                   |FROM v\n               "))), ClassTag$.MODULE$.apply(SparkException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3225))).getCause();
        String x$194 = "INVALID_COLUMN_NAME_AS_PATH";
        Map x$195 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datasource"), (Object)"HiveFileFormat"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)"`IF(ID=1,ID,0)`")}));
        Option x$196 = $this.checkError$default$3();
        boolean x$197 = $this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$198 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$193, "INVALID_COLUMN_NAME_AS_PATH", x$196, x$195, x$197, x$198);
    }

    public static final /* synthetic */ void $anonfun$new$440(HiveDDLSuite $this, String k) {
        $this.spark().sparkContext().addedJars().get((Object)"default").foreach((Function1 & Serializable)x$13 -> x$13.remove((Object)k));
    }

    public static final /* synthetic */ void $anonfun$new$448(HiveDDLSuite $this, String tbl$1, String sqlCmd) {
        SparkUnsupportedOperationException x$205 = (SparkUnsupportedOperationException)$this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)sqlCmd), ClassTag$.MODULE$.apply(SparkUnsupportedOperationException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3284));
        String x$206 = "UNSUPPORTED_FEATURE.HIVE_WITH_ANSI_INTERVALS";
        Map x$207 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)("`" + CatalogManager$.MODULE$.SESSION_CATALOG_NAME() + "`.`default`.`" + tbl$1 + "`"))}));
        Option x$208 = $this.checkError$default$3();
        boolean x$209 = $this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$210 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$205, "UNSUPPORTED_FEATURE.HIVE_WITH_ANSI_INTERVALS", x$208, x$207, x$209, x$210);
    }

    public HiveDDLSuite() {
        TestHiveSingleton.$init$(this);
        this.hiveFormats = new .colon.colon((Object)"PARQUET", (List)new .colon.colon((Object)"ORC", (List)new .colon.colon((Object)"TEXTFILE", (List)new .colon.colon((Object)"SEQUENCEFILE", (List)new .colon.colon((Object)"RCFILE", (List)new .colon.colon((Object)"AVRO", (List)Nil$.MODULE$))))));
        this.test("alter table: change column", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testChangeColumn(false), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        this.test("alter datasource table add columns - orc", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testAddColumn("orc"), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
        this.test("alter datasource table add columns - partitioned - orc", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testAddColumnPartitioned("orc"), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        this.test("SPARK-46934: quote element name before parsing struct", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)"CREATE TABLE t USING hive AS SELECT STRUCT('a' AS `$a`, 1 AS b) q");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.spark().table("t").schema());
                StructType $org_scalatest_assert_macro_right = CatalystSqlParser$.MODULE$.parseTableSchema("q STRUCT<`$a`: STRING, b: INT>");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
            });
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)"CREATE TABLE t(q STRUCT<`$a`:INT, col2:STRING>, i1 INT) USING hive");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.spark().table("t").schema());
                StructType $org_scalatest_assert_macro_right = CatalystSqlParser$.MODULE$.parseTableSchema("q STRUCT<`$a`:INT, col2:STRING>, i1 INT");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
            });
            this.withView((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.spark().sql("CREATE VIEW v AS SELECT STRUCT('a' AS `a`, 1 AS b) q");
                Row row = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToInteger((int)1)}));
                this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"SELECT q.`a`, q.b FROM v"), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row));
            });
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        this.test("SPARK-22431: table with nested type", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t", "x"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().sql("CREATE TABLE t(q STRUCT<`$a`:INT, col2:STRING>, i1 INT) USING PARQUET");
            this.checkAnswer((Function0 & Serializable)() -> this.spark().table("t"), (scala.collection.immutable.Seq)Nil$.MODULE$);
            this.spark().sql("CREATE TABLE x (q STRUCT<col1:INT, col2:STRING>, i1 INT)");
            this.checkAnswer((Function0 & Serializable)() -> this.spark().table("x"), (scala.collection.immutable.Seq)Nil$.MODULE$);
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        this.test("SPARK-22431: view with nested type", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withView((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().sql("CREATE VIEW v AS SELECT STRUCT('a' AS `a`, 1 AS b) q");
            Row row = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToInteger((int)1)}))}));
            this.checkAnswer((Function0 & Serializable)() -> this.spark().table("v"), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row));
            this.spark().sql("ALTER VIEW v AS SELECT STRUCT('a' AS `b`, 1 AS b) q1");
            org.apache.spark.sql.classic.Dataset df = this.spark().table("v");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool("q1".equals(df.schema().fields()[0].name()), "\"q1\".equals(df.schema.fields.apply(0).name)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
            Row row2 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToInteger((int)1)}))}));
            this.checkAnswer((Function0 & Serializable)() -> df, (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row2));
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        this.test("SPARK-22431: alter table tests with nested types", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "t2", "t3"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().sql("CREATE TABLE t1 (q STRUCT<col1:INT, col2:STRING>, i1 INT) USING HIVE");
            this.spark().sql("ALTER TABLE t1 ADD COLUMNS (newcol1 STRUCT<`col1`:STRING, col2:Int>)");
            String newcol = this.spark().sql("SELECT * FROM t1").schema().fields()[2].name();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool("newcol1".equals(newcol), "\"newcol1\".equals(newcol)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
            this.spark().sql("CREATE TABLE t2(q STRUCT<`a`:INT, col2:STRING>, i1 INT) USING PARQUET");
            this.spark().sql("ALTER TABLE t2 ADD COLUMNS (newcol1 STRUCT<`$col1`:STRING, col2:Int>)");
            this.spark().sql("ALTER TABLE t2 ADD COLUMNS (newcol2 STRUCT<`col1`:STRING, col2:Int>)");
            org.apache.spark.sql.classic.Dataset df2 = this.spark().table("t2");
            this.checkAnswer((Function0 & Serializable)() -> df2, (scala.collection.immutable.Seq)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool("newcol1".equals(df2.schema().fields()[2].name()), "\"newcol1\".equals(df2.schema.fields.apply(2).name)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool("newcol2".equals(df2.schema().fields()[3].name()), "\"newcol2\".equals(df2.schema.fields.apply(3).name)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
            this.spark().sql("CREATE TABLE t3(q STRUCT<`$a`:INT, col2:STRING>, i1 INT) USING PARQUET");
            this.spark().sql("ALTER TABLE t3 ADD COLUMNS (newcol1 STRUCT<`$col1`:STRING, col2:Int>)");
            this.spark().sql("ALTER TABLE t3 ADD COLUMNS (newcol2 STRUCT<`col1`:STRING, col2:Int>)");
            org.apache.spark.sql.classic.Dataset df3 = this.spark().table("t3");
            this.checkAnswer((Function0 & Serializable)() -> df3, (scala.collection.immutable.Seq)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool("newcol1".equals(df3.schema().fields()[2].name()), "\"newcol1\".equals(df3.schema.fields.apply(2).name)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool("newcol2".equals(df3.schema().fields()[3].name()), "\"newcol2\".equals(df3.schema.fields.apply(3).name)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
        this.test("SPARK-46934: alter table tests with nested types", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE t1 (q STRUCT<col1:INT, col2:STRING>, i1 INT) USING hive");
            this.sql().apply((Object)"ALTER TABLE t1 ADD COLUMNS (newcol1 STRUCT<`$col1`:STRING, col2:Int>)");
            StructType $org_scalatest_assert_macro_left = this.spark().table("t1").schema();
            StructType $org_scalatest_assert_macro_right = CatalystSqlParser$.MODULE$.parseTableSchema("q STRUCT<col1:INT, col2:STRING>, i1 INT,newcol1 STRUCT<`$col1`:STRING, col2:Int>");
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        this.test("SPARK-26630: table with old input format and without partitioned will use HadoopRDD", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"table_old", "table_ctas_old"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |CREATE TABLE table_old (col1 LONG, col2 STRING, col3 DOUBLE, col4 BOOLEAN)\n          |STORED AS\n          |INPUTFORMAT 'org.apache.hadoop.mapred.TextInputFormat'\n          |OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat'\n        ")));
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |INSERT INTO table_old\n          |VALUES (2147483648, 'AAA', 3.14, false), (2147483649, 'BBB', 3.142, true)\n        ")));
            Row row = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0x80000000L), "AAA", BoxesRunTime.boxToDouble((double)3.14), BoxesRunTime.boxToBoolean((boolean)false)}));
            Row row2 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0x80000001L), "BBB", BoxesRunTime.boxToDouble((double)3.142), BoxesRunTime.boxToBoolean((boolean)true)}));
            this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"SELECT col1, col2, col3, col4 FROM table_old"), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
            this.sql().apply((Object)"CREATE TABLE table_ctas_old AS SELECT col1, col2, col3, col4 FROM table_old");
            Row row3 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0x80000000L), "AAA", BoxesRunTime.boxToDouble((double)3.14), BoxesRunTime.boxToBoolean((boolean)false)}));
            Row row4 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0x80000001L), "BBB", BoxesRunTime.boxToDouble((double)3.142), BoxesRunTime.boxToBoolean((boolean)true)}));
            this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"SELECT col1, col2, col3, col4 from table_ctas_old"), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row4).$colon$colon((Object)row3));
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
        this.test("SPARK-26630: table with old input format and partitioned will use HadoopRDD", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"table_pt_old", "table_ctas_pt_old"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |CREATE TABLE table_pt_old (col1 LONG, col2 STRING, col3 DOUBLE, col4 BOOLEAN)\n          |PARTITIONED BY (pt INT)\n          |STORED AS\n          |INPUTFORMAT 'org.apache.hadoop.mapred.TextInputFormat'\n          |OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat'\n        ")));
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |INSERT INTO table_pt_old PARTITION (pt = 1)\n          |VALUES (2147483648, 'AAA', 3.14, false), (2147483649, 'BBB', 3.142, true)\n        ")));
            Row row = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0x80000000L), "AAA", BoxesRunTime.boxToDouble((double)3.14), BoxesRunTime.boxToBoolean((boolean)false)}));
            Row row2 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0x80000001L), "BBB", BoxesRunTime.boxToDouble((double)3.142), BoxesRunTime.boxToBoolean((boolean)true)}));
            this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"SELECT col1, col2, col3, col4 FROM table_pt_old WHERE pt = 1"), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
            this.sql().apply((Object)"CREATE TABLE table_ctas_pt_old AS SELECT col1, col2, col3, col4 FROM table_pt_old");
            Row row3 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0x80000000L), "AAA", BoxesRunTime.boxToDouble((double)3.14), BoxesRunTime.boxToBoolean((boolean)false)}));
            Row row4 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0x80000001L), "BBB", BoxesRunTime.boxToDouble((double)3.142), BoxesRunTime.boxToBoolean((boolean)true)}));
            this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"SELECT col1, col2, col3, col4 from table_ctas_pt_old"), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row4).$colon$colon((Object)row3));
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
        this.test("SPARK-26630: table with new input format and without partitioned will use NewHadoopRDD", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"table_new", "table_ctas_new"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |CREATE TABLE table_new (col1 LONG, col2 STRING, col3 DOUBLE, col4 BOOLEAN)\n          |STORED AS\n          |INPUTFORMAT 'org.apache.hadoop.mapreduce.lib.input.TextInputFormat'\n          |OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat'\n        ")));
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |INSERT INTO table_new\n          |VALUES (2147483648, 'AAA', 3.14, false), (2147483649, 'BBB', 3.142, true)\n        ")));
            Row row = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0x80000000L), "AAA", BoxesRunTime.boxToDouble((double)3.14), BoxesRunTime.boxToBoolean((boolean)false)}));
            Row row2 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0x80000001L), "BBB", BoxesRunTime.boxToDouble((double)3.142), BoxesRunTime.boxToBoolean((boolean)true)}));
            this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"SELECT col1, col2, col3, col4 FROM table_new"), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
            this.sql().apply((Object)"CREATE TABLE table_ctas_new AS SELECT col1, col2, col3, col4 FROM table_new");
            Row row3 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0x80000000L), "AAA", BoxesRunTime.boxToDouble((double)3.14), BoxesRunTime.boxToBoolean((boolean)false)}));
            Row row4 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0x80000001L), "BBB", BoxesRunTime.boxToDouble((double)3.142), BoxesRunTime.boxToBoolean((boolean)true)}));
            this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"SELECT col1, col2, col3, col4 from table_ctas_new"), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row4).$colon$colon((Object)row3));
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
        this.test("SPARK-26630: table with new input format and partitioned will use NewHadoopRDD", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"table_pt_new", "table_ctas_pt_new"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |CREATE TABLE table_pt_new (col1 LONG, col2 STRING, col3 DOUBLE, col4 BOOLEAN)\n          |PARTITIONED BY (pt INT)\n          |STORED AS\n          |INPUTFORMAT 'org.apache.hadoop.mapreduce.lib.input.TextInputFormat'\n          |OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat'\n        ")));
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |INSERT INTO table_pt_new PARTITION (pt = 1)\n          |VALUES (2147483648, 'AAA', 3.14, false), (2147483649, 'BBB', 3.142, true)\n        ")));
            Row row = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0x80000000L), "AAA", BoxesRunTime.boxToDouble((double)3.14), BoxesRunTime.boxToBoolean((boolean)false)}));
            Row row2 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0x80000001L), "BBB", BoxesRunTime.boxToDouble((double)3.142), BoxesRunTime.boxToBoolean((boolean)true)}));
            this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"SELECT col1, col2, col3, col4 FROM table_pt_new WHERE pt = 1"), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
            this.sql().apply((Object)"CREATE TABLE table_ctas_pt_new AS SELECT col1, col2, col3, col4 FROM table_pt_new");
            Row row3 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0x80000000L), "AAA", BoxesRunTime.boxToDouble((double)3.14), BoxesRunTime.boxToBoolean((boolean)false)}));
            Row row4 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0x80000001L), "BBB", BoxesRunTime.boxToDouble((double)3.142), BoxesRunTime.boxToBoolean((boolean)true)}));
            this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"SELECT col1, col2, col3, col4 from table_ctas_pt_new"), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row4).$colon$colon((Object)row3));
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
        this.test("Create Table LIKE USING Hive built-in ORC in Hive catalog", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SessionCatalog catalog = this.spark().sessionState().catalog();
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"s", "t"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)"CREATE TABLE s(a INT, b INT) USING parquet");
                CatalogTable source = catalog.getTableMetadata(TableIdentifier$.MODULE$.apply("s"));
                Option $org_scalatest_assert_macro_left = source.provider();
                Some $org_scalatest_assert_macro_right = new Some((Object)"parquet");
                Option option = $org_scalatest_assert_macro_left;
                Some some = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
                this.sql().apply((Object)"CREATE TABLE t LIKE s USING org.apache.spark.sql.hive.orc");
                CatalogTable table = catalog.getTableMetadata(TableIdentifier$.MODULE$.apply("t"));
                Option $org_scalatest_assert_macro_left2 = table.provider();
                Some $org_scalatest_assert_macro_right2 = new Some((Object)"org.apache.spark.sql.hive.orc");
                Option option2 = $org_scalatest_assert_macro_left2;
                Some some2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
            });
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
        this.test("Database Ownership", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Assertion assertion;
            SessionCatalog catalog = this.spark().sessionState().catalog();
            try {
                String db = "spark_29425_1";
                this.sql().apply((Object)("CREATE DATABASE " + db));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((Row)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])((org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("DESCRIBE DATABASE EXTENDED " + db))).where("info_name='Owner'").collect()))).getString(1));
                String $org_scalatest_assert_macro_right = Utils$.MODULE$.getCurrentUserName();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
                this.sql().apply((Object)("ALTER DATABASE " + db + " SET DBPROPERTIES('abc'='xyz')"));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(((Row)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])((org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("DESCRIBE DATABASE EXTENDED " + db))).where("info_name='Owner'").collect()))).getString(1));
                String $org_scalatest_assert_macro_right2 = Utils$.MODULE$.getCurrentUserName();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 367));
            }
            finally {
                catalog.reset();
            }
            return assertion;
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358));
        this.test("drop tables", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tab1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tabName = "tab1";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.tableDirectoryExists(TableIdentifier$.MODULE$.apply(tabName), this.tableDirectoryExists$default$2()), "HiveDDLSuite.this.tableDirectoryExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(tabName), HiveDDLSuite.this.tableDirectoryExists$default$2)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
            this.sql().apply((Object)("CREATE TABLE " + tabName + "(c1 int)"));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.tableDirectoryExists(TableIdentifier$.MODULE$.apply(tabName), this.tableDirectoryExists$default$2()), "HiveDDLSuite.this.tableDirectoryExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(tabName), HiveDDLSuite.this.tableDirectoryExists$default$2)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
            this.sql().apply((Object)("DROP TABLE " + tabName));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.tableDirectoryExists(TableIdentifier$.MODULE$.apply(tabName), this.tableDirectoryExists$default$2()), "HiveDDLSuite.this.tableDirectoryExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(tabName), HiveDDLSuite.this.tableDirectoryExists$default$2)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385));
            this.sql().apply((Object)("DROP TABLE IF EXISTS " + tabName));
            this.sql().apply((Object)("DROP VIEW IF EXISTS " + tabName));
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 375));
        this.test("create a hive table without schema", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1 & Serializable)tempDir -> {
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tab1", "tab2"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                Tuple2 tuple2 = new Tuple2((Object)"a", (Object)"b");
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(HiveDDLSuite.class.getClassLoader());
                public final class $typecreator10$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public $typecreator10$1(HiveDDLSuite $outer) {
                    }
                }
                $this.testImplicits().localSeqToDatasetHolder((scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)tuple2), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new $typecreator10$1(null)))).toDF().write().json(tempDir.getCanonicalPath());
                AnalysisException x$1 = (AnalysisException)$this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)"CREATE TABLE tab1 USING hive"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398));
                String x$2 = "_LEGACY_ERROR_TEMP_3083";
                Map x$3 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"`spark_catalog`.`default`.`tab1`")}));
                Option x$4 = $this.checkError$default$3();
                boolean x$5 = $this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$6 = $this.checkError$default$6();
                $this.checkError((SparkThrowable)x$1, "_LEGACY_ERROR_TEMP_3083", x$4, x$3, x$5, x$6);
                AnalysisException x$7 = (AnalysisException)$this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)("CREATE TABLE tab2 USING hive location '" + tempDir.getCanonicalPath() + "'")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 405));
                String x$8 = "_LEGACY_ERROR_TEMP_3083";
                Map x$9 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"`spark_catalog`.`default`.`tab2`")}));
                Option x$10 = $this.checkError$default$3();
                boolean x$11 = $this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$12 = $this.checkError$default$6();
                $this.checkError((SparkThrowable)x$7, "_LEGACY_ERROR_TEMP_3083", x$10, x$9, x$11, x$12);
            });
            return BoxedUnit.UNIT;
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
        this.test("drop external tables in default database", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1 & Serializable)tmpDir -> {
            HiveDDLSuite.$anonfun$new$50(this, tmpDir);
            return BoxedUnit.UNIT;
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
        this.test("drop external data source table in default database", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1 & Serializable)tmpDir -> {
            HiveDDLSuite.$anonfun$new$53(this, tmpDir);
            return BoxedUnit.UNIT;
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439));
        this.test("create table and view with comment", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SessionCatalog catalog = this.spark().sessionState().catalog();
            String tabName = "tab1";
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tabName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + tabName + "(c1 int) COMMENT 'BLABLA'"));
                String viewName = "view1";
                this.withView((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{viewName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    this.sql().apply((Object)("CREATE VIEW " + viewName + " COMMENT 'no comment' AS SELECT * FROM " + tabName));
                    CatalogTable tableMetadata = catalog.getTableMetadata(TableIdentifier$.MODULE$.apply(tabName, (Option)new Some((Object)"default")));
                    CatalogTable viewMetadata = catalog.getTableMetadata(TableIdentifier$.MODULE$.apply(viewName, (Option)new Some((Object)"default")));
                    Option $org_scalatest_assert_macro_left = tableMetadata.comment();
                    Option $org_scalatest_assert_macro_right = Option$.MODULE$.apply((Object)"BLABLA");
                    Option option = $org_scalatest_assert_macro_left;
                    Option option2 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(option2) : option2 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 477));
                    Option $org_scalatest_assert_macro_left2 = viewMetadata.comment();
                    Option $org_scalatest_assert_macro_right2 = Option$.MODULE$.apply((Object)"no comment");
                    Option option3 = $org_scalatest_assert_macro_left2;
                    Option option4 = $org_scalatest_assert_macro_right2;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option3 != null ? !option3.equals(option4) : option4 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 478));
                    Option $org_scalatest_assert_macro_left3 = tableMetadata.properties().get((Object)"comment");
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 480));
                    Option $org_scalatest_assert_macro_left4 = viewMetadata.properties().get((Object)"comment");
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 481));
                });
            });
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 467));
        this.test("create Hive-serde table and view with unicode columns and comment", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SessionCatalog catalog = this.spark().sessionState().catalog();
            String tabName = "tab1";
            String viewName = "view1";
            String colName1 = "\u548c";
            String colName2 = "\u5c3c";
            String comment = "\u5e99";
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tabName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |CREATE TABLE " + tabName + "(`" + colName1 + "` int COMMENT '" + comment + "')\n             |COMMENT '" + comment + "'\n             |PARTITIONED BY (`" + colName2 + "` int)\n           ")));
                this.sql().apply((Object)("INSERT OVERWRITE TABLE " + tabName + " partition (`" + colName2 + "`=2) SELECT 1"));
                this.withView((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{viewName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    Bool bool;
                    Bool bool2;
                    Bool bool3;
                    this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |CREATE VIEW " + viewName + "(`" + colName1 + "` COMMENT '" + comment + "', `" + colName2 + "`)\n             |COMMENT '" + comment + "'\n             |AS SELECT `" + colName1 + "`, `" + colName2 + "` FROM " + tabName + "\n           ")));
                    CatalogTable tableMetadata = catalog.getTableMetadata(TableIdentifier$.MODULE$.apply(tabName, (Option)new Some((Object)"default")));
                    CatalogTable viewMetadata = catalog.getTableMetadata(TableIdentifier$.MODULE$.apply(viewName, (Option)new Some((Object)"default")));
                    Option $org_scalatest_assert_macro_left = tableMetadata.comment();
                    Option $org_scalatest_assert_macro_right = Option$.MODULE$.apply((Object)comment);
                    Option option = $org_scalatest_assert_macro_left;
                    Option option2 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(option2) : option2 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 512));
                    Option $org_scalatest_assert_macro_left2 = viewMetadata.comment();
                    Option $org_scalatest_assert_macro_right2 = Option$.MODULE$.apply((Object)comment);
                    Option option3 = $org_scalatest_assert_macro_left2;
                    Option option4 = $org_scalatest_assert_macro_right2;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option3 != null ? !option3.equals(option4) : option4 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 513));
                    StructField[] $org_scalatest_assert_macro_left3 = tableMetadata.schema().fields();
                    int $org_scalatest_assert_macro_right3 = 2;
                    Bool $org_scalatest_assert_macro_left4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                    if ($org_scalatest_assert_macro_left4.value()) {
                        StructField[] $org_scalatest_assert_macro_left5 = viewMetadata.schema().fields();
                        int $org_scalatest_assert_macro_right4 = 2;
                        bool3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                    } else {
                        bool3 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                    }
                    Bool $org_scalatest_assert_macro_right5 = bool3;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "&&", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left4.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 515));
                    StructField column1InTable = (StructField)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])tableMetadata.schema().fields()));
                    StructField column1InView = (StructField)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])viewMetadata.schema().fields()));
                    String $org_scalatest_assert_macro_left6 = column1InTable.name();
                    String $org_scalatest_assert_macro_right6 = colName1;
                    String string = $org_scalatest_assert_macro_left6;
                    String string2 = $org_scalatest_assert_macro_right6;
                    Bool $org_scalatest_assert_macro_left7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                    if ($org_scalatest_assert_macro_left7.value()) {
                        String $org_scalatest_assert_macro_left8 = column1InView.name();
                        String $org_scalatest_assert_macro_right7 = colName1;
                        String string3 = $org_scalatest_assert_macro_left8;
                        String string4 = $org_scalatest_assert_macro_right7;
                        bool2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right7, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                    } else {
                        bool2 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                    }
                    Bool $org_scalatest_assert_macro_right8 = bool2;
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "&&", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left7.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 518));
                    Option $org_scalatest_assert_macro_left9 = column1InTable.getComment();
                    Option $org_scalatest_assert_macro_right9 = Option$.MODULE$.apply((Object)comment);
                    Option option5 = $org_scalatest_assert_macro_left9;
                    Option option6 = $org_scalatest_assert_macro_right9;
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right9, !(option5 != null ? !option5.equals(option6) : option6 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 519));
                    Option $org_scalatest_assert_macro_left10 = column1InView.getComment();
                    Option $org_scalatest_assert_macro_right10 = Option$.MODULE$.apply((Object)comment);
                    Option option7 = $org_scalatest_assert_macro_left10;
                    Option option8 = $org_scalatest_assert_macro_right10;
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right10, !(option7 != null ? !option7.equals(option8) : option8 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 520));
                    String $org_scalatest_assert_macro_left11 = tableMetadata.schema().fields()[1].name();
                    String $org_scalatest_assert_macro_right11 = colName2;
                    String string5 = $org_scalatest_assert_macro_left11;
                    String string6 = $org_scalatest_assert_macro_right11;
                    Bool $org_scalatest_assert_macro_left12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right11, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
                    if ($org_scalatest_assert_macro_left12.value()) {
                        String $org_scalatest_assert_macro_left13 = viewMetadata.schema().fields()[1].name();
                        String $org_scalatest_assert_macro_right12 = colName2;
                        String string7 = $org_scalatest_assert_macro_left13;
                        String string8 = $org_scalatest_assert_macro_right12;
                        bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right12, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
                    } else {
                        bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                    }
                    Bool $org_scalatest_assert_macro_right13 = bool;
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "&&", (Object)$org_scalatest_assert_macro_right13, $org_scalatest_assert_macro_left12.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right13), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 522));
                    Row row = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)}));
                    this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("SELECT `" + colName1 + "`, `" + colName2 + "` FROM " + tabName)), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row));
                    Row row2 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)}));
                    this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("SELECT `" + colName1 + "`, `" + colName2 + "` FROM " + viewName)), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row2));
                });
            });
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 486));
        this.test("create table: partition column names exist in table definition", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.assertAnalysisErrorCondition("CREATE TABLE tbl(a int) PARTITIONED BY (a string)", "COLUMN_ALREADY_EXISTS", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)"`a`")})))), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 531));
        this.test("create partitioned table without specifying data type for the partition columns", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sql1 = "CREATE TABLE tbl(a int) PARTITIONED BY (b) STORED AS parquet";
            AnalysisException x$13 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)sql1), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 541));
            String x$14 = "COLUMN_NOT_DEFINED_IN_TABLE";
            Map x$15 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colType"), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)"`b`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)("`" + CatalogManager$.MODULE$.SESSION_CATALOG_NAME() + "`.`default`.`tbl`")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableCols"), (Object)"`a`")}));
            Option x$16 = this.checkError$default$3();
            boolean x$17 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$18 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$13, "COLUMN_NOT_DEFINED_IN_TABLE", x$16, x$15, x$17, x$18);
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 538));
        this.test("add/drop partition with location - managed table", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tab = "tab_with_partitions";
            this.withTempDir((Function1 & Serializable)tmpDir -> {
                HiveDDLSuite.$anonfun$new$71(this, tab, tmpDir);
                return BoxedUnit.UNIT;
            });
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 553));
        this.test("SPARK-19129: drop partition with a empty string will drop the whole table", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(HiveDDLSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator21$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator21$1(HiveDDLSuite $outer) {
                }
            }
            org.apache.spark.sql.classic.Dataset df = this.spark().createDataFrame((scala.collection.immutable.Seq)new .colon.colon((Object)new Tuple2((Object)"0", (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)"1", (Object)"b"), (List)Nil$.MODULE$)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator21$1(null))).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"partCol1", "name"}));
            df.write().mode("overwrite").partitionBy((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"partCol1"})).saveAsTable("partitionedTable");
            String sql1 = "alter table partitionedTable drop partition(partCol1='')";
            AnalysisException x$19 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)sql1), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 604));
            String x$20 = "_LEGACY_ERROR_TEMP_1076";
            Map x$21 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"details"), (Object)"The spec ([partCol1=]) contains an empty partition column value")}));
            Option x$22 = this.checkError$default$3();
            boolean x$23 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$24 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$19, "_LEGACY_ERROR_TEMP_1076", x$22, x$21, x$23, x$24);
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 599));
        this.test("add/drop partitions - external table", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SessionCatalog catalog = this.spark().sessionState().catalog();
            this.withTempDir((Function1 & Serializable)tmpDir -> {
                HiveDDLSuite.$anonfun$new$82(this, catalog, tmpDir);
                return BoxedUnit.UNIT;
            });
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 613));
        this.test("drop views", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tab1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tabName = "tab1";
            this.spark().range(10L).write().saveAsTable("tab1");
            this.withView((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"view1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                String viewName = "view1";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.tableDirectoryExists(TableIdentifier$.MODULE$.apply(tabName), this.tableDirectoryExists$default$2()), "HiveDDLSuite.this.tableDirectoryExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(tabName), HiveDDLSuite.this.tableDirectoryExists$default$2)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 701));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.tableDirectoryExists(TableIdentifier$.MODULE$.apply(viewName), this.tableDirectoryExists$default$2()), "HiveDDLSuite.this.tableDirectoryExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(viewName), HiveDDLSuite.this.tableDirectoryExists$default$2)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 702));
                this.sql().apply((Object)("CREATE VIEW " + viewName + " AS SELECT * FROM tab1"));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.tableDirectoryExists(TableIdentifier$.MODULE$.apply(tabName), this.tableDirectoryExists$default$2()), "HiveDDLSuite.this.tableDirectoryExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(tabName), HiveDDLSuite.this.tableDirectoryExists$default$2)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 705));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.tableDirectoryExists(TableIdentifier$.MODULE$.apply(viewName), this.tableDirectoryExists$default$2()), "HiveDDLSuite.this.tableDirectoryExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(viewName), HiveDDLSuite.this.tableDirectoryExists$default$2)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 706));
                this.sql().apply((Object)("DROP VIEW " + viewName));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(this.tableDirectoryExists(TableIdentifier$.MODULE$.apply(tabName), this.tableDirectoryExists$default$2()), "HiveDDLSuite.this.tableDirectoryExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(tabName), HiveDDLSuite.this.tableDirectoryExists$default$2)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 709));
                this.sql().apply((Object)("DROP VIEW IF EXISTS " + viewName));
            });
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 694));
        this.test("alter views - rename", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tabName = "tab1";
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tabName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.spark().range(10L).write().saveAsTable(tabName);
                String oldViewName = "view1";
                String newViewName = "view2";
                this.withView((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{oldViewName, newViewName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    SessionCatalog catalog = this.spark().sessionState().catalog();
                    this.sql().apply((Object)("CREATE VIEW " + oldViewName + " AS SELECT * FROM " + tabName));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(TableIdentifier$.MODULE$.apply(oldViewName)), "catalog.tableExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(oldViewName))", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 725));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(TableIdentifier$.MODULE$.apply(newViewName)), "catalog.tableExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(newViewName))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 726));
                    this.sql().apply((Object)("ALTER VIEW " + oldViewName + " RENAME TO " + newViewName));
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(TableIdentifier$.MODULE$.apply(oldViewName)), "catalog.tableExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(oldViewName))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 728));
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(TableIdentifier$.MODULE$.apply(newViewName)), "catalog.tableExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(newViewName))", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 729));
                });
            });
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 715));
        this.test("alter views - set/unset tblproperties", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tabName = "tab1";
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tabName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.spark().range(10L).write().saveAsTable(tabName);
                String viewName = "view1";
                this.withView((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{viewName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    this.sql().apply((Object)("CREATE VIEW " + viewName + " AS SELECT * FROM " + tabName));
                    this.checkProperties$1((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$), viewName);
                    this.sql().apply((Object)("ALTER VIEW " + viewName + " SET TBLPROPERTIES ('p' = 'an')"));
                    this.checkProperties$1((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p"), (Object)"an")})), viewName);
                    this.sql().apply((Object)("ALTER VIEW " + viewName + " SET TBLPROPERTIES ('p' = 'an')"));
                    this.checkProperties$1((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p"), (Object)"an")})), viewName);
                    this.sql().apply((Object)("ALTER VIEW " + viewName + " SET TBLPROPERTIES ('p' = 'b')"));
                    this.checkProperties$1((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p"), (Object)"b")})), viewName);
                    this.sql().apply((Object)("ALTER VIEW " + viewName + " UNSET TBLPROPERTIES ('p')"));
                    this.checkProperties$1((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$), viewName);
                    this.sql().apply((Object)("ALTER VIEW " + viewName + " UNSET TBLPROPERTIES ('p')"));
                    this.checkProperties$1((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$), viewName);
                });
            });
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 734));
        this.test("create table - SET TBLPROPERTIES EXTERNAL to TRUE", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tabName = "tab1";
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tabName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                AnalysisException x$31 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("CREATE TABLE " + tabName + " (height INT, length INT) TBLPROPERTIES('EXTERNAL'='TRUE')")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 784));
                String x$32 = "_LEGACY_ERROR_TEMP_3087";
                Map x$33 = Predef$.MODULE$.Map().empty();
                Option x$34 = this.checkError$default$3();
                boolean x$35 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$36 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$31, "_LEGACY_ERROR_TEMP_3087", x$34, x$33, x$35, x$36);
            });
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 780));
        this.test("alter table - SET TBLPROPERTIES EXTERNAL to TRUE", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tabName = "tab1";
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tabName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                SessionCatalog catalog = this.spark().sessionState().catalog();
                this.sql().apply((Object)("CREATE TABLE " + tabName + " (height INT, length INT)"));
                CatalogTableType $org_scalatest_assert_macro_left = catalog.getTableMetadata(TableIdentifier$.MODULE$.apply(tabName)).tableType();
                CatalogTableType $org_scalatest_assert_macro_right = CatalogTableType$.MODULE$.MANAGED();
                CatalogTableType catalogTableType = $org_scalatest_assert_macro_left;
                CatalogTableType catalogTableType2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 799));
                AnalysisException x$37 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("ALTER TABLE " + tabName + " SET TBLPROPERTIES ('EXTERNAL' = 'TRUE')")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 802));
                String x$38 = "_LEGACY_ERROR_TEMP_3087";
                Map x$39 = Predef$.MODULE$.Map().empty();
                Option x$40 = this.checkError$default$3();
                boolean x$41 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$42 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$37, "_LEGACY_ERROR_TEMP_3087", x$40, x$39, x$41, x$42);
                CatalogTableType $org_scalatest_assert_macro_left2 = catalog.getTableMetadata(TableIdentifier$.MODULE$.apply(tabName)).tableType();
                CatalogTableType $org_scalatest_assert_macro_right2 = CatalogTableType$.MODULE$.MANAGED();
                CatalogTableType catalogTableType3 = $org_scalatest_assert_macro_left2;
                CatalogTableType catalogTableType4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(catalogTableType3 != null ? !catalogTableType3.equals(catalogTableType4) : catalogTableType4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 809));
                this.sql().apply((Object)("ALTER TABLE " + tabName + " SET TBLPROPERTIES ('External' = 'TRUE')"));
                CatalogTableType $org_scalatest_assert_macro_left3 = catalog.getTableMetadata(TableIdentifier$.MODULE$.apply(tabName)).tableType();
                CatalogTableType $org_scalatest_assert_macro_right3 = CatalogTableType$.MODULE$.MANAGED();
                CatalogTableType catalogTableType5 = $org_scalatest_assert_macro_left3;
                CatalogTableType catalogTableType6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(catalogTableType5 != null ? !catalogTableType5.equals(catalogTableType6) : catalogTableType6 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 814));
            });
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 794));
        this.test("alter views and alter table - misuse", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tabName = "tab1";
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tabName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.spark().range(10L).write().saveAsTable(tabName);
                String oldViewName = "view1";
                String newViewName = "view2";
                this.withView((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{oldViewName, newViewName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    SessionCatalog catalog = this.spark().sessionState().catalog();
                    this.sql().apply((Object)("CREATE VIEW " + oldViewName + " AS SELECT * FROM " + tabName));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(TableIdentifier$.MODULE$.apply(tabName)), "catalog.tableExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(tabName))", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 829));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(TableIdentifier$.MODULE$.apply(oldViewName)), "catalog.tableExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(oldViewName))", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 830));
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(TableIdentifier$.MODULE$.apply(newViewName)), "catalog.tableExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(newViewName))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 831));
                    AnalysisException x$43 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("ALTER VIEW " + tabName + " RENAME TO " + newViewName)), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 834));
                    String x$44 = "EXPECT_VIEW_NOT_TABLE.USE_ALTER_TABLE";
                    Map x$45 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"ALTER VIEW"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"`tab1`")}));
                    Option x$46 = this.checkError$default$3();
                    boolean x$47 = this.checkError$default$5();
                    SparkFunSuite.ExpectedContext[] x$48 = this.checkError$default$6();
                    this.checkError((SparkThrowable)x$43, "EXPECT_VIEW_NOT_TABLE.USE_ALTER_TABLE", x$46, x$45, x$47, x$48);
                    AnalysisException x$49 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("ALTER TABLE " + oldViewName + " RENAME TO " + newViewName)), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
                    String x$50 = "EXPECT_TABLE_NOT_VIEW.USE_ALTER_VIEW";
                    Map x$51 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"ALTER TABLE"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)"`view1`")}));
                    Option x$52 = this.checkError$default$3();
                    boolean x$53 = this.checkError$default$5();
                    SparkFunSuite.ExpectedContext[] x$54 = this.checkError$default$6();
                    this.checkError((SparkThrowable)x$49, "EXPECT_TABLE_NOT_VIEW.USE_ALTER_VIEW", x$52, x$51, x$53, x$54);
                    this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("ALTER VIEW " + tabName + " SET TBLPROPERTIES ('p' = 'an')")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 850)), "EXPECT_VIEW_NOT_TABLE.USE_ALTER_TABLE", (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)("`" + CatalogManager$.MODULE$.SESSION_CATALOG_NAME() + "`.`default`.`" + tabName + "`")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"ALTER VIEW ... SET TBLPROPERTIES")})), this.ExpectedContext().apply(tabName, 11, 14));
                    this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("ALTER TABLE " + oldViewName + " SET TBLPROPERTIES ('p' = 'an')")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 861)), "EXPECT_TABLE_NOT_VIEW.USE_ALTER_VIEW", (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)("`" + CatalogManager$.MODULE$.SESSION_CATALOG_NAME() + "`.`default`.`" + oldViewName + "`")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"ALTER TABLE ... SET TBLPROPERTIES")})), this.ExpectedContext().apply(oldViewName, 12, 16));
                    this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("ALTER VIEW " + tabName + " UNSET TBLPROPERTIES ('p')")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 872)), "EXPECT_VIEW_NOT_TABLE.USE_ALTER_TABLE", (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)("`" + CatalogManager$.MODULE$.SESSION_CATALOG_NAME() + "`.`default`.`" + tabName + "`")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"ALTER VIEW ... UNSET TBLPROPERTIES")})), this.ExpectedContext().apply(tabName, 11, 14));
                    this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("ALTER TABLE " + oldViewName + " UNSET TBLPROPERTIES ('p')")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 883)), "EXPECT_TABLE_NOT_VIEW.USE_ALTER_VIEW", (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)("`" + CatalogManager$.MODULE$.SESSION_CATALOG_NAME() + "`.`default`.`" + oldViewName + "`")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"ALTER TABLE ... UNSET TBLPROPERTIES")})), this.ExpectedContext().apply(oldViewName, 12, 16));
                    this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("ALTER TABLE " + oldViewName + " SET LOCATION '/path/to/home'")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 894)), "EXPECT_TABLE_NOT_VIEW.NO_ALTERNATIVE", (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)("`" + CatalogManager$.MODULE$.SESSION_CATALOG_NAME() + "`.`default`.`" + oldViewName + "`")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"ALTER TABLE ... SET LOCATION ...")})), this.ExpectedContext().apply(oldViewName, 12, 16));
                    this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("ALTER TABLE " + oldViewName + " SET SERDE 'whatever'")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 905)), "EXPECT_TABLE_NOT_VIEW.USE_ALTER_VIEW", (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)("`" + CatalogManager$.MODULE$.SESSION_CATALOG_NAME() + "`.`default`.`" + oldViewName + "`")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"ALTER TABLE ... SET [SERDE|SERDEPROPERTIES]")})), this.ExpectedContext().apply(oldViewName, 12, 16));
                    this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("ALTER TABLE " + oldViewName + " SET SERDEPROPERTIES ('x' = 'y')")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 916)), "EXPECT_TABLE_NOT_VIEW.USE_ALTER_VIEW", (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)("`" + CatalogManager$.MODULE$.SESSION_CATALOG_NAME() + "`.`default`.`" + oldViewName + "`")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"ALTER TABLE ... SET [SERDE|SERDEPROPERTIES]")})), this.ExpectedContext().apply(oldViewName, 12, 16));
                    this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("ALTER TABLE " + oldViewName + " PARTITION (a=1, b=2) SET SERDEPROPERTIES ('x' = 'y')")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 927)), "EXPECT_TABLE_NOT_VIEW.USE_ALTER_VIEW", (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)("`" + CatalogManager$.MODULE$.SESSION_CATALOG_NAME() + "`.`default`.`" + oldViewName + "`")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"ALTER TABLE ... SET [SERDE|SERDEPROPERTIES]")})), this.ExpectedContext().apply(oldViewName, 12, 16));
                    this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("ALTER TABLE " + oldViewName + " RECOVER PARTITIONS")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 938)), "EXPECT_TABLE_NOT_VIEW.NO_ALTERNATIVE", (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)("`" + CatalogManager$.MODULE$.SESSION_CATALOG_NAME() + "`.`default`.`" + oldViewName + "`")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"ALTER TABLE ... RECOVER PARTITIONS")})), this.ExpectedContext().apply(oldViewName, 12, 16));
                    this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("ALTER TABLE " + oldViewName + " PARTITION (a='1') RENAME TO PARTITION (a='100')")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 949)), "EXPECT_TABLE_NOT_VIEW.NO_ALTERNATIVE", (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)("`" + CatalogManager$.MODULE$.SESSION_CATALOG_NAME() + "`.`default`.`" + oldViewName + "`")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"ALTER TABLE ... RENAME TO PARTITION")})), this.ExpectedContext().apply(oldViewName, 12, 16));
                    this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("ALTER TABLE " + oldViewName + " ADD IF NOT EXISTS PARTITION (a='4', b='8')")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 960)), "EXPECT_TABLE_NOT_VIEW.NO_ALTERNATIVE", (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)("`" + CatalogManager$.MODULE$.SESSION_CATALOG_NAME() + "`.`default`.`" + oldViewName + "`")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"ALTER TABLE ... ADD PARTITION ...")})), this.ExpectedContext().apply(oldViewName, 12, 16));
                    this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("ALTER TABLE " + oldViewName + " DROP IF EXISTS PARTITION (a='2')")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 971)), "EXPECT_TABLE_NOT_VIEW.NO_ALTERNATIVE", (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)("`" + CatalogManager$.MODULE$.SESSION_CATALOG_NAME() + "`.`default`.`" + oldViewName + "`")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"ALTER TABLE ... DROP PARTITION ...")})), this.ExpectedContext().apply(oldViewName, 12, 16));
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(TableIdentifier$.MODULE$.apply(tabName)), "catalog.tableExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(tabName))", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 981));
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(TableIdentifier$.MODULE$.apply(oldViewName)), "catalog.tableExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(oldViewName))", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 982));
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(TableIdentifier$.MODULE$.apply(newViewName)), "catalog.tableExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(newViewName))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 983));
                });
            });
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 819));
        this.test("Insert overwrite Hive table should output correct schema", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_PARQUET().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tbl", "tbl2"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withView((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"view1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().sql("CREATE TABLE tbl(id long)");
            this.spark().sql("INSERT OVERWRITE TABLE tbl VALUES 4");
            this.spark().sql("CREATE VIEW view1 AS SELECT id FROM tbl");
            this.withTempPath((Function1 & Serializable)path -> {
                HiveDDLSuite.$anonfun$new$131(this, path);
                return BoxedUnit.UNIT;
            });
        }))), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 988));
        this.test("Create Hive table as select should output correct schema", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_PARQUET().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tbl", "tbl2"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withView((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"view1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().sql("CREATE TABLE tbl(id long)");
            this.spark().sql("INSERT OVERWRITE TABLE tbl VALUES 4");
            this.spark().sql("CREATE VIEW view1 AS SELECT id FROM tbl");
            this.withTempPath((Function1 & Serializable)path -> {
                HiveDDLSuite.$anonfun$new$137(this, path);
                return BoxedUnit.UNIT;
            });
        }))), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1012));
        this.test("SPARK-25313 Insert overwrite directory should output correct schema", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_PARQUET().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withView((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"view1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().sql("CREATE TABLE tbl(id long)");
            this.spark().sql("INSERT OVERWRITE TABLE tbl VALUES 4");
            this.spark().sql("CREATE VIEW view1 AS SELECT id FROM tbl");
            this.withTempPath((Function1 & Serializable)path -> {
                HiveDDLSuite.$anonfun$new$143(this, path);
                return BoxedUnit.UNIT;
            });
        }))), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1036));
        this.test("alter table partition - storage information", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE boxes (height INT, length INT) STORED AS textfile PARTITIONED BY (width INT)");
            this.sql().apply((Object)"INSERT OVERWRITE TABLE boxes PARTITION (width=4) SELECT 4, 4");
            SessionCatalog catalog = this.spark().sessionState().catalog();
            String expectedSerde = "com.sparkbricks.serde.ColumnarSerDe";
            Map expectedSerdeProps = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compress"), (Object)"true")}));
            String expectedSerdePropsString = ((IterableOnceOps)expectedSerdeProps.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    return "'" + k + "'='" + v + "'";
                }
                throw new MatchError((Object)tuple2);
            })).mkString(", ");
            CatalogTablePartition oldPart = catalog.getPartition(TableIdentifier$.MODULE$.apply("boxes"), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"width"), (Object)"4")})));
            Option $org_scalatest_assert_macro_left = oldPart.storage().serde();
            Some $org_scalatest_assert_macro_right = new Some((Object)expectedSerde);
            Option option = $org_scalatest_assert_macro_left;
            Some some = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, option == null ? some != null : !option.equals(some), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"bad test: serde was already set", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1064));
            Map $org_scalatest_assert_macro_left2 = (Map)oldPart.storage().properties().filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)HiveDDLSuite.$anonfun$new$147(expectedSerdeProps, x0$2)));
            Map $org_scalatest_assert_macro_right2 = expectedSerdeProps;
            Map map = $org_scalatest_assert_macro_left2;
            Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!=", (Object)$org_scalatest_assert_macro_right2, map == null ? map2 != null : !map.equals(map2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"bad test: serde properties were already set", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1065));
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("ALTER TABLE boxes PARTITION (width=4)\n      |    SET SERDE '" + expectedSerde + "'\n      |    WITH SERDEPROPERTIES (" + expectedSerdePropsString + ")\n      |")));
            CatalogTablePartition newPart = catalog.getPartition(TableIdentifier$.MODULE$.apply("boxes"), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"width"), (Object)"4")})));
            Option $org_scalatest_assert_macro_left3 = newPart.storage().serde();
            Some $org_scalatest_assert_macro_right3 = new Some((Object)expectedSerde);
            Option option2 = $org_scalatest_assert_macro_left3;
            Some some2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1072));
            Map $org_scalatest_assert_macro_left4 = (Map)newPart.storage().properties().filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)HiveDDLSuite.$anonfun$new$148(expectedSerdeProps, x0$3)));
            Map $org_scalatest_assert_macro_right4 = expectedSerdeProps;
            Map map3 = $org_scalatest_assert_macro_left4;
            Map map4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(map3 != null ? !map3.equals(map4) : map4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1073));
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1055));
        this.test("MSCK REPAIR RABLE", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Assertion assertion;
            SessionCatalog catalog = this.spark().sessionState().catalog();
            TableIdentifier tableIdent = TableIdentifier$.MODULE$.apply("tab1");
            this.sql().apply((Object)"CREATE TABLE tab1 (height INT, length INT) PARTITIONED BY (a INT, b INT)");
            Map part1 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"5")}));
            Map part2 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"6")}));
            Path root = new Path(catalog.getTableMetadata(tableIdent).location());
            FileSystem fs = root.getFileSystem(this.spark().sessionState().newHadoopConf());
            fs.mkdirs(new Path(new Path(root, "a=1"), "b=5"));
            fs.createNewFile(new Path(new Path(root, "a=1/b=5"), "a.csv"));
            fs.createNewFile(new Path(new Path(root, "a=1/b=5"), "_SUCCESS"));
            fs.mkdirs(new Path(new Path(root, "A=2"), "B=6"));
            fs.createNewFile(new Path(new Path(root, "A=2/B=6"), "b.csv"));
            fs.createNewFile(new Path(new Path(root, "A=2/B=6"), "c.csv"));
            fs.createNewFile(new Path(new Path(root, "A=2/B=6"), ".hiddenFile"));
            fs.mkdirs(new Path(new Path(root, "A=2/B=6"), "_temporary"));
            fs.mkdirs(new Path(new Path(root, "a"), "b"));
            fs.mkdirs(new Path(new Path(root, "b=1"), "a=1"));
            fs.mkdirs(new Path(root, "a=4"));
            fs.createNewFile(new Path(new Path(root, "a=1"), "b=4"));
            fs.createNewFile(new Path(new Path(root, "a=1"), "_SUCCESS"));
            fs.mkdirs(new Path(new Path(root, "a=1"), "_temporary"));
            fs.mkdirs(new Path(new Path(root, "a=1"), ".b=4"));
            try {
                this.sql().apply((Object)"MSCK REPAIR TABLE tab1");
                Set $org_scalatest_assert_macro_left = ((IterableOnceOps)catalog.listPartitions(tableIdent, catalog.listPartitions$default$2()).map((Function1 & Serializable)x$4 -> x$4.spec())).toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{part1, part2}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1106));
                String $org_scalatest_assert_macro_left2 = (String)catalog.getPartition(tableIdent, part1).parameters().apply((Object)"numFiles");
                String $org_scalatest_assert_macro_right2 = "1";
                String string = $org_scalatest_assert_macro_left2;
                String string2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1108));
                String $org_scalatest_assert_macro_left3 = (String)catalog.getPartition(tableIdent, part2).parameters().apply((Object)"numFiles");
                String $org_scalatest_assert_macro_right3 = "2";
                String string3 = $org_scalatest_assert_macro_left3;
                String string4 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1109));
            }
            finally {
                fs.delete(root, true);
            }
            return assertion;
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1077));
        this.test("drop table using drop view", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tab1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE tab1(c1 int)");
            this.assertAnalysisErrorCondition("DROP VIEW tab1", "WRONG_COMMAND_FOR_OBJECT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"alternative"), (Object)"DROP TABLE"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"DROP VIEW"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foundType"), (Object)"MANAGED"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)"VIEW"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)(CatalogManager$.MODULE$.SESSION_CATALOG_NAME() + ".default.tab1"))}))));
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1115));
        this.test("drop view using drop table", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tab1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().range(10L).write().saveAsTable("tab1");
            this.withView((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"view1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)"CREATE VIEW view1 AS SELECT * FROM tab1");
                this.assertAnalysisErrorCondition("DROP TABLE view1", "WRONG_COMMAND_FOR_OBJECT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"alternative"), (Object)"DROP VIEW"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"DROP TABLE"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foundType"), (Object)"VIEW"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)"EXTERNAL or MANAGED"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)"spark_catalog.default.view1")}))));
            });
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1132));
        this.test("create view with mismatched schema", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tab1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.spark().range(10L).write().saveAsTable("tab1");
                this.withView((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"view1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    AnalysisException x$55 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"CREATE VIEW view1 (col1, col3) AS SELECT * FROM tab1"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1157));
                    String x$56 = "CREATE_VIEW_COLUMN_ARITY_MISMATCH.NOT_ENOUGH_DATA_COLUMNS";
                    Map x$57 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)("`" + CatalogManager$.MODULE$.SESSION_CATALOG_NAME() + "`.`default`.`view1`")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewColumns"), (Object)"`col1`, `col3`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataColumns"), (Object)"`id`")}));
                    Option x$58 = this.checkError$default$3();
                    boolean x$59 = this.checkError$default$5();
                    SparkFunSuite.ExpectedContext[] x$60 = this.checkError$default$6();
                    this.checkError((SparkThrowable)x$55, "CREATE_VIEW_COLUMN_ARITY_MISMATCH.NOT_ENOUGH_DATA_COLUMNS", x$58, x$57, x$59, x$60);
                });
            });
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tab2"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(HiveDDLSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator31$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                    }

                    public Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator31$1(HiveDDLSuite $outer) {
                    }
                }
                this.testImplicits().localSeqToDatasetHolder((scala.collection.immutable.Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)3)), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator31$1(null)))).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1", "col2", "col3"})).write().saveAsTable("tab2");
                this.withView((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"view2"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    AnalysisException x$61 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"CREATE VIEW view2 (col1, col3) AS SELECT * FROM tab2"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1173));
                    String x$62 = "CREATE_VIEW_COLUMN_ARITY_MISMATCH.TOO_MANY_DATA_COLUMNS";
                    Map x$63 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)("`" + CatalogManager$.MODULE$.SESSION_CATALOG_NAME() + "`.`default`.`view2`")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewColumns"), (Object)"`col1`, `col3`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataColumns"), (Object)"`col1`, `col2`, `col3`")}));
                    Option x$64 = this.checkError$default$3();
                    boolean x$65 = this.checkError$default$5();
                    SparkFunSuite.ExpectedContext[] x$66 = this.checkError$default$6();
                    this.checkError((SparkThrowable)x$61, "CREATE_VIEW_COLUMN_ARITY_MISMATCH.TOO_MANY_DATA_COLUMNS", x$64, x$63, x$65, x$66);
                });
            });
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1152));
        this.test("create view with specified schema", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withView((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"view1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)"CREATE VIEW view1 (col1, col2) AS SELECT 1, 2");
            Row row = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)}));
            this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"SELECT * FROM view1"), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row));
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1187));
        this.test("desc table for Hive table - partitioned table", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE tbl(a int) PARTITIONED BY (b int)");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapRefArray((Object[])((org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"DESC tbl")).collect()).containsSlice((Seq)new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a", "int", null})), (List)new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"b", "int", null})), (List)new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"# Partition Information", "", ""})), (List)new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"# col_name", "data_type", "comment"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"b", "int", null})), (List)Nil$.MODULE$)))))), "scala.Predef.wrapRefArray[org.apache.spark.sql.Row](HiveDDLSuite.this.sql.apply(\"DESC tbl\").collect()).containsSlice[org.apache.spark.sql.Row](scala.`package`.Seq.apply[org.apache.spark.sql.Row](org.apache.spark.sql.Row.apply(\"a\", \"int\", null), org.apache.spark.sql.Row.apply(\"b\", \"int\", null), org.apache.spark.sql.Row.apply(\"# Partition Information\", \"\", \"\"), org.apache.spark.sql.Row.apply(\"# col_name\", \"data_type\", \"comment\"), org.apache.spark.sql.Row.apply(\"b\", \"int\", null)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1201));
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1197));
        this.test("desc table for Hive table - bucketed + sorted table", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |CREATE TABLE tbl (id int, name string)\n          |CLUSTERED BY(id)\n          |SORTED BY(id, name) INTO 1024 BUCKETS\n          |PARTITIONED BY (ds string)\n        ")));
            Row[] x = (Row[])((org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"DESC FORMATTED tbl")).collect();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapRefArray((Object[])x).containsSlice((Seq)new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"Num Buckets", "1024", ""})), (List)new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"Bucket Columns", "[`id`]", ""})), (List)new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"Sort Columns", "[`id`, `name`]", ""})), (List)Nil$.MODULE$)))), "scala.Predef.wrapRefArray[org.apache.spark.sql.Row](x).containsSlice[org.apache.spark.sql.Row](scala.`package`.Seq.apply[org.apache.spark.sql.Row](org.apache.spark.sql.Row.apply(\"Num Buckets\", \"1024\", \"\"), org.apache.spark.sql.Row.apply(\"Bucket Columns\", \"[`id`]\", \"\"), org.apache.spark.sql.Row.apply(\"Sort Columns\", \"[`id`, `name`]\", \"\")))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1224));
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1213));
        this.test("desc table for data source table using Hive Metastore", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String $org_scalatest_assert_macro_left = (String)this.spark().sparkContext().conf().get(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION());
            String $org_scalatest_assert_macro_right = "hive";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1235));
            String tabName = "tab1";
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tabName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE " + tabName + "(a int comment 'test') USING parquet "));
                Row row = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a", "int", "test"}));
                this.checkAnswer((Function0 & Serializable)() -> ((org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("DESC " + tabName))).select("col_name", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"data_type", "comment"})), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row));
            });
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1234));
        this.test("create/drop database - location without pre-created directory", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1 & Serializable)tmpDir -> {
            this.createDatabaseWithLocation(tmpDir, false);
            return BoxedUnit.UNIT;
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1278));
        this.test("create/drop database - location with pre-created directory", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1 & Serializable)tmpDir -> {
            this.createDatabaseWithLocation(tmpDir, true);
            return BoxedUnit.UNIT;
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1284));
        this.test("drop database containing tables - CASCADE", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.dropDatabase(true, true), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1336));
        this.test("drop an empty database - CASCADE", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.dropDatabase(true, false), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1340));
        this.test("drop database containing tables - RESTRICT", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.dropDatabase(false, true), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1344));
        this.test("drop an empty database - RESTRICT", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.dropDatabase(false, false), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1348));
        this.test("drop default database", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"true", (List)new .colon.colon((Object)"false", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)caseSensitive -> {
            this.withSQLConf((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)caseSensitive)}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                Map map;
                String x$74;
                AnalysisException x$73;
                block7: {
                    String string;
                    block6: {
                        AnalysisException x$67 = (AnalysisException)$this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)"DROP DATABASE default"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1356));
                        String x$68 = "UNSUPPORTED_FEATURE.DROP_DATABASE";
                        Map x$69 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"database"), (Object)"`spark_catalog`.`default`")}));
                        Option x$70 = $this.checkError$default$3();
                        boolean x$71 = $this.checkError$default$5();
                        SparkFunSuite.ExpectedContext[] x$72 = $this.checkError$default$6();
                        $this.checkError((SparkThrowable)x$67, "UNSUPPORTED_FEATURE.DROP_DATABASE", x$70, x$69, x$71, x$72);
                        x$73 = (AnalysisException)$this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)"DROP DATABASE DeFault"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1366));
                        String string2 = caseSensitive;
                        switch (string2 == null ? 0 : string2.hashCode()) {
                            case 97196323: {
                                if (!"false".equals(string2)) break;
                                string = "UNSUPPORTED_FEATURE.DROP_DATABASE";
                                break block6;
                            }
                        }
                        string = "_LEGACY_ERROR_TEMP_3065";
                    }
                    x$74 = string;
                    String string3 = caseSensitive;
                    switch (string3 == null ? 0 : string3.hashCode()) {
                        case 97196323: {
                            if (!"false".equals(string3)) break;
                            map = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"database"), (Object)"`spark_catalog`.`default`")}));
                            break block7;
                        }
                    }
                    map = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clazz"), (Object)"org.apache.hadoop.hive.ql.metadata.HiveException"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)"MetaException(message:Can not drop default database)")}));
                }
                Map x$75 = map;
                Option x$76 = $this.checkError$default$3();
                boolean x$77 = $this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$78 = $this.checkError$default$6();
                $this.checkError((SparkThrowable)x$73, x$74, x$76, x$75, x$77, x$78);
            });
            return BoxedUnit.UNIT;
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1352));
        this.test("Create Cataloged Table As Select - Drop Table After Runtime Exception", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tab"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n            |CREATE TABLE tab\n            |STORED AS TEXTFILE\n            |SELECT 1 AS a, (SELECT a FROM (SELECT 1 AS a UNION ALL SELECT 2 AS a) t) AS b\n          "))), ClassTag$.MODULE$.apply(SparkException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1386));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.spark().sessionState().catalog().tableExists(TableIdentifier$.MODULE$.apply("tab")), "HiveDDLSuite.this.spark.sessionState.catalog.tableExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(\"tab\"))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1395));
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1384));
        this.test("CREATE TABLE LIKE a temporary view", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)None$.MODULE$, (List)new .colon.colon((Object)new Some((Object)"parquet"), (List)new .colon.colon((Object)new Some((Object)"orc"), (List)new .colon.colon((Object)new Some((Object)"hive"), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)provider -> {
            HiveDDLSuite.$anonfun$new$190(this, provider);
            return BoxedUnit.UNIT;
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1399));
        this.test("CREATE TABLE LIKE a data source table", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)None$.MODULE$, (List)new .colon.colon((Object)new Some((Object)"parquet"), (List)new .colon.colon((Object)new Some((Object)"orc"), (List)new .colon.colon((Object)new Some((Object)"hive"), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)provider -> {
            HiveDDLSuite.$anonfun$new$193(this, provider);
            return BoxedUnit.UNIT;
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1434));
        this.test("CREATE TABLE LIKE an external data source table", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)None$.MODULE$, (List)new .colon.colon((Object)new Some((Object)"parquet"), (List)new .colon.colon((Object)new Some((Object)"orc"), (List)new .colon.colon((Object)new Some((Object)"hive"), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)provider -> {
            HiveDDLSuite.$anonfun$new$196(this, provider);
            return BoxedUnit.UNIT;
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1472));
        this.test("CREATE TABLE LIKE a managed Hive serde table", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)None$.MODULE$, (List)new .colon.colon((Object)new Some((Object)"parquet"), (List)new .colon.colon((Object)new Some((Object)"orc"), (List)new .colon.colon((Object)new Some((Object)"hive"), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)provider -> {
            HiveDDLSuite.$anonfun$new$199(this, provider);
            return BoxedUnit.UNIT;
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1513));
        this.test("CREATE TABLE LIKE an external Hive serde table", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)None$.MODULE$, (List)new .colon.colon((Object)new Some((Object)"parquet"), (List)new .colon.colon((Object)new Some((Object)"orc"), (List)new .colon.colon((Object)new Some((Object)"hive"), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)provider -> {
            HiveDDLSuite.$anonfun$new$202(this, provider);
            return BoxedUnit.UNIT;
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1548));
        this.test("CREATE TABLE LIKE a view", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)None$.MODULE$, (List)new .colon.colon((Object)new Some((Object)"parquet"), (List)new .colon.colon((Object)new Some((Object)"orc"), (List)new .colon.colon((Object)new Some((Object)"hive"), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)provider -> {
            HiveDDLSuite.$anonfun$new$205(this, provider);
            return BoxedUnit.UNIT;
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1601));
        this.test("create table with the same name as an index table", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tabName = "tab1";
            String indexName = tabName + "_index";
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tabName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                HiveClient client = ((HiveExternalCatalog)this.spark().sharedState().externalCatalog().unwrapped()).client();
                this.sql().apply((Object)("CREATE TABLE " + tabName + "(a int)"));
                try {
                    client.runSqlHive("CREATE INDEX " + indexName + " ON TABLE " + tabName + " (a) AS 'COMPACT' WITH DEFERRED REBUILD");
                    String indexTabName = ((TableIdentifier)this.spark().sessionState().catalog().listTables("default", "*" + indexName + "*").head()).table();
                    Row row = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{indexTabName, "spark_catalog", new String[]{"default"}, null, null, BoxesRunTime.boxToBoolean((boolean)false)}));
                    Row row2 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{tabName, "spark_catalog", new String[]{"default"}, null, "MANAGED", BoxesRunTime.boxToBoolean((boolean)false)}));
                    this.checkAnswer((Function0 & Serializable)() -> this.spark().catalog().listTables().toDF(), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
                    AnalysisException x$79 = (AnalysisException)this.intercept((Function0 & Serializable)() -> this.spark().catalog().getTable("default", indexTabName), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1762));
                    String x$80 = "UNSUPPORTED_FEATURE.HIVE_TABLE_TYPE";
                    Map x$81 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)("`" + indexTabName + "`")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableType"), (Object)"index table")}));
                    Option x$82 = this.checkError$default$3();
                    boolean x$83 = this.checkError$default$5();
                    SparkFunSuite.ExpectedContext[] x$84 = this.checkError$default$6();
                    this.checkError((SparkThrowable)x$79, "UNSUPPORTED_FEATURE.HIVE_TABLE_TYPE", x$82, x$81, x$83, x$84);
                    TableAlreadyExistsException x$85 = (TableAlreadyExistsException)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("CREATE TABLE " + indexTabName + "(b int) USING hive")), ClassTag$.MODULE$.apply(TableAlreadyExistsException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1772));
                    String x$86 = "TABLE_OR_VIEW_ALREADY_EXISTS";
                    Map x$87 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)("`default`.`" + indexTabName + "`"))}));
                    Option x$88 = this.checkError$default$3();
                    boolean x$89 = this.checkError$default$5();
                    SparkFunSuite.ExpectedContext[] x$90 = this.checkError$default$6();
                    this.checkError((SparkThrowable)x$85, "TABLE_OR_VIEW_ALREADY_EXISTS", x$88, x$87, x$89, x$90);
                    TableAlreadyExistsException x$91 = (TableAlreadyExistsException)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("ALTER TABLE " + tabName + " RENAME TO " + indexTabName)), ClassTag$.MODULE$.apply(TableAlreadyExistsException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1780));
                    String x$92 = "TABLE_OR_VIEW_ALREADY_EXISTS";
                    Map x$93 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)("`default`.`" + indexTabName + "`"))}));
                    Option x$94 = this.checkError$default$3();
                    boolean x$95 = this.checkError$default$5();
                    SparkFunSuite.ExpectedContext[] x$96 = this.checkError$default$6();
                    this.checkError((SparkThrowable)x$91, "TABLE_OR_VIEW_ALREADY_EXISTS", x$94, x$93, x$95, x$96);
                    AnalysisException x$97 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("DESCRIBE " + indexTabName)), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1789));
                    String x$98 = "UNSUPPORTED_FEATURE.HIVE_TABLE_TYPE";
                    Map x$99 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)("`" + indexTabName + "`")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableType"), (Object)"index table")}));
                    Option x$100 = this.checkError$default$3();
                    boolean x$101 = this.checkError$default$5();
                    SparkFunSuite.ExpectedContext[] x$102 = this.checkError$default$6();
                    this.checkError((SparkThrowable)x$97, "UNSUPPORTED_FEATURE.HIVE_TABLE_TYPE", x$100, x$99, x$101, x$102);
                }
                finally {
                    client.runSqlHive("DROP INDEX IF EXISTS " + indexName + " ON " + tabName);
                }
            });
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1740));
        this.test("insert skewed table", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tabName = "tab1";
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tabName}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                HiveClient client = ((HiveExternalCatalog)this.spark().sharedState().externalCatalog().unwrapped()).client();
                client.runSqlHive(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |CREATE Table " + tabName + "(col1 int, col2 int)\n           |PARTITIONED BY (part1 string, part2 string)\n           |SKEWED BY (col1) ON (3, 4) STORED AS DIRECTORIES\n         ")));
                CatalogTable hiveTable = this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tabName, (Option)new Some((Object)"default")));
                scala.collection.immutable.Seq $org_scalatest_assert_macro_left = hiveTable.unsupportedFeatures();
                String $org_scalatest_assert_macro_right = "skewed columns";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1818));
                this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |INSERT OVERWRITE TABLE " + tabName + "\n           |PARTITION (part1='a', part2)\n           |SELECT 3, 4, 'b'\n         ")));
                this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |INSERT INTO TABLE " + tabName + "\n           |PARTITION (part1='a', part2='b')\n           |SELECT 1, 2\n         ")));
                Row row = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)4), "a", "b"}));
                Row row2 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), "a", "b"}));
                this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("SELECT * from " + tabName)), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
            });
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1803));
        this.test("desc table for data source table - no user-defined schema", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"parquet", (List)new .colon.colon((Object)"json", (List)new .colon.colon((Object)"orc", (List)Nil$.MODULE$))).foreach((Function1 & Serializable)fileFormat -> {
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1 & Serializable)dir -> {
                HiveDDLSuite.$anonfun$new$220($this, fileFormat, dir);
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1842));
        this.test("datasource and statistics table property keys are not allowed", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE tbl(a INT) STORED AS parquet");
            new .colon.colon((Object)HiveExternalCatalog$.MODULE$.DATASOURCE_PREFIX(), (List)new .colon.colon((Object)HiveExternalCatalog$.MODULE$.STATISTICS_PREFIX(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)forbiddenPrefix -> {
                HiveDDLSuite.$anonfun$new$223(this, forbiddenPrefix);
                return BoxedUnit.UNIT;
            });
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1858));
        this.test("create hive serde table with new syntax", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t", "t2", "t3"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1 & Serializable)path -> {
            HiveDDLSuite.$anonfun$new$228(this, path);
            return BoxedUnit.UNIT;
        })), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1888));
        this.test("create hive serde table with Catalog", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1 & Serializable)dir -> {
            HiveDDLSuite.$anonfun$new$235(this, dir);
            return BoxedUnit.UNIT;
        })), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1922));
        this.test("create hive serde table with DataFrameWriter.saveAsTable", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t", "t1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(HiveDDLSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator41$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator41$1(HiveDDLSuite $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder((scala.collection.immutable.Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"a"), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator41$1(null)))).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"})).write().format("hive").option("fileFormat", "avro").saveAsTable("t");
            this.checkAnswer((Function0 & Serializable)() -> this.spark().table("t"), Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a"})));
            JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(HiveDDLSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator51$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator51$1(HiveDDLSuite $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder((scala.collection.immutable.Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator51$1(null)))).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"})).write().format("hive").mode(SaveMode.Overwrite).option("fileFormat", "parquet").saveAsTable("t");
            this.checkAnswer((Function0 & Serializable)() -> this.spark().table("t"), Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"c", BoxesRunTime.boxToInteger((int)1)})));
            CatalogTable table = this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply("t"));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(DDLUtils$.MODULE$.isHiveTable(table), "org.apache.spark.sql.execution.command.DDLUtils.isHiveTable(table)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1958));
            Option $org_scalatest_assert_macro_left = table.storage().inputFormat();
            Some $org_scalatest_assert_macro_right = new Some((Object)"org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat");
            Option option = $org_scalatest_assert_macro_left;
            Some some = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1959));
            Option $org_scalatest_assert_macro_left2 = table.storage().outputFormat();
            Some $org_scalatest_assert_macro_right2 = new Some((Object)"org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat");
            Option option2 = $org_scalatest_assert_macro_left2;
            Some some2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1961));
            Option $org_scalatest_assert_macro_left3 = table.storage().serde();
            Some $org_scalatest_assert_macro_right3 = new Some((Object)"org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe");
            Option option3 = $org_scalatest_assert_macro_left3;
            Some some3 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option3 != null ? !option3.equals(some3) : some3 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1963));
            JavaUniverse $u3 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m3 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(HiveDDLSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator61$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator61$1(HiveDDLSuite $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder((scala.collection.immutable.Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)"x"), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator61$1(null)))).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"})).write().format("hive").mode(SaveMode.Overwrite).option("fileFormat", "avro").saveAsTable("t");
            this.checkAnswer((Function0 & Serializable)() -> this.spark().table("t"), Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), "x"})));
            table = this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply("t"));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(DDLUtils$.MODULE$.isHiveTable(table), "org.apache.spark.sql.execution.command.DDLUtils.isHiveTable(table)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1971));
            Option $org_scalatest_assert_macro_left4 = table.storage().inputFormat();
            Some $org_scalatest_assert_macro_right4 = new Some((Object)"org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat");
            Option option4 = $org_scalatest_assert_macro_left4;
            Some some4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(option4 != null ? !option4.equals(some4) : some4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1972));
            Option $org_scalatest_assert_macro_left5 = table.storage().outputFormat();
            Some $org_scalatest_assert_macro_right5 = new Some((Object)"org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat");
            Option option5 = $org_scalatest_assert_macro_left5;
            Some some5 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(option5 != null ? !option5.equals(some5) : some5 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1974));
            Option $org_scalatest_assert_macro_left6 = table.storage().serde();
            Some $org_scalatest_assert_macro_right6 = new Some((Object)"org.apache.hadoop.hive.serde2.avro.AvroSerDe");
            Option option6 = $org_scalatest_assert_macro_left6;
            Some some6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(option6 != null ? !option6.equals(some6) : some6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1976));
            AnalysisException e2 = (AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(HiveDDLSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator71$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator71$1(HiveDDLSuite $outer) {
                    }
                }
                this.testImplicits().localSeqToDatasetHolder((scala.collection.immutable.Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"a"), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator71$1(null)))).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"})).write().format("hive").bucketBy(4, "i", (scala.collection.immutable.Seq)Nil$.MODULE$).saveAsTable("t1");
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1979));
            String $org_scalatest_assert_macro_left7 = e2.message();
            String $org_scalatest_assert_macro_right7 = "Creating bucketed Hive serde table is not supported yet";
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.contains($org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1982));
            AnalysisException x$115 = (AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.spark().table("t").write().format("hive").mode("overwrite").saveAsTable("t"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1985));
            String x$116 = "UNSUPPORTED_OVERWRITE.TABLE";
            Map x$117 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)("`" + CatalogManager$.MODULE$.SESSION_CATALOG_NAME() + "`.`default`.`t`"))}));
            Option x$118 = this.checkError$default$3();
            boolean x$119 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$120 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$115, "UNSUPPORTED_OVERWRITE.TABLE", x$118, x$117, x$119, x$120);
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1947));
        this.test("SPARK-34370: support Avro schema evolution (add column with avro.schema.url)", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.checkAvroSchemaEvolutionAddColumn("'avro.schema.url'='" + TestHive$.MODULE$.getHiveFile("schemaWithOneField.avsc").toURI() + "'", "'avro.schema.url'='" + TestHive$.MODULE$.getHiveFile("schemaWithTwoFields.avsc").toURI() + "'"), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1993));
        this.test("SPARK-26836: support Avro schema evolution (add column with avro.schema.literal)", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String originalSchema = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |{\n        |  \"namespace\": \"test\",\n        |  \"name\": \"some_schema\",\n        |  \"type\": \"record\",\n        |  \"fields\": [\n        |    {\n        |      \"name\": \"col2\",\n        |      \"type\": \"string\"\n        |    }\n        |  ]\n        |}\n      "));
            String evolvedSchema = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |{\n        |  \"namespace\": \"test\",\n        |  \"name\": \"some_schema\",\n        |  \"type\": \"record\",\n        |  \"fields\": [\n        |    {\n        |      \"name\": \"col1\",\n        |      \"type\": \"string\",\n        |      \"default\": \"col1_default\"\n        |    },\n        |    {\n        |      \"name\": \"col2\",\n        |      \"type\": \"string\"\n        |    }\n        |  ]\n        |}\n      "));
            this.checkAvroSchemaEvolutionAddColumn("'avro.schema.literal'='" + originalSchema + "'", "'avro.schema.literal'='" + evolvedSchema + "'");
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1999));
        this.test("SPARK-34370: support Avro schema evolution (remove column with avro.schema.url)", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.checkAvroSchemaEvolutionRemoveColumn("'avro.schema.url'='" + TestHive$.MODULE$.getHiveFile("schemaWithTwoFields.avsc").toURI() + "'", "'avro.schema.url'='" + TestHive$.MODULE$.getHiveFile("schemaWithOneField.avsc").toURI() + "'"), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2059));
        this.test("SPARK-26836: support Avro schema evolution (remove column with avro.schema.literal)", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String originalSchema = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |{\n        |  \"namespace\": \"test\",\n        |  \"name\": \"some_schema\",\n        |  \"type\": \"record\",\n        |  \"fields\": [\n        |    {\n        |      \"name\": \"col1\",\n        |      \"type\": \"string\",\n        |      \"default\": \"col1_default\"\n        |    },\n        |    {\n        |      \"name\": \"col2\",\n        |      \"type\": \"string\"\n        |    }\n        |  ]\n        |}\n      "));
            String evolvedSchema = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |{\n        |  \"namespace\": \"test\",\n        |  \"name\": \"some_schema\",\n        |  \"type\": \"record\",\n        |  \"fields\": [\n        |    {\n        |      \"name\": \"col2\",\n        |      \"type\": \"string\"\n        |    }\n        |  ]\n        |}\n      "));
            this.checkAvroSchemaEvolutionRemoveColumn("'avro.schema.literal'='" + originalSchema + "'", "'avro.schema.literal'='" + evolvedSchema + "'");
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2065));
        this.test("append data to hive serde table", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t", "t1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(HiveDDLSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator81$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator81$1(HiveDDLSuite $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder((scala.collection.immutable.Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"a"), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator81$1(null)))).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"})).write().format("hive").option("fileFormat", "avro").saveAsTable("t");
            this.checkAnswer((Function0 & Serializable)() -> this.spark().table("t"), Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a"})));
            this.sql().apply((Object)"INSERT INTO t SELECT 2, 'b'");
            Row row = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a"}));
            Row row2 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b"}));
            this.checkAnswer((Function0 & Serializable)() -> this.spark().table("t"), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
            JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(HiveDDLSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator91$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator91$1(HiveDDLSuite $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder((scala.collection.immutable.Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"c"), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator91$1(null)))).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"})).write().format("hive").mode("append").saveAsTable("t");
            Row row3 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a"}));
            Row row4 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b"}));
            Row row5 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c"}));
            this.checkAnswer((Function0 & Serializable)() -> this.spark().table("t"), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row5).$colon$colon((Object)row4).$colon$colon((Object)row3));
            JavaUniverse $u3 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m3 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(HiveDDLSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator101$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator101$1(HiveDDLSuite $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder((scala.collection.immutable.Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)3.5)), (Object)BoxesRunTime.boxToInteger((int)3)), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator101$1(null)))).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"})).write().format("hive").mode("append").saveAsTable("t");
            Row row6 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a"}));
            Row row7 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b"}));
            Row row8 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c"}));
            Row row9 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "3"}));
            this.checkAnswer((Function0 & Serializable)() -> this.spark().table("t"), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row9).$colon$colon((Object)row8).$colon$colon((Object)row7).$colon$colon((Object)row6));
            JavaUniverse $u4 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m4 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(HiveDDLSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator111$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator111$1(HiveDDLSuite $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder((scala.collection.immutable.Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"d"), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator111$1(null)))).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"})).write().saveAsTable("t1");
            AnalysisException e = (AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(HiveDDLSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator121$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator121$1(HiveDDLSuite $outer) {
                    }
                }
                this.testImplicits().localSeqToDatasetHolder((scala.collection.immutable.Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"e"), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator121$1(null)))).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"})).write().format("hive").mode("append").saveAsTable("t1");
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2145));
            String $org_scalatest_assert_macro_left = e.message();
            String $org_scalatest_assert_macro_right = "The format of the existing table " + CatalogManager$.MODULE$.SESSION_CATALOG_NAME() + ".default.t1 is ";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2149));
            String $org_scalatest_assert_macro_left2 = e.message();
            String $org_scalatest_assert_macro_right2 = "It doesn't match the specified format `HiveFileFormat`.";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2151));
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2125));
        this.test("create partitioned hive serde table as select", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t", "t1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.exec.dynamic.partition.mode"), (Object)"nonstrict")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(HiveDDLSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator131$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator131$1(HiveDDLSuite $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder((scala.collection.immutable.Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)"y"), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator131$1(null)))).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"})).write().format("hive").partitionBy((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"i"})).saveAsTable("t");
            Row row = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"y", BoxesRunTime.boxToInteger((int)10)}));
            this.checkAnswer((Function0 & Serializable)() -> this.spark().table("t"), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row));
            JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(HiveDDLSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator141$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator141$1(HiveDDLSuite $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder((scala.collection.immutable.Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)3)), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator141$1(null)))).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j", "k"})).write().mode("overwrite").format("hive").partitionBy((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"j", "k"})).saveAsTable("t");
            Row row2 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)}));
            this.checkAnswer((Function0 & Serializable)() -> this.spark().table("t"), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row2));
            this.spark().sql("create table t1 using hive partitioned by (i) as select 1 as i, 'a' as j");
            Row row3 = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToInteger((int)1)}));
            this.checkAnswer((Function0 & Serializable)() -> this.spark().table("t1"), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row3));
        })), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2155));
        this.test("read/write files with hive data source is not allowed", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1 & Serializable)dir -> {
            HiveDDLSuite.$anonfun$new$262(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2171));
        this.test("partitioned table should always put partition columns at the end of table schema", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String provider = this.spark().sessionState().conf().defaultDataSourceName();
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t", "t1", "t2", "t3", "t4", "t5", "t6"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TABLE t(a int, b int, c int, d int) USING " + provider + " PARTITIONED BY (d, b)"));
                scala.collection.immutable.Seq $org_scalatest_assert_macro_left = this.getTableColumns$1("t");
                .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"a", (List)new .colon.colon((Object)"c", (List)new .colon.colon((Object)"d", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$))));
                scala.collection.immutable.Seq seq = $org_scalatest_assert_macro_left;
                .colon.colon colon2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2204));
                this.sql().apply((Object)("CREATE TABLE t1 USING " + provider + " PARTITIONED BY (d, b) AS SELECT 1 a, 1 b, 1 c, 1 d"));
                scala.collection.immutable.Seq $org_scalatest_assert_macro_left2 = this.getTableColumns$1("t1");
                .colon.colon $org_scalatest_assert_macro_right2 = new .colon.colon((Object)"a", (List)new .colon.colon((Object)"c", (List)new .colon.colon((Object)"d", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$))));
                scala.collection.immutable.Seq seq2 = $org_scalatest_assert_macro_left2;
                .colon.colon colon3 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq2 != null ? !seq2.equals(colon3) : colon3 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2207));
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(HiveDDLSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator161$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
                    }

                    public Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator161$1(HiveDDLSuite $outer) {
                    }
                }
                this.testImplicits().localSeqToDatasetHolder((scala.collection.immutable.Seq)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator161$1(null)))).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c", "d"})).write().partitionBy((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d", "b"})).saveAsTable("t2");
                scala.collection.immutable.Seq $org_scalatest_assert_macro_left3 = this.getTableColumns$1("t2");
                .colon.colon $org_scalatest_assert_macro_right3 = new .colon.colon((Object)"a", (List)new .colon.colon((Object)"c", (List)new .colon.colon((Object)"d", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$))));
                scala.collection.immutable.Seq seq3 = $org_scalatest_assert_macro_left3;
                .colon.colon colon4 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(seq3 != null ? !seq3.equals(colon4) : colon4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2210));
                this.withTempPath((Function1 & Serializable)path -> {
                    HiveDDLSuite.$anonfun$new$270(this, provider, path);
                    return BoxedUnit.UNIT;
                });
                this.sql().apply((Object)"CREATE TABLE t4(a int, b int, c int, d int) USING hive PARTITIONED BY (d, b)");
                scala.collection.immutable.Seq $org_scalatest_assert_macro_left4 = this.getTableColumns$1("t4");
                .colon.colon $org_scalatest_assert_macro_right4 = new .colon.colon((Object)"a", (List)new .colon.colon((Object)"c", (List)new .colon.colon((Object)"d", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$))));
                scala.collection.immutable.Seq seq4 = $org_scalatest_assert_macro_left4;
                .colon.colon colon5 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(seq4 != null ? !seq4.equals(colon5) : colon5 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2221));
                this.withSQLConf((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.exec.dynamic.partition.mode"), (Object)"nonstrict")}), (Function0 & Serializable)() -> {
                    this.sql().apply((Object)"CREATE TABLE t5 USING hive PARTITIONED BY (d, b) AS SELECT 1 a, 1 b, 1 c, 1 d");
                    scala.collection.immutable.Seq $org_scalatest_assert_macro_left = this.getTableColumns$1("t5");
                    .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"a", (List)new .colon.colon((Object)"c", (List)new .colon.colon((Object)"d", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$))));
                    scala.collection.immutable.Seq seq = $org_scalatest_assert_macro_left;
                    .colon.colon colon2 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2225));
                    JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(HiveDDLSuite.class.getClassLoader());
                    public final class Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator181$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
                        }

                        public Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator181$1(HiveDDLSuite $outer) {
                        }
                    }
                    this.testImplicits().localSeqToDatasetHolder((scala.collection.immutable.Seq)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator181$1(null)))).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c", "d"})).write().format("hive").partitionBy((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d", "b"})).saveAsTable("t6");
                    scala.collection.immutable.Seq $org_scalatest_assert_macro_left2 = this.getTableColumns$1("t6");
                    .colon.colon $org_scalatest_assert_macro_right2 = new .colon.colon((Object)"a", (List)new .colon.colon((Object)"c", (List)new .colon.colon((Object)"d", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$))));
                    scala.collection.immutable.Seq seq2 = $org_scalatest_assert_macro_left2;
                    .colon.colon colon3 = $org_scalatest_assert_macro_right2;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq2 != null ? !seq2.equals(colon3) : colon3 != null), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2229));
                });
            });
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2196));
        this.test("create hive table with a non-existing location", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t", "t1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.withTempPath((Function1 & Serializable)dir -> {
                HiveDDLSuite.$anonfun$new$274(this, dir);
                return BoxedUnit.UNIT;
            });
            this.withTempPath((Function1 & Serializable)dir -> {
                HiveDDLSuite.$anonfun$new$276(this, dir);
                return BoxedUnit.UNIT;
            });
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2234));
        scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)shouldDelete -> {
            HiveDDLSuite.$anonfun$new$278(this, BoxesRunTime.unboxToBoolean((Object)shouldDelete));
            return BoxedUnit.UNIT;
        });
        new .colon.colon((Object)"parquet", (List)new .colon.colon((Object)"hive", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)datasource -> {
            HiveDDLSuite.$anonfun$new$286(this, datasource);
            return BoxedUnit.UNIT;
        });
        new .colon.colon((Object)"a b", (List)new .colon.colon((Object)"a:b", (List)new .colon.colon((Object)"a%b", (List)Nil$.MODULE$))).foreach((Function1 & Serializable)specialChars -> {
            this.test("hive table: location uri contains " + specialChars, (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                Bool bool;
                Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(Utils$.MODULE$.isWindows(), "org.apache.spark.util.Utils.isWindows", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left.value()) {
                    bool = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
                } else {
                    String $org_scalatest_assert_macro_left2 = specialChars;
                    String $org_scalatest_assert_macro_right = "a:b";
                    String string = $org_scalatest_assert_macro_left2;
                    String string2 = $org_scalatest_assert_macro_right;
                    bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!=", (Object)$org_scalatest_assert_macro_right, string == null ? string2 != null : !string.equals(string2), Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right = bool;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "||", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$bar$bar((Function0 & Serializable)() -> $org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2351));
                $this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    $this.withTempDir((Function1 & Serializable)dir -> {
                        HiveDDLSuite.$anonfun$new$298($this, specialChars, dir);
                        return BoxedUnit.UNIT;
                    });
                    $this.withTempDir((Function1 & Serializable)dir -> {
                        HiveDDLSuite.$anonfun$new$301($this, specialChars, dir);
                        return BoxedUnit.UNIT;
                    });
                });
            }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2348));
            return BoxedUnit.UNIT;
        });
        this.test("SPARK-19905: Hive SerDe table input paths", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"spark_19905"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"spark_19905_view"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().range(10L).createOrReplaceTempView("spark_19905_view");
            this.sql().apply((Object)"CREATE TABLE spark_19905 STORED AS RCFILE AS SELECT * FROM spark_19905_view");
            Object $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])this.spark().table("spark_19905").inputFiles());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left), "nonEmpty", ArrayOps$.MODULE$.nonEmpty$extension($org_scalatest_assert_macro_left), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2454));
            long $org_scalatest_assert_macro_left2 = ((org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"SELECT input_file_name() FROM spark_19905")).count();
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left2 > (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2455));
        })), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2449));
        this.hiveFormats().foreach((Function1 & Serializable)tableType -> {
            this.test("alter hive serde table add columns -- partitioned - " + tableType, (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tab"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |CREATE TABLE tab (c1 int, c2 int)\n             |PARTITIONED BY (c3 int) STORED AS " + tableType + "\n          ")));
                $this.sql().apply((Object)"INSERT INTO tab PARTITION (c3=1) VALUES (1, 2)");
                $this.sql().apply((Object)"ALTER TABLE tab ADD COLUMNS (c4 int)");
                $this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)"SELECT * FROM tab WHERE c3 = 1"), (scala.collection.immutable.Seq)new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), null, BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$));
                StructType $org_scalatest_assert_macro_left = $this.spark().table("tab").schema();
                StructField $org_scalatest_assert_macro_right = new StructField("c4", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2476));
                $this.sql().apply((Object)"INSERT INTO tab PARTITION (c3=2) VALUES (2, 3, 4)");
                $this.checkAnswer((Function0 & Serializable)() -> $this.spark().table("tab"), (scala.collection.immutable.Seq)new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), null, BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$)));
                $this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)"SELECT * FROM tab WHERE c3 = 2 AND c4 IS NOT NULL"), (scala.collection.immutable.Seq)new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$));
                $this.sql().apply((Object)"ALTER TABLE tab ADD COLUMNS (c5 char(10))");
                DataType $org_scalatest_assert_macro_left2 = ((StructField)$this.spark().sharedState().externalCatalog().getTable("default", "tab").schema().find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)HiveDDLSuite.$anonfun$new$315(x$7))).get()).dataType();
                CharType $org_scalatest_assert_macro_right2 = new CharType(10);
                DataType dataType = $org_scalatest_assert_macro_left2;
                CharType charType = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType != null ? !dataType.equals(charType) : charType != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2489));
            }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2461));
            return BoxedUnit.UNIT;
        });
        this.hiveFormats().foreach((Function1 & Serializable)tableType -> {
            this.test("alter hive serde table add columns -- with predicate - " + tableType + " ", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tab"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)("CREATE TABLE tab (c1 int, c2 int) STORED AS " + tableType));
                $this.sql().apply((Object)"INSERT INTO tab VALUES (1, 2)");
                $this.sql().apply((Object)"ALTER TABLE tab ADD COLUMNS (c4 int)");
                $this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)"SELECT * FROM tab WHERE c4 IS NULL"), (scala.collection.immutable.Seq)new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), null})), (List)Nil$.MODULE$));
                StructType $org_scalatest_assert_macro_left = $this.spark().table("tab").schema();
                StructField $org_scalatest_assert_macro_right = new StructField("c4", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2505));
                $this.sql().apply((Object)"INSERT INTO tab VALUES (2, 3, 4)");
                $this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)"SELECT * FROM tab WHERE c4 = 4 "), (scala.collection.immutable.Seq)new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$));
                $this.checkAnswer((Function0 & Serializable)() -> $this.spark().table("tab"), (scala.collection.immutable.Seq)new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), null})), (List)new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$)));
            }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2496));
            return BoxedUnit.UNIT;
        });
        scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)caseSensitive -> {
            this.test("alter add columns with existing column name - caseSensitive " + BoxesRunTime.unboxToBoolean((Object)caseSensitive), (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)String.valueOf(BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)caseSensitive))))}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tab"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)"CREATE TABLE tab (c1 int) PARTITIONED BY (c2 int) STORED AS PARQUET");
                if (!caseSensitive) {
                    $this.assertAnalysisErrorCondition("ALTER TABLE tab ADD COLUMNS (C2 string)", "COLUMN_ALREADY_EXISTS", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)"`c2`")}))));
                    $this.assertAnalysisErrorCondition("ALTER TABLE tab ADD COLUMNS (C1 string)", "COLUMN_ALREADY_EXISTS", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)"`c1`")}))));
                    return;
                }
                AnalysisException x$139 = (AnalysisException)$this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)"ALTER TABLE tab ADD COLUMNS (C2 string)"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2541));
                String x$140 = "_LEGACY_ERROR_TEMP_3065";
                Map x$141 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clazz"), (Object)"org.apache.hadoop.hive.ql.metadata.HiveException"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)"Partition column name c2 conflicts with table columns.")}));
                Option x$142 = $this.checkError$default$3();
                boolean x$143 = $this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$144 = $this.checkError$default$6();
                $this.checkError((SparkThrowable)x$139, "_LEGACY_ERROR_TEMP_3065", x$142, x$141, x$143, x$144);
                AnalysisException x$145 = (AnalysisException)$this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)"ALTER TABLE tab ADD COLUMNS (C1 string)"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2553));
                String x$146 = "_LEGACY_ERROR_TEMP_3065";
                Map x$147 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clazz"), (Object)"org.apache.hadoop.hive.ql.metadata.HiveException"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)"Duplicate column name c1 in the table definition.")}));
                Option x$148 = $this.checkError$default$3();
                boolean x$149 = $this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$150 = $this.checkError$default$6();
                $this.checkError((SparkThrowable)x$145, "_LEGACY_ERROR_TEMP_3065", x$148, x$147, x$149, x$150);
            })), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2521));
            return BoxedUnit.UNIT;
        });
        this.test("SPARK-36241: support creating tables with void datatype", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "t2", "t3"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                AnalysisException x$151 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"CREATE TABLE t1 USING PARQUET AS SELECT NULL AS null_col"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2571));
                String x$152 = "UNSUPPORTED_DATA_TYPE_FOR_DATASOURCE";
                Map x$153 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)"`null_col`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnType"), (Object)"\"VOID\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"format"), (Object)"Parquet")}));
                Option x$154 = this.checkError$default$3();
                boolean x$155 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$156 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$151, "UNSUPPORTED_DATA_TYPE_FOR_DATASOURCE", x$154, x$153, x$155, x$156);
                AnalysisException x$157 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"CREATE TABLE t2 STORED AS PARQUET AS SELECT null as null_col"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2582));
                String x$158 = "_LEGACY_ERROR_TEMP_3065";
                Map x$159 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clazz"), (Object)"org.apache.hadoop.hive.ql.metadata.HiveException"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)"java.lang.UnsupportedOperationException: Unknown field type: void")}));
                Option x$160 = this.checkError$default$3();
                boolean x$161 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$162 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$157, "_LEGACY_ERROR_TEMP_3065", x$160, x$159, x$161, x$162);
                this.sql().apply((Object)"CREATE TABLE t3 USING HIVE AS SELECT NULL AS null_col");
                this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"SELECT * FROM t3"), Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})));
            });
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "t2", "t3", "t4"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                AnalysisException x$163 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"CREATE TABLE t1 (v VOID) USING PARQUET"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2598));
                String x$164 = "UNSUPPORTED_DATA_TYPE_FOR_DATASOURCE";
                Map x$165 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)"`v`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnType"), (Object)"\"VOID\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"format"), (Object)"Parquet")}));
                Option x$166 = this.checkError$default$3();
                boolean x$167 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$168 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$163, "UNSUPPORTED_DATA_TYPE_FOR_DATASOURCE", x$166, x$165, x$167, x$168);
                AnalysisException x$169 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"CREATE TABLE t2 (v VOID) STORED AS PARQUET"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2608));
                String x$170 = "_LEGACY_ERROR_TEMP_3065";
                Map x$171 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clazz"), (Object)"org.apache.hadoop.hive.ql.metadata.HiveException"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)"java.lang.UnsupportedOperationException: Unknown field type: void")}));
                Option x$172 = this.checkError$default$3();
                boolean x$173 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$174 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$169, "_LEGACY_ERROR_TEMP_3065", x$172, x$171, x$173, x$174);
                this.sql().apply((Object)"CREATE TABLE t3 (v VOID) USING hive");
                this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"SELECT * FROM t3"), (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().empty());
            });
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                StructType schema = new StructType().add("c", (DataType)NullType$.MODULE$);
                this.spark().catalog().createTable("t", "json", schema, Predef$.MODULE$.Map().empty());
                this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"SELECT * FROM t"), (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().empty());
            });
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2567));
        this.test("SPARK-21216: join with a streaming DataFrame", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            org.apache.spark.sql.classic.SQLContext _sqlContext = this.spark().sqlContext();
            this.withTempView((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(HiveDDLSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator191$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator191$1(HiveDDLSuite $outer) {
                    }
                }
                this.testImplicits().localSeqToDatasetHolder((scala.collection.immutable.Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"one"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)"two"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)4), (Object)"four"), (List)Nil$.MODULE$))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveDDLSuite$$typecreator191$1(null)))).toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"number", "word"})).createOrReplaceTempView("t1");
                this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE TABLE smallTable(word string, number int)\n            |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe'\n            |STORED AS TEXTFILE\n          ")));
                this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("INSERT INTO smallTable\n          |SELECT word, number from t1\n        ")));
                MemoryStream inputData = MemoryStream$.MODULE$.apply(this.testImplicits().newIntEncoder(), (SQLContext)_sqlContext);
                org.apache.spark.sql.classic.Dataset joined = inputData.toDS().toDF().join((Dataset)this.spark().table("smallTable"), this.testImplicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((scala.collection.immutable.Seq)Nil$.MODULE$).$eq$eq$eq((Object)this.testImplicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"number"}))).$((scala.collection.immutable.Seq)Nil$.MODULE$)));
                StreamingQuery sq = joined.writeStream().format("memory").queryName("t2").start();
                try {
                    inputData.addData((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
                    sq.processAllAvailable();
                    this.checkAnswer((Function0 & Serializable)() -> this.spark().table("t2"), (scala.collection.immutable.Seq)new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "one", BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "two", BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$)));
                }
                finally {
                    sq.stop();
                }
            });
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2633));
        this.test("table name with schema", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withDatabase((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"usrdb"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().sql("create schema usrdb");
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"usrdb.test"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.spark().sql("create table usrdb.test(c int)");
                this.spark().read().table("usrdb.test");
            });
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2675));
        new .colon.colon((Object)new Tuple2((Object)"orc", (Object)OrcCompressionCodec.ZLIB.name()), (List)new .colon.colon((Object)new Tuple2((Object)"parquet", (Object)ParquetCompressionCodec.GZIP.name()), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)x0$4 -> {
            HiveDDLSuite.$anonfun$new$345(this, x0$4);
            return BoxedUnit.UNIT;
        });
        this.test("SPARK-23355 convertMetastoreOrc should not ignore table properties - STORED AS", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"native", (List)new .colon.colon((Object)"hive", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)orcImpl -> {
            this.withSQLConf((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_IMPLEMENTATION().key()), (Object)orcImpl), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_ORC().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1 & Serializable)path -> {
                HiveDDLSuite.$anonfun$new$356($this, path);
                return BoxedUnit.UNIT;
            })));
            return BoxedUnit.UNIT;
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2741));
        this.test("SPARK-23355 convertMetastoreParquet should not ignore table properties - STORED AS", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_PARQUET().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1 & Serializable)path -> {
            HiveDDLSuite.$anonfun$new$364(this, path);
            return BoxedUnit.UNIT;
        }))), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2783));
        this.test("load command for non local invalid path validation", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE tbl(i INT, j STRING) USING hive");
            AnalysisException x$175 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"load data inpath '/doesnotexist.csv' into table tbl"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2816));
            String x$176 = "LOAD_DATA_PATH_NOT_EXISTS";
            Map x$177 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)"/doesnotexist.csv")}));
            Option x$178 = this.checkError$default$3();
            boolean x$179 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$180 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$175, "LOAD_DATA_PATH_NOT_EXISTS", x$178, x$177, x$179, x$180);
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2812));
        this.test("SPARK-22252: FileFormatWriter should respect the input query schema in HIVE", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "t2", "t3", "t4"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().range(1L).select((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((scala.collection.immutable.Seq)Nil$.MODULE$).as("col1"), this.testImplicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((scala.collection.immutable.Seq)Nil$.MODULE$).as("col2")})).write().saveAsTable("t1");
            this.spark().sql("select COL1, COL2 from t1").write().format("hive").saveAsTable("t2");
            this.checkAnswer((Function0 & Serializable)() -> this.spark().table("t2"), Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)})));
            this.spark().range(1L).select((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((scala.collection.immutable.Seq)Nil$.MODULE$), this.testImplicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((scala.collection.immutable.Seq)Nil$.MODULE$).as("col1"), this.testImplicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((scala.collection.immutable.Seq)Nil$.MODULE$).as("col2")})).write().saveAsTable("t3");
            this.spark().sql("select COL1, COL2 from t3").write().format("hive").saveAsTable("t4");
            this.checkAnswer((Function0 & Serializable)() -> this.spark().table("t4"), Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)})));
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2825));
        this.test("SPARK-24812: desc formatted table for last access verification", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE IF NOT EXISTS t1 (c1_int INT, c2_string STRING, c3_float FLOAT)");
            org.apache.spark.sql.classic.Dataset desc = ((org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"DESC FORMATTED t1")).filter(this.testImplicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col_name"}))).$((scala.collection.immutable.Seq)Nil$.MODULE$).startsWith("Last Access")).select("data_type", (scala.collection.immutable.Seq)Nil$.MODULE$);
            String $org_scalatest_assert_macro_left = ((Row)desc.first()).toString();
            String $org_scalatest_assert_macro_right = "UNKNOWN";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2846));
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2838));
        this.test("SPARK-47101 checks if nested column names do not include invalid characters", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)",", (List)new .colon.colon((Object)":", (List)new .colon.colon((Object)";", (List)new .colon.colon((Object)"^", (List)new .colon.colon((Object)"\\", (List)new .colon.colon((Object)"/", (List)new .colon.colon((Object)"%", (List)Nil$.MODULE$))))))).foreach((Function1 & Serializable)c -> {
            HiveDDLSuite.$anonfun$new$377(this, c);
            return BoxedUnit.UNIT;
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2850));
        this.test("desc formatted table should also show viewOriginalText for views", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withView((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v1", "v2"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)"CREATE VIEW v1 AS SELECT 1 AS value");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapRefArray((Object[])((org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"DESC FORMATTED v1")).collect()).containsSlice((Seq)new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"Type", "VIEW", ""})), (List)new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"View Text", "SELECT 1 AS value", ""})), (List)new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"View Original Text", "SELECT 1 AS value", ""})), (List)Nil$.MODULE$)))), "scala.Predef.wrapRefArray[org.apache.spark.sql.Row](HiveDDLSuite.this.sql.apply(\"DESC FORMATTED v1\").collect()).containsSlice[org.apache.spark.sql.Row](scala.`package`.Seq.apply[org.apache.spark.sql.Row](org.apache.spark.sql.Row.apply(\"Type\", \"VIEW\", \"\"), org.apache.spark.sql.Row.apply(\"View Text\", \"SELECT 1 AS value\", \"\"), org.apache.spark.sql.Row.apply(\"View Original Text\", \"SELECT 1 AS value\", \"\")))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2871));
            this.hiveClient().runSqlHive("CREATE VIEW v2 AS SELECT * FROM (SELECT 1) T");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapRefArray((Object[])((org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"DESC FORMATTED v2")).collect()).containsSlice((Seq)new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"Type", "VIEW", ""})), (List)new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"View Text", "SELECT `t`.`_c0` FROM (SELECT 1) `T`", ""})), (List)new .colon.colon((Object)Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"View Original Text", "SELECT * FROM (SELECT 1) T", ""})), (List)Nil$.MODULE$)))), "scala.Predef.wrapRefArray[org.apache.spark.sql.Row](HiveDDLSuite.this.sql.apply(\"DESC FORMATTED v2\").collect()).containsSlice[org.apache.spark.sql.Row](scala.`package`.Seq.apply[org.apache.spark.sql.Row](org.apache.spark.sql.Row.apply(\"Type\", \"VIEW\", \"\"), org.apache.spark.sql.Row.apply(\"View Text\", \"SELECT `t`.`_c0` FROM (SELECT 1) `T`\", \"\"), org.apache.spark.sql.Row.apply(\"View Original Text\", \"SELECT * FROM (SELECT 1) T\", \"\")))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2880));
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2868));
        this.test("Hive CTAS can't create partitioned table by specifying schema", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sql1 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE TABLE t (a int)\n         |PARTITIONED BY (b string)\n         |STORED AS parquet\n         |AS SELECT 1 as a, \"a\" as b"));
            this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)sql1), ClassTag$.MODULE$.apply(ParseException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2897)), "_LEGACY_ERROR_TEMP_0035", (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)"Schema may not be specified in a Create Table As Select (CTAS) statement")})), this.ExpectedContext().apply(sql1, 0, 92));
            String sql2 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE TABLE t\n         |PARTITIONED BY (b string)\n         |STORED AS parquet\n         |AS SELECT 1 as a, \"a\" as b"));
            this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)sql2), ClassTag$.MODULE$.apply(ParseException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2909)), "_LEGACY_ERROR_TEMP_0035", (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)"Partition column types may not be specified in Create Table As Select (CTAS)")})), this.ExpectedContext().apply(sql2, 0, 84));
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2890));
        this.test("Hive CTAS with dynamic partition", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"orc", (List)new .colon.colon((Object)"parquet", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)format -> {
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.exec.dynamic.partition.mode"), (Object)"nonstrict")}), (Function0 & Serializable)() -> {
                $this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n               |CREATE TABLE t\n               |PARTITIONED BY (b)\n               |STORED AS " + format + "\n               |AS SELECT 1 as a, \"a\" as b\n               ")));
                $this.checkAnswer((Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a"})));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply("t")).partitionColumnNames());
                .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"b", (List)Nil$.MODULE$);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2930));
            }));
            return BoxedUnit.UNIT;
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2917));
        this.test("Create Table LIKE STORED AS Hive Format", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SessionCatalog catalog = this.spark().sessionState().catalog();
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"s"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)"CREATE TABLE s(a INT, b INT) STORED AS ORC");
                this.hiveFormats().foreach((Function1 & Serializable)tableType -> {
                    HiveDDLSuite.$anonfun$new$392(this, catalog, tableType);
                    return BoxedUnit.UNIT;
                });
            });
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2937));
        this.test("Create Table LIKE VIEW STORED AS Hive Format", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SessionCatalog catalog = this.spark().sessionState().catalog();
            this.withView((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)"CREATE TEMPORARY VIEW v AS SELECT 1 AS A, 1 AS B;");
                this.hiveFormats().foreach((Function1 & Serializable)tableType -> {
                    HiveDDLSuite.$anonfun$new$396(this, catalog, tableType);
                    return BoxedUnit.UNIT;
                });
            });
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2955));
        this.test("Create Table LIKE with specified TBLPROPERTIES", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SessionCatalog catalog = this.spark().sessionState().catalog();
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"s", "t"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)"CREATE TABLE s(a INT, b INT) USING hive TBLPROPERTIES('a'='apple')");
                CatalogTable source = catalog.getTableMetadata(TableIdentifier$.MODULE$.apply("s"));
                String $org_scalatest_assert_macro_left = (String)source.properties().apply((Object)"a");
                String $org_scalatest_assert_macro_right = "apple";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2978));
                this.sql().apply((Object)"CREATE TABLE t LIKE s STORED AS parquet TBLPROPERTIES('f'='foo', 'b'='bar')");
                CatalogTable table = catalog.getTableMetadata(TableIdentifier$.MODULE$.apply("t"));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(table.properties().get((Object)"a"));
                None$ $org_scalatest_assert_macro_right2 = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2981));
                String $org_scalatest_assert_macro_left3 = (String)table.properties().apply((Object)"f");
                String $org_scalatest_assert_macro_right3 = "foo";
                String string3 = $org_scalatest_assert_macro_left3;
                String string4 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2982));
                String $org_scalatest_assert_macro_left4 = (String)table.properties().apply((Object)"b");
                String $org_scalatest_assert_macro_right4 = "bar";
                String string5 = $org_scalatest_assert_macro_left4;
                String string6 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2983));
            });
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2973));
        this.test("Create Table LIKE with row format", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SessionCatalog catalog = this.spark().sessionState().catalog();
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sourceHiveTable", "sourceDsTable"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)"CREATE TABLE sourceHiveTable(a INT, b INT) STORED AS PARQUET");
                this.sql().apply((Object)"CREATE TABLE sourceDsTable(a INT, b INT) USING PARQUET");
                String sql1 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE TABLE targetDsTable LIKE sourceHiveTable USING PARQUET\n          |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe'"));
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)sql1), ClassTag$.MODULE$.apply(ParseException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2998)), "INVALID_STATEMENT_OR_CLAUSE", (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"CREATE TABLE LIKE ... USING ... ROW FORMAT SERDE ORG.APACHE.HADOOP.HIVE.SERDE2.LAZY.LAZYSIMPLESERDE")})), this.ExpectedContext().apply(sql1, 0, 130));
                String sql2 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE TABLE targetHiveTable LIKE sourceHiveTable USING hive\n          |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe'\n          |WITH SERDEPROPERTIES ('test' = 'test')"));
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)sql2), ClassTag$.MODULE$.apply(ParseException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3014)), "INVALID_STATEMENT_OR_CLAUSE", (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"CREATE TABLE LIKE ... USING ... ROW FORMAT SERDE ORG.APACHE.HADOOP.HIVE.SERDE2.LAZY.LAZYSIMPLESERDE")})), this.ExpectedContext().apply(sql2, 0, 168));
                String sql3 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE TABLE targetDsTable LIKE sourceDsTable\n          |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe'\n          |WITH SERDEPROPERTIES ('test' = 'test')"));
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)sql3), ClassTag$.MODULE$.apply(ParseException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3030)), "_LEGACY_ERROR_TEMP_0047", Predef$.MODULE$.Map().empty(), this.ExpectedContext().apply(sql3, 0, 153));
                String sql4 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE TABLE targetDsTable LIKE sourceDsTable USING format\n          |STORED AS INPUTFORMAT 'inFormat' OUTPUTFORMAT 'outFormat'\n          |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe'"));
                this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)sql4), ClassTag$.MODULE$.apply(ParseException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3044)), "INVALID_STATEMENT_OR_CLAUSE", (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"CREATE TABLE LIKE ... USING ... STORED AS INPUTFORMAT INFORMAT OUTPUTFORMAT OUTFORMAT ROW FORMAT SERDE ORG.APACHE.HADOOP.HIVE.SERDE2.LAZY.LAZYSIMPLESERDE")})), this.ExpectedContext().apply(sql4, 0, 185));
            });
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2987));
        this.test("SPARK-30785: create table like a partitioned table", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SessionCatalog catalog = this.spark().sessionState().catalog();
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sc_part", "ta_part"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)"CREATE TABLE sc_part (key string, ts int) USING parquet PARTITIONED BY (ts)");
                this.sql().apply((Object)"CREATE TABLE ta_part like sc_part");
                CatalogTable sourceTable = catalog.getTableMetadata(TableIdentifier$.MODULE$.apply("sc_part", (Option)new Some((Object)"default")));
                CatalogTable targetTable = catalog.getTableMetadata(TableIdentifier$.MODULE$.apply("ta_part", (Option)new Some((Object)"default")));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(sourceTable.tracksPartitionsInCatalog(), "sourceTable.tracksPartitionsInCatalog", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3064));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(targetTable.tracksPartitionsInCatalog(), "targetTable.tracksPartitionsInCatalog", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3065));
                scala.collection.immutable.Seq $org_scalatest_assert_macro_left = targetTable.partitionColumnNames();
                .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"ts", (List)Nil$.MODULE$);
                scala.collection.immutable.Seq seq = $org_scalatest_assert_macro_left;
                .colon.colon colon2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3066));
                this.sql().apply((Object)"ALTER TABLE ta_part ADD PARTITION (ts=10)");
                Row row = Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"ts=10"}));
                this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"SHOW PARTITIONS ta_part"), (scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)row));
            });
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3057));
        this.test("SPARK-31904: Fix case sensitive problem of char and varchar partition columns", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "t2"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE t1(a STRING, B VARCHAR(10), C CHAR(10)) STORED AS parquet");
            this.sql().apply((Object)"CREATE TABLE t2 USING parquet PARTITIONED BY (b, c) AS SELECT * FROM t1");
            Object $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])((org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"SELECT * FROM t2 WHERE b = 'A'")).collect());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3077));
            Object $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])((org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"SELECT * FROM t2 WHERE c = 'A'")).collect());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left2), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3078));
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3072));
        this.test("SPARK-33546: CREATE TABLE LIKE should validate row format & file format", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SessionCatalog catalog = this.spark().sessionState().catalog();
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sourceHiveTable", "sourceDsTable"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)"CREATE TABLE sourceHiveTable(a INT, b INT) STORED AS PARQUET");
                this.sql().apply((Object)"CREATE TABLE sourceDsTable(a INT, b INT) USING PARQUET");
                .colon.colon allowSerdeFileFormats = new .colon.colon((Object)"TEXTFILE", (List)new .colon.colon((Object)"SEQUENCEFILE", (List)new .colon.colon((Object)"RCFILE", (List)Nil$.MODULE$)));
                new .colon.colon((Object)"sourceHiveTable", (List)new .colon.colon((Object)"sourceDsTable", (List)Nil$.MODULE$)).foreach(arg_0 -> HiveDDLSuite.$anonfun$new$413$adapted(this, (scala.collection.immutable.Seq)allowSerdeFileFormats, catalog, arg_0));
                new .colon.colon((Object)"sourceHiveTable", (List)new .colon.colon((Object)"sourceDsTable", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)sourceTable -> {
                    this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"targetTable"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                        $this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n               |CREATE TABLE targetTable LIKE " + sourceTable + "\n               |ROW FORMAT DELIMITED\n               |STORED AS TEXTFILE\n             ")));
                        Option expectedSerde = HiveSerDe$.MODULE$.sourceToSerDe("TEXTFILE");
                        CatalogTable table = catalog$12.getTableMetadata(TableIdentifier$.MODULE$.apply("targetTable", (Option)new Some((Object)"default")));
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(table.provider());
                        Some $org_scalatest_assert_macro_right = new Some((Object)"hive");
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3146));
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(table.storage().inputFormat());
                        Some $org_scalatest_assert_macro_right2 = new Some(((HiveSerDe)expectedSerde.get()).inputFormat().get());
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3147));
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(table.storage().outputFormat());
                        Some $org_scalatest_assert_macro_right3 = new Some(((HiveSerDe)expectedSerde.get()).outputFormat().get());
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3148));
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(table.storage().serde());
                        Some $org_scalatest_assert_macro_right4 = new Some(((HiveSerDe)expectedSerde.get()).serde().get());
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3149));
                        String sql1 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE TABLE targetTable LIKE " + sourceTable + "\n               |ROW FORMAT DELIMITED\n               |STORED AS PARQUET"));
                        $this.checkError((SparkThrowable)$this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)sql1), ClassTag$.MODULE$.apply(ParseException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3157)), "_LEGACY_ERROR_TEMP_0035", (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)"ROW FORMAT DELIMITED is only compatible with 'textfile', not 'parquet'")})), $this.ExpectedContext().apply(sql1, 0, 68 + sourceTable.length()));
                    });
                    return BoxedUnit.UNIT;
                });
                this.hiveFormats().foreach((Function1 & Serializable)tableType -> {
                    HiveDDLSuite.$anonfun$new$423(this, catalog, tableType);
                    return BoxedUnit.UNIT;
                });
            });
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3082));
        this.test("SPARK-33844, 37969: Insert overwrite directory should check schema too", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_INSERT_DIR().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withView((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().range(1L).createTempView("v");
            this.withTempPath((Function1 & Serializable)path -> {
                HiveDDLSuite.$anonfun$new$429(this, path);
                return BoxedUnit.UNIT;
            });
        })), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3196));
        this.test("SPARK-36201: Add check for inner field of parquet/orc schema", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_INSERT_DIR().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withView((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().range(1L).createTempView("v");
            this.withTempPath((Function1 & Serializable)path -> {
                HiveDDLSuite.$anonfun$new$435(this, path);
                return BoxedUnit.UNIT;
            });
        })), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3219));
        this.test("SPARK-34261: Avoid side effect if create exists temporary function", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            URL $org_scalatest_assert_macro_left = Thread.currentThread().getContextClassLoader().getResource("TestUDTF.jar");
            Object $org_scalatest_assert_macro_right = null;
            URL uRL = $org_scalatest_assert_macro_left;
            Object var4_3 = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, uRL == null ? var4_3 != null : !((Object)uRL).equals(var4_3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3244));
            this.withUserDefinedFunction((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"f1"), (Object)BoxesRunTime.boxToBoolean((boolean)true))}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                AnalysisException e;
                this.sql().apply((Object)"CREATE TEMPORARY FUNCTION f1 AS 'org.apache.hadoop.hive.ql.udf.UDFUUID'");
                String jarName = "TestUDTF.jar";
                String jar = ((TestHiveSparkSession)this.spark()).getHiveFile(jarName).toURI().toString();
                this.spark().sparkContext().allAddedJars().keys().find((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.contains(jarName))).foreach((Function1 & Serializable)k -> {
                    HiveDDLSuite.$anonfun$new$440(this, k);
                    return BoxedUnit.UNIT;
                });
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.spark().sparkContext().listJars().exists((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.contains(jarName))), "HiveDDLSuite.this.spark.sparkContext.listJars().exists(((x$14: String) => x$14.contains(jarName)))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3252));
                AnalysisException x$199 = e = (AnalysisException)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("CREATE TEMPORARY FUNCTION f1 AS 'org.apache.hadoop.hive.ql.udf.UDFUUID' USING JAR '" + jar + "'")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3253));
                String x$200 = "ROUTINE_ALREADY_EXISTS";
                Map x$201 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"routineName"), (Object)"`f1`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"newRoutineType"), (Object)"routine"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"existingRoutineType"), (Object)"routine")}));
                Option x$202 = this.checkError$default$3();
                boolean x$203 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$204 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$199, "ROUTINE_ALREADY_EXISTS", x$202, x$201, x$203, x$204);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.spark().sparkContext().listJars().exists((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)x$15.contains(jarName))), "HiveDDLSuite.this.spark.sparkContext.listJars().exists(((x$15: String) => x$15.contains(jarName)))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3262));
                this.sql().apply((Object)("CREATE OR REPLACE TEMPORARY FUNCTION f1 AS 'org.apache.hadoop.hive.ql.udf.UDFUUID' USING JAR '" + jar + "'"));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.spark().sparkContext().listJars().exists((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.contains(jarName))), "HiveDDLSuite.this.spark.sparkContext.listJars().exists(((x$16: String) => x$16.contains(jarName)))", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3266));
            });
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3243));
        this.test("SPARK-36949: Disallow tables with ANSI intervals when the provider is Hive", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tbl = "tbl_with_ansi_intervals";
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tbl}), (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |CREATE TABLE " + tbl + "\n           |STORED AS ORC\n           |AS SELECT\n           |  INTERVAL '1-1' YEAR TO MONTH AS YM,\n           |  INTERVAL '1 02:03:04.123456' DAY TO SECOND AS DT\n           |")), (List)new .colon.colon((Object)("CREATE TABLE " + tbl + " (dt INTERVAL HOUR TO MINUTE) USING HIVE"), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)sqlCmd -> {
                HiveDDLSuite.$anonfun$new$448(this, tbl, sqlCmd);
                return BoxedUnit.UNIT;
            }));
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3270));
        this.test("SPARK-37046: Alter view should preserve column case with view definition change", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withView((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().sql("CREATE VIEW v AS SELECT 1 AS A, 1 AS B");
            org.apache.spark.sql.classic.Dataset df = this.spark().table("v");
            scala.collection.immutable.Seq $org_scalatest_assert_macro_left = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])df.schema().names()));
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"A", (List)new .colon.colon((Object)"B", (List)Nil$.MODULE$));
            scala.collection.immutable.Seq seq = $org_scalatest_assert_macro_left;
            .colon.colon colon2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3299));
            this.spark().sql("ALTER VIEW v AS SELECT 1 AS C, 1 AS D");
            org.apache.spark.sql.classic.Dataset df1 = this.spark().table("v");
            scala.collection.immutable.Seq $org_scalatest_assert_macro_left2 = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])df1.schema().names()));
            .colon.colon $org_scalatest_assert_macro_right2 = new .colon.colon((Object)"C", (List)new .colon.colon((Object)"D", (List)Nil$.MODULE$));
            scala.collection.immutable.Seq seq2 = $org_scalatest_assert_macro_left2;
            .colon.colon colon3 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq2 != null ? !seq2.equals(colon3) : colon3 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3303));
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3294));
        this.test("SPARK-37046: Alter view should preserve column case with view name change", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withView((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().sql("CREATE VIEW v AS SELECT 1 AS A, 1 AS B");
            org.apache.spark.sql.classic.Dataset df = this.spark().table("v");
            scala.collection.immutable.Seq $org_scalatest_assert_macro_left = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])df.schema().names()));
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"A", (List)new .colon.colon((Object)"B", (List)Nil$.MODULE$));
            scala.collection.immutable.Seq seq = $org_scalatest_assert_macro_left;
            .colon.colon colon2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3312));
            this.sql().apply((Object)"ALTER VIEW v RENAME TO vRenamed");
            org.apache.spark.sql.classic.Dataset df1 = this.spark().table("vRenamed");
            scala.collection.immutable.Seq $org_scalatest_assert_macro_left2 = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])df1.schema().names()));
            .colon.colon $org_scalatest_assert_macro_right2 = new .colon.colon((Object)"A", (List)new .colon.colon((Object)"B", (List)Nil$.MODULE$));
            scala.collection.immutable.Seq seq2 = $org_scalatest_assert_macro_left2;
            .colon.colon colon3 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq2 != null ? !seq2.equals(colon3) : colon3 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3316));
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3307));
        this.test("SPARK-37046: Alter view should preserve column case with tbl properties change", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withView((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().sql("CREATE VIEW v AS SELECT 1 AS A, 1 AS B");
            org.apache.spark.sql.classic.Dataset df = this.spark().table("v");
            scala.collection.immutable.Seq $org_scalatest_assert_macro_left = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])df.schema().names()));
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"A", (List)new .colon.colon((Object)"B", (List)Nil$.MODULE$));
            scala.collection.immutable.Seq seq = $org_scalatest_assert_macro_left;
            .colon.colon colon2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3325));
            this.sql().apply((Object)"ALTER VIEW v SET TBLPROPERTIES('testkey' = 'testval')");
            org.apache.spark.sql.classic.Dataset df1 = this.spark().table("v");
            scala.collection.immutable.Seq $org_scalatest_assert_macro_left2 = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])df1.schema().names()));
            .colon.colon $org_scalatest_assert_macro_right2 = new .colon.colon((Object)"A", (List)new .colon.colon((Object)"B", (List)Nil$.MODULE$));
            scala.collection.immutable.Seq seq2 = $org_scalatest_assert_macro_left2;
            .colon.colon colon3 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq2 != null ? !seq2.equals(colon3) : colon3 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3329));
        }), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3320));
        this.test("SPARK-38216: Fail early if all the columns are partitioned columns", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            AnalysisException x$211 = (AnalysisException)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"CREATE TABLE tab (c1 int) PARTITIONED BY (c1) STORED AS PARQUET"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3335));
            String x$212 = "ALL_PARTITION_COLUMNS_NOT_ALLOWED";
            Map x$213 = Predef$.MODULE$.Map().empty();
            Option x$214 = this.checkError$default$3();
            boolean x$215 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$216 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$211, "ALL_PARTITION_COLUMNS_NOT_ALLOWED", x$214, x$213, x$215, x$216);
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3333));
        this.test("SPARK-43359: Delete table not allowed", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tbl = "t1";
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tbl}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                AnalysisException e;
                this.sql().apply((Object)("CREATE TABLE " + tbl + "(c1 INT)"));
                AnalysisException x$217 = e = (AnalysisException)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("DELETE FROM " + tbl + " WHERE c1 = 1")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3347));
                String x$218 = "UNSUPPORTED_FEATURE.TABLE_OPERATION";
                Map x$219 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)("`" + CatalogManager$.MODULE$.SESSION_CATALOG_NAME() + "`.`default`.`" + tbl + "`")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"DELETE")}));
                Option x$220 = this.checkError$default$3();
                boolean x$221 = this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$222 = this.checkError$default$6();
                this.checkError((SparkThrowable)x$217, "UNSUPPORTED_FEATURE.TABLE_OPERATION", x$220, x$219, x$221, x$222);
            });
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3343));
        this.test("SPARK-47101: comma is allowed in column name", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tbl = "t1";
            this.withTable((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tbl}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)"CREATE TABLE t1 STORED AS parquet SELECT id as `a,b` FROM range(1)");
                this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"SELECT * FROM t1"), Row$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})));
            });
        }, new Position("HiveDDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3359));
        Statics.releaseFence();
    }

    public static final /* synthetic */ Object $anonfun$checkCreateTableLike$1$adapted(scala.collection.immutable.Seq metastoreGeneratedProperties$1, Tuple2 x0$1) {
        return BoxesRunTime.boxToBoolean((boolean)HiveDDLSuite.$anonfun$checkCreateTableLike$1(metastoreGeneratedProperties$1, x0$1));
    }

    public static final /* synthetic */ Object $anonfun$new$413$adapted(HiveDDLSuite $this, scala.collection.immutable.Seq allowSerdeFileFormats$1, SessionCatalog catalog$12, String sourceTable) {
        HiveDDLSuite.$anonfun$new$413($this, allowSerdeFileFormats$1, catalog$12, sourceTable);
        return BoxedUnit.UNIT;
    }
}

