/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import java.io.Serializable;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUpper;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.connector.catalog.CatalogManager$;
import org.apache.spark.sql.execution.SQLViewSuite;
import org.apache.spark.sql.hive.HiveExternalCatalog;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.execution.HiveSQLViewSuite$;
import org.apache.spark.sql.hive.test.TestHiveContext;
import org.apache.spark.sql.hive.test.TestHiveSingleton;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.tags.SlowHiveTest;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@SlowHiveTest
@ScalaSignature(bytes="\u0006\u0005u2Aa\u0001\u0003\u0001#!)Q\u0004\u0001C\u0001=!)\u0011\u0005\u0001C\u0005E\t\u0001\u0002*\u001b<f'Fce+[3x'VLG/\u001a\u0006\u0003\u000b\u0019\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\u001dA\u0011\u0001\u00025jm\u0016T!!\u0003\u0006\u0002\u0007M\fHN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\n\u0018!\t\u0019R#D\u0001\u0015\u0015\t)\u0001\"\u0003\u0002\u0017)\ta1+\u0015'WS\u0016<8+^5uKB\u0011\u0001dG\u0007\u00023)\u0011!DB\u0001\u0005i\u0016\u001cH/\u0003\u0002\u001d3\t\tB+Z:u\u0011&4XmU5oO2,Go\u001c8\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u0011\u0001\u001b\u0005!\u0011AE2sK\u0006$XMU1x\u0011&4X\rV1cY\u0016$\"aI\u0015\u0011\u0005\u0011:S\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\tUs\u0017\u000e\u001e\u0005\u0006U\t\u0001\raK\u0001\u0004I\u0012d\u0007C\u0001\u00174\u001d\ti\u0013\u0007\u0005\u0002/K5\tqF\u0003\u00021!\u00051AH]8pizJ!AM\u0013\u0002\rA\u0013X\rZ3g\u0013\t!TG\u0001\u0004TiJLgn\u001a\u0006\u0003e\u0015B#\u0001A\u001c\u0011\u0005aZT\"A\u001d\u000b\u0005iR\u0011\u0001\u0002;bONL!\u0001P\u001d\u0003\u0019Mcwn\u001e%jm\u0016$Vm\u001d;")
public class HiveSQLViewSuite
extends SQLViewSuite
implements TestHiveSingleton {
    private boolean enableAutoThreadAudit;
    private SparkSession spark;
    private TestHiveContext hiveContext;
    private HiveClient hiveClient;

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public void afterAll() {
        TestHiveSingleton.afterAll$(this);
    }

    @Override
    public void afterEach() {
        TestHiveSingleton.afterEach$(this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public TestHiveContext hiveContext() {
        return this.hiveContext;
    }

    @Override
    public HiveClient hiveClient() {
        return this.hiveClient;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveContext_$eq(TestHiveContext x$1) {
        this.hiveContext = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveClient_$eq(HiveClient x$1) {
        this.hiveClient = x$1;
    }

    private void createRawHiveTable(String ddl) {
        ((HiveExternalCatalog)this.hiveContext().sharedState().externalCatalog().unwrapped()).client().runSqlHive(ddl);
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$4(int i) {
        return new Tuple2((Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)), (Object)BoxesRunTime.boxToInteger((int)i));
    }

    public static final /* synthetic */ String $anonfun$new$13(int i) {
        return String.valueOf(BoxesRunTime.boxToInteger((int)i));
    }

    public HiveSQLViewSuite() {
        TestHiveSingleton.$init$(this);
        this.test("create a permanent/temp view using a hive, built-in, and permanent user function", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String permanentFuncName = "myUpper";
            String permanentFuncClass = GenericUDFUpper.class.getCanonicalName();
            String builtInFuncNameInLowerCase = "abs";
            String builtInFuncNameInMixedCase = "aBs";
            String hiveFuncName = "histogram_numeric";
            this.withUserDefinedFunction((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)permanentFuncName), (Object)BoxesRunTime.boxToBoolean((boolean)false))}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE FUNCTION " + permanentFuncName + " AS '" + permanentFuncClass + "'"));
                this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tab1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(HiveSQLViewSuite.class.getClassLoader());
                    public final class Org_apache_spark_sql_hive_execution_HiveSQLViewSuite$$typecreator10$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                        }

                        public Org_apache_spark_sql_hive_execution_HiveSQLViewSuite$$typecreator10$1(HiveSQLViewSuite $outer) {
                        }
                    }
                    this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)i -> HiveSQLViewSuite.$anonfun$new$4(BoxesRunTime.unboxToInt((Object)i))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveSQLViewSuite$$typecreator10$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"str", "id"})).write().saveAsTable("tab1");
                    new .colon.colon((Object)"VIEW", (List)new .colon.colon((Object)"TEMPORARY VIEW", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)viewMode -> {
                        this.withView((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"view1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                            $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                 |CREATE " + viewMode + " view1\n                 |AS SELECT\n                 |" + permanentFuncName$1 + "(str) as myUpper,\n                 |" + builtInFuncNameInLowerCase$1 + "(id) as abs_lower,\n                 |" + builtInFuncNameInMixedCase$1 + "(id) as abs_mixed,\n                 |" + hiveFuncName$1 + "(id, 5) over() as func\n                 |FROM tab1\n               ")));
                            $this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)$this.sql().apply((Object)"select count(*) FROM view1"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10)})));
                        });
                        return BoxedUnit.UNIT;
                    });
                });
            });
        }, new Position("HiveSQLViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        this.test("create a permanent/temp view using a temporary function", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tempFunctionName = "temp";
            String functionClass = GenericUDFUpper.class.getCanonicalName();
            this.withUserDefinedFunction((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tempFunctionName), (Object)BoxesRunTime.boxToBoolean((boolean)true))}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)("CREATE TEMPORARY FUNCTION " + tempFunctionName + " AS '" + functionClass + "'"));
                this.withView((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"view1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tempView1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tab1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    AnalysisException e;
                    this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)i -> HiveSQLViewSuite.$anonfun$new$13(BoxesRunTime.unboxToInt((Object)i))), this.testImplicits().newStringEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"})).write().saveAsTable("tab1");
                    this.sql().apply((Object)("CREATE TEMPORARY VIEW tempView1 AS SELECT " + tempFunctionName + "(id) from tab1"));
                    this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"select count(*) FROM tempView1"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10)})));
                    AnalysisException x$1 = e = (AnalysisException)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)("CREATE VIEW view1 AS SELECT " + tempFunctionName + "(id) from tab1")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveSQLViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
                    String x$2 = "INVALID_TEMP_OBJ_REFERENCE";
                    Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"obj"), (Object)"VIEW"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objName"), (Object)("`" + CatalogManager$.MODULE$.SESSION_CATALOG_NAME() + "`.`default`.`view1`")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tempObj"), (Object)"FUNCTION"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tempObjName"), (Object)("`" + tempFunctionName + "`"))}));
                    Option x$4 = this.checkError$default$3();
                    boolean x$5 = this.checkError$default$5();
                    SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
                    this.checkError((SparkThrowable)x$1, "INVALID_TEMP_OBJ_REFERENCE", x$4, x$3, x$5, x$6);
                })));
            });
        }, new Position("HiveSQLViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("SPARK-14933 - create view from hive parquet table", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t_part"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withView((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v_part"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().sql("create table t_part stored as parquet as select 1 as a, 2 as b");
            this.spark().sql("create view v_part as select * from t_part");
            this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"select * from t_part"), (Dataset)this.sql().apply((Object)"select * from v_part"));
        })), new Position("HiveSQLViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        this.test("SPARK-14933 - create view from hive orc table", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t_orc"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withView((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v_orc"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().sql("create table t_orc stored as orc as select 1 as a, 2 as b");
            this.spark().sql("create view v_orc as select * from t_orc");
            this.checkAnswer((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"select * from t_orc"), (Dataset)this.sql().apply((Object)"select * from v_orc"));
        })), new Position("HiveSQLViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        this.test("make sure we can resolve view created by old version of Spark", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hive_table"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withView((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"old_view"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().sql("CREATE TABLE hive_table AS SELECT 1 AS a, 2 AS b");
            TableIdentifier x$7 = TableIdentifier$.MODULE$.apply("old_view");
            CatalogTableType x$8 = CatalogTableType$.MODULE$.VIEW();
            CatalogStorageFormat x$9 = CatalogStorageFormat$.MODULE$.empty();
            StructType x$10 = new StructType().add("a", "int").add("b", "int");
            Some x$11 = new Some((Object)"SELECT `gen_attr_0` AS `a`, `gen_attr_1` AS `b` FROM (SELECT `gen_attr_0`, `gen_attr_1` FROM (SELECT `a` AS `gen_attr_0`, `b` AS `gen_attr_1` FROM hive_table) AS gen_subquery_0) AS hive_table");
            Option x$12 = CatalogTable$.MODULE$.apply$default$5();
            Seq x$13 = CatalogTable$.MODULE$.apply$default$6();
            Option x$14 = CatalogTable$.MODULE$.apply$default$7();
            String x$15 = CatalogTable$.MODULE$.apply$default$8();
            long x$16 = CatalogTable$.MODULE$.apply$default$9();
            long x$17 = CatalogTable$.MODULE$.apply$default$10();
            String x$18 = CatalogTable$.MODULE$.apply$default$11();
            Map x$19 = CatalogTable$.MODULE$.apply$default$12();
            Option x$20 = CatalogTable$.MODULE$.apply$default$13();
            Option x$21 = CatalogTable$.MODULE$.apply$default$15();
            Option x$22 = CatalogTable$.MODULE$.apply$default$16();
            Seq x$23 = CatalogTable$.MODULE$.apply$default$17();
            boolean x$24 = CatalogTable$.MODULE$.apply$default$18();
            boolean x$25 = CatalogTable$.MODULE$.apply$default$19();
            Map x$26 = CatalogTable$.MODULE$.apply$default$20();
            Option x$27 = CatalogTable$.MODULE$.apply$default$21();
            CatalogTable view = new CatalogTable(x$7, x$8, x$9, x$10, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, (Option)x$11, x$21, x$22, x$23, x$24, x$25, x$26, x$27);
            SessionCatalog qual$1 = this.hiveContext().sessionState().catalog();
            CatalogTable x$28 = view;
            boolean x$29 = false;
            boolean x$30 = qual$1.createTable$default$3();
            qual$1.createTable(x$28, false, x$30);
            org.apache.spark.sql.classic.Dataset df = (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"SELECT * FROM old_view");
            this.checkAnswer((Function0 & Serializable)() -> df, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(DataTypeUtils$.MODULE$.sameType((DataType)df.schema(), (DataType)view.schema()), "org.apache.spark.sql.catalyst.types.DataTypeUtils.sameType(df.schema, view.schema)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSQLViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        })), new Position("HiveSQLViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
        this.test("SPARK-20680: Add HiveVoidType to compatible with Hive void type", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withView((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)"create view v1 as select null as c");
            org.apache.spark.sql.classic.Dataset df = (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"select * from v1");
            DataType $org_scalatest_assert_macro_left = ((StructField)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])df.schema().fields()))).dataType();
            NullType$ $org_scalatest_assert_macro_right = NullType$.MODULE$;
            DataType dataType = $org_scalatest_assert_macro_left;
            NullType$ nullType$ = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(nullType$) : nullType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSQLViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
            this.checkAnswer((Function0 & Serializable)() -> df, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})));
            this.sql().apply((Object)"alter view v1 as select null as c1, 1 as c2");
            org.apache.spark.sql.classic.Dataset df2 = (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"select * from v1");
            DataType $org_scalatest_assert_macro_left2 = ((StructField)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])df2.schema().fields()))).dataType();
            NullType$ $org_scalatest_assert_macro_right2 = NullType$.MODULE$;
            DataType dataType2 = $org_scalatest_assert_macro_left2;
            NullType$ nullType$2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType2 != null ? !dataType2.equals(nullType$2) : nullType$2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSQLViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
            this.checkAnswer((Function0 & Serializable)() -> df2, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)1)})));
        }), new Position("HiveSQLViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        this.test("SPARK-35792: ignore optimization configs used in RelationConversions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t_orc"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withView((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v_orc"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.withSQLConf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_ORC().key()), (Object)"true")}), (Function0 & Serializable)() -> {
                this.spark().sql("create table t_orc stored as orc as select 1 as a, 2 as b");
                return this.spark().sql("create view v_orc as select * from t_orc");
            });
            this.withSQLConf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_ORC().key()), (Object)"false")}), (Function0 & Serializable)() -> {
                Option relationInTable = ((org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"select * from t_orc")).queryExecution().analyzed().collect((PartialFunction)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof HiveTableRelation) {
                            HiveTableRelation hiveTableRelation = (HiveTableRelation)A1;
                            return (B1)hiveTableRelation;
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(LogicalPlan x1) {
                        LogicalPlan logicalPlan = x1;
                        return logicalPlan instanceof HiveTableRelation;
                    }
                }).headOption();
                Option relationInView = ((org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"select * from v_orc")).queryExecution().analyzed().collect((PartialFunction)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        A1 A1 = x2;
                        if (A1 instanceof HiveTableRelation) {
                            HiveTableRelation hiveTableRelation = (HiveTableRelation)A1;
                            return (B1)hiveTableRelation;
                        }
                        return (B1)function1.apply(x2);
                    }

                    public final boolean isDefinedAt(LogicalPlan x2) {
                        LogicalPlan logicalPlan = x2;
                        return logicalPlan instanceof HiveTableRelation;
                    }
                }).headOption();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(relationInTable.isDefined(), "relationInTable.isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSQLViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(relationInView.isDefined(), "relationInView.isDefined", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSQLViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
            });
        })), new Position("HiveSQLViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
        this.test("hive partitioned view is not supported", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withView((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"v1"}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |CREATE TABLE test (c1 INT, c2 STRING)\n             |PARTITIONED BY (\n             |  p1 BIGINT COMMENT 'bla',\n             |  p2 STRING )\n           ")));
            this.createRawHiveTable(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |CREATE VIEW v1\n             |PARTITIONED ON (p1, p2)\n             |AS SELECT * from test\n           ")));
            this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"SHOW CREATE TABLE v1"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveSQLViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213)), "UNSUPPORTED_SHOW_CREATE_TABLE.WITH_UNSUPPORTED_FEATURE", "0A000", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)("`" + CatalogManager$.MODULE$.SESSION_CATALOG_NAME() + "`.`default`.`v1`")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unsupportedFeatures"), (Object)" - partitioned view")})));
            this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (org.apache.spark.sql.classic.Dataset)this.sql().apply((Object)"SHOW CREATE TABLE v1 AS SERDE"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveSQLViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224)), "UNSUPPORTED_SHOW_CREATE_TABLE.WITH_UNSUPPORTED_FEATURE", "0A000", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)("`" + CatalogManager$.MODULE$.SESSION_CATALOG_NAME() + "`.`default`.`v1`")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unsupportedFeatures"), (Object)" - partitioned view")})));
        })), new Position("HiveSQLViewSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        Statics.releaseFence();
    }
}

