/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.orc;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkConf;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalog.Catalog;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.hive.orc.OrcFileFormat;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

public final class OrcReadBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark {
    public static final OrcReadBenchmark$ MODULE$ = new OrcReadBenchmark$();
    private static final String NATIVE_ORC_FORMAT;
    private static final String HIVE_ORC_FORMAT;
    private static SparkSession spark;
    private static String sparkHome;
    private static volatile boolean bitmap$0;

    static {
        SQLConfHelper.$init$((SQLConfHelper)MODULE$);
        SQLHelper.$init$((SQLHelper)MODULE$);
        SqlBasedBenchmark.$init$((SqlBasedBenchmark)MODULE$);
        NATIVE_ORC_FORMAT = org.apache.spark.sql.execution.datasources.orc.OrcFileFormat.class.getCanonicalName();
        HIVE_ORC_FORMAT = OrcFileFormat.class.getCanonicalName();
    }

    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$((SqlBasedBenchmark)this, (String)name, (long)cardinality, f);
    }

    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$((SqlBasedBenchmark)this, ds);
    }

    public void prepareDataInfo(Benchmark benchmark) {
        SqlBasedBenchmark.prepareDataInfo$((SqlBasedBenchmark)this, (Benchmark)benchmark);
    }

    public StructType writeWideRow(String path, int rowsNum, int numCols) {
        return SqlBasedBenchmark.writeWideRow$((SqlBasedBenchmark)this, (String)path, (int)rowsNum, (int)numCols);
    }

    public void afterAll() {
        SqlBasedBenchmark.afterAll$((SqlBasedBenchmark)this);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    public SparkSession spark() {
        return spark;
    }

    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        spark = x$1;
    }

    private String sparkHome$lzycompute() {
        OrcReadBenchmark$ orcReadBenchmark$ = this;
        synchronized (orcReadBenchmark$) {
            if (!bitmap$0) {
                sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                bitmap$0 = true;
            }
        }
        return sparkHome;
    }

    public String sparkHome() {
        if (!bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return sparkHome;
    }

    public SparkSession getSparkSession() {
        SparkConf conf = new SparkConf();
        SparkSession sparkSession = SparkSession$.MODULE$.builder().master("local[1]").appName("OrcReadBenchmark").config(conf).getOrCreate();
        sparkSession.conf().set(SQLConf$.MODULE$.ORC_FILTER_PUSHDOWN_ENABLED().key(), "true");
        return sparkSession;
    }

    public void withTempTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        try {
            f.apply$mcV$sp();
        }
        finally {
            Catalog catalog = this.spark().catalog();
            tableNames.foreach((Function1 & Serializable)viewName -> BoxesRunTime.boxToBoolean((boolean)catalog.dropTempView(viewName)));
        }
    }

    private String NATIVE_ORC_FORMAT() {
        return NATIVE_ORC_FORMAT;
    }

    private String HIVE_ORC_FORMAT() {
        return HIVE_ORC_FORMAT;
    }

    private void prepareTable(File dir, Dataset<Row> df, Option<String> partition) {
        String dirORC = dir.getCanonicalPath();
        if (partition.isDefined()) {
            df.write().partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)partition.get()})).orc(dirORC);
        } else {
            df.write().orc(dirORC);
        }
        this.spark().read().format(this.NATIVE_ORC_FORMAT()).load(dirORC).createOrReplaceTempView("nativeOrcTable");
        this.spark().read().format(this.HIVE_ORC_FORMAT()).load(dirORC).createOrReplaceTempView("hiveOrcTable");
    }

    private Option<String> prepareTable$default$3() {
        return None$.MODULE$;
    }

    private String getExpr(DataType dataType) {
        DataType dataType2 = dataType;
        if (ByteType$.MODULE$.equals(dataType2)) {
            return "cast(value % 128 as byte)";
        }
        if (ShortType$.MODULE$.equals(dataType2)) {
            return "cast(value % 32768 as short)";
        }
        return "cast(value % " + Integer.MAX_VALUE + " as " + dataType.sql() + ")";
    }

    private DataType getExpr$default$1() {
        return IntegerType$.MODULE$;
    }

    public void numericScanBenchmark(int values, DataType dataType) {
        String x$1 = "SQL Single " + dataType.sql() + " Column Scan";
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            OrcReadBenchmark$.MODULE$.withTempTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "nativeOrcTable", "hiveOrcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                OrcReadBenchmark$.MODULE$.spark().range((long)values$1).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), OrcReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                OrcReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)OrcReadBenchmark$.MODULE$.spark().sql("SELECT " + OrcReadBenchmark$.MODULE$.getExpr(dataType$1) + " id FROM t1"), OrcReadBenchmark$.MODULE$.prepareTable$default$3());
                benchmark$1.addCase("Hive built-in ORC", benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM hiveOrcTable")).noop());
                benchmark$1.addCase("Native ORC MR", benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM nativeOrcTable")).noop()));
                benchmark$1.addCase("Native ORC Vectorized", benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM nativeOrcTable")).noop());
                benchmark$1.run(benchmark$1.run$default$1());
            });
            return BoxedUnit.UNIT;
        });
    }

    public void intStringScanBenchmark(int values) {
        String x$1 = "Int and String Scan";
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("Int and String Scan", x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            OrcReadBenchmark$.MODULE$.withTempTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "nativeOrcTable", "hiveOrcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                OrcReadBenchmark$.MODULE$.spark().range((long)values$2).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), OrcReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                OrcReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)OrcReadBenchmark$.MODULE$.spark().sql("SELECT " + OrcReadBenchmark$.MODULE$.getExpr(OrcReadBenchmark$.MODULE$.getExpr$default$1()) + " AS c1, CAST(value as STRING) AS c2 FROM t1"), OrcReadBenchmark$.MODULE$.prepareTable$default$3());
                benchmark$2.addCase("Hive built-in ORC", benchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(c1), sum(length(c2)) FROM hiveOrcTable")).noop());
                benchmark$2.addCase("Native ORC MR", benchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$7 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(c1), sum(length(c2)) FROM nativeOrcTable")).noop()));
                benchmark$2.addCase("Native ORC Vectorized", benchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$8 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(c1), sum(length(c2)) FROM nativeOrcTable")).noop());
                benchmark$2.run(benchmark$2.run$default$1());
            });
            return BoxedUnit.UNIT;
        });
    }

    public void partitionTableScanBenchmark(int values) {
        String x$1 = "Partitioned Table";
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("Partitioned Table", x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            OrcReadBenchmark$.MODULE$.withTempTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "nativeOrcTable", "hiveOrcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                OrcReadBenchmark$.MODULE$.spark().range((long)values$3).map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), OrcReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                OrcReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)OrcReadBenchmark$.MODULE$.spark().sql("SELECT value % 2 AS p, " + OrcReadBenchmark$.MODULE$.getExpr(OrcReadBenchmark$.MODULE$.getExpr$default$1()) + " AS id FROM t1"), (Option<String>)new Some((Object)"p"));
                benchmark$3.addCase("Data column - Hive built-in ORC", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$10 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM hiveOrcTable")).noop());
                benchmark$3.addCase("Data column - Native ORC MR", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$11 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM nativeOrcTable")).noop()));
                benchmark$3.addCase("Data column - Native ORC Vectorized", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$12 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM nativeOrcTable")).noop());
                benchmark$3.addCase("Partition column - Hive built-in ORC", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$13 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(p) FROM hiveOrcTable")).noop());
                benchmark$3.addCase("Partition column - Native ORC MR", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$14 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(p) FROM nativeOrcTable")).noop()));
                benchmark$3.addCase("Partition column - Native ORC Vectorized", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$15 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(p) FROM nativeOrcTable")).noop());
                benchmark$3.addCase("Both columns - Hive built-in ORC", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$16 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(p), sum(id) FROM hiveOrcTable")).noop());
                benchmark$3.addCase("Both columns - Native ORC MR", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$17 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(p), sum(id) FROM nativeOrcTable")).noop()));
                benchmark$3.addCase("Both columns - Native ORC Vectorized", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$18 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(p), sum(id) FROM nativeOrcTable")).noop());
                benchmark$3.run(benchmark$3.run$default$1());
            });
            return BoxedUnit.UNIT;
        });
    }

    public void repeatedStringScanBenchmark(int values) {
        String x$1 = "Repeated String";
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("Repeated String", x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            OrcReadBenchmark$.MODULE$.withTempTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "nativeOrcTable", "hiveOrcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                OrcReadBenchmark$.MODULE$.spark().range((long)values$4).createOrReplaceTempView("t1");
                OrcReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)OrcReadBenchmark$.MODULE$.spark().sql("SELECT CAST((id % 200) + 10000 as STRING) AS c1 FROM t1"), OrcReadBenchmark$.MODULE$.prepareTable$default$3());
                benchmark$4.addCase("Hive built-in ORC", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$19 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(length(c1)) FROM hiveOrcTable")).noop());
                benchmark$4.addCase("Native ORC MR", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$20 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(length(c1)) FROM nativeOrcTable")).noop()));
                benchmark$4.addCase("Native ORC Vectorized", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$21 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(length(c1)) FROM nativeOrcTable")).noop());
                benchmark$4.run(benchmark$4.run$default$1());
            });
            return BoxedUnit.UNIT;
        });
    }

    public void stringWithNullsScanBenchmark(int values, double fractionOfNulls) {
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            OrcReadBenchmark$.MODULE$.withTempTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "nativeOrcTable", "hiveOrcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                OrcReadBenchmark$.MODULE$.spark().range((long)values$5).createOrReplaceTempView("t1");
                OrcReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)OrcReadBenchmark$.MODULE$.spark().sql("SELECT IF(RAND(1) < " + fractionOfNulls$1 + ", NULL, CAST(id as STRING)) AS c1, IF(RAND(2) < " + fractionOfNulls$1 + ", NULL, CAST(id as STRING)) AS c2 FROM t1"), OrcReadBenchmark$.MODULE$.prepareTable$default$3());
                double percentageOfNulls = fractionOfNulls$1 * (double)100;
                String x$1 = "String with Nulls Scan (" + percentageOfNulls + "%)";
                long x$2 = values$5;
                Option x$3 = OrcReadBenchmark$.MODULE$.output();
                int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
                FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
                FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
                boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
                Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
                benchmark.addCase("Hive built-in ORC", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$22 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT SUM(LENGTH(c2)) FROM hiveOrcTable WHERE c1 IS NOT NULL AND c2 IS NOT NULL")).noop());
                benchmark.addCase("Native ORC MR", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$23 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT SUM(LENGTH(c2)) FROM nativeOrcTable WHERE c1 IS NOT NULL AND c2 IS NOT NULL")).noop()));
                benchmark.addCase("Native ORC Vectorized", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$24 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT SUM(LENGTH(c2)) FROM nativeOrcTable WHERE c1 IS NOT NULL AND c2 IS NOT NULL")).noop());
                benchmark.run(benchmark.run$default$1());
            });
            return BoxedUnit.UNIT;
        });
    }

    public void columnsBenchmark(int values, int width) {
        String x$1 = "Single Column Scan from " + width + " columns";
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            OrcReadBenchmark$.MODULE$.withTempTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "nativeOrcTable", "hiveOrcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                int middle = width$1 / 2;
                IndexedSeq selectExpr = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), width$1).map((Function1 & Serializable)i -> OrcReadBenchmark$.$anonfun$columnsBenchmark$3(BoxesRunTime.unboxToInt((Object)i)));
                OrcReadBenchmark$.MODULE$.spark().range((long)values$6).map((Function1 & Serializable)x$25 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), OrcReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).toDF().selectExpr((Seq)selectExpr).createOrReplaceTempView("t1");
                OrcReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)OrcReadBenchmark$.MODULE$.spark().sql("SELECT * FROM t1"), OrcReadBenchmark$.MODULE$.prepareTable$default$3());
                benchmark$5.addCase("Hive built-in ORC", benchmark$5.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$26 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(c" + middle + ") FROM hiveOrcTable")).noop());
                benchmark$5.addCase("Native ORC MR", benchmark$5.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$27 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(c" + middle + ") FROM nativeOrcTable")).noop()));
                benchmark$5.addCase("Native ORC Vectorized", benchmark$5.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$28 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(c" + middle + ") FROM nativeOrcTable")).noop());
                benchmark$5.run(benchmark$5.run$default$1());
            });
            return BoxedUnit.UNIT;
        });
    }

    public void structBenchmark(int values, int width) {
        String x$1 = "Single Struct Column Scan with " + width + " Fields";
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            OrcReadBenchmark$.MODULE$.withTempTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "nativeOrcTable", "hiveOrcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                String selectExprCore = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), width$2).map((Function1 & Serializable)i -> OrcReadBenchmark$.$anonfun$structBenchmark$3(BoxesRunTime.unboxToInt((Object)i))).mkString(",");
                .colon.colon selectExpr = new .colon.colon((Object)("named_struct(" + selectExprCore + ") as c1"), (List)Nil$.MODULE$);
                OrcReadBenchmark$.MODULE$.spark().range((long)values$7).map((Function1 & Serializable)x$29 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), OrcReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).toDF().selectExpr((Seq)selectExpr).createOrReplaceTempView("t1");
                OrcReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)OrcReadBenchmark$.MODULE$.spark().sql("SELECT * FROM t1"), OrcReadBenchmark$.MODULE$.prepareTable$default$3());
                benchmark$6.addCase("Hive built-in ORC", benchmark$6.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$30 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT * FROM hiveOrcTable")).noop());
                benchmark$6.addCase("Native ORC MR", benchmark$6.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$31 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT * FROM nativeOrcTable")).noop()));
                benchmark$6.addCase("Native ORC Vectorized", benchmark$6.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$32 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_NESTED_COLUMN_ENABLED().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT * FROM nativeOrcTable")).noop()));
                benchmark$6.run(benchmark$6.run$default$1());
            });
            return BoxedUnit.UNIT;
        });
    }

    public void nestedStructBenchmark(int values, int elementCount, int structWidth) {
        String x$1 = "Nested Struct Scan with " + elementCount + " Elements, " + structWidth + " Fields";
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            OrcReadBenchmark$.MODULE$.withTempTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "nativeOrcTable", "hiveOrcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                String structExprFields = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), structWidth$1).map((Function1 & Serializable)i -> OrcReadBenchmark$.$anonfun$nestedStructBenchmark$3(BoxesRunTime.unboxToInt((Object)i))).mkString(",");
                String structExpr = "named_struct(" + structExprFields + ")";
                String arrayExprElements = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), elementCount$1).map((Function1 & Serializable)x$33 -> OrcReadBenchmark$.$anonfun$nestedStructBenchmark$4(structExpr, BoxesRunTime.unboxToInt((Object)x$33))).mkString(",");
                .colon.colon selectExpr = new .colon.colon((Object)("array(" + arrayExprElements + ") as c1"), (List)Nil$.MODULE$);
                Predef$.MODULE$.print((Object)("select expression is " + (Seq)selectExpr + "\n"));
                OrcReadBenchmark$.MODULE$.spark().range((long)values$8).map((Function1 & Serializable)x$34 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), OrcReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).toDF().selectExpr((Seq)selectExpr).createOrReplaceTempView("t1");
                OrcReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)OrcReadBenchmark$.MODULE$.spark().sql("SELECT * FROM t1"), OrcReadBenchmark$.MODULE$.prepareTable$default$3());
                benchmark$7.addCase("Hive built-in ORC", benchmark$7.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$35 -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT * FROM hiveOrcTable")).noop());
                benchmark$7.addCase("Native ORC MR", benchmark$7.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$36 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT * FROM nativeOrcTable")).noop()));
                benchmark$7.addCase("Native ORC Vectorized", benchmark$7.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$37 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_NESTED_COLUMN_ENABLED().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> OrcReadBenchmark$.MODULE$.DatasetToBenchmark(OrcReadBenchmark$.MODULE$.spark().sql("SELECT * FROM nativeOrcTable")).noop()));
                benchmark$7.run(benchmark$7.run$default$1());
            });
            return BoxedUnit.UNIT;
        });
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.runBenchmark("SQL Single Numeric Column Scan", (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)ByteType$.MODULE$, (List)new .colon.colon((Object)ShortType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)LongType$.MODULE$, (List)new .colon.colon((Object)FloatType$.MODULE$, (List)new .colon.colon((Object)DoubleType$.MODULE$, (List)Nil$.MODULE$)))))).foreach((Function1 & Serializable)dataType -> {
            OrcReadBenchmark$.MODULE$.numericScanBenchmark(0xF00000, (DataType)dataType);
            return BoxedUnit.UNIT;
        }));
        this.runBenchmark("Int and String Scan", (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.intStringScanBenchmark(0xA00000));
        this.runBenchmark("Partitioned Table Scan", (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.partitionTableScanBenchmark(0xF00000));
        this.runBenchmark("Repeated String Scan", (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.repeatedStringScanBenchmark(0xA00000));
        this.runBenchmark("String with Nulls Scan", (Function0)(JFunction0.mcV.sp & Serializable)() -> ((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.5, 0.95}))).foreach((Function1)(JFunction1.mcVD.sp & Serializable)fractionOfNulls -> MODULE$.stringWithNullsScanBenchmark(0xA00000, fractionOfNulls)));
        this.runBenchmark("Single Column Scan From Wide Columns", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            MODULE$.columnsBenchmark(0x100000, 100);
            MODULE$.columnsBenchmark(0x100000, 200);
            MODULE$.columnsBenchmark(0x100000, 300);
        });
        this.runBenchmark("Struct scan", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            MODULE$.structBenchmark(0x100000, 10);
            MODULE$.structBenchmark(0x100000, 100);
            MODULE$.structBenchmark(0x100000, 300);
            MODULE$.structBenchmark(0x100000, 600);
        });
        this.runBenchmark("Nested Struct scan", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            MODULE$.nestedStructBenchmark(0x100000, 10, 10);
            MODULE$.nestedStructBenchmark(0x100000, 30, 10);
            MODULE$.nestedStructBenchmark(0x100000, 10, 30);
        });
    }

    public static final /* synthetic */ String $anonfun$columnsBenchmark$3(int i) {
        return MODULE$.getExpr(MODULE$.getExpr$default$1()) + " as c" + i;
    }

    public static final /* synthetic */ String $anonfun$structBenchmark$3(int i) {
        return "'f" + i + "', value";
    }

    public static final /* synthetic */ String $anonfun$nestedStructBenchmark$3(int i) {
        return "'f" + i + "', value";
    }

    public static final /* synthetic */ String $anonfun$nestedStructBenchmark$4(String structExpr$1, int x$33) {
        return String.valueOf(structExpr$1);
    }

    private OrcReadBenchmark$() {
    }
}

