/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.client;

import java.io.File;
import java.io.Serializable;
import java.sql.Date;
import java.time.ZoneId;
import java.util.Collections;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.InSet;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.hive.client.Shim_v2_0;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005y4AAC\u0006\u00011!)Q\u0005\u0001C\u0001M!9\u0011\u0006\u0001b\u0001\n\u0013Q\u0003B\u0002\u0018\u0001A\u0003%1\u0006C\u00040\u0001\t\u0007I\u0011\u0002\u0019\t\rq\u0002\u0001\u0015!\u00032\u0011\u001di\u0004A1A\u0005\nyBaa\u0012\u0001!\u0002\u0013y\u0004\"\u0002%\u0001\t\u0013I\u0005\"\u00029\u0001\t\u0013\t(\u0001\u0004$jYR,'o]*vSR,'B\u0001\u0007\u000e\u0003\u0019\u0019G.[3oi*\u0011abD\u0001\u0005Q&4XM\u0003\u0002\u0011#\u0005\u00191/\u001d7\u000b\u0005I\u0019\u0012!B:qCJ\\'B\u0001\u000b\u0016\u0003\u0019\t\u0007/Y2iK*\ta#A\u0002pe\u001e\u001c\u0001aE\u0002\u00013u\u0001\"AG\u000e\u000e\u0003EI!\u0001H\t\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\tq2%D\u0001 \u0015\t\u0001\u0013%A\u0003qY\u0006t7O\u0003\u0002#\u001f\u0005A1-\u0019;bYf\u001cH/\u0003\u0002%?\tA\u0001\u000b\\1o)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002OA\u0011\u0001\u0006A\u0007\u0002\u0017\u0005!1\u000f[5n+\u0005Y\u0003C\u0001\u0015-\u0013\ti3BA\u0005TQ&lwL\u001e\u001a`a\u0005)1\u000f[5nA\u0005IA/Z:u)\u0006\u0014G.Z\u000b\u0002cA\u0011!GO\u0007\u0002g)\u0011A'N\u0001\t[\u0016$\u0018\rZ1uC*\u0011agN\u0001\u0003c2T!A\u0004\u001d\u000b\u0005e\u001a\u0012A\u00025bI>|\u0007/\u0003\u0002<g\t)A+\u00192mK\u0006QA/Z:u)\u0006\u0014G.\u001a\u0011\u0002\u0015Y\f'o\u00115be\u000e{G.F\u0001@!\t\u0001U)D\u0001B\u0015\t\u00115)A\u0002ba&T!\u0001R\u001c\u0002\u00135,G/Y:u_J,\u0017B\u0001$B\u0005-1\u0015.\u001a7e'\u000eDW-\\1\u0002\u0017Y\f'o\u00115be\u000e{G\u000eI\u0001\u000bM&dG/\u001a:UKN$H\u0003\u0002&Q;:\u0004\"a\u0013(\u000e\u00031S\u0011!T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f2\u0013A!\u00168ji\")\u0011\u000b\u0003a\u0001%\u0006!a.Y7f!\t\u0019&L\u0004\u0002U1B\u0011Q\u000bT\u0007\u0002-*\u0011qkF\u0001\u0007yI|w\u000e\u001e \n\u0005ec\u0015A\u0002)sK\u0012,g-\u0003\u0002\\9\n11\u000b\u001e:j]\u001eT!!\u0017'\t\u000byC\u0001\u0019A0\u0002\u000f\u0019LG\u000e^3sgB\u0019\u0001-\u001a5\u000f\u0005\u0005\u001cgBA+c\u0013\u0005i\u0015B\u00013M\u0003\u001d\u0001\u0018mY6bO\u0016L!AZ4\u0003\u0007M+\u0017O\u0003\u0002e\u0019B\u0011\u0011\u000e\\\u0007\u0002U*\u00111.I\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0002nU\nQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u000b=D\u0001\u0019\u0001*\u0002\rI,7/\u001e7u\u0003\u0005\tGc\u0001:vmB\u0011\u0011n]\u0005\u0003i*\u0014!#\u0011;ue&\u0014W\u000f^3SK\u001a,'/\u001a8dK\")\u0011+\u0003a\u0001%\")q/\u0003a\u0001q\u0006AA-\u0019;b)f\u0004X\r\u0005\u0002zy6\t!P\u0003\u0002|\u001f\u0005)A/\u001f9fg&\u0011QP\u001f\u0002\t\t\u0006$\u0018\rV=qK\u0002")
public class FiltersSuite
extends SparkFunSuite
implements PlanTest {
    private final Shim_v2_0 shim;
    private final Table testTable;
    private final FieldSchema varCharCol;
    private String sparkHome;
    private volatile boolean bitmap$0;

    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$((PlanTestBase)this, (LogicalPlan)plan1, (LogicalPlan)plan2, (boolean)checkAnalysis);
    }

    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$((PlanTestBase)this);
    }

    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$((PlanTestBase)this, (Expression)e1, (Expression)e2);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    private String sparkHome$lzycompute() {
        FiltersSuite filtersSuite = this;
        synchronized (filtersSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    private Shim_v2_0 shim() {
        return this.shim;
    }

    private Table testTable() {
        return this.testTable;
    }

    private FieldSchema varCharCol() {
        return this.varCharCol;
    }

    private void filterTest(String name, Seq<Expression> filters, String result) {
        this.test(name, (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ADVANCED_PARTITION_PREDICATE_PUSHDOWN().key()), (Object)"true")}), (Function0 & Serializable)() -> {
            String converted;
            String string = converted = this.shim().convertFilters(this.testTable(), filters);
            String string2 = result;
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw this.fail("Expected " + filters.mkString(",") + " to convert to '" + result + "' but got '" + converted + "'", new Position("FiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
            }
            return BoxedUnit.UNIT;
        }), new Position("FiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
    }

    private AttributeReference a(String name, DataType dataType) {
        String x$1 = name;
        DataType x$2 = dataType;
        boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
        return new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
    }

    public static final /* synthetic */ Assertion $anonfun$new$3(FiltersSuite $this, boolean enabled) {
        return (Assertion)$this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ADVANCED_PARTITION_PREDICATE_PUSHDOWN().key()), (Object)Boolean.toString(enabled))}), (Function0 & Serializable)() -> {
            Predicate predicate = package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$eq$eq$eq((Expression)$this.a("intcol", (DataType)IntegerType$.MODULE$))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))).$eq$eq$eq((Expression)$this.a("intcol", (DataType)IntegerType$.MODULE$)));
            List filters = Nil$.MODULE$.$colon$colon((Object)predicate);
            String converted = $this.shim().convertFilters($this.testTable(), (Seq)filters);
            if (enabled) {
                String $org_scalatest_assert_macro_left = converted;
                String $org_scalatest_assert_macro_right = "(1 = intcol or 2 = intcol)";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
            }
            String $org_scalatest_assert_macro_left = converted;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        });
    }

    private final void checkConverted$1(InSet inSet, String result) {
        InSet inSet2 = inSet;
        String $org_scalatest_assert_macro_left = this.shim().convertFilters(this.testTable(), (Seq)Nil$.MODULE$.$colon$colon((Object)inSet2));
        String $org_scalatest_assert_macro_right = result;
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
    }

    public static final /* synthetic */ Object $anonfun$new$7(int s) {
        return Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)s)).eval(org.apache.spark.sql.catalyst.expressions.package$.MODULE$.EmptyRow());
    }

    public static final /* synthetic */ Object $anonfun$new$8(int s) {
        return Literal$.MODULE$.apply((Object)Integer.toString(s)).eval(org.apache.spark.sql.catalyst.expressions.package$.MODULE$.EmptyRow());
    }

    public static final /* synthetic */ Object $anonfun$new$9(int s) {
        return Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)s)).eval(org.apache.spark.sql.catalyst.expressions.package$.MODULE$.EmptyRow());
    }

    public static final /* synthetic */ Object $anonfun$new$10(int s) {
        return Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)s)).eval(org.apache.spark.sql.catalyst.expressions.package$.MODULE$.EmptyRow());
    }

    public static final /* synthetic */ Object $anonfun$new$11(int d) {
        return new Literal((Object)BoxesRunTime.boxToInteger((int)d), (DataType)DateType$.MODULE$).eval(org.apache.spark.sql.catalyst.expressions.package$.MODULE$.EmptyRow());
    }

    public FiltersSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        SQLHelper.$init$((SQLHelper)this);
        PlanTestBase.$init$((PlanTestBase)this);
        this.shim = new Shim_v2_0();
        this.testTable = new Table("default", "test");
        this.varCharCol = new FieldSchema();
        this.varCharCol().setName("varchar");
        this.varCharCol().setType("varchar");
        this.testTable().setPartCols(Collections.singletonList(this.varCharCol()));
        Predicate predicate = package.expressions$.MODULE$.DslExpression((Expression)this.a("stringcol", (DataType)StringType$.MODULE$)).$greater((Expression)Literal$.MODULE$.apply((Object)"test"));
        this.filterTest("string filter", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)predicate), "stringcol > \"test\"");
        Predicate predicate2 = package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)"test")).$greater((Expression)this.a("stringcol", (DataType)StringType$.MODULE$));
        this.filterTest("string filter backwards", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)predicate2), "\"test\" > stringcol");
        Predicate predicate3 = package.expressions$.MODULE$.DslExpression((Expression)this.a("intcol", (DataType)IntegerType$.MODULE$)).$eq$eq$eq((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)));
        this.filterTest("int filter", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)predicate3), "intcol = 1");
        Predicate predicate4 = package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$eq$eq$eq((Expression)this.a("intcol", (DataType)IntegerType$.MODULE$));
        this.filterTest("int filter backwards", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)predicate4), "1 = intcol");
        Predicate predicate5 = package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$eq$eq$eq((Expression)this.a("intcol", (DataType)IntegerType$.MODULE$));
        Predicate predicate6 = package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)"a")).$eq$eq$eq((Expression)this.a("strcol", (DataType)IntegerType$.MODULE$));
        this.filterTest("int and string filter", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)predicate6).$colon$colon((Object)predicate5), "1 = intcol and \"a\" = strcol");
        Predicate predicate7 = package.expressions$.MODULE$.DslExpression((Expression)this.a("datecol", (DataType)DateType$.MODULE$)).$eq$eq$eq((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-01")));
        this.filterTest("date filter", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)predicate7), "datecol = \"2019-01-01\"");
        Predicate predicate8 = package.expressions$.MODULE$.DslExpression((Expression)this.a("datecol", (DataType)DateType$.MODULE$)).in((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-01")), Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-07"))}));
        this.filterTest("date filter with IN predicate", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)predicate8), "(datecol = \"2019-01-01\" or datecol = \"2019-01-07\")");
        Predicate predicate9 = package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-01"))).$eq$eq$eq((Expression)this.a("datecol", (DataType)DateType$.MODULE$));
        Predicate predicate10 = package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)"a")).$eq$eq$eq((Expression)this.a("strcol", (DataType)IntegerType$.MODULE$));
        this.filterTest("date and string filter", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)predicate10).$colon$colon((Object)predicate9), "\"2019-01-01\" = datecol and \"a\" = strcol");
        Predicate predicate11 = package.expressions$.MODULE$.DslExpression((Expression)this.a("datecol", (DataType)DateType$.MODULE$)).$eq$eq$eq((Expression)Literal$.MODULE$.apply(null));
        this.filterTest("date filter with null", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)predicate11), "");
        InSet inSet = new InSet((Expression)this.a("strcol", (DataType)StringType$.MODULE$), (Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2"}))).map((Function1 & Serializable)s -> UTF8String.fromString((String)s)));
        this.filterTest("string filter with InSet predicate", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)inSet), "(strcol = \"1\" or strcol = \"2\")");
        Predicate predicate12 = package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)"")).$eq$eq$eq((Expression)this.a("varchar", (DataType)StringType$.MODULE$));
        this.filterTest("skip varchar", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)predicate12), "");
        Predicate predicate13 = package.expressions$.MODULE$.DslExpression((Expression)this.a("stringcol", (DataType)StringType$.MODULE$)).$eq$eq$eq((Expression)Literal$.MODULE$.apply((Object)"p1\" and q=\"q1"));
        Predicate predicate14 = package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)"p2\" and q=\"q2")).$eq$eq$eq((Expression)this.a("stringcol", (DataType)StringType$.MODULE$));
        this.filterTest("SPARK-19912 String literals should be escaped for Hive metastore partition pruning", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)predicate14).$colon$colon((Object)predicate13), "stringcol = 'p1\" and q=\"q1' and 'p2\" and q=\"q2' = stringcol");
        Predicate predicate15 = package.expressions$.MODULE$.DslExpression((Expression)this.a("intcol", (DataType)IntegerType$.MODULE$)).in((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Literal$.MODULE$.apply(null)}));
        this.filterTest("SPARK-24879 null literals should be ignored for IN constructs", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)predicate15), "(intcol = 1)");
        Predicate predicate16 = package.expressions$.MODULE$.DslExpression((Expression)this.a("intcol", (DataType)IntegerType$.MODULE$)).$eq$bang$eq((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)));
        Predicate predicate17 = package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)"a")).$eq$bang$eq((Expression)this.a("strcol", (DataType)IntegerType$.MODULE$));
        this.filterTest("NOT: int and string filters", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)predicate17).$colon$colon((Object)predicate16), "intcol != 1 and \"a\" != strcol");
        Predicate predicate18 = package.expressions$.MODULE$.DslExpression((Expression)this.a("datecol", (DataType)DateType$.MODULE$)).$eq$bang$eq((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-01")));
        this.filterTest("NOT: date filter", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)predicate18), "datecol != \"2019-01-01\"");
        Not not = new Not((Expression)new In((Expression)this.a("strcol", (DataType)StringType$.MODULE$), (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"a"), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"b"), (List)Nil$.MODULE$))));
        this.filterTest("not-in, string filter", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)not), "(strcol != \"a\" and strcol != \"b\")");
        Not not2 = new Not((Expression)new In((Expression)this.a("strcol", (DataType)StringType$.MODULE$), (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"a"), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"b"), (List)new .colon.colon((Object)Literal$.MODULE$.apply(null), (List)Nil$.MODULE$)))));
        this.filterTest("not-in, string filter with null", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)not2), "");
        Not not3 = new Not((Expression)new In((Expression)this.a("datecol", (DataType)DateType$.MODULE$), (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)Date.valueOf("2021-01-01")), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)Date.valueOf("2021-01-02")), (List)Nil$.MODULE$))));
        this.filterTest("not-in, date filter", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)not3), "(datecol != \"2021-01-01\" and datecol != \"2021-01-02\")");
        Not not4 = new Not((Expression)new In((Expression)this.a("datecol", (DataType)DateType$.MODULE$), (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)Date.valueOf("2021-01-01")), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)Date.valueOf("2021-01-02")), (List)new .colon.colon((Object)Literal$.MODULE$.apply(null), (List)Nil$.MODULE$)))));
        this.filterTest("not-in, date filter with null", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)not4), "");
        Object[] objectArray = new Object[2];
        Literal qual$1 = Literal$.MODULE$.apply((Object)"a");
        InternalRow x$1 = qual$1.eval$default$1();
        objectArray[0] = qual$1.eval(x$1);
        Literal qual$2 = Literal$.MODULE$.apply((Object)"b");
        InternalRow x$2 = qual$2.eval$default$1();
        objectArray[1] = qual$2.eval(x$2);
        Not not5 = new Not((Expression)new InSet((Expression)this.a("strcol", (DataType)StringType$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray))));
        this.filterTest("not-inset, string filter", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)not5), "(strcol != \"a\" and strcol != \"b\")");
        Object[] objectArray2 = new Object[3];
        Literal qual$3 = Literal$.MODULE$.apply((Object)"a");
        InternalRow x$3 = qual$3.eval$default$1();
        objectArray2[0] = qual$3.eval(x$3);
        Literal qual$4 = Literal$.MODULE$.apply((Object)"b");
        InternalRow x$4 = qual$4.eval$default$1();
        objectArray2[1] = qual$4.eval(x$4);
        Literal qual$5 = Literal$.MODULE$.apply(null);
        InternalRow x$5 = qual$5.eval$default$1();
        objectArray2[2] = qual$5.eval(x$5);
        Not not6 = new Not((Expression)new InSet((Expression)this.a("strcol", (DataType)StringType$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray2))));
        this.filterTest("not-inset, string filter with null", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)not6), "");
        Object[] objectArray3 = new Object[2];
        Literal qual$6 = Literal$.MODULE$.apply((Object)Date.valueOf("2020-01-01"));
        InternalRow x$6 = qual$6.eval$default$1();
        objectArray3[0] = qual$6.eval(x$6);
        Literal qual$7 = Literal$.MODULE$.apply((Object)Date.valueOf("2020-01-02"));
        InternalRow x$7 = qual$7.eval$default$1();
        objectArray3[1] = qual$7.eval(x$7);
        Not not7 = new Not((Expression)new InSet((Expression)this.a("datecol", (DataType)DateType$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray3))));
        this.filterTest("not-inset, date filter", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)not7), "(datecol != \"2020-01-01\" and datecol != \"2020-01-02\")");
        Object[] objectArray4 = new Object[3];
        Literal qual$8 = Literal$.MODULE$.apply((Object)Date.valueOf("2020-01-01"));
        InternalRow x$8 = qual$8.eval$default$1();
        objectArray4[0] = qual$8.eval(x$8);
        Literal qual$9 = Literal$.MODULE$.apply((Object)Date.valueOf("2020-01-02"));
        InternalRow x$9 = qual$9.eval$default$1();
        objectArray4[1] = qual$9.eval(x$9);
        Literal qual$10 = Literal$.MODULE$.apply(null);
        InternalRow x$10 = qual$10.eval$default$1();
        objectArray4[2] = qual$10.eval(x$10);
        Not not8 = new Not((Expression)new InSet((Expression)this.a("datecol", (DataType)DateType$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray4))));
        this.filterTest("not-inset, date filter with null", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)not8), "");
        Predicate predicate19 = package.expressions$.MODULE$.DslExpression((Expression)this.a("intcol", (DataType)IntegerType$.MODULE$)).in((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{Literal$.MODULE$.apply(null)}));
        this.filterTest("SPARK-24879 IN predicates with only NULLs will not cause a NPE", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)predicate19), "");
        Predicate predicate20 = package.expressions$.MODULE$.DslExpression((Expression)this.a("intcol", (DataType)IntegerType$.MODULE$)).$eq$eq$eq((Expression)new Literal(null, (DataType)IntegerType$.MODULE$));
        this.filterTest("typecast null literals should not be pushed down in simple predicates", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)predicate20), "");
        this.test("turn on/off ADVANCED_PARTITION_PREDICATE_PUSHDOWN", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)enabled -> FiltersSuite.$anonfun$new$3(this, BoxesRunTime.unboxToBoolean((Object)enabled))), new Position("FiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
        this.test("SPARK-33416: Avoid Hive metastore stack overflow when InSet predicate have many values", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HIVE_METASTORE_PARTITION_PRUNING_INSET_THRESHOLD().key()), (Object)"15")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkConverted$1(new InSet((Expression)this.a("intcol", (DataType)IntegerType$.MODULE$), package$.MODULE$.Range().apply(1, 20).map((Function1 & Serializable)s -> FiltersSuite.$anonfun$new$7(BoxesRunTime.unboxToInt((Object)s))).toSet()), "(intcol >= 1 and intcol <= 19)");
            this.checkConverted$1(new InSet((Expression)this.a("stringcol", (DataType)StringType$.MODULE$), package$.MODULE$.Range().apply(1, 20).map((Function1 & Serializable)s -> FiltersSuite.$anonfun$new$8(BoxesRunTime.unboxToInt((Object)s))).toSet()), "(stringcol >= \"1\" and stringcol <= \"9\")");
            this.checkConverted$1(new InSet(package.expressions$.MODULE$.DslExpression((Expression)this.a("intcol", (DataType)IntegerType$.MODULE$)).cast((DataType)LongType$.MODULE$), package$.MODULE$.Range().apply(1, 20).map((Function1 & Serializable)s -> FiltersSuite.$anonfun$new$9(BoxesRunTime.unboxToInt((Object)s))).toSet()), "(intcol >= 1 and intcol <= 19)");
            this.checkConverted$1(new InSet((Expression)this.a("doublecol", (DataType)DoubleType$.MODULE$), package$.MODULE$.Range().apply(1, 20).map((Function1 & Serializable)s -> FiltersSuite.$anonfun$new$10(BoxesRunTime.unboxToInt((Object)s))).toSet()), "");
            this.checkConverted$1(new InSet((Expression)this.a("datecol", (DataType)DateType$.MODULE$), package$.MODULE$.Range().apply(1, 20).map((Function1 & Serializable)d -> FiltersSuite.$anonfun$new$11(BoxesRunTime.unboxToInt((Object)d))).toSet()), "(datecol >= \"1970-01-02\" and datecol <= \"1970-01-20\")");
        }), new Position("FiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        this.test("SPARK-34515: Fix NPE if InSet contains null value during getPartitionsByFilter", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HIVE_METASTORE_PARTITION_PRUNING_INSET_THRESHOLD().key()), (Object)"2")}), (Function0 & Serializable)() -> {
            String converted;
            InSet filter = new InSet((Expression)this.a("p", (DataType)IntegerType$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})));
            String $org_scalatest_assert_macro_left = converted = this.shim().convertFilters(this.testTable(), (Seq)new .colon.colon((Object)filter, (List)Nil$.MODULE$));
            String $org_scalatest_assert_macro_right = "(p >= 1 and p <= 2)";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
        }), new Position("FiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
        this.test("Don't push not inset if it's values exceeds the threshold", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HIVE_METASTORE_PARTITION_PRUNING_INSET_THRESHOLD().key()), (Object)"2")}), (Function0 & Serializable)() -> {
            String converted;
            Not filter = new Not((Expression)new InSet((Expression)this.a("p", (DataType)IntegerType$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)}))));
            String $org_scalatest_assert_macro_left = converted = this.shim().convertFilters(this.testTable(), (Seq)new .colon.colon((Object)filter, (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
        }), new Position("FiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
        this.test("SPARK-34538: Skip InSet null value during push filter to Hive metastore", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HIVE_METASTORE_PARTITION_PRUNING_INSET_THRESHOLD().key()), (Object)"3")}), (Function0 & Serializable)() -> {
                String intConverted;
                InSet intFilter = new InSet((Expression)this.a("p", (DataType)IntegerType$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})));
                String $org_scalatest_assert_macro_left = intConverted = this.shim().convertFilters(this.testTable(), (Seq)new .colon.colon((Object)intFilter, (List)Nil$.MODULE$));
                String $org_scalatest_assert_macro_right = "(p = 1 or p = 2)";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
            });
            return (Assertion)this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HIVE_METASTORE_PARTITION_PRUNING_INSET_THRESHOLD().key()), (Object)"3")}), (Function0 & Serializable)() -> {
                String dateConverted;
                Object[] objectArray = new Object[3];
                objectArray[0] = null;
                Literal qual$11 = Literal$.MODULE$.apply((Object)Date.valueOf("2020-01-01"));
                InternalRow x$11 = qual$11.eval$default$1();
                objectArray[1] = qual$11.eval(x$11);
                Literal qual$12 = Literal$.MODULE$.apply((Object)Date.valueOf("2021-01-01"));
                InternalRow x$12 = qual$12.eval$default$1();
                objectArray[2] = qual$12.eval(x$12);
                InSet dateFilter = new InSet((Expression)this.a("p", (DataType)DateType$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray)));
                String $org_scalatest_assert_macro_left = dateConverted = this.shim().convertFilters(this.testTable(), (Seq)new .colon.colon((Object)dateFilter, (List)Nil$.MODULE$));
                String $org_scalatest_assert_macro_right = "(p = \"2020-01-01\" or p = \"2021-01-01\")";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
            });
        }, new Position("FiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
    }
}

